/*****************************************************************************/
/* module sauve.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/textsw.h>
#include <stdio.h>
#include <pixrect/pixrect_hs.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

#define	MIN(A,B)    ((A)<(B)?(A):(B))

extern  Textsw          master;
    
extern	struct	fname	*fname_panel();
extern	struct	frasname *fras_panel();
struct	fname *fn;

extern int write_desc();

extern void hproc_laser_Gnature();
extern void hproc_laser_Gmaximum();
extern void hproc_sauve_unplan();
extern void hproc_sauve_imcart();
extern void hproc_sauve_impol();
extern void hproc_sauve_imrgb();

/*****************************************************************************/
/*									     */
/* nom      : SetUpPS							     */
/*									     */
/* fonction : construit l'entete d'un fichier PostScript pour une image      */
/*                                                                           */
/* entrees  : FILE *fdout	        : fichier de sortie de l'image       */
/*            int x		        : nbr de colonnes de l'image         */
/*	      int y			: nbr de lignes	de l'image	     */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : neant							     */
/*									     */
/*****************************************************************************/

SetUpPS (mode, fdOut,x,y)

    int mode;
    FILE *fdOut;
    int x,y;

{
    int dx, dy;
    double sx, sy, scale;
    double scaledX, scaledY, XX, YY;
    char pcent = '%';

    sx = PAGEWIDTH / (double)(x);
    sy = PAGEHEIGHT/ (double)(y);
    scale = (sx > sy) ? sy:sx;
    scaledX = x*scale;
    scaledY = y*scale;
    fprintf (fdOut, "%c!\n",pcent);
    fprintf (fdOut, "gsave\n");
    fprintf (fdOut, "initgraphics\n");
    fprintf (fdOut, "0.24 0.24 scale\n");
    fprintf (fdOut, "/imline %d string def\n",y);
    fprintf (fdOut, "/drawimage {\n");
    fprintf (fdOut, "    %d %d 8\n",x,y);
    fprintf (fdOut, "    [%d 0 0 %d 0 %d]\n",x,1*y,y);
    fprintf (fdOut, "    { currentfile imline readhexstring pop } image\n");
    fprintf (fdOut, "} def\n");
    if (mode == 0) {	/* grandeur nature */
	XX =  MIN ((int)(scaledX+0.5), (int)((scaledX*x/512)+0.5));
	YY =  MIN ((int)(scaledY+0.5), (int)((scaledY*y/512)+0.5));
	if ((int)XX != (int)(scaledX+0.5) && (int)YY != (int)(scaledY+0.5)){
	    scaledX = XX;
	    scaledY = YY;
	}
    }
    dx = PAGEOFFSETX + (PAGEWIDTH  - scaledX)/2;
    dy = PAGEOFFSETY + (PAGEHEIGHT  - scaledY)/2;
/*
    dy = PAGEHEIGHT - (PAGEOFFSETY + (PAGEHEIGHT - scaledY)/2);
*/
    fprintf (fdOut, "%d %d translate\n",dx,dy);
    fprintf (fdOut, "%d %d scale\n",(int)(scaledX+0.5), -1*(int)(scaledY+0.5));
    fprintf (fdOut, "drawimage\n");

}

/*****************************************************************************/
/*									     */
/* nom      : EndImagePS						     */
/*									     */
/* fonction : termine un fichier PostScript pour une image	             */
/*                                                                           */
/* entrees  : FILE *fdout	        : fichier de sortie de l'image       */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : neant							     */
/*									     */
/*****************************************************************************/
 
EndImagePS (fdOut)

    FILE *fdOut;

{
    fprintf (fdOut, "showpage\n");
    fprintf (fdOut, "grestore\n");
}


/*****************************************************************************/
/*									     */
/* nom      : proc_laser						     */
/*									     */
/* fonction : declanche la constuction d'un fichier PostScript d'une image   */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*									     */
/*****************************************************************************/

caddr_t proc_laser (m, mi)

    Menu m;
    Menu_item mi;

{
    struct fname *fn, *copyfn;

    int mode = (int) menu_get (mi, MENU_VALUE);
    if (flag_bother){
	if (mode == 0) hproc_laser_Gnature();
	else hproc_laser_Gmaximum();
	return;
    }
    if (flag_help){
	if (mode == 0) hproc_laser_Gnature();
	else hproc_laser_Gmaximum();
    }
    if (!flag_creer) {
	sprintf (buf, mastertabs[230]
	);
	if (mode == 0) strcat (buf, mastertabs[231]);
	else strcat (buf, mastertabs[232]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
	index_image[0] = macro_cour->from[0];
    else fromto (FROM, DEFAUT);
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, "%d ", index_image[0]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen,"%s",fn->filename), "w"); 
    }
    else
	fn = fname_panel (paneltabs[441], paneltabs[442],
	21);
    if (flag_break) {
	interruption();
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	if (mode==0) {
	    sprintf (com->nom, "I_OPOSNOR"); 
	    com->code = 134;
	}
	else {
	    sprintf (com->nom, "I_OPOSMAX"); 
	    com->code = 135;
	}
	com->from[0] = index_image[0];
	sprintf (buf, "%s FROM %d WITH %s\n", 
		com->nom, index_image[0], fn->filename);
	write_macro (buf);
	fn->fpim = fn->fpdesc = NULL;
	copyfn = (struct fname *)malloc(sizeof(*copyfn));
	*copyfn = *fn;
	com->param = (char *)copyfn;
    }
    else {
	sprintf (buf, "--> %s\n", fn->filename);
	write_master (buf);
	fichier_laser(mode, index_image[0], fn->fpim);
    }
}

/*****************************************************************************/
/*									     */
/* nom      : fichier_laser						     */
/*									     */
/* fonction : construit un fichier PostScript pour une image		     */
/*                                                                           */
/* entrees  : unsigned char *image	: image a traiter                    */
/*                                                                           */
/* globale  : char *reponse		: nom du fichier de sortie	     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : SetUpPS							     */
/*	      EndImagePS						     */
/*									     */
/*****************************************************************************/

fichier_laser(mode, nodep, fdOut)
    int	    mode, nodep;
    FILE    *fdOut;
{
    register int i, j;
    register float rapport;
    unsigned char n, *image;
    static char table[] = {'0', '1', '2', '3', '4', '5', '6', '7',
                           '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    if (dir_desc[nodep].type > 0){
	switch (dir_desc[nodep].type){
	    case 2:
	    case 3:
	    case 4:
	    case 5:autoconvert_byte(index_image[0]);
		   image = (unsigned char *) buffer_image[0].image ;
		   break;
	}
	SetUpPS (mode, fdOut, (int)dir_desc[nodep].ncolonne,
		 (int)dir_desc[nodep].nligne);
        rapport = 255 / (buffer_desc[0].mmax - buffer_desc[0].mmin);
        for (j=0; j<buffer_desc[0].nligne; j++) {
            for (i=0; i<buffer_desc[0].ncolonne; i++) {
                n = (unsigned char)((*image - buffer_desc[0].mmin) * rapport);
                fprintf (fdOut, "%c", table [(int)((n & 0xF0) >> 4)]);
                fprintf (fdOut, "%c", table [(int)(n & 0x0F)]);
                image++;
	    }
        fprintf (fdOut, "\n");
	}
        EndImagePS (fdOut);
	fclose (fdOut);
    }
    else if (dir_desc[nodep].type == 0 || dir_desc[nodep].type == -1) {
	image = dir_image[nodep].image;
	SetUpPS (mode, fdOut, (int)dir_desc[nodep].ncolonne,
			(int)dir_desc[nodep].nligne);
        rapport = 255 / (dir_desc[nodep].mmax - dir_desc[nodep].mmin);
        for (j=0; j<dir_desc[nodep].nligne; j++) {
            for (i=0; i<dir_desc[nodep].ncolonne; i++) {
                n = (unsigned char)((*image - dir_desc[nodep].mmin) * rapport);
                fprintf (fdOut, "%c", table [(int)((n & 0xF0) >> 4)]);
                fprintf (fdOut, "%c", table [(int)(n & 0x0F)]);
                image++;
	    }
        fprintf (fdOut, "\n");
	}
        EndImagePS (fdOut);
	fclose (fdOut);
    }
    else {
	write_erreur(16);
	fclose (fdOut);
    }

}

/*****************************************************************************/
/*									     */
/* nom	    : sauve_fichier						     */
/*									     */
/* fonction : sauve une image en format standard (.ima et .desc)             */
/*                                                                           */
/* entrees  : char *filname           : nom du fichier de sauvetage	     */
/*	      int index1,index2,index3: no des plan-images a sauver	     */
/*									     */
/* globales : description desc        : statistiques de l'image              */
/*	      description_memoire dir_desc				     */
/*	      directoire_image dir_image				     */
/*                                                                           */
/* return   : neant                                                          */
/*									     */
/* routines : element(t)              : taille en byte du type de l'image    */
/*									     */
/*****************************************************************************/
 
int sauve_fichier (index1, index2, index3, fn)

int index1, index2, index3;
struct fname *fn;

{   
    FILE    *fp,*fopen();
    int     n, taille, elem;

       /* on ecrit d'abord le descripteur de l'image */

    fp = fn->fpdesc;
    desc.ncolonne = dir_desc[index1].ncolonne; 
    desc.nligne = dir_desc[index1].nligne;
    strcpy (desc.date, (char *)get_time());
    desc.mini[0] = dir_desc[index1].mmin;
    desc.maxi[0] = dir_desc[index1].mmax;
    desc.mu[0] = dir_desc[index1].mu;
    desc.ecart[0] = dir_desc[index1].ecart;
    strcpy (desc.comment, dir_desc[index1].comment);

    if (index2 != -1) {      /* 2eme plan-image non-vide */
        desc.mini[1] = dir_desc[index2].mmin;
        desc.maxi[1] = dir_desc[index2].mmax;
        desc.mu[1] = dir_desc[index2].mu;
        desc.ecart[1] = dir_desc[index2].ecart;
    }
    else desc.mini[1] = desc.maxi[1] = desc.mu[1] = desc.ecart[1] = 0;

    if (index3 != -1) {      /* 3eme plan-image non-vide */
        desc.mini[2] = dir_desc[index3].mmin;
        desc.maxi[2] = dir_desc[index3].mmax;
        desc.mu[2] = dir_desc[index3].mu;
        desc.ecart[2] = dir_desc[index3].ecart;
    }
    else desc.mini[2] = desc.maxi[2] = desc.mu[2] = desc.ecart[2] = 0;

    desc.mini[3] = desc.maxi[3] = desc.mu[3] = desc.ecart[3] = 0;
    desc.mini[4] = desc.maxi[4] = desc.mu[4] = desc.ecart[4] = 0;
    desc.mini[5] = desc.maxi[5] = desc.mu[5] = desc.ecart[5] = 0;

/*
??????????
    fwrite(&desc,sizeof(desc),1,fp);      
??????????
*/
    write_desc(fp, desc);   /* ecriture du descripteur */
    
    fclose(fp);            /* fermeture du fichier .desc */

    /* on ecrit ensuite l'image  */

    elem = element(dir_desc[index1].type);
    taille = desc.nligne * desc.ncolonne * elem;
    fp = fn->fpim;
    fwrite(dir_image[index1].image, (int)taille, 1, fp);     /* 1er plan  */
    if (dir_image[index2].image != NULL)                           
        fwrite(dir_image[index2].image, (int)taille, 1, fp); /* 2eme plan */
    if (dir_image[index3].image != NULL)
        fwrite(dir_image[index3].image, (int)taille, 1, fp); /* 3eme plan */
    fclose(fp);
}

/*****************************************************************************/
/*									     */
/* nom      : proc_sauve1						     */
/*									     */
/* fonction : declanche le sauvetage d'une image a un plan-image	     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*									     */
/*****************************************************************************/

caddr_t proc_sauve1 (m, mi)
    Menu m;
    Menu_item mi;
{
    struct fname *fn, *copyfn;



    if (flag_bother){
	 hproc_sauve_unplan();
	 return;
    }
    if (flag_help) hproc_sauve_unplan();
    if (!flag_creer) {
	sprintf (buf,mastertabs[233] 
	);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
	index_image[0] = macro_cour->from[0];
    else fromto (FROM, DEFAUT);
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, "%d ", index_image[0]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen,"%s.ima",fn->filename), "w"); 
	fn->fpdesc = fopen (sprintf(filen,"%s.des",fn->filename), "w"); 
    }
    else
	fn = fname_panel(paneltabs[443], paneltabs[444],
		    20);
    if (flag_break) {
	interruption();
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->code = 130;
	sprintf (com->nom, "I_OSIMSPL"); 
	com->from[0] = index_image[0];
	sprintf (buf, "I_OSIMSPL FROM %d WITH %s\n", 
		index_image[0], fn->filename);
	write_macro (buf);
	fn->fpim = fn->fpdesc = NULL;
	copyfn = (struct fname *)malloc(sizeof(*copyfn));
	*copyfn = *fn;
	com->param = (char *)copyfn;
    }
    else {
	sprintf (buf, "--> %s\n", fn->filename);
	write_master (buf);
	desc.type = dir_desc[index_image[0]].type;
	sauve_fichier (index_image[0], -1, -1, fn);
    }
}

/*****************************************************************************/
/*									     */
/* nom      : proc_sauve2_cart						     */
/*									     */
/* fonction : declanche le sauvetage d'une image complexe cartesienne        */
/*            ( 2 plans-image)						     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*									     */
/*****************************************************************************/

caddr_t proc_sauve2_cart (m, mi)
    Menu m;
    Menu_item mi;
{
    struct fname *fn, *copyfn;


    if (flag_bother){
	 hproc_sauve_imcart();
	 return;
    }
    if (flag_help) hproc_sauve_imcart();
    if (!flag_creer) {
	sprintf (buf,mastertabs[234]
	);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[2] = macro_cour->from[1];
    }
    else fromto (FROM, COMPL1);
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, "(%d %d) ", index_image[0], index_image[2]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen,"%s.ima",fn->filename), "w"); 
	fn->fpdesc = fopen (sprintf(filen,"%s.des",fn->filename), "w"); 
    }
    else
	fn = fname_panel (paneltabs[445], paneltabs[446],
			 20);
    if (flag_break) {
	interruption();
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->code = 131;
	sprintf (com->nom, "I_OSIMCCA"); 
	com->from[0] = index_image[0];
	com->from[1] = index_image[2];
	sprintf (buf, "SAVECOMPL FROM %d %d WITH %s\n", 
		index_image[0], index_image[2], fn->filename);
	write_macro (buf);
	fn->fpim = fn->fpdesc = NULL;
	copyfn = (struct fname *)malloc(sizeof(*copyfn));
	*copyfn = *fn;
	com->param = (char *)copyfn;
    }
    else {
	sprintf (buf, "--> %s\n", fn->filename);
	write_master (buf);
	desc.type = 4;
	sauve_fichier (index_image[0], index_image[2], -1, fn);
    }
}

/*****************************************************************************/
/*									     */
/* nom      : proc_sauve2_pol						     */
/*									     */
/* fonction : declanche le sauvetage d'une image complexe polaire	     */
/*	      (2 plans-image)						     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*									     */
/*****************************************************************************/

caddr_t proc_sauve2_pol (m, mi)
    Menu m;
    Menu_item mi;
{
    struct fname *fn, *copyfn;


    if (flag_bother){
	hproc_sauve_impol();
	 return;
    }
    if (flag_help) hproc_sauve_impol();
    if (!flag_creer) {
	sprintf (buf,mastertabs[235]
	);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[2] = macro_cour->from[1];
    }
    else fromto (FROM, COMPL2);
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, "(%d %d) ", index_image[0], index_image[2]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen,"%s.ima",fn->filename), "w"); 
	fn->fpdesc = fopen (sprintf(filen,"%s.des",fn->filename), "w"); 
    }
    else
	fn = fname_panel (paneltabs[447],
			paneltabs[446], 20);
    if (flag_break) {
	interruption();
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->code = 132;
	sprintf (com->nom, "I_OSIMCPO"); 
	com->from[0] = index_image[0];
	com->from[1] = index_image[2];
	sprintf (buf, "I_OSIMCPO FROM %d %d WITH %s\n", 
		index_image[0], index_image[2], fn->filename);
	write_macro (buf);
	fn->fpim = fn->fpdesc = NULL;
	copyfn = (struct fname *)malloc(sizeof(*copyfn));
	*copyfn = *fn;
	com->param = (char *)copyfn;
    }
    else {
	sprintf (buf, "--> %s\n", fn->filename);
	write_master (buf);
	desc.type = 5;
	sauve_fichier (index_image[0], index_image[2], -1, fn);
    }
}

/*****************************************************************************/
/*									     */
/* nom      : proc_sauve3						     */
/*									     */
/* fonction : declanche le sauvetage d'une image RGB (3 plans-image)	     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*									     */
/*****************************************************************************/

caddr_t proc_sauve3 (m, mi)
    Menu m;
    Menu_item mi;

{
    struct fname *fn, *copyfn;



    if (flag_bother){
	 hproc_sauve_imrgb();
	 return;
    }
    if (flag_help) hproc_sauve_imrgb();
    if (!flag_creer) {
	sprintf (buf,mastertabs[236]
	);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[2] = macro_cour->from[1];
	index_image[4] = macro_cour->from[2];
    }
    else fromto (FROM, RGB);
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
       sprintf(buf,"(%d %d %d) ",index_image[0],index_image[2],index_image[4]);
       write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen,"%s.ima",fn->filename), "w"); 
	fn->fpdesc = fopen (sprintf(filen,"%s.des",fn->filename), "w"); 
    }
    else
	fn = fname_panel (paneltabs[448], paneltabs[446],
	20);
    if (flag_break) {
	interruption();
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->code = 133;
	sprintf (com->nom, "I_OSIMRGB"); 
	com->from[0] = index_image[0];
	com->from[1] = index_image[2];
	com->from[2] = index_image[4];
	sprintf (buf, "I_OSIMRGB FROM %d %d %d WITH %s\n", 
		index_image[0], index_image[2], index_image[4], fn->filename);
	write_macro (buf);
	fn->fpim = fn->fpdesc = NULL;
	copyfn = (struct fname *)malloc(sizeof(*copyfn));
	*copyfn = *fn;
	com->param = (char *)copyfn;
    }
    else {
	sprintf (buf, "--> %s\n", fn->filename);
	write_master (buf);
	desc.type = 6;
	sauve_fichier (index_image[0],index_image[2],index_image[4], fn);
    }
}


caddr_t proc_write_rasterfile(m, mi)
    Menu m;
    Menu_item mi;
{
    FILE *fp;
    int i, nline, ncol;
    struct fname *fnras1, *copyfnras1;
    struct pixrect *p1pixrect;
    colormap_t colormaploc;
    short *images;

    unsigned char *p_pix, *p_image;
    int incr_pix, l, c, flag_autoconvert;
    
    if (flag_bother){
	hproc_write_rasterfile();
	return;
    }
    if (flag_help) hproc_write_rasterfile();
    if (!flag_creer) {
	sprintf (buf,mastertabs[237] );
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
	index_image[0] = macro_cour->from[0];
    else fromto (FROM, DEFAUT);
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, "%d ", index_image[0]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;

	filen = (char *)malloc(60);
	fnras1 = (struct fname *)macro_cour->param;
	fnras1->fpim = fopen (sprintf(filen,"%s.ima",fnras1->filename), "w"); 
	fnras1->fpdesc = fopen (sprintf(filen,"%s.des",fnras1->filename), "w"); 
    }
    else
	fnras1 = fname_panel(paneltabs[449], paneltabs[450], 31);
    if (flag_break) {
	interruption();
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->code = 136;
	sprintf (com->nom, "I_OSIMSRA"); 
	com->from[0] = index_image[0];
	sprintf (buf, "I_OSIMSRA FROM %d WITH %s\n", 
		index_image[0], fnras1->filename);
	write_macro (buf);
	fnras1->fpim = fnras1->fpdesc = NULL;
	copyfnras1 = (struct fname *)malloc(sizeof(*copyfnras1));
	*copyfnras1 = *fnras1;
	com->param = (char *)copyfnras1;
    }
    else {
	sprintf (buf, "--> %s\n", fnras1->filename);
	write_master (buf);
	switch (dir_desc[index_image[0]].type){
	    case -1:
	    case 0: 
		    p_image = (unsigned char *)dir_image[index_image[0]].image;
		    break;
	    case 1:
	    case 2:
	    case 3:
	    case 4:
	    case 5:flag_autoconvert = TRUE;
		   autoconvert_byte(index_image[0]);
		   p_image = (unsigned char *) buffer_image[0].image;
		   break;
	}
	colormaploc.type = RMT_EQUAL_RGB;
	colormaploc.length = 256;
	colormaploc.map[0] = nivgrislin[0];
	colormaploc.map[1] = nivgrislin[1];
	colormaploc.map[2] = nivgrislin[2];
	ncol  = dir_desc[index_image[0]].ncolonne ;
	nline = dir_desc[index_image[0]].nligne;

	p1pixrect = mem_create(ncol, nline, 8);
	p_pix = (unsigned char *)((mpr_d(p1pixrect))->md_image);
	incr_pix = dir_desc[index_image[0]].ncolonne & 03;
	incr_pix = (4 - incr_pix) & 03;
	for (l=0; l<nline; l++){
	    for (c=0; c<ncol; c++){
		*p_pix = *p_image;
		p_pix++;  p_image++;
	    }
	    p_pix += incr_pix;
	}
	pr_dump(p1pixrect, fnras1->fpim, &colormaploc, RT_BYTE_ENCODED, 1);
	pr_destroy(p1pixrect);
	fclose(fnras1->fpim);
	if (flag_autoconvert == TRUE)
	    free (p_image);

    }
    
}

