/*****************************************************************************/
/* module histogr.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/scrollbar.h>
#include <math.h>
#include <stdio.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

#define	MIN(A,B)    ((A)<(B)?(A):(B))

static	void		dans_histo();
static	Panel_setting	lire_histo();
extern	SetUpPS(), EndImagePS();
extern	struct	fname	*fname_panel();

Frame       frame_histo;
Panel       panel_histo;
Panel_item  histo_haut, histo_larg, histo_min, histo_max, histo_recip;
Panel_item  rep_histo;

extern void hproc_calcule_hist();
extern void hproc_affiche_hist();
extern void hproc_imprime_hist();

extern char *paneltabs[];
extern char *mastertabs[];
/*****************************************************************************/

static Panel_setting lire_histo (item, event)
    Panel_item item;
    Event *event;

{
    static struct description_vecteur desc_vect;
    struct histogr *histo;
    int i, mode;

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_histo);
        return;
    }
    else { 
        if (event_id(event) == '\t')
	    return (PANEL_NEXT);
        else {
	    mode = (int) window_get (panel_histo, WIN_CLIENT_DATA, 0);
	    histo = (struct histogr *)malloc(sizeof(*histo));
	    switch (mode) {
	    case 0:
		desc_vect.ncase = atoi ((char *)panel_get
		    (histo_recip, PANEL_VALUE));
		desc_vect.b_min = atoi ((char *)panel_get
		    (histo_min, PANEL_VALUE));
		desc_vect.b_max = atoi ((char *)panel_get
		    (histo_max, PANEL_VALUE));
		break;
	    case 1:
		histo->larg_barre = atoi ((char *)panel_get
		    (histo_larg, PANEL_VALUE));
		histo->haut_barre = atoi ((char *)panel_get
		    (histo_haut, PANEL_VALUE));
		break;
	    }
	    desc_vect.prive = (char *)histo;
	    window_return(&desc_vect);
	    window_destroy (frame_histo);
	    return;
	}
    }
}

/*****************************************************************************/

struct description_vecteur *histo_panel(nodep, noarr, mode)
    int nodep, noarr, mode;

{
    Panel_item titre;
    char stitre[30];
    struct description_vecteur *reshisto, *histo;
    struct histogr *ih, *ihr;
    
    frame_histo = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_histo = window_create (frame_histo, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);

    switch (mode) {
	case 0: strcpy (stitre, paneltabs[200]); break;
	case 1: strcpy (stitre, paneltabs[201]); break;
	case 2: strcpy (stitre, paneltabs[202]); break;
    }
    titre = panel_create_item (panel_histo, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, stitre,
                       0);
    switch (mode){
	case 0:
	    sprintf(stitre, "%d", 
		flag_creer ? 0 : (int)rint(dir_desc[nodep].mmin));
	    histo_min = panel_create_item (panel_histo, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[203],
                       PANEL_VALUE, stitre,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_histo,
                       0);
	    sprintf(stitre, "%d", 
		flag_creer ? 255 : (int)rint(dir_desc[nodep].mmax));
	    histo_max = panel_create_item (panel_histo, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[204],
                       PANEL_VALUE, stitre,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_histo,
                       0);
	    sprintf(stitre, "%d", flag_creer ? 256 : 
	       (int)(rint(dir_desc[nodep].mmax)-rint(dir_desc[nodep].mmin)+1));
	    histo_recip = panel_create_item (panel_histo, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(4),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[205],
                       PANEL_VALUE, stitre,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_histo,
                       0);
	    window_set (panel_histo, WIN_CLIENT_DATA, 0, 0); 
	    window_set (panel_histo, PANEL_CARET_ITEM, histo_min, 0);
	    break;
	case 1:
	    histo_haut = panel_create_item (panel_histo, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[206],
                       PANEL_VALUE, "256\0",
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_histo,
                       0);
	    histo_larg = panel_create_item (panel_histo, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[207],
                       PANEL_VALUE, "1\0",
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_histo,
                       0);
	    window_set (panel_histo, WIN_CLIENT_DATA, 1, 0); 
	    window_set (panel_histo, PANEL_CARET_ITEM, histo_haut, 0);
	    break;
    }
    window_fit (panel_histo);
    window_fit (frame_histo);
    
    histo = (struct description_vecteur *)malloc(sizeof(*histo));
    reshisto = (struct description_vecteur *)window_loop(frame_histo);
    if (!flag_break){
	switch (mode) {
	case 0:
	    *histo = *reshisto;
	    histo->type = 2;
	    histo->genre = 0;
	    break;
	case 1:
	    if (flag_creer){
		*histo = *reshisto;	    
	    }
	    else {
		*histo = dir_desc_vect[nodep];
		ih = (struct histogr *)histo->prive;	
		ihr = (struct histogr *)reshisto->prive;    
		ih->larg_barre = ihr->larg_barre;
		ih->haut_barre = ihr->haut_barre;
		free(ihr);
	    }
	    break;
	}
    }
    return (histo);
}

/*****************************************************************************/

affiche_histo (nodep, histo)
    int	nodep;
    struct description_vecteur *histo;
{
    Frame fr_histo;
    Canvas can_histo;
    Panel panel_rep;
    Pixwin *pw;
    Scrollbar barvert, barhoriz;
    int fli, fco, haut, maxhist, pas, *tab_hist, *temp;
    char titre[80];
    register int i,j;
    struct histogr *ih;
    struct description_vecteur *dv;

    ih = (struct histogr *)histo->prive;
    fli = ih->haut_barre;
    fco = histo->ncase * ih->larg_barre;

    sprintf (titre, "[%d]", index_vect[0]);
    fr_histo = window_create (NULL, FRAME, 
			FRAME_LABEL, titre,
                        FRAME_NO_CONFIRM, TRUE, FRAME_EMBOLDEN_LABEL, TRUE, 
                        WIN_SHOW, TRUE, 0, 0);
    can_histo = window_create (fr_histo, CANVAS, WIN_SHOW, TRUE,
                         CANVAS_AUTO_EXPAND, FALSE,
                         CANVAS_AUTO_SHRINK, FALSE,
                         CANVAS_AUTO_CLEAR, TRUE,
                         CANVAS_FIXED_IMAGE, FALSE,
			 CANVAS_FAST_MONO, TRUE,
                         CANVAS_WIDTH, fco,
                         CANVAS_HEIGHT, fli,
                         WIN_WIDTH, MIN (fco, 512) + 15,   
                         WIN_HEIGHT, MIN (fli, 512) + 15,
			 WIN_EVENT_PROC, dans_histo, 
                         0); 
    window_set (can_histo, CANVAS_RETAINED, TRUE,
                WIN_VERTICAL_SCROLLBAR, barvert = scrollbar_create(0),
                WIN_HORIZONTAL_SCROLLBAR, barhoriz = scrollbar_create(0), 0);
    scrollbar_paint_clear (barvert);
    scrollbar_paint_clear (barhoriz);
    window_fit (can_histo); 
    panel_rep = window_create (fr_histo, PANEL, PANEL_LABEL_BOLD, TRUE,
			       WIN_X, 0, WIN_ROWS, 1, WIN_BELOW, can_histo,
			       0);
    rep_histo = panel_create_item (panel_rep, PANEL_MESSAGE,
			       PANEL_SHOW_ITEM, TRUE,
			       PANEL_LABEL_STRING, paneltabs[208], 0);
    ih->histo_rep = rep_histo;
    window_fit_height (panel_rep);
    window_fit (fr_histo);

    pw = canvas_pixwin (can_histo);
    pw_writebackground (pw, 0, 0, fco, fli, PIX_SRC);

    dv = (struct description_vecteur *)malloc(sizeof(*dv));
    *dv = *histo;
    /* on met dans les "donnees privees" du canvas ...*/
    window_set (can_histo, WIN_CLIENT_DATA, dv, 0);

    pas = 0;
    temp = (int *)malloc(histo->ncase * sizeof(*temp));
    ((struct histogr *)(dv->prive))->tab_hist = temp;
    tab_hist = (int *)dir_vecteur[nodep].image;
    for (i=0; i<histo->ncase; i++){
	for (j=0; j<ih->larg_barre; j++){
            haut = *(tab_hist) * ih->haut_barre / histo->vmax;
	    if (haut!=0)
		pw_vector (pw, pas+j, ih->haut_barre - 1, pas+j, 
			   ih->haut_barre - haut, PIX_SRC, 1);
	}
	*temp = *tab_hist;
	tab_hist++;  temp++;
	pas += ih->larg_barre;
    }
}

/*****************************************************************************/

calcul_histo (nodep, noarr, histo)
    int nodep, noarr;
    struct description_vecteur *histo;
{
    float delta, longueur;
    register int i, j;
    int taille, pas, total;
    int *tab_hist, *temp;
    struct histogr *ih;

    tab_hist = (int *)malloc(histo->ncase * sizeof(*tab_hist));

    longueur = histo->b_max - histo->b_min;
    delta = (longueur + 1) / histo->ncase;
    taille = dir_desc[nodep].ncolonne * dir_desc[nodep].nligne;
    temp = tab_hist;
    for (i=0; i<histo->ncase; i++) {
	*temp = 0;
	temp++;
    }
    total = 0;
    switch (dir_desc[nodep].type) {
	case -1:
	case 0 :{
	    unsigned char *im = dir_image[nodep].image;
	    for (i=0; i<taille; i++){
		if (*im >= histo->b_min && *im <= histo->b_max){
		    pas = (int) (((*im) - histo->b_min) / delta);
		    (*(tab_hist + pas))++;
		    im++;  total++;
		}
	    }
            break;
	}
	case 1 :{
	    short *im = (short *)dir_image[nodep].image;
	    for (i=0; i<taille; i++){
		if (*im >= histo->b_min && *im <= histo->b_max){
		    pas = (int) (((*im) - histo->b_min) / delta);
		    (*(tab_hist + pas))++;
		    im++;  total++;
		}
	    }
            break;
	}
	case 2 :{
	    int *im = (int *)dir_image[nodep].image;
	    for (i=0; i<taille; i++){
		if (*im >= histo->b_min && *im <= histo->b_max){
		    pas = (int) (((*im) - histo->b_min) / delta);
		    (*(tab_hist + pas))++;
		    im++;  total++;
		}
	    }
            break;
	}
	case 3 :{
	    float *im = (float *)dir_image[nodep].image;
	    for (i=0; i<taille; i++){
		if (*im >= histo->b_min && *im <= histo->b_max){
		    pas = (int) (((*im) - histo->b_min) / delta);
		    (*(tab_hist + pas))++;
		    im++;  total++;
		}
	    }
            break;
	}
    }
/* ### 18 septembre 1989 */
/* histo -> vmin, vmax, total, sont de type float */
    histo->total = (float) total;
    histo->vmin = (float)taille;
    histo->vmax = 0.0;
    temp = tab_hist;
    for (i=0; i<histo->ncase; i++){
	if ((float)*temp < histo->vmin) histo->vmin = (float)*temp;
	else if ((float)*temp > histo->vmax) histo->vmax = (float)*temp;
	temp++;
    }
/* ### */
    ih = (struct histogr *)histo->prive;
    ih->tab_hist = tab_hist;
    if (dir_vecteur[noarr].image != NULL) free (dir_vecteur[noarr].image);
    dir_vecteur[noarr].image = (unsigned char *)tab_hist;
    dir_desc_vect[noarr] = *histo;
}	
	
/*****************************************************************************/
	
imprimer_histo (nodep, histo, fn)
    int	    nodep;
    struct  description_vecteur	*histo;
    struct  fname *fn;
{
    struct  histogr *ih;
    int	    pas = 0;
    int	    *tab_hist, *tab_haut, *temp;
    register int i, j, k;

    ih = (struct histogr *)histo->prive;
    SetUpPS (1,fn->fpim,(histo->ncase * ih->larg_barre)+2, ih->haut_barre + 2);
    tab_hist = (int *)dir_vecteur[nodep].image;
    temp = tab_haut = (int *)malloc(histo->ncase * sizeof(int));
    for (i=0; i<histo->ncase; i++){
	*tab_haut = *(tab_hist) * ih->haut_barre / histo->vmax;
	tab_haut++;
	tab_hist++;
    }
    for (i=0; i<(histo->ncase * ih->larg_barre) + 2; i++) 
	fprintf (fn->fpim, "00");
    fprintf (fn->fpim, "\n");
    for (j=ih->haut_barre; j>0; j--){
	tab_haut = temp;
	fprintf (fn->fpim, "00");
	for (i=0; i<histo->ncase; i++){
	    if (j > *tab_haut) 
		for (k=0; k<ih->larg_barre; k++)
		    fprintf (fn->fpim, "ff");
	    else
		for (k=0; k<ih->larg_barre; k++)
		    fprintf (fn->fpim, "00");
	    tab_haut++;
	}
	fprintf (fn->fpim, "00");
	fprintf (fn->fpim, "\n");
    }
    for (i=0; i<(histo->ncase * ih->larg_barre) + 2; i++) 
	fprintf (fn->fpim, "00");
    fprintf (fn->fpim, "\n");
    EndImagePS (fn->fpim);
    fclose (fn->fpim);
}

/*****************************************************************************/

caddr_t proc_histo (m, mi)
    Menu m;
    Menu_item mi;

{
    struct  fname *fn, *fncopy;
    struct  description_vecteur *histo, *copyhisto;
    int mode = (int)menu_get(mi, MENU_VALUE);

    switch (mode){
	case 0: /*calculer*/
	    if (flag_bother) {
		hproc_calcule_hist();
		return;
	    }
            if (flag_help) hproc_calcule_hist();	
	    if (!flag_creer){
		sprintf (buf, mastertabs[91]);
		write_master (buf);
	    }
	    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
		index_image[0] = macro_cour->from[0];
		index_vect[1] = macro_cour->to[0];
	    }
	    else{
		fromto(FROM, DEFAUT);
		if (flag_break) {
		    interruption();
		    return;
		}
		fromto_vect(TO, DEFAUT);
		if (flag_break) {
		    interruption();
		    return;
		}
	    }
	    if (!flag_creer){
		sprintf (buf, mastertabs[92], index_image[0], index_vect[1]);
		write_master (buf);
	    }
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
		histo = (struct description_vecteur *)malloc(sizeof(*histo));
		*histo = *((struct description_vecteur *)macro_cour->param);
		if (histo->b_min == 0 && histo->b_max == 0){
		    histo->b_min = (int)rint(dir_desc[index_image[0]].mmin);
		    histo->b_max = (int)rint(dir_desc[index_image[0]].mmax);
		}
		if (histo->ncase == 0) 
		    histo->ncase = histo->b_max - histo->b_min + 1;
	    }
	    else histo = histo_panel(index_image[0], index_vect[1], 0);
	    if (flag_break) {
		interruption();
		return;
	    }
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande(&macro_cour);
		sprintf (com->nom, "MEAHISCAL");
		com->code = 30;
		com->from[0] = index_image[0];
		com->to[0] = index_vect[1];
		sprintf (buf,"MEAHISCAL FROM %d TO %d WITH %d %d %d\n",
			index_image[0], index_vect[1], 
			histo->b_min, histo->b_max, histo->ncase);
		write_macro(buf);
		copyhisto = (struct description_vecteur *)
			    malloc(sizeof(*copyhisto));
		*copyhisto = *histo;
		com->param = (char *)copyhisto;
	    }
	    else{
		sprintf (buf, "(%d %d %d)\n", 
			histo->b_min, histo->b_max, histo->ncase);
		write_master(buf);
		calcul_histo (index_image[0], index_vect[1], histo);
	    }
	    break;
	case 1: /*afficher*/
	    if (flag_bother) {
		hproc_affiche_hist();
		return;
	    }
            if (flag_help) hproc_affiche_hist();	
	    if (!flag_creer){
		sprintf (buf, mastertabs[93]);
		write_master (buf);
	    }
	    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
		index_vect[0] = macro_cour->from[0];
	    else{
		fromto_vect(FROM, DEFAUT);
		if (flag_break) {
		    interruption();
		    return;
		}
	    }
	    if (!flag_creer){
		if (dir_vecteur[index_vect[0]].image == NULL){
		    write_erreur(21);
		    return;
		}
		sprintf (buf, mastertabs[94], index_vect[0]);
		write_master (buf);
	    }
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
		histo = (struct description_vecteur *)malloc(sizeof(*histo));
		*histo = *((struct description_vecteur *)macro_cour->param);
	    }
	    else
		histo = histo_panel(index_vect[0], -1, 1);
	    if (flag_break) {
		interruption();
		return;
	    }
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande(&macro_cour);
		sprintf (com->nom, "MEAHISSHO");
		com->code = 31;
		com->from[0] = index_vect[0];
		sprintf (buf,"MEAHISSHO FROM %d WITH %d %d\n",
			index_vect[0], 
			((struct histogr *)histo->prive)->haut_barre,
			((struct histogr *)histo->prive)->larg_barre);
		write_macro(buf);
		copyhisto = (struct description_vecteur *)
			    malloc(sizeof(*copyhisto));
		*copyhisto = *histo;
		com->param = (char *)copyhisto;
		free(histo);
	    }
	    else{
		sprintf (buf, "(%d %d)\n", 
			((struct histogr *)(histo->prive))->larg_barre,
			((struct histogr *)(histo->prive))->haut_barre);
		write_master(buf);
		dir_desc_vect[index_vect[0]].prive = histo->prive;
		free(histo);
		affiche_histo(index_vect[0],&dir_desc_vect[index_vect[0]]);
	    }
	    break;
	case 2: /*imprimer*/
	    if (flag_bother) {
		hproc_imprime_hist();
		return;
	    }
            if (flag_help) hproc_imprime_hist();	
	    if (!flag_creer){
		sprintf (buf, mastertabs[95]);
		write_master (buf);
	    }
	    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
		index_vect[0] = macro_cour->from[0];
	    else{
		fromto_vect(FROM, DEFAUT);
		if (flag_break) {
		    interruption();
		    return;
		}
	    }
	    if (!flag_creer){
		if (dir_vecteur[index_vect[0]].image == NULL){
		    write_erreur(21);
		    return;
		}
		sprintf (buf, mastertabs[94], index_vect[0]);
		write_master (buf);
	    }
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
		histo = (struct description_vecteur *)malloc(sizeof(*histo));
		*histo = *((struct description_vecteur *)macro_cour->param);
		fncopy = ((struct histogr *)histo->prive)->fileps;
		fncopy->fpim = fopen (fncopy->filename, "w"); 
	    }
	    else {
		histo = histo_panel(index_vect[0], -1, 1);
		if (flag_break) {
		    interruption();
		    return;
		}
		fn = fname_panel
		     (paneltabs[209],paneltabs[210],21);
		fncopy = (struct fname *)malloc (sizeof(*fncopy));
		*fncopy = *fn;
		((struct histogr *)histo->prive)->fileps = fncopy;
	    }
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande(&macro_cour);
		sprintf (com->nom, "MEAHISPRI");
		com->code = 32;
		com->from[0] = index_vect[0];
		sprintf (buf,"MEAHISPRI FROM %d WITH %d %d %s\n\0",
			index_vect[0], 
			((struct histogr *)histo->prive)->haut_barre,
			((struct histogr *)histo->prive)->larg_barre,
			((struct histogr *)histo->prive)->fileps->filename);
		fclose (((struct histogr *)histo->prive)->fileps->fpim);
		write_macro(buf);
		copyhisto = (struct description_vecteur *)
			    malloc(sizeof(*copyhisto));
		*copyhisto = *histo;
		com->param = (char *)copyhisto;
		free(histo);
	    }
	    else{
		dir_desc_vect[index_vect[0]].prive = histo->prive;
		fncopy = ((struct histogr *)histo->prive)->fileps;
		sprintf (buf, "--> %s (%d %d)\n", fncopy->filename,
			((struct histogr *)(histo->prive))->larg_barre,
			((struct histogr *)(histo->prive))->haut_barre);
		write_master (buf);
		imprimer_histo
			(index_vect[0], &dir_desc_vect[index_vect[0]], fncopy);
		free(histo);
	    }
	    break;
    }
}

/*****************************************************************************/

static void dans_histo (can, event)
    Canvas can;
    Event *event;

{
    struct description_vecteur *info_hist;
    struct histogr *ih;
    int no_barre, i;
    float delta, pct;
    char * rep;

    if (event_id(event) == MS_RIGHT && event_is_down(event) == TRUE) {
	rep = (char *)malloc(40);
	info_hist = (struct description_vecteur *)
		    window_get (can, WIN_CLIENT_DATA, 0);
	ih = (struct histogr *)info_hist->prive;
	no_barre = (int)event_x(event) / ih->larg_barre;
	delta = (info_hist->b_max - info_hist->b_min + 1) / info_hist->ncase; 
	pct = 0.0;
	for (i=0; i<=no_barre; i++)
	    pct += (float)*(ih->tab_hist + i);
	pct = pct / info_hist->total * 100.0;
	sprintf (rep, "%.0f-%.0f  %.4f%%  [->%.4f%%]\0", 
		 info_hist->b_min + delta * no_barre,
		 info_hist->b_min + delta * (no_barre + 1) - 1,
		 (float)(*(ih->tab_hist+no_barre)) / info_hist->total * 100.0,
		 (float) pct);
	panel_set (ih->histo_rep, PANEL_LABEL_STRING, rep, 0);
    }
}
