/*****************************************************************************/
/* module stransfo.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

#define INFINI -1
#define NULL 0

extern unsigned short **liste_point;

erosion(nl,nc,image,taille)
int nl,nc;
short **image;
short taille;
{
  int i;
  long n = 1; /* nombre de points qui changent de valeur */

  x1_cadre(nl,nc,image);  /* met le cadre a 1 */
  if(taille == INFINI)
     {
	 while((n = b_erosion(nl,nc,image)) != NULL)
             {
		 ;
	     }
     }
  else
     {
          for(i=1;i<=taille;i++)
             {
        	 n = b_erosion(nl,nc,image);
                 if(n == 0)
                   {
	               break;
	           }
	     }
     }
} /* end erosion */ 


/****************************************************************/

dilatation(nl,nc,image,taille)
int nl,nc;
short **image;
short taille;
{
  int i;
  long n;
 
  x0_cadre(nl,nc,image);
  if(taille == INFINI)
     {   
	 while((n = b_dilatation(nl,nc,image)) != NULL)
             {
		 ;
	     }
     }
  else
     {
          for(i=1;i<=taille;i++)
             {
        	 n = b_dilatation(nl,nc,image);
                 if(n == 0)
                   {
	               break;
	           }
	     }
     }
} /* end dilatation */ 

/**************************************************************/

/* dilatation conditionnel de grandeur taille */ 

condilat(nl,nc,image,ima2,taille)
int nl,nc;
short **image,**ima2;
short taille;
{
  int i;
  long n;
  
  x0_cadre(nl,nc,image);
  if(taille == INFINI)
     {
	 while((n = b_condilat(nl,nc,image,ima2)) != NULL)
             {
		 ;
	     }
     }
  else
     {
          for(i=1;i<=taille;i++)
             {
        	 n = b_condilat(nl,nc,image,ima2);
                 if(n == 0)
                   {
	               break;
	           }
	     }
     }
} /* end condilat */ 

/************************************************************************/

/* erosion conditionnel de grandeur taille */ 

conderos(nl,nc,image,ima2,taille)
int nl,nc;
short **image,**ima2;
short taille;
{
  int i;
  long n;
  
  x1_cadre(nl,nc,image);
  if(taille == INFINI)
     {
	 while((n = b_conderos(nl,nc,image,ima2)) != NULL)
             {
		 ;
	     }
     }
  else
     {
          for(i=1;i<=taille;i++)
             {
        	 n = b_conderos(nl,nc,image,ima2);
                 if(n == 0)
                   {
	               break;
	           }
	     }
     }
} /* end conderos */ 

/************************************************************************/

