/*****************************************************************************/
/* module conversion.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

#include "def.h"

#define ALLUME 255
#define ETEINT 0
#define NORMAL 1
#define AJOUT  2


#define OUI  1
#define TRUE 1
#define FALSE 0

extern struct desc_ima  tab_ima[MAX_IMA];

/* transformation trame carree -> hexagonale */
 
carhex(nls, ncs, imas, imah, ima_courante)
int nls, ncs,  ima_courante;
unsigned char *imas, *imah;
{
    int i, ncolh;
    register int j;
    register float s, a;
    float          b, c;
    short flag = FALSE;

    a = 1.154700539;
    b = 0.5000000000;
    c = 1.077350269;

    tab_ima[ima_courante].trame = NORMAL;

    ncolh = ncs/a + 1;
    if((ncolh & 01) == 01)
       {
           tab_ima[ima_courante].trame = AJOUT;

	   flag = TRUE;   /* nombre impair de colonnes */
       }
    for(i=1;i<=(nls/2);i++)
      {
          if(flag)   /* on ajoute une colonne devant la premiere */
            {
		*imah++ = *imas;
	    }
          
          s = b;
	  for(j=1;j<=ncolh;j++)  /* lignes impairs */
            {
		*imah++ = *(imas + (int) s );
                s += a;
	    }
          imas += ncs;

          if(flag)   /* on ajoute une colonne */
            {
		*imah++ = *imas;
	    }
          
          s = c;
	  for(j=1;j<ncolh;j++)  /* lignes pairs */
            {
		*imah++ = *(imas + (int) s );
                s += a;
	    }
          imas += ncs;
          *imah++ = *(imas - 1); /* dernier point de la ligne */
      }
    if(flag)
      {
	  ncolh = ncolh+1;
      }
    return(ncolh);
}

/****************************************************************/
/* transformation trame hexagonale --> trame carree */

hexcar(nlh, nch, imah, imas, ima_courante)
int nlh, nch,  ima_courante;
unsigned char *imah, *imas;
{
    int i, ncs;
    register int j;
    register float s, a;
    float          b, c;
    short flag = FALSE;

    a = 0.8660254033;
    b = 0.5000000000;
    c = -0.077350269;

    ncs = tab_ima[ima_courante].ncs;    

    if( tab_ima[ima_courante].trame == AJOUT)
       {
	   flag = TRUE;   /* nombre impair de colonnes */
           nch--;
       }
    for(i=1;i<=(nlh/2);i++)
      {
          if(flag)   /* on supprime  une colonne */
            {
                 imah++;
	    }
          
          s = b;
	  for(j=1;j<=ncs;j++)  /* lignes impairs */
            {
		*imas++ = *(imah + (int) s );
                s += a;
	    }
          imah += nch;

          if(flag)   /* on supprime  une colonne */
            {
		*imah++;
	    }

          *imas++ = *imah;         /* premier point de la ligne */
          s = a + c;
	  for(j=2;j<=ncs;j++)  /* lignes pairs */
            {
		*imas++ = *(imah + (int) s );
                s += a;
	    }
          imah += nch;
      } 
	
}



/*************************************************************************/


/*  compaction de l'image : 4 pixels par point */

compacter(nlh, nch, imah, ima)
int            nlh, nch;
unsigned char  *imah;
unsigned short **ima;
{
    int i, nl, nc;
    register int j;
    register unsigned short *p_col,  *p_av, *p_ap;

    nl = nlh/2;
    nc = nch/2;

    ima_clear(nl, nc, ima);   /* met l'image pointee par ima a 0 */
 
    for(i=1;i<=nl;i++)
      {  
          ima++;
          p_av = *(ima-1);
	  p_col = *ima;
          p_ap = *(ima+1);
          for(j=1;j<=nc;j++)         /* valeur de A et B */
            {
                p_av++;
                p_col++;
                p_ap++;
		if(*imah++ != ETEINT)  /* pixel A a 1 */
                  {
		      A1_voisin(p_av, p_col); 
		  }
                if(*imah++ != ETEINT)  /* pixel B a 1 */
                  {
		      B1_voisin(p_av, p_col);
		  }
	    }
          p_av = *(ima-1);
	  p_col = *ima;
          p_ap = *(ima+1);
          for(j=1;j<=nc;j++)         /* valeur de C et D */
            {
                p_av++;
                p_col++;
                p_ap++;  
		if(*imah++ != ETEINT)   /* pixel C a 1 */
                  {
		      C1_voisin(p_col, p_ap);
		  }
                ;
                if(*imah++ != ETEINT)   /* pixel D a1 */
                  {
		      D1_voisin(p_col, p_ap);
		  }
	    }

      }                       
}  /* end compacter */

/***********************************************************************/
/* decompacte une image */

decompacter(nl, nc, ima, imah)
int nl, nc;
unsigned char *imah;
unsigned short **ima;
{                         
    int i;
    register int j;
    unsigned short *p_col;

    ima++;
    for(i=1;i<=nl;i++)
      {
	  p_col = *ima;
          p_col++;
          for(j=1;j<=nc;j++)
            { 
		*imah++ = ((*p_col & 01) == 01) ? ALLUME : ETEINT ;  /* A */
                *imah++ = ((*p_col & 02) == 02) ? ALLUME : ETEINT ;  /* B */
                p_col++;  
	    }
          p_col = *ima;
          p_col++;
          for(j=1;j<=nc;j++)
            {
		*imah++ = ((*p_col & 04) == 04) ? ALLUME : ETEINT ;  /* C */
                *imah++ = ((*p_col & 010) == 010) ? ALLUME : ETEINT; /* D */
                 p_col++;
	    }
          ima++;
      }
}  /* end decompacter */

/*************************************************************************/
