/* globals.h
   Define the global variables and macros */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing Services Office                      */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef G_GLOBALS_H
#define G_GLOBALS_H

/* These defines assure that global variables are declared only once.
   They are declared when this file is included by a file with GLOBALS
   defined. */

#ifndef GLOBALS
#define EXTERN extern
#define INIT(x)
#else
#define EXTERN
#define INIT(x) =x
#endif


EXTERN
char		gopherName[PATH_NAME_LEN];	/* name used to start xgopher */

EXTERN
FILE		*logFP INIT(NULL);		/* global logging file */

#undef EXTERN
#undef INIT


	/*   Macros and symbolic constants used by Xgopher */

#define		LOG	if (logFP != NULL) fprintf

#define GSTAT_WAIT      1       /* show status indicating some delay */
#define GSTAT_SELECT    2       /* show awaiting selection status */

#define MIN_DIR_STRING_LIST_LEN		200	/* hint at len of dir list */
#define MIN_MARK_STRING_LIST_LEN	20	/* hint at len of mark list */

#endif /* ifndef G_GLOBALS_H */
