/*
 * inval.h --
 *	POSTGRES cache invalidation dispatcher definitions.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/utils/RCS/inval.h,v 1.8 1991/11/11 19:32:17 mer Exp $
 */

#ifndef	InvalIncluded	/* Include this file only once */
#define InvalIncluded	1

#include "tmp/postgres.h"
#include "utils/linval.h"
#include "access/htup.h"
#include "utils/rel.h"

/*
 * DiscardInvalid --
 *	Causes the invalidated cache state to be discarded.
 *
 * Note:
 *	This should be called as the first step in processing a transaction.
 *	This should be called while waiting for a query from the front end
 *	when other backends are active.
 */
extern
void
DiscardInvalid ARGS((
	void
));

/*
 * RegisterInvalid --
 *	Causes registration of invalidated state with other backends iff true.
 *
 * Note:
 *	This should be called as the last step in processing a transaction.
 */
extern
void
RegisterInvalid ARGS((
	bool	send
));

/*
 * SetRefreshWhenInvalidate --
 *	Causes the local caches to be immediately refreshed iff true.
 */
void
SetRefreshWhenInvalidate ARGS((
	bool	on
));

/*
 * RelationIdInvalidateHeapTuple --
 *	Causes the given tuple in a relation to be invalidated.
 *
 * Note:
 *	Assumes object id is valid.
 *	Assumes tuple is valid.
 */
extern
void
RelationIdInvalidateHeapTuple ARGS((
	ObjectId	relationId,
	HeapTuple	tuple
));

InvalidationEntry InvalidationEntryAllocate ARGS((uint16 size ));

LocalInvalid LocalInvalidRegister ARGS((
	LocalInvalid invalid,
	InvalidationEntry entry
));

void LocalInvalidInvalidate ARGS((LocalInvalid invalid , void (*function )()));

void getmyrelids ARGS((void ));

#endif	/* !defined(InvalIncluded) */

