/*
 * context.h --
 *	Declarations for memory contexts.
 *
 * Identification:
 *	"$Header: /private/postgres/src/lib/H/utils/RCS/context.h,v 1.3 1990/08/17 08:54:06 cimarron Exp $"
 */

#ifndef ContextIncluded
#define ContextIncluded

#include "tmp/postgres.h"
#include "tmp/simplelists.h"

#define	MMGRSIZE	(1 << 16)

struct mchain {
	struct mchain	*mc_next;
	struct mchain	*mc_prev;
	char		*mc_name;	/* for tracing  */
	int		mc_len;		/* must be last */
/* 	int		mc_data[];	/* VARIABLE-LENGTH ARRAY */
};

struct memhead {
	short		mh_flags;
	short		mh_stacked;
	struct memhead	*mh_prev;	/* previous memory block */
	int		*mh_topfast;	/* end of memory block   */
	int		*mh_botfast;	/* beginning of memory block */
	struct mchain	mh_slow;	/* doubly-linked-list of slow memory */
};

struct context {
	SimpleNode	ct_node;	/* doubly linked list of context strs	*/
	int		ct_status;
	struct memhead	*ct_mh;		/* current memory block */
	struct context	*ct_prev;
	struct context	*ct_head;
	int		*ct_lmtfast;	/* end of ct_mmgr 		  */
	long		ct_allocated;	/* ttl bytes allocated in this ctx*/
	long		ct_fallocated;	/* just the fast memory		  */
	char		*ct_name;	/* name of context		  */
	int		ct_mmgr[MMGRSIZE];
};

#define	CT_VOLATILE	00	/* user space: ok to kill */
#define	CT_PRESERVE	01	/* permanent system space: don't kill */
#define	CT_BOOTSTRAP	02	/* for standalone programs */

/* XXX OBSOLETE */
struct xaction {
	OID		xa_user;
	struct	context	xa_topcxt;
};

extern struct xaction	Xact;
extern struct context	*TopContext;
extern struct context	*Curcxt;
extern struct memhead	*Curmem;
extern SimpleList	ContextList;

#define	ENABLE_BOOTSTRAP()	TopContext->ct_status |= CT_BOOTSTRAP
#define	DISABLE_BOOTSTRAP()	TopContext->ct_status &= ~CT_BOOTSTRAP

extern			initXact();
extern struct context 	*topcontext();
extern struct context 	*switchcontext();
extern struct context 	*newcontext();
extern struct context 	*newnamedcontext();
extern struct context 	*killcontext();

#endif	/* !ContextIncluded */
