#ifdef NOTDEF
Received: from bernina.ethz.ch by postgres.Berkeley.EDU (5.61/1.29)
	id AA17395; Fri, 8 Mar 91 05:47:50 -0800
Received: from neptune by bernina.ethz.ch with SMTP inbound id <29090-0@bernina.ethz.ch>; Fri, 8 Mar 1991 14:47:47 +0100
From: Michael Boehlen <boehlen@inf.ethz.ch>
Received: from crown (crown.inf.ethz.ch) by neptune.inf.ethz.ch id AA25978; Fri, 8 Mar 91 14:47:43 +0100
Message-Id: <9103081343.AA00272@crown>
Received: by crown id AA00272; Fri, 8 Mar 91 14:43:57 +0100
To: postgres@postgres.Berkeley.edu
Subject: integers are not properly handled in postgres (-> bget: no free buffers)
Date: Fri, 08 Mar 91 14:43:54 N

I asked you a few days ago what the error message
  'WARN:Mar  8 14:22:03:bget: no free buffers'
means. I think I've found the bug leading to this error message.

Consider the following situation:

relation edge    von            nach
                 ====================
                 1              2
                 2              3
                 3              4
                 4              5
                 2              7

relation weg     von            nach
                 ====================
                 1              2
                 2              3
                 3              4
                 4              5
                 2              7

I'm going to compute the transitive closure by iterating the following statement
sequence:

  retrieve into delta(von=edge.von,nach=weg.nach) where edge.nach=weg.von
  delete delta where delta.von=weg.von and delta.nach=weg.nach"
  append weg(delta.all)
  destroy delta

After about 5 iteration steps postgres crashes with the error message
  WARN:Mar  8 14:22:03:bget: no free buffers

Note: If I'm using type char16 (instead of int4) it works all right! I
guess you don't
      handle buffer deallocation the right way.

Will you fix this bug in the future?

Mike Boehlen

Below I included a copy of the program that leads to this bug

-------------------------------------------------------------------------
#endif

#include <stdio.h>
#include <string.h>
#include "tmp/libpq.h"

char* status;
int i=0;

main() {
  PQsetdb("test");
  while (i<30) {
    status = PQexec("retrieve into delta(von=edge.von,nach=weg.nach) \
                     where edge.nach=weg.von");
    printf("<<<PQexec status: %s>>>\n", status);
    if (*status == 'R') exit(0);

    status = PQexec("delete delta where delta.von=weg.von and delta.nach=weg.nach");
    printf("<<<PQexec status: %s>>>\n", status);
    if (*status == 'R') exit(0);

    status = PQexec("append weg(delta.all)");
    printf("<<<PQexec status: %s>>>\n", status);
    if (*status == 'R') exit(0);

    status = PQexec("destroy delta");
    printf("<<<PQexec status: %s>>>\n", status);
    if (*status == 'R') exit(0);

    i++;
    printf("Number of iterations: %i\n\n", i);
  }
}
