/*
 * Make an MSDOS volume label
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#include <sys/types.h>
#include <sys/fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#ifdef BSD
#include <sys/time.h>
#else /* BSD */
#include <time.h>
#endif /* BSD */
#include "msdos.h"

void
mlabel(argc, argv)
int argc;
char *argv[];
{
	int entry, slot, fargn, verbose, oops;
	char filename[30], drive;
	unsigned char fixed[12], vol[12];
	struct directory *dir;
	long now;

	fargn = 1;
	verbose = 0;
	oops = 0;
	if (argc > 1) {
		if (!strcmp(argv[1], "-v")) {
			fargn = 2;
			verbose = 1;
		}
		if (argv[1][0] == '-' && !verbose)
			oops++;
	}
	if (argc < 2 || argv[fargn][1] != ':' || oops) {
		fprintf(stderr, "Mtools version %s, dated %s\n", mversion, mdate);
		fprintf(stderr, "Usage: %s [-v] drive:\n", argv[0]);
		exit(1);
	}
	mcwd = fix_mcwd();

	drive = argv[fargn][0];
	if (islower(drive))
		drive = toupper(drive);

	if (init(drive, O_RDWR)) {
		fprintf(stderr, "%s: Cannot initialize '%c:'\n", argv[0], drive);
		exit(1);
	}
					/* see if a label exists and get slot */
	slot = -1;
	vol[0] = '\0';
	for (entry = 0; entry < dir_entries; entry++) {
		dir = dir_read(entry);
					/* if empty */
		if (dir->name[0] == 0x0) {
			if (slot < 0)
				slot = entry;
			break;
		}
					/* if erased */
		if (dir->name[0] == 0xe5) {
			if (slot < 0)
				slot = entry;
			continue;
		}
					/* if not a volume label */
		if (!(dir->attr & 0x08))
			continue;

		slot = entry;
		strncpy((char *) vol, (char *) dir->name, 8);
		vol[8] = '\0';
		strncat((char *) vol, (char *) dir->ext, 3);
		vol[11] = '\0';

		printf("Volume in drive %c is \"%s\"\n", drive, vol);
		break;
	}
	if (slot < 0) {
		fprintf(stderr, "%s: No directory slots\n", argv[0]);
		exit(1);
	}
	if (vol[0] == '\0')
		printf("Volume in drive %c is unlabeled\n", drive);

					/* ask for new label */
	printf("Enter the new volume label (11 characters): ");
	fflush(stdout);
	gets(filename);
	if (filename[0] != '\0') {
		sprintf((char *) fixed, "%-11.11s", filename);
		if (strlen(filename) > 11 && verbose)
			printf("New label is \"%s\"\n", fixed);
	}
	else {
		if (vol[0] == '\0')
			exit(0);
		if ( ask_confirmation("Delete volume label (y/n): "))
			exit(0);
		strcpy((char *) fixed, (char *) vol);
		fixed[0] = 0xe5;
	}
					/* make directory entry */
	time(&now);
	dir = mk_entry(fixed, 0x08, 0, 0L, now);
	dir_write(slot, dir);

	dir_flush();
	disk_flush();
	close(fd);
	exit(0);
}
