/***
 *** get/set VGAreg, a simple VGA register hacking program
 *** written by Koen Gadeyne (kmg@barco.be)
 ***
 *** version: 0.2
 ***
 *** WARNING: since different SVGA cards use different extra address ranges in any 
 *** of the register sets, no checking is done to make sure you don't attempt to change
 *** a non-existing register!
 ***
 *** This is just a hacking tool! Use at your own risk. It was NOT intended to be 
 *** idiot proof! If you don't understand all this, then don't bother trying to use it.
 ***
 ***/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "vga_prg.h"
#include "configfile.h"
#include "messages.h"

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (-1)
#endif

char *CommandName;
int debug_messages=FALSE;
const char *str_chipsets[NUM_CHIPSETS] = CHIPSET_STRINGS;
const char *str_regsets[NUM_REGSETS] = REGSET_STRINGS;
const int str_regset_type[NUM_REGSETS] = REGSET_TYPE;

void usage(int setreg)
{
     PMESSAGE(("usage: %s [options] VGA_register_set [register_index] %s\n
     Options: -n  Don't program VGA hardware
              -d  print debugging information
              -h  print usage information
              -u  unlock chipset-specific registers (needs %s file)
              
     VGA_register_set: any of %s
     register_index: an index in the specified VGA_register_set, 
                     either in decimal (e.g. '24') or hex ('0x18') notation.
                     Only needed when it is an indexed register.
     %s",
     CommandName, (setreg==TRUE) ? "data" : "", CONFIGFILE, showopts(str_regsets, NUM_REGSETS),
     (setreg==TRUE) ? "data: the data to program into the specified register.\n" : ""))
}


/***********************************************************************************************************/
 
int main (int argc, char* argv[])
{
  int chipset=-1;
  FILE* param_file;
  char tempstr[1024]="";
  int program_hardware=TRUE;
  int unlock_chipset=FALSE;
  int regset = -1;
  char c;
  unsigned char tmpbyte=0;
  int regnum=0;
  int setreg = FALSE; /* if TRUE: "getVGAreg" function, if FALSE, "setVGAreg" function */
  char* commandfilename;
  int data=0;
  
 /*
  * See what action is required: read or write VGA register
  */
    
  CommandName = argv[0];
  commandfilename = strchr(CommandName, '/'); commandfilename++;
  if (!strncasecmp(commandfilename,"set",3)) setreg = TRUE; 
  else setreg = FALSE;
  
 
 /*
  * command-line argument parsing
  */

  while ((c = getopt (argc, argv, "ndhu")) != EOF)
    switch (c)
    {
      case 'n': program_hardware=FALSE;
                break;
      case 'd': debug_messages=TRUE;
                break;
      case 'h': usage(setreg);
                exit(0);
                break;
      case 'u': unlock_chipset = TRUE;
                break;
      case '?': usage(setreg);
                PERROR(("Bad option '%s'\n",argv[optind-1]));
                exit(-1);
                break;
      default: PERROR(("getopt returned unknown token '%c'.",c));
    }

  PDEBUG(("'%cetVGAreg' function selected through command name '%s'", (setreg==TRUE) ? 's' : 'g', commandfilename));

  /* get register set from commandline */
  if (argc<optind+1) PERROR(("Missing register set on commandline"));
  regset = findoption(argv[optind], str_regsets, NUM_REGSETS, "register set");

  /* get register index, if an indexed register set was specified */
  if (str_regset_type[regset]==RT_INDEX)
  {
    optind++;
    if (argc<optind+1) PERROR(("Missing register index for '%s' register set", str_regsets[regset]));
    regnum = getbyte(argv[optind], "register number", 0, 255);
    PDEBUG(("register index = %d (0x%x).", regnum, regnum));
  }

  /* get register data, if 'set'VGAreg command */
  if (setreg==TRUE)
  {
    optind++;
    if (argc<optind+1) PERROR(("Missing register data"));
    data = getbyte(argv[optind], "register data", 0, 255);
    PDEBUG(("register data to write = %d (0x%x).", data, data));
  }
  optind++;  
  if (argc>optind) PWARNING(("Extra parameters (starting with '%s') ignored", argv[optind])); 
  

 /*
  * open parameter file if needed for unlocking chipset, use only chipset definition (until now)
  */
  if (unlock_chipset == TRUE)
  {
    param_file = open_param_file(CONFIGFILE);

    sscanf(findlabel(param_file, "ChipSet"), "%*s %s", tempstr);
    chipset = findoption(tempstr, str_chipsets, NUM_CHIPSETS, "chip set");
  }  

/*
 * start doing something usefull
 */
 
 if (program_hardware==TRUE)
  {
     get_VGA_io_perm();
     Renounce_SUID;
     if (unlock_chipset == TRUE) unlock(chipset); 
     if (str_regset_type[regset]==RT_INDEX)
     {
       if (setreg==TRUE) outb_VGA_indexed(regset, regnum, data);
       tmpbyte = inb_VGA_indexed(regset, regnum);
       printf("VGA '%s' register, index %d (=0x%x) contains %d (=0x%x)\n",str_regsets[regset], regnum, regnum, tmpbyte, tmpbyte);
     }
     else
     {
       if (setreg==TRUE) outb_VGA_mem(regset, data);
       tmpbyte = inb_VGA_mem(regset);
       printf("VGA '%s' register contains %d (=0x%x)\n",str_regsets[regset], tmpbyte, tmpbyte);
     }
  }
  return(0);
}
