/*
	Prototypes for the dot clock selection functions
*/

#if __STDC__
#define _Cdecl
#else
#define _Cdecl	cdecl
#endif

#ifdef __TURBOC__
#define _near  near
#endif
#ifdef __GNUC__
#define _near
#endif

#ifdef __cplusplus
extern "C" {
#endif

void	      _Cdecl setdotclock(void _near *ptr);
unsigned long _Cdecl setfreq	(unsigned long freq, unsigned quarz);

#ifdef __cplusplus
  }
#endif

extern unsigned _bin, _mul, _div, _gen;
extern unsigned long _value;

/* Available return values for SetDotClockFrequency() */

#define PCG_OK			0	/*  all is okay 	*/
#define PCG_WITHIN_1		0	/*  error within 1%	*/
#define PCG_WITHIN_2		1	/*  error within 2%	*/
#define PCG_WITHIN_3		2	/*  error within 3%	*/
#define PCG_WITHIN_4		3	/*  error within 4%	*/
#define PCG_WITHIN_5		4	/*  error within 5%	*/
#define PCG_WITHIN_6		5	/*  error within 6%	*/
#define PCG_WITHIN_7		6	/*  error within 7%	*/
#define PCG_WITHIN_8		7	/*  error within 8%	*/
#define PCG_WITHIN_9		8	/*  error within 9%	*/

#define PCG_TOO_INACCURATE     15	/*  error bigger than 15%	*/

#define PCG_NO_NUMBER	       16	/*  argument is not a number	*/
#define PCG_BAD_OPTION	       17	/*  bad option allocated	*/
#define PCG_TOO_HIGH	       18	/*  frequency is too high	*/
#define PCG_TOO_LOW	       19	/*  frequency is too low	*/

#define PCG_UNKNOWN	      127	/*  unknown cause		*/

/* End of Set.H */
