/*
 * arch/arm/mach-tegra/board-trimslice-pinmux.c
 *
 * Copyright (C) 2011 CompuLab, Ltd.
 * Copyright (c) 2012, NVIDIA CORPORATION.  All rights reserved.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#include <linux/kernel.h>

#include "board-trimslice.h"
#include "board-pinmux.h"

static struct pinctrl_map trimslice_map[] = {
	TEGRA_MAP_MUXCONF("ata",   "ide",           none, tristate),
	TEGRA_MAP_MUXCONF("atb",   "sdio4",         none, driven),
	TEGRA_MAP_MUXCONF("atc",   "nand",          none, tristate),
	TEGRA_MAP_MUXCONF("atd",   "gmi",           none, tristate),
	TEGRA_MAP_MUXCONF("ate",   "gmi",           none, tristate),
	TEGRA_MAP_MUXCONF("cdev1", "plla_out",      none, driven),
	TEGRA_MAP_MUXCONF("cdev2", "pllp_out4",     down, tristate),
	TEGRA_MAP_MUXCONF("crtp",  "crt",           none, tristate),
	TEGRA_MAP_MUXCONF("csus",  "vi_sensor_clk", down, tristate),
	TEGRA_MAP_MUXCONF("dap1",  "dap1",          none, driven),
	TEGRA_MAP_MUXCONF("dap2",  "dap2",          none, tristate),
	TEGRA_MAP_MUXCONF("dap3",  "dap3",          none, tristate),
	TEGRA_MAP_MUXCONF("dap4",  "dap4",          none, tristate),
	TEGRA_MAP_MUXCONF("ddc",   "i2c2",          up,   driven),
	TEGRA_MAP_MUXCONF("dta",   "vi",            none, tristate),
	TEGRA_MAP_MUXCONF("dtb",   "vi",            none, tristate),
	TEGRA_MAP_MUXCONF("dtc",   "vi",            none, tristate),
	TEGRA_MAP_MUXCONF("dtd",   "vi",            none, tristate),
	TEGRA_MAP_MUXCONF("dte",   "vi",            none, tristate),
	TEGRA_MAP_MUXCONF("dtf",   "i2c3",          up,   driven),
	TEGRA_MAP_MUXCONF("gma",   "sdio4",         none, driven),
	TEGRA_MAP_MUXCONF("gmb",   "nand",          none, tristate),
	TEGRA_MAP_MUXCONF("gmc",   "sflash",        none, driven),
	TEGRA_MAP_MUXCONF("gmd",   "sflash",        none, driven),
	TEGRA_MAP_MUXCONF("gme",   "gmi",           none, tristate),
	TEGRA_MAP_MUXCONF("gpu",   "uarta",         none, driven),
	TEGRA_MAP_MUXCONF("gpu7",  "rtck",          none, driven),
	TEGRA_MAP_MUXCONF("gpv",   "pcie",          none, driven),
	TEGRA_MAP_MUXCONF("hdint", "hdmi",          na,   tristate),
	TEGRA_MAP_MUXCONF("i2cp",  "i2cp",          none, tristate),
	TEGRA_MAP_MUXCONF("irrx",  "uartb",         up,   tristate),
	TEGRA_MAP_MUXCONF("irtx",  "uartb",         up,   tristate),
	TEGRA_MAP_MUXCONF("kbca",  "kbc",           up,   tristate),
	TEGRA_MAP_MUXCONF("kbcb",  "kbc",           up,   tristate),
	TEGRA_MAP_MUXCONF("kbcc",  "kbc",           up,   tristate),
	TEGRA_MAP_MUXCONF("kbcd",  "kbc",           up,   tristate),
	TEGRA_MAP_MUXCONF("kbce",  "kbc",           up,   tristate),
	TEGRA_MAP_MUXCONF("kbcf",  "kbc",           up,   tristate),
	TEGRA_MAP_MUXCONF("lcsn",  "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("ld0",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld1",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld10",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld11",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld12",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld13",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld14",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld15",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld16",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld17",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld2",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld3",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld4",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld5",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld6",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld7",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld8",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ld9",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("ldc",   "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("ldi",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lhp0",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lhp1",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lhp2",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lhs",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lm0",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lm1",   "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("lpp",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lpw0",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lpw1",  "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("lpw2",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lsc0",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lsc1",  "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("lsck",  "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("lsda",  "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("lsdi",  "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("lspi",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lvp0",  "displaya",      na,   tristate),
	TEGRA_MAP_MUXCONF("lvp1",  "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("lvs",   "displaya",      na,   driven),
	TEGRA_MAP_MUXCONF("owc",   "rsvd2",         up,   tristate),
	TEGRA_MAP_MUXCONF("pmc",   "pwr_on",        na,   tristate),
	TEGRA_MAP_MUXCONF("pta",   "gmi",           none, tristate),
	TEGRA_MAP_MUXCONF("rm",    "i2c1",          up,   driven),
	TEGRA_MAP_MUXCONF("sdb",   "pwm",           na,   driven),
	TEGRA_MAP_MUXCONF("sdc",   "pwm",           up,   driven),
	TEGRA_MAP_MUXCONF("sdd",   "pwm",           up,   driven),
	TEGRA_MAP_MUXCONF("sdio1", "sdio1",         none, driven),
	TEGRA_MAP_MUXCONF("slxa",  "pcie",          none, driven),
	TEGRA_MAP_MUXCONF("slxc",  "sdio3",         none, tristate),
	TEGRA_MAP_MUXCONF("slxd",  "sdio3",         none, tristate),
	TEGRA_MAP_MUXCONF("slxk",  "pcie",          none, driven),
	TEGRA_MAP_MUXCONF("spdi",  "spdif",         none, tristate),
	TEGRA_MAP_MUXCONF("spdo",  "spdif",         none, tristate),
	TEGRA_MAP_MUXCONF("spia",  "spi2",          down, tristate),
	TEGRA_MAP_MUXCONF("spib",  "spi2",          down, tristate),
	TEGRA_MAP_MUXCONF("spic",  "spi2",          up,   tristate),
	TEGRA_MAP_MUXCONF("spid",  "spi1",          down, tristate),
	TEGRA_MAP_MUXCONF("spie",  "spi1",          up,   tristate),
	TEGRA_MAP_MUXCONF("spif",  "spi1",          down, tristate),
	TEGRA_MAP_MUXCONF("spig",  "spi2_alt",      up,   tristate),
	TEGRA_MAP_MUXCONF("spih",  "spi2_alt",      up,   tristate),
	TEGRA_MAP_MUXCONF("uaa",   "ulpi",          up,   tristate),
	TEGRA_MAP_MUXCONF("uab",   "ulpi",          up,   tristate),
	TEGRA_MAP_MUXCONF("uac",   "rsvd2",         none, driven),
	TEGRA_MAP_MUXCONF("uad",   "irda",          up,   tristate),
	TEGRA_MAP_MUXCONF("uca",   "uartc",         up,   tristate),
	TEGRA_MAP_MUXCONF("ucb",   "uartc",         up,   tristate),
	TEGRA_MAP_MUXCONF("uda",   "ulpi",          none, tristate),
	TEGRA_MAP_CONF("ck32",    none, na),
	TEGRA_MAP_CONF("ddrc",    none, na),
	TEGRA_MAP_CONF("pmca",    none, na),
	TEGRA_MAP_CONF("pmcb",    none, na),
	TEGRA_MAP_CONF("pmcc",    none, na),
	TEGRA_MAP_CONF("pmcd",    none, na),
	TEGRA_MAP_CONF("pmce",    none, na),
	TEGRA_MAP_CONF("xm2c",    none, na),
	TEGRA_MAP_CONF("xm2d",    none, na),
	TEGRA_MAP_CONF("ls",      up,   na),
	TEGRA_MAP_CONF("lc",      up,   na),
	TEGRA_MAP_CONF("ld17_0",  down, na),
	TEGRA_MAP_CONF("ld19_18", down, na),
	TEGRA_MAP_CONF("ld21_20", down, na),
	TEGRA_MAP_CONF("ld23_22", down, na),
};

static struct tegra_board_pinmux_conf conf = {
	.maps = trimslice_map,
	.map_count = ARRAY_SIZE(trimslice_map),
};

void trimslice_pinmux_init(void)
{
	tegra_board_pinmux_init(&conf, NULL);
}
