//: c08:MultiImplementation.java
// With concrete or abstract classes, inner 
// classes are the only way to produce the effect
// of "multiple implementation inheritance."
// {ThrowsException}
package c08;
import com.bruceeckel.simpletest.*;

class C {}
abstract class D {}

class Z extends C {
  D makeD() { return new D() {}; }
} 

public class MultiImplementation {
  static void takesC(C c) {}
  static void takesD(D d) {}
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("c08.MultiImplementation");
    Z z = new Z();
    takesC(z);
    takesD(z.makeD());
    monitor.expect(new String[] {});
  }
} ///:~