//: X1:SimpleTestTest.java
// A set of unit tests for the testing 
// framework class SimpleTest
// {Depends: junit.jar}
// {Broken}
import java.io.*;
import com.bruceeckel.simpletest.*;
import java.util.*;

import junit.framework.*;
public class SimpleTestTest
  extends TestCase {
  private List output = null;
  private boolean endOfLine = true;
  private SimpleTest monitor;
  // Initialize primitive types
  static final boolean b = true;
  static final char c = 'm';
  static final int i = 200;
  static final long l = 123456789012345L;
  static final float f = 1.234f;
  static final double d = 1.234567e-50d;
  static final char[] s = new char[] {
    'c', 'h', 'a', 'r', 'a', 'r', 'r', 'a', 'y'
  };
  static final String str = new String("string");
  static final Object o = new Date();

  public SimpleTestTest(String name) {
    super(name);
  }

  protected void setUp() {
    monitor = new SimpleTest("SimpleTestTest");
  }
  protected void tearDown() {
    monitor.cleanup();
  }
  public void testExpectNoArgs() {
    generateRandomOutput();
    // Dump output to StringWriter
    StringWriter sw = new StringWriter();
    monitor.expect(sw);
    // Transfer content of 
    // String[] output into StringWriter
    StringWriter expOutput = new StringWriter();
    Iterator it = output.iterator();
    while (it.hasNext())
      expOutput.write((String)it.next() + '\n');
    // Test if StringWriters match
    assertEquals(sw.toString(), expOutput.toString());
  }
  private void addToOutput(String s) {
    if (endOfLine)
      output.add(s);
    else {
      String str = 
        (String)output.remove(output.size() - 1);
      output.add(str.concat(s));
    }
  }
  private void generateRandomOutput() {
    output = new ArrayList();
    endOfLine = true;
    for (int i = 0; i < 100; i++) {
      int choice = (int)(Math.random() * 19);
      switch (choice) {
        case 0:
          System.out.println(b);
          addToOutput(b ? "true" : "false");
          if (!endOfLine)
            endOfLine = true;
          break;
        case 1:
          System.out.println(c);
          addToOutput(String.valueOf(c));
          if (!endOfLine)
            endOfLine = true;
          break;
        case 2:
          System.out.println(i);
          addToOutput(String.valueOf(i));
          if (!endOfLine)
            endOfLine = true;
          break;
        case 3:
          System.out.println(l);
          addToOutput(String.valueOf(l));
          if (!endOfLine)
            endOfLine = true;
          break;
        case 4:
          System.out.println(f);
          addToOutput(String.valueOf(f));
          if (!endOfLine)
            endOfLine = true;
          break;
        case 5:
          System.out.println(d);
          addToOutput(String.valueOf(d));
          if (!endOfLine)
            endOfLine = true;
          break;
        case 6:
          System.out.println(s);
          addToOutput(String.valueOf(s));
          if (!endOfLine)
            endOfLine = true;
          break;
        case 7:
          System.out.println(str);
          addToOutput(str);
          if (!endOfLine)
            endOfLine = true;
          break;
        case 8:
          System.out.println(o);
          addToOutput(String.valueOf(o));
          if (!endOfLine)
            endOfLine = true;
          break;
        case 9:
          System.out.println();
          if (endOfLine)
            output.add(new String(""));
          else
            endOfLine = true;
          break;
        case 10:
          System.out.print(b);
          addToOutput(b ? "true" : "false");
          if (endOfLine)
            endOfLine = false;
          break;
        case 11:
          System.out.print(c);
          addToOutput(String.valueOf(c));
          if (endOfLine)
            endOfLine = false;
          break;
        case 12:
          System.out.print(i);
          addToOutput(String.valueOf(i));
          if (endOfLine)
            endOfLine = false;
          break;
        case 13:
          System.out.print(l);
          addToOutput(String.valueOf(l));
          if (endOfLine)
            endOfLine = false;
          break;
        case 14:
          System.out.print(f);
          addToOutput(String.valueOf(f));
          if (endOfLine)
            endOfLine = false;
          break;
        case 15:
          System.out.print(d);
          addToOutput(String.valueOf(d));
          if (endOfLine)
            endOfLine = false;
          break;
        case 16:
          System.out.print(s);
          addToOutput(String.valueOf(s));
          if (endOfLine)
            endOfLine = false;
          break;
        case 17:
          System.out.print(str);
          addToOutput(str);
          if (endOfLine)
            endOfLine = false;
          break;
        case 18:
          System.out.print(o);
          addToOutput(String.valueOf(o));
          if (endOfLine)
            endOfLine = false;
          break;
      }
    }
  }
  public void testExpect() {
    generateRandomOutput();
    monitor.expect(
        (String[])output.toArray(new String[] {  }));
    // Stop one line short of expected output
    Iterator it = output.iterator();
    String line = null;
    while (it.hasNext()) {
      line = (String)it.next();
      if (it.hasNext())
        System.out.println(line);
      else
        break;
    }
    if (line != null) {
      try {
        monitor.expect(
            (String[])output.toArray(new String[] {  }));
        fail("Should raise a RuntimeException");
      } catch (RuntimeException e) {
      }
      // Finish printing expected output
      System.out.println(line);
      monitor.expect(
          (String[])output.toArray(new String[] {  }));
    }
    //Print one extra line
    it = output.iterator();
    while (it.hasNext())
      System.out.println(it.next());
    System.out.println(o);
    try {
      monitor.expect(
          (String[])output.toArray(new String[] {  }));
      fail("Should raise a RuntimeException");
    } catch (RuntimeException e) {
    }
  }
  public void testExpectIgnoreOrder() {
    generateRandomOutput();
    // Change order of Strings (lines) in output
    int i = (int)(Math.random() * output.size());
    int j = 0;
    while ((j = (int)(Math.random()*output.size())) == i)
      ;
    output.add(i, output.remove(j));
    // expect() method should fail
    try {
      monitor.expect(
          (String[])output.toArray(new String[] {  }));
      fail("Should raise a RuntimeException");
    } catch (RuntimeException e) {
    }
    // Test if all of the output lines appear 
    // in the expected output, regardless of order
    monitor.expectIgnoreOrder(
        (String[])output.toArray(new String[] {  }));
  }
  public static void main(String[] args) {
    junit.textui.TestRunner.run(SimpleTestTest.class);
  }
} ///:~