/* scantron for surveys control program
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

#include <stdio.h>
#include "Capa/capaCommon.h"
#include "bubbler.h"
#include <ctype.h>

#ifdef   F_DBUG
extern FILE *dfp; 
#endif

int main()
{
  T_entry grade;
  FILE * inputFile, * outputFile;
  int i=0,setnumber,score,section,setId,done=0,numQuestions;
  char class[10],set[3],name[MAX_NAME_CHAR+1],buf,buffmt[128],
      studentnumber[MAX_STUDENT_NUMBER+1],filename[128];
  int q=0,r=0,answer[MAXQUEST][11];
  Question questions[MAXQUEST];
  
  printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
  printf("Covert form Bubbler output to survey results ");
  printf("Version 0.1.00\n");
  printf("Please enter the Set Id number.");
  scanf("%d",&setId);
  sprintf(filename,"bubbler.output.%d",setId);
  inputFile=fopen(filename,"r");

  if (inputFile==NULL)
    {
      fprintf(stderr,"%s not found\n",filename);
      exit(-1);
    }

  fscanf(inputFile,"%s %s",class,set);
  printf("%s %s\n",class,set);
  setnumber=atoi(set);

  i=0;
  fscanf(inputFile,"%c",&buf);
  while(!done)
    {
      buf=fgetc(inputFile);
      if (buf!='\n')
	{
	  questions[i].type=buf;
	  buf=fgetc(inputFile);
	  questions[i].points=questions[i].leafs=(int)(buf-'0');
	  i++;
	}
      else
	{
	  done=1;
	}
    }
  
  numQuestions=i;

  for(q=0;q<MAXQUEST;q++)
    for(r=0;r<11;r++)
      answer[q][r]=0;

  printf("Processing");
  while(fscanf(inputFile,"%9c",studentnumber)!=EOF)
    {
      printf(".");
      fflush(stdout);
      fscanf(inputFile,"%32c",name);
      sprintf(buffmt,"%%%dc",numQuestions);
      fscanf(inputFile,buffmt,grade.answers);
      fscanf(inputFile,"%d",&score);
      fscanf(inputFile,"%d",&section);
      buf='\0';
      while(buf!='\n')
	{
	  buf=fgetc(inputFile);
	}
#ifdef DEBUG
      printf("%d %d\n",numQuestions,strlen(grade.answers));
#endif /*DEBUG*/
      for(i=0;i<numQuestions;i++)
	{
	  switch(questions[i].type)
	    {
	    case 'a':
	    case 'f':
	    case 'g':
	    case 'b':
	    case 'c':
	    case 'e':
	    case 'd':
	      if (isdigit(grade.answers[i]))
		answer[i][grade.answers[i]-'0']++;
	      else if(isspace(grade.answers[i]))
		{
		  answer[i][10]++;
		}
	      break;
	    default:
	      printf("Unknown question type\n");
	      break;
	    }
	}
      grade.answers[i]='\0';
#ifdef DEBUG
      printf("%s\n",studentnumber);
#endif /*DEBUG*/
    }

  sprintf(filename,"survey.%d",setId);
  outputFile=fopen(filename,"w");
  if (outputFile==NULL)
    {
      fprintf(stderr,"%s not found\n",filename);
      exit(-1);
    }

  fprintf(outputFile,"Survey results for class: %s\n\n",class);
  for(q=0;q<numQuestions;q++)
    {
      fprintf(outputFile,"Question: %d\n",q+1);
      fprintf(outputFile,"  0   1   2   3   4   5   6   7   8   9   S\n");
      for(r=0;r<11;r++)
	{
	  fprintf(outputFile,"%3d ",answer[q][r]);
	}
      fprintf(outputFile,"\n");
    }
  printf("\nProcessing completed. Look in survey.%d for results.\n",
	 setId);
  return 0;
}
