
;;; tes-mode.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: tes-mode.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: tes-mode functionality
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun tes-mode ()
  (interactive)
  (fundamental-mode)
  (setq major-mode 'tes-mode)
  (setq mode-name "TES")
  (local-set-key "\t" 'd-latex--tab-key)
  (local-set-key [(return)] 'd-latex--tes-enter)
  (local-set-key [(meta control \\)] 'd-latex--meta-control-backslash)
  (d-font-lock-add-end
   `(
     ("\\\\hrule\\>"         0 'bold nil)
     ("\\\\hspace\\>"        0 'bold nil)
     ("\\\\thispagestyle\\>" 0 'bold nil)
     ("\\\\usepackage\\>"    0 'bold nil)
     ("\\\\thispagestyle\\>" 0 'bold nil)
     ("\\\\\\(color\\|phantom\\|pagebreak\\|vspace\\|hypersetup\\|scalebox\\|includegraphics\\|linewidth\\)\\>" 0 'bold nil)
     (,(concat "\\(\\<m4" "_dnl\\>\\)\\(.*\\)$") (1 'd-face-m4-dnl t) (2 'font-lock-comment-face t))
     ("\\\\color{\\(red\\)}"   1 'fg:lightred nil)
     ("\\\\color{\\(green\\)}" 1 'fg:lightgreen nil)
     ("\\\\color{\\(blue\\)}"  1 'fg:lightblue nil)
     ("@node \\(.*$\\)"    1 'font-lock-function-name-face nil)
     ("@chapter \\(.*$\\)" 1 'font-lock-function-name-face nil)
     ("@section \\(.*$\\)" 1 'font-lock-function-name-face nil)
     ("@\\*"                 0 'fg:lightred nil)
     ))
  )

(defun d-latex--tes-enter ()
  (interactive)
  (insert "\n"))

(provide 'tes-mode)

