/* LocaleInformation_id.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_id extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "IDR";

  private static final String currenciesDisplayNameValues = "IDR";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "IDR";

  private static final String currenciesSymbolValues = "Rp";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "Mei",
    "Jun",
    "Jul",
    "Agu",
    "Sep",
    "Okt",
    "Nov",
    "Des",
    null,
  };

  private static final String[] months = {
    "Januari",
    "Februari",
    "Maret",
    "April",
    "Mei",
    "Juni",
    "Juli",
    "Agustus",
    "September",
    "Oktober",
    "November",
    "Desember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Min",
    "Sen",
    "Sel",
    "Rab",
    "Kam",
    "Jum",
    "Sab",
  };

  private static final String[] weekdays = {
    null,
    "Minggu",
    "Senin",
    "Selasa",
    "Rabu",
    "Kamis",
    "Jumat",
    "Sabtu",
  };

  private static final String territoriesKeys = "TK\u00A6TJ\u00A6TH\u00A6TG\u00A6GY\u00A6TD\u00A6GW\u00A6GU\u00A6GT\u00A6GS\u00A6GR\u00A6GQ\u00A6GP\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6GL\u00A6SV\u00A6ST\u00A6GI\u00A6GH\u00A6SR\u00A6GF\u00A6GE\u00A6SO\u00A6GD\u00A6SN\u00A6SM\u00A6GB\u00A6SL\u00A6GA\u00A6SK\u00A6SJ\u00A6SI\u00A6SH\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SB\u00A6SA\u00A6FR\u00A6FO\u00A6FM\u00A6RW\u00A6FK\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6RE\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6DO\u00A6PY\u00A6DM\u00A6PW\u00A6DK\u00A6DJ\u00A6PT\u00A6PS\u00A6PR\u00A6DE\u00A6PN\u00A6PM\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6PF\u00A6CZ\u00A6PE\u00A6CY\u00A6CX\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CK\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6CD\u00A6CC\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BV\u00A6BT\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BM\u00A6NU\u00A6BJ\u00A6BI\u00A6BH\u00A6NR\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6NF\u00A6AZ\u00A6NE\u00A6NC\u00A6AW\u00A6ZM\u00A6NA\u00A6AU\u00A6AT\u00A6AS\u00A6AR\u00A6AQ\u00A6MZ\u00A6AO\u00A6MY\u00A6AN\u00A6MX\u00A6AM\u00A6MW\u00A6AL\u00A6MV\u00A6ZA\u00A6MU\u00A6MT\u00A6AI\u00A6MS\u00A6MR\u00A6AG\u00A6MQ\u00A6AF\u00A6MP\u00A6AE\u00A6MO\u00A6AD\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6YU\u00A6YT\u00A6MH\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LC\u00A6LB\u00A6LA\u00A6KZ\u00A6KY\u00A6KW\u00A6KR\u00A6KP\u00A6KN\u00A6KM\u00A6KI\u00A6WS\u00A6KH\u00A6KG\u00A6KE\u00A6WF\u00A6JP\u00A6JO\u00A6JM\u00A6VU\u00A6VN\u00A6VI\u00A6VG\u00A6VE\u00A6VC\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6HM\u00A6TW\u00A6TV\u00A6HK\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "Tokelau\u00A6Tajikistan\u00A6Thailand\u00A6Togo\u00A6Guyana\u00A6Chad\u00A6Guinea-Bissau\u00A6Guam\u00A6Guatemala\u00A6Georgia Selatan dan Kepulauan Sandwich Selatan\u00A6Yunani\u00A6Guinea Khatulistiwa\u00A6Guadeloupe\u00A6Swaziland\u00A6Syria\u00A6Guinea\u00A6Gambia\u00A6Greenland\u00A6El Salvador\u00A6Sao Tome dan Principe\u00A6Gibraltar\u00A6Ghana\u00A6Suriname\u00A6Guyana Perancis\u00A6Georgia\u00A6Somalia\u00A6Grenada\u00A6Senegal\u00A6San Marino\u00A6Inggris Raya\u00A6Sierra Leone\u00A6Gabon\u00A6Slovakia\u00A6Svalbard dan Jan Mayen\u00A6Slovenia\u00A6Saint Helena\u00A6Singapura\u00A6Sweden\u00A6Sudan\u00A6Seychelles\u00A6Kepulauan Solomon\u00A6Arab Saudi\u00A6Perancis\u00A6Kepulauan Faroe\u00A6Mikronesia\u00A6Rwanda\u00A6Kepulauan Falkland\u00A6Rusia\u00A6Fiji\u00A6Finlandia\u00A6Romania\u00A6R\u00e9union\u00A6Ethiopia\u00A6Spanyol\u00A6Eritrea\u00A6Sahara Barat\u00A6Mesir\u00A6Estonia\u00A6Ekuador\u00A6Algeria\u00A6Qatar\u00A6Republik Dominika\u00A6Paraguay\u00A6Dominika\u00A6Palau\u00A6Denmark\u00A6Jibouti\u00A6Portugis\u00A6Otoritas Palestina\u00A6Puerto Riko\u00A6Jerman\u00A6Pitcairn\u00A6Saint Pierre dan Miquelon\u00A6Polandia\u00A6Pakistan\u00A6Filipina\u00A6Papua Nugini\u00A6Polynesia Perancis\u00A6Republik Ceko\u00A6Peru\u00A6Siprus\u00A6Pulau Christmas\u00A6Tanjung Verde\u00A6Panama\u00A6Kuba\u00A6Kosta Rika\u00A6Kolombia\u00A6Cina\u00A6Kamerun\u00A6Chili\u00A6Kepulauan Cook\u00A6Pantai Gading\u00A6Swiss\u00A6Kongo\u00A6Republik Afrika Tengah\u00A6Republik Demokratik Kongo\u00A6Kepulauan Cocos\u00A6Oman\u00A6Kanada\u00A6Belize\u00A6Belarusia\u00A6Botswana\u00A6Kepulauan Bouvet\u00A6Bhutan\u00A6Bahamas\u00A6Brazil\u00A6Selandia Baru\u00A6Bolivia\u00A6Brunei\u00A6Bermuda\u00A6Niue\u00A6Benin\u00A6Burundi\u00A6Bahrain\u00A6Nauru\u00A6Bulgaria\u00A6Burkina Faso\u00A6Nepal\u00A6Belgia\u00A6Norwegia\u00A6Bangladesh\u00A6Barbados\u00A6Zimbabwe\u00A6Netherlands\u00A6Bosnia dan Herzegovina\u00A6Nicaragua\u00A6Nigeria\u00A6Kepulauan Norfolk\u00A6Azerbaijan\u00A6Niger\u00A6Kaledonia Baru\u00A6Aruba\u00A6Zambia\u00A6Namibia\u00A6Australia\u00A6Austria\u00A6Samoa Amerika\u00A6Argentina\u00A6Antarktika\u00A6Mozambique\u00A6Angola\u00A6Malaysia\u00A6Antilles Belanda\u00A6Mexico\u00A6Armenia\u00A6Malawi\u00A6Albania\u00A6Maldives\u00A6Afrika Selatan\u00A6Mauritius\u00A6Malta\u00A6Anguilla\u00A6Montserrat\u00A6Mauritania\u00A6Antigua dan Barbuda\u00A6Martinique\u00A6Afghanistan\u00A6Kepualuan Mariana Utara\u00A6Uni Emirat Arab\u00A6Makao S.A.R. Cina\u00A6Andora\u00A6Mongolia\u00A6Myanmar\u00A6Mali\u00A6Macedonia\u00A6Yugoslavia\u00A6Mayotte\u00A6Kepulauan Marshall\u00A6Madagaskar\u00A6Moldova\u00A6Monaco\u00A6Maroko\u00A6Yaman\u00A6Libya\u00A6Latvia\u00A6Luxembourg\u00A6Lithuania\u00A6Lesotho\u00A6Liberia\u00A6Sri Lanka\u00A6Liechtenstein\u00A6Santa Lusia\u00A6Lebanon\u00A6Laos\u00A6Kazakhstan\u00A6Kepulauan Kayman\u00A6Kuwait\u00A6Korea Selatan\u00A6Korea Utara\u00A6Saint Kitts dan Nevis\u00A6Komoros\u00A6Kiribati\u00A6Samoa\u00A6Kamboja\u00A6Kyrgyzstan\u00A6Kenya\u00A6Wallis dan Futuna\u00A6Jepang\u00A6Yordania\u00A6Jamaika\u00A6Vanuatu\u00A6Vietnam\u00A6Kepulauan U.S. Virgin\u00A6Kepulauan British Virgin\u00A6Venezuela\u00A6Saint Vincent dan Grenadines\u00A6Vatikan\u00A6Itali\u00A6Islandia\u00A6Iran\u00A6Iraq\u00A6Uzbekistan\u00A6Uruguay\u00A6India\u00A6Israel\u00A6Amerika Serikat\u00A6Irlandia\u00A6Indonesia\u00A6Uganda\u00A6Ukraina\u00A6Hungaria\u00A6Haiti\u00A6Kroasia\u00A6Tanzania\u00A6Honduras\u00A6Pulau Heard dan Kepulauan McDonald\u00A6Taiwan\u00A6Tuvalu\u00A6Hong Kong S.A.R., Cina\u00A6Trinidad dan Tobago\u00A6Turkey\u00A6Tonga\u00A6Tunisia\u00A6Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ast\u00A6lb\u00A6la\u00A6xh\u00A6ky\u00A6kw\u00A6kv\u00A6ku\u00A6ks\u00A6kr\u00A6ko\u00A6kn\u00A6km\u00A6kl\u00A6kk\u00A6kj\u00A6ki\u00A6kg\u00A6grc\u00A6wo\u00A6art\u00A6ka\u00A6gem\u00A6arn\u00A6afa\u00A6jv\u00A6wa\u00A6arc\u00A6cel\u00A6vo\u00A6ja\u00A6vi\u00A6ve\u00A6it\u00A6is\u00A6uz\u00A6io\u00A6ik\u00A6ii\u00A6ur\u00A6ig\u00A6kos\u00A6ie\u00A6id\u00A6ia\u00A6uk\u00A6kok\u00A6ug\u00A6hz\u00A6hy\u00A6got\u00A6hu\u00A6phi\u00A6hr\u00A6ho\u00A6ty\u00A6apa\u00A6tw\u00A6fur\u00A6goh\u00A6tt\u00A6hi\u00A6ts\u00A6tr\u00A6cop\u00A6he\u00A6tn\u00A6tl\u00A6ha\u00A6tk\u00A6ti\u00A6ace\u00A6th\u00A6tg\u00A6te\u00A6gv\u00A6ta\u00A6syr\u00A6gu\u00A6map\u00A6bug\u00A6mak\u00A6gn\u00A6sw\u00A6gl\u00A6sv\u00A6su\u00A6enm\u00A6ss\u00A6mad\u00A6sr\u00A6sq\u00A6so\u00A6gd\u00A6sn\u00A6sm\u00A6sl\u00A6ga\u00A6sk\u00A6si\u00A6sh\u00A6sg\u00A6se\u00A6fy\u00A6sd\u00A6sc\u00A6sa\u00A6cau\u00A6ang\u00A6car\u00A6fr\u00A6fo\u00A6rw\u00A6gmh\u00A6ru\u00A6fj\u00A6cai\u00A6fi\u00A6ff\u00A6ro\u00A6rn\u00A6rm\u00A6fa\u00A6peo\u00A6lez\u00A6eu\u00A6et\u00A6es\u00A6eo\u00A6en\u00A6el\u00A6qu\u00A6jrb\u00A6fro\u00A6frm\u00A6ee\u00A6mkh\u00A6dz\u00A6dv\u00A6alg\u00A6pt\u00A6ps\u00A6de\u00A6pl\u00A6da\u00A6pi\u00A6sux\u00A6jpr\u00A6cy\u00A6akk\u00A6cv\u00A6pa\u00A6cs\u00A6cr\u00A6co\u00A6mis\u00A6os\u00A6ch\u00A6or\u00A6ce\u00A6om\u00A6ca\u00A6oj\u00A6bs\u00A6br\u00A6gil\u00A6bo\u00A6ny\u00A6bn\u00A6bm\u00A6nv\u00A6bi\u00A6bh\u00A6bg\u00A6be\u00A6no\u00A6nn\u00A6nl\u00A6ba\u00A6zu\u00A6ng\u00A6az\u00A6ne\u00A6ay\u00A6nb\u00A6av\u00A6na\u00A6aus\u00A6as\u00A6ar\u00A6zh\u00A6my\u00A6am\u00A6ak\u00A6za\u00A6paa\u00A6mt\u00A6ms\u00A6mr\u00A6af\u00A6ae\u00A6mo\u00A6haw\u00A6mn\u00A6ab\u00A6ml\u00A6aa\u00A6mk\u00A6chk\u00A6mi\u00A6mh\u00A6mg\u00A6mga\u00A6yo\u00A6egy\u00A6yi\u00A6bat\u00A6lv\u00A6ath\u00A6lu\u00A6lt\u00A6ban\u00A6lo\u00A6ln\u00A6bai\u00A6li\u00A6lg";

  private static final String languagesValues = "Astur\u00A6Luxembourg\u00A6Latin\u00A6Xhosa\u00A6Kirghiz\u00A6Cornish\u00A6Komi\u00A6Kurdi\u00A6Kashmir\u00A6Kanuri\u00A6Korea\u00A6Kannada\u00A6Khmer\u00A6Kalaallisut\u00A6Kazakh\u00A6Kuanyama\u00A6Kikuyu\u00A6Kongo\u00A6Yunani Kuno (sd 1453)\u00A6Wolof\u00A6Buatan (Lainnya)\u00A6Georgian\u00A6Jermanik (Lainnya)\u00A6Araucan\u00A6Afro-Asiatik (Lainnya)\u00A6Jawa\u00A6Walloon\u00A6Aram\u00A6Celtic (Lainnya)\u00A6Volap\u00fck\u00A6Japanese\u00A6Vietnamese\u00A6Venda\u00A6Italian\u00A6Icelandic\u00A6Uzbek\u00A6Ido\u00A6Inupiaq\u00A6Sichuan Yi\u00A6Urdu\u00A6Igbo\u00A6Kosrae\u00A6Interlingue\u00A6Bahasa Indonesia\u00A6Interlingua\u00A6Ukrainian\u00A6Konkani\u00A6Uighur\u00A6Herero\u00A6Armenia\u00A6Gothik\u00A6Hungaria\u00A6Filipina (Lainnya)\u00A6Kroasia\u00A6Hiri Motu\u00A6Tahitian\u00A6Bahasa-bahasa Apache\u00A6Twi\u00A6Friuli\u00A6Jerman Kuno (kl.750-1050)\u00A6Tatar\u00A6Hindi\u00A6Tsonga\u00A6Turkish\u00A6Koptik\u00A6Ibrani\u00A6Tswana\u00A6Tagalog\u00A6Hausa\u00A6Turkmen\u00A6Tigrinya\u00A6Aceh\u00A6Thai\u00A6Tajik\u00A6Telugu\u00A6Manx\u00A6Tamil\u00A6Syria\u00A6Gujarati\u00A6Austronesia\u00A6Bugis\u00A6Makassar\u00A6Guarani\u00A6Swahili\u00A6Gallegan\u00A6Swedia\u00A6Sundan\u00A6Inggris, Abad Pertengahan (1100-1500)\u00A6Swati\u00A6Madura\u00A6Serbian\u00A6Albanian\u00A6Somali\u00A6Gaelik Skotlandia\u00A6Shona\u00A6Samoan\u00A6Slovenian\u00A6Irlandia\u00A6Slovak\u00A6Sinhalese\u00A6Serbo-Croatian\u00A6Sango\u00A6Northern Sami\u00A6Frisi\u00A6Sindhi\u00A6Sardinian\u00A6Sanskrit\u00A6Kaukasia (Lainnya)\u00A6Inggris Kuno (kl.450-1100)\u00A6Karib\u00A6Perancis\u00A6Faro\u00A6Kinyarwanda\u00A6Jerman, Abad Pertengahan (kl.1050-1500)\u00A6Russian\u00A6Fiji\u00A6India Amerika Tengah (Lainnnya)\u00A6Finlandia\u00A6Fulah\u00A6Romanian\u00A6Rundi\u00A6Rhaeto-Romance\u00A6Persia\u00A6Persia Kuno (kl.600-400 SM.)\u00A6Lezghia\u00A6Basque\u00A6Estonian\u00A6Spanyol\u00A6Esperanto\u00A6Inggris\u00A6Yunani\u00A6Quechua\u00A6Judeo-Arab\u00A6Perancis Kuno (842-kl.1400)\u00A6Perancis, Abad Pertengahan (kl.1400-1600)\u00A6Ewe\u00A6Mon-Khmer (Lainnya)\u00A6Dzongkha\u00A6Divehi\u00A6Bahasa Algonquia\u00A6Portugis\u00A6Pashto (Pushto)\u00A6Jerman\u00A6Polish\u00A6Denmark\u00A6Pali\u00A6Sumeria\u00A6Judeo-Persia\u00A6Welsh\u00A6Akkadien\u00A6Chuvash\u00A6Punjabi\u00A6Ceko\u00A6Cree\u00A6Korsika\u00A6Bahasa Lain-lain\u00A6Ossetic\u00A6Chamorro\u00A6Oriya\u00A6Chechen\u00A6Oromo\u00A6Catalan\u00A6Ojibwa\u00A6Bosnia\u00A6Breton\u00A6Gilbert\u00A6Tibet\u00A6Nyanja; Chichewa; Chewa\u00A6Bengal\u00A6Bambara\u00A6Navajo\u00A6Bislama\u00A6Bihari\u00A6Bulgaria\u00A6Belarusia\u00A6Norwegian\u00A6Norwegian Nynorsk\u00A6Belanda\u00A6Bashkir\u00A6Zulu\u00A6Ndonga\u00A6Azerbaijan\u00A6Nepal\u00A6Aymara\u00A6Norwegian Bokm\u00e5l\u00A6Avarik\u00A6Nauru\u00A6Bahasa-bahasa Australia\u00A6Assam\u00A6Arab\u00A6Cina\u00A6Burma\u00A6Amharik\u00A6Akan\u00A6Zhuang\u00A6Papuan (Lainnya)\u00A6Maltese\u00A6Malay\u00A6Marathi\u00A6Afrikaans\u00A6Avestan\u00A6Moldavian\u00A6Hawaii\u00A6Mongolian\u00A6Abkhaz\u00A6Malayalam\u00A6Afar\u00A6Macedonian\u00A6Chuuke\u00A6Maori\u00A6Marshall\u00A6Malagasi\u00A6Irlandia Abad Pertengahan (900-1200)\u00A6Yoruba\u00A6Mesir Kuno\u00A6Yiddish\u00A6Baltik (Lainnya)\u00A6Latvian\u00A6Bahasa-bahasa Athapaska\u00A6Luba-Katanga\u00A6Lithuania\u00A6Balin\u00A6Lao\u00A6Lingala\u00A6Bahasa-bahasa Bamileke\u00A6Limburg\u00A6Ganda";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currencyFormat", "\u00a4#,##0.00;-\u00a4#,##0.00" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
