//
// C++ Interface: outputgenerator
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef OUTPUTGENERATOR_H
#define OUTPUTGENERATOR_H

#include <iostream>

class OutputBuffer;

/**
base class that actually writes the generated output to the output stream

@author Lorenzo Bettini
*/
class OutputGenerator
{
  private:
    OutputBuffer &outputbuffer;
    std::ostream &output;

  protected:
    virtual void reset() {}
    virtual void generate_line(const std::string &line);
    void output_string(const std::string &s);

  public:
    OutputGenerator(OutputBuffer &buff, std::ostream &os);

    virtual ~OutputGenerator();

    void generate();
};

#endif
