/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.database;

import gnu.prolog.database.Predicate;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Predicate_retract
extends ExecuteOnlyCode {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            RetractBacktrackInfo bi = (RetractBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return Predicate_retract.nextSolution(interpreter, bi);
        }
        Term clause = args[0];
        Term head = null;
        Term body = null;
        if (clause instanceof VariableTerm) {
            PrologException.instantiationError();
        } else if (clause instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)clause;
            if (ct.tag == TermConstants.clauseTag) {
                head = ct.args[0].dereference();
                body = ct.args[1].dereference();
            } else {
                head = ct;
                body = TermConstants.trueAtom;
            }
        } else if (clause instanceof AtomTerm) {
            head = clause;
            body = TermConstants.trueAtom;
        } else {
            PrologException.typeError(TermConstants.callableAtom, clause);
        }
        CompoundTermTag predTag = null;
        if (head instanceof VariableTerm) {
            PrologException.instantiationError();
        } else if (head instanceof CompoundTerm) {
            predTag = ((CompoundTerm)head).tag;
        } else if (head instanceof AtomTerm) {
            predTag = CompoundTermTag.get((AtomTerm)head, 0);
        } else {
            PrologException.typeError(TermConstants.callableAtom, head);
        }
        Predicate p = interpreter.getEnvironment().getModule().getDefinedPredicate(predTag);
        if (p == null) {
            return -1;
        }
        if (p.getType() == Predicate.TYPE.USER_DEFINED) {
            if (!p.isDynamic()) {
                PrologException.permissionError(TermConstants.modifyAtom, TermConstants.staticProcedureAtom, predTag.getPredicateIndicator());
            }
        } else {
            PrologException.permissionError(TermConstants.modifyAtom, TermConstants.staticProcedureAtom, predTag.getPredicateIndicator());
        }
        HashMap<Term, Term> map = new HashMap<Term, Term>();
        RetractBacktrackInfo bi = new RetractBacktrackInfo();
        Predicate predicate = p;
        synchronized (predicate) {
            List<Term> clauses = p.getClauses();
            ArrayList<Term> list = new ArrayList<Term>(clauses.size());
            Iterator<Term> i$ = clauses.iterator();
            while (i$.hasNext()) {
                Term term;
                Term cl = term = i$.next();
                Term cp = (Term)cl.clone();
                map.put(cp, cl);
                list.add(cp);
            }
            bi.iclauses = list.iterator();
            bi.clauseMap = map;
            bi.startUndoPosition = interpreter.getUndoPosition();
            bi.clause = new CompoundTerm(TermConstants.clauseTag, head, body);
            bi.pred = p;
        }
        return Predicate_retract.nextSolution(interpreter, bi);
    }

    private static int nextSolution(Interpreter interpreter, RetractBacktrackInfo bi) throws PrologException {
        while (bi.iclauses.hasNext()) {
            Term term = bi.iclauses.next();
            int rc = interpreter.unify(bi.clause, term);
            if (rc != 1) continue;
            bi.pred.removeClause(bi.clauseMap.get(term));
            interpreter.pushBacktrackInfo(bi);
            return 0;
        }
        return -1;
    }

    private static class RetractBacktrackInfo
    extends BacktrackInfo {
        Iterator<Term> iclauses;
        Map<Term, Term> clauseMap;
        int startUndoPosition;
        Term clause;
        Predicate pred;

        RetractBacktrackInfo() {
            super(-1, -1);
        }
    }
}

