
/*
 * (c) 1988 by George Kyriazis
 */

/*
 * the background color.
 * can be changed to have any kind of background texturing.  (hint hint)
 */

#include "ray.h"

struct	color	bgcolor(r)
struct	ray	r;
{
	struct	color	c;

/* if it is above the appropriate axis just give a grey value */
/* if below give a gradually whiter color                     */
	switch( bgflag ) {
		case NONE:
			c.r = c.g = c.b = 0.2;
			break;
		case X:
			if( r.dir.x > 0.0 )
				c.r = c.g = c.b = 0.2;
			else
				c.r = c.g = c.b = 0.2 - 0.8 * r.dir.x;
			break;
		case Y:
			if( r.dir.y > 0.0 )
				c.r = c.g = c.b = 0.2;
			else
				c.r = c.g = c.b = 0.2 - 0.8 * r.dir.y;
			break;
		case Z:
			if( r.dir.z > 0.0 )
				c.r = c.g = c.b = 0.2;
			else
				c.r = c.g = c.b = 0.2 - 0.8 * r.dir.z;
			break;
	}

	return c;
}
