#define	MAXOBJECTS	1010
#define	MAXLEVEL	4

#define	MINT	1e-6

struct point {double x,y,z;};

struct vector {double x,y,z;};

struct circle {
	struct vector o;
	double c,s;
};

struct ray {
	int obj;		/* origin index */
	struct point a;		/* origin coordinate */
	struct vector l;	/* direction */
};

struct color {double r,g,b;};

struct intersect {
	int obj;
	double t;
	struct vector n;
} intersect();

struct object {
	int flags;
	struct point center;
	double radius;
	struct intersect (*shape)();
	double *spparams;
	struct color (*shade)();
	double *sdparams;
} objects[MAXOBJECTS];

#define	EYE		1		/* object is eye */
#define	LIGHT		2		/* object is light source */
#define	REFLECT		4		/* object is reflective */
#define	REFRACT		8		/* object is refractive */
#define	RAYORIGIN	(EYE|LIGHT|REFLECT|REFRACT)
#define	SELF		16		/* rays from an object may */
					/* intersect the object again */

extern int res;
extern int maxobj,lights;

struct objlist2 {
	int obj;
	struct objlist *next;
};

struct objlist {
	int obj;
	struct objlist *next;
	float t;
}
	***candidates;

struct dirlist {
	int dir;
	struct dirlist *next;
};

extern struct vector nilvect,normalize(),reflect(),refract();
extern struct color trace(),bgcolor();

extern int fflag,dflag,aflag,tflag,sflag,oflag;

extern int alsize;

/* This should be modified to be word alignment of alloc macro
 *	0x1	for 2 byte alignment
 *	0x3	for 4 byte alignment
 */
#define	ALMASK	0x1

extern char *myalloc(),*freep,*endp;
extern char *malloc();

#define alloc(type)	((alsize=(sizeof(type)+ALMASK)&~ALMASK),\
			 (type *) (endp>freep+alsize\
				 ?(freep+=alsize)-alsize\
				 :myalloc(alsize)))

#define nalloc(type,n)	((alsize=(sizeof(type)*(n)+ALMASK)&~ALMASK),\
			 (type *) (endp>freep+alsize\
				 ?(freep+=alsize)-alsize\
				 :myalloc(alsize)))

extern int raycount,shadowcount;

extern int NRECTS,DIRECTIONS;

struct shapetab {
	void (*shapeinitfunc)();
	struct intersect (*shapefunc)();
	int nparams;
}
	*shapetab;

extern int nshapetab;

struct shadetab {
	void (*shadeinitfunc)();
	struct color (*shadefunc)();
	int nparams;
}
	*shadetab;

extern int nshadetab;

extern double fovf;
