#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>

#include "ray.h"

main(ac,av)
int ac;
char **av;
{int g;
struct rusage ru;
struct timeval tu,tu2;
	raycount=0;
	shadowcount=0;
	fflag=1;
	dflag=0;
	aflag=0;
	tflag=0;
	sflag=1;
	oflag=1;
	while(av[1]&&*av[1]=='-')
	{	switch(av[1][1])
		{case 's':		/* classical slow algorithm */
			fflag=0;
			break;
		case 'd':		/* debug flag */
			dflag=1;
			break;
		case 'a':		/* do anti-aliasing */
			aflag=1;
			break;
		case 't':		/* produce timing information */
			tflag=1;
			break;
		case 'b':		/* no shading */
			sflag=0;
			break;
		case 'o':		/* don't order candidates */
			oflag=0;
			break;
		case 'r':		/* set image resolution */
			res = atoi(av[2]);
			ac--;
			av++;
			break;
		default:
			usage();
		}
		ac--;
		av++;
	}
	if(ac!=3)
		usage();
	initshape();
	initshade();
	input(av[1]);
	if(fflag)
	{	(void) getrusage(0,&ru);
		tu=ru.ru_utime;
		initdir();
		if(tflag)
			fprintf(stderr,"Directions=%d Objects=%d\n",
				DIRECTIONS,maxobj);
		(void) getrusage(0,&ru);
		tu2=ru.ru_utime;
		if(tflag)
		{	fprintf(stderr,"Initializeation time ");
			printtime(tu,tu2);
		}
	}
	else
	{	if(tflag)
			fprintf(stderr,"Objects=%d\n",maxobj);
	}
	if((g=creat(av[2],0666))<0)
	{	perror(av[2]);
		exit(3);
	}
	(void) getrusage(0,&ru);
	tu=ru.ru_utime;
	if(aflag)
		ascan(g);
	else
		scan(g);
	(void) getrusage(0,&ru);
	tu2=ru.ru_utime;
	if(tflag)
	{	fprintf(stderr,"   Computation time ");
		printtime(tu,tu2);
		fprintf(stderr,"\n%d rays traced",raycount);
		fprintf(stderr,"   %d shadows tested\n",shadowcount);
	}
	(void) close(g);
	exit(0);
}

usage()
{	fprintf(stderr,
		"Usage: ray [-sdatbo] [-r res] scenefile picfile\n");
	exit(1);
}

printtime(t0,t1)
struct timeval t0,t1;
{int sec,usec;
	usec=t1.tv_usec-t0.tv_usec;
	sec=t1.tv_sec-t0.tv_sec;
	if(usec<0)
	{	usec+=1000000;
		sec--;
	}
	fprintf(stderr,"%4d.%03d",sec,usec/1000);
}
