#include <math.h>
#include <stdio.h>

#include "ray.h"

input(s)
char *s;
{struct object *o;
FILE *f;
int i,sp,sd;
char c;
double fov;
	if((f=fopen(s,"r"))==0)
	{	perror(s);
		exit(1);
	}
	o=objects;
	if(fscanf(f," f %lf ",&fov)!=1||fov<=0||fov>=180)
	{	fprintf(stderr,"field of view format error\n");
		exit(1);
	}
	fovf=tan(fov*3.14159/360)/sqrt(2.0);
	o->flags=EYE;
	o->center.x=o->center.y=o->center.z=0;
	o->radius=0;
	o++;
	lights=0;
	while(fscanf(f," l %lf %lf %lf ",&o->center.x,&o->center.y,
		&o->center.z)==3)
	{	o->flags=LIGHT;
		o->radius=0;
		o++;
		lights++;
	}
	maxobj=lights+1;
	while(fscanf(f," o %d %d ",&sp,&sd)==2)
	{	if(maxobj==MAXOBJECTS)
		{	fprintf(stderr,"too many objects\n");
			exit(1);
		}
		if(sp<0||sp>=nshapetab)
		{	fprintf(stderr,"shape number range error\n");
			exit(1);
		}
		if(sd<0||sd>=nshadetab)
		{	fprintf(stderr,"shade number range error\n");
			exit(1);
		}
		o= &objects[maxobj];
		o->flags=0;

		o->shape=shapetab[sp].shapefunc;
		o->spparams=nalloc(double,shapetab[sp].nparams);
		for(i=0;i<shapetab[sp].nparams;i++)
		{	if(fscanf(f," %lf ",&o->spparams[i])!=1)
			{	fprintf(stderr,"shape parameter error\n");
				exit(1);
			}
		}
		(*shapetab[sp].shapeinitfunc)(o);

		o->shade=shadetab[sd].shadefunc;
		o->sdparams=nalloc(double,shadetab[sd].nparams);
		for(i=0;i<shadetab[sd].nparams;i++)
		{	if(fscanf(f," %lf ",&o->sdparams[i])!=1)
			{	fprintf(stderr,"shade parameter error\n");
				exit(1);
			}
		}
		(*shadetab[sd].shadeinitfunc)(o);

		maxobj++;
	}
	if(fscanf(f," %c",&c)!=1||c!='e')
	{	fprintf(stderr,"end command not found\n");
		exit(1);
	}
	(void) fclose(f);
}
