/* Misc3DMouseDriver.m				 
 *
 * The MetaDriver is a very basic driver object. Ever real driver should be a
 * subclass of that. It is also used for 
 *
 * For more interface-info see the header file. More in depth information
 * can be found in the source-code.
 *
 * Written by: 		Thomas Engel
 * Created:    		11.04.1994 (Copyleft)
 * Last modified: 	13.04.1994
 */

#import "Misc3DMouseDriver.h"
#import <remote/NXProxy.h>

@implementation Misc3DMouseDriver

- setTarget:anObject
{
	if( [anObject conformsTo:@protocol(Misc3DMouseTarget)] )
	{
		[super setTarget:anObject];
		if( [target isProxy] ) 
			[target setProtocolForProxy:@protocol(Misc3DMouseTarget)];
	}
		
	targetIsRightHanded = [target worldIsRightHanded];
	if( !transformMatrix ) transformMatrix = [MiscRtMatrix new];
	return self;
}

- (BOOL)deliverTranslation:(float)x :(float)y :(float)z
	  	       andRotation:(float)a :(float)b :(float)c
{
	// If we can send an event we will compose the right transformation
	// matrix and them we'll pass it along.
	// We will return our success flag.
	
	if( !sendEvents ) return NO;
	if( syncEvents && awaitingSync ) return NO;

	// Looks like we might really send it. depending on the handedness
	// we have to adjust the given values. As we remember they alway come
	// from a right handed device. (at least we have said they should be
	// that way :-)
	
	if( !targetIsRightHanded )
	{
		 z = -z;
		 a = -a;
		 b = -b;
	}
	[transformMatrix setByTranslation:x :y: z andRotation:a :b :c];
	
	[target transformationEvent:transformMatrix];
	if( syncEvents ) awaitingSync = YES;
	return YES;
}

- (BOOL)deliverKeyPress:(char *)keys
{
	return NO;
}

@end

/*
 * History: 13.04.94 Changed to work with new Matrix methods.
 *
 *			11.04.94 Should simplify the other mouse drivers. 
 *
 *
 * Bugs: not very likely
 */