
/*
 * $Id: newwin.c,v 1.7 1993/06/08 02:18:53 browne Exp $
 *
 * $Log: newwin.c,v $
 * Revision 1.7  1993/06/08  02:18:53  browne
 * added MODE_DATABASE
 *
 * Revision 1.6  1993/05/28  19:48:49  wade
 * *** empty log message ***
 *
 * Revision 1.5  1993/02/22  16:04:47  wade
 * added finger demo support
 *
 * Revision 1.4  1993/01/06  20:32:24  wade
 * using XtCreatePopupShell now for popups
 *
 * Revision 1.3  1993/01/05  22:16:12  wade
 * changed Class name of popup to Xnetlib
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

#include "xnl.h"

void Print_text();

 
static char *names[] = {
/* MODE_NORMAL won't happen */ "normal mode window",
/* MODE_RECEIVE */ "receive mode window",
/* MODE_CLASSIFICATION */ "classification mode window",
/* MODE_KEYWORD */ "keyword mode window",
/* MODE_WHO */ "who mode window",
/* MODE_HELP */ "help mode window",
/* MODE_INDEX */ "index mode window",
/* MODE_LIBRARY */ "library mode window",
/* MODE_LIBSELECT */ "library select mode window",
/* MODE_CLASSSELECT same as MODE_LIBSELECT*/ "library select mode window",
/* MODE_UPDATE */ "setup mode window",
/* MODE_QUIT */ "quit mode window",
/* MODE_MOTD */ "motd mode window",
/* MODE_STUB */ "stub mode window",
/* MODE_PERFORMANCE */ "performance mode window",
/* MODE_REXEC */ "remote services mode window",
/* MODE_DATABASE */ "conference database mode window"
};

void
newWinCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[5];
    Widget  popup, button, pane, form, text, text_sink;
    register int n, i, rows, num_libs, max_wide, how_big;
	String s;
	int tabs[5];
	String *cur_list;
	Boolean clicker;


	if ((Mode == MODE_LIBRARY) || (Mode == MODE_CLASSSELECT)){

		if (Mode == MODE_CLASSSELECT)
			cur_list = ClassList;
		else
			cur_list = topdirList;


		popup = XtVaCreatePopupShell("NewWindow",
			topLevelShellWidgetClass, toplevel, 
			XtNtitle, names[Mode], NULL);


		pane = XtCreateManagedWidget("newWinPopupPane", panedWidgetClass,
			popup, NULL, 0);

		form = XtCreateManagedWidget("newWinPopupForm", formWidgetClass,
			pane, NULL, 0);

		button = XtCreateManagedWidget("Done",commandWidgetClass,form,NULL,0);
		XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)pane);

		button = XtVaCreateManagedWidget("Print",commandWidgetClass,form,
			XtNfromHoriz, button, NULL);


#define IFGOOD(x) (((x) < num_libs) ? (cur_list[x]) : (" "))

		max_wide = how_big=0;
		for (i=0; cur_list[i]; i++) {
			how_big += strlen(cur_list[i]) + 5;
			if (strlen(cur_list[i]) > max_wide)
				max_wide = strlen(cur_list[i]);
		}
		max_wide += 2;
		num_libs = i;
		i++;
		rows = (i +3)/5;

		for (i=0; i < 5; i++)
			tabs[i] = max_wide + i*max_wide;

		s = XtMalloc(how_big);
		s[0] = '\0';

		for (i=0; i < rows; i++) {
			strcat(s, IFGOOD(i +0*rows)); strcat(s, "\t");
			strcat(s, IFGOOD(i +1*rows)); strcat(s, "\t");
			strcat(s, IFGOOD(i +2*rows)); strcat(s, "\t");
			strcat(s, IFGOOD(i +3*rows)); strcat(s, "\t");
			strcat(s, IFGOOD(i +4*rows)); strcat(s, "\n");
		}
#undef IFGOOD

		n = 0;
		XtSetArg(args[n], XtNwidth, (XNL_WIDTH*3)/4); n++;
		XtSetArg(args[n], XtNheight, XNL_HEIGHT/2); n++;
		XtSetArg(args[n], XtNstring, s); n++;
		text=XtCreateManagedWidget("text", asciiTextWidgetClass,pane, args, n);

		XtSetArg(args[0], XtNtextSink, &text_sink);
		XtGetValues (text, args, 1);
		XawTextSinkSetTabs(text_sink, 5, tabs);

		XtAddCallback(button, XtNcallback, Print_text, (XtPointer)text);

		XtPopup(popup, XtGrabNone);

		XtFree(s);

		return;
	} else if (Mode == MODE_CLASSIFICATION) {
		popup = XtVaCreatePopupShell("NewWindow",
			topLevelShellWidgetClass, toplevel, 
			XtNtitle, names[Mode], NULL);

        pane = XtCreateManagedWidget("newWinPopupPane", panedWidgetClass,
            popup, NULL, 0);
		form = XtCreateManagedWidget("newWinPopupForm", formWidgetClass,
			pane, NULL, 0);

        button = XtCreateManagedWidget("Done",commandWidgetClass,form,NULL,0);
        XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)pane);

        button = XtVaCreateManagedWidget("Print",commandWidgetClass,form,
            XtNfromHoriz, button, NULL);


#define IFGOOD(x) (((x) < num_libs) ? (mainClassList[x]) : (" "))

        max_wide = how_big=0;
        for (i=0; mainClassList[i]; i++) {
            how_big += strlen(mainClassList[i]) + 5;
            if (strlen(mainClassList[i]) > max_wide)
                max_wide = strlen(mainClassList[i]);
        }
        max_wide += 2;
        num_libs = i;
        i++;
        rows = (i)/2;

        for (i=0; i < 2; i++)
            tabs[i] = max_wide + i*max_wide;

        s = XtMalloc(how_big);
        s[0] = '\0';

        for (i=0; i < rows; i++) {
            strcat(s, IFGOOD(i +0*rows)); strcat(s, "\t");
            strcat(s, IFGOOD(i +1*rows)); strcat(s, "\n");
        }
#undef IFGOOD

        n = 0;
        XtSetArg(args[n], XtNwidth, (XNL_WIDTH*3)/4); n++;
        XtSetArg(args[n], XtNheight, XNL_HEIGHT/2); n++;
        XtSetArg(args[n], XtNstring, s); n++;
        text=XtCreateManagedWidget("text", asciiTextWidgetClass,pane, args, n);

        XtSetArg(args[0], XtNtextSink, &text_sink);
        XtGetValues (text, args, 1);
        XawTextSinkSetTabs(text_sink, 2, tabs);

        XtAddCallback(button, XtNcallback, Print_text, (XtPointer)text);

        XtPopup(popup, XtGrabNone);

        XtFree(s);

        return;
	}

	if (currentDisplayText == NULL)
		return;

	switch (Mode) {
	case MODE_CLASSIFICATION:
	case MODE_KEYWORD:
	case MODE_WHO:
	case MODE_HELP:
	case MODE_INDEX:
	case MODE_LIBRARY:
	case MODE_LIBSELECT:
	case MODE_CLASSSELECT:
	case MODE_MOTD:
	case MODE_REXEC:
	case MODE_RECEIVE:
#ifdef STUB
	case MODE_STUB:
#endif
#ifdef PERFORMANCE
	case MODE_PERFORMANCE:
#endif
        case MODE_DATABASE:
	break;
	/* not handled */
	default: 
		return; break;
	}

#ifdef DEBUG
printf("ding %s\n", XtName(currentDisplayText));
#endif

	popup = XtVaCreatePopupShell("NewWindow",
        topLevelShellWidgetClass, toplevel, 
        XtNtitle, names[Mode], NULL);


    pane = XtCreateManagedWidget("newWinPopupPane", panedWidgetClass,
        popup, NULL, 0);
	form = XtCreateManagedWidget("newWinPopupForm", formWidgetClass,
		pane, NULL, 0);

    button = XtCreateManagedWidget("Done", commandWidgetClass,form, NULL, 0);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)pane);


	button = XtVaCreateManagedWidget("Print",commandWidgetClass,form,
		XtNfromHoriz, button, NULL);


	s = XawUtkGetText(currentDisplayText);

	XtSetArg(args[0], XtNgetAllButton, &clicker);
	XtGetValues(currentDisplayText, args, 1);


	n = 0;
	XtSetArg(args[n], XtNwidth, (XNL_WIDTH*3)/4); n++;
	XtSetArg(args[n], XtNheight, XNL_HEIGHT/2); n++;
	XtSetArg(args[n], XtNstring, s + ((clicker) ? strlen(GET_ALL_PR) : 0)); n++;
    text=XtCreateManagedWidget("text", asciiTextWidgetClass,pane, args, n);

	XtAddCallback(button, XtNcallback, Print_text, (XtPointer)text);

    XtPopup(popup, XtGrabNone);

	XtFree(s);
}



void
Print_text(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
	Widget text = (Widget)call_data;
    String s;
    char line[MAXLINE], command[MAXLINE];
    char filename[MAXLINE];
    FILE *fp;
    int retval;

    if (FINGER_DEMO) {
		printf("\nThe demo version of Xnetlib doesn't print.\n\n");
		return;
    }


    /* get text */
    s = XawUtkGetText(text);

    if ((s == NULL) || (strlen(s) < 1)) {
        set_status("nothing to print", YELLOW);
        return;
    }

    /* get tmp file name */
    strcpy(filename, tmpnam(NULL));
    if (!filename) {
        set_status("couldn't allocate temporay file name", RED);
        XtFree(s);
        return;
    }

    /* load tmp file */
    fp = fopen(filename, "w");
    if ( fp ) {
        fputs(s, fp);
        fclose(fp);
    } else {
        sprintf(line, "couldn't open temp file ( %s )", filename);
        set_status(line, RED);
    }

    XtFree(s);

    /* print it */
    sprintf(command, PRINT_COMMAND, filename);
    retval = system(command);
    retval &= 127;
    if ( retval ) {
        sprintf(line, "couldn't print using ( %s )", command);
        set_status(line, RED);
    } else {
        set_status("printed who info", GREEN);
    }

    /* remove the tmp file */
    unlink(filename);

}

