/* database_addconf.c */

/* addButtonCB() - called when user clicks on "Add a conference...
 * clearButtonCB() - called when user clicks on "Clear"
 */

#include "database.h"

void
addButtonCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[20];
    Widget  popup, button, form, pane, last, titleLabel, locationLabel;
    register int n;
	XtTranslations translations;
    static char text_translations[] = "<Key>Return: "; /* nothing */

    translations = XtParseTranslationTable(text_translations);

    n=0;
    XtSetArg(args[n], XtNallowShellResize, True);               n++;
    XtSetArg(args[n], XtNtitle, "Conference Submission");            n++;
    SubmitPopup = popup = XtCreatePopupShell("Conference_Submission",
        topLevelShellWidgetClass, toplevel, args, n);

    pane = XtVaCreateManagedWidget("popupPane", panedWidgetClass,
        popup, XtNresize, True, NULL);

    form = XtVaCreateManagedWidget("popupForm", formWidgetClass,
        pane, XtNresize, True, NULL);

    n = 0;
    button = XtCreateManagedWidget("cancel", commandWidgetClass,form, args, n);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)pane);

    n = 0;
	XtSetArg(args[n], XtNfromHoriz, button); n++;
    last = XtCreateManagedWidget("submit", commandWidgetClass,form, args, n);
    XtAddCallback(last, XtNcallback, submit, (XtPointer)pane);

    n = 0;
    XtSetArg(args[n], XtNfromVert, button); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "Dates:  from "); n++;
    last = XtCreateManagedWidget("Dates", labelWidgetClass, form,
            args, n);


    n = 0;
    XtSetArg(args[n], XtNfromVert, button); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNwidth, 100); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                         n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    last = XtCreateManagedWidget("fromTextPopup", asciiTextWidgetClass,
        form, args, n);
    XtOverrideTranslations(last, translations);

    n = 0;
    XtSetArg(args[n], XtNfromVert, button); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, " to "); n++;
    last = XtCreateManagedWidget("DatesTo", labelWidgetClass, form,
            args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, button); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNwidth, 100); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                         n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    button = last = XtCreateManagedWidget("toTextPopup", asciiTextWidgetClass,
        form, args, n);
    XtOverrideTranslations(last, translations);

    n = 0;
    XtSetArg(args[n], XtNfromVert, button); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "Conference title: "); n++;
    last = XtCreateManagedWidget("title", labelWidgetClass, form,
            args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, button); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNwidth, 500); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                         n++;
    XtSetArg(args[n], XtNresize, XawtextResizeWidth); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    titleLabel = XtCreateManagedWidget("titleText", asciiTextWidgetClass,
        form, args, n);
    XtOverrideTranslations(last, translations);

    n = 0;
    XtSetArg(args[n], XtNfromVert, titleLabel); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "Conference location: "); n++;
    locationLabel = XtCreateManagedWidget("location", labelWidgetClass, form,
            args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, titleLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, locationLabel); n++;
    XtSetArg(args[n], XtNwidth, 480); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                         n++;
    XtSetArg(args[n], XtNresize, XawtextResizeWidth); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    last = XtCreateManagedWidget("locationText", asciiTextWidgetClass,
        form, args, n);
    XtOverrideTranslations(last, translations);

    n = 0;
    XtSetArg(args[n], XtNfromVert, last); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "Enter description below or click here to read description from file: "); n++;
    last = XtCreateManagedWidget("descFile", labelWidgetClass, form,
            args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, locationLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, last); n++;
    XtSetArg(args[n], XtNlabel, "Read from file"); n++;
    readButton = last = XtCreateManagedWidget("Read",
          commandWidgetClass, form, args, n);
    XtAddCallback(readButton, XtNcallback, readButtonCB, (XtPointer)NULL);

    n = 0;
    XtSetArg(args[n], XtNallowResize, True);               n++;
    XtSetArg(args[n], XtNwidth, 510);               n++;
    XtSetArg(args[n], XtNheight, 400);               n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                         n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    descDisplayText = XtCreateManagedWidget("description", asciiTextWidgetClass,
        pane, args, n);


    XtPopup(popup, XtGrabNone);
}

void
changeButtonCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[5];
    Widget  popup, last, button;
    Position    x, y;
    Dimension   width, height;
    register int n;

    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2),
            (Position) (height / 2), &x, &y);


    n = 0;
    XtSetArg(args[n], XtNx, x);             n++;
    XtSetArg(args[n], XtNy, y);             n++;

    popup = XtCreatePopupShell("databaseChangePopup",
        transientShellWidgetClass, w, args, n);

    databaseChangeDialog = XtCreateManagedWidget("databaseChangeDialog",
        formWidgetClass, popup,NULL, 0);

    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, 
        "To change the listing for a conference you have submitted,");
    n++;
    last = XtCreateManagedWidget("changelabel1",
            labelWidgetClass, databaseChangeDialog, args, n);

    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, 
        "send an e-mail message to conferences@netlib.ornl.gov,");
    n++;
    XtSetArg(args[n], XtNfromVert, last); n++;
    last = XtCreateManagedWidget("changelabel2",
            labelWidgetClass, databaseChangeDialog, args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, last);  n++;
    button = XtCreateManagedWidget("dismiss", commandWidgetClass,
        databaseChangeDialog, args, n);
    XtAddCallback(button, XtNcallback, Destroy_form, 
                       (XtPointer) databaseChangeDialog);   

    XtPopup(popup, XtGrabExclusive);
}
