/*
 * $XConsortium: UtkasciiTextP.h,v 1.15 89/07/17 18:09:37 kit Exp $ 
 */

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/***********************************************************************
 *
 * UtkasciiText Widget
 *
 ***********************************************************************/

/*
 * UtkasciiText.c - Private header file for UtkasciiText Widget.
 *
 * This Widget is intended to be used as a simple front end to the 
 * text widget with an utkascii source and utkascii sink attached to it.
 *
 * Date:    June 29, 1989
 *
 * By:      Chris D. Peterson
 *          MIT X Consortium 
 *          kit@expo.lcs.mit.edu
 */

/*
 * 
$Log: UtkasciiTextP.h,v $
 * Revision 1.2  1992/12/05  17:27:42  larose
 * added rcs logging
 *
 *
 */

#ifndef _UtkasciiTextP_h
#define _UtkasciiTextP_h

#include <X11/Xaw/TextP.h>
#include "UtkasciiSrc.h" /* no need to get private header. */
#include "UtkasciiText.h"

typedef struct {int empty;} UtkasciiClassPart;

typedef struct _UtkasciiTextClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    TextClassPart	text_class;
    UtkasciiClassPart	utkascii_class;
} UtkasciiTextClassRec;

extern UtkasciiTextClassRec utkasciiTextClassRec;

typedef struct { char foo; /* keep compiler happy. */ } UtkasciiPart;

typedef struct _UtkasciiRec {
    CorePart		core;
    SimplePart		simple;
    TextPart		text;
    UtkasciiPart           utkascii;
} UtkasciiRec;

/************************************************************
 *
 * Utkascii String Emulation widget.
 *
 ************************************************************/ 

#ifdef ASCII_STRING

typedef struct {int empty;} UtkasciiStringClassPart;

typedef struct _UtkasciiStringClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    TextClassPart	text_class;
    UtkasciiClassPart	utkascii_class;
    UtkasciiStringClassPart string_class;
} UtkasciiStringClassRec;

extern UtkasciiStringClassRec utkasciiStringClassRec;

typedef struct { char foo; /* keep compiler happy. */ } UtkasciiStringPart;

typedef struct _UtkasciiStringRec {
    CorePart		core;
    SimplePart		simple;
    TextPart		text;
    UtkasciiPart           utkascii;
    UtkasciiStringPart     utkascii_str;
} UtkasciiStringRec;

#endif /* ASCII_STRING */

#ifdef ASCII_DISK

/************************************************************
 *
 * Utkascii Disk Emulation widget.
 *
 ************************************************************/ 

typedef struct {int empty;} UtkasciiDiskClassPart;

typedef struct _UtkasciiDiskClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    TextClassPart	text_class;
    UtkasciiClassPart	utkascii_class;
    UtkasciiDiskClassPart	disk_class;
} UtkasciiDiskClassRec;

extern UtkasciiDiskClassRec utkasciiDiskClassRec;

typedef struct { char foo; /* keep compiler happy. */ } UtkasciiDiskPart;

typedef struct _UtkasciiDiskRec {
    CorePart		core;
    SimplePart		simple;
    TextPart		text;
    UtkasciiPart           utkascii;
    UtkasciiDiskPart       utkascii_disk;
} UtkasciiDiskRec;
#endif /* ASCII_DISK */

#endif /* _UtkasciiTextP_h */
