
/*
 * $Id: nl_access.c,v 1.12 1993/06/17 19:33:38 wade Exp $
 *
 * $Log: nl_access.c,v $
 * Revision 1.12  1993/06/17  19:33:38  wade
 * *** empty log message ***
 *
 * Revision 1.11  1993/06/06  03:06:49  wade
 * fixed the bcopy so it used the "right" host when hosts resolve to
 * only 1 address.
 * -rw
 *
 * Revision 1.10  1993/05/21  17:10:05  wade
 * added support for hosts with 2 addresses per name
 * still needs support for more than 2
 *
 * Revision 1.9  1993/04/20  16:01:40  wade
 * *** empty log message ***
 *
 * Revision 1.8  1993/04/20  15:26:51  wade
 * added konnekt
 *
 * Revision 1.7  1993/01/06  20:43:28  wade
 * idef'd errno symbols in errstring()
 *
 * Revision 1.6  1992/12/19  20:36:06  larose
 * added rcs stuff.
 *
 * usage: netlibget server [d or t] file library
 *  d for dependency checking
 *  t for file tag
 * or    netlibget server key <whois>
 * or    netlibget server key <keyword>
 * 
 * and think it would be a lot clearer to write:
 * 
 * or    netlibget server <key> whois
 * or    netlibget server <key> keyword
 * 
 * Of course for consistency with the usage: netlibget server file library
 * it would be even better to write:
 * 
 * or    netlibget server whois <name>
 * or    netlibget server keyword <key>
*/
#include <stdio.h>
#include <sys/ioctl.h>

#ifdef TERM
#include <unistd.h>
#include <term/client.h>
extern int lcompression;
extern int rcompression;
extern int priority;
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <signal.h>

#define KONNEKT_TIMEOUT	10 /* seconds */

#ifdef STANDALONE
/* needed for username getting */
#include <pwd.h>

#define set_netstat(s) /* wont be needing this */

#define konnekt		connect	/* use regular connect */

#endif

#define CASE_SENSE

#ifdef CASE_SENSE
#define LC(s) 
#else
#define LC(s) \
    if (s && s[0]) \
      for (n=strlen(s) -1; n >= 0 ; n--) \
        if ((s[n] >= 'A') && (s[n] <= 'Z')) \
        s[n] = s[n] + ('a' - 'A');
#endif

/* #define DEBUG */

#ifndef swrite
#define swrite(s, str)  write(s, str, strlen(str))
#endif

struct string_list {
	char *str;
	unsigned long when;
	struct string_list *next;
};

static struct string_list *black_ball_list = NULL;



extern int errno;

#define MAXLINE 2550

#define SERVER_PORT 5555

#define DIR_MODE    0000755
#define PUB_DIR_MODE    0000777

#define FALSE 0
#define TRUE  1

/* data chunk sizes */
#define BLOCKSIZE   1024
#define BUFSIZE     300

/* status values */
#define RCP_OK      0
#define RCP_FILEERROR   1
#define RCP_NAMEDECODE  2
#define RCP_ACCESSERROR 3
#define RCP_BUSY    4
#define RCP_COMERR  5       /* used only by the server */
#define RCP_WHOISERROR  6
#define RCP_KEYWORDERROR        7

#define SURFER    "128.219.8.12"        /* surfer */
#define SERVER_NAME SURFER

int fileSize, bytesRead;

char buf[BUFSIZE], realname[MAXLINE], fname[MAXLINE];
FILE *fp;
int oldumask;

int connect_to_server();
int getfile();
static char *strchr();

/* global data */
char block[BLOCKSIZE];
char filename[MAXLINE], library[MAXLINE], dirname[MAXLINE];


#define NETLIB_MODE_GET        0x00
#define NETLIB_MODE_GETDEP    0x01
#define NETLIB_MODE_WHO        0x02
#define NETLIB_MODE_KEY        0x04
#define NETLIB_MODE_TAG        0x08

#define GET_ALL     1
#define GET_PART_INIT    2
#define GET_PART_READ    3

char *errstr();

netlib_filesize() { return fileSize; }
netlib_bytesRead() { return bytesRead; }


int netlib_open(); /* int netlib_open(host, type, fname, lib, destdir)
      host: server address
      type: NETLIB_MODE_GET, NETLIB_MODE_GETDEP,
            NETLIB_MODE_WHO, NETLIB_MODE_KEY
      fname: name of file to get, or key, or who
      lib:   name of library to get from, reserved for key or who
      destdir: where to write file
    opens the socket to surfer returns the socket or 0 for failure */


int netlib_abort(); /* int netlib_abort(socket)
    blows the connection for you */


#ifdef STANDALONE
char *get_email()
{
    static char ret[255];
    char username[255], host[255];
	struct hostent *hp;
    struct passwd *pptr;

    if ((pptr = getpwuid(getuid())) == NULL) {
        fprintf(stdout, "I can't figure out your username; consult your administrator\n");
        exit(1);
    } else {
        strcpy(username, pptr->pw_name);
    }

    if ((0==gethostname(host, 250)) && (hp = gethostbyname(host))) {
        strcpy(host, hp->h_name);
        sprintf(ret, "%s@%s", username, host);
    } else {
		strcpy(ret, username);
	}

	return ret;
}

unsigned long what_time() { return 0; }

main(argc, argv)
int argc;
char *argv[];
{
    int s;
    int i, cc;
    int verbose, use_stdout;
	char emailAddress[255], server[255], filename[255];
	char dest[255];
	char *service;
	char buf[1024];
	int fsize=0;


	if (argc == 1) {
	  usage(argv[0]);
    }

    filename[0] = 
    emailAddress[0] = '\0';
	strcpy(server, "netlib.ornl.gov");
	service = "file-get";
	use_stdout = verbose = 0;

    for (i=1; i < argc; i++) {
        if ((strcmp(argv[i], "-e") == 0) && (i+1 < argc)) {
          i++;
          strcpy(emailAddress, argv[i]);
        } else if ((strcmp(argv[i], "-s") == 0) && (i+1 < argc)) {
          i++;
          strcpy(server, argv[i]);
        } else if (strcmp(argv[i], "-d") == 0) {
		  service = "file-get-dep";
        } else if (strcmp(argv[i], "-k") == 0) {
		  service = "keyword-literal-case";
		  use_stdout = 1;
        } else if (strcmp(argv[i], "-ko") == 0) {
		  service = "keyword-or";
		  use_stdout = 1;
        } else if (strcmp(argv[i], "-ka") == 0) {
		  service = "keyword-and";
		  use_stdout = 1;
        } else if (strcmp(argv[i], "-w") == 0) {
		  service = "who";
		  use_stdout = 1;
        } else if (strcmp(argv[i], "-q") == 0) {
		  verbose = 0;
        } else if (strcmp(argv[i], "-v") == 0) {
		  verbose = 1;
        } else if (argv[i][0] == '-') { /* some broken option */
		    usage(argv[0]);
        } else { /* probably the file name */
		  if (filename[0]) /* already got one */
		    usage(argv[0]);
		  else
			strcpy(filename, argv[i]);
		}
    }

	if (filename[0] == '\0') {
		usage(argv[0]);
	}

	if (emailAddress[0] == '\0') {
		strcpy(emailAddress, get_email());
	}

	if (verbose)
		printf("%s from %s by %s; email %s\n", filename, server, service,
			emailAddress);

	strcpy(dest, filename+1);
	make_dir(dest, 0);
	rmdir(dest); /* remove dir named for file */

	if (s = nlrexec_service_open(service, server, emailAddress)) {
		if (verbose)
          printf("connected to server\n");

		strcat(filename, "\n");
		swrite(s, filename);

		if (!use_stdout) {
			sget_line(s, buf);
			if (strncmp(buf, "OK", 2) != 0) {
			  fprintf(stderr, "%s\n", buf);
			  exit(-1);
			}
			if (verbose)
			  printf("%s bytes\n", buf);
		}

		/* open file to write */
		if (use_stdout) {
			fp = stdout;
		} else if ((fp = fopen(dest, "w")) == NULL) {
			fprintf(stderr,"Couldn't open %s to write file\n", dest);
			exit(1);
		}

		/* copy dater */
#ifdef TERM
	    while (cc=read(s, buf, 1022)) {
#else
	    while (cc=recv(s, buf, 1022, NULL)) {
#endif
			fsize += cc;
            fwrite(buf, 1, cc, fp);
		}

		if (!use_stdout)
			fclose(fp);

		if (verbose)
          printf("%d bytes\n", fsize);
	}
}

usage(s)
char *s;
{
      fprintf(stderr,"usage: %s [-v|-q] [-e your_email_address] [-s server[+port]] [-d|-k|-w] file or key\n", s);
      fprintf(stderr," -d to get dependent files\n");
      fprintf(stderr," -k for keyword search\n");
      fprintf(stderr," -ko for keyword-or search\n");
      fprintf(stderr," -ka for keyword-and search\n");
      fprintf(stderr," -w for whois search\n");
      fprintf(stderr," -v for verbose; -q for quiet\n");
      exit(1);
}

#endif

int
netlib_abort(s)
int s;
{

#ifdef DEBUG
    
    printf("netlib_abort()\n");
#endif

	shutdown(s, 2);
    close(s);

	set_netstat("connection aborted");
}


/* the black_ball scheme is a list of hosts that we have had trouble
	contacting; this way you only time out once on a host .
	the host gets a repreive after BLACK_BALL_TIMEOUT */

#define	BLACK_BALL_TIMEOUT	60*10	/* 10 minutes */

black_ball(host)
char *host;
{
	struct string_list *slist;
return; /*ZZZZ*/
#ifdef NOWAY

	/* add to top */
	slist = (struct string_list *)malloc(sizeof(struct string_list *));
	slist->str = (char*)malloc(strlen(host)+1);
	strcpy(slist->str, host);
	slist->when = what_time() + BLACK_BALL_TIMEOUT;
	slist->next = black_ball_list;
	black_ball_list = slist;
#endif
}

check_black_ball_list(host)
char *host;
{
	struct string_list *slist, *slist_last;

	slist = black_ball_list;
	while (slist) {
		if (0== strcmp(slist->str, host)) {
			if (slist->when < what_time()) { /* old information, try it again */
				/* remove from list */
				if (slist == black_ball_list)
				  black_ball_list = slist->next;
				else
				  slist_last->next = slist->next;
				free(slist->str);
				free(slist);
				return 0;
			} else
				return 1; /* a hit */
		} else 
		slist_last = slist;
		slist = slist->next;
	}
	return 0; /* no hits */
}

/***********************************************************************\
*                                    *
* NAME: connect_to_server                        *
*                                    *
* FUNCTION:                                *
*      This routine creates a standard socket and attempts to    *
* connect to the server's well-known port.  If successful, it        *
* returns the socket file descriptor.  Otherwise, it returns a        *
* (-1).                                    *
*                                    *
\***********************************************************************/
int connect_to_server(hostname, port)
char *hostname;
int port;
{
    int s;
	static int whichaddr = -1;
    struct sockaddr_in name;
    unsigned long host_addr;
    struct hostent *addr;
	char line[255];
	char bad_host[255];
    
#ifdef DEBUG
    printf("connect_to_server to %s\n", hostname);
#endif

	sprintf(bad_host, "%s %d", hostname, port);

	if (check_black_ball_list(bad_host)) {
		/* we had bad luck w/ this guy before */
		return (-1);
	}

#ifdef TERM

	lcompression = 1;
	rcompression = 1;
	priority = -2;

	if ((s = connect_server(0)) > 0) 
	{
		if (send_command(s, C_PORT, 0, "%s:%d", hostname, port) < 0)
		{
			fprintf(stderr, "Cannot connect to %s\n", hostname);
			(void)close(s);
			return(-1);
		}
		else
			send_command(s, C_DUMB, 1, 0);
	}
	else
	{
		perror("couldn't connect to term server");
		return(-1);
	}

#else

    /* make a socket to connect to the server with */
    if((s = socket(AF_INET, SOCK_STREAM, 6)) < 0) {
        sprintf(line, "Can't create socket, %s", errstr(errno));
		set_netstat(line);
		fprintf(stderr, "Can't create socket, %s\n", errstr(errno));
        return(-1);
    }

    /* clear out the socket's name */
    bzero((char *)&name, sizeof(name));

    /* assign it to the internet address scheme */
    name.sin_family = AF_INET;
    
    /* get the current host's name */
    if((addr = gethostbyname(hostname)) == NULL) {
        endhostent();
        
        /* didn't work, try it as an IP address */
        host_addr = inet_addr(hostname);

        /* copy the address to the socket's host address field */
        bcopy(&host_addr, (char *)&name.sin_addr, sizeof(struct in_addr));

    } else {
      endhostent();

/*ZZZ - this code isn't clever enough to make use of more than
  2 addresses -- needs work */
	  /* if more than one address comes with this name pick one based
		on my uid so that I'll favour one consistently */
	
	  if (whichaddr==-1) {
	   if (addr->h_addr_list[1]) {	/* there is at least 2 addresses */
		whichaddr = ((int)getuid()) & 1;
	   } else
		whichaddr=0;
	  }


      /* copy the address to the socket's host address field */
	 if (addr->h_addr_list[1]) {
      bcopy(addr->h_addr_list[whichaddr], (char *)&name.sin_addr, addr->h_length);
	 } else {
      bcopy(addr->h_addr_list[0], (char *)&name.sin_addr, addr->h_length);
	 }
    }


    /* set up the port name */
    name.sin_port = htons(port);

    if  (konnekt(s,(struct sockaddr *) &name,sizeof(struct sockaddr_in), 
			KONNEKT_TIMEOUT) < 0) {
	 if (addr->h_addr_list[1]) {
		whichaddr = (whichaddr)?0:1;
        bcopy(addr->h_addr_list[whichaddr], (char *)&name.sin_addr, addr->h_length);
		name.sin_port = htons(port);
	 }
	 if ((!addr->h_addr_list[1]) || /* is another addr to use */
	     (konnekt(s,(struct sockaddr *) &name,sizeof(struct sockaddr_in), 
			KONNEKT_TIMEOUT) < 0))
		{
        sprintf(line, "Error obtaining connection, %s", errstr(errno));
		set_netstat(line);
        fprintf(stderr, "Error connecting to (%s): %s\n", hostname,errstr(errno));
		black_ball(bad_host);
		close(s);
        return(-1);
        } 
    } 

#endif

    return(s);
}



/********************************************************************
***\
*                                   *
* NAME: tsend                               *
*                                   *
* FUNCTION:                             *
*     Tenacious send.  Just like send(2) except that it     *
* will keep trying to get those n bytes until there really      *
* aren't any more.  Returns the number it got or -1 if error.       *
*                                   *
* This routine was adapted from Bob Manchek's tsend.            *
*                                   *
\********************************************************************
***/
int tsend(d, b, n, f)
int d, n, f;
char *b;
{
    int e;
    int x = n;

    while (x > 0) {
        if ((e = send(d, b, x, f)) < 0) {
            return e;
        }
        b += e;
        x -= e;
    }
    return n - x;
}


/* make_dir     Reed Wade 13 Jan 92
 *
 * checks
 *  from left to right creating any dirs needed
*/
make_dir(line, public)
char *line;
int public;
{
    char makeit[MAXLINE];
    register int i;
    int mode;
    
    /*if (public)*/
      mode = umask(0);

    i=1;
    makeit[0] = line[0];
    while (line[i]) {
        if (line[i] == '/') {
            makeit[i] = '\0';
            mkdir(makeit, (public) ? PUB_DIR_MODE : DIR_MODE);
        }
        makeit[i] = line[i];
        i++;
    }
    makeit[i] = line[i];
    mkdir(makeit, (public) ? PUB_DIR_MODE : DIR_MODE);
    
    /*if (public)*/
      umask(mode);

}


static char *strchr(s, c)
char *s, c;
{
    while(*s != NULL && *s != c)
        s++;

    return(*s == NULL ? NULL : s);
}

char *errstr(err)
int err;
{
    switch (err) {
#ifdef ENETDOWN
      case ENETDOWN: return("network is down");
#endif
#ifdef ENETUNREACH
      case ENETUNREACH: return("network is unreachable");
#endif
#ifdef ENETRESET
      case ENETRESET: return("network dropped connection");
#endif
#ifdef ECONNABORTED
      case ECONNABORTED: return("connection aborted");
#endif
#ifdef ECONNRESET
      case ECONNRESET: return("connection reset by peer");
#endif
#ifdef ENOBUFS
      case ENOBUFS: return("no buffer space available");
#endif
#ifdef EISCONN
      case EISCONN: return("socket already connected");
#endif
#ifdef ENOTCONN
      case ENOTCONN: return("socket not connected");
#endif
#ifdef ESHUTDOWN
      case ESHUTDOWN: return("socket shutdown");
#endif
#ifdef ETIMEDOUT
      case ETIMEDOUT: return("connection timed out");
#endif
#ifdef ECONNREFUSED
      case ECONNREFUSED: return("connection refused");
#endif
#ifdef EHOSTDOWN
      case EHOSTDOWN: return("host is down");
#endif
#ifdef EHOSTUNREACH
      case EHOSTUNREACH: return("host is unreachable");
#endif
#ifdef ENOTSOCK
      case ENOTSOCK: return("not a socket");
#endif
#ifdef EDESTADDRREQ
      case EDESTADDRREQ: return("need dest address");
#endif
#ifdef EMSGSIZE
      case EMSGSIZE: return("message too big");
#endif
#ifdef EPROTOTYPE
      case EPROTOTYPE: return("bad protocol");
#endif
#ifdef ENOPROTOOPT
      case ENOPROTOOPT: return("protocol not available");
#endif
#ifdef EPROTONOSUPPORT
      case EPROTONOSUPPORT: return("protocol not supported");
#endif
#ifdef ESOCKTNOSUPPORT
      case ESOCKTNOSUPPORT: return("socket not supported");
#endif
#ifdef EOPNOTSUPP
      case EOPNOTSUPP: return("operation not supported on socket");
#endif
#ifdef EPFNOSUPPORT
      case EPFNOSUPPORT: return("protocol family not supported");
#endif
#ifdef EAFNOSUPPORT
      case EAFNOSUPPORT: return("address family not supported");
#endif
#ifdef EADDRINUSE
      case EADDRINUSE: return("addresss already in use");
#endif
#ifdef EADDRNOTAVAIL
      case EADDRNOTAVAIL: return("can't assign requested address");
#endif
      default: return("connection error");
    }
}





/* nlrexec_open extracts service and host from str, then calls
    nlrexec_service_open    */
nlrexec_open(str, email)
char *str, *email;
{
    char service[255], host[255], portStr[255];
    register int i;

/*
printf("<%s> @ <%s>\n", str, email);
*/

    strcpy(service, str);
    /* now terminate at the space */
    for (i=0; service[i] && (service[i] != ' '); i++) ;
    if (service[i]) {
        service[i] = '\0';
    } else {
        fprintf(stderr, "no host name (%s)\n", str);
        return 0;
    }

    strcpy(host, str +strlen(service) +1);

    return nlrexec_service_open(service, host, email);
}



nlrexec_service_open(service, _host, email)
char *service, *_host, *email;
{
    char host[255], portStr[255];
    int s;
    register int i;
    char buf[1024];
    int port;

/*
printf("service open <%s> <%s> <%s>\n", service, _host, email);
*/
    strcpy(host, _host);

    /* terminate at +, if there */
    for (i=0; host[i] && (host[i] != '+'); i++) ;
    if (host[i]) {  /* port is specified */
        strcpy(portStr, host +i +1);
        host[i] = '\0';
        if (1 != sscanf(portStr, "%d", &port)) {
            fprintf(stderr, "bad port spec (%s) of (%s)\n", portStr, host);
            port = SERVER_PORT;
        }
    } else {
        port = SERVER_PORT;
    }

    if ((s = connect_to_server(host, port)) < 0) {
        return 0;
    }

    sprintf(buf, "%s\n", email);
    swrite(s, buf);
    sprintf(buf, "%s\n", service);
    swrite(s, buf);

    return s;
}

int netlib_open(host, service, fname, lib, email, public)
char *host, *service, *fname, *lib, *email;
int public;
{
    int s, port;
    int i;
    char buf[BUFSIZE], hostname[BUFSIZE];

    strcpy(filename, fname);
    strcpy(library, lib);

    LC(filename);
    LC(library);
        
    port = SERVER_PORT;

	/* look to see if a port is imbedded in the host name 
		of the form host.domain/port */
	strcpy(hostname, host);
    for (i= strlen(hostname); (i && (hostname[i] != '+')); i--) ;

	if (i) { /* there's a port */
      if (1 != sscanf(hostname +i+1, "%d", &port)) {
	    fprintf(stderr, "Couldn't get port number from %s\n", host);
		return(0);
	  }
	  hostname[i] = '\0'; /* plug it up */
	}
    

#ifdef DEBUG
    printf("netlib_open(%s, %s, %s) BEGIN \n",
    	host, fname, lib);
#endif

    /* connect to the server */
    if((s = connect_to_server(hostname, port)) < 0) {
        return(0);
    } else {
		set_netstat("connected to server...");

        sprintf(buf, "%s\n", email);
        swrite(s, buf);
        sprintf(buf, "%s\n", service);
        swrite(s, buf);
        sprintf(buf, "/%s/%s\n", library, filename);
        swrite(s, buf);

    }

#ifdef DEBUG
    printf("netlib_open() END %d\n", s);
#endif

    return(s);
}

sget_line(s, buf)
int s;
char *buf;
{
    int i, retval;

    i = -1;
    do {
        i++;
        retval = read(s, buf +i, 1);
    } while ((retval > 0) && (buf[i] != '\n'));

    while (isspace(buf[i])) i--;
    buf[i+1] = '\0';

    if (retval > 0)
        return i+1;
    else
        return 0;
}
