/*
** defs.h - For the finger distribution.
**
** Written by Keith Gabryelski
** Released into public domain September 1, 1988.
** Please keep this header.
*/

/*
** Your system type.  Define only one.  Also look at the end of
** finger.h
*/

#define SCO_XENIX_386		/* SCO Xenix 386 machines. */
/*#define SCO_XENIX_286		/* SCO Xenix 286 machines - NOT TESTED. */
/*#define UNIX_PC		/* The 3B1 and 7300 machines. */
/*#define SYSV_3B5		/* The 3B5 machine - NOT TESTED. */

/*
** NLIST_FILE is used to store kernel symbols so we don't have to nlist
** the kernel every time.
*/

#define	NLIST_FILE	"/usr/lib/finger/nlist"

/*
** WHOIS_DBASE_DIR -
** A directory for keeping data base files on individual users.  
*/

#define	WHOIS_DBASE_DIR	"/usr/lib/finger/dbase"

/*
** BIRTHDAY_CARD -
** The birthday that the birthday wizard will send to users at the
** appropriate time.
**/

#define BIRTHDAY_CARD	"/usr/lib/finger/birthday_card"

/*
** PLAN_FILE -
** Name of the users plan file.  This file contains the users over all
** `plan' in life.  It is kept in the users home directory.
*/

#define PLAN_FILE	".plan"

/*
** FORWARD_FILE -
** File containing site and user name where mail is forwarded for
** the user.  This file is kept in the users home directory.
*/

#define FORWARD_FILE	".forward"

/*
** MAIL_SPOOL_DIR
** Where is mail kept?
*/

#define MAIL_SPOOL_DIR	"/usr/spool/mail"

/*
** MAILER -
** How do we mail things?
*/

#define MAILER		"/usr/bin/smail"

/*
** Below here are things you probably do not want to change.
*/

#undef TRUE
#undef FALSE
#define TRUE			1
#define FALSE			0

#define FAIL			-1
#define OK			0

#define STAT_OWRITE		0x002

/*
** Below here are things that cannot be modified or the distribution
** will surely not work.
**
** Thanks should also go out to Neil Pert for awesome percussion. -MQH
*/

#define SIGNIFICANT_OTHER	"Marla Gabryelski"

#define	MUSICIAN		"Brian_Eno"
#define	SONG			"Third_Uncle"

#define VERNUM			1
#define PATCHLEVEL		0

#define AUTHOR			"Keith M. Gabryelski"
#define ADDRESS			"ag@elgar.UUCP"
#define ALTPATH			"ag@portnoy.UUCP"
#define THANKS1			"ford@kenobi.UUCP (Mike Ditto)"
