/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import spec.jbb.Company;
import spec.jbb.JBButil;
import spec.jbb.TimerData;
import spec.jbb.Transaction;
import spec.jbb.Warehouse;

class TransactionManager {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996-2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private short warehouseId;
    public Company.runModes mode = Company.runModes.DEFAULT_MODE;
    private static final byte new_order = 0;
    private static final byte payment = 1;
    private static final byte order_status = 2;
    private static final byte delivery = 3;
    private static final byte stock_level = 4;
    private static final byte cust_report = 5;
    private static final byte maxTxnTypes;
    private static final byte multiple_orders;
    private static final byte pgm_exit;
    private Transaction[] transactionInstance;

    TransactionManager() {
    }

    public void initTransactionManager(Company company, short s) {
        this.company = company;
        this.warehouseId = s;
        JBButil.random(1, (int)this.company.getMaxDistrictsPerWarehouse(), s);
    }

    private void createTxnInstances() {
        this.transactionInstance = new Transaction[maxTxnTypes];
        for (int i = 0; i < maxTxnTypes; ++i) {
            this.transactionInstance[i] = Transaction.getInstance(Transaction.transactionClasses[i], this.company, this.warehouseId);
        }
    }

    private void manualSelection() {
        System.out.println("Select transaction type");
        System.out.println();
        for (int i = 0; i < maxTxnTypes; ++i) {
            try {
                System.out.println(i + 1 + ". " + Transaction.transactionClasses[i].getMethod("getMenuName", null).invoke(null, (Object[])null));
                continue;
            }
            catch (Exception exception) {
                JBButil.getLog().log(Level.WARNING, "TransactionManager.manualSelection - NoSuchMethodException, or IllegalAccessException", exception);
            }
        }
        System.out.println(multiple_orders + 1 + ". Create NewOrders");
        System.out.println(pgm_exit + 1 + ". Exit");
        System.out.println();
        System.out.println("Enter selection here: ");
    }

    private String readUserValue() {
        String string = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private long runTxn(Transaction transaction, long l, long l2, double d) {
        transaction.init();
        if (l > 0L) {
            JBButil.milliSecondsToSleep(l);
        }
        transaction.initializeTransactionLog();
        if (l2 > 0L) {
            JBButil.milliSecondsToSleep(l2);
        }
        long l3 = System.currentTimeMillis();
        transaction.process();
        transaction.processTransactionLog();
        long l4 = System.currentTimeMillis();
        if (d > 0.0) {
            JBButil.SecondsToSleep(d);
        }
        return l4 - l3;
    }

    private long goManual(int n, TimerData timerData) {
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        if (this.isMultiple(n)) {
            long l3 = 0L;
            System.out.println("How many orders to be created? ");
            l3 = new Integer(this.readUserValue()).intValue();
            System.out.println("Creating New Orders...");
            int n2 = 0;
            while ((long)n2 < l3) {
                this.transactionInstance[0].init();
                this.transactionInstance[0].process();
                ++n2;
            }
            return 0L;
        }
        if (n < maxTxnTypes) {
            l = timerData.getMenuWaitTime(n);
            l2 = timerData.getTypingWaitTime(n);
            d = JBButil.negativeExpDistribution((double)timerData.getThinkingWaitTime(n) / 1000.0, this.warehouseId);
        }
        return this.runTxn(this.transactionInstance[n], l, l2, d);
    }

    boolean isMultiple(int n) {
        return n == multiple_orders;
    }

    public synchronized Company.runModes getrunMode() {
        return this.mode;
    }

    public synchronized void setrunMode(Company.runModes runModes2) {
        this.mode = runModes2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        int n;
        boolean bl = false;
        int[] nArray = new int[33];
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        TimerData timerData = this.company.getTimerDataPtr(this.warehouseId);
        long l = timerData.getRampUpTime();
        long l2 = timerData.getMeasurementTime();
        TimerData timerData2 = new TimerData();
        timerData2.setWaitTimes(timerData.getWaitTimes());
        nArray = this.buildDeck();
        Warehouse warehouse = this.company.getWarehousePtr(this.warehouseId, false);
        this.createTxnInstances();
        Object object = this.company.initThreadsCountMonitor;
        synchronized (object) {
            Object object2 = this.company.initThreadsStateChange;
            synchronized (object2) {
                ++this.company.initThreadsCount;
                this.company.initThreadsStateChange.notify();
            }
            try {
                this.company.initThreadsCountMonitor.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (l > 0L || l2 > 0L) {
            bl2 = true;
        }
        if (JBButil.getLog().isLoggable(Level.FINEST)) {
            JBButil.getLog().finest("Benchmark SPECjbb2005 1.05: warehouse " + this.warehouseId);
        }
        while (this.getrunMode() != Company.runModes.STOP) {
            if (!bl2 && this.getrunMode() == Company.runModes.DEFAULT_MODE) {
                this.manualSelection();
                n = new Integer(this.readUserValue()) - 1;
            } else {
                n = nArray[n2];
                if (++n2 == 33) {
                    nArray = this.buildDeck();
                    n2 = 0;
                }
            }
            long l3 = this.goManual(n, timerData2);
            if (this.getrunMode() == Company.runModes.RECORDING) {
                timerData2.updateTimerData(n, l3);
            }
            if (bl2) {
                if (this.getrunMode() != Company.runModes.RAMP_DOWN || bl3) continue;
                object = this.company.threadsDoneCountMonitor;
                synchronized (object) {
                    ++this.company.threadsDoneCount;
                    this.company.threadsDoneCountMonitor.notify();
                    bl3 = true;
                    continue;
                }
            }
            if (n != pgm_exit) continue;
        }
        if (bl2 && this.getrunMode() == Company.runModes.STOP) {
            long l4 = this.company.getElapsedTime();
            timerData2.calculateResponseTimeStats();
            double d = timerData2.updateTPMC(l4);
            double d2 = timerData2.updateBTPS(l4);
            long l5 = 0L;
            for (n = 0; n < maxTxnTypes; ++n) {
                timerData.rollupTimerData(n, timerData2.getTransactionCount(n), timerData2.getTotalTime(n), timerData2.getTotalTimeSquare(n), timerData2.getMinimumTime(n), timerData2.getMaximumTime(n));
                this.company.getTimerDataPtr((short)(bl ? 1 : 0)).rollupTimerData(n, timerData2.getTransactionCount(n), timerData2.getTotalTime(n), timerData2.getTotalTimeSquare(n), timerData2.getMinimumTime(n), timerData2.getMaximumTime(n));
                l5 += timerData2.getTransactionCount(n);
            }
            this.company.getTimerDataPtr((short)(bl ? 1 : 0)).accumulateTransactionStats(l5);
            timerData.updateTPMC(d);
            timerData.updateBTPS(d2);
            this.company.getTimerDataPtr((short)(bl ? 1 : 0)).updateTPMC(d);
            this.company.getTimerDataPtr((short)(bl ? 1 : 0)).updateBTPS(d2);
            Object object3 = this.company.stopThreadsCountMonitor;
            synchronized (object3) {
                ++this.company.stopThreadsCount;
                this.company.stopThreadsCountMonitor.notify();
            }
        }
    }

    public boolean goValidate() {
        int n;
        Transaction[] transactionArray = new Transaction[maxTxnTypes];
        Transaction.validateRun();
        for (n = 0; n < maxTxnTypes; ++n) {
            transactionArray[n] = Transaction.getInstance(Transaction.transactionClasses[n], this.company, this.warehouseId);
        }
        for (n = 0; n < maxTxnTypes; ++n) {
            transactionArray[n].init();
            transactionArray[n].initializeTransactionLog();
            transactionArray[n].process();
            transactionArray[n].processTransactionLog();
        }
        return Transaction.isRunValid();
    }

    public int[] buildDeck() {
        int n;
        int n2;
        int[] nArray = new int[33];
        int[] nArray2 = new int[33];
        for (n2 = 0; n2 < 33; ++n2) {
            nArray2[n2] = n2;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            n = JBButil.random(0, 32 - n2, this.warehouseId);
            nArray[nArray2[n]] = 0;
            nArray2[n] = nArray2[32 - n2];
        }
        for (n2 = 0; n2 < 10; ++n2) {
            n = JBButil.random(0, 22 - n2, this.warehouseId);
            nArray[nArray2[n]] = 1;
            nArray2[n] = nArray2[22 - n2];
        }
        n = JBButil.random(0, 12, this.warehouseId);
        nArray[nArray2[n]] = 2;
        nArray2[n] = nArray2[12];
        n = JBButil.random(0, 11, this.warehouseId);
        nArray[nArray2[n]] = 3;
        nArray2[n] = nArray2[11];
        n = JBButil.random(0, 10, this.warehouseId);
        nArray[nArray2[n]] = 4;
        nArray2[n] = nArray2[10];
        for (n2 = 0; n2 < 10; ++n2) {
            n = JBButil.random(0, 9 - n2, this.warehouseId);
            nArray[nArray2[n]] = 5;
        }
        return nArray;
    }

    static {
        multiple_orders = maxTxnTypes = Transaction.maxTxnTypes;
        pgm_exit = (byte)(multiple_orders + 2);
    }
}

