module LargeGraphNoSolution

  DEMANDS = [["nodejs", "= 0.1.0"],
             ["rabbitmq", "= 0.1.0"],
             ["sensu", "= 0.1.0"],
             ["annoyances", "= 1.0.1"],
             ["apt", "= 2.3.9"],
             ["ark", "= 0.7.3"],
             ["avahi-daemon", "= 0.0.14"],
             ["aws", "= 2.1.2"],
             ["chef-server", "= 2.1.5"],
             ["chef_handler", "= 1.1.5"],
             ["dmg", "= 2.1.5"],
             ["dynect", "= 1.0.5"],
             ["ec2", ">= 0.0.0"],
             ["elasticsearch", "= 0.3.8"],
             ["ganglia", "= 0.2.1"],
             ["git", "= 2.8.5"],
             ["graphite", "= 0.4.8"],
             ["homebrew", "= 1.5.5"],
             ["ircd-ratbox", ">= 0.0.0"],
             ["java", "= 1.22.1"],
             ["jenkins", "= 2.0.3"],
             ["kibana", "= 0.1.7"],
             ["logstash", "= 0.7.6"],
             ["minitest-handler", "= 1.1.5"],
             ["monit", "= 0.7.3"],
             ["mysql", "= 5.0.3"],
             ["nginx", "= 2.5.1"],
             ["ntp", "= 1.6.3"],
             ["omnibus_updater", "= 1.0.0"],
             ["openswan", "= 0.3.0"],
             ["openvpn", "= 3.0.1"],
             ["php", "= 1.4.7"],
             ["postfix", "= 3.0.5"],
             ["postgresql", "= 3.3.4"],
             ["powershell", "= 3.0.1"],
             ["python", "= 1.4.7"],
             ["rbenv", "= 1.7.1"],
             ["rsyslog", "= 1.12.3"],
             ["ruby_build", "= 0.8.1"],
             ["runit", "= 1.5.11"],
             ["rvm", "= 0.9.2"],
             ["statsd", "= 1.1.5"],
             ["sysctl", "= 0.3.5"],
             ["ubuntu", "= 1.1.7"],
             ["vagrant-cookbook", "= 0.2.0"],
             ["varnish", "= 0.9.13"],
             ["vim", "= 1.1.3"],
             ["virtualbox-cookbook", "= 1.0.3"],
             ["windows", "= 1.30.1"],
             ["yum", "= 2.4.5"]].freeze
  ARTIFACTS =
    { "nodejs" =>
      [{ name: "nodejs", version: "0.1.0", dependencies: [] },
       { name: "nodejs",
         version: "1.3.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "1.1.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "1.1.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "1.0.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "1.0.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.6.11",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.6.8",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.6.5",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.6.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.5.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.5.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.4.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.4.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.2.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "nodejs",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "rabbitmq" =>
      [{ name: "rabbitmq",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "rabbitmq",
         version: "3.1.0",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "3.0.4",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "3.0.2",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "3.0.0",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "2.4.2",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "2.4.0",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "2.3.2",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "2.3.0",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "2.1.2",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "2.1.0",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "2.0.0",
         dependencies: [["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.8.0",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.7.0",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.6.4",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.6.2",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.6.0",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.5.0",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.4.0",
         dependencies: [["apt", ">= 1.1.0"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.3.2",
         dependencies: [["apt", ">= 1.1.0"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq",
         version: "1.3.0",
         dependencies: [["apt", ">= 1.1.0"], ["yum", ">= 0.5.0"], ["erlang", ">= 0.9.0"]] },
       { name: "rabbitmq", version: "1.2.1", dependencies: [["apt", "> 1.1.0"]] },
       { name: "rabbitmq", version: "1.2.0", dependencies: [["apt", "> 1.1.0"]] },
       { name: "rabbitmq", version: "1.1.0", dependencies: [["apt", "> 1.1.0"]] },
       { name: "rabbitmq", version: "1.0.0", dependencies: [] },
       { name: "rabbitmq", version: "0.3.0", dependencies: [] }],
      "sensu" =>
      [{ name: "sensu",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.8.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redisio", ">= 1.7.0"]] },
       { name: "sensu",
         version: "0.7.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redisio", ">= 1.7.0"]] },
       { name: "sensu",
         version: "0.7.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redisio", ">= 1.7.0"]] },
       { name: "sensu",
         version: "0.6.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redisio", ">= 1.7.0"]] },
       { name: "sensu",
         version: "0.6.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redisio", ">= 1.7.0"]] },
       { name: "sensu",
         version: "0.6.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redisio", ">= 1.7.0"]] },
       { name: "sensu",
         version: "0.5.6",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redisio", ">= 1.7.0"]] },
       { name: "sensu",
         version: "0.5.5",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redis", ">= 2.1.0"]] },
       { name: "sensu",
         version: "0.5.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redis", ">= 2.1.0"]] },
       { name: "sensu",
         version: "0.5.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redis", ">= 2.1.0"]] },
       { name: "sensu",
         version: "0.5.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redis", ">= 2.1.0"]] },
       { name: "sensu",
         version: "0.5.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 1.8.8"],
          ["rabbitmq", ">= 2.0.0"],
          ["redis", ">= 2.1.0"]] },
       { name: "sensu",
         version: "0.4.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.3.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.1.6",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.1.5",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.1.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.0.9",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.0.8",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.0.7",
         dependencies: [["rabbitmq", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.0.6",
         dependencies: [["rabbitmq", ">= 0.0.0"], ["redis", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.0.3",
         dependencies: [["rabbitmq", ">= 0.0.0"], ["redis", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "sensu",
         version: "0.0.1",
         dependencies: [["rabbitmq", ">= 0.0.0"], ["redis", ">= 0.0.0"]] }],
      "annoyances" =>
      [{ name: "annoyances", version: "1.0.1", dependencies: [] },
       { name: "annoyances", version: "1.0.0", dependencies: [] },
       { name: "annoyances", version: "0.4.1", dependencies: [] },
       { name: "annoyances", version: "0.4.0", dependencies: [] },
       { name: "annoyances", version: "0.3.0", dependencies: [] },
       { name: "annoyances", version: "0.2.0", dependencies: [] },
       { name: "annoyances", version: "0.1.0", dependencies: [] },
       { name: "annoyances", version: "0.0.2", dependencies: [] },
       { name: "annoyances", version: "0.0.1", dependencies: [] }],
      "apt" =>
      [{ name: "apt", version: "2.3.9", dependencies: [] },
       { name: "apt", version: "1.8.4", dependencies: [] },
       { name: "apt", version: "1.9.2", dependencies: [] },
       { name: "apt", version: "2.3.8", dependencies: [] },
       { name: "apt", version: "2.3.6", dependencies: [] },
       { name: "apt", version: "2.3.4", dependencies: [] },
       { name: "apt", version: "2.3.0", dependencies: [] },
       { name: "apt", version: "2.2.1", dependencies: [] },
       { name: "apt", version: "2.2.0", dependencies: [] },
       { name: "apt", version: "2.1.2", dependencies: [] },
       { name: "apt", version: "2.1.1", dependencies: [] },
       { name: "apt", version: "2.1.0", dependencies: [] },
       { name: "apt", version: "2.0.0", dependencies: [] },
       { name: "apt", version: "1.10.0", dependencies: [] },
       { name: "apt", version: "1.9.0", dependencies: [] },
       { name: "apt", version: "1.8.2", dependencies: [] },
       { name: "apt", version: "1.8.0", dependencies: [] },
       { name: "apt", version: "1.7.0", dependencies: [] },
       { name: "apt", version: "1.6.0", dependencies: [] },
       { name: "apt", version: "1.5.0", dependencies: [] },
       { name: "apt", version: "1.4.8", dependencies: [] },
       { name: "apt", version: "1.4.6", dependencies: [] },
       { name: "apt", version: "1.4.4", dependencies: [] },
       { name: "apt", version: "1.4.2", dependencies: [] },
       { name: "apt", version: "1.4.0", dependencies: [] },
       { name: "apt", version: "1.3.2", dependencies: [] },
       { name: "apt", version: "1.3.0", dependencies: [] },
       { name: "apt", version: "1.2.2", dependencies: [] },
       { name: "apt", version: "1.2.0", dependencies: [] },
       { name: "apt", version: "1.1.2", dependencies: [] },
       { name: "apt", version: "1.1.1", dependencies: [] },
       { name: "apt", version: "1.1.0", dependencies: [] },
       { name: "apt", version: "1.0.0", dependencies: [] },
       { name: "apt", version: "0.9.3", dependencies: [] },
       { name: "apt", version: "0.9.2", dependencies: [] },
       { name: "apt", version: "0.9.0", dependencies: [] },
       { name: "apt", version: "0.8.0", dependencies: [] }],
      "ark" =>
      [{ name: "ark", version: "0.7.3", dependencies: [] },
       { name: "ark", version: "0.7.2", dependencies: [] },
       { name: "ark", version: "0.7.0", dependencies: [] },
       { name: "ark", version: "0.6.0", dependencies: [] },
       { name: "ark", version: "0.5.0", dependencies: [] },
       { name: "ark", version: "0.4.2", dependencies: [] },
       { name: "ark", version: "0.4.0", dependencies: [] },
       { name: "ark", version: "0.3.2", dependencies: [] },
       { name: "ark", version: "0.3.0", dependencies: [] },
       { name: "ark", version: "0.2.4", dependencies: [] },
       { name: "ark", version: "0.2.2", dependencies: [] },
       { name: "ark", version: "0.2.0", dependencies: [] },
       { name: "ark", version: "0.1.0", dependencies: [] },
       { name: "ark", version: "0.0.17", dependencies: [] },
       { name: "ark", version: "0.0.16", dependencies: [] },
       { name: "ark", version: "0.0.15", dependencies: [] },
       { name: "ark", version: "0.0.11", dependencies: [] },
       { name: "ark", version: "0.0.10", dependencies: [] },
       { name: "ark", version: "0.0.9", dependencies: [] },
       { name: "ark", version: "0.0.8", dependencies: [["java", ">= 0.0.0"]] },
       { name: "ark", version: "0.0.1", dependencies: [["java", ">= 0.0.0"]] }],
      "avahi-daemon" =>
      [{ name: "avahi-daemon", version: "0.0.14", dependencies: [] },
       { name: "avahi-daemon", version: "0.0.12", dependencies: [] },
       { name: "avahi-daemon", version: "0.0.10", dependencies: [] },
       { name: "avahi-daemon", version: "0.0.8", dependencies: [] },
       { name: "avahi-daemon", version: "0.0.6", dependencies: [] },
       { name: "avahi-daemon", version: "0.0.4", dependencies: [] }],
      "aws" =>
      [{ name: "aws", version: "2.1.2", dependencies: [] },
       { name: "aws", version: "2.1.1", dependencies: [] },
       { name: "aws", version: "2.1.0", dependencies: [] },
       { name: "aws", version: "2.0.0", dependencies: [] },
       { name: "aws", version: "1.0.0", dependencies: [] },
       { name: "aws", version: "0.101.6", dependencies: [] },
       { name: "aws", version: "0.101.4", dependencies: [] },
       { name: "aws", version: "0.101.2", dependencies: [] },
       { name: "aws", version: "0.101.0", dependencies: [] },
       { name: "aws", version: "0.100.6", dependencies: [] },
       { name: "aws", version: "0.100.4", dependencies: [] },
       { name: "aws", version: "0.100.2", dependencies: [] },
       { name: "aws", version: "0.100.0", dependencies: [] },
       { name: "aws", version: "0.99.1", dependencies: [] },
       { name: "aws", version: "0.99.0", dependencies: [] },
       { name: "aws", version: "0.10.1", dependencies: [] },
       { name: "aws", version: "0.10.0", dependencies: [] },
       { name: "aws", version: "0.9.0", dependencies: [] }],
      "chef-server" =>
      [{ name: "chef-server", version: "2.1.5", dependencies: [] },
       { name: "chef-server", version: "2.1.4", dependencies: [] },
       { name: "chef-server",
         version: "2.1.2",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "chef-server",
         version: "2.1.0",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "chef-server", version: "2.0.1", dependencies: [] },
       { name: "chef-server", version: "2.0.0", dependencies: [] },
       { name: "chef-server",
         version: "1.1.0",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["gecode", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"]] },
       { name: "chef-server",
         version: "1.0.0",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["gecode", ">= 0.0.0"]] },
       { name: "chef-server",
         version: "0.99.12",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["gecode", ">= 0.0.0"]] },
       { name: "chef-server",
         version: "0.99.11",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["gecode", ">= 0.0.0"]] },
       { name: "chef-server",
         version: "0.99.10",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["gecode", ">= 0.0.0"]] }],
      "chef_handler" =>
      [{ name: "chef_handler", version: "1.1.5", dependencies: [] },
       { name: "chef_handler", version: "1.1.4", dependencies: [] },
       { name: "chef_handler", version: "1.1.2", dependencies: [] },
       { name: "chef_handler", version: "1.1.0", dependencies: [] },
       { name: "chef_handler", version: "1.0.8", dependencies: [] },
       { name: "chef_handler", version: "1.0.6", dependencies: [] },
       { name: "chef_handler", version: "1.0.4", dependencies: [] },
       { name: "chef_handler", version: "1.0.2", dependencies: [] },
       { name: "chef_handler", version: "1.0.0", dependencies: [] }],
      "dmg" =>
      [{ name: "dmg", version: "2.1.5", dependencies: [] },
       { name: "dmg", version: "1.1.0", dependencies: [] },
       { name: "dmg", version: "2.2.0", dependencies: [] },
       { name: "dmg", version: "2.1.4", dependencies: [] },
       { name: "dmg", version: "2.1.2", dependencies: [] },
       { name: "dmg", version: "2.1.0", dependencies: [] },
       { name: "dmg", version: "2.0.8", dependencies: [] },
       { name: "dmg", version: "2.0.6", dependencies: [] },
       { name: "dmg", version: "2.0.4", dependencies: [] },
       { name: "dmg", version: "2.0.2", dependencies: [] },
       { name: "dmg", version: "2.0.0", dependencies: [] },
       { name: "dmg", version: "1.0.0", dependencies: [] },
       { name: "dmg", version: "0.7.0", dependencies: [] },
       { name: "dmg", version: "0.6.0", dependencies: [] },
       { name: "dmg", version: "0.5.2", dependencies: [] },
       { name: "dmg", version: "0.5.1", dependencies: [] },
       { name: "dmg", version: "0.5.0", dependencies: [] }],
      "dynect" =>
      [{ name: "dynect", version: "1.0.5", dependencies: [] },
       { name: "dynect", version: "1.0.4", dependencies: [] },
       { name: "dynect", version: "1.0.2", dependencies: [] },
       { name: "dynect", version: "1.0.0", dependencies: [] },
       { name: "dynect", version: "0.3.2", dependencies: [] },
       { name: "dynect", version: "0.2.0", dependencies: [] }],
      "elasticsearch" =>
      [{ name: "elasticsearch",
         version: "0.3.8",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["monit", ">= 0.0.0"],
          ["ark", ">= 0.2.4"]] },
       { name: "elasticsearch",
         version: "0.3.7",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.3.5",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.3.4",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.3.3",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.3.2",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.3.1",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.3.0",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.2.7",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.2.5",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.2.4",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.2.3",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.2.2",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.2.1",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.2.0",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "elasticsearch",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"], ["bluepill", ">= 0.0.0"]] }],
      "ganglia" =>
      [{ name: "ganglia",
         version: "0.2.1",
         dependencies: [["graphite", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "ganglia", version: "0.2.0", dependencies: [] },
       { name: "ganglia", version: "0.1.1", dependencies: [] },
       { name: "ganglia", version: "0.1.0", dependencies: [] },
       { name: "ganglia", version: "0.0.2", dependencies: [] },
       { name: "ganglia", version: "0.0.1", dependencies: [] }],
      "git" =>
      [{ name: "git",
         version: "2.8.5",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["yum", "< 3.0.0"],
          ["runit", ">= 1.0.0"]] },
       { name: "git",
         version: "2.3.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", "~> 1.0"]] },
       { name: "git",
         version: "4.0.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "git",
         version: "3.1.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "git",
         version: "3.0.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "git",
         version: "2.10.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "git",
         version: "2.9.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "git",
         version: "2.8.4",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["yum", "< 3.0.0"],
          ["runit", ">= 1.0.0"]] },
       { name: "git",
         version: "2.8.1",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["yum", "< 3.0.0"],
          ["runit", ">= 1.0.0"]] },
       { name: "git",
         version: "2.7.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"]] },
       { name: "git",
         version: "2.6.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"]] },
       { name: "git",
         version: "2.5.2",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"]] },
       { name: "git",
         version: "2.5.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", ">= 1.0.0"]] },
       { name: "git",
         version: "2.4.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", "~> 1.0"]] },
       { name: "git",
         version: "2.2.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", "<= 0.16.2"]] },
       { name: "git",
         version: "2.1.4",
         dependencies: [["dmg", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["runit", "<= 0.16.2"]] },
       { name: "git",
         version: "2.1.2",
         dependencies: [["dmg", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"]] },
       { name: "git",
         version: "2.1.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"]] },
       { name: "git",
         version: "1.1.2",
         dependencies: [["dmg", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"]] },
       { name: "git",
         version: "1.1.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["windows", ">= 0.0.0"]] },
       { name: "git",
         version: "2.0.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["dmg", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "git",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["dmg", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "git",
         version: "1.0.0",
         dependencies: [["runit", ">= 0.0.0"], ["yum", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] },
       { name: "git",
         version: "0.10.0",
         dependencies: [["runit", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "git", version: "0.9.0", dependencies: [["runit", ">= 0.0.0"]] },
       { name: "git", version: "0.8.1", dependencies: [["runit", ">= 0.0.0"]] },
       { name: "git", version: "0.8.0", dependencies: [["runit", ">= 0.0.0"]] },
       { name: "git",
         version: "0.7.0",
         dependencies: [["runit", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "graphite" =>
      [{ name: "graphite",
         version: "0.4.8",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", "~> 1.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.4.7",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", "~> 1.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.4.6",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", "~> 1.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.4.5",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", "~> 1.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.4.3",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", "~> 1.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.4.2",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", "<= 0.16.2"],
          ["memcached", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.4.1",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", "<= 0.16.2"],
          ["memcached", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.4.0",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.3.0",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.2.0",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.1.3",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.1.2",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.1.1",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.1.0",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.0.5",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ganglia", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.0.4",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ganglia", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.0.3",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ganglia", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.0.2",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "graphite",
         version: "0.0.1",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "homebrew" =>
      [{ name: "homebrew", version: "1.5.5", dependencies: [] },
       { name: "homebrew", version: "1.3.2", dependencies: [] },
       { name: "homebrew", version: "1.5.4", dependencies: [] },
       { name: "homebrew", version: "1.5.2", dependencies: [] },
       { name: "homebrew", version: "1.5.0", dependencies: [] },
       { name: "homebrew", version: "1.4.0", dependencies: [] },
       { name: "homebrew", version: "1.3.0", dependencies: [] },
       { name: "homebrew", version: "1.2.0", dependencies: [] },
       { name: "homebrew", version: "1.0.0", dependencies: [] }],
      "java" =>
      [{ name: "java", version: "1.22.1", dependencies: [] },
       { name: "java", version: "1.22.0", dependencies: [] },
       { name: "java",
         version: "1.9.6",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java", version: "1.21.2", dependencies: [] },
       { name: "java", version: "1.21.0", dependencies: [] },
       { name: "java", version: "1.20.0", dependencies: [] },
       { name: "java", version: "1.19.2", dependencies: [] },
       { name: "java", version: "1.19.0", dependencies: [] },
       { name: "java", version: "1.18.0", dependencies: [] },
       { name: "java",
         version: "1.17.6",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.17.4",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.17.2",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.17.0",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.16.4",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.16.2",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.16.0",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.15.4",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.15.2",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.15.0",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "0.15.2",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.14.0",
         dependencies: [["windows", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "java",
         version: "1.13.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.12.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.11.6",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.11.4",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.11.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.11.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.10.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.10.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.9.4",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.9.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.9.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.8.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java",
         version: "1.8.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "java", version: "1.7.0", dependencies: [] },
       { name: "java", version: "1.6.4", dependencies: [] },
       { name: "java", version: "1.6.2", dependencies: [] },
       { name: "java", version: "1.6.0", dependencies: [] },
       { name: "java", version: "1.5.4", dependencies: [] },
       { name: "java", version: "1.5.2", dependencies: [] },
       { name: "java", version: "1.5.0", dependencies: [] },
       { name: "java", version: "1.4.2", dependencies: [] },
       { name: "java", version: "1.4.0", dependencies: [] },
       { name: "java", version: "1.1.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "java", version: "1.0.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "java", version: "0.10.3", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "java", version: "0.10.2", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "java", version: "0.10.0", dependencies: [] },
       { name: "java", version: "0.7.0", dependencies: [] }],
      "jenkins" =>
      [{ name: "jenkins",
         version: "2.0.3",
         dependencies: [["apt", "~> 2.0"], ["runit", "~> 1.5"], ["yum", "~> 3.0"]] },
       { name: "jenkins",
         version: "1.2.2",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "jenkins",
         version: "2.0.2",
         dependencies: [["apt", "~> 2.0"], ["runit", "~> 1.5"], ["yum", "~> 3.0"]] },
       { name: "jenkins",
         version: "2.0.0",
         dependencies: [["apt", "~> 2.0"], ["runit", "~> 1.5"], ["yum", "~> 3.0"]] },
       { name: "jenkins",
         version: "1.2.0",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "jenkins",
         version: "1.1.0",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "jenkins",
         version: "1.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 1.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "jenkins",
         version: "0.6.3",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "jenkins",
         version: "0.6.2",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "jenkins",
         version: "0.6.1",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "jenkins",
         version: "0.6.0",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "kibana" =>
      [{ name: "kibana",
         version: "0.1.7",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "kibana",
         version: "0.1.6",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "kibana", version: "0.1.2", dependencies: [] },
       { name: "kibana", version: "0.1.0", dependencies: [] }],
      "logstash" =>
      [{ name: "logstash",
         version: "0.7.6",
         dependencies: [["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ant", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.5.9",
         dependencies: [["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["ant", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["yumrepo", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.5.8",
         dependencies: [["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["ant", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["yumrepo", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.5.7",
         dependencies: [["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["ant", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["yumrepo", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.5.5",
         dependencies: [["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["ant", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["yumrepo", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.5.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["ant", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.3.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["ant", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.2.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["ant", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["ant", ">= 0.0.0"]] },
       { name: "logstash",
         version: "0.0.1",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"]] }],
      "minitest-handler" =>
      [{ name: "minitest-handler",
         version: "1.1.5",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "1.1.4",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "1.1.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "1.1.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "1.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "1.0.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.2.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.2.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.1.7",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.1.6",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.1.5",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.1.4",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.1.3",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.1.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.1.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.1.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.0.10",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.0.9",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler", version: "0.0.7", dependencies: [] },
       { name: "minitest-handler", version: "0.0.6", dependencies: [] },
       { name: "minitest-handler", version: "0.0.5", dependencies: [] },
       { name: "minitest-handler",
         version: "0.0.4",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.0.3",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.0.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "minitest-handler",
         version: "0.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "monit" =>
      [{ name: "monit", version: "0.7.3", dependencies: [] },
       { name: "monit", version: "0.7.1", dependencies: [] },
       { name: "monit", version: "0.7.0", dependencies: [] },
       { name: "monit", version: "0.6.0", dependencies: [] },
       { name: "monit", version: "0.5.0", dependencies: [] },
       { name: "monit", version: "0.4.0", dependencies: [] },
       { name: "monit", version: "0.3.0", dependencies: [] }],
      "mysql" =>
      [{ name: "mysql", version: "5.0.3", dependencies: [] },
       { name: "mysql",
         version: "3.0.2",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", "> 1.1.0"]] },
       { name: "mysql", version: "5.0.0", dependencies: [] },
       { name: "mysql",
         version: "4.1.2",
         dependencies: [["openssl", "~> 1.1"],
          ["build-essential", "~> 1.4"],
          ["homebrew", ">= 0.0.0"],
          ["windows", ">= 0.0.0"]] },
       { name: "mysql",
         version: "4.1.1",
         dependencies: [["openssl", "~> 1.1"],
          ["build-essential", "~> 1.4"],
          ["homebrew", ">= 0.0.0"],
          ["windows", ">= 0.0.0"]] },
       { name: "mysql",
         version: "4.1.0",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.20",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.18",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.14",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.12",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.10",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.8",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.6",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.4",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.2",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "4.0.0",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "3.0.12",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "3.0.10",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "3.0.8",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "3.0.6",
         dependencies: [["openssl", "~> 1.1"], ["build-essential", "~> 1.4"]] },
       { name: "mysql",
         version: "3.0.4",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", "> 1.1.0"]] },
       { name: "mysql",
         version: "3.0.0",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "mysql",
         version: "2.1.2",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "mysql",
         version: "2.1.0",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "mysql",
         version: "2.0.2",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "mysql",
         version: "2.0.0",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.3.0",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.2.6",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.2.4",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.2.2",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.2.1",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.8",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.7",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.6",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.5",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.4",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.3",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.2",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.1",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "1.0.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.24.4",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.24.3",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.24.2",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.24.1",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.24.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.23.1",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.23.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.22.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.21.5",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.21.3",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.21.2",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.21.1",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.21.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.20.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql",
         version: "0.15.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mysql", version: "0.10.0", dependencies: [] },
       { name: "mysql", version: "5.0.2", dependencies: [] }],
      "nginx" =>
      [{ name: "nginx",
         version: "2.5.1",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 2.0"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum-epel", "~> 0.3"]] },
       { name: "nginx",
         version: "1.2.0",
         dependencies: [["bluepill", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["runit", "<= 0.16.2"],
          ["build-essential", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"]] },
       { name: "nginx",
         version: "1.6.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"]] },
       { name: "nginx",
         version: "1.8.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"]] },
       { name: "nginx",
         version: "2.5.0",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 2.0"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum-epel", "~> 0.3"]] },
       { name: "nginx",
         version: "2.4.4",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 2.0"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum-epel", "~> 0.3"]] },
       { name: "nginx",
         version: "2.4.2",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nginx",
         version: "2.4.1",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nginx",
         version: "2.4.0",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nginx",
         version: "2.3.0",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nginx",
         version: "2.2.2",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nginx",
         version: "2.2.0",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nginx",
         version: "2.1.0",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nginx",
         version: "2.0.8",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "< 3.0.0"]] },
       { name: "nginx",
         version: "2.0.6",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "< 3.0.0"]] },
       { name: "nginx",
         version: "2.0.4",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 2.3"]] },
       { name: "nginx",
         version: "2.0.2",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 2.3"]] },
       { name: "nginx",
         version: "2.0.0",
         dependencies: [["apt", "~> 2.2"],
          ["bluepill", "~> 2.3"],
          ["build-essential", "~> 1.4"],
          ["ohai", "~> 1.1"],
          ["runit", "~> 1.2"],
          ["yum", "~> 2.3"]] },
       { name: "nginx",
         version: "1.7.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"]] },
       { name: "nginx",
         version: "1.4.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"]] },
       { name: "nginx",
         version: "1.3.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["ohai", ">= 1.1.4"]] },
       { name: "nginx",
         version: "1.1.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["ohai", ">= 1.1.4"]] },
       { name: "nginx",
         version: "1.1.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["ohai", ">= 1.1.2"]] },
       { name: "nginx",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["ohai", ">= 1.1.0"]] },
       { name: "nginx",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "nginx",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["ohai", "~> 1.0.2"]] },
       { name: "nginx",
         version: "0.101.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["ohai", "~> 1.0.2"]] },
       { name: "nginx",
         version: "0.101.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["ohai", "~> 1.0.2"]] },
       { name: "nginx",
         version: "0.101.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ohai", "~> 1.0.2"]] },
       { name: "nginx",
         version: "0.101.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ohai", "~> 1.0.2"]] },
       { name: "nginx",
         version: "0.100.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.100.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.99.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.99.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.14.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.14.3",
         dependencies: [["runit", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.14.2",
         dependencies: [["runit", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.14.1",
         dependencies: [["runit", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.14.0",
         dependencies: [["runit", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.12.1",
         dependencies: [["runit", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "nginx",
         version: "0.10.0",
         dependencies: [["runit", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "nginx", version: "0.8.0", dependencies: [] }],
      "ntp" =>
      [{ name: "ntp", version: "1.6.3", dependencies: [] },
       { name: "ntp", version: "1.3.2", dependencies: [] },
       { name: "ntp", version: "1.6.2", dependencies: [] },
       { name: "ntp", version: "1.6.0", dependencies: [] },
       { name: "ntp", version: "1.5.4", dependencies: [] },
       { name: "ntp", version: "1.5.0", dependencies: [] },
       { name: "ntp", version: "1.4.0", dependencies: [] },
       { name: "ntp", version: "1.3.0", dependencies: [] },
       { name: "ntp", version: "1.2.0", dependencies: [] },
       { name: "ntp", version: "1.1.8", dependencies: [] },
       { name: "ntp", version: "1.1.6", dependencies: [] },
       { name: "ntp", version: "1.1.4", dependencies: [] },
       { name: "ntp", version: "1.1.2", dependencies: [] },
       { name: "ntp", version: "1.1.0", dependencies: [] },
       { name: "ntp", version: "1.0.1", dependencies: [] },
       { name: "ntp", version: "1.0.0", dependencies: [] },
       { name: "ntp", version: "0.8.2", dependencies: [] },
       { name: "ntp", version: "0.8.1", dependencies: [] },
       { name: "ntp", version: "0.7.0", dependencies: [] }],
      "omnibus_updater" =>
      [{ name: "omnibus_updater", version: "1.0.0", dependencies: [] },
       { name: "omnibus_updater", version: "0.2.8", dependencies: [] },
       { name: "omnibus_updater", version: "0.2.6", dependencies: [] },
       { name: "omnibus_updater", version: "0.2.4", dependencies: [] },
       { name: "omnibus_updater", version: "0.2.3", dependencies: [] },
       { name: "omnibus_updater", version: "0.2.0", dependencies: [] },
       { name: "omnibus_updater", version: "0.1.2", dependencies: [] },
       { name: "omnibus_updater", version: "0.1.1", dependencies: [] },
       { name: "omnibus_updater", version: "0.1.0", dependencies: [] },
       { name: "omnibus_updater", version: "0.0.5", dependencies: [] },
       { name: "omnibus_updater", version: "0.0.4", dependencies: [] },
       { name: "omnibus_updater", version: "0.0.3", dependencies: [] },
       { name: "omnibus_updater", version: "0.0.2", dependencies: [] },
       { name: "omnibus_updater", version: "0.0.1", dependencies: [] }],
      "openswan" =>
      [{ name: "openswan",
         version: "0.3.0",
         dependencies: [["ipaddr_extensions", ">= 0.0.0"]] }],
      "openvpn" =>
      [{ name: "openvpn", version: "3.0.1", dependencies: [] },
       { name: "openvpn",
         version: "2.1.0",
         dependencies: [["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "openvpn", version: "2.0.4", dependencies: [] },
       { name: "openvpn", version: "2.0.2", dependencies: [] },
       { name: "openvpn", version: "2.0.0", dependencies: [] },
       { name: "openvpn", version: "1.1.4", dependencies: [] },
       { name: "openvpn", version: "1.1.2", dependencies: [] },
       { name: "openvpn", version: "1.1.0", dependencies: [] },
       { name: "openvpn", version: "1.0.2", dependencies: [] },
       { name: "openvpn", version: "1.0.0", dependencies: [] },
       { name: "openvpn", version: "0.99.2", dependencies: [] },
       { name: "openvpn", version: "0.99.1", dependencies: [] },
       { name: "openvpn", version: "0.99.0", dependencies: [] },
       { name: "openvpn", version: "0.8.2", dependencies: [] },
       { name: "openvpn", version: "0.7.0", dependencies: [] }],
      "php" =>
      [{ name: "php",
         version: "1.4.7",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.2.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.4.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.4.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.4.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.4.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.3.14",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.3.12",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.3.10",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.3.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.3.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.3.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "php",
         version: "1.2.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.2.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.2.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.1.8",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.1.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.1.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.1.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "0.99.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "0.99.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php",
         version: "0.99.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "php", version: "0.9.1", dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "php", version: "0.9.0", dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "php",
         version: "0.7.0",
         dependencies: [["apache2", ">= 0.0.0"]] }],
      "postfix" =>
      [{ name: "postfix", version: "3.0.5", dependencies: [] },
       { name: "postfix", version: "3.1.8", dependencies: [] },
       { name: "postfix", version: "3.1.6", dependencies: [] },
       { name: "postfix", version: "3.1.4", dependencies: [] },
       { name: "postfix", version: "3.1.2", dependencies: [] },
       { name: "postfix", version: "3.1.0", dependencies: [] },
       { name: "postfix", version: "3.0.4", dependencies: [] },
       { name: "postfix", version: "3.0.2", dependencies: [] },
       { name: "postfix", version: "3.0.0", dependencies: [] },
       { name: "postfix", version: "2.1.6", dependencies: [] },
       { name: "postfix", version: "2.1.4", dependencies: [] },
       { name: "postfix", version: "2.1.2", dependencies: [] },
       { name: "postfix", version: "2.1.0", dependencies: [] },
       { name: "postfix", version: "2.0.0", dependencies: [] },
       { name: "postfix", version: "1.2.2", dependencies: [] },
       { name: "postfix", version: "1.2.0", dependencies: [] },
       { name: "postfix", version: "1.0.0", dependencies: [] },
       { name: "postfix", version: "0.8.4", dependencies: [] },
       { name: "postfix", version: "0.8.2", dependencies: [] },
       { name: "postfix", version: "0.7.0", dependencies: [] }],
      "postgresql" =>
      [{ name: "postgresql",
         version: "3.3.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "3.3.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "3.2.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "3.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "3.0.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "3.0.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "3.0.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "2.4.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "2.2.2",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "2.2.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "2.1.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "2.0.2",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "2.0.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "1.0.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "0.99.4",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "0.99.2",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql",
         version: "0.99.0",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "postgresql", version: "0.11.1", dependencies: [] },
       { name: "postgresql", version: "0.11.0", dependencies: [] },
       { name: "postgresql", version: "0.10.2", dependencies: [] },
       { name: "postgresql", version: "0.10.1", dependencies: [] },
       { name: "postgresql", version: "0.10.0", dependencies: [] },
       { name: "postgresql", version: "0.9.0", dependencies: [] },
       { name: "postgresql", version: "0.7.0", dependencies: [] }],
      "powershell" =>
      [{ name: "powershell",
         version: "3.0.1",
         dependencies: [["windows", ">= 1.2.8"],
          ["ms_dotnet45", ">= 0.0.0"],
          ["ms_dotnet4", ">= 0.0.0"],
          ["ms_dotnet2", ">= 0.0.0"]] },
       { name: "powershell",
         version: "3.0.0",
         dependencies: [["windows", ">= 1.2.8"],
          ["ms_dotnet45", ">= 0.0.0"],
          ["ms_dotnet4", ">= 0.0.0"],
          ["ms_dotnet2", ">= 0.0.0"]] },
       { name: "powershell",
         version: "2.0.0",
         dependencies: [["windows", ">= 1.2.8"]] },
       { name: "powershell",
         version: "1.1.2",
         dependencies: [["windows", ">= 1.2.8"]] },
       { name: "powershell",
         version: "1.1.0",
         dependencies: [["windows", ">= 1.2.8"]] },
       { name: "powershell",
         version: "1.0.8",
         dependencies: [["windows", ">= 1.2.8"]] },
       { name: "powershell",
         version: "1.0.6",
         dependencies: [["windows", ">= 1.2.8"]] },
       { name: "powershell",
         version: "1.0.4",
         dependencies: [["windows", ">= 1.2.8"]] },
       { name: "powershell",
         version: "1.0.2",
         dependencies: [["windows", ">= 1.2.8"]] },
       { name: "powershell", version: "1.0.1", dependencies: [] },
       { name: "powershell", version: "1.0.0", dependencies: [] }],
      "python" =>
      [{ name: "python",
         version: "1.4.7",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "python",
         version: "1.4.6",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "python",
         version: "1.4.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.4.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.4.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.3.6",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.3.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.3.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.3.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.2.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.2.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.0.8",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "python",
         version: "1.0.6",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "python",
         version: "1.0.4",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "python",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "python", version: "1.0.1", dependencies: [] },
       { name: "python", version: "1.0.0", dependencies: [] },
       { name: "python", version: "0.99.0", dependencies: [] },
       { name: "python", version: "0.7.0", dependencies: [] }],
      "rbenv" =>
      [{ name: "rbenv",
         version: "1.7.1",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.4.1",
         dependencies: [["git", ">= 0.0.0"], ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.7.0",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.6.5",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.6.4",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.6.3",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.6.2",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.6.1",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.6.0",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.5.1",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.5.0",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.4.2",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["ohai", ">= 1.1.0"]] },
       { name: "rbenv",
         version: "1.4.0",
         dependencies: [["git", ">= 0.0.0"], ["ohai", "~> 1.0.2"]] },
       { name: "rbenv",
         version: "1.3.2",
         dependencies: [["git", ">= 0.0.0"], ["ohai", "~> 1.0.2"]] },
       { name: "rbenv",
         version: "1.3.1",
         dependencies: [["git", ">= 0.0.0"], ["ohai", "~> 1.0.2"]] },
       { name: "rbenv",
         version: "1.3.0",
         dependencies: [["git", ">= 0.0.0"], ["ohai", "~> 1.0.2"]] },
       { name: "rbenv",
         version: "1.2.2",
         dependencies: [["git", ">= 0.0.0"], ["ohai", "~> 1.0.2"]] },
       { name: "rbenv",
         version: "1.2.1",
         dependencies: [["git", ">= 0.0.0"], ["ohai", "~> 1.0.2"]] },
       { name: "rbenv",
         version: "1.2.0",
         dependencies: [["git", ">= 0.0.0"], ["ohai", "~> 1.0.2"]] },
       { name: "rbenv", version: "1.1.0", dependencies: [["git", ">= 0.0.0"]] },
       { name: "rbenv", version: "1.0.2", dependencies: [["git", ">= 0.0.0"]] },
       { name: "rbenv", version: "1.0.1", dependencies: [["git", ">= 0.0.0"]] },
       { name: "rbenv", version: "1.0.0", dependencies: [["git", ">= 0.0.0"]] },
       { name: "rbenv", version: "0.9.2", dependencies: [["git", ">= 0.0.0"]] },
       { name: "rbenv",
         version: "0.9.0",
         dependencies: [["centos", ">= 0.0.0"],
          ["redhat", ">= 0.0.0"],
          ["fedora", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] }],
      "rsyslog" =>
      [{ name: "rsyslog", version: "1.12.3", dependencies: [] },
       { name: "rsyslog", version: "1.12.2", dependencies: [] },
       { name: "rsyslog", version: "1.5.0", dependencies: [] },
       { name: "rsyslog", version: "1.12.0", dependencies: [] },
       { name: "rsyslog", version: "1.11.0", dependencies: [] },
       { name: "rsyslog", version: "1.10.2", dependencies: [] },
       { name: "rsyslog", version: "1.9.0", dependencies: [] },
       { name: "rsyslog", version: "1.8.0", dependencies: [] },
       { name: "rsyslog", version: "1.7.0", dependencies: [] },
       { name: "rsyslog", version: "1.6.0", dependencies: [] },
       { name: "rsyslog", version: "1.4.0", dependencies: [] },
       { name: "rsyslog", version: "1.3.0", dependencies: [] },
       { name: "rsyslog", version: "1.2.0", dependencies: [] },
       { name: "rsyslog", version: "1.1.0", dependencies: [] },
       { name: "rsyslog",
         version: "1.0.0",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "rsyslog",
         version: "0.99.2",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "rsyslog",
         version: "0.99.1",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "rsyslog",
         version: "0.99.0",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "rsyslog",
         version: "0.9.5",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "rsyslog",
         version: "0.9.4",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "rsyslog",
         version: "0.9.3",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "rsyslog", version: "0.9.2", dependencies: [] },
       { name: "rsyslog", version: "0.9.0", dependencies: [] },
       { name: "rsyslog", version: "0.7.0", dependencies: [] }],
      "ruby_build" =>
      [{ name: "ruby_build", version: "0.8.1", dependencies: [] },
       { name: "ruby_build", version: "0.8.0", dependencies: [] },
       { name: "ruby_build", version: "0.7.2", dependencies: [] },
       { name: "ruby_build", version: "0.7.0", dependencies: [] },
       { name: "ruby_build", version: "0.6.2", dependencies: [] },
       { name: "ruby_build", version: "0.6.0", dependencies: [] }],
      "runit" =>
      [{ name: "runit",
         version: "1.5.11",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.0.6",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.1.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.5.10",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.5.8",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.5.5",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.5.3",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.5.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.5.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.4.6",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", "< 3.0.0"]] },
       { name: "runit",
         version: "1.4.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", "< 3.0.0"]] },
       { name: "runit",
         version: "1.4.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.3.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.2.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.1.6",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.1.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.0.4",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "runit",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "runit", version: "0.16.2", dependencies: [] },
       { name: "runit", version: "0.16.0", dependencies: [] },
       { name: "runit", version: "0.15.0", dependencies: [] },
       { name: "runit", version: "0.14.2", dependencies: [] },
       { name: "runit", version: "0.14.1", dependencies: [] },
       { name: "runit", version: "0.14.0", dependencies: [] },
       { name: "runit", version: "0.13.0", dependencies: [] },
       { name: "runit", version: "0.12.0", dependencies: [] },
       { name: "runit", version: "0.11.0", dependencies: [] },
       { name: "runit", version: "0.8.0", dependencies: [] },
       { name: "runit", version: "0.7.0", dependencies: [] }],
      "rvm" =>
      [{ name: "rvm",
         version: "0.9.2",
         dependencies: [["java", ">= 0.0.0"], ["chef_gem", ">= 0.0.0"]] },
       { name: "rvm",
         version: "0.0.4",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "rvm",
         version: "0.0.3",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "rvm",
         version: "0.0.2",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "statsd" =>
      [{ name: "statsd",
         version: "1.1.5",
         dependencies: [["git", ">= 0.0.0"], ["nodejs", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "statsd",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "sysctl" =>
      [{ name: "sysctl", version: "0.3.5", dependencies: [] },
       { name: "sysctl", version: "0.3.4", dependencies: [] },
       { name: "sysctl", version: "0.3.3", dependencies: [] },
       { name: "sysctl", version: "0.3.2", dependencies: [] },
       { name: "sysctl", version: "0.3.1", dependencies: [] },
       { name: "sysctl", version: "0.3.0", dependencies: [] },
       { name: "sysctl", version: "0.1.0", dependencies: [] },
       { name: "sysctl", version: "0.0.3", dependencies: [] },
       { name: "sysctl", version: "0.0.2", dependencies: [] },
       { name: "sysctl", version: "0.0.1", dependencies: [] }],
      "ubuntu" =>
      [{ name: "ubuntu", version: "1.1.7", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "ubuntu", version: "1.1.6", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "ubuntu", version: "1.1.4", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "ubuntu", version: "1.1.2", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "ubuntu", version: "1.1.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "ubuntu", version: "1.0.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "ubuntu", version: "0.99.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "ubuntu", version: "0.7.0", dependencies: [["apt", ">= 0.0.0"]] }],
      "vagrant-cookbook" =>
      [{ name: "vagrant-cookbook",
         version: "0.2.0",
         dependencies: [["dmg", ">= 0.0.0"], ["windows", ">= 0.0.0"]] }],
      "varnish" =>
      [{ name: "varnish", version: "0.9.13", dependencies: [] },
       { name: "varnish", version: "0.9.12", dependencies: [] },
       { name: "varnish", version: "0.9.10", dependencies: [] },
       { name: "varnish", version: "0.9.8", dependencies: [] },
       { name: "varnish", version: "0.9.6", dependencies: [] },
       { name: "varnish", version: "0.9.4", dependencies: [] },
       { name: "varnish", version: "0.9.2", dependencies: [] },
       { name: "varnish", version: "0.9.1", dependencies: [] },
       { name: "varnish", version: "0.7.0", dependencies: [] }],
      "vim" =>
      [{ name: "vim", version: "1.1.3", dependencies: [] },
       { name: "vim", version: "1.0.2", dependencies: [] },
       { name: "vim", version: "1.1.2", dependencies: [] },
       { name: "vim", version: "1.1.0", dependencies: [] },
       { name: "vim", version: "1.0.0", dependencies: [] },
       { name: "vim", version: "0.0.1", dependencies: [] }],
      "virtualbox-cookbook" =>
      [{ name: "virtualbox-cookbook",
         version: "1.0.3",
         dependencies: [["dmg", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", "~> 3.1"],
          ["apache2", ">= 0.0.0"]] }],
      "windows" =>
      [{ name: "windows",
         version: "1.30.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.30.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.8.4",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.12.8",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.12.6",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.12.4",
         dependencies: [["chef_handler", ">= 0.0.0"], ["powershell", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.12.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.12.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.11.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.10.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.9.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.8.10",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.8.8",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.8.6",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.8.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.8.0",
         dependencies: [["chef_handler", ">= 0.0.0"], ["powershell", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.7.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.6.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.5.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.4.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.3.4",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.3.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.3.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.2.12",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.2.10",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.2.8",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.2.6",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.2.4",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.2.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows",
         version: "1.2.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "windows", version: "1.0.8", dependencies: [] },
       { name: "windows", version: "1.0.6", dependencies: [] },
       { name: "windows", version: "1.0.4", dependencies: [] },
       { name: "windows", version: "1.0.2", dependencies: [] },
       { name: "windows", version: "1.0.0", dependencies: [] }],
      "yum" =>
      [{ name: "yum", version: "2.4.5", dependencies: [] },
       { name: "yum", version: "2.1.0", dependencies: [] },
       { name: "yum", version: "3.1.6", dependencies: [] },
       { name: "yum", version: "3.1.4", dependencies: [] },
       { name: "yum", version: "3.1.2", dependencies: [] },
       { name: "yum", version: "3.1.0", dependencies: [] },
       { name: "yum", version: "3.0.6", dependencies: [] },
       { name: "yum", version: "3.0.4", dependencies: [] },
       { name: "yum", version: "3.0.2", dependencies: [] },
       { name: "yum", version: "3.0.0", dependencies: [] },
       { name: "yum", version: "2.4.4", dependencies: [] },
       { name: "yum", version: "2.4.2", dependencies: [] },
       { name: "yum", version: "2.4.0", dependencies: [] },
       { name: "yum", version: "2.3.4", dependencies: [] },
       { name: "yum", version: "2.3.2", dependencies: [] },
       { name: "yum", version: "2.3.0", dependencies: [] },
       { name: "yum", version: "2.2.4", dependencies: [] },
       { name: "yum", version: "2.2.2", dependencies: [] },
       { name: "yum", version: "2.2.0", dependencies: [] },
       { name: "yum", version: "2.0.6", dependencies: [] },
       { name: "yum", version: "2.0.4", dependencies: [] },
       { name: "yum", version: "2.0.2", dependencies: [] },
       { name: "yum", version: "2.0.0", dependencies: [] },
       { name: "yum", version: "1.0.0", dependencies: [] },
       { name: "yum", version: "0.8.2", dependencies: [] },
       { name: "yum", version: "0.8.0", dependencies: [] },
       { name: "yum", version: "0.6.2", dependencies: [] },
       { name: "yum", version: "0.6.0", dependencies: [] },
       { name: "yum", version: "0.5.2", dependencies: [] },
       { name: "yum", version: "0.5.0", dependencies: [] },
       { name: "yum", version: "0.1.2", dependencies: [] },
       { name: "yum", version: "0.1.1", dependencies: [] },
       { name: "yum", version: "0.1.0", dependencies: [] }],
      "7-zip" =>
      [{ name: "7-zip",
         version: "1.0.0",
         dependencies: [["windows", ">= 1.2.2"]] },
       { name: "7-zip",
         version: "1.0.2",
         dependencies: [["windows", ">= 1.2.2"]] }],
      "apache2" =>
      [{ name: "apache2",
         version: "1.10.0",
         dependencies: [["iptables", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["pacman", ">= 0.0.0"]] },
       { name: "apache2", version: "1.6.6", dependencies: [] },
       { name: "apache2",
         version: "1.9.6",
         dependencies: [["iptables", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["pacman", ">= 0.0.0"]] },
       { name: "apache2",
         version: "1.9.4",
         dependencies: [["iptables", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["pacman", ">= 0.0.0"]] },
       { name: "apache2",
         version: "1.9.1",
         dependencies: [["iptables", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["pacman", ">= 0.0.0"]] },
       { name: "apache2",
         version: "1.9.0",
         dependencies: [["iptables", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["pacman", ">= 0.0.0"]] },
       { name: "apache2", version: "1.8.14", dependencies: [] },
       { name: "apache2", version: "1.8.12", dependencies: [] },
       { name: "apache2", version: "1.8.10", dependencies: [] },
       { name: "apache2", version: "1.8.8", dependencies: [] },
       { name: "apache2", version: "1.8.6", dependencies: [] },
       { name: "apache2", version: "1.8.4", dependencies: [] },
       { name: "apache2", version: "1.8.2", dependencies: [] },
       { name: "apache2", version: "1.8.0", dependencies: [] },
       { name: "apache2", version: "1.7.0", dependencies: [] },
       { name: "apache2", version: "1.6.2", dependencies: [] },
       { name: "apache2", version: "1.6.0", dependencies: [] },
       { name: "apache2", version: "1.5.0", dependencies: [] },
       { name: "apache2", version: "1.4.2", dependencies: [] },
       { name: "apache2", version: "1.4.0", dependencies: [] },
       { name: "apache2", version: "1.3.2", dependencies: [] },
       { name: "apache2", version: "1.3.0", dependencies: [] },
       { name: "apache2", version: "1.2.0", dependencies: [] },
       { name: "apache2", version: "1.1.16", dependencies: [] },
       { name: "apache2", version: "1.1.12", dependencies: [] },
       { name: "apache2", version: "1.1.10", dependencies: [] },
       { name: "apache2", version: "1.1.8", dependencies: [] },
       { name: "apache2", version: "1.1.6", dependencies: [] },
       { name: "apache2", version: "1.1.4", dependencies: [] },
       { name: "apache2", version: "1.1.2", dependencies: [] },
       { name: "apache2", version: "1.1.0", dependencies: [] },
       { name: "apache2", version: "1.0.8", dependencies: [] },
       { name: "apache2", version: "1.0.6", dependencies: [] },
       { name: "apache2", version: "1.0.4", dependencies: [] },
       { name: "apache2", version: "1.0.2", dependencies: [] },
       { name: "apache2", version: "1.0.0", dependencies: [] },
       { name: "apache2", version: "0.99.4", dependencies: [] },
       { name: "apache2", version: "0.99.3", dependencies: [] },
       { name: "apache2", version: "0.99.2", dependencies: [] },
       { name: "apache2", version: "0.99.1", dependencies: [] },
       { name: "apache2", version: "0.99.0", dependencies: [] },
       { name: "apache2", version: "0.12.3", dependencies: [] },
       { name: "apache2", version: "0.12.2", dependencies: [] },
       { name: "apache2", version: "0.12.1", dependencies: [] },
       { name: "apache2", version: "0.12.0", dependencies: [] },
       { name: "apache2", version: "0.11.0", dependencies: [] },
       { name: "apache2", version: "0.10.1", dependencies: [] },
       { name: "apache2", version: "0.10.0", dependencies: [] },
       { name: "apache2", version: "0.9.1", dependencies: [] }],
      "bluepill" =>
      [{ name: "bluepill",
         version: "2.2.0",
         dependencies: [["rsyslog", ">= 0.0.0"]] },
       { name: "bluepill",
         version: "2.3.1",
         dependencies: [["rsyslog", ">= 0.0.0"]] },
       { name: "bluepill",
         version: "2.3.0",
         dependencies: [["rsyslog", ">= 0.0.0"]] },
       { name: "bluepill",
         version: "2.2.2",
         dependencies: [["rsyslog", ">= 0.0.0"]] },
       { name: "bluepill",
         version: "2.1.0",
         dependencies: [["rsyslog", ">= 0.0.0"]] },
       { name: "bluepill", version: "2.0.0", dependencies: [] },
       { name: "bluepill", version: "1.1.2", dependencies: [] },
       { name: "bluepill", version: "1.1.0", dependencies: [] },
       { name: "bluepill", version: "1.0.6", dependencies: [] },
       { name: "bluepill", version: "1.0.4", dependencies: [] },
       { name: "bluepill", version: "1.0.2", dependencies: [] },
       { name: "bluepill", version: "1.0.0", dependencies: [] },
       { name: "bluepill", version: "0.3.0", dependencies: [] },
       { name: "bluepill", version: "0.2.2", dependencies: [] },
       { name: "bluepill", version: "0.2.0", dependencies: [] },
       { name: "bluepill", version: "0.1.0", dependencies: [] }],
      "build-essential" =>
      [{ name: "build-essential", version: "1.3.4", dependencies: [] },
       { name: "build-essential", version: "1.4.0", dependencies: [] },
       { name: "build-essential", version: "2.0.0", dependencies: [] },
       { name: "build-essential", version: "1.4.4", dependencies: [] },
       { name: "build-essential", version: "1.4.2", dependencies: [] },
       { name: "build-essential", version: "1.3.2", dependencies: [] },
       { name: "build-essential", version: "1.3.0", dependencies: [] },
       { name: "build-essential", version: "1.2.0", dependencies: [] },
       { name: "build-essential", version: "1.1.2", dependencies: [] },
       { name: "build-essential", version: "1.1.0", dependencies: [] },
       { name: "build-essential", version: "1.0.2", dependencies: [] },
       { name: "build-essential", version: "1.0.0", dependencies: [] },
       { name: "build-essential", version: "0.7.0", dependencies: [] }],
      "chef-sugar" =>
      [{ name: "chef-sugar", version: "1.2.8", dependencies: [] },
       { name: "chef-sugar", version: "1.2.7", dependencies: [] },
       { name: "chef-sugar", version: "1.2.6", dependencies: [] },
       { name: "chef-sugar", version: "1.2.4", dependencies: [] },
       { name: "chef-sugar", version: "1.2.2", dependencies: [] },
       { name: "chef-sugar", version: "1.2.1", dependencies: [] },
       { name: "chef-sugar", version: "1.2.0", dependencies: [] },
       { name: "chef-sugar", version: "1.1.0", dependencies: [] },
       { name: "chef-sugar", version: "1.0.1", dependencies: [] },
       { name: "chef-sugar", version: "1.0.0", dependencies: [] }],
      "iptables" =>
      [{ name: "iptables", version: "0.12.0", dependencies: [] },
       { name: "iptables", version: "0.13.0", dependencies: [] },
       { name: "iptables", version: "0.12.2", dependencies: [] },
       { name: "iptables", version: "0.11.0", dependencies: [] },
       { name: "iptables", version: "0.10.0", dependencies: [] },
       { name: "iptables", version: "0.9.3", dependencies: [] },
       { name: "iptables", version: "0.9.2", dependencies: [] },
       { name: "iptables", version: "0.7.0", dependencies: [] }],
      "jpackage" =>
      [{ name: "jpackage",
         version: "1.0.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "jpackage",
         version: "1.0.2",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "jpackage",
         version: "0.10.0",
         dependencies: [["java", ">= 0.0.0"]] }],
      "logrotate" =>
      [{ name: "logrotate", version: "1.5.0", dependencies: [] },
       { name: "logrotate", version: "1.4.0", dependencies: [] },
       { name: "logrotate", version: "1.3.0", dependencies: [] },
       { name: "logrotate", version: "1.2.2", dependencies: [] },
       { name: "logrotate", version: "1.2.0", dependencies: [] },
       { name: "logrotate", version: "1.1.0", dependencies: [] },
       { name: "logrotate", version: "1.0.2", dependencies: [] },
       { name: "logrotate", version: "1.0.0", dependencies: [] },
       { name: "logrotate", version: "0.8.2", dependencies: [] },
       { name: "logrotate", version: "0.8.1", dependencies: [] },
       { name: "logrotate", version: "0.7.0", dependencies: [] }],
      "nscd" =>
      [{ name: "nscd", version: "0.9.0", dependencies: [] },
       { name: "nscd", version: "0.11.0", dependencies: [] },
       { name: "nscd", version: "0.10.0", dependencies: [] },
       { name: "nscd", version: "0.8.2", dependencies: [] },
       { name: "nscd", version: "0.7.0", dependencies: [] }],
      "ohai" =>
      [{ name: "ohai", version: "1.1.12", dependencies: [] },
       { name: "ohai", version: "1.1.8", dependencies: [] },
       { name: "ohai", version: "2.0.0", dependencies: [] },
       { name: "ohai", version: "1.1.10", dependencies: [] },
       { name: "ohai", version: "1.1.6", dependencies: [] },
       { name: "ohai", version: "1.1.4", dependencies: [] },
       { name: "ohai", version: "1.1.2", dependencies: [] },
       { name: "ohai", version: "1.1.0", dependencies: [] },
       { name: "ohai", version: "1.0.2", dependencies: [] },
       { name: "ohai", version: "1.0.0", dependencies: [] },
       { name: "ohai", version: "0.9.0", dependencies: [] }],
      "omnibus" =>
      [{ name: "omnibus",
         version: "1.0.0",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgutil", "~> 0.0.3"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] },
       { name: "omnibus",
         version: "1.0.10",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgin", "~> 0.4.0"],
          ["pkgutil", "~> 0.0.3"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] },
       { name: "omnibus",
         version: "1.0.2",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgin", "~> 0.4.0"],
          ["pkgutil", "~> 0.0.3"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] },
       { name: "omnibus",
         version: "1.2.4",
         dependencies: [["7-zip", "~> 1.0"],
          ["apt", "~> 1.9"],
          ["build-essential", "~> 1.4"],
          ["git", "~> 3.0"],
          ["homebrew", "~> 1.5"],
          ["pkgin", "~> 0.4"],
          ["pkgutil", "~> 0.0"],
          ["rbenv", "~> 1.6"],
          ["windows", "~> 1.8"],
          ["wix", "~> 1.1"],
          ["yum-epel", "~> 0.3"]] },
       { name: "omnibus",
         version: "1.2.2",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgin", "~> 0.4.0"],
          ["pkgutil", "~> 0.0.3"],
          ["rbenv", "= 1.6.5"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] },
       { name: "omnibus",
         version: "1.2.0",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgin", "~> 0.4.0"],
          ["pkgutil", "~> 0.0.3"],
          ["rbenv", "= 1.6.5"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] },
       { name: "omnibus",
         version: "1.1.0",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgin", "~> 0.4.0"],
          ["pkgutil", "~> 0.0.3"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] },
       { name: "omnibus",
         version: "1.0.8",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgin", "~> 0.4.0"],
          ["pkgutil", "~> 0.0.3"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] },
       { name: "omnibus",
         version: "1.0.6",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgin", "~> 0.4.0"],
          ["pkgutil", "~> 0.0.3"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] },
       { name: "omnibus",
         version: "1.0.4",
         dependencies: [["apt", "~> 1.9.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.3.0"],
          ["homebrew", "~> 1.3.2"],
          ["pkgin", "~> 0.4.0"],
          ["pkgutil", "~> 0.0.3"],
          ["yum", "~> 2.2.0"],
          ["windows", "~> 1.8.8"],
          ["wix", "~> 1.1.0"],
          ["7-zip", "~> 1.0.0"]] }],
      "openldap" =>
      [{ name: "openldap",
         version: "0.11.2",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "openldap",
         version: "1.12.8",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "openldap",
         version: "1.12.6",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "openldap",
         version: "1.12.4",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "openldap",
         version: "1.12.2",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "openldap",
         version: "0.12.0",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "openldap",
         version: "0.11.4",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "openldap",
         version: "0.11.0",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "openldap",
         version: "0.10.0",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"]] },
       { name: "openldap",
         version: "0.9.3",
         dependencies: [["openssh", ">= 0.0.0"], ["nscd", ">= 0.0.0"]] },
       { name: "openldap",
         version: "0.9.2",
         dependencies: [["nscd", ">= 0.0.0"], ["openssh", ">= 0.0.0"]] },
       { name: "openldap",
         version: "0.7.0",
         dependencies: [["nscd", ">= 0.0.0"], ["openssh", ">= 0.0.0"]] }],
      "openssh" =>
      [{ name: "openssh",
         version: "1.2.0",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "openssh",
         version: "1.3.2",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "openssh",
         version: "1.3.0",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "openssh",
         version: "1.2.2",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "openssh", version: "1.1.4", dependencies: [] },
       { name: "openssh", version: "1.1.2", dependencies: [] },
       { name: "openssh", version: "1.1.0", dependencies: [] },
       { name: "openssh", version: "1.0.0", dependencies: [] },
       { name: "openssh", version: "0.8.0", dependencies: [] },
       { name: "openssh", version: "0.7.2", dependencies: [] },
       { name: "openssh", version: "0.7.0", dependencies: [] }],
      "openssl" =>
      [{ name: "openssl", version: "1.0.2", dependencies: [] },
       { name: "openssl", version: "1.1.0", dependencies: [] },
       { name: "openssl", version: "1.0.0", dependencies: [] },
       { name: "openssl", version: "0.1.0", dependencies: [] }],
      "opscode-github" =>
      [{ name: "opscode-github", version: "0.7.0", dependencies: [] }],
      "pacman" =>
      [{ name: "pacman", version: "1.1.1", dependencies: [] },
       { name: "pacman", version: "1.1.0", dependencies: [] },
       { name: "pacman", version: "1.0.4", dependencies: [] },
       { name: "pacman", version: "1.0.2", dependencies: [] },
       { name: "pacman", version: "1.0.1", dependencies: [] },
       { name: "pacman", version: "1.0.0", dependencies: [] },
       { name: "pacman", version: "0.9.0", dependencies: [] }],
      "pkgin" =>
      [{ name: "pkgin", version: "0.4.0", dependencies: [] },
       { name: "pkgin", version: "0.3.0", dependencies: [] },
       { name: "pkgin", version: "0.2.0", dependencies: [] },
       { name: "pkgin", version: "0.1.0", dependencies: [] }],
      "pkgutil" =>
      [{ name: "pkgutil", version: "0.0.3", dependencies: [] },
       { name: "pkgutil", version: "0.0.2", dependencies: [] },
       { name: "pkgutil", version: "0.0.1", dependencies: [] }],
      "sudo" =>
      [{ name: "sudo", version: "2.0.4", dependencies: [] },
       { name: "sudo", version: "2.1.0", dependencies: [] },
       { name: "sudo", version: "2.1.4", dependencies: [] },
       { name: "sudo", version: "2.5.2", dependencies: [] },
       { name: "sudo", version: "2.4.2", dependencies: [] },
       { name: "sudo", version: "2.5.0", dependencies: [] },
       { name: "sudo", version: "2.4.0", dependencies: [] },
       { name: "sudo", version: "2.3.0", dependencies: [] },
       { name: "sudo", version: "2.2.2", dependencies: [] },
       { name: "sudo", version: "2.2.0", dependencies: [] },
       { name: "sudo", version: "2.1.2", dependencies: [] },
       { name: "sudo", version: "2.0.2", dependencies: [] },
       { name: "sudo", version: "2.0.0", dependencies: [] },
       { name: "sudo", version: "1.3.0", dependencies: [] },
       { name: "sudo", version: "1.2.2", dependencies: [] },
       { name: "sudo", version: "1.2.0", dependencies: [] },
       { name: "sudo", version: "1.1.0", dependencies: [] },
       { name: "sudo", version: "1.0.2", dependencies: [] },
       { name: "sudo", version: "1.0.0", dependencies: [] },
       { name: "sudo", version: "0.9.1", dependencies: [] },
       { name: "sudo", version: "0.9.0", dependencies: [] },
       { name: "sudo", version: "0.7.0", dependencies: [] }],
      "tmux" =>
      [{ name: "tmux", version: "1.3.0", dependencies: [] },
       { name: "tmux", version: "1.4.0", dependencies: [] },
       { name: "tmux", version: "1.3.2", dependencies: [] },
       { name: "tmux", version: "1.2.2", dependencies: [] },
       { name: "tmux", version: "1.1.2", dependencies: [] },
       { name: "tmux", version: "1.2.0", dependencies: [] },
       { name: "tmux", version: "1.1.0", dependencies: [] },
       { name: "tmux", version: "1.0.0", dependencies: [] }],
      "tomcat" =>
      [{ name: "tomcat",
         version: "0.14.2",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.15.10",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.15.8",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.15.6",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.15.4",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.15.2",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.15.0",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.14.4",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.14.0",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.13.0",
         dependencies: [["java", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.12.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.11.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.10.4",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.10.3",
         dependencies: [["java", ">= 0.0.0"], ["jpackage", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.10.2",
         dependencies: [["java", ">= 0.0.0"], ["jpackage", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.10.1",
         dependencies: [["java", ">= 0.0.0"], ["jpackage", ">= 0.0.0"]] },
       { name: "tomcat",
         version: "0.10.0",
         dependencies: [["java", ">= 0.0.0"], ["jpackage", ">= 0.0.0"]] }],
      "users" =>
      [{ name: "users", version: "1.3.0", dependencies: [] },
       { name: "users", version: "1.4.0", dependencies: [] },
       { name: "users", version: "1.7.0", dependencies: [] },
       { name: "users", version: "1.6.0", dependencies: [] },
       { name: "users", version: "1.5.2", dependencies: [] },
       { name: "users", version: "1.5.0", dependencies: [] },
       { name: "users", version: "1.2.0", dependencies: [] },
       { name: "users", version: "1.1.4", dependencies: [] },
       { name: "users", version: "1.1.2", dependencies: [] },
       { name: "users", version: "1.1.0", dependencies: [] },
       { name: "users", version: "1.0.0", dependencies: [] },
       { name: "users", version: "0.3.1", dependencies: [] },
       { name: "users", version: "0.3.0", dependencies: [] },
       { name: "users", version: "0.2.0", dependencies: [] },
       { name: "users", version: "0.1.0", dependencies: [] }],
      "wix" =>
      [{ name: "wix", version: "1.0.2", dependencies: [["windows", ">= 1.2.2"]] },
       { name: "wix", version: "1.1.0", dependencies: [["windows", ">= 1.2.2"]] },
       { name: "wix",
         version: "1.0.0",
         dependencies: [["windows", ">= 1.2.2"]] }],
      "xml" =>
      [{ name: "xml",
         version: "1.1.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "xml",
         version: "1.2.4",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "xml",
         version: "1.2.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "xml",
         version: "1.2.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "xml", version: "1.1.0", dependencies: [] },
       { name: "xml", version: "1.0.4", dependencies: [] },
       { name: "xml", version: "1.0.2", dependencies: [] },
       { name: "xml", version: "1.0.0", dependencies: [] },
       { name: "xml", version: "0.1.0", dependencies: [] }],
      "yum-epel" =>
      [{ name: "yum-epel", version: "0.3.4", dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-epel", version: "0.3.2", dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-epel", version: "0.3.0", dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-epel", version: "0.2.0", dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-epel", version: "0.1.6", dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-epel", version: "0.1.4", dependencies: [["yum", "~> 3.0"]] }],
      "zsh" =>
      [{ name: "zsh", version: "1.0.0", dependencies: [] },
       { name: "zsh", version: "0.7.0", dependencies: [] }],
      "1password" =>
      [{ name: "1password", version: "1.0.6", dependencies: [] },
       { name: "1password", version: "1.0.4", dependencies: [] },
       { name: "1password", version: "1.0.2", dependencies: [] },
       { name: "1password", version: "1.0.0", dependencies: [] }],
      "accounts" => [{ name: "accounts", version: "0.1.0", dependencies: [] }],
      "accumulator" =>
      [{ name: "accumulator", version: "0.2.0", dependencies: [] },
       { name: "accumulator", version: "0.1.3", dependencies: [] }],
      "ack" => [{ name: "ack", version: "1.0.0", dependencies: [] }],
      "ack-grep" => [{ name: "ack-grep", version: "0.1.0", dependencies: [] }],
      "activemq" =>
      [{ name: "activemq",
         version: "1.3.0",
         dependencies: [["java", "~> 1.13"]] },
       { name: "activemq",
         version: "1.2.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "activemq",
         version: "1.1.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "activemq",
         version: "1.0.2",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "activemq",
         version: "1.0.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "activemq",
         version: "0.3.3",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "activemq",
         version: "0.3.2",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "activemq",
         version: "0.3.0",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"]] }],
      "ad" => [{ name: "ad", version: "0.0.1", dependencies: [] }],
      "ad-auth" =>
      [{ name: "ad-auth",
         version: "1.0.7",
         dependencies: [["sudo", ">= 0.0.0"]] },
       { name: "ad-auth",
         version: "1.0.5",
         dependencies: [["sudo", ">= 0.0.0"]] },
       { name: "ad-auth",
         version: "1.0.4",
         dependencies: [["sudo", ">= 0.0.0"]] }],
      "ad-likewise" =>
      [{ name: "ad-likewise",
         version: "0.2.0",
         dependencies: [["sudo", ">= 0.0.0"]] }],
      "admin-user" =>
      [{ name: "admin-user",
         version: "1.1.2",
         dependencies: [["sudo", ">= 2.2.0"]] },
       { name: "admin-user",
         version: "1.1.1",
         dependencies: [["sudo", ">= 0.0.0"]] },
       { name: "admin-user",
         version: "1.1.0",
         dependencies: [["sudo", "~> 2.0.4"]] }],
      "aegir" =>
      [{ name: "aegir",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.0.0"]] },
       { name: "aegir",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.0.0"]] },
       { name: "aegir",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.0.0"]] },
       { name: "aegir",
         version: "0.1.0",
         dependencies: [["sudo", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.0.0"]] }],
      "afw" =>
      [{ name: "afw", version: "0.0.7", dependencies: [] },
       { name: "afw", version: "0.0.5", dependencies: [] },
       { name: "afw", version: "0.0.4", dependencies: [] },
       { name: "afw", version: "0.0.3", dependencies: [] },
       { name: "afw", version: "0.0.2", dependencies: [] },
       { name: "afw", version: "0.0.1", dependencies: [["ohai", ">= 0.0.0"]] }],
      "aide" =>
      [{ name: "aide", version: "0.1.2", dependencies: [] },
       { name: "aide", version: "0.1.1", dependencies: [] },
       { name: "aide", version: "0.1.0", dependencies: [] }],
      "ajenti" =>
      [{ name: "ajenti",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "akibanserver" =>
      [{ name: "akibanserver",
         version: "0.1.7",
         dependencies: [["apt", "= 1.8.0"], ["postgresql", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "akibanserver",
         version: "0.1.5",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "akibanserver",
         version: "0.1.4",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "akibanserver",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "akibanserver",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "akibanserver",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "akibanserver",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "akibanserver",
         version: "0.0.1",
         dependencies: [["postgresql", ">= 0.0.0"]] }],
      "alternate_search" =>
      [{ name: "alternate_search",
         version: "2.3.0",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "alternate_search",
         version: "2.1.2",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "alternate_search",
         version: "2.1.0",
         dependencies: [["partial_search", ">= 0.0.0"]] }],
      "AmazonEC2Tag" =>
      [{ name: "AmazonEC2Tag", version: "1.0.0", dependencies: [] }],
      "amazon_s3cmd" =>
      [{ name: "amazon_s3cmd",
         version: "0.1.50",
         dependencies: [["magic_shell", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "amazon_s3cmd",
         version: "0.1.46",
         dependencies: [["magic_shell", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "amazon_s3cmd",
         version: "0.1.45",
         dependencies: [["magic_shell", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "amazon_s3cmd",
         version: "0.1.42",
         dependencies: [["magic_shell", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "amazon_s3cmd",
         version: "0.1.41",
         dependencies: [["magic_shell", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "amazon_s3cmd",
         version: "0.1.40",
         dependencies: [["magic_shell", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "amazon_s3cmd",
         version: "0.1.39",
         dependencies: [["magic_shell", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "amazon_s3cmd",
         version: "0.1.37",
         dependencies: [["magic_shell", ">= 0.0.0"]] }],
      "aminator" =>
      [{ name: "aminator",
         version: "0.0.1",
         dependencies: [["python", ">= 0.0.0"]] }],
      "amoeba_basenode" =>
      [{ name: "amoeba_basenode",
         version: "0.0.4",
         dependencies: [["swap", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"],
          ["locale", ">= 0.1.0"],
          ["timezone-ii", ">= 0.0.0"],
          ["hostname", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["monit", ">= 1.5.0"]] },
       { name: "amoeba_basenode",
         version: "0.0.3",
         dependencies: [["swap", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"],
          ["locale", ">= 0.1.0"],
          ["timezone-ii", ">= 0.0.0"],
          ["hostname", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["monit", ">= 1.5.0"]] },
       { name: "amoeba_basenode",
         version: "0.0.2",
         dependencies: [["swap", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"],
          ["locale", ">= 0.1.0"],
          ["timezone-ii", ">= 0.0.0"],
          ["hostname", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["monit", ">= 1.5.0"]] },
       { name: "amoeba_basenode",
         version: "0.0.1",
         dependencies: [["swap", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"],
          ["locale", ">= 0.1.0"],
          ["timezone-ii", ">= 0.0.0"],
          ["hostname", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["monit", ">= 1.5.0"]] }],
      "android-sdk" =>
      [{ name: "android-sdk",
         version: "0.1.1",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "android-sdk",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "android-sdk",
         version: "0.0.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] }],
      "ant" =>
      [{ name: "ant",
         version: "1.0.2",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "ant",
         version: "1.0.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "ant",
         version: "0.10.1",
         dependencies: [["java", ">= 0.0.0"], ["jpackage", ">= 0.0.0"]] },
       { name: "ant",
         version: "0.10.0",
         dependencies: [["java", ">= 0.0.0"], ["jpackage", ">= 0.0.0"]] }],
      "aolserver" => [{ name: "aolserver", version: "1.0.0", dependencies: [] }],
      "apache" =>
      [{ name: "apache",
         version: "0.0.5",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "apache",
         version: "0.0.4",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "apache",
         version: "0.0.3",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "apache",
         version: "0.0.2",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "apache", version: "0.0.1", dependencies: [] }],
      "apache2-windows" =>
      [{ name: "apache2-windows",
         version: "0.1.11",
         dependencies: [["windows", ">= 0.0.0"], ["vcruntime", ">= 0.0.0"]] }],
      "apache2_odin_auth" =>
      [{ name: "apache2_odin_auth",
         version: "0.1.3",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["perl", ">= 0.0.0"]] },
       { name: "apache2_odin_auth",
         version: "0.1.2",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["perl", ">= 0.0.0"]] },
       { name: "apache2_odin_auth",
         version: "0.1.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["perl", ">= 0.0.0"]] },
       { name: "apache2_odin_auth",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["perl", ">= 0.0.0"]] }],
      "apache_vhosts" =>
      [{ name: "apache_vhosts",
         version: "20140206.0.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "apache_vhosts",
         version: "20140110.0.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "apache_vhosts",
         version: "20140109.0.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "apache_vhosts",
         version: "20140108.0.0",
         dependencies: [["apache2", ">= 0.0.0"]] }],
      "apcupsd" => [{ name: "apcupsd", version: "0.1.0", dependencies: [] }],
      "app" =>
      [{ name: "app",
         version: "0.1.1",
         dependencies: [["xml", ">= 0.0.0"],
          ["xslt", ">= 0.0.0"],
          ["imagemagick", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"]] },
       { name: "app",
         version: "0.1.0",
         dependencies: [["xml", ">= 0.0.0"],
          ["xslt", ">= 0.0.0"],
          ["imagemagick", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"]] }],
      "apparmor" =>
      [{ name: "apparmor", version: "0.9.2", dependencies: [] },
       { name: "apparmor", version: "0.9.0", dependencies: [] },
       { name: "apparmor", version: "0.7.0", dependencies: [] }],
      "appbox" =>
      [{ name: "appbox",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["user", ">= 0.0.0"],
          ["curl", ">= 0.0.0"],
          ["htop", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["tmux", ">= 0.0.0"]] },
       { name: "appbox",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["user", ">= 0.0.0"],
          ["curl", ">= 0.0.0"],
          ["htop", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["tmux", ">= 0.0.0"]] }],
      "Appfirst-Cookbook" =>
      [{ name: "Appfirst-Cookbook", version: "1.0.2", dependencies: [] }],
      "application" =>
      [{ name: "application", version: "4.1.4", dependencies: [] },
       { name: "application", version: "4.1.2", dependencies: [] },
       { name: "application", version: "4.1.0", dependencies: [] },
       { name: "application", version: "4.0.0", dependencies: [] },
       { name: "application", version: "3.0.0", dependencies: [] },
       { name: "application", version: "2.0.4", dependencies: [] },
       { name: "application", version: "2.0.2", dependencies: [] },
       { name: "application", version: "2.0.0", dependencies: [] },
       { name: "application",
         version: "1.0.4",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 1.0.6"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "1.0.2",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 1.0.6"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "1.0.0",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 1.0.6"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.14",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["python", ">= 1.0.6"]] },
       { name: "application",
         version: "0.99.12",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.11",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.10",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.9",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.8",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.7",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.6",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.5",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.4",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.3",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.2",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.1",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] },
       { name: "application",
         version: "0.99.0",
         dependencies: [["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] },
       { name: "application",
         version: "0.8.1",
         dependencies: [["ruby_enterprise", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] },
       { name: "application",
         version: "0.8.0",
         dependencies: [["passenger_apache2", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] },
       { name: "application",
         version: "0.7.0",
         dependencies: [["ruby_enterprise", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "application",
         version: "0.6.3",
         dependencies: [["ruby_enterprise", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "application",
         version: "0.6.2",
         dependencies: [["passenger_apache2", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"]] },
       { name: "application",
         version: "0.6.0",
         dependencies: [["passenger_apache2", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"]] },
       { name: "application",
         version: "0.5.0",
         dependencies: [["passenger_apache2", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "application",
         version: "0.4.0",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"]] },
       { name: "application",
         version: "0.3.0",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["passenger_enterprise", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"]] }],
      "applications" =>
      [{ name: "applications",
         version: "0.0.1",
         dependencies: [["dmg", ">= 0.0.0"],
          ["composer", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["rvm", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["percona", ">= 0.0.0"],
          ["newrelic", ">= 0.0.0"],
          ["pivotal-workstation", ">= 0.0.0"]] }],
      "application_java" =>
      [{ name: "application_java",
         version: "3.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["application", "~> 3.0"]] },
       { name: "application_java",
         version: "2.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["application", "~> 3.0"]] },
       { name: "application_java",
         version: "1.1.0",
         dependencies: [["application", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] },
       { name: "application_java",
         version: "1.0.4",
         dependencies: [["application", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] },
       { name: "application_java",
         version: "1.0.2",
         dependencies: [["application", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] },
       { name: "application_java",
         version: "1.0.0",
         dependencies: [["application", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] }],
      "application_nginx" =>
      [{ name: "application_nginx",
         version: "2.0.2",
         dependencies: [["application", "~> 3.0"], ["nginx", ">= 0.0.0"]] },
       { name: "application_nginx",
         version: "2.0.0",
         dependencies: [["application", "~> 3.0"], ["nginx", ">= 0.0.0"]] },
       { name: "application_nginx",
         version: "1.1.0",
         dependencies: [["application", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] },
       { name: "application_nginx",
         version: "1.0.4",
         dependencies: [["application", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] },
       { name: "application_nginx",
         version: "1.0.2",
         dependencies: [["application", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] },
       { name: "application_nginx",
         version: "1.0.0",
         dependencies: [["application", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] }],
      "application_nodejs" =>
      [{ name: "application_nodejs",
         version: "2.0.1",
         dependencies: [["nodejs", ">= 0.0.0"], ["application", ">= 0.0.0"]] },
       { name: "application_nodejs",
         version: "2.0.0",
         dependencies: [["nodejs", ">= 0.0.0"], ["application", ">= 0.0.0"]] },
       { name: "application_nodejs",
         version: "1.0.1",
         dependencies: [["nodejs", ">= 0.0.0"], ["application", ">= 0.0.0"]] }],
      "application_php" =>
      [{ name: "application_php",
         version: "2.0.0",
         dependencies: [["application", "~> 3.0"],
          ["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "application_php",
         version: "1.1.2",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"]] },
       { name: "application_php",
         version: "1.1.0",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"]] },
       { name: "application_php",
         version: "1.0.4",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"]] },
       { name: "application_php",
         version: "1.0.2",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"]] },
       { name: "application_php",
         version: "1.0.0",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"]] }],
      "application_python" =>
      [{ name: "application_python",
         version: "3.0.0",
         dependencies: [["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"],
          ["application", "~> 3.0"]] },
       { name: "application_python",
         version: "2.0.4",
         dependencies: [["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"],
          ["application", "~> 3.0"]] },
       { name: "application_python",
         version: "2.0.2",
         dependencies: [["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"],
          ["application", "~> 3.0"]] },
       { name: "application_python",
         version: "2.0.0",
         dependencies: [["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"],
          ["application", "~> 3.0"]] },
       { name: "application_python",
         version: "1.2.4",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] },
       { name: "application_python",
         version: "1.2.2",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] },
       { name: "application_python",
         version: "1.2.0",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] },
       { name: "application_python",
         version: "1.1.0",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] },
       { name: "application_python",
         version: "1.0.8",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] },
       { name: "application_python",
         version: "1.0.6",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] },
       { name: "application_python",
         version: "1.0.4",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] },
       { name: "application_python",
         version: "1.0.2",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] },
       { name: "application_python",
         version: "1.0.0",
         dependencies: [["application", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"]] }],
      "application_ruby" =>
      [{ name: "application_ruby",
         version: "3.0.2",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["application", "~> 4.0"],
          ["runit", "~> 1.0"],
          ["logrotate", "~> 1.0"]] },
       { name: "application_ruby",
         version: "2.2.0",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["application", "~> 4.0"],
          ["runit", "~> 1.0"],
          ["logrotate", "~> 1.0"]] },
       { name: "application_ruby",
         version: "2.1.4",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["application", "~> 3.0"],
          ["runit", "~> 1.0"],
          ["logrotate", "~> 1.0"]] },
       { name: "application_ruby",
         version: "2.1.2",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["application", "~> 3.0"],
          ["runit", "~> 1.0"],
          ["logrotate", "~> 1.0"]] },
       { name: "application_ruby",
         version: "2.1.0",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["application", "~> 3.0"],
          ["runit", "~> 1.0"]] },
       { name: "application_ruby",
         version: "2.0.0",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["application", "~> 3.0"],
          ["runit", "~> 1.0"]] },
       { name: "application_ruby",
         version: "1.1.4",
         dependencies: [["application", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["runit", "~> 1.0"]] },
       { name: "application_ruby",
         version: "1.1.2",
         dependencies: [["application", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["runit", "~> 1.0"]] },
       { name: "application_ruby",
         version: "1.1.0",
         dependencies: [["application", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["runit", "~> 1.0"]] },
       { name: "application_ruby",
         version: "1.0.10",
         dependencies: [["application", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["runit", "<= 0.16.2"]] },
       { name: "application_ruby",
         version: "1.0.8",
         dependencies: [["application", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "application_ruby",
         version: "1.0.6",
         dependencies: [["application", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "application_ruby",
         version: "1.0.4",
         dependencies: [["application", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "application_ruby",
         version: "1.0.2",
         dependencies: [["application", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "application_ruby",
         version: "1.0.0",
         dependencies: [["application", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] }],
      "application_wlp" =>
      [{ name: "application_wlp",
         version: "0.2.0",
         dependencies: [["application", ">= 4.1.2"], ["wlp", ">= 0.0.0"]] },
       { name: "application_wlp",
         version: "0.1.0",
         dependencies: [["application", "~> 3.0"], ["wlp", ">= 0.0.0"]] }],
      "application_zf" =>
      [{ name: "application_zf",
         version: "0.4.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] },
       { name: "application_zf",
         version: "0.3.1",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] },
       { name: "application_zf",
         version: "0.3.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] },
       { name: "application_zf",
         version: "0.2.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] },
       { name: "application_zf",
         version: "0.1.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] },
       { name: "application_zf",
         version: "0.0.5",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] },
       { name: "application_zf",
         version: "0.0.4",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] },
       { name: "application_zf",
         version: "0.0.3",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] },
       { name: "application_zf",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"]] }],
      "app_database" =>
      [{ name: "app_database",
         version: "0.1.0",
         dependencies: [["unix_bin", ">= 0.2.7"],
          ["resource_masher", ">= 0.10.0"],
          ["run_action_now", ">= 0.1.0"]] }],
      "apt-cacher-ng" =>
      [{ name: "apt-cacher-ng", version: "0.1.0", dependencies: [] }],
      "apt-mirror" => [{ name: "apt-mirror", version: "0.1.2", dependencies: [] }],
      "apt-periodic" =>
      [{ name: "apt-periodic",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "apt-periodic",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "apt-repo" => [{ name: "apt-repo", version: "0.1.0", dependencies: [] }],
      "apticron" =>
      [{ name: "apticron", version: "0.2.0", dependencies: [] },
       { name: "apticron", version: "0.1.0", dependencies: [] }],
      "archive" =>
      [{ name: "archive",
         version: "0.2.4",
         dependencies: [["cutlery", ">= 0.0.0"]] },
       { name: "archive",
         version: "0.2.1",
         dependencies: [["cutlery", ">= 0.2.0"]] }],
      "arpwatch" =>
      [{ name: "arpwatch", version: "0.1.1", dependencies: [] },
       { name: "arpwatch", version: "0.1.0", dependencies: [] }],
      "artifact" =>
      [{ name: "artifact",
         version: "1.11.3",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "artifact",
         version: "1.11.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "artifact",
         version: "1.11.1",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "artifact",
         version: "1.11.0",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.10.3",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.10.2",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.10.1",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.10.0",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.9.0",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.8.1",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.8.0",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.7.1",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.6.1",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.7.0",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.6.0",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.5.0",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact",
         version: "1.4.0",
         dependencies: [["windows", "~> 1.8.0"]] },
       { name: "artifact", version: "1.3.1", dependencies: [] },
       { name: "artifact", version: "1.3.0", dependencies: [] },
       { name: "artifact", version: "1.2.0", dependencies: [] },
       { name: "artifact", version: "1.1.2", dependencies: [] },
       { name: "artifact", version: "1.1.1", dependencies: [] },
       { name: "artifact", version: "1.1.0", dependencies: [] },
       { name: "artifact", version: "1.0.0", dependencies: [] },
       { name: "artifact",
         version: "0.11.5",
         dependencies: [["nexus", ">= 0.17.0"]] },
       { name: "artifact",
         version: "0.11.4",
         dependencies: [["nexus", ">= 0.17.0"]] },
       { name: "artifact",
         version: "0.11.3",
         dependencies: [["nexus", ">= 0.17.0"]] },
       { name: "artifact",
         version: "0.11.2",
         dependencies: [["nexus", ">= 0.11.2"]] },
       { name: "artifact",
         version: "0.11.1",
         dependencies: [["nexus", ">= 0.11.2"]] },
       { name: "artifact",
         version: "0.11.0",
         dependencies: [["nexus", ">= 0.11.2"]] },
       { name: "artifact",
         version: "0.10.10",
         dependencies: [["nexus", ">= 0.11.2"]] },
       { name: "artifact",
         version: "0.10.7",
         dependencies: [["nexus", "~> 0.11.2"]] },
       { name: "artifact", version: "0.10.2", dependencies: [] },
       { name: "artifact", version: "0.10.1", dependencies: [] },
       { name: "artifact", version: "0.10.0", dependencies: [] },
       { name: "artifact", version: "0.9.8", dependencies: [] },
       { name: "artifact", version: "0.9.7", dependencies: [] },
       { name: "artifact", version: "0.9.6", dependencies: [] },
       { name: "artifact", version: "0.9.5", dependencies: [] },
       { name: "artifact", version: "0.9.4", dependencies: [] },
       { name: "artifact", version: "0.9.3", dependencies: [] }],
      "asgard" =>
      [{ name: "asgard",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"], ["java", ">= 0.0.0"], ["tomcat", ">= 0.0.0"]] },
       { name: "asgard",
         version: "0.0.2",
         dependencies: [["apache2", ">= 0.0.0"], ["java", ">= 0.0.0"], ["tomcat", ">= 0.0.0"]] }],
      "asterisk" =>
      [{ name: "asterisk",
         version: "0.3.0",
         dependencies: [["apt", "~> 2.2"],
          ["build-essential", "~> 1.4"],
          ["unimrcp", "~> 0.2"],
          ["yum", "~> 3.0"]] },
       { name: "asterisk",
         version: "0.2.7",
         dependencies: [["apt", "~> 2.2"], ["unimrcp", "~> 0.1"]] },
       { name: "asterisk", version: "0.2.6", dependencies: [["apt", "~> 2.2"]] },
       { name: "asterisk",
         version: "0.2.5",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] },
       { name: "asterisk",
         version: "0.2.4",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] },
       { name: "asterisk",
         version: "0.2.3",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] },
       { name: "asterisk",
         version: "0.2.2",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] },
       { name: "asterisk",
         version: "0.2.1",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] },
       { name: "asterisk",
         version: "0.2.0",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] },
       { name: "asterisk",
         version: "0.1.0",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] }],
      "atftp" => [{ name: "atftp", version: "0.0.1", dependencies: [] }],
      "atg" =>
      [{ name: "atg",
         version: "1.0.1",
         dependencies: [["java, jboss-atg, generic-users and sudoers", ">= 0.0.0"]] },
       { name: "atg",
         version: "1.0.0",
         dependencies: [["java, jboss-atg, generic-users and sudoers", ">= 0.0.0"]] }],
      "attrbagger" =>
      [{ name: "attrbagger", version: "0.2.1", dependencies: [] },
       { name: "attrbagger", version: "0.2.0", dependencies: [] }],
      "attribute-validator" =>
      [{ name: "attribute-validator", version: "0.3.2", dependencies: [] },
       { name: "attribute-validator", version: "0.3.0", dependencies: [] },
       { name: "attribute-validator", version: "0.2.0", dependencies: [] },
       { name: "attribute-validator", version: "0.1.0", dependencies: [] }],
      "auditd" =>
      [{ name: "auditd", version: "0.1.4", dependencies: [] },
       { name: "auditd", version: "0.1.3", dependencies: [] },
       { name: "auditd", version: "0.1.0", dependencies: [] }],
      "aufs" =>
      [{ name: "aufs",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["modules", ">= 0.0.0"]] },
       { name: "aufs",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["modules", ">= 0.0.0"]] }],
      "authbind" =>
      [{ name: "authbind",
         version: "0.1.6",
         dependencies: [["cutlery", ">= 0.0.0"]] },
       { name: "authbind",
         version: "0.1.5",
         dependencies: [["cutlery", ">= 0.0.0"]] },
       { name: "authbind",
         version: "0.1.4",
         dependencies: [["cutlery", ">= 0.0.0"]] },
       { name: "authbind", version: "0.1.3", dependencies: [] },
       { name: "authbind", version: "0.1.2", dependencies: [] },
       { name: "authbind", version: "0.1.1", dependencies: [] },
       { name: "authbind", version: "0.1.0", dependencies: [] }],
      "authconfig" =>
      [{ name: "authconfig", version: "1.1.2", dependencies: [] },
       { name: "authconfig", version: "1.1.0", dependencies: [] },
       { name: "authconfig", version: "0.3.0", dependencies: [] },
       { name: "authconfig", version: "0.2.0", dependencies: [] }],
      "auto-patch" =>
      [{ name: "auto-patch",
         version: "0.1.9",
         dependencies: [["cron", ">= 0.0.0"]] }],
      "autoetchosts" =>
      [{ name: "autoetchosts", version: "0.0.1", dependencies: [] }],
      "autohotkey" =>
      [{ name: "autohotkey",
         version: "0.1.1",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "autohotkey",
         version: "0.1.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "aws-cloud-watch-cli-tools" =>
      [{ name: "aws-cloud-watch-cli-tools",
         version: "0.2.0",
         dependencies: [["aws", ">= 0.100.6"], ["java", ">= 1.8.0"]] }],
      "aws-rds" =>
      [{ name: "aws-rds", version: "1.3.0", dependencies: [] },
       { name: "aws-rds", version: "1.2.0", dependencies: [] },
       { name: "aws-rds", version: "1.1.0", dependencies: [] },
       { name: "aws-rds", version: "1.0.2", dependencies: [] },
       { name: "aws-rds", version: "1.0.1", dependencies: [] },
       { name: "aws-rds", version: "1.0.0", dependencies: [] }],
      "awsclient" =>
      [{ name: "awsclient",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["aws", ">= 0.0.0"]] }],
      "awstats" =>
      [{ name: "awstats",
         version: "0.2.2",
         dependencies: [["apache2", ">= 0.0.0"], ["htpasswd", ">= 0.0.0"]] }],
      "aws_developer_tools" =>
      [{ name: "aws_developer_tools",
         version: "3.1.3",
         dependencies: [["java", ">= 1.8.0"], ["chef_ruby", ">= 2.2.0"]] },
       { name: "aws_developer_tools",
         version: "3.0.0",
         dependencies: [["java", ">= 1.8.0"], ["chef_ruby", ">= 2.2.0"]] },
       { name: "aws_developer_tools",
         version: "2.0.0",
         dependencies: [["java", ">= 1.8.0"], ["chef_ruby", ">= 2.2.0"]] },
       { name: "aws_developer_tools",
         version: "1.0.0",
         dependencies: [["java", ">= 1.8.0"], ["chef_ruby", ">= 2.2.0"]] }],
      "aws_extras" =>
      [{ name: "aws_extras", version: "1.1.0", dependencies: [] },
       { name: "aws_extras", version: "1.0.0", dependencies: [] }],
      "azure" =>
      [{ name: "azure", version: "0.2.0", dependencies: [["ohai", ">= 1.1.4"]] },
       { name: "azure", version: "0.1.1", dependencies: [["ohai", ">= 1.1.4"]] },
       { name: "azure", version: "0.1.0", dependencies: [["ohai", ">= 1.1.4"]] }],
      "backup" =>
      [{ name: "backup", version: "0.4.0", dependencies: [["cron", ">= 0.0.0"]] },
       { name: "backup", version: "0.3.2", dependencies: [["cron", ">= 0.0.0"]] },
       { name: "backup", version: "0.3.1", dependencies: [["cron", ">= 0.0.0"]] },
       { name: "backup",
         version: "0.0.4",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "backup", version: "0.0.3", dependencies: [] },
       { name: "backup", version: "0.0.2", dependencies: [] },
       { name: "backup", version: "0.0.1", dependencies: [] }],
      "backup-manager" =>
      [{ name: "backup-manager", version: "0.0.2", dependencies: [] },
       { name: "backup-manager", version: "0.0.1", dependencies: [] }],
      "backuppc-client" =>
      [{ name: "backuppc-client",
         version: "0.9.1",
         dependencies: [["sudo", "~> 2.5.2"]] },
       { name: "backuppc-client",
         version: "0.9.0",
         dependencies: [["sudo", "~> 2.5.2"]] }],
      "backuppc-server" =>
      [{ name: "backuppc-server",
         version: "1.1.0",
         dependencies: [["apache2", "~> 1.9.6"],
          ["build-essential", "~> 1.4.4"],
          ["perl", "~> 1.2.2"],
          ["postfix", "~> 3.1.4"],
          ["sudo", "~> 2.5.2"]] },
       { name: "backuppc-server",
         version: "1.0.0",
         dependencies: [["apache2", "~> 1.9.6"],
          ["build-essential", "~> 1.4.4"],
          ["perl", "~> 1.2.2"],
          ["postfix", "~> 3.1.4"],
          ["sudo", "~> 2.5.2"]] },
       { name: "backuppc-server",
         version: "0.9.0",
         dependencies: [["apache2", "~> 1.9.6"],
          ["build-essential", "~> 1.4.4"],
          ["perl", "~> 1.2.2"],
          ["postfix", "~> 3.1.4"],
          ["sudo", "~> 2.5.2"]] },
       { name: "backuppc-server",
         version: "0.1.0",
         dependencies: [["apache2", "~> 1.9.6"],
          ["build-essential", "~> 1.4.4"],
          ["perl", "~> 1.2.2"],
          ["postfix", "~> 3.1.4"],
          ["sudo", "~> 2.5.2"]] }],
      "backup_lwrp" =>
      [{ name: "backup_lwrp",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["cron", ">= 0.0.0"]] },
       { name: "backup_lwrp",
         version: "0.0.11",
         dependencies: [["build-essential", ">= 0.0.0"], ["cron", ">= 0.0.0"]] },
       { name: "backup_lwrp",
         version: "0.0.10",
         dependencies: [["build-essential", ">= 0.0.0"], ["cron", ">= 0.0.0"]] },
       { name: "backup_lwrp",
         version: "0.0.4",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "bacon" =>
      [{ name: "bacon", version: "11.0.1388269389", dependencies: [] },
       { name: "bacon", version: "10.0.1388266505", dependencies: [] },
       { name: "bacon", version: "10.0.1388266201", dependencies: [] },
       { name: "bacon", version: "10.0.1388266120", dependencies: [] },
       { name: "bacon", version: "10.0.1388266054", dependencies: [] },
       { name: "bacon", version: "10.0.1388265814", dependencies: [] },
       { name: "bacon", version: "10.0.1388265653", dependencies: [] },
       { name: "bacon", version: "0.0.0", dependencies: [] },
       { name: "bacon", version: "6.0.34", dependencies: [] },
       { name: "bacon", version: "6.0.32", dependencies: [] },
       { name: "bacon", version: "6.0.30", dependencies: [] },
       { name: "bacon", version: "6.0.28", dependencies: [] },
       { name: "bacon", version: "6.0.16", dependencies: [] },
       { name: "bacon", version: "6.0.15", dependencies: [] },
       { name: "bacon", version: "6.0.14", dependencies: [] },
       { name: "bacon", version: "6.0.13", dependencies: [] },
       { name: "bacon", version: "6.0.12", dependencies: [] },
       { name: "bacon", version: "6.0.11", dependencies: [] },
       { name: "bacon", version: "6.0.10", dependencies: [] },
       { name: "bacon", version: "6.0.9", dependencies: [] },
       { name: "bacon", version: "6.0.8", dependencies: [] },
       { name: "bacon", version: "6.0.7", dependencies: [] },
       { name: "bacon", version: "1.5.1388111522", dependencies: [] },
       { name: "bacon", version: "1.5.1388111484", dependencies: [] },
       { name: "bacon", version: "1.5.1388111092", dependencies: [] },
       { name: "bacon", version: "1.5.1388111070", dependencies: [] },
       { name: "bacon", version: "1.5.1388111007", dependencies: [] },
       { name: "bacon", version: "1.5.1388110951", dependencies: [] },
       { name: "bacon", version: "1.5.1388110639", dependencies: [] },
       { name: "bacon", version: "1.5.1388110567", dependencies: [] },
       { name: "bacon", version: "1.5.1388110520", dependencies: [] },
       { name: "bacon", version: "1.5.1388110504", dependencies: [] },
       { name: "bacon", version: "1.5.1388110439", dependencies: [] },
       { name: "bacon", version: "1.5.1388110426", dependencies: [] },
       { name: "bacon", version: "1.5.1388110273", dependencies: [] },
       { name: "bacon", version: "1.5.1388110213", dependencies: [] },
       { name: "bacon", version: "1.5.9", dependencies: [] },
       { name: "bacon", version: "1.5.8", dependencies: [] },
       { name: "bacon", version: "1.5.7", dependencies: [] },
       { name: "bacon", version: "1.5.6", dependencies: [] },
       { name: "bacon", version: "1.5.5", dependencies: [] },
       { name: "bacon", version: "1.5.3", dependencies: [] },
       { name: "bacon", version: "1.5.2", dependencies: [] },
       { name: "bacon", version: "1.0.1", dependencies: [] },
       { name: "bacon", version: "0.1.3", dependencies: [] },
       { name: "bacon", version: "0.1.2", dependencies: [] },
       { name: "bacon", version: "0.1.1", dependencies: [] },
       { name: "bacon", version: "0.1.0", dependencies: [] }],
      "bacula" =>
      [{ name: "bacula",
         version: "1.2.1",
         dependencies: [["database", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["mysql", ">= 3.0.0"]] },
       { name: "bacula",
         version: "1.2.0",
         dependencies: [["openssl", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 3.0.0"]] },
       { name: "bacula",
         version: "1.1.1",
         dependencies: [["openssl", ">= 0.0.0"], ["database", ">= 0.0.0"]] },
       { name: "bacula",
         version: "1.0.0",
         dependencies: [["database", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] }],
      "bag_config" =>
      [{ name: "bag_config", version: "2.0.1", dependencies: [] },
       { name: "bag_config", version: "2.0.0", dependencies: [] },
       { name: "bag_config", version: "1.0.1", dependencies: [] },
       { name: "bag_config", version: "1.0.0", dependencies: [] }],
      "bamboo" =>
      [{ name: "bamboo",
         version: "1.1.0",
         dependencies: [["ark", "= 0.4.0"],
          ["apache2", "= 1.8.4"],
          ["backup", "= 0.0.5"],
          ["cron", "= 1.2.8"],
          ["database", "= 1.5.2"],
          ["git", "= 2.7.0"],
          ["java", "= 1.12.0"],
          ["mysql", "= 3.0.2"],
          ["mysql_connector", "= 0.4.1"],
          ["perl", "= 1.2.0"]] }],
      "bapteme" =>
      [{ name: "bapteme",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "base" => [{ name: "base", version: "0.1.0", dependencies: [] }],
      "bash" =>
      [{ name: "bash", version: "0.1.2", dependencies: [] },
       { name: "bash", version: "0.1.1", dependencies: [] },
       { name: "bash", version: "0.1.0", dependencies: [] }],
      "bash-completion" =>
      [{ name: "bash-completion", version: "0.1.0", dependencies: [] }],
      "bazaar" => [{ name: "bazaar", version: "0.0.1", dependencies: [] }],
      "beanstalkd" =>
      [{ name: "beanstalkd", version: "0.1.3", dependencies: [] },
       { name: "beanstalkd", version: "0.1.2", dependencies: [] },
       { name: "beanstalkd", version: "0.1.1", dependencies: [] },
       { name: "beanstalkd", version: "0.1.0", dependencies: [] },
       { name: "beanstalkd", version: "0.0.3", dependencies: [] },
       { name: "beanstalkd", version: "0.0.4", dependencies: [] },
       { name: "beanstalkd", version: "0.0.2", dependencies: [] },
       { name: "beanstalkd", version: "0.0.1", dependencies: [] }],
      "beaver" =>
      [{ name: "beaver",
         version: "1.1.0",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "beaver",
         version: "0.1.0",
         dependencies: [["python", ">= 0.0.0"]] }],
      "berkshelf" =>
      [{ name: "berkshelf",
         version: "0.3.1",
         dependencies: [["runit", ">= 0.0.0"], ["rbenv", ">= 1.5.0"], ["nginx", ">= 1.7.0"]] },
       { name: "berkshelf",
         version: "0.3.0",
         dependencies: [["runit", ">= 0.0.0"], ["rbenv", ">= 1.5.0"], ["nginx", ">= 1.7.0"]] },
       { name: "berkshelf",
         version: "0.2.2",
         dependencies: [["runit", ">= 0.0.0"], ["rbenv", ">= 1.5.0"], ["nginx", ">= 1.7.0"]] },
       { name: "berkshelf",
         version: "0.2.1",
         dependencies: [["runit", ">= 0.0.0"], ["rbenv", ">= 1.5.0"], ["nginx", ">= 1.7.0"]] },
       { name: "berkshelf",
         version: "0.2.0",
         dependencies: [["rbenv", ">= 1.5.0"], ["nginx", ">= 1.7.0"]] },
       { name: "berkshelf",
         version: "0.1.0",
         dependencies: [["rbenv", ">= 1.5.0"]] }],
      "berkshelf-api" =>
      [{ name: "berkshelf-api",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["poise", ">= 0.0.0"],
          ["poise-ruby", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] }],
      "berkshelf-cookbook-fixture" =>
      [{ name: "berkshelf-cookbook-fixture", version: "1.0.0", dependencies: [] },
       { name: "berkshelf-cookbook-fixture", version: "0.2.0", dependencies: [] },
       { name: "berkshelf-cookbook-fixture",
         version: "0.1.0",
         dependencies: [] }],
      "bginfo" =>
      [{ name: "bginfo",
         version: "0.0.6",
         dependencies: [["windows", ">= 1.2.8"]] }],
      "bigdesk" =>
      [{ name: "bigdesk",
         version: "0.0.1",
         dependencies: [["elasticsearch", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "bind" =>
      [{ name: "bind", version: "1.0.2", dependencies: [] },
       { name: "bind", version: "1.0.1", dependencies: [] },
       { name: "bind", version: "1.0.0", dependencies: [] },
       { name: "bind", version: "0.2.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "bind", version: "0.1.1", dependencies: [] },
       { name: "bind", version: "0.1.0", dependencies: [] },
       { name: "bind", version: "0.0.9", dependencies: [] },
       { name: "bind", version: "0.0.8", dependencies: [] },
       { name: "bind", version: "0.0.7", dependencies: [] },
       { name: "bind", version: "0.0.6", dependencies: [] },
       { name: "bind", version: "0.0.5", dependencies: [] },
       { name: "bind", version: "0.0.4", dependencies: [] }],
      "bind-chroot" =>
      [{ name: "bind-chroot", version: "0.0.18", dependencies: [] },
       { name: "bind-chroot", version: "0.0.16", dependencies: [] },
       { name: "bind-chroot", version: "0.0.12", dependencies: [] }],
      "bind10" => [{ name: "bind10", version: "0.1.0", dependencies: [] }],
      "bind9" => [{ name: "bind9", version: "0.1.3", dependencies: [] }],
      "bind9-chroot" =>
      [{ name: "bind9-chroot", version: "0.4.1", dependencies: [] },
       { name: "bind9-chroot", version: "0.4.0", dependencies: [] }],
      "bind9-easy" =>
      [{ name: "bind9-easy", version: "0.1.0", dependencies: [] },
       { name: "bind9-easy", version: "0.0.1", dependencies: [] }],
      "bitly" => [{ name: "bitly", version: "0.1.0", dependencies: [] }],
      "bittorrent" =>
      [{ name: "bittorrent",
         version: "0.3.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "bittorrent", version: "0.1.0", dependencies: [] }],
      "blacklist_node_attrs" =>
      [{ name: "blacklist_node_attrs", version: "0.1.0", dependencies: [] }],
      "bonita" =>
      [{ name: "bonita",
         version: "5.7.1",
         dependencies: [["tomcat", ">= 0.0.0"]] },
       { name: "bonita",
         version: "0.1.2",
         dependencies: [["tomcat", ">= 0.0.0"]] },
       { name: "bonita",
         version: "0.1.1",
         dependencies: [["tomcat", ">= 0.0.0"]] },
       { name: "bonita",
         version: "0.1.0",
         dependencies: [["tomcat", ">= 0.0.0"]] }],
      "boost" =>
      [{ name: "boost", version: "0.2.0", dependencies: [] },
       { name: "boost", version: "0.1.0", dependencies: [] }],
      "bootstrap" =>
      [{ name: "bootstrap",
         version: "0.11.4",
         dependencies: [["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "bootstrap",
         version: "0.11.2",
         dependencies: [["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "bootstrap",
         version: "0.11.0",
         dependencies: [["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "bootstrap",
         version: "0.1.0",
         dependencies: [["stompserver", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "bridger" => [{ name: "bridger", version: "0.0.1", dependencies: [] }],
      "brightbox-ruby" =>
      [{ name: "brightbox-ruby",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "bsdcpio" => [{ name: "bsdcpio", version: "1.0.0", dependencies: [] }],
      "btm-test" =>
      [{ name: "btm-test", version: "0.1.1", dependencies: [] },
       { name: "btm-test", version: "0.1.0", dependencies: [] }],
      "btsync" =>
      [{ name: "btsync",
         version: "0.1.27",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "btsync",
         version: "0.1.26",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "btsync", version: "0.1.5", dependencies: [] },
       { name: "btsync", version: "0.1.4", dependencies: [] },
       { name: "btsync", version: "0.1.3", dependencies: [] }],
      "builder" =>
      [{ name: "builder",
         version: "0.1.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["ssh_known_hosts", ">= 0.0.0"]] },
       { name: "builder",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "builder",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "buildr" =>
      [{ name: "buildr",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "bundler" =>
      [{ name: "bundler",
         version: "0.2.0",
         dependencies: [["rubygems", ">= 0.0.0"]] }],
      "bundler_enterprise" =>
      [{ name: "bundler_enterprise", version: "0.1.0", dependencies: [] }],
      "byobu" => [{ name: "byobu", version: "0.0.1", dependencies: [] }],
      "cabal" =>
      [{ name: "cabal", version: "0.1.2", dependencies: [] },
       { name: "cabal", version: "0.1.1", dependencies: [] },
       { name: "cabal", version: "0.1.0", dependencies: [] }],
      "cacert" =>
      [{ name: "cacert", version: "0.2.0", dependencies: [] },
       { name: "cacert", version: "0.1.0", dependencies: [] }],
      "cacti" =>
      [{ name: "cacti",
         version: "0.5.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "cacti",
         version: "0.4.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "cacti",
         version: "0.3.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "cacti",
         version: "0.2.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "cacti",
         version: "0.1.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] }],
      "cakephp" =>
      [{ name: "cakephp",
         version: "0.0.1",
         dependencies: [["mysql", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "camo" =>
      [{ name: "camo",
         version: "0.1.0",
         dependencies: [["nodejs", ">= 0.0.0"]] }],
      "campfire" =>
      [{ name: "campfire", version: "0.0.4", dependencies: [] },
       { name: "campfire", version: "0.0.3", dependencies: [] }],
      "capistrano" => [{ name: "capistrano", version: "0.7.0", dependencies: [] }],
      "carbon" =>
      [{ name: "carbon",
         version: "0.3.2",
         dependencies: [["runit", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "carbon",
         version: "0.1.1",
         dependencies: [["runit", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] }],
      "carton" =>
      [{ name: "carton",
         version: "0.1.0",
         dependencies: [["perlbrew", ">= 0.1.0"], ["runit", ">= 0.15.0"]] }],
      "cassandra" =>
      [{ name: "cassandra",
         version: "0.2.4",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["thrift", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"]] },
       { name: "cassandra",
         version: "0.2.3",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["thrift", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["tuning", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"],
          ["dashpot", ">= 0.0.0"]] },
       { name: "cassandra",
         version: "0.2.2",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["thrift", ">= 0.0.0"],
          ["mountable_volumes", ">= 0.0.0"],
          ["provides_service", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] }],
      "cassandra-opscenter" =>
      [{ name: "cassandra-opscenter",
         version: "0.0.5",
         dependencies: [["python", ">= 0.0.0"], ["java", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] }],
      "cassandra-priam" =>
      [{ name: "cassandra-priam",
         version: "0.0.5",
         dependencies: [["sudo", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"]] }],
      "catalyst" =>
      [{ name: "catalyst", version: "0.0.6", dependencies: [] },
       { name: "catalyst", version: "0.0.5", dependencies: [] },
       { name: "catalyst", version: "0.0.4", dependencies: [] },
       { name: "catalyst", version: "0.0.32", dependencies: [] },
       { name: "catalyst", version: "0.0.31", dependencies: [] },
       { name: "catalyst", version: "0.0.3", dependencies: [] }],
      "catalyst-fastcgi" =>
      [{ name: "catalyst-fastcgi",
         version: "0.0.4",
         dependencies: [["catalyst", ">= 0.0.4"], ["apache", ">= 0.0.3"]] },
       { name: "catalyst-fastcgi",
         version: "0.0.3",
         dependencies: [["apache", ">= 0.0.3"], ["catalyst", ">= 0.0.4"]] },
       { name: "catalyst-fastcgi",
         version: "0.0.2",
         dependencies: [["catalyst", ">= 0.0.4"], ["apache", ">= 0.0.3"]] },
       { name: "catalyst-fastcgi",
         version: "0.0.1",
         dependencies: [["catalyst", ">= 0.0.0"], ["apache", ">= 0.0.0"]] }],
      "ca_openldap" =>
      [{ name: "ca_openldap", version: "0.2.1", dependencies: [] },
       { name: "ca_openldap", version: "0.2.0", dependencies: [] }],
      "ceph" =>
      [{ name: "ceph",
         version: "0.2.0",
         dependencies: [["apache2", ">= 1.1.12"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 3.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "ceph",
         version: "0.1.0",
         dependencies: [["apache2", ">= 1.1.12"], ["apt", ">= 0.0.0"]] }],
      "cerberus" =>
      [{ name: "cerberus",
         version: "2.1.0",
         dependencies: [["twitter", ">= 1.0.1"]] },
       { name: "cerberus",
         version: "1.0.3",
         dependencies: [["twitter", ">= 1.0.1"]] },
       { name: "cerberus",
         version: "0.2.0",
         dependencies: [["twitter", ">= 1.0.1"]] },
       { name: "cerberus",
         version: "0.1.3",
         dependencies: [["twitter", ">= 1.0.1"]] }],
      "certificate" =>
      [{ name: "certificate", version: "0.5.0", dependencies: [] },
       { name: "certificate", version: "0.4.3", dependencies: [] },
       { name: "certificate", version: "0.4.2", dependencies: [] },
       { name: "certificate", version: "0.4.1", dependencies: [] },
       { name: "certificate", version: "0.3.0", dependencies: [] },
       { name: "certificate", version: "0.2.3", dependencies: [] },
       { name: "certificate", version: "0.2.2", dependencies: [] },
       { name: "certificate", version: "0.2.1", dependencies: [] },
       { name: "certificate", version: "0.2.0", dependencies: [] },
       { name: "certificate", version: "0.1.0", dependencies: [] },
       { name: "certificate", version: "0.0.6", dependencies: [] },
       { name: "certificate", version: "0.0.5", dependencies: [] },
       { name: "certificate", version: "0.0.4", dependencies: [] },
       { name: "certificate", version: "0.0.3", dependencies: [] },
       { name: "certificate", version: "0.0.2", dependencies: [] }],
      "cgroups" => [{ name: "cgroups", version: "0.0.1", dependencies: [] }],
      "chadu" =>
      [{ name: "chadu", version: "0.0.4", dependencies: [] },
       { name: "chadu", version: "0.0.3", dependencies: [] },
       { name: "chadu", version: "0.0.2", dependencies: [] },
       { name: "chadu", version: "0.0.1", dependencies: [] }],
      "chapp" => [{ name: "chapp", version: "0.1.0", dependencies: [] }],
      "charon" =>
      [{ name: "charon",
         version: "0.1.1",
         dependencies: [["winstaller", ">= 0.0.6"]] }],
      "checksum" =>
      [{ name: "checksum", version: "0.1.1", dependencies: [] },
       { name: "checksum", version: "0.1.0", dependencies: [] }],
      "chef" =>
      [{ name: "chef",
         version: "0.99.9",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["chef-server", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.99.1",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.99.0",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.22.1",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.22.0",
         dependencies: [["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.21.3",
         dependencies: [["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.21.2",
         dependencies: [["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.21.0",
         dependencies: [["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.20.0",
         dependencies: [["zlib", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rabbitmq_chef", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "chef",
         version: "0.12.0",
         dependencies: [["passenger_apache2", ">= 0.0.0"],
          ["stompserver", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["couchdb", ">= 0.0.0"],
          ["packages", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "chef-client" =>
      [{ name: "chef-client",
         version: "3.3.8",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.3.6",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.3.4",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.3.3",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.3.2",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.3.0",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.2.2",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.2.0",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.1.2",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.1.0",
         dependencies: [["cron", ">= 1.2.0"], ["logrotate", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.0.6",
         dependencies: [["cron", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.0.4",
         dependencies: [["cron", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.0.2",
         dependencies: [["cron", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "3.0.0",
         dependencies: [["cron", ">= 1.2.0"]] },
       { name: "chef-client",
         version: "2.2.4",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "chef-client",
         version: "2.2.2",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "chef-client",
         version: "2.2.0",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "chef-client",
         version: "2.1.10",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "chef-client",
         version: "2.1.8",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "chef-client", version: "2.1.6", dependencies: [] },
       { name: "chef-client", version: "2.1.4", dependencies: [] },
       { name: "chef-client", version: "2.1.2", dependencies: [] },
       { name: "chef-client", version: "2.1.0", dependencies: [] },
       { name: "chef-client", version: "2.0.2", dependencies: [] },
       { name: "chef-client", version: "2.0.0", dependencies: [] },
       { name: "chef-client", version: "1.2.0", dependencies: [] },
       { name: "chef-client", version: "1.1.4", dependencies: [] },
       { name: "chef-client", version: "1.1.2", dependencies: [] },
       { name: "chef-client", version: "1.1.0", dependencies: [] },
       { name: "chef-client", version: "1.0.4", dependencies: [] },
       { name: "chef-client", version: "1.0.2", dependencies: [] },
       { name: "chef-client", version: "1.0.0", dependencies: [] },
       { name: "chef-client", version: "0.99.5", dependencies: [] },
       { name: "chef-client", version: "0.99.4", dependencies: [] },
       { name: "chef-client", version: "0.99.3", dependencies: [] },
       { name: "chef-client", version: "0.99.2", dependencies: [] },
       { name: "chef-client", version: "0.99.1", dependencies: [] },
       { name: "chef-client", version: "0.99.0", dependencies: [] }],
      "chef-client-cron" =>
      [{ name: "chef-client-cron", version: "1.0.4", dependencies: [] }],
      "chef-client_syslog" =>
      [{ name: "chef-client_syslog", version: "0.1.0", dependencies: [] }],
      "chef-golang" =>
      [{ name: "chef-golang", version: "1.0.1", dependencies: [] },
       { name: "chef-golang", version: "1.0.0", dependencies: [] }],
      "chef-lighttpd" =>
      [{ name: "chef-lighttpd", version: "0.3.0", dependencies: [] }],
      "chef-pry" =>
      [{ name: "chef-pry",
         version: "0.2.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "chef-pry",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["xml", ">= 0.0.0"]] }],
      "chef-reporting" =>
      [{ name: "chef-reporting",
         version: "0.1.2",
         dependencies: [["chef-client", ">= 3.0.0"]] }],
      "chef-sbt" => [{ name: "chef-sbt", version: "0.0.1", dependencies: [] }],
      "chef-server-populator" =>
      [{ name: "chef-server-populator",
         version: "0.3.0",
         dependencies: [["chef-server", ">= 2.0.0"]] },
       { name: "chef-server-populator", version: "0.2.0", dependencies: [] },
       { name: "chef-server-populator",
         version: "0.1.1",
         dependencies: [["chef-server", ">= 0.0.0"]] },
       { name: "chef-server-populator", version: "0.1.0", dependencies: [] }],
      "chef-server-webapp" =>
      [{ name: "chef-server-webapp",
         version: "0.1.3",
         dependencies: [["apache2", ">= 0.0.0"], ["chef-server", ">= 2.0.0"]] },
       { name: "chef-server-webapp",
         version: "0.1.2",
         dependencies: [["apache2", ">= 0.0.0"], ["chef-server", ">= 2.0.0"]] },
       { name: "chef-server-webapp",
         version: "0.1.1",
         dependencies: [["apache2", ">= 0.0.0"], ["chef-server", ">= 2.0.0"]] },
       { name: "chef-server-webapp",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"], ["chef-server", ">= 2.0.0"]] }],
      "chef-solo-search" =>
      [{ name: "chef-solo-search", version: "0.5.1", dependencies: [] },
       { name: "chef-solo-search", version: "0.4.0", dependencies: [] }],
      "chef-splunk" =>
      [{ name: "chef-splunk",
         version: "1.1.0",
         dependencies: [["chef-vault", ">= 1.0.4"]] },
       { name: "chef-splunk",
         version: "1.0.4",
         dependencies: [["chef-vault", ">= 1.0.4"]] },
       { name: "chef-splunk",
         version: "1.0.2",
         dependencies: [["chef-vault", ">= 1.0.4"]] },
       { name: "chef-splunk",
         version: "1.0.0",
         dependencies: [["chef-vault", ">= 1.0.4"]] }],
      "chef-vault" =>
      [{ name: "chef-vault", version: "1.0.4", dependencies: [] },
       { name: "chef-vault", version: "1.0.2", dependencies: [] },
       { name: "chef-vault", version: "1.0.0", dependencies: [] }],
      "chef-zero" =>
      [{ name: "chef-zero",
         version: "2.0.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "chef-zero",
         version: "2.0.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "chef-zero",
         version: "1.2.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "chef-zero",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "chef-zero", version: "1.0.0", dependencies: [] }],
      "chef_ec2_cli_tools" =>
      [{ name: "chef_ec2_cli_tools",
         version: "0.2.0",
         dependencies: [["java", "~> 1.8.0"]] },
       { name: "chef_ec2_cli_tools",
         version: "0.1.2",
         dependencies: [["java", "~> 1.8.0"]] }],
      "chef_gem" =>
      [{ name: "chef_gem", version: "0.1.0", dependencies: [] },
       { name: "chef_gem", version: "0.0.5", dependencies: [] },
       { name: "chef_gem", version: "0.0.4", dependencies: [] },
       { name: "chef_gem", version: "0.0.3", dependencies: [] },
       { name: "chef_gem", version: "0.0.2", dependencies: [] },
       { name: "chef_gem", version: "0.0.1", dependencies: [] }],
      "chef_handler_orchestrate_io" =>
      [{ name: "chef_handler_orchestrate_io",
         version: "0.1.0",
         dependencies: [] }],
      "chef_handler_sns" =>
      [{ name: "chef_handler_sns",
         version: "0.1.0",
         dependencies: [["xml", ">= 0.0.0"], ["chef_handler", ">= 0.0.0"]] }],
      "chef_package" =>
      [{ name: "chef_package", version: "0.0.1", dependencies: [] }],
      "chef_ruby" =>
      [{ name: "chef_ruby",
         version: "2.2.1",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "chef_ruby",
         version: "2.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "chef_vault_pki" =>
      [{ name: "chef_vault_pki",
         version: "1.0.0",
         dependencies: [["sensu_spec", "~> 0.2"]] },
       { name: "chef_vault_pki",
         version: "0.1.6",
         dependencies: [["sensu_spec", "~> 0.2"]] }],
      "chgems" =>
      [{ name: "chgems", version: "1.0.2", dependencies: [["ark", ">= 0.0.0"]] },
       { name: "chgems", version: "1.0.0", dependencies: [["ark", ">= 0.0.0"]] }],
      "chocolatey" =>
      [{ name: "chocolatey",
         version: "0.1.0",
         dependencies: [["powershell", ">= 0.0.0"]] },
       { name: "chocolatey",
         version: "0.0.5",
         dependencies: [["powershell", ">= 0.0.0"]] },
       { name: "chocolatey",
         version: "0.0.4",
         dependencies: [["powershell", ">= 0.0.0"]] },
       { name: "chocolatey",
         version: "0.0.2",
         dependencies: [["powershell", ">= 0.0.0"]] },
       { name: "chocolatey",
         version: "0.0.1",
         dependencies: [["powershell", ">= 0.0.0"]] }],
      "chocolatey-installer" =>
      [{ name: "chocolatey-installer",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"], ["chocolatey", ">= 0.0.0"]] }],
      "chromium" => [{ name: "chromium", version: "0.0.1", dependencies: [] }],
      "chronos" =>
      [{ name: "chronos",
         version: "1.0.1",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["mesos", ">= 0.0.0"]] },
       { name: "chronos",
         version: "1.0.0",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["mesos", ">= 0.0.0"]] }],
      "chrony" => [{ name: "chrony", version: "0.1.0", dependencies: [] }],
      "chruby" =>
      [{ name: "chruby",
         version: "0.2.2",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] },
       { name: "chruby",
         version: "0.2.1",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] },
       { name: "chruby",
         version: "0.2.0",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] },
       { name: "chruby",
         version: "0.1.5",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] },
       { name: "chruby",
         version: "0.1.4",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] },
       { name: "chruby",
         version: "0.1.3",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] },
       { name: "chruby",
         version: "0.1.2",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] },
       { name: "chruby",
         version: "0.1.1",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] },
       { name: "chruby",
         version: "0.1.0",
         dependencies: [["ark", ">= 0.0.0"], ["ruby_build", ">= 0.0.0"]] }],
      "chruby-build" =>
      [{ name: "chruby-build",
         version: "0.1.1",
         dependencies: [["apt", ">= 2.3.0"], ["ark", ">= 0.6.0"]] },
       { name: "chruby-build",
         version: "0.1.0",
         dependencies: [["apt", ">= 2.3.0"], ["ark", ">= 0.6.0"]] }],
      "chruby_install" =>
      [{ name: "chruby_install",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "chz-firewall" =>
      [{ name: "chz-firewall",
         version: "0.2.1",
         dependencies: [["powershell", ">= 0.0.0"]] },
       { name: "chz-firewall",
         version: "0.1.2",
         dependencies: [["powershell", ">= 0.0.0"]] },
       { name: "chz-firewall",
         version: "0.1.1",
         dependencies: [["powershell", ">= 0.0.0"]] },
       { name: "chz-firewall",
         version: "0.1.0",
         dependencies: [["powershell", ">= 0.0.0"]] }],
      "circonus" =>
      [{ name: "circonus", version: "0.0.11", dependencies: [] },
       { name: "circonus", version: "0.0.10", dependencies: [] },
       { name: "circonus", version: "0.0.9", dependencies: [] },
       { name: "circonus", version: "0.0.8", dependencies: [] },
       { name: "circonus", version: "0.0.7", dependencies: [] },
       { name: "circonus", version: "0.0.6", dependencies: [] },
       { name: "circonus", version: "0.0.5", dependencies: [] },
       { name: "circonus", version: "0.0.4", dependencies: [] },
       { name: "circonus", version: "0.0.3", dependencies: [] },
       { name: "circonus", version: "0.0.2", dependencies: [] }],
      "cis_benchmark" =>
      [{ name: "cis_benchmark", version: "0.0.1", dependencies: [] }],
      "ckbk" =>
      [{ name: "ckbk", version: "0.2.4", dependencies: [] },
       { name: "ckbk", version: "0.2.3", dependencies: [] },
       { name: "ckbk", version: "0.2.2", dependencies: [] },
       { name: "ckbk", version: "0.2.1", dependencies: [] },
       { name: "ckbk", version: "0.2.0", dependencies: [] },
       { name: "ckbk", version: "0.1.1", dependencies: [] },
       { name: "ckbk", version: "0.1.0", dependencies: [] },
       { name: "ckbk", version: "0.0.2", dependencies: [] },
       { name: "ckbk", version: "0.0.1", dependencies: [] }],
      "clamav" =>
      [{ name: "clamav",
         version: "1.0.2",
         dependencies: [["logrotate", "~> 1.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", "~> 0.2"],
          ["apt", "~> 2.1"],
          ["cron", "~> 1.2"]] },
       { name: "clamav",
         version: "1.0.0",
         dependencies: [["logrotate", "~> 1.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", "~> 0.2"],
          ["apt", "~> 2.1"],
          ["cron", "~> 1.2"]] },
       { name: "clamav",
         version: "0.4.1",
         dependencies: [["logrotate", "~> 1.0"], ["yum", "~> 2.1"], ["apt", "~> 2.1"]] },
       { name: "clamav",
         version: "0.4.0",
         dependencies: [["logrotate", "~> 1.0"], ["yum", "~> 2.1"], ["apt", "~> 1.8"]] },
       { name: "clamav",
         version: "0.2.0",
         dependencies: [["logrotate", "= 1.0.2"], ["yum", "= 2.1.0"], ["apt", "= 1.8.0"]] }],
      "clonezillalive" =>
      [{ name: "clonezillalive",
         version: "0.1.4",
         dependencies: [["nfs", ">= 0.0.0"], ["pxe", ">= 0.0.0"]] },
       { name: "clonezillalive",
         version: "0.1.3",
         dependencies: [["nfs", ">= 0.0.0"], ["pxe", ">= 0.0.0"]] },
       { name: "clonezillalive",
         version: "0.1.1",
         dependencies: [["tftp", ">= 0.0.0"], ["nfs", ">= 0.0.0"]] },
       { name: "clonezillalive",
         version: "0.1.0",
         dependencies: [["tftp", ">= 0.0.0"], ["nfs", ">= 0.0.0"]] }],
      "cloudflare" =>
      [{ name: "cloudflare", version: "0.1.3", dependencies: [] },
       { name: "cloudflare", version: "0.1.2", dependencies: [] },
       { name: "cloudflare", version: "0.1.1", dependencies: [] },
       { name: "cloudflare", version: "0.1.0", dependencies: [] }],
      "cloudformation" =>
      [{ name: "cloudformation",
         version: "0.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"],
          ["xml", "~> 1.1.0"]] }],
      "cloudfoundry" =>
      [{ name: "cloudfoundry",
         version: "1.3.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.3.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.3.1",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.3.0",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.1.2",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.0.4",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.0.3",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.0.2",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.0.1",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] }],
      "cloudfoundry-cloud_controller" =>
      [{ name: "cloudfoundry-cloud_controller",
         version: "1.4.0",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.3.7",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.3.6",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.3.5",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.3.4",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.3.3",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.3.2",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.3.1",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.3.0",
         dependencies: [["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.2.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.2.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.1.3",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.1.2",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.1.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.1.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry-nginx", "~> 1.0.2"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.0.2",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-cloud_controller",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] }],
      "cloudfoundry-dea" =>
      [{ name: "cloudfoundry-dea",
         version: "1.1.5",
         dependencies: [["cloudfoundry", "~> 1.3.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-dea",
         version: "1.1.4",
         dependencies: [["cloudfoundry", "~> 1.3.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-dea",
         version: "1.1.3",
         dependencies: [["cloudfoundry", "~> 1.3.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-dea",
         version: "1.1.2",
         dependencies: [["cloudfoundry", "~> 1.3.0"]] },
       { name: "cloudfoundry-dea",
         version: "1.1.1",
         dependencies: [["cloudfoundry", "~> 1.1.2"]] },
       { name: "cloudfoundry-dea",
         version: "1.1.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"]] },
       { name: "cloudfoundry-dea",
         version: "1.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"]] },
       { name: "cloudfoundry-dea",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"]] }],
      "cloudfoundry-filesystem-service" =>
      [{ name: "cloudfoundry-filesystem-service",
         version: "1.0.3",
         dependencies: [["cloudfoundry_service", "~> 1.2.2"]] },
       { name: "cloudfoundry-filesystem-service",
         version: "1.0.2",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["cloudfoundry_service", "~> 1.2.0"]] },
       { name: "cloudfoundry-filesystem-service",
         version: "1.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["cloudfoundry_service", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-filesystem-service",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["cloudfoundry_service", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-filesystem-service",
         version: "0.99.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["cloudfoundry_service", ">= 0.0.0"]] }],
      "cloudfoundry-health_manager" =>
      [{ name: "cloudfoundry-health_manager",
         version: "2.0.0",
         dependencies: [["cloudfoundry", "~> 1.3.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-health_manager",
         version: "1.0.2",
         dependencies: [["cloudfoundry", "~> 1.3.0"],
          ["cloudfoundry-cloud_controller", "~> 1.3.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-health_manager",
         version: "1.0.1",
         dependencies: [["cloudfoundry", "~> 1.2.0"],
          ["cloudfoundry-cloud_controller", "~> 1.3.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-health_manager",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["cloudfoundry-cloud_controller", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] }],
      "cloudfoundry-mongodb-service" =>
      [{ name: "cloudfoundry-mongodb-service",
         version: "1.1.1",
         dependencies: [["cloudfoundry", "~> 1.3.1"],
          ["cloudfoundry_service", "~> 1.2.2"],
          ["mongodb", ">= 0.0.0"]] },
       { name: "cloudfoundry-mongodb-service",
         version: "1.1.0",
         dependencies: [["cloudfoundry", "~> 1.3.1"],
          ["cloudfoundry_service", "~> 1.2.2"],
          ["mongodb", ">= 0.0.0"]] },
       { name: "cloudfoundry-mongodb-service",
         version: "1.0.4",
         dependencies: [["cloudfoundry_service", "~> 1.2.2"], ["mongodb", ">= 0.0.0"]] },
       { name: "cloudfoundry-mongodb-service",
         version: "1.0.3",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"],
          ["cloudfoundry_service", "~> 1.2.0"]] },
       { name: "cloudfoundry-mongodb-service",
         version: "1.0.2",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"],
          ["cloudfoundry_service", "~> 1.1.4"]] },
       { name: "cloudfoundry-mongodb-service",
         version: "1.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["cloudfoundry_service", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-mongodb-service",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["cloudfoundry_service", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] }],
      "cloudfoundry-nginx" =>
      [{ name: "cloudfoundry-nginx",
         version: "1.0.4",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] },
       { name: "cloudfoundry-nginx",
         version: "1.0.3",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] },
       { name: "cloudfoundry-nginx",
         version: "1.0.2",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] },
       { name: "cloudfoundry-nginx",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] }],
      "cloudfoundry-rabbitmq-service" =>
      [{ name: "cloudfoundry-rabbitmq-service",
         version: "1.1.2",
         dependencies: [["cloudfoundry_service", "~> 1.2.2"]] },
       { name: "cloudfoundry-rabbitmq-service",
         version: "1.1.1",
         dependencies: [["cloudfoundry", "~> 1.2.0"], ["cloudfoundry_service", "~> 1.2.1"]] },
       { name: "cloudfoundry-rabbitmq-service",
         version: "1.1.0",
         dependencies: [["cloudfoundry", "~> 1.1.1"], ["cloudfoundry_service", "~> 1.2.1"]] },
       { name: "cloudfoundry-rabbitmq-service",
         version: "1.0.2",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["cloudfoundry_service", "~> 1.2.0"]] },
       { name: "cloudfoundry-rabbitmq-service",
         version: "1.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["cloudfoundry_service", "~> 1.1.4"]] },
       { name: "cloudfoundry-rabbitmq-service",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["cloudfoundry_service", ">= 0.0.0"]] }],
      "cloudfoundry-router" =>
      [{ name: "cloudfoundry-router",
         version: "1.0.4",
         dependencies: [["cloudfoundry-nginx", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"]] },
       { name: "cloudfoundry-router",
         version: "1.0.3",
         dependencies: [["cloudfoundry-nginx", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"]] },
       { name: "cloudfoundry-router",
         version: "1.0.2",
         dependencies: [["cloudfoundry-nginx", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"]] },
       { name: "cloudfoundry-router",
         version: "1.0.1",
         dependencies: [["cloudfoundry-nginx", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"]] },
       { name: "cloudfoundry-router",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["cloudfoundry-nginx", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-router",
         version: "0.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["cloudfoundry-nginx", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] }],
      "cloudfoundry-ruby-runtime" =>
      [{ name: "cloudfoundry-ruby-runtime",
         version: "1.2.1",
         dependencies: [["cloudfoundry", "~> 1.3.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-ruby-runtime",
         version: "1.2.0",
         dependencies: [["cloudfoundry", "~> 1.3.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-ruby-runtime",
         version: "1.1.3",
         dependencies: [["cloudfoundry", "~> 1.2.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-ruby-runtime",
         version: "1.1.2",
         dependencies: [["cloudfoundry", "~> 1.1.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-ruby-runtime",
         version: "1.1.1",
         dependencies: [["cloudfoundry", "~> 1.0.4"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-ruby-runtime",
         version: "1.1.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-ruby-runtime",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] }],
      "cloudfoundry-service_broker" =>
      [{ name: "cloudfoundry-service_broker",
         version: "1.0.2",
         dependencies: [["cloudfoundry_service", "~> 1.2.2"]] },
       { name: "cloudfoundry-service_broker",
         version: "1.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["cloudfoundry_service", "~> 1.2.0"]] },
       { name: "cloudfoundry-service_broker",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["cloudfoundry_service", ">= 0.0.0"]] }],
      "cloudfoundry-stager" =>
      [{ name: "cloudfoundry-stager",
         version: "1.0.5",
         dependencies: [["cloudfoundry", "~> 1.3.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-stager",
         version: "1.0.4",
         dependencies: [["cloudfoundry", "~> 1.2.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-stager",
         version: "1.0.3",
         dependencies: [["cloudfoundry", "~> 1.1.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-stager",
         version: "1.0.2",
         dependencies: [["cloudfoundry", "~> 1.1.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-stager",
         version: "1.0.1",
         dependencies: [["cloudfoundry", "~> 1.1.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-stager",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry-stager",
         version: "0.99.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] }],
      "cloudfoundry_service" =>
      [{ name: "cloudfoundry_service",
         version: "1.2.3",
         dependencies: [["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"]] },
       { name: "cloudfoundry_service",
         version: "1.2.2",
         dependencies: [["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["cloudfoundry", "~> 1.3.0"]] },
       { name: "cloudfoundry_service",
         version: "1.2.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "1.2.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "1.1.4",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "1.1.3",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "1.1.2",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "1.1.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "1.1.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "1.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] },
       { name: "cloudfoundry_service",
         version: "0.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"]] }],
      "cloudkick" =>
      [{ name: "cloudkick",
         version: "1.3.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "cloudkick",
         version: "1.2.2",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "cloudkick",
         version: "1.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "cloudkick",
         version: "1.0.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "cloudkick",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "cloudkick",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "cloudkick",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "cloudpassage" =>
      [{ name: "cloudpassage", version: "0.0.6", dependencies: [] },
       { name: "cloudpassage", version: "0.0.5", dependencies: [] },
       { name: "cloudpassage", version: "0.0.4", dependencies: [] },
       { name: "cloudpassage", version: "0.0.3", dependencies: [] },
       { name: "cloudpassage", version: "0.0.2", dependencies: [] },
       { name: "cloudpassage", version: "0.0.1", dependencies: [] }],
      "cloudwatch-monitoring" =>
      [{ name: "cloudwatch-monitoring", version: "1.1.0", dependencies: [] }],
      "cloudwatch_monitoring" =>
      [{ name: "cloudwatch_monitoring",
         version: "1.2.0",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "cloudwatch_monitoring",
         version: "1.1.1",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "cloudwatch_monitoring", version: "1.0.1", dependencies: [] },
       { name: "cloudwatch_monitoring", version: "1.0.0", dependencies: [] }],
      "cloud_foundry" =>
      [{ name: "cloud_foundry", version: "0.0.2", dependencies: [] },
       { name: "cloud_foundry", version: "0.0.1", dependencies: [] }],
      "cloud_utils" => [{ name: "cloud_utils", version: "3.0.4", dependencies: [] }],
      "cmake" => [{ name: "cmake", version: "0.2.0", dependencies: [] }],
      "cmon" => [{ name: "cmon", version: "0.5.0", dependencies: [] }],
      "co-cloudmonkey" =>
      [{ name: "co-cloudmonkey",
         version: "0.3.0",
         dependencies: [["python", ">= 0.0.0"]] }],
      "co-cloudstack" =>
      [{ name: "co-cloudstack",
         version: "1.0.0",
         dependencies: [["co-nfs", ">= 0.0.0"], ["database", ">= 0.0.0"]] }],
      "co-nfs" => [{ name: "co-nfs", version: "0.2.0", dependencies: [] }],
      "cobbler" =>
      [{ name: "cobbler",
         version: "0.2.0",
         dependencies: [["runit", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "cobbler",
         version: "0.1.0",
         dependencies: [["runit", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "collectd" => [{ name: "collectd", version: "1.0.0", dependencies: [] }],
      "collectd_plugins" =>
      [{ name: "collectd_plugins",
         version: "1.0.0",
         dependencies: [["collectd", ">= 0.0.0"]] }],
      "colorize_output" =>
      [{ name: "colorize_output", version: "0.1.0", dependencies: [] }],
      "composer" =>
      [{ name: "composer", version: "0.0.7", dependencies: [] },
       { name: "composer", version: "0.0.6", dependencies: [] },
       { name: "composer",
         version: "0.0.5",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "composer",
         version: "0.0.4",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "composer",
         version: "0.0.3",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "composer",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "composer",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"]] }],
      "conf" => [{ name: "conf", version: "0.1.0", dependencies: [] }],
      "conffile" =>
      [{ name: "conffile",
         version: "0.4.0",
         dependencies: [["gem_specific_install", "~> 0.1.8"]] },
       { name: "conffile", version: "0.3.0", dependencies: [] },
       { name: "conffile",
         version: "0.2.2",
         dependencies: [["gem_specific_install", ">= 0.1.4"]] },
       { name: "conffile",
         version: "0.1.6",
         dependencies: [["gem_specific_install", ">= 0.1.4"]] },
       { name: "conffile",
         version: "0.1.4",
         dependencies: [["gem_specific_install", ">= 0.1.4"]] },
       { name: "conffile",
         version: "0.1.3",
         dependencies: [["gem_specific_install", ">= 0.1.4"]] },
       { name: "conffile",
         version: "0.1.2",
         dependencies: [["gem_specific_install", ">= 0.1.4"], ["run_action_now", ">= 0.0.0"]] },
       { name: "conffile",
         version: "0.1.1",
         dependencies: [["gem_specific_install", ">= 0.1.3"]] },
       { name: "conffile",
         version: "0.4.2",
         dependencies: [["gem_specific_install", "~> 0.2.0"]] }],
      "confluence" =>
      [{ name: "confluence",
         version: "0.0.2",
         dependencies: [["runit", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "confluence",
         version: "0.0.1",
         dependencies: [["runit", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "console" => [{ name: "console", version: "0.1.0", dependencies: [] }],
      "container" =>
      [{ name: "container",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "control_groups" =>
      [{ name: "control_groups", version: "0.1.6", dependencies: [] },
       { name: "control_groups", version: "0.1.4", dependencies: [] },
       { name: "control_groups", version: "0.1.2", dependencies: [] },
       { name: "control_groups", version: "0.1.0", dependencies: [] },
       { name: "control_groups", version: "0.0.1", dependencies: [] }],
      "cookbook_pusher" =>
      [{ name: "cookbook_pusher",
         version: "0.2.0",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "cookbook_pusher",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"]] }],
      "cookbook_versions_handler" =>
      [{ name: "cookbook_versions_handler",
         version: "1.0.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "copperegg" =>
      [{ name: "copperegg",
         version: "0.2.3",
         dependencies: [["chef_handler", "> 1.0.0"]] },
       { name: "copperegg", version: "0.2.1", dependencies: [] },
       { name: "copperegg", version: "0.1.9", dependencies: [] },
       { name: "copperegg", version: "0.1.8", dependencies: [] }],
      "couchbase" =>
      [{ name: "couchbase",
         version: "1.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "couchbase",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"], ["windows", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "couchdb" =>
      [{ name: "couchdb",
         version: "2.5.1",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "2.5.0",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "2.4.8",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", "< 3.0.0"]] },
       { name: "couchdb",
         version: "2.4.6",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", "< 3.0.0"]] },
       { name: "couchdb",
         version: "2.4.4",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "2.4.2",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "2.4.0",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "2.2.0",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "2.1.0",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "2.0.0",
         dependencies: [["erlang", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "1.0.4",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "1.0.2",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "1.0.0",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "0.14.1",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "0.14.0",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "0.13.3",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "couchdb",
         version: "0.12.0",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "couchdb", version: "0.8.0", dependencies: [] }],
      "couchpotato" => [{ name: "couchpotato", version: "0.0.1", dependencies: [] }],
      "cpan" =>
      [{ name: "cpan", version: "0.0.29", dependencies: [] },
       { name: "cpan", version: "0.0.28", dependencies: [] },
       { name: "cpan", version: "0.0.26", dependencies: [] },
       { name: "cpan", version: "0.0.25", dependencies: [] },
       { name: "cpan", version: "0.0.24", dependencies: [] },
       { name: "cpan", version: "0.0.23", dependencies: [] },
       { name: "cpan", version: "0.0.22", dependencies: [] },
       { name: "cpan", version: "0.0.21", dependencies: [] },
       { name: "cpan", version: "0.0.20", dependencies: [] },
       { name: "cpan", version: "0.0.19", dependencies: [] },
       { name: "cpan", version: "0.0.18", dependencies: [] },
       { name: "cpan", version: "0.0.17", dependencies: [] },
       { name: "cpan", version: "0.0.15", dependencies: [] },
       { name: "cpan", version: "0.0.14", dependencies: [] },
       { name: "cpan", version: "0.0.13", dependencies: [] },
       { name: "cpan", version: "0.0.12", dependencies: [] },
       { name: "cpan", version: "0.0.11", dependencies: [] },
       { name: "cpan", version: "0.0.10", dependencies: [] },
       { name: "cpan", version: "0.0.9", dependencies: [] },
       { name: "cpan", version: "0.0.8", dependencies: [] },
       { name: "cpan", version: "0.0.7", dependencies: [] },
       { name: "cpan", version: "0.0.6", dependencies: [] },
       { name: "cpan", version: "0.0.5", dependencies: [] },
       { name: "cpan", version: "0.0.4", dependencies: [] },
       { name: "cpan", version: "0.0.3", dependencies: [] }],
      "cpan-plus" =>
      [{ name: "cpan-plus", version: "0.0.4", dependencies: [] },
       { name: "cpan-plus", version: "0.0.3", dependencies: [] },
       { name: "cpan-plus", version: "0.0.2", dependencies: [] },
       { name: "cpan-plus", version: "0.0.1", dependencies: [] }],
      "cpanminus" =>
      [{ name: "cpanminus", version: "0.1.1", dependencies: [] },
       { name: "cpanminus", version: "0.1.0", dependencies: [] }],
      "cpu" =>
      [{ name: "cpu", version: "0.2.0", dependencies: [] },
       { name: "cpu", version: "0.1.0", dependencies: [] }],
      "cron" =>
      [{ name: "cron", version: "1.3.2", dependencies: [] },
       { name: "cron", version: "1.3.0", dependencies: [] },
       { name: "cron", version: "1.2.8", dependencies: [] },
       { name: "cron", version: "1.2.6", dependencies: [] },
       { name: "cron", version: "1.2.4", dependencies: [] },
       { name: "cron", version: "1.2.2", dependencies: [] },
       { name: "cron", version: "1.2.0", dependencies: [] },
       { name: "cron", version: "1.0.4", dependencies: [] },
       { name: "cron", version: "1.0.2", dependencies: [] },
       { name: "cron", version: "1.0.0", dependencies: [] },
       { name: "cron", version: "0.0.1", dependencies: [] }],
      "crontab" => [{ name: "crontab", version: "0.0.1", dependencies: [] }],
      "crowd" =>
      [{ name: "crowd",
         version: "0.0.1",
         dependencies: [["runit", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "crypto-coin" =>
      [{ name: "crypto-coin",
         version: "0.2.2",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "crypto-coin",
         version: "0.2.1",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "crypto-coin",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "ctfhooks" =>
      [{ name: "ctfhooks",
         version: "0.1.0",
         dependencies: [["sudo", ">= 0.0.0"], ["users", ">= 0.0.0"]] }],
      "cube" =>
      [{ name: "cube",
         version: "0.4.0",
         dependencies: [["mongodb", ">= 0.0.0"], ["nodejs", ">= 0.0.0"], ["ufw", ">= 0.0.0"]] },
       { name: "cube",
         version: "0.3.0",
         dependencies: [["nodejs", ">= 0.0.0"], ["ufw", ">= 0.0.0"]] },
       { name: "cube",
         version: "0.2.6",
         dependencies: [["nodejs", ">= 0.0.0"], ["ufw", ">= 0.0.0"]] },
       { name: "cube",
         version: "0.2.0",
         dependencies: [["nodejs", ">= 0.0.0"], ["ufw", ">= 0.0.0"]] },
       { name: "cube",
         version: "0.1.0",
         dependencies: [["nodejs", ">= 0.0.0"], ["ufw", ">= 0.0.0"]] }],
      "curl" => [{ name: "curl", version: "1.1.0", dependencies: [] }],
      "cutlery" =>
      [{ name: "cutlery",
         version: "0.2.6",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "cutlery", version: "0.2.2", dependencies: [] },
       { name: "cutlery", version: "0.1.0", dependencies: [] }],
      "daemontools" =>
      [{ name: "daemontools",
         version: "1.2.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "daemontools",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "daemontools",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "daemontools",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "daemontools",
         version: "0.9.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["ucspi-tcp", ">= 0.0.0"]] }],
      "dashing" => [{ name: "dashing", version: "0.1.0", dependencies: [] }],
      "data-bag-merge" =>
      [{ name: "data-bag-merge", version: "0.1.2", dependencies: [] },
       { name: "data-bag-merge", version: "0.1.1", dependencies: [] },
       { name: "data-bag-merge", version: "0.1.0", dependencies: [] }],
      "database" =>
      [{ name: "database",
         version: "2.1.0",
         dependencies: [["mysql", ">= 5.0.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "2.0.0",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.6.0",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.5.2",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.5.0",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.4.0",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.3.12",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.3.10",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.3.8",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.3.6",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.3.4",
         dependencies: [["mysql", ">= 1.3.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.3.2",
         dependencies: [["mysql", ">= 1.2.0"],
          ["postgresql", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.2.0",
         dependencies: [["mysql", ">= 1.2.0"],
          ["postgresql", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.1.4",
         dependencies: [["mysql", ">= 1.2.0"],
          ["postgresql", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.1.2",
         dependencies: [["mysql", ">= 1.2.0"],
          ["postgresql", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.1.0",
         dependencies: [["mysql", ">= 1.2.0"],
          ["postgresql", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "1.0.0",
         dependencies: [["mysql", ">= 1.2.0"], ["aws", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "0.99.1",
         dependencies: [["mysql", ">= 0.0.0"], ["aws", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "0.99.0",
         dependencies: [["mysql", ">= 0.0.0"], ["aws", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "0.7.1",
         dependencies: [["mysql", ">= 0.0.0"], ["aws", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "0.7.0",
         dependencies: [["mysql", ">= 0.0.0"], ["aws", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] },
       { name: "database",
         version: "0.6.0",
         dependencies: [["mysql", ">= 0.0.0"], ["xfs", ">= 0.0.0"], ["aws", ">= 0.0.0"]] },
       { name: "database",
         version: "2.1.2",
         dependencies: [["mysql", ">= 5.0.0"],
          ["postgresql", ">= 1.0.0"],
          ["aws", ">= 0.0.0"],
          ["xfs", ">= 0.0.0"],
          ["mysql-chef_gem", ">= 0.0.0"]] }],
      "databox" =>
      [{ name: "databox",
         version: "0.1.1",
         dependencies: [["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "databox",
         version: "0.1.0",
         dependencies: [["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] }],
      "datadog" =>
      [{ name: "datadog",
         version: "1.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", "~> 1.1.0"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "1.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", "~> 1.1.0"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "1.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", "~> 1.1.0"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "1.0.1",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", "~> 1.1.0"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", "~> 1.1.0"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.1.4",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", "~> 1.0.6"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", "~> 1.0.6"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", ">= 1.0.6"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", ">= 1.0.6"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.12",
         dependencies: [["apt", ">= 0.0.0"], ["chef_handler", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.11",
         dependencies: [["chef_handler", ">= 0.0.0"], ["yum", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.10",
         dependencies: [["chef_handler", ">= 0.0.0"], ["yum", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.9",
         dependencies: [["chef_handler", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.8",
         dependencies: [["chef_handler", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.1.0",
         dependencies: [["chef_handler", ">= 0.0.0"], ["yum", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.4",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"], ["chef_handler", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.3",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"], ["chef_handler", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.2",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"], ["chef_handler", ">= 0.0.0"]] },
       { name: "datadog",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["chef_handler", ">= 0.0.0"]] }],
      "dbench" =>
      [{ name: "dbench",
         version: "1.0.4",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "dbench",
         version: "1.0.3",
         dependencies: [["git", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "dbench",
         version: "1.0.2",
         dependencies: [["git", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "dbench",
         version: "1.0.1",
         dependencies: [["git", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "dbench",
         version: "0.0.7",
         dependencies: [["git", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "dbench",
         version: "0.0.6",
         dependencies: [["git", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "dbench",
         version: "0.0.4",
         dependencies: [["git", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "dbench",
         version: "0.0.2",
         dependencies: [["git", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "ddclient" =>
      [{ name: "ddclient", version: "1.1.0", dependencies: [] },
       { name: "ddclient", version: "1.0.0", dependencies: [] }],
      "debian" =>
      [{ name: "debian", version: "1.5.4", dependencies: [["apt", ">= 1.6.0"]] },
       { name: "debian", version: "1.5.2", dependencies: [["apt", ">= 1.6.0"]] },
       { name: "debian", version: "1.5.0", dependencies: [["apt", ">= 1.6.0"]] },
       { name: "debian", version: "1.4.0", dependencies: [["apt", ">= 1.6.0"]] },
       { name: "debian", version: "0.0.2", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "debian", version: "0.0.1", dependencies: [["apt", ">= 0.0.0"]] }],
      "deb_pkg_unautostart" =>
      [{ name: "deb_pkg_unautostart", version: "0.1.0", dependencies: [] }],
      "deis" =>
      [{ name: "deis",
         version: "0.6.0",
         dependencies: [["apt", ">= 2.3.8"],
          ["docker", ">= 0.31.0"],
          ["sudo", ">= 2.3.0"],
          ["rsyslog", ">= 1.10.2"]] },
       { name: "deis",
         version: "0.5.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["rsyslog", ">= 0.0.0"]] },
       { name: "deis",
         version: "0.5.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["rsyslog", ">= 0.0.0"]] },
       { name: "deis",
         version: "0.5.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["rsyslog", ">= 0.0.0"]] },
       { name: "deis",
         version: "0.4.1",
         dependencies: [["apt", ">= 2.3.0"], ["sudo", ">= 2.2.2"], ["rsyslog", ">= 1.9.0"]] },
       { name: "deis",
         version: "0.4.0",
         dependencies: [["apt", ">= 2.1.2"], ["sudo", ">= 2.2.0"], ["rsyslog", ">= 1.8.0"]] },
       { name: "deis",
         version: "0.3.1",
         dependencies: [["apt", ">= 2.1.2"], ["sudo", ">= 2.2.0"], ["rsyslog", ">= 1.8.0"]] },
       { name: "deis",
         version: "0.3.0",
         dependencies: [["apt", ">= 2.1.2"], ["sudo", ">= 2.2.0"], ["rsyslog", ">= 1.8.0"]] },
       { name: "deis",
         version: "0.2.1",
         dependencies: [["apt", ">= 2.1.2"], ["sudo", ">= 2.2.0"], ["rsyslog", ">= 1.8.0"]] },
       { name: "deis",
         version: "0.2.0",
         dependencies: [["apt", ">= 2.1.2"], ["sudo", ">= 2.2.0"], ["rsyslog", ">= 1.8.0"]] },
       { name: "deis",
         version: "0.1.1",
         dependencies: [["apt", ">= 2.1.2"], ["sudo", ">= 2.2.0"], ["rsyslog", ">= 1.8.0"]] },
       { name: "deis",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["sudo", ">= 0.0.0"], ["rsyslog", ">= 0.0.0"]] },
       { name: "deis",
         version: "0.0.7",
         dependencies: [["apt", ">= 0.0.0"], ["sudo", ">= 0.0.0"], ["rsyslog", ">= 0.0.0"]] },
       { name: "deis",
         version: "0.0.6",
         dependencies: [["apt", ">= 0.0.0"], ["sudo", ">= 0.0.0"], ["rsyslog", ">= 0.0.0"]] },
       { name: "deis",
         version: "0.0.5",
         dependencies: [["apt", ">= 0.0.0"], ["sudo", ">= 0.0.0"]] }],
      "delayed_evaluator" =>
      [{ name: "delayed_evaluator", version: "0.2.0", dependencies: [] },
       { name: "delayed_evaluator", version: "0.1.0", dependencies: [] }],
      "denyhosts" => [{ name: "denyhosts", version: "0.1.0", dependencies: [] }],
      "deploy-play" =>
      [{ name: "deploy-play",
         version: "1.0.0",
         dependencies: [["java", ">= 1.6.0"]] },
       { name: "deploy-play",
         version: "0.1.0",
         dependencies: [["java", ">= 1.6.0"]] }],
      "deployer" =>
      [{ name: "deployer",
         version: "0.1.1",
         dependencies: [["sudo", ">= 0.0.0"]] },
       { name: "deployer",
         version: "0.1.0",
         dependencies: [["sudo", ">= 0.0.0"]] }],
      "deploy_key" =>
      [{ name: "deploy_key", version: "0.1.1", dependencies: [] },
       { name: "deploy_key", version: "0.1.0", dependencies: [] },
       { name: "deploy_key", version: "0.0.4", dependencies: [] },
       { name: "deploy_key", version: "0.0.3", dependencies: [] },
       { name: "deploy_key", version: "0.0.2", dependencies: [] },
       { name: "deploy_key", version: "0.0.1", dependencies: [] }],
      "deploy_s3" =>
      [{ name: "deploy_s3",
         version: "1.5.0",
         dependencies: [["hipsnip-s3cmd", ">= 0.0.0"]] },
       { name: "deploy_s3",
         version: "1.4.0",
         dependencies: [["hipsnip-s3cmd", ">= 0.0.0"]] },
       { name: "deploy_s3",
         version: "1.3.0",
         dependencies: [["hipsnip-s3cmd", ">= 0.0.0"]] }],
      "deploy_wrapper" =>
      [{ name: "deploy_wrapper", version: "0.2.0", dependencies: [] },
       { name: "deploy_wrapper", version: "0.1.0", dependencies: [] },
       { name: "deploy_wrapper", version: "0.0.3", dependencies: [] },
       { name: "deploy_wrapper", version: "0.0.2", dependencies: [] },
       { name: "deploy_wrapper", version: "0.0.1", dependencies: [] }],
      "desktop" =>
      [{ name: "desktop", version: "0.1.1", dependencies: [] },
       { name: "desktop", version: "0.1.0", dependencies: [] }],
      "development_app" =>
      [{ name: "development_app", version: "0.1.0", dependencies: [] }],
      "device-mapper" =>
      [{ name: "device-mapper",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["modules", ">= 0.0.0"]] }],
      "devstack" =>
      [{ name: "devstack",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"]] }],
      "dhcp" =>
      [{ name: "dhcp",
         version: "2.2.1",
         dependencies: [["ruby-helper", ">= 0.0.0"], ["helpers-databags", ">= 0.0.0"]] },
       { name: "dhcp",
         version: "2.1.3",
         dependencies: [["ruby-helper", ">= 0.0.0"], ["helpers-databags", ">= 0.0.0"]] },
       { name: "dhcp",
         version: "2.1.2",
         dependencies: [["ruby-helper", ">= 0.0.0"], ["helpers-databags", ">= 0.0.0"]] },
       { name: "dhcp",
         version: "2.0.1",
         dependencies: [["ruby-helper", ">= 0.0.0"], ["helpers-databags", ">= 0.0.0"]] },
       { name: "dhcp",
         version: "2.0.0",
         dependencies: [["ruby-helper", ">= 0.0.0"], ["helpers-databags", ">= 0.0.0"]] }],
      "dhcpd" =>
      [{ name: "dhcpd", version: "0.1.2", dependencies: [] },
       { name: "dhcpd", version: "0.1.1", dependencies: [] },
       { name: "dhcpd", version: "0.1.0", dependencies: [] }],
      "dhcpdump" =>
      [{ name: "dhcpdump", version: "0.1.3", dependencies: [] },
       { name: "dhcpdump", version: "0.1.1", dependencies: [] },
       { name: "dhcpdump", version: "0.1.0", dependencies: [] }],
      "diamond" => [{ name: "diamond", version: "0.0.1", dependencies: [] }],
      "diamond_lwrp" =>
      [{ name: "diamond_lwrp",
         version: "0.1.3",
         dependencies: [["python", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "diamond_lwrp",
         version: "0.1.2",
         dependencies: [["python", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "diamond_lwrp",
         version: "0.1.0",
         dependencies: [["python", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] }],
      "diaspora" =>
      [{ name: "diaspora",
         version: "0.1.0",
         dependencies: [["xml", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["imagemagick", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] }],
      "diptables" =>
      [{ name: "diptables", version: "0.1.4", dependencies: [] },
       { name: "diptables", version: "0.1.3", dependencies: [] },
       { name: "diptables", version: "0.1.2", dependencies: [] },
       { name: "diptables", version: "0.1.1", dependencies: [] },
       { name: "diptables", version: "0.1.0", dependencies: [] }],
      "disco" =>
      [{ name: "disco",
         version: "0.1.2",
         dependencies: [["python", ">= 1.0.6"],
          ["simple_iptables", ">= 0.1.0"],
          ["build-essential", ">= 1.0.0"]] },
       { name: "disco",
         version: "0.1.1",
         dependencies: [["python", ">= 1.0.6"],
          ["simple_iptables", ">= 0.1.0"],
          ["build-essential", ">= 1.0.0"]] },
       { name: "disco",
         version: "0.1.0",
         dependencies: [["python", ">= 1.0.6"], ["simple_iptables", ">= 0.1.0"]] }],
      "discovery" =>
      [{ name: "discovery", version: "0.2.2", dependencies: [] },
       { name: "discovery", version: "0.2.0", dependencies: [] },
       { name: "discovery", version: "0.1.9", dependencies: [] },
       { name: "discovery", version: "0.1.7", dependencies: [] },
       { name: "discovery", version: "0.1.6", dependencies: [] },
       { name: "discovery", version: "0.1.5", dependencies: [] },
       { name: "discovery", version: "0.1.4", dependencies: [] },
       { name: "discovery", version: "0.1.3", dependencies: [] },
       { name: "discovery", version: "0.1.1", dependencies: [] },
       { name: "discovery", version: "0.1.0", dependencies: [] },
       { name: "discovery", version: "0.0.7", dependencies: [] },
       { name: "discovery", version: "0.0.6", dependencies: [] },
       { name: "discovery", version: "0.0.5", dependencies: [] },
       { name: "discovery", version: "0.0.4", dependencies: [] },
       { name: "discovery", version: "0.0.3", dependencies: [] },
       { name: "discovery", version: "0.0.2", dependencies: [] }],
      "distcc" => [{ name: "distcc", version: "0.1.0", dependencies: [] }],
      "django" =>
      [{ name: "django",
         version: "0.8.0",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "django",
         version: "0.7.0",
         dependencies: [["python", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "djbdns" =>
      [{ name: "djbdns",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ucspi-tcp", ">= 0.0.0"],
          ["runit", "<= 0.16.2"]] },
       { name: "djbdns",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "djbdns",
         version: "0.99.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "djbdns",
         version: "0.99.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "djbdns",
         version: "0.99.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "djbdns",
         version: "0.9.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "djbdns",
         version: "0.99.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["daemontools", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["ucspi-tcp", ">= 0.0.0"]] },
       { name: "djbdns",
         version: "0.8.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "djbdns",
         version: "0.8.2",
         dependencies: [["runit", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "djbdns",
         version: "0.7.0",
         dependencies: [["runit", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "dns" =>
      [{ name: "dns",
         version: "0.1.2",
         dependencies: [["hosts_file", "~> 0.1.4"], ["build-essential", ">= 1.1.0"]] },
       { name: "dns",
         version: "0.1.0",
         dependencies: [["hosts_file", "~> 0.1.4"], ["build-essential", ">= 1.1.0"]] },
       { name: "dns",
         version: "0.0.4",
         dependencies: [["hosts_file", "~> 0.1.2"], ["build-essential", ">= 1.1.0"]] },
       { name: "dns",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 1.1.0"]] }],
      "dnsimple" =>
      [{ name: "dnsimple",
         version: "1.0.0",
         dependencies: [["build-essential", "~> 1.4.2"]] },
       { name: "dnsimple",
         version: "0.9.0",
         dependencies: [["build-essential", "~> 1.4.2"]] },
       { name: "dnsimple", version: "0.5.0", dependencies: [] },
       { name: "dnsimple", version: "0.4.0", dependencies: [] },
       { name: "dnsimple", version: "0.3.2", dependencies: [] },
       { name: "dnsimple", version: "0.3.1", dependencies: [] },
       { name: "dnsimple", version: "0.3.0", dependencies: [] },
       { name: "dnsimple", version: "0.2.0", dependencies: [] },
       { name: "dnsimple", version: "0.1.1", dependencies: [] },
       { name: "dnsimple", version: "0.1.0", dependencies: [] }],
      "dnsmasq" =>
      [{ name: "dnsmasq",
         version: "0.2.0",
         dependencies: [["hosts_file", ">= 0.0.0"]] },
       { name: "dnsmasq",
         version: "0.1.4",
         dependencies: [["hosts_file", ">= 0.0.0"]] },
       { name: "dnsmasq",
         version: "0.1.2",
         dependencies: [["hosts_file", ">= 0.0.0"]] },
       { name: "dnsmasq",
         version: "0.1.0",
         dependencies: [["hosts_file", ">= 0.0.0"]] },
       { name: "dnsmasq",
         version: "0.0.2",
         dependencies: [["hosts_file", ">= 0.0.0"]] },
       { name: "dnsmasq",
         version: "0.0.1",
         dependencies: [["hosts_file", ">= 0.0.0"]] }],
      "docker" =>
      [{ name: "docker",
         version: "0.33.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["aufs", ">= 0.1.1"],
          ["device-mapper", ">= 0.1.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.32.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.32.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.32.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.31.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.30.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.30.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.30.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.29.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.28.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.27.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.27.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.26.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.25.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.25.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.24.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.24.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 1.1.6"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.24.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.23.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.23.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.22.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.21.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.20.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.19.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.19.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.18.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.18.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.17.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.16.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.15.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.14.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.13.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.12.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.11.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.10.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.10.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.9.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.9.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.8.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.8.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.7.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.6.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.6.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.6.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.5.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.4.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] },
       { name: "docker",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["golang", ">= 0.0.0"],
          ["lxc", ">= 0.0.0"],
          ["modules", ">= 0.0.0"]] }],
      "docker-registry" =>
      [{ name: "docker-registry",
         version: "0.0.3",
         dependencies: [["application_nginx", ">= 0.0.0"],
          ["application_python", ">= 0.0.0"],
          ["application", ">= 3.0.0"]] }],
      "dokku" =>
      [{ name: "dokku",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["docker", ">= 0.0.0"],
          ["user", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"]] },
       { name: "dokku", version: "0.0.1", dependencies: [] }],
      "domain" => [{ name: "domain", version: "0.1.0", dependencies: [] }],
      "doozer" =>
      [{ name: "doozer",
         version: "0.1.0",
         dependencies: [["golang", ">= 0.0.0"], ["git", ">= 0.0.0"], ["mercurial", ">= 0.0.0"]] },
       { name: "doozer",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["golang", ">= 0.0.0"]] }],
      "dotdeb" =>
      [{ name: "dotdeb", version: "0.1.1", dependencies: [] },
       { name: "dotdeb", version: "0.1.0", dependencies: [] }],
      "dotdeb_repo" =>
      [{ name: "dotdeb_repo",
         version: "1.0.2",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "dovecot" =>
      [{ name: "dovecot",
         version: "0.3.1",
         dependencies: [["ohai", ">= 0.0.0"]] },
       { name: "dovecot",
         version: "0.3.0",
         dependencies: [["ohai", ">= 0.0.0"]] },
       { name: "dovecot", version: "0.2.0", dependencies: [] },
       { name: "dovecot", version: "0.1.1", dependencies: [] },
       { name: "dovecot", version: "0.1.0", dependencies: [] }],
      "downtime" => [{ name: "downtime", version: "1.0.0", dependencies: [] }],
      "dpkg_autostart" =>
      [{ name: "dpkg_autostart", version: "0.1.10", dependencies: [] },
       { name: "dpkg_autostart", version: "0.1.8", dependencies: [] },
       { name: "dpkg_autostart", version: "0.1.6", dependencies: [] },
       { name: "dpkg_autostart", version: "0.1.5", dependencies: [] },
       { name: "dpkg_autostart", version: "0.1.2", dependencies: [] },
       { name: "dpkg_autostart", version: "0.1.0", dependencies: [] }],
      "dpkg_packages" =>
      [{ name: "dpkg_packages", version: "0.1.3", dependencies: [] },
       { name: "dpkg_packages", version: "0.1.2", dependencies: [] },
       { name: "dpkg_packages", version: "0.1.1", dependencies: [] },
       { name: "dpkg_packages", version: "0.1.0", dependencies: [] }],
      "drbd" =>
      [{ name: "drbd", version: "0.8.2", dependencies: [] },
       { name: "drbd", version: "0.8.0", dependencies: [] },
       { name: "drbd", version: "0.7.1", dependencies: [["lvm", ">= 0.0.0"]] },
       { name: "drbd", version: "0.7.0", dependencies: [["lvm", ">= 0.0.0"]] }],
      "dreadnot" =>
      [{ name: "dreadnot",
         version: "0.1.0",
         dependencies: [["nodejs", ">= 0.0.0"], ["smf", ">= 0.0.0"]] }],
      "drone" =>
      [{ name: "drone",
         version: "0.1.0",
         dependencies: [["docker", ">= 0.0.0"]] }],
      "dropbox" => [{ name: "dropbox", version: "0.0.1", dependencies: [] }],
      "dropwizard" =>
      [{ name: "dropwizard",
         version: "1.0.2",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "dropwizard",
         version: "1.0.1",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "dropwizard",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "dropwizard",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "drupal" =>
      [{ name: "drupal",
         version: "1.1.0",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "drupal",
         version: "1.0.0",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "drupal",
         version: "0.2.0",
         dependencies: [["mysql", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "drupal-windows" =>
      [{ name: "drupal-windows",
         version: "0.1.18",
         dependencies: [["windows", ">= 0.0.0"],
          ["vcruntime", ">= 0.0.0"],
          ["php-windows", ">= 0.0.0"],
          ["apache2-windows", ">= 0.0.0"]] }],
      "drush" => [{ name: "drush", version: "0.9.0", dependencies: [] }],
      "dry-run" =>
      [{ name: "dry-run", version: "0.0.3", dependencies: [] },
       { name: "dry-run", version: "0.0.2", dependencies: [] },
       { name: "dry-run", version: "0.0.1", dependencies: [] }],
      "dry-run-lies" =>
      [{ name: "dry-run-lies",
         version: "0.1.1",
         dependencies: [["nfs", ">= 0.0.0"]] }],
      "dspam" =>
      [{ name: "dspam", version: "0.1.2", dependencies: [] },
       { name: "dspam", version: "0.1.0", dependencies: [] }],
      "dtach" => [{ name: "dtach", version: "1.0.0", dependencies: [] }],
      "duo-unix" =>
      [{ name: "duo-unix",
         version: "0.1.0",
         dependencies: [["chef-vault", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"]] }],
      "duplicity" => [{ name: "duplicity", version: "0.0.1", dependencies: [] }],
      "dusk" =>
      [{ name: "dusk", version: "0.0.1", dependencies: [["runit", "~> 1.1.0"]] }],
      "dynomite" =>
      [{ name: "dynomite",
         version: "0.2.2",
         dependencies: [["runit", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"]] },
       { name: "dynomite",
         version: "0.1.0",
         dependencies: [["runit", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"]] }],
      "eaccelerator" =>
      [{ name: "eaccelerator", version: "0.1.1", dependencies: [] },
       { name: "eaccelerator", version: "0.1.0", dependencies: [] }],
      "easy-iptables" =>
      [{ name: "easy-iptables", version: "0.1.0", dependencies: [] }],
      "easyapache" =>
      [{ name: "easyapache", version: "0.0.3", dependencies: [] },
       { name: "easyapache", version: "0.0.2", dependencies: [] },
       { name: "easyapache", version: "0.0.1", dependencies: [] }],
      "ebs" =>
      [{ name: "ebs",
         version: "0.3.6",
         dependencies: [["aws", ">= 0.101.0"], ["delayed_evaluator", ">= 0.0.0"]] },
       { name: "ebs",
         version: "0.3.5",
         dependencies: [["aws", ">= 0.101.0"], ["delayed_evaluator", ">= 0.0.0"]] },
       { name: "ebs", version: "0.3.4", dependencies: [["aws", ">= 0.0.0"]] },
       { name: "ebs", version: "0.3.3", dependencies: [["aws", ">= 0.0.0"]] },
       { name: "ebs", version: "0.3.2", dependencies: [["aws", ">= 0.0.0"]] },
       { name: "ebs", version: "0.3.1", dependencies: [["aws", ">= 0.0.0"]] },
       { name: "ebs", version: "0.3.0", dependencies: [["aws", ">= 0.0.0"]] },
       { name: "ebs", version: "0.2.0", dependencies: [["aws", ">= 0.0.0"]] }],
      "ec2" => [{ name: "ec2", version: "0.9.0", dependencies: [] }],
      "ec2-ami-tools" =>
      [{ name: "ec2-ami-tools", version: "0.0.3", dependencies: [] },
       { name: "ec2-ami-tools", version: "0.0.2", dependencies: [] },
       { name: "ec2-ami-tools", version: "0.0.1", dependencies: [] }],
      "ec2-bundle-vol" =>
      [{ name: "ec2-bundle-vol", version: "0.0.1", dependencies: [] }],
      "echa-oracle" =>
      [{ name: "echa-oracle", version: "1.0.4", dependencies: [] },
       { name: "echa-oracle", version: "1.0.2", dependencies: [] }],
      "editor" =>
      [{ name: "editor",
         version: "0.2.0",
         dependencies: [["magic_shell", ">= 0.0.0"]] }],
      "ejabberd" =>
      [{ name: "ejabberd",
         version: "0.1.1",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] },
       { name: "ejabberd",
         version: "0.1.0",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.4"]] }],
      "el-sysctl" => [{ name: "el-sysctl", version: "0.0.6", dependencies: [] }],
      "el2centos" =>
      [{ name: "el2centos",
         version: "0.0.5",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "el2centos",
         version: "0.0.4",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "el2centos",
         version: "0.0.3",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "el2centos",
         version: "0.0.2",
         dependencies: [["yum", ">= 0.0.0"]] }],
      "elasticsearch-head" =>
      [{ name: "elasticsearch-head",
         version: "0.0.1",
         dependencies: [["elasticsearch", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "elasticsearch_cluster" =>
      [{ name: "elasticsearch_cluster",
         version: "3.0.4",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["tuning", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"]] },
       { name: "elasticsearch_cluster",
         version: "3.0.3",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["tuning", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"],
          ["dashpot", ">= 0.0.0"]] },
       { name: "elasticsearch_cluster",
         version: "3.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["mountable_volumes", ">= 0.0.0"],
          ["provides_service", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] }],
      "elefant" =>
      [{ name: "elefant",
         version: "0.8.1",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "elefant",
         version: "0.8.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"]] }],
      "elixir" =>
      [{ name: "elixir",
         version: "0.4.0",
         dependencies: [["git", ">= 0.0.0"], ["erlang", ">= 0.0.0"]] },
       { name: "elixir",
         version: "0.3.0",
         dependencies: [["git", ">= 0.0.0"], ["erlang", ">= 0.0.0"]] },
       { name: "elixir",
         version: "0.2.0",
         dependencies: [["git", ">= 0.0.0"], ["erlang", ">= 0.0.0"]] },
       { name: "elixir",
         version: "0.1.1",
         dependencies: [["git", ">= 0.0.0"], ["erlang", ">= 0.0.0"]] },
       { name: "elixir",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"], ["erlang", ">= 0.0.0"]] }],
      "emacs" =>
      [{ name: "emacs", version: "0.9.0", dependencies: [] },
       { name: "emacs", version: "0.8.4", dependencies: [] },
       { name: "emacs", version: "0.8.2", dependencies: [] },
       { name: "emacs", version: "0.8.0", dependencies: [] },
       { name: "emacs", version: "0.7.0", dependencies: [] }],
      "emailer" => [{ name: "emailer", version: "1.0.1", dependencies: [] }],
      "emerald_express" =>
      [{ name: "emerald_express", version: "0.1.0", dependencies: [] }],
      "encfs" => [{ name: "encfs", version: "0.1.0", dependencies: [] }],
      "encrypted_volume" =>
      [{ name: "encrypted_volume",
         version: "0.1.0",
         dependencies: [["chef-vault", ">= 0.0.0"]] }],
      "encryptfs" =>
      [{ name: "encryptfs", version: "1.0.1", dependencies: [] },
       { name: "encryptfs", version: "1.0.0", dependencies: [] }],
      "enforce_supported_platform" =>
      [{ name: "enforce_supported_platform",
         version: "1.0.0",
         dependencies: [] }],
      "enstratius_agent_proxy" =>
      [{ name: "enstratius_agent_proxy",
         version: "1.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"]] }],
      "envdir" => [{ name: "envdir", version: "0.1.0", dependencies: [] }],
      "environment-version" =>
      [{ name: "environment-version", version: "0.1.0", dependencies: [] }],
      "eos" =>
      [{ name: "eos", version: "0.1.4", dependencies: [] },
       { name: "eos", version: "0.1.2", dependencies: [] },
       { name: "eos", version: "0.1.0", dependencies: [] }],
      "ephemeral_lvm" =>
      [{ name: "ephemeral_lvm",
         version: "1.0.4",
         dependencies: [["lvm", "~> 1.0.0"]] },
       { name: "ephemeral_lvm",
         version: "1.0.3",
         dependencies: [["lvm", "~> 1.0.0"]] },
       { name: "ephemeral_lvm",
         version: "1.0.2",
         dependencies: [["lvm", "~> 1.0.0"]] },
       { name: "ephemeral_lvm",
         version: "1.0.1",
         dependencies: [["lvm", "~> 1.0.0"]] },
       { name: "ephemeral_lvm",
         version: "1.0.0",
         dependencies: [["lvm", "~> 1.0.0"]] }],
      "ephemeral_raid" =>
      [{ name: "ephemeral_raid", version: "0.0.5", dependencies: [] }],
      "erlang" =>
      [{ name: "erlang",
         version: "1.5.2",
         dependencies: [["apt", ">= 1.7.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"],
          ["yum-erlang_solutions", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "erlang",
         version: "1.5.0",
         dependencies: [["apt", ">= 1.7.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"],
          ["yum-erlang_solutions", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "erlang",
         version: "1.4.2",
         dependencies: [["apt", ">= 1.7.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"],
          ["yum-erlang_solutions", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "erlang",
         version: "1.4.0",
         dependencies: [["apt", ">= 1.7.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"],
          ["yum-erlang_solutions", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "erlang",
         version: "1.3.6",
         dependencies: [["apt", ">= 1.7.0"],
          ["yum", "< 3.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "erlang",
         version: "1.3.4",
         dependencies: [["apt", ">= 1.7.0"],
          ["yum", "< 3.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "erlang",
         version: "1.3.2",
         dependencies: [["apt", ">= 1.7.0"],
          ["yum", ">= 0.5.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "erlang",
         version: "1.3.0",
         dependencies: [["apt", ">= 1.7.0"],
          ["yum", ">= 0.5.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "erlang",
         version: "1.2.0",
         dependencies: [["yum", ">= 0.5.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "erlang", version: "1.1.2", dependencies: [["yum", ">= 0.5.0"]] },
       { name: "erlang", version: "1.1.0", dependencies: [["yum", ">= 0.5.0"]] },
       { name: "erlang", version: "1.0.0", dependencies: [["yum", ">= 0.5.0"]] },
       { name: "erlang", version: "0.9.0", dependencies: [["yum", ">= 0.5.0"]] },
       { name: "erlang", version: "0.8.2", dependencies: [] },
       { name: "erlang", version: "0.7.0", dependencies: [] }],
      "ernie" =>
      [{ name: "ernie",
         version: "0.1.0",
         dependencies: [["erlang", ">= 0.0.0"]] }],
      "errbit" =>
      [{ name: "errbit",
         version: "0.4.0",
         dependencies: [["mongodb", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "errbit",
         version: "0.3.0",
         dependencies: [["mongodb", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] },
       { name: "errbit",
         version: "0.2.0",
         dependencies: [["mongodb", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] },
       { name: "errbit",
         version: "0.1.0",
         dependencies: [["mongodb", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] }],
      "etcd" =>
      [{ name: "etcd",
         version: "2.1.3",
         dependencies: [["ark", ">= 0.0.0"],
          ["partial_search", "~> 1.0.6"],
          ["git", ">= 0.0.0"]] },
       { name: "etcd",
         version: "2.1.2",
         dependencies: [["ark", ">= 0.0.0"],
          ["partial_search", "~> 1.0.6"],
          ["git", ">= 0.0.0"]] },
       { name: "etcd",
         version: "2.1.1",
         dependencies: [["ark", ">= 0.0.0"],
          ["partial_search", "~> 1.0.2"],
          ["git", ">= 0.0.0"]] },
       { name: "etcd",
         version: "2.0.1",
         dependencies: [["ark", ">= 0.0.0"],
          ["partial_search", "~> 1.0.2"],
          ["git", ">= 0.0.0"]] },
       { name: "etcd",
         version: "2.0.0",
         dependencies: [["ark", ">= 0.0.0"],
          ["partial_search", "~> 1.0.2"],
          ["git", ">= 0.0.0"]] },
       { name: "etcd",
         version: "1.3.5",
         dependencies: [["ark", ">= 0.0.0"],
          ["partial_search", "~> 1.0.2"],
          ["git", ">= 0.0.0"]] },
       { name: "etcd",
         version: "1.3.4",
         dependencies: [["ark", ">= 0.0.0"], ["partial_search", "~> 1.0.2"]] },
       { name: "etcd",
         version: "1.3.3",
         dependencies: [["ark", ">= 0.0.0"], ["partial_search", "~> 1.0.2"]] },
       { name: "etcd", version: "1.3.1", dependencies: [["ark", ">= 0.0.0"]] },
       { name: "etcd", version: "1.2.4", dependencies: [["ark", ">= 0.0.0"]] },
       { name: "etcd", version: "1.2.3", dependencies: [["ark", ">= 0.0.0"]] },
       { name: "etcd", version: "1.2.2", dependencies: [["ark", ">= 0.0.0"]] },
       { name: "etcd", version: "1.2.1", dependencies: [["ark", ">= 0.0.0"]] },
       { name: "etcd", version: "1.1.1", dependencies: [["ark", ">= 0.0.0"]] },
       { name: "etcd", version: "1.1.0", dependencies: [["ark", ">= 0.0.0"]] },
       { name: "etcd", version: "1.0.0", dependencies: [] }],
      "etchosts" => [{ name: "etchosts", version: "0.1.0", dependencies: [] }],
      "etckeeper" =>
      [{ name: "etckeeper",
         version: "1.0.2",
         dependencies: [["chef_handler", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "etckeeper",
         version: "1.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "etckeeper",
         version: "0.0.3",
         dependencies: [["cron", ">= 0.0.0"]] },
       { name: "etckeeper",
         version: "0.0.2",
         dependencies: [["cron", ">= 0.0.0"]] }],
      "etc_environment" =>
      [{ name: "etc_environment", version: "1.0.1", dependencies: [] }],
      "etherpad" =>
      [{ name: "etherpad",
         version: "0.1.0",
         dependencies: [["nodejs", ">= 0.0.0"]] }],
      "etherpad-lite" =>
      [{ name: "etherpad-lite",
         version: "0.1.2",
         dependencies: [["nodejs", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["npm", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] },
       { name: "etherpad-lite",
         version: "0.1.1",
         dependencies: [["nodejs", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["npm", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] }],
      "eucalyptus" =>
      [{ name: "eucalyptus",
         version: "0.2.1",
         dependencies: [["yum", ">= 0.0.0"], ["ntp", ">= 0.0.0"], ["selinux", ">= 0.0.0"]] },
       { name: "eucalyptus",
         version: "0.2.0",
         dependencies: [["yum", ">= 0.0.0"],
          ["ntp", ">= 0.0.0"],
          ["selinux", ">= 0.0.0"],
          ["ssh_known_hosts", ">= 0.0.0"],
          ["partial_search", ">= 0.0.0"]] },
       { name: "eucalyptus",
         version: "0.1.5",
         dependencies: [["yum", ">= 0.0.0"],
          ["ntp", ">= 0.0.0"],
          ["selinux", ">= 0.0.0"],
          ["ssh_known_hosts", ">= 0.0.0"],
          ["partial_search", ">= 0.0.0"]] },
       { name: "eucalyptus",
         version: "0.1.4",
         dependencies: [["yum", ">= 0.0.0"],
          ["ntp", ">= 0.0.0"],
          ["selinux", ">= 0.0.0"],
          ["ssh_known_hosts", ">= 0.0.0"],
          ["partial_search", ">= 0.0.0"]] },
       { name: "eucalyptus",
         version: "0.1.3",
         dependencies: [["yum", ">= 0.0.0"],
          ["ntp", ">= 0.0.0"],
          ["selinux", ">= 0.0.0"],
          ["ssh_known_hosts", ">= 0.0.0"],
          ["partial_search", ">= 0.0.0"]] },
       { name: "eucalyptus",
         version: "0.1.2",
         dependencies: [["yum", ">= 0.0.0"],
          ["ntp", ">= 0.0.0"],
          ["selinux", ">= 0.0.0"],
          ["ssh_known_hosts", ">= 0.0.0"],
          ["partial_search", ">= 0.0.0"]] },
       { name: "eucalyptus",
         version: "0.1.1",
         dependencies: [["yum", ">= 0.0.0"],
          ["ntp", ">= 0.0.0"],
          ["selinux", ">= 0.0.0"],
          ["ssh_known_hosts", ">= 0.0.0"],
          ["partial_search", ">= 0.0.0"]] },
       { name: "eucalyptus",
         version: "0.1.0",
         dependencies: [["yum", ">= 0.0.0"],
          ["ntp", ">= 0.0.0"],
          ["selinux", ">= 0.0.0"],
          ["ssh_known_hosts", ">= 0.0.0"],
          ["partial_search", ">= 0.0.0"]] }],
      "eventlog" =>
      [{ name: "eventlog",
         version: "0.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "eventstore" =>
      [{ name: "eventstore",
         version: "0.4.0",
         dependencies: [["mono", ">= 0.0.0"]] },
       { name: "eventstore",
         version: "0.3.0",
         dependencies: [["mono", ">= 0.0.0"]] },
       { name: "eventstore",
         version: "0.2.0",
         dependencies: [["mono", ">= 0.0.0"]] },
       { name: "eventstore",
         version: "0.1.0",
         dependencies: [["mono", ">= 0.0.0"]] }],
      "exim4-light" =>
      [{ name: "exim4-light", version: "0.1.2", dependencies: [] },
       { name: "exim4-light", version: "0.1.1", dependencies: [] },
       { name: "exim4-light", version: "0.1.0", dependencies: [] }],
      "extended_drbd" =>
      [{ name: "extended_drbd",
         version: "1.0.2",
         dependencies: [["iptables", ">= 0.0.0"], ["wait", ">= 0.0.0"]] },
       { name: "extended_drbd",
         version: "1.0.1",
         dependencies: [["iptables", ">= 0.0.0"], ["wait", ">= 0.0.0"]] },
       { name: "extended_drbd",
         version: "1.0.0",
         dependencies: [["iptables", ">= 0.0.0"], ["wait", ">= 0.0.0"]] },
       { name: "extended_drbd", version: "0.0.1", dependencies: [] }],
      "eye" =>
      [{ name: "eye", version: "0.4.0", dependencies: [] },
       { name: "eye", version: "0.3.1", dependencies: [] },
       { name: "eye", version: "0.3.0", dependencies: [] },
       { name: "eye", version: "0.2.0", dependencies: [] },
       { name: "eye", version: "0.1.0", dependencies: [] }],
      "ez-ipupdate" =>
      [{ name: "ez-ipupdate", version: "0.1.8", dependencies: [] },
       { name: "ez-ipupdate", version: "0.1.7", dependencies: [] },
       { name: "ez-ipupdate", version: "0.1.6", dependencies: [] },
       { name: "ez-ipupdate", version: "0.1.5", dependencies: [] }],
      "fail2ban" =>
      [{ name: "fail2ban",
         version: "2.1.2",
         dependencies: [["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "fail2ban",
         version: "2.1.0",
         dependencies: [["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "fail2ban", version: "2.0.4", dependencies: [["yum", "< 3.0.0"]] },
       { name: "fail2ban", version: "2.0.2", dependencies: [["yum", "< 3.0.0"]] },
       { name: "fail2ban",
         version: "2.0.0",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "fail2ban",
         version: "1.2.4",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "fail2ban",
         version: "1.2.2",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "fail2ban",
         version: "1.2.0",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "fail2ban", version: "1.1.0", dependencies: [] },
       { name: "fail2ban", version: "1.0.2", dependencies: [] },
       { name: "fail2ban", version: "1.0.0", dependencies: [] },
       { name: "fail2ban", version: "0.7.0", dependencies: [] }],
      "fanfare" =>
      [{ name: "fanfare",
         version: "0.1.2",
         dependencies: [["postgresql", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["user", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "fanfare", version: "0.0.1", dependencies: [] }],
      "fanout" =>
      [{ name: "fanout",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "ffmpeg" =>
      [{ name: "ffmpeg",
         version: "0.3.1",
         dependencies: [["x264", ">= 0.0.0"],
          ["libvpx", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "ffmpeg",
         version: "0.3.0",
         dependencies: [["x264", ">= 0.0.0"],
          ["libvpx", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "ffmpeg",
         version: "0.2.1",
         dependencies: [["x264", "~> 0.3.0"],
          ["libvpx", "~> 0.2.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "ffmpeg",
         version: "0.2.0",
         dependencies: [["x264", "~> 0.2.0"],
          ["libvpx", "~> 0.2.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "ffmpeg",
         version: "0.1.3",
         dependencies: [["x264", "~> 0.1.1"],
          ["libvpx", "~> 0.1.1"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "ffmpeg",
         version: "0.1.1",
         dependencies: [["x264", "~> 0.1.1"],
          ["libvpx", "~> 0.1.1"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "ffmpeg",
         version: "0.1.0",
         dependencies: [["x264", "~> 0.1.1"],
          ["libvpx", "~> 0.1.1"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] }],
      "ff_sync" =>
      [{ name: "ff_sync",
         version: "1.0.0",
         dependencies: [["mercurial", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] }],
      "filesystem" =>
      [{ name: "filesystem",
         version: "0.8.2",
         dependencies: [["xfs", ">= 0.0.0"], ["lvm", "~> 1.0.0"]] },
       { name: "filesystem",
         version: "0.8.1",
         dependencies: [["xfs", ">= 0.0.0"], ["lvm", "~> 1.0.0"]] }],
      "filezilla" =>
      [{ name: "filezilla",
         version: "1.0.1",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "filezilla",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "firefox" =>
      [{ name: "firefox",
         version: "1.0.7",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "firefox",
         version: "1.0.6",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "firefox",
         version: "1.0.5",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "firefox",
         version: "1.0.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "firefox",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "firewall" =>
      [{ name: "firewall", version: "0.11.6", dependencies: [] },
       { name: "firewall", version: "0.11.4", dependencies: [] },
       { name: "firewall", version: "0.11.2", dependencies: [] },
       { name: "firewall", version: "0.11.0", dependencies: [] },
       { name: "firewall", version: "0.10.2", dependencies: [] },
       { name: "firewall", version: "0.10.0", dependencies: [] },
       { name: "firewall", version: "0.9.2", dependencies: [] },
       { name: "firewall", version: "0.8.2", dependencies: [] },
       { name: "firewall", version: "0.9.0", dependencies: [] },
       { name: "firewall", version: "0.8.0", dependencies: [] },
       { name: "firewall", version: "0.6.0", dependencies: [] },
       { name: "firewall", version: "0.5.7", dependencies: [] },
       { name: "firewall", version: "0.5.6", dependencies: [] },
       { name: "firewall", version: "0.5.5", dependencies: [] },
       { name: "firewall", version: "0.5.2", dependencies: [] },
       { name: "firewall", version: "0.5.0", dependencies: [] }],
      "flapjack" =>
      [{ name: "flapjack",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["logrotate", ">= 0.0.0"]] }],
      "flume" =>
      [{ name: "flume",
         version: "3.0.4",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"]] },
       { name: "flume",
         version: "3.0.3",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"]] },
       { name: "flume",
         version: "3.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["mountable_volumes", ">= 0.0.0"],
          ["provides_service", ">= 0.0.0"]] }],
      "flume_agent" =>
      [{ name: "flume_agent", version: "1.0.2", dependencies: [] },
       { name: "flume_agent", version: "1.0.1", dependencies: [] },
       { name: "flume_agent", version: "1.0.0", dependencies: [] }],
      "fog" =>
      [{ name: "fog", version: "0.0.2", dependencies: [["mysql", ">= 0.0.0"]] }],
      "fog_cloud" =>
      [{ name: "fog_cloud", version: "0.1.2", dependencies: [] },
       { name: "fog_cloud",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "foreman" =>
      [{ name: "foreman",
         version: "0.0.1",
         dependencies: [["uwsgi", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ruby_install", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["tftp", ">= 0.0.0"],
          ["bind", ">= 0.0.0"],
          ["dhcp", ">= 0.0.0"]] }],
      "forever" =>
      [{ name: "forever",
         version: "0.1.1",
         dependencies: [["npm", ">= 0.0.0"]] }],
      "forkable_client" =>
      [{ name: "forkable_client", version: "0.0.1", dependencies: [] }],
      "fortune" => [{ name: "fortune", version: "0.0.1", dependencies: [] }],
      "fping" =>
      [{ name: "fping", version: "0.1.0", dependencies: [["yum", ">= 0.0.0"]] }],
      "fpm" => [{ name: "fpm", version: "0.0.1", dependencies: [] }],
      "fpm-tng" =>
      [{ name: "fpm-tng", version: "0.1.7", dependencies: [] },
       { name: "fpm-tng", version: "0.1.4", dependencies: [] },
       { name: "fpm-tng", version: "0.1.3", dependencies: [] },
       { name: "fpm-tng", version: "0.1.2", dependencies: [] },
       { name: "fpm-tng", version: "0.1.1", dependencies: [] },
       { name: "fpm-tng", version: "0.1.0", dependencies: [] }],
      "fqdn" =>
      [{ name: "fqdn",
         version: "0.3.0",
         dependencies: [["line", ">= 0.0.0"], ["hostsfile", ">= 0.0.0"], ["now", ">= 0.0.0"]] },
       { name: "fqdn",
         version: "0.2.0",
         dependencies: [["line", ">= 0.0.0"], ["hostsfile", ">= 0.0.0"]] },
       { name: "fqdn",
         version: "0.1.2",
         dependencies: [["line", ">= 0.0.0"], ["hostsfile", ">= 0.0.0"]] }],
      "freebsd" =>
      [{ name: "freebsd", version: "0.1.2", dependencies: [] },
       { name: "freebsd", version: "0.1.0", dependencies: [] },
       { name: "freebsd", version: "0.0.6", dependencies: [] },
       { name: "freebsd", version: "0.0.4", dependencies: [] },
       { name: "freebsd", version: "0.0.2", dependencies: [] },
       { name: "freebsd", version: "0.0.1", dependencies: [] }],
      "freeswitch" =>
      [{ name: "freeswitch",
         version: "0.4.2",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 3.1"]] },
       { name: "freeswitch",
         version: "0.4.1",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 3.1"]] },
       { name: "freeswitch",
         version: "0.4.0",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 3.1"]] },
       { name: "freeswitch",
         version: "0.3.2",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.2"]] },
       { name: "freeswitch",
         version: "0.3.1",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.2"]] },
       { name: "freeswitch",
         version: "0.3.0",
         dependencies: [["apt", "~> 2.2"], ["yum", "~> 2.2"]] },
       { name: "freeswitch",
         version: "0.2.0",
         dependencies: [["apt", "~> 2.2"]] },
       { name: "freeswitch",
         version: "0.1.0",
         dependencies: [["apt", "~> 2.2"]] }],
      "freight" =>
      [{ name: "freight", version: "0.2.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "freight",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "freightyard" =>
      [{ name: "freightyard",
         version: "0.1.0",
         dependencies: [["freight", ">= 0.0.0"], ["perl", ">= 0.0.0"]] }],
      "fuse" =>
      [{ name: "fuse",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "fuse",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "fusioninventory-agent" =>
      [{ name: "fusioninventory-agent",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "fusioninventory-agent", version: "0.1.0", dependencies: [] }],
      "gads" =>
      [{ name: "gads",
         version: "0.2.0",
         dependencies: [["java", ">= 0.0.0"], ["run_once", ">= 0.0.0"]] }],
      "galera" => [{ name: "galera", version: "0.4.1", dependencies: [] }],
      "gallery" =>
      [{ name: "gallery",
         version: "0.1.1",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"]] }],
      "gams" => [{ name: "gams", version: "0.1.0", dependencies: [] }],
      "ganglia_cluster" =>
      [{ name: "ganglia_cluster",
         version: "3.0.4",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"]] },
       { name: "ganglia_cluster",
         version: "3.0.3",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"]] }],
      "gateway" =>
      [{ name: "gateway",
         version: "0.2.0",
         dependencies: [["sysctl", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["iptables-ng", ">= 0.0.0"]] },
       { name: "gateway", version: "0.1.0", dependencies: [] }],
      "gdal" =>
      [{ name: "gdal", version: "0.1.0", dependencies: [["ark", ">= 0.0.0"]] }],
      "gdash" =>
      [{ name: "gdash",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["graphite", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"]] },
       { name: "gdash",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["graphite", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"]] }],
      "gdebi" =>
      [{ name: "gdebi", version: "1.1.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "gdebi", version: "1.0.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "gdebi", version: "0.2.0", dependencies: [] }],
      "gearman" => [{ name: "gearman", version: "0.0.1", dependencies: [] }],
      "gecode" =>
      [{ name: "gecode",
         version: "2.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", "~> 3.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "gecode",
         version: "2.0.8",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", "< 3.0.0"]] },
       { name: "gecode",
         version: "2.0.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", "< 3.0.0"]] },
       { name: "gecode",
         version: "2.0.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "gecode",
         version: "2.0.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "gecode",
         version: "1.3.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "gecode",
         version: "1.2.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "gecode",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "gecode",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "gecode",
         version: "0.99.0",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "gelf_handler" =>
      [{ name: "gelf_handler",
         version: "1.0.6",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "gelf_handler",
         version: "1.0.5",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "gelf_handler",
         version: "1.0.4",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "gelf_handler",
         version: "1.0.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "gelf_handler",
         version: "1.0.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "geminabox" =>
      [{ name: "geminabox",
         version: "0.1.2",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] },
       { name: "geminabox",
         version: "0.1.1",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] },
       { name: "geminabox",
         version: "0.1.0",
         dependencies: [["unicorn", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] }],
      "gemrc" => [{ name: "gemrc", version: "0.0.1", dependencies: [] }],
      "gems" =>
      [{ name: "gems",
         version: "0.8.3",
         dependencies: [["rsync", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "gems",
         version: "0.8.2",
         dependencies: [["rsync", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "gems",
         version: "0.8.0",
         dependencies: [["apache2", ">= 0.0.0"]] }],
      "gem_installer" =>
      [{ name: "gem_installer", version: "0.1.2", dependencies: [] },
       { name: "gem_installer", version: "0.1.1", dependencies: [] },
       { name: "gem_installer",
         version: "0.1.0",
         dependencies: [["bag_config", ">= 0.0.0"]] }],
      "gem_server" =>
      [{ name: "gem_server",
         version: "0.1.2",
         dependencies: [["runit", ">= 0.0.0"], ["rbenv", ">= 1.5.0"], ["nginx", ">= 1.7.0"]] },
       { name: "gem_server",
         version: "0.1.1",
         dependencies: [["runit", ">= 0.0.0"], ["rbenv", ">= 1.5.0"], ["nginx", ">= 1.7.0"]] },
       { name: "gem_server",
         version: "0.1.0",
         dependencies: [["runit", ">= 0.0.0"], ["rbenv", ">= 1.5.0"], ["nginx", ">= 1.7.0"]] }],
      "gem_specific_install" =>
      [{ name: "gem_specific_install",
         version: "0.1.8",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "gem_specific_install",
         version: "0.1.6",
         dependencies: [["git", ">= 0.0.0"], ["run_action_now", ">= 0.0.0"]] },
       { name: "gem_specific_install",
         version: "0.1.4",
         dependencies: [["git", ">= 0.0.0"], ["run_action_now", ">= 0.0.0"]] },
       { name: "gem_specific_install",
         version: "0.1.3",
         dependencies: [["git", ">= 0.0.0"], ["run_action_now", ">= 0.0.0"]] },
       { name: "gem_specific_install",
         version: "0.1.2",
         dependencies: [["git", ">= 0.0.0"], ["run_action_now", ">= 0.0.0"]] },
       { name: "gem_specific_install",
         version: "0.1.1",
         dependencies: [["git", ">= 0.0.0"], ["run_action_now", ">= 0.0.0"]] },
       { name: "gem_specific_install",
         version: "0.2.0",
         dependencies: [["git", ">= 0.0.0"]] }],
      "generic-users" =>
      [{ name: "generic-users", version: "0.1.7", dependencies: [] },
       { name: "generic-users", version: "0.1.6", dependencies: [] },
       { name: "generic-users", version: "0.1.5", dependencies: [] },
       { name: "generic-users", version: "0.1.4", dependencies: [] },
       { name: "generic-users", version: "0.1.3", dependencies: [] },
       { name: "generic-users", version: "0.1.2", dependencies: [] },
       { name: "generic-users", version: "0.1.1", dependencies: [] },
       { name: "generic-users", version: "0.1.0", dependencies: [] },
       { name: "generic-users", version: "0.0.9", dependencies: [] },
       { name: "generic-users", version: "0.0.1", dependencies: [] }],
      "geoip" => [{ name: "geoip", version: "0.1.0", dependencies: [] }],
      "geos" =>
      [{ name: "geos", version: "0.1.1", dependencies: [] },
       { name: "geos", version: "0.1.0", dependencies: [] }],
      "gerrit" =>
      [{ name: "gerrit",
         version: "0.3.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["maven", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ssl_certificates", ">= 0.0.0"]] }],
      "getaddrinfo" => [{ name: "getaddrinfo", version: "0.1.0", dependencies: [] }],
      "getting-orche" =>
      [{ name: "getting-orche", version: "0.4.0", dependencies: [] }],
      "getting-started" =>
      [{ name: "getting-started", version: "0.4.0", dependencies: [] },
       { name: "getting-started", version: "0.3.0", dependencies: [] },
       { name: "getting-started", version: "0.2.0", dependencies: [] },
       { name: "getting-started", version: "0.1.0", dependencies: [] }],
      "gflags" =>
      [{ name: "gflags",
         version: "1.0.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "gflags",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "gflags",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "gflags",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "gflags",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] }],
      "ghmac" =>
      [{ name: "ghmac", version: "1.3.4", dependencies: [] },
       { name: "ghmac", version: "1.2.2", dependencies: [] },
       { name: "ghmac", version: "1.1.0", dependencies: [] },
       { name: "ghmac", version: "1.0.0", dependencies: [] }],
      "ghubbkup" =>
      [{ name: "ghubbkup",
         version: "0.1.61",
         dependencies: [["amazon_s3cmd", ">= 0.0.0"]] },
       { name: "ghubbkup",
         version: "0.1.60",
         dependencies: [["amazon_s3cmd", ">= 0.0.0"]] },
       { name: "ghubbkup",
         version: "0.1.59",
         dependencies: [["amazon_s3cmd", ">= 0.0.0"]] }],
      "giraffe" =>
      [{ name: "giraffe",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"]] }],
      "git-annex" =>
      [{ name: "git-annex",
         version: "0.1.6",
         dependencies: [["apt", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] },
       { name: "git-annex",
         version: "0.1.5",
         dependencies: [["apt", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] },
       { name: "git-annex",
         version: "0.1.4",
         dependencies: [["apt", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] },
       { name: "git-annex",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] },
       { name: "git-annex",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] },
       { name: "git-annex",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] },
       { name: "git-annex",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] }],
      "git-fs" => [{ name: "git-fs", version: "0.1.0", dependencies: [] }],
      "git-ssh-server" =>
      [{ name: "git-ssh-server",
         version: "0.2.0",
         dependencies: [["git", ">= 2.2.0"]] },
       { name: "git-ssh-server",
         version: "0.1.3",
         dependencies: [["git", ">= 2.2.0"]] },
       { name: "git-ssh-server",
         version: "0.1.2",
         dependencies: [["git", ">= 2.2.0"]] },
       { name: "git-ssh-server",
         version: "0.1.1",
         dependencies: [["git", ">= 2.2.0"]] },
       { name: "git-ssh-server",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"]] }],
      "github" =>
      [{ name: "github",
         version: "0.2.0",
         dependencies: [["libarchive", ">= 0.0.0"]] },
       { name: "github", version: "0.1.1", dependencies: [] },
       { name: "github", version: "0.1.0", dependencies: [] }],
      "github-deploys" =>
      [{ name: "github-deploys", version: "0.1.2", dependencies: [] },
       { name: "github-deploys", version: "0.1.1", dependencies: [] },
       { name: "github-deploys", version: "0.1.0", dependencies: [] }],
      "github_backup" =>
      [{ name: "github_backup",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"]] }],
      "github_users" =>
      [{ name: "github_users",
         version: "0.1.1",
         dependencies: [["ssh_known_hosts", ">= 0.0.0"], ["sudo", ">= 0.0.0"]] }],
      "gitlab" =>
      [{ name: "gitlab",
         version: "6.4.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "6.4.5",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "6.4.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "6.4.3",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "6.4.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "6.4.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "6.4.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", "<= 2.0.8"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", "<= 2.4.4"]] },
       { name: "gitlab",
         version: "6.1.21",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["nginx", "<= 2.0.8"],
          ["yum", "<= 2.4.4"]] },
       { name: "gitlab",
         version: "6.1.10",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", "< 3.0.0"]] },
       { name: "gitlab",
         version: "6.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["certificate", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "0.3.4",
         dependencies: [["yumrepo", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "0.3.3",
         dependencies: [["yumrepo", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "0.3.2",
         dependencies: [["ruby_build", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "0.3.1",
         dependencies: [["ruby_build", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "0.3.0",
         dependencies: [["ruby_build", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "0.2.1",
         dependencies: [["ruby_build", ">= 0.0.0"],
          ["chef_gem", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"]] },
       { name: "gitlab",
         version: "0.2.0",
         dependencies: [["ruby_build", ">= 0.0.0"],
          ["chef_gem", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"]] }],
      "gitlab-server" =>
      [{ name: "gitlab-server",
         version: "1.0.3",
         dependencies: [["redisio", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rvm", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "gitlab-server",
         version: "1.0.2",
         dependencies: [["redisio", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rvm", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "gitlab-server",
         version: "1.0.1",
         dependencies: [["redisio", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["rvm", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] }],
      "gitlabhq" =>
      [{ name: "gitlabhq",
         version: "0.4.1",
         dependencies: [["yumrepo", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["backup", ">= 0.0.0"]] },
       { name: "gitlabhq",
         version: "0.4.0",
         dependencies: [["yumrepo", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["xml", ">= 0.0.0"],
          ["zlib", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["backup", ">= 0.0.0"]] }],
      "gitolite" =>
      [{ name: "gitolite", version: "1.0.1", dependencies: [] },
       { name: "gitolite", version: "1.0.0", dependencies: [] }],
      "gitolite-server" =>
      [{ name: "gitolite-server",
         version: "1.0.1",
         dependencies: [["git", ">= 0.0.0"], ["ssh_known_hosts", ">= 0.0.0"]] }],
      "gitorious" =>
      [{ name: "gitorious",
         version: "2.1.0",
         dependencies: [["rabbitmq", ">= 2.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "gitorious",
         version: "2.0.0",
         dependencies: [["rabbitmq", ">= 2.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "gitorious",
         version: "1.1.0",
         dependencies: [["rabbitmq", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["memcached", ">= 0.0.0"]] },
       { name: "gitorious",
         version: "1.0.0",
         dependencies: [["rabbitmq", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["memcached", ">= 0.0.0"]] }],
      "gitosis" =>
      [{ name: "gitosis",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"], ["ssh_known_hosts", ">= 0.0.0"]] }],
      "gitpaste" =>
      [{ name: "gitpaste",
         version: "0.0.3",
         dependencies: [["nginx", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "gitpaste",
         version: "0.0.2",
         dependencies: [["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "gitpaste",
         version: "0.0.1",
         dependencies: [["python", ">= 0.0.0"],
          ["gunicorn", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"]] }],
      "gitzone" => [{ name: "gitzone", version: "1.0.6", dependencies: [] }],
      "git_ppa" =>
      [{ name: "git_ppa",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "git_user" =>
      [{ name: "git_user",
         version: "0.3.0",
         dependencies: [["user", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ssh_known_hosts", ">= 0.0.0"]] }],
      "gkrellmd" =>
      [{ name: "gkrellmd",
         version: "0.3.2",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "gkrellmd",
         version: "0.3.1",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "gkrellmd",
         version: "0.3.0",
         dependencies: [["yum", ">= 0.0.0"]] }],
      "glassfish" =>
      [{ name: "glassfish",
         version: "0.5.28",
         dependencies: [["java", ">= 0.0.0"],
          ["authbind", ">= 0.0.0"],
          ["cutlery", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.24",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"], ["cutlery", "~> 0.1"]] },
       { name: "glassfish",
         version: "0.5.22",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"], ["cutlery", "~> 0.1"]] },
       { name: "glassfish",
         version: "0.5.20",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"], ["cutlery", "~> 0.1"]] },
       { name: "glassfish",
         version: "0.5.19",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"], ["cutlery", "~> 0.1"]] },
       { name: "glassfish",
         version: "0.5.18",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"], ["cutlery", "~> 0.1"]] },
       { name: "glassfish",
         version: "0.5.16",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"], ["cutlery", "~> 0.1"]] },
       { name: "glassfish",
         version: "0.5.14",
         dependencies: [["java", ">= 0.0.0"],
          ["authbind", ">= 0.0.0"],
          ["cutlery", "~> 0.1.0"]] },
       { name: "glassfish",
         version: "0.5.12",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.10",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.8",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.6",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.5",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.4",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.3",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.2",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.5.0",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.4.49",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.4.47",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.4.46",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish",
         version: "0.4.45",
         dependencies: [["java", ">= 0.0.0"], ["authbind", ">= 0.0.0"]] },
       { name: "glassfish", version: "0.3.1", dependencies: [] },
       { name: "glassfish", version: "0.3.0", dependencies: [] },
       { name: "glassfish", version: "0.1.0", dependencies: [] }],
      "global" =>
      [{ name: "global", version: "0.1.1", dependencies: [] },
       { name: "global", version: "0.1.0", dependencies: [] }],
      "gluster" =>
      [{ name: "gluster",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "gnome" =>
      [{ name: "gnome",
         version: "0.0.3",
         dependencies: [["x-windows", ">= 0.0.0"]] },
       { name: "gnome", version: "0.0.2", dependencies: [] },
       { name: "gnome", version: "0.0.1", dependencies: [] }],
      "gnu_parallel" =>
      [{ name: "gnu_parallel",
         version: "1.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["homebrew", ">= 0.0.0"]] },
       { name: "gnu_parallel",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["homebrew", ">= 0.0.0"]] },
       { name: "gnu_parallel",
         version: "0.99.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["homebrew", ">= 0.0.0"]] },
       { name: "gnu_parallel",
         version: "0.99.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["homebrew", ">= 0.0.0"]] },
       { name: "gnu_parallel",
         version: "0.99.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "goaccess" =>
      [{ name: "goaccess",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "god" =>
      [{ name: "god", version: "1.0.2", dependencies: [["runit", "<= 0.16.2"]] },
       { name: "god", version: "1.0.0", dependencies: [["runit", ">= 0.0.0"]] },
       { name: "god",
         version: "0.7.0",
         dependencies: [["runit", ">= 0.0.0"], ["ruby", ">= 0.0.0"]] }],
      "golang" =>
      [{ name: "golang", version: "1.3.0", dependencies: [] },
       { name: "golang", version: "1.2.0", dependencies: [] },
       { name: "golang", version: "1.1.2", dependencies: [["git", ">= 0.0.0"]] },
       { name: "golang", version: "1.1.1", dependencies: [["git", ">= 0.0.0"]] },
       { name: "golang", version: "1.1.0", dependencies: [["git", ">= 0.0.0"]] },
       { name: "golang", version: "1.0.2", dependencies: [] },
       { name: "golang", version: "1.0.1", dependencies: [] }],
      "goodbye_world" =>
      [{ name: "goodbye_world", version: "0.1.11", dependencies: [] },
       { name: "goodbye_world", version: "0.1.10", dependencies: [] },
       { name: "goodbye_world", version: "0.1.9", dependencies: [] },
       { name: "goodbye_world", version: "0.1.8", dependencies: [] },
       { name: "goodbye_world", version: "0.1.7", dependencies: [] }],
      "google-authenticator" =>
      [{ name: "google-authenticator",
         version: "0.1.8",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "google-authenticator",
         version: "0.1.5",
         dependencies: [["openssh", ">= 0.0.0"]] },
       { name: "google-authenticator",
         version: "0.1.4",
         dependencies: [["openssh", ">= 0.0.0"]] }],
      "google-chrome" =>
      [{ name: "google-chrome",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "google-drive" =>
      [{ name: "google-drive",
         version: "0.1.1",
         dependencies: [["windows", ">= 1.2.6"]] }],
      "gosu" => [{ name: "gosu", version: "0.1.0", dependencies: [] }],
      "gow" =>
      [{ name: "gow", version: "0.0.3", dependencies: [["windows", ">= 1.2.8"]] },
       { name: "gow", version: "0.0.2", dependencies: [["windows", ">= 1.2.8"]] },
       { name: "gow",
         version: "0.0.1",
         dependencies: [["windows", ">= 1.2.8"]] }],
      "gozer" =>
      [{ name: "gozer",
         version: "0.0.4",
         dependencies: [["i3", ">= 0.0.0"], ["ohai", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "gozer",
         version: "0.0.3",
         dependencies: [["i3", ">= 0.0.0"], ["ohai", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "gozer", version: "0.0.2", dependencies: [["i3", ">= 0.0.0"]] },
       { name: "gozer", version: "0.0.1", dependencies: [["i3", ">= 0.0.0"]] }],
      "gpac" =>
      [{ name: "gpac",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["subversion", ">= 0.0.0"]] },
       { name: "gpac",
         version: "0.0.6",
         dependencies: [["build-essential", ">= 0.0.0"], ["subversion", ">= 0.0.0"]] },
       { name: "gpac",
         version: "0.0.5",
         dependencies: [["build-essential", ">= 0.0.0"], ["subversion", ">= 0.0.0"]] },
       { name: "gpac",
         version: "0.0.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["subversion", ">= 0.0.0"]] },
       { name: "gpac",
         version: "0.0.3",
         dependencies: [["build-essential", ">= 0.0.0"], ["subversion", ">= 0.0.0"]] },
       { name: "gpac",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "gpac",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "gpg" =>
      [{ name: "gpg", version: "0.2.2", dependencies: [] },
       { name: "gpg", version: "0.1.1", dependencies: [] },
       { name: "gpg", version: "0.1.0", dependencies: [] },
       { name: "gpg",
         version: "0.0.1",
         dependencies: [["minitest", ">= 0.0.0"]] }],
      "gqlplus" =>
      [{ name: "gqlplus",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["ark", ">= 0.0.0"]] },
       { name: "gqlplus",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["readline", ">= 0.0.0"],
          ["ncurses", ">= 0.0.0"],
          ["ark", ">= 0.0.0"]] }],
      "gradle" =>
      [{ name: "gradle",
         version: "1.5.1",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "gradle",
         version: "1.5.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "gradle",
         version: "1.4.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "gradle",
         version: "1.2.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] }],
      "graphene" =>
      [{ name: "graphene",
         version: "0.0.6",
         dependencies: [["graphite", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "graphene",
         version: "0.0.3",
         dependencies: [["graphite", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] }],
      "graphite_handler" =>
      [{ name: "graphite_handler",
         version: "0.0.8",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "graphite_handler",
         version: "0.0.6",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "graphite_handler",
         version: "0.0.5",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "graphite_handler",
         version: "0.0.4",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "graphite_handler",
         version: "0.0.3",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "graphite_handler",
         version: "0.0.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "graphite_handler",
         version: "0.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "graphite_lwrp" =>
      [{ name: "graphite_lwrp",
         version: "0.3.3",
         dependencies: [["python", ">= 0.0.0"],
          ["carbon", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "graphite_lwrp",
         version: "0.1.2",
         dependencies: [["python", ">= 0.0.0"],
          ["carbon", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] }],
      "graphite_reporting_handler" =>
      [{ name: "graphite_reporting_handler",
         version: "1.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "graphite_reporting_handler",
         version: "1.0.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "graphiti" =>
      [{ name: "graphiti",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["runit", ">= 0.0.0"]] }],
      "graylog2" =>
      [{ name: "graylog2",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["apache2", ">= 0.0.0"], ["mongodb", ">= 0.0.0"]] },
       { name: "graylog2",
         version: "0.0.5",
         dependencies: [["apt", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "graylog2",
         version: "0.0.4",
         dependencies: [["apt", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "graylog2",
         version: "0.0.3",
         dependencies: [["apt", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "grc" => [{ name: "grc", version: "1.0.0", dependencies: [] }],
      "greenscreen" =>
      [{ name: "greenscreen",
         version: "0.0.5",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "greenscreen",
         version: "0.0.4",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "greenscreen",
         version: "0.0.3",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "greenscreen",
         version: "0.0.2",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "greenscreen",
         version: "0.0.1",
         dependencies: [["git", ">= 0.0.0"]] }],
      "grinder" =>
      [{ name: "grinder",
         version: "0.1.0",
         dependencies: [["apt", "~> 2.3"],
          ["java", "~> 1.14"],
          ["bluepill", "~> 2.3"],
          ["python", "~> 1.4"],
          ["build-essential", "~> 1.4.2"]] }],
      "groovy" =>
      [{ name: "groovy",
         version: "0.0.1",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] }],
      "group" => [{ name: "group", version: "0.0.1", dependencies: [] }],
      "gunicorn" =>
      [{ name: "gunicorn",
         version: "1.1.2",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "gunicorn",
         version: "1.1.0",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "gunicorn",
         version: "1.0.0",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "gunicorn",
         version: "0.99.0",
         dependencies: [["python", ">= 0.0.0"]] }],
      "hadoop" =>
      [{ name: "hadoop",
         version: "1.0.1",
         dependencies: [["yum", ">= 3.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "hadoop",
         version: "1.0.0",
         dependencies: [["yum", ">= 3.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "hadoop",
         version: "0.8.0",
         dependencies: [["java", ">= 0.0.0"]] }],
      "hadoop_cluster" =>
      [{ name: "hadoop_cluster",
         version: "3.0.5",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["tuning", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["dashpot", ">= 0.0.0"]] },
       { name: "hadoop_cluster",
         version: "0.10.0",
         dependencies: [["cluster_service_discovery", ">= 0.0.0"],
          ["mountable_volumes", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["ubuntu", ">= 0.0.0"]] },
       { name: "hadoop_cluster",
         version: "0.9.5",
         dependencies: [["java", ">= 0.0.0"],
          ["ebs", ">= 0.0.0"],
          ["aws", ">= 0.0.0"],
          ["ubuntu", ">= 0.0.0"],
          ["cluster_service_discovery", ">= 0.0.0"]] }],
      "hadoop_cluster_rpm" =>
      [{ name: "hadoop_cluster_rpm",
         version: "0.9.0",
         dependencies: [["java", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "hadoop_for_hbase" =>
      [{ name: "hadoop_for_hbase",
         version: "0.1.0",
         dependencies: [["ssh_known_hosts", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "haproxy" =>
      [{ name: "haproxy",
         version: "1.6.2",
         dependencies: [["cpu", ">= 0.2.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "haproxy",
         version: "1.6.0",
         dependencies: [["cpu", ">= 0.2.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "haproxy",
         version: "1.5.0",
         dependencies: [["cpu", ">= 0.2.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "haproxy",
         version: "1.4.0",
         dependencies: [["cpu", ">= 0.2.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "haproxy",
         version: "1.3.2",
         dependencies: [["cpu", ">= 0.2.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "haproxy",
         version: "1.3.0",
         dependencies: [["cpu", ">= 0.2.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "haproxy", version: "1.2.0", dependencies: [["cpu", ">= 0.2.0"]] },
       { name: "haproxy", version: "1.1.4", dependencies: [] },
       { name: "haproxy", version: "1.1.0", dependencies: [] },
       { name: "haproxy", version: "1.0.6", dependencies: [] },
       { name: "haproxy", version: "1.0.4", dependencies: [] },
       { name: "haproxy", version: "1.0.3", dependencies: [] },
       { name: "haproxy", version: "1.0.2", dependencies: [] },
       { name: "haproxy", version: "1.0.1", dependencies: [] },
       { name: "haproxy", version: "1.0.0", dependencies: [] },
       { name: "haproxy", version: "0.8.1", dependencies: [] },
       { name: "haproxy", version: "0.8.0", dependencies: [] },
       { name: "haproxy", version: "0.7.0", dependencies: [] }],
      "haproxy2" => [{ name: "haproxy2", version: "0.5.7", dependencies: [] }],
      "haproxy_lwrp" =>
      [{ name: "haproxy_lwrp",
         version: "2.0.3",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "haproxy_lwrp",
         version: "2.0.2",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "haproxy_lwrp",
         version: "2.0.1",
         dependencies: [["runit", ">= 0.0.0"]] }],
      "hbase" =>
      [{ name: "hbase",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"], ["hadoop", ">= 0.0.0"]] }],
      "hbase_cluster" =>
      [{ name: "hbase_cluster",
         version: "3.0.4",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["dashpot", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"],
          ["zookeeper", ">= 0.0.0"],
          ["ganglia", ">= 0.0.0"]] },
       { name: "hbase_cluster",
         version: "3.0.3",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"],
          ["zookeeper", ">= 0.0.0"],
          ["ganglia", ">= 0.0.0"]] },
       { name: "hbase_cluster",
         version: "3.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["mountable_volumes", ">= 0.0.0"],
          ["provides_service", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"],
          ["zookeeper", ">= 0.0.0"],
          ["ganglia", ">= 0.0.0"]] }],
      "headphones" => [{ name: "headphones", version: "0.0.1", dependencies: [] }],
      "heartbeat" =>
      [{ name: "heartbeat", version: "1.0.0", dependencies: [] },
       { name: "heartbeat", version: "0.7.1", dependencies: [] },
       { name: "heartbeat", version: "0.7.0", dependencies: [] }],
      "heartbeat3" =>
      [{ name: "heartbeat3", version: "0.4.3", dependencies: [] },
       { name: "heartbeat3", version: "0.4.2", dependencies: [] },
       { name: "heartbeat3", version: "0.4.1", dependencies: [] }],
      "heavywater" => [{ name: "heavywater", version: "0.1.0", dependencies: [] }],
      "heidisql" =>
      [{ name: "heidisql",
         version: "1.0.0",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "heidisql",
         version: "0.1.0",
         dependencies: [["windows", ">= 1.2.6"]] }],
      "helios" =>
      [{ name: "helios",
         version: "1.0.1",
         dependencies: [["powershell", ">= 1.0.6"]] },
       { name: "helios",
         version: "0.0.5",
         dependencies: [["powershell", ">= 1.0.6"]] }],
      "hello_world" =>
      [{ name: "hello_world", version: "0.0.3", dependencies: [] },
       { name: "hello_world", version: "0.0.2", dependencies: [] },
       { name: "hello_world", version: "0.0.1", dependencies: [] }],
      "hello_world_test" =>
      [{ name: "hello_world_test", version: "1.0.0", dependencies: [] }],
      "helpers-databags" =>
      [{ name: "helpers-databags", version: "1.0.0", dependencies: [] },
       { name: "helpers-databags", version: "0.0.3", dependencies: [] },
       { name: "helpers-databags", version: "0.0.2", dependencies: [] }],
      "helpers-search" =>
      [{ name: "helpers-search", version: "0.0.3", dependencies: [] }],
      "hermes" =>
      [{ name: "hermes",
         version: "0.1.1",
         dependencies: [["cerberus", ">= 0.0.2"]] },
       { name: "hermes",
         version: "0.1.0",
         dependencies: [["cerberus", ">= 0.0.2"]] }],
      "heroku" => [{ name: "heroku", version: "0.1.0", dependencies: [] }],
      "hg" =>
      [{ name: "hg",
         version: "0.1.2",
         dependencies: [["mercurial", ">= 0.0.0"]] },
       { name: "hg",
         version: "0.1.0",
         dependencies: [["mercurial", ">= 0.0.0"]] }],
      "hgrc" =>
      [{ name: "hgrc",
         version: "0.0.2",
         dependencies: [["conffile", ">= 0.0.0"]] },
       { name: "hgrc",
         version: "0.0.1",
         dependencies: [["conffile", ">= 0.0.0"]] }],
      "hhvm" =>
      [{ name: "hhvm",
         version: "0.2.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "hhvm",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "hhvm",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "hipchat" => [{ name: "hipchat", version: "0.0.4", dependencies: [] }],
      "hipchat_client" =>
      [{ name: "hipchat_client",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "hipsnip-jetty" =>
      [{ name: "hipsnip-jetty",
         version: "0.9.0",
         dependencies: [["java", ">= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.8.0",
         dependencies: [["java", "= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.7.0",
         dependencies: [["java", "= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.6.0",
         dependencies: [["java", "= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.5.0",
         dependencies: [["java", "= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.4.0",
         dependencies: [["java", "= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.3.0",
         dependencies: [["java", "= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.2.1",
         dependencies: [["java", "= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.2.0",
         dependencies: [["java", "= 1.10.0"]] },
       { name: "hipsnip-jetty",
         version: "0.1.0",
         dependencies: [["java", "= 1.10.0"]] }],
      "hipsnip-mongodb" =>
      [{ name: "hipsnip-mongodb",
         version: "1.1.2",
         dependencies: [["sysctl", ">= 0.3.2"]] },
       { name: "hipsnip-mongodb",
         version: "1.1.1",
         dependencies: [["sysctl", ">= 0.3.2"]] },
       { name: "hipsnip-mongodb",
         version: "1.1.0",
         dependencies: [["sysctl", "~> 0.3.2"]] },
       { name: "hipsnip-mongodb",
         version: "1.0.1",
         dependencies: [["ulimit", "~> 0.1.4"]] },
       { name: "hipsnip-mongodb",
         version: "1.0.0",
         dependencies: [["ulimit", "~> 0.1.4"]] }],
      "hipsnip-s3cmd" =>
      [{ name: "hipsnip-s3cmd", version: "1.0.0", dependencies: [] }],
      "hipsnip-solr" =>
      [{ name: "hipsnip-solr",
         version: "0.5.0",
         dependencies: [["hipsnip-jetty", "~> 0.9.0"]] },
       { name: "hipsnip-solr",
         version: "0.4.3",
         dependencies: [["hipsnip-jetty", "~> 0.9.0"]] },
       { name: "hipsnip-solr",
         version: "0.4.2",
         dependencies: [["hipsnip-jetty", "~> 0.9.0"]] },
       { name: "hipsnip-solr",
         version: "0.4.1",
         dependencies: [["hipsnip-jetty", "~> 0.8.0"]] },
       { name: "hipsnip-solr",
         version: "0.4.0",
         dependencies: [["hipsnip-jetty", "~> 0.8.0"]] },
       { name: "hipsnip-solr",
         version: "0.3.2",
         dependencies: [["hipsnip-jetty", ">= 0.6.0"]] },
       { name: "hipsnip-solr",
         version: "0.3.1",
         dependencies: [["hipsnip-jetty", ">= 0.5.0"]] },
       { name: "hipsnip-solr",
         version: "0.3.0",
         dependencies: [["hipsnip-jetty", ">= 0.4.0"]] },
       { name: "hipsnip-solr",
         version: "0.2.0",
         dependencies: [["hipsnip-jetty", ">= 0.2.1"]] },
       { name: "hipsnip-solr",
         version: "0.1.0",
         dependencies: [["hipsnip-jetty", ">= 0.2.0"]] }],
      "hive" =>
      [{ name: "hive",
         version: "3.0.4",
         dependencies: [["java", ">= 0.0.0"], ["hadoop_cluster", ">= 0.0.0"]] },
       { name: "hive",
         version: "3.0.3",
         dependencies: [["java", ">= 0.0.0"], ["hadoop_cluster", ">= 0.0.0"]] },
       { name: "hive",
         version: "3.0.0",
         dependencies: [["java", ">= 0.0.0"], ["hadoop_cluster", ">= 0.0.0"]] }],
      "hollandbackup" =>
      [{ name: "hollandbackup", version: "0.1.0", dependencies: [] },
       { name: "hollandbackup", version: "0.0.7", dependencies: [] },
       { name: "hollandbackup", version: "0.0.6", dependencies: [] },
       { name: "hollandbackup", version: "0.0.5", dependencies: [] },
       { name: "hollandbackup", version: "0.0.4", dependencies: [] },
       { name: "hollandbackup", version: "0.0.3", dependencies: [] },
       { name: "hollandbackup", version: "0.0.2", dependencies: [] },
       { name: "hollandbackup", version: "0.0.1", dependencies: [] }],
      "homesick" =>
      [{ name: "homesick",
         version: "0.4.0",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "homesick", version: "0.3.2", dependencies: [] },
       { name: "homesick", version: "0.3.0", dependencies: [] },
       { name: "homesick", version: "0.2.2", dependencies: [] },
       { name: "homesick", version: "0.2.0", dependencies: [] }],
      "hostname" =>
      [{ name: "hostname",
         version: "0.1.0",
         dependencies: [["hostsfile", ">= 0.0.0"]] },
       { name: "hostname",
         version: "0.0.6",
         dependencies: [["hostsfile", ">= 0.0.0"]] },
       { name: "hostname",
         version: "0.0.5",
         dependencies: [["hostsfile", ">= 0.0.0"]] },
       { name: "hostname", version: "0.0.4", dependencies: [] },
       { name: "hostname", version: "0.0.3", dependencies: [] },
       { name: "hostname", version: "0.0.2", dependencies: [] },
       { name: "hostname", version: "0.0.1", dependencies: [] }],
      "hosts" => [{ name: "hosts", version: "0.1.1", dependencies: [] }],
      "hosts-awareness" =>
      [{ name: "hosts-awareness", version: "0.0.4", dependencies: [] },
       { name: "hosts-awareness", version: "0.0.3", dependencies: [] }],
      "hostsfile" =>
      [{ name: "hostsfile", version: "2.4.4", dependencies: [] },
       { name: "hostsfile", version: "2.4.3", dependencies: [] },
       { name: "hostsfile", version: "2.4.2", dependencies: [] },
       { name: "hostsfile", version: "2.4.1", dependencies: [] },
       { name: "hostsfile", version: "2.4.0", dependencies: [] },
       { name: "hostsfile", version: "2.0.0", dependencies: [] },
       { name: "hostsfile", version: "1.0.2", dependencies: [] },
       { name: "hostsfile", version: "1.0.1", dependencies: [] },
       { name: "hostsfile", version: "1.0.0", dependencies: [] },
       { name: "hostsfile", version: "0.2.5", dependencies: [] },
       { name: "hostsfile", version: "0.2.4", dependencies: [] },
       { name: "hostsfile", version: "0.2.3", dependencies: [] },
       { name: "hostsfile", version: "0.2.2", dependencies: [] },
       { name: "hostsfile", version: "0.2.1", dependencies: [] },
       { name: "hostsfile", version: "0.2.0", dependencies: [] },
       { name: "hostsfile", version: "0.1.2", dependencies: [] },
       { name: "hostsfile", version: "0.1.1", dependencies: [] },
       { name: "hostsfile", version: "0.1.0", dependencies: [] }],
      "hosts_corrected" =>
      [{ name: "hosts_corrected", version: "1.0.2", dependencies: [] }],
      "hosts_file" =>
      [{ name: "hosts_file", version: "0.2.0", dependencies: [] },
       { name: "hosts_file", version: "0.1.4", dependencies: [] },
       { name: "hosts_file", version: "0.1.2", dependencies: [] },
       { name: "hosts_file", version: "0.1.0", dependencies: [] },
       { name: "hosts_file", version: "0.0.1", dependencies: [] }],
      "hotsauce" => [{ name: "hotsauce", version: "0.1.0", dependencies: [] }],
      "hp-tools" =>
      [{ name: "hp-tools",
         version: "1.0.0",
         dependencies: [["snmp", ">= 0.0.0"]] },
       { name: "hp-tools", version: "0.3.0", dependencies: [] }],
      "htop" =>
      [{ name: "htop", version: "1.2.0", dependencies: [["yum", ">= 0.0.0"]] },
       { name: "htop", version: "1.1.0", dependencies: [["yum", ">= 0.0.0"]] },
       { name: "htop", version: "1.0.0", dependencies: [] }],
      "htpasswd" =>
      [{ name: "htpasswd",
         version: "0.1.2",
         dependencies: [["ruby", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "htpasswd", version: "0.0.3", dependencies: [] },
       { name: "htpasswd", version: "0.0.2", dependencies: [] },
       { name: "htpasswd", version: "0.0.1", dependencies: [] }],
      "httpie" =>
      [{ name: "httpie",
         version: "0.1.0",
         dependencies: [["python", "~> 1.4.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] }],
      "httplivestreamsegmenter" =>
      [{ name: "httplivestreamsegmenter",
         version: "0.0.8",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "httplivestreamsegmenter",
         version: "0.0.7",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "httplivestreamsegmenter",
         version: "0.0.6",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "httplivestreamsegmenter",
         version: "0.0.5",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "httplivestreamsegmenter",
         version: "0.0.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "httplivestreamsegmenter",
         version: "0.0.3",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "httplivestreamsegmenter",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "httplivestreamsegmenter",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "http_deploy" =>
      [{ name: "http_deploy", version: "0.0.2", dependencies: [] },
       { name: "http_deploy", version: "0.0.1", dependencies: [] }],
      "hub" =>
      [{ name: "hub", version: "1.0.4", dependencies: [] },
       { name: "hub", version: "1.0.1", dependencies: [] },
       { name: "hub", version: "1.0.0", dependencies: [] }],
      "hubot" =>
      [{ name: "hubot",
         version: "1.0.2",
         dependencies: [["git", ">= 0.0.0"], ["nodejs", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "hubot",
         version: "1.0.1",
         dependencies: [["git", ">= 0.0.0"], ["nodejs", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "hubot",
         version: "1.0.0",
         dependencies: [["git", ">= 0.0.0"], ["nodejs", ">= 0.0.0"], ["runit", ">= 0.0.0"]] }],
      "hudson" =>
      [{ name: "hudson", version: "0.3.0", dependencies: [] },
       { name: "hudson", version: "0.2.0", dependencies: [] }],
      "hwraid" =>
      [{ name: "hwraid",
         version: "0.3.1",
         dependencies: [["apt", ">= 0.0.0"], ["nagios", ">= 0.0.0"], ["hwraid", ">= 0.0.0"]] },
       { name: "hwraid",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"], ["nagios", ">= 0.0.0"], ["hwraid", ">= 0.0.0"]] },
       { name: "hwraid",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["hwraid", ">= 0.0.0"]] },
       { name: "hwraid",
         version: "0.1.4",
         dependencies: [["apt", ">= 0.0.0"], ["hwraid", ">= 0.0.0"]] },
       { name: "hwraid",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"], ["hwraid", ">= 0.0.0"]] },
       { name: "hwraid",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"], ["hwraid", ">= 0.0.0"]] }],
      "hypertable" =>
      [{ name: "hypertable",
         version: "0.3.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "hypertable",
         version: "0.1.5",
         dependencies: [["iptables", ">= 0.0.0"], ["ulimit", ">= 0.0.0"]] },
       { name: "hypertable",
         version: "0.1.3",
         dependencies: [["iptables", ">= 0.0.0"], ["ulimit", ">= 0.0.0"]] },
       { name: "hypertable",
         version: "0.1.1",
         dependencies: [["iptables", ">= 0.0.0"], ["ulimit", ">= 0.0.0"]] }],
      "i3" => [{ name: "i3", version: "0.0.1", dependencies: [] }],
      "ibm_integration_bus" =>
      [{ name: "ibm_integration_bus", version: "1.0.2", dependencies: [] },
       { name: "ibm_integration_bus", version: "1.0.0", dependencies: [] }],
      "ice" =>
      [{ name: "ice",
         version: "0.2.8",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["artifact", ">= 0.0.0"]] }],
      "icecast2" => [{ name: "icecast2", version: "0.0.1", dependencies: [] }],
      "icinga" =>
      [{ name: "icinga",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "id3lib" => [{ name: "id3lib", version: "0.1.1", dependencies: [] }],
      "idea" =>
      [{ name: "idea", version: "0.1.0", dependencies: [["java", ">= 0.0.0"]] }],
      "iftop" => [{ name: "iftop", version: "0.0.1", dependencies: [] }],
      "iis" =>
      [{ name: "iis", version: "2.1.0", dependencies: [["windows", ">= 1.2.6"]] },
       { name: "iis", version: "2.0.4", dependencies: [["windows", ">= 1.2.6"]] },
       { name: "iis", version: "2.0.2", dependencies: [["windows", ">= 1.2.6"]] },
       { name: "iis", version: "2.0.0", dependencies: [["windows", ">= 1.2.6"]] },
       { name: "iis", version: "1.6.6", dependencies: [["windows", ">= 1.2.6"]] },
       { name: "iis", version: "1.6.4", dependencies: [["windows", ">= 1.2.6"]] },
       { name: "iis", version: "1.6.2", dependencies: [["windows", ">= 1.2.6"]] },
       { name: "iis", version: "1.6.0", dependencies: [["windows", ">= 1.2.6"]] },
       { name: "iis",
         version: "1.5.6",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.5.4",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.5.2",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.5.0",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.4.0",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.3.6",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.3.4",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.3.2",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.3.0",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.2.0",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.1.0",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.0.2",
         dependencies: [["windows", ">= 1.2.6"], ["webpi", ">= 1.0.0"]] },
       { name: "iis",
         version: "1.0.0",
         dependencies: [["windows", ">= 1.0.8"], ["webpi", ">= 1.0.0"]] }],
      "iis_urlrewrite" =>
      [{ name: "iis_urlrewrite",
         version: "1.0.0",
         dependencies: [["iis", ">= 0.0.0"], ["windows", ">= 0.0.0"]] }],
      "imagemagick" =>
      [{ name: "imagemagick", version: "0.2.3", dependencies: [] },
       { name: "imagemagick", version: "0.2.2", dependencies: [] },
       { name: "imagemagick", version: "0.2.0", dependencies: [] },
       { name: "imagemagick", version: "0.1.0", dependencies: [] }],
      "incron" => [{ name: "incron", version: "0.1.0", dependencies: [] }],
      "infochimps_graphite" =>
      [{ name: "infochimps_graphite",
         version: "0.0.6",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["ganglia", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"]] },
       { name: "infochimps_graphite",
         version: "0.0.5",
         dependencies: [["python", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["ganglia", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"]] }],
      "infochimps_statsd" =>
      [{ name: "infochimps_statsd",
         version: "3.0.4",
         dependencies: [["runit", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"],
          ["graphite", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"]] },
       { name: "infochimps_statsd",
         version: "3.0.3",
         dependencies: [["runit", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"],
          ["graphite", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"]] }],
      "install_from" =>
      [{ name: "install_from", version: "3.0.4", dependencies: [] },
       { name: "install_from", version: "3.0.0", dependencies: [] }],
      "instiki" =>
      [{ name: "instiki",
         version: "0.2.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["rails", ">= 0.0.0"]] },
       { name: "instiki",
         version: "0.1.0",
         dependencies: [["rails", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "interfaces" => [{ name: "interfaces", version: "0.0.1", dependencies: [] }],
      "inwx-dns-updater" =>
      [{ name: "inwx-dns-updater",
         version: "1.0.0",
         dependencies: [["application", ">= 0.0.0"]] }],
      "ipaddr_extensions" =>
      [{ name: "ipaddr_extensions", version: "0.3.0", dependencies: [] },
       { name: "ipaddr_extensions", version: "0.1.0", dependencies: [] }],
      "ipf_configure" =>
      [{ name: "ipf_configure",
         version: "0.2.0",
         dependencies: [["ipf", ">= 0.0.0"]] }],
      "ipmitool" =>
      [{ name: "ipmitool", version: "1.1.0", dependencies: [] },
       { name: "ipmitool", version: "1.0.0", dependencies: [] }],
      "ips" => [{ name: "ips", version: "0.0.2", dependencies: [] }],
      "ips-omniti" =>
      [{ name: "ips-omniti",
         version: "0.0.2",
         dependencies: [["ips", ">= 0.0.0"]] }],
      "ipsec" => [{ name: "ipsec", version: "0.1.0", dependencies: [] }],
      "iptables-ng" =>
      [{ name: "iptables-ng", version: "2.1.0", dependencies: [] },
       { name: "iptables-ng", version: "2.0.0", dependencies: [] },
       { name: "iptables-ng", version: "1.1.1", dependencies: [] },
       { name: "iptables-ng", version: "1.1.0", dependencies: [] },
       { name: "iptables-ng", version: "1.0.0", dependencies: [] }],
      "ipxe" =>
      [{ name: "ipxe",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "ircd-ratbox" =>
      [{ name: "ircd-ratbox", version: "0.0.2", dependencies: [] },
       { name: "ircd-ratbox", version: "0.0.1", dependencies: [] }],
      "irssi" =>
      [{ name: "irssi", version: "0.2.0", dependencies: [["yum", ">= 0.0.0"]] },
       { name: "irssi", version: "0.1.1", dependencies: [] }],
      "iscsi" =>
      [{ name: "iscsi",
         version: "0.0.6",
         dependencies: [["multipath", ">= 0.0.0"], ["el-sysctl", ">= 0.0.0"]] },
       { name: "iscsi",
         version: "0.0.5",
         dependencies: [["multipath", ">= 0.0.0"], ["el-sysctl", ">= 0.0.0"]] },
       { name: "iscsi",
         version: "0.0.4",
         dependencies: [["multipath", ">= 0.0.0"], ["el-sysctl", ">= 0.0.0"]] }],
      "isomounter" =>
      [{ name: "isomounter", version: "0.1.1", dependencies: [] },
       { name: "isomounter", version: "0.1.0", dependencies: [] },
       { name: "isomounter", version: "0.0.4", dependencies: [] }],
      "iterm2" =>
      [{ name: "iterm2",
         version: "1.3.0",
         dependencies: [["mac_os_x", ">= 0.0.0"], ["homebrew", ">= 0.0.0"]] },
       { name: "iterm2",
         version: "1.2.0",
         dependencies: [["mac_os_x", ">= 0.0.0"], ["homebrew", ">= 0.0.0"]] },
       { name: "iterm2", version: "1.1.0", dependencies: [] },
       { name: "iterm2", version: "1.0.3", dependencies: [] },
       { name: "iterm2", version: "1.0.1", dependencies: [] },
       { name: "iterm2", version: "1.0.0", dependencies: [] },
       { name: "iterm2", version: "0.0.1", dependencies: [] }],
      "jabber" =>
      [{ name: "jabber",
         version: "0.0.2",
         dependencies: [["erlang", ">= 0.0.0"]] }],
      "jahia" =>
      [{ name: "jahia",
         version: "0.1.0",
         dependencies: [["firewall", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["maven", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] }],
      "janitor" =>
      [{ name: "janitor", version: "1.0.3", dependencies: [] },
       { name: "janitor", version: "1.0.1", dependencies: [] },
       { name: "janitor", version: "1.0.0", dependencies: [] },
       { name: "janitor", version: "0.0.5", dependencies: [] }],
      "java-libraries" =>
      [{ name: "java-libraries", version: "0.1.0", dependencies: [] }],
      "java-management" =>
      [{ name: "java-management",
         version: "1.0.2",
         dependencies: [["java", ">= 0.0.0"]] }],
      "javamonitor" =>
      [{ name: "javamonitor",
         version: "0.7.0",
         dependencies: [["webobjects", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "java_sun" =>
      [{ name: "java_sun",
         version: "0.10.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "java_sun", version: "0.9.2", dependencies: [] },
       { name: "java_sun", version: "0.9.1", dependencies: [] }],
      "java_wrapper" =>
      [{ name: "java_wrapper", version: "0.1.0", dependencies: [] },
       { name: "java_wrapper", version: "0.0.28", dependencies: [] },
       { name: "java_wrapper", version: "0.0.27", dependencies: [] },
       { name: "java_wrapper", version: "0.0.26", dependencies: [] },
       { name: "java_wrapper", version: "0.0.25", dependencies: [] },
       { name: "java_wrapper", version: "0.0.24", dependencies: [] },
       { name: "java_wrapper", version: "0.0.23", dependencies: [] },
       { name: "java_wrapper", version: "0.0.22", dependencies: [] },
       { name: "java_wrapper", version: "0.0.21", dependencies: [] },
       { name: "java_wrapper", version: "0.0.20", dependencies: [] },
       { name: "java_wrapper", version: "0.0.19", dependencies: [] },
       { name: "java_wrapper", version: "0.0.18", dependencies: [] },
       { name: "java_wrapper", version: "0.0.17", dependencies: [] },
       { name: "java_wrapper", version: "0.0.16", dependencies: [] }],
      "jboss" =>
      [{ name: "jboss", version: "0.0.3", dependencies: [["java", ">= 0.0.0"]] }],
      "jboss-atg" =>
      [{ name: "jboss-atg",
         version: "0.0.3",
         dependencies: [["java", ">= 0.0.0"]] }],
      "jekyll" =>
      [{ name: "jekyll",
         version: "0.1.0",
         dependencies: [["rbenv", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "jellyfish" =>
      [{ name: "jellyfish",
         version: "0.1.1",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "jellyfish",
         version: "0.1.0",
         dependencies: [["python", ">= 0.0.0"]] }],
      "jemalloc" =>
      [{ name: "jemalloc", version: "0.1.1", dependencies: [] },
       { name: "jemalloc", version: "0.1.0", dependencies: [] }],
      "jenkins_build" =>
      [{ name: "jenkins_build",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["postgresql", "> 2.4.1"],
          ["jenkins", "> 0.8.0"],
          ["nodejs", ">= 0.0.0"],
          ["phantomjs", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["database", ">= 0.0.0"]] },
       { name: "jenkins_build",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["jenkins", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"],
          ["phantomjs", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["database", ">= 0.0.0"]] },
       { name: "jenkins_build",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["jenkins", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"],
          ["phantomjs", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] }],
      "jently" =>
      [{ name: "jently",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"], ["passenger_apache2", ">= 0.0.0"]] }],
      "jetty" =>
      [{ name: "jetty",
         version: "0.1.2",
         dependencies: [["java", ">= 0.0.0"],
          ["jpackage", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "jetty",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"],
          ["jpackage", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "jetty",
         version: "0.0.1",
         dependencies: [["java", ">= 0.0.0"], ["jpackage", ">= 0.0.0"]] }],
      "jira" =>
      [{ name: "jira",
         version: "0.9.2",
         dependencies: [["java", ">= 0.0.0"], ["apache2", ">= 0.0.0"], ["runit", "<= 0.16.2"]] },
       { name: "jira",
         version: "0.9.0",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "jira",
         version: "0.8.2",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "jira",
         version: "0.7.0",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "jmxtrans" =>
      [{ name: "jmxtrans",
         version: "0.0.3",
         dependencies: [["ark", ">= 0.0.0"], ["logrotate", ">= 0.0.0"]] }],
      "jn_hosts" =>
      [{ name: "jn_hosts", version: "0.0.4", dependencies: [] },
       { name: "jn_hosts", version: "0.0.1", dependencies: [] }],
      "jn_sysctl" =>
      [{ name: "jn_sysctl",
         version: "2.0.1",
         dependencies: [["accumulator", ">= 0.0.0"]] },
       { name: "jn_sysctl",
         version: "2.0.0",
         dependencies: [["accumulator", ">= 0.0.0"]] },
       { name: "jn_sysctl", version: "1.2.1", dependencies: [] },
       { name: "jn_sysctl", version: "1.2.0", dependencies: [] },
       { name: "jn_sysctl", version: "1.1.0", dependencies: [] },
       { name: "jn_sysctl", version: "1.0.2", dependencies: [] }],
      "joe" => [{ name: "joe", version: "1.0.0", dependencies: [] }],
      "jolicode-php" =>
      [{ name: "jolicode-php",
         version: "1.1.0",
         dependencies: [["yum", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "jolicode-php", version: "1.0.0", dependencies: [] }],
      "jones" =>
      [{ name: "jones",
         version: "1.0.0",
         dependencies: [["python", ">= 0.0.0"],
          ["nginx_conf", ">= 0.0.0"],
          ["zookeeper", ">= 0.0.0"],
          ["application", ">= 0.0.0"],
          ["application_python", ">= 0.0.0"]] }],
      "jruby" =>
      [{ name: "jruby",
         version: "0.2.5",
         dependencies: [["java", ">= 0.0.0"], ["install_from", ">= 0.0.0"]] },
       { name: "jruby",
         version: "0.2.4",
         dependencies: [["java", ">= 0.0.0"], ["install_from", ">= 0.0.0"]] },
       { name: "jruby",
         version: "0.2.3",
         dependencies: [["java", ">= 0.0.0"], ["install_from", ">= 0.0.0"]] },
       { name: "jruby",
         version: "0.2.2",
         dependencies: [["java", ">= 0.0.0"], ["install_from", ">= 0.0.0"]] },
       { name: "jruby", version: "0.2.0", dependencies: [["java", ">= 0.0.0"]] },
       { name: "jruby", version: "0.1.0", dependencies: [["java", ">= 0.0.0"]] },
       { name: "jruby", version: "0.0.1", dependencies: [["java", ">= 0.0.0"]] }],
      "js" =>
      [{ name: "js", version: "0.0.8", dependencies: [] },
       { name: "js", version: "0.0.6", dependencies: [] }],
      "jungledisk" =>
      [{ name: "jungledisk", version: "0.0.2", dependencies: [] },
       { name: "jungledisk", version: "0.0.1", dependencies: [] }],
      "kafka" =>
      [{ name: "kafka",
         version: "1.0.20",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"], ["zookeeper", ">= 0.0.0"]] },
       { name: "kafka",
         version: "1.0.17",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"], ["zookeeper", ">= 0.0.0"]] },
       { name: "kafka",
         version: "1.0.11",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"], ["zookeeper", ">= 0.0.0"]] },
       { name: "kafka",
         version: "1.0.8",
         dependencies: [["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["zookeeper", ">= 0.0.0"]] }],
      "kafka_broker" =>
      [{ name: "kafka_broker",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "kaltura" =>
      [{ name: "kaltura", version: "0.6.0", dependencies: [] },
       { name: "kaltura", version: "0.5.0", dependencies: [] },
       { name: "kaltura", version: "0.4.0", dependencies: [] },
       { name: "kaltura", version: "0.3.0", dependencies: [] },
       { name: "kaltura", version: "0.2.0", dependencies: [] },
       { name: "kaltura", version: "0.1.0", dependencies: [] }],
      "keepalived" =>
      [{ name: "keepalived", version: "1.2.0", dependencies: [] },
       { name: "keepalived", version: "1.1.0", dependencies: [] },
       { name: "keepalived", version: "1.0.4", dependencies: [] },
       { name: "keepalived", version: "1.0.2", dependencies: [] },
       { name: "keepalived", version: "1.0.0", dependencies: [] },
       { name: "keepalived", version: "0.7.0", dependencies: [] }],
      "kerl" => [{ name: "kerl", version: "0.0.1", dependencies: [] }],
      "kernel" => [{ name: "kernel", version: "0.0.2", dependencies: [] }],
      "kernel_vm" => [{ name: "kernel_vm", version: "0.0.1", dependencies: [] }],
      "kickstart" =>
      [{ name: "kickstart",
         version: "0.4.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "kickstart",
         version: "0.3.2",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "kickstart",
         version: "0.2.0",
         dependencies: [["apache2", ">= 0.0.0"]] }],
      "kismet" =>
      [{ name: "kismet", version: "0.2.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "kismet", version: "0.1.0", dependencies: [["apt", ">= 0.0.0"]] }],
      "kitchen-jenkins" =>
      [{ name: "kitchen-jenkins",
         version: "0.1.0",
         dependencies: [["virtualbox", ">= 0.0.0"],
          ["vagrant", ">= 0.2.0"],
          ["jenkins", ">= 0.0.0"]] }],
      "known_host" =>
      [{ name: "known_host", version: "0.1.3", dependencies: [] },
       { name: "known_host", version: "0.1.2", dependencies: [] },
       { name: "known_host", version: "0.1.1", dependencies: [] },
       { name: "known_host", version: "0.1.0", dependencies: [] }],
      "koha" => [{ name: "koha", version: "0.0.1", dependencies: [] }],
      "komodo-edit" =>
      [{ name: "komodo-edit",
         version: "0.1.3",
         dependencies: [["windows", ">= 1.2.6"], ["apt", ">= 0.0.0"]] },
       { name: "komodo-edit",
         version: "0.1.1",
         dependencies: [["windows", ">= 1.2.6"], ["apt", ">= 0.0.0"]] }],
      "krb5" =>
      [{ name: "krb5", version: "0.2.0", dependencies: [] },
       { name: "krb5", version: "0.1.0", dependencies: [["ntp", ">= 0.0.0"]] },
       { name: "krb5", version: "0.0.7", dependencies: [["ntp", ">= 0.0.0"]] },
       { name: "krb5", version: "0.0.6", dependencies: [["ntp", ">= 0.0.0"]] },
       { name: "krb5", version: "0.0.2", dependencies: [] }],
      "kronos" =>
      [{ name: "kronos",
         version: "1.0.1",
         dependencies: [["reginjector", ">= 0.1.0"]] },
       { name: "kronos",
         version: "0.2.4",
         dependencies: [["reginjector", ">= 0.1.0"]] },
       { name: "kronos",
         version: "0.1.8",
         dependencies: [["reginjector", ">= 0.1.0"]] },
       { name: "kronos", version: "0.1.4", dependencies: [] },
       { name: "kronos", version: "0.1.1", dependencies: [] },
       { name: "kronos", version: "0.0.5", dependencies: [] }],
      "kvm" =>
      [{ name: "kvm",
         version: "0.3.1",
         dependencies: [["ntp", ">= 1.2.0"],
          ["sysctl", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["sysfs", ">= 0.0.0"],
          ["cpu", ">= 0.0.0"]] },
       { name: "kvm",
         version: "0.2.1",
         dependencies: [["ntp", ">= 1.2.0"],
          ["sysctl", ">= 0.0.0"],
          ["modules", ">= 0.0.0"],
          ["sysfs", ">= 0.0.0"],
          ["cpu", ">= 0.0.0"]] },
       { name: "kvm", version: "0.2.0", dependencies: [["ntp", ">= 1.2.0"]] },
       { name: "kvm",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["sysctl", ">= 0.0.0"], ["modules", ">= 0.0.0"]] }],
      "laravel" =>
      [{ name: "laravel",
         version: "1.0.0",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["composer", ">= 0.0.0"]] }],
      "latex" => [{ name: "latex", version: "0.0.1", dependencies: [] }],
      "ldap" => [{ name: "ldap", version: "0.1.0", dependencies: [] }],
      "ldapknife" =>
      [{ name: "ldapknife",
         version: "0.0.22",
         dependencies: [["perl", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "ldapknife",
         version: "0.0.20",
         dependencies: [["perl", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "ldapknife",
         version: "0.0.18",
         dependencies: [["perl", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "ldapknife",
         version: "0.0.16",
         dependencies: [["perl", ">= 0.0.0"], ["yumrepo", ">= 0.0.0"]] },
       { name: "ldapknife",
         version: "0.0.14",
         dependencies: [["perl", ">= 0.0.0"], ["yumrepo", ">= 0.0.0"]] },
       { name: "ldapknife",
         version: "0.0.12",
         dependencies: [["perl", ">= 0.0.0"], ["yumrepo", ">= 0.0.0"]] },
       { name: "ldapknife",
         version: "0.0.10",
         dependencies: [["perl", ">= 0.0.0"], ["yumrepo", ">= 0.0.0"]] },
       { name: "ldapknife",
         version: "0.0.8",
         dependencies: [["perl", ">= 0.0.0"], ["yumrepo", ">= 0.0.0"]] },
       { name: "ldapknife",
         version: "0.0.6",
         dependencies: [["perl", ">= 0.0.0"], ["yumrepo", ">= 0.0.0"]] }],
      "leiningen" =>
      [{ name: "leiningen",
         version: "0.2.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "leiningen", version: "0.1.0", dependencies: [] }],
      "lesscss" =>
      [{ name: "lesscss",
         version: "0.0.1",
         dependencies: [["npm", ">= 0.0.0"]] }],
      "libarchive" =>
      [{ name: "libarchive", version: "0.2.0", dependencies: [] },
       { name: "libarchive", version: "0.1.0", dependencies: [] }],
      "libev" =>
      [{ name: "libev",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "libevent" =>
      [{ name: "libevent",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "libfdk_aac" =>
      [{ name: "libfdk_aac",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "libguestfs" =>
      [{ name: "libguestfs",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "libmemcached" =>
      [{ name: "libmemcached",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "libqrencode" => [{ name: "libqrencode", version: "3.4.2", dependencies: [] }],
      "libqt4" =>
      [{ name: "libqt4",
         version: "0.1.0",
         dependencies: [["cmake", ">= 0.0.0"]] }],
      "librato_metrics" =>
      [{ name: "librato_metrics", version: "0.3.0", dependencies: [] },
       { name: "librato_metrics", version: "0.2.0", dependencies: [] },
       { name: "librato_metrics", version: "0.1.0", dependencies: [] }],
      "libreoffice" =>
      [{ name: "libreoffice",
         version: "0.0.2",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "libvirt" =>
      [{ name: "libvirt",
         version: "0.1.0",
         dependencies: [["apparmor", ">= 0.0.0"]] }],
      "libvpx" =>
      [{ name: "libvpx",
         version: "0.3.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "libvpx",
         version: "0.3.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "libvpx",
         version: "0.3.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "libvpx",
         version: "0.2.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "libvpx",
         version: "0.1.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "libvpx",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "libvpx",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "libyaml" =>
      [{ name: "libyaml",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] }],
      "lighttpd" => [{ name: "lighttpd", version: "0.1.0", dependencies: [] }],
      "line" =>
      [{ name: "line", version: "0.5.1", dependencies: [] },
       { name: "line", version: "0.5.0", dependencies: [] },
       { name: "line", version: "0.4.4", dependencies: [] },
       { name: "line", version: "0.4.2", dependencies: [] },
       { name: "line", version: "0.4.1", dependencies: [] },
       { name: "line", version: "0.4.0", dependencies: [] },
       { name: "line", version: "0.3.1", dependencies: [] },
       { name: "line", version: "0.3.0", dependencies: [] },
       { name: "line", version: "0.2.10", dependencies: [] },
       { name: "line", version: "0.2.9", dependencies: [] },
       { name: "line", version: "0.2.8", dependencies: [] },
       { name: "line", version: "0.2.7", dependencies: [] },
       { name: "line", version: "0.2.6", dependencies: [] },
       { name: "line", version: "0.2.5", dependencies: [] },
       { name: "line", version: "0.2.4", dependencies: [] },
       { name: "line", version: "0.2.3", dependencies: [] },
       { name: "line", version: "0.1.2", dependencies: [] },
       { name: "line", version: "0.1.1", dependencies: [] },
       { name: "line", version: "0.1.0", dependencies: [] },
       { name: "line", version: "0.0.1", dependencies: [] }],
      "links" => [{ name: "links", version: "0.1.1", dependencies: [] }],
      "linode" =>
      [{ name: "linode", version: "1.2.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "linode", version: "1.0.6", dependencies: [] },
       { name: "linode", version: "1.0.5", dependencies: [] },
       { name: "linode", version: "1.0.4", dependencies: [] },
       { name: "linode", version: "1.0.3", dependencies: [] },
       { name: "linode", version: "1.0.2", dependencies: [] },
       { name: "linode", version: "1.0.1", dependencies: [] },
       { name: "linode", version: "1.0.0", dependencies: [] }],
      "linux-dev-env" =>
      [{ name: "linux-dev-env", version: "0.0.10", dependencies: [] }],
      "linux-gamer" =>
      [{ name: "linux-gamer",
         version: "0.0.10",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "linux-gamer",
         version: "0.0.8",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "linux-gamer",
         version: "0.0.6",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "linux-gamer",
         version: "0.0.4",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "liquibase" =>
      [{ name: "liquibase",
         version: "0.3.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "liquibase",
         version: "0.2.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "liquibase",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "liquibase",
         version: "0.0.1",
         dependencies: [["java", ">= 0.0.0"]] }],
      "liquid-feedback" =>
      [{ name: "liquid-feedback",
         version: "1.1.0",
         dependencies: [["postgresql", ">= 0.0.0"],
          ["mercurial", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["database", ">= 0.0.0"]] },
       { name: "liquid-feedback",
         version: "1.0.0",
         dependencies: [["database", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["mercurial", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] }],
      "liverebel" =>
      [{ name: "liverebel", version: "0.1.1", dependencies: [] },
       { name: "liverebel", version: "0.1.0", dependencies: [] },
       { name: "liverebel", version: "0.0.9", dependencies: [] }],
      "lldpd" => [{ name: "lldpd", version: "1.0.0", dependencies: [] }],
      "lmctfy" =>
      [{ name: "lmctfy",
         version: "0.2.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["control_groups", ">= 0.0.0"],
          ["gflags", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["protobuf", ">= 0.0.0"],
          ["re2", ">= 0.0.0"]] },
       { name: "lmctfy",
         version: "0.2.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["control_groups", ">= 0.0.0"],
          ["gflags", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["protobuf", ">= 0.0.0"],
          ["re2", ">= 0.0.0"]] },
       { name: "lmctfy",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["control_groups", ">= 0.0.0"],
          ["gflags", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["protobuf", ">= 0.0.0"],
          ["re2", ">= 0.0.0"]] },
       { name: "lmctfy",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["control_groups", ">= 0.0.0"],
          ["gflags", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["protobuf", ">= 0.0.0"],
          ["re2", ">= 0.0.0"]] }],
      "locale" =>
      [{ name: "locale", version: "0.0.2", dependencies: [] },
       { name: "locale", version: "0.0.1", dependencies: [] }],
      "locale-gen" => [{ name: "locale-gen", version: "0.0.1", dependencies: [] }],
      "locales" =>
      [{ name: "locales", version: "0.2.2", dependencies: [] },
       { name: "locales", version: "0.1.1", dependencies: [] },
       { name: "locales", version: "0.1.0", dependencies: [] }],
      "local_template" =>
      [{ name: "local_template", version: "0.0.1", dependencies: [] }],
      "loco_xvfb" => [{ name: "loco_xvfb", version: "0.3.0", dependencies: [] }],
      "logadm" =>
      [{ name: "logadm", version: "0.2.0", dependencies: [] },
       { name: "logadm", version: "0.1.1", dependencies: [] }],
      "logentries" =>
      [{ name: "logentries",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "logentries",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "logentries-rsyslog" =>
      [{ name: "logentries-rsyslog",
         version: "1.0.0",
         dependencies: [["rsyslog", "~> 1.5.0"]] }],
      "loggly" =>
      [{ name: "loggly", version: "0.1.1", dependencies: [] },
       { name: "loggly", version: "0.1.0", dependencies: [] },
       { name: "loggly", version: "0.0.3", dependencies: [] },
       { name: "loggly", version: "0.0.2", dependencies: [] }],
      "loggly-rsyslog" =>
      [{ name: "loggly-rsyslog",
         version: "1.0.0",
         dependencies: [["rsyslog", "~> 1.5.0"]] }],
      "logstash_forwarder" =>
      [{ name: "logstash_forwarder",
         version: "1.0.7",
         dependencies: [["sensu_spec", "~> 0.2"]] },
       { name: "logstash_forwarder",
         version: "1.0.6",
         dependencies: [["sensu_spec", "~> 0.2"]] },
       { name: "logstash_forwarder",
         version: "1.0.5",
         dependencies: [["sensu_spec", "~> 0.2"]] },
       { name: "logstash_forwarder",
         version: "1.0.3",
         dependencies: [["sensu_spec", "~> 0.2"]] },
       { name: "logstash_forwarder",
         version: "1.0.1",
         dependencies: [["sensu_spec", "~> 0.2"]] }],
      "logster" =>
      [{ name: "logster", version: "0.0.3", dependencies: [["git", ">= 0.0.0"]] },
       { name: "logster",
         version: "0.0.2",
         dependencies: [["git", ">= 0.0.0"]] }],
      "logwatch" =>
      [{ name: "logwatch", version: "1.1.0", dependencies: [["perl", "~> 1.2"]] },
       { name: "logwatch",
         version: "1.0.2",
         dependencies: [["perl", ">= 0.0.0"]] },
       { name: "logwatch",
         version: "1.0.0",
         dependencies: [["perl", ">= 0.0.0"]] },
       { name: "logwatch",
         version: "0.1.0",
         dependencies: [["perl", ">= 0.0.0"]] }],
      "log_rotations" =>
      [{ name: "log_rotations",
         version: "0.0.1",
         dependencies: [["logrotate", ">= 0.0.0"]] }],
      "lshw" =>
      [{ name: "lshw",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "lshw",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "lshw",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "lsyncd" =>
      [{ name: "lsyncd", version: "0.2.0", dependencies: [["yum", "~> 3.0.0"]] },
       { name: "lsyncd", version: "0.1.2", dependencies: [] },
       { name: "lsyncd", version: "0.1.0", dependencies: [["yum", ">= 0.0.0"]] }],
      "lumenvox" =>
      [{ name: "lumenvox",
         version: "0.1.1",
         dependencies: [["yum", ">= 0.0.0"], ["yum-repoforge", ">= 0.0.0"]] },
       { name: "lumenvox",
         version: "0.1.0",
         dependencies: [["yum", ">= 0.0.0"], ["yum-repoforge", ">= 0.0.0"]] }],
      "lv" => [{ name: "lv", version: "0.2.0", dependencies: [] }],
      "lvm" =>
      [{ name: "lvm", version: "1.0.8", dependencies: [] },
       { name: "lvm", version: "1.0.4", dependencies: [] },
       { name: "lvm", version: "1.0.2", dependencies: [] },
       { name: "lvm", version: "1.0.0", dependencies: [] },
       { name: "lvm", version: "0.8.12", dependencies: [] },
       { name: "lvm", version: "0.8.10", dependencies: [] },
       { name: "lvm", version: "0.8.8", dependencies: [] },
       { name: "lvm", version: "0.8.6", dependencies: [] },
       { name: "lvm", version: "0.8.4", dependencies: [] },
       { name: "lvm", version: "0.8.2", dependencies: [] },
       { name: "lvm", version: "0.7.0", dependencies: [] }],
      "lxc" =>
      [{ name: "lxc",
         version: "1.1.8",
         dependencies: [["dpkg_autostart", "~> 0.1.10"]] },
       { name: "lxc",
         version: "1.1.6",
         dependencies: [["dpkg_autostart", "~> 0.1.10"]] },
       { name: "lxc",
         version: "1.1.4",
         dependencies: [["dpkg_autostart", "~> 0.1.6"]] },
       { name: "lxc",
         version: "1.1.2",
         dependencies: [["dpkg_autostart", "~> 0.1.6"]] },
       { name: "lxc",
         version: "1.1.0",
         dependencies: [["dpkg_autostart", "~> 0.1.6"]] },
       { name: "lxc", version: "1.0.0", dependencies: [] },
       { name: "lxc",
         version: "0.1.0",
         dependencies: [["omnibus_updater", ">= 0.0.0"]] },
       { name: "lxc",
         version: "0.0.3",
         dependencies: [["omnibus_updater", ">= 0.0.0"]] },
       { name: "lxc",
         version: "0.0.2",
         dependencies: [["omnibus_updater", ">= 0.0.0"]] },
       { name: "lxc",
         version: "0.0.1",
         dependencies: [["omnibus_updater", ">= 0.0.0"]] }],
      "lxmx_hostname" =>
      [{ name: "lxmx_hostname",
         version: "0.3.6",
         dependencies: [["hostsfile", ">= 0.0.0"]] },
       { name: "lxmx_hostname",
         version: "0.3.5",
         dependencies: [["hostsfile", ">= 0.0.0"]] }],
      "lxmx_oh_my_zsh" =>
      [{ name: "lxmx_oh_my_zsh",
         version: "0.5.0",
         dependencies: [["user", ">= 0.0.0"], ["ark", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] },
       { name: "lxmx_oh_my_zsh",
         version: "0.4.1",
         dependencies: [["user", ">= 0.0.0"], ["ark", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] },
       { name: "lxmx_oh_my_zsh",
         version: "0.4.0",
         dependencies: [["user", ">= 0.0.0"], ["ark", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] }],
      "macapps" =>
      [{ name: "macapps", version: "1.0.2", dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "macapps",
         version: "1.0.0",
         dependencies: [["dmg", ">= 0.0.0"]] }],
      "machine_tag" =>
      [{ name: "machine_tag", version: "1.0.4", dependencies: [] },
       { name: "machine_tag", version: "1.0.3", dependencies: [] },
       { name: "machine_tag", version: "1.0.2", dependencies: [] },
       { name: "machine_tag", version: "1.0.1", dependencies: [] },
       { name: "machine_tag", version: "1.0.0", dependencies: [] }],
      "macoffice" =>
      [{ name: "macoffice",
         version: "1.0.0",
         dependencies: [["dmg", ">= 0.0.0"]] }],
      "macports" =>
      [{ name: "macports",
         version: "1.0.0",
         dependencies: [["dmg", ">= 0.0.0"]] }],
      "mac_os_x" =>
      [{ name: "mac_os_x", version: "1.4.4", dependencies: [] },
       { name: "mac_os_x", version: "1.4.2", dependencies: [] },
       { name: "mac_os_x", version: "1.4.0", dependencies: [] },
       { name: "mac_os_x", version: "1.3.6", dependencies: [] },
       { name: "mac_os_x", version: "1.3.4", dependencies: [] },
       { name: "mac_os_x", version: "1.3.2", dependencies: [] },
       { name: "mac_os_x", version: "1.3.0", dependencies: [] },
       { name: "mac_os_x", version: "1.2.2", dependencies: [] },
       { name: "mac_os_x", version: "1.2.0", dependencies: [] },
       { name: "mac_os_x", version: "1.0.0", dependencies: [] }],
      "magento" =>
      [{ name: "magento",
         version: "0.6.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.4.1"]] },
       { name: "magento",
         version: "0.6.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.4.1"]] },
       { name: "magento",
         version: "0.5.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.4.1"]] },
       { name: "magento",
         version: "0.4.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.0.0"]] },
       { name: "magento",
         version: "0.3.1",
         dependencies: [["php", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "magento",
         version: "0.3.0",
         dependencies: [["php", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "magento-toolbox" =>
      [{ name: "magento-toolbox",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "magento-toolbox",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"]] }],
      "magic_shell" =>
      [{ name: "magic_shell", version: "1.0.0", dependencies: [] },
       { name: "magic_shell", version: "0.3.2", dependencies: [] },
       { name: "magic_shell", version: "0.3.1", dependencies: [] },
       { name: "magic_shell", version: "0.3.0", dependencies: [] },
       { name: "magic_shell", version: "0.2.0", dependencies: [] },
       { name: "magic_shell", version: "0.1.5", dependencies: [] },
       { name: "magic_shell", version: "0.1.4", dependencies: [] },
       { name: "magic_shell", version: "0.1.3", dependencies: [] },
       { name: "magic_shell", version: "0.1.2", dependencies: [] },
       { name: "magic_shell", version: "0.1.1", dependencies: [] },
       { name: "magic_shell", version: "0.1.0", dependencies: [] }],
      "mailcatcher" => [{ name: "mailcatcher", version: "0.1.0", dependencies: [] }],
      "mailman" =>
      [{ name: "mailman",
         version: "0.9.6",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "mailman",
         version: "0.9.5",
         dependencies: [["openssl", ">= 0.0.0"]] }],
      "mail_alias" =>
      [{ name: "mail_alias",
         version: "0.1.0",
         dependencies: [["minitest-handler", ">= 0.0.0"]] }],
      "man" => [{ name: "man", version: "0.7.0", dependencies: [] }],
      "mandrel" =>
      [{ name: "mandrel",
         version: "0.2.0",
         dependencies: [["python", ">= 0.0.0"]] }],
      "maradns" =>
      [{ name: "maradns", version: "0.8.1", dependencies: [] },
       { name: "maradns", version: "0.7.0", dependencies: [] }],
      "marathon" =>
      [{ name: "marathon",
         version: "1.0.1",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["mesos", ">= 0.0.0"]] },
       { name: "marathon",
         version: "1.0.0",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["mesos", ">= 0.0.0"]] }],
      "marker" => [{ name: "marker", version: "1.0.0", dependencies: [] }],
      "mater" =>
      [{ name: "mater",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"], ["git", ">= 0.0.0"], ["unicorn", ">= 0.0.0"]] }],
      "maven" =>
      [{ name: "maven",
         version: "1.1.0",
         dependencies: [["ark", "~> 0.4"], ["java", "~> 1.13"]] },
       { name: "maven",
         version: "1.0.0",
         dependencies: [["ark", "~> 0.4"], ["java", "~> 1.13"]] },
       { name: "maven",
         version: "0.16.4",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.16.2",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.16.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.15.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.14.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.13.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.12.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.11.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.3.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "maven", version: "0.2.0", dependencies: [["java", ">= 0.0.0"]] },
       { name: "maven",
         version: "0.10.0",
         dependencies: [["java", ">= 0.0.0"], ["jpackage", ">= 0.0.0"]] }],
      "mcelog" =>
      [{ name: "mcelog", version: "0.1.3", dependencies: [] },
       { name: "mcelog", version: "0.1.2", dependencies: [] }],
      "mcollective" =>
      [{ name: "mcollective",
         version: "0.14.2",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.14.1",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.14.0",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.12.1",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.12.0",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.11.0",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.10.2",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.9.1",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.9.0",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.10",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.9",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.8",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.7",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.6",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.5",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.4",
         dependencies: [["chef_handler", ">= 1.0.4"], ["apt", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.3",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "mcollective",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "mdadm" =>
      [{ name: "mdadm", version: "1.0.1", dependencies: [] },
       { name: "mdadm", version: "1.0.0", dependencies: [] }],
      "media" =>
      [{ name: "media",
         version: "1.1.2",
         dependencies: [["nfs", ">= 0.0.0"], ["minidlna", ">= 0.0.0"]] },
       { name: "media",
         version: "1.1.1",
         dependencies: [["nfs", ">= 0.0.0"], ["minidlna", ">= 0.0.0"]] },
       { name: "media",
         version: "1.1.0",
         dependencies: [["nfs", ">= 0.0.0"], ["minidlna", ">= 0.0.0"]] },
       { name: "media",
         version: "1.0.0",
         dependencies: [["nfs", ">= 0.0.0"], ["minidlna", ">= 0.0.0"]] },
       { name: "media", version: "0.1.1", dependencies: [["nfs", ">= 0.0.0"]] },
       { name: "media", version: "0.1.0", dependencies: [["nfs", ">= 0.0.0"]] }],
      "mediacore" =>
      [{ name: "mediacore",
         version: "0.2.2",
         dependencies: [["python", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["database", ">= 0.0.0"]] },
       { name: "mediacore",
         version: "0.2.1",
         dependencies: [["python", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["supervisor", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["database", ">= 0.0.0"]] }],
      "memcached" =>
      [{ name: "memcached",
         version: "1.7.2",
         dependencies: [["runit", "~> 1.0"], ["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.7.0",
         dependencies: [["runit", "~> 1.0"], ["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.6.6",
         dependencies: [["runit", "~> 1.0"], ["yum", "< 3.0.0"]] },
       { name: "memcached",
         version: "1.6.4",
         dependencies: [["runit", "~> 1.0"], ["yum", "< 3.0.0"]] },
       { name: "memcached",
         version: "1.6.2",
         dependencies: [["runit", "~> 1.0"], ["yum", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.6.0",
         dependencies: [["runit", "~> 1.0"], ["yum", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.5.0",
         dependencies: [["runit", "~> 1.0"], ["yum", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.4.0",
         dependencies: [["runit", "~> 1.0"], ["yum", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.3.0",
         dependencies: [["runit", "~> 1.0"], ["yum", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.2.0",
         dependencies: [["runit", "<= 0.16.2"], ["yum", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.1.2",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.1.0",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.0.4",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.0.2",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "memcached",
         version: "1.0.0",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "memcached",
         version: "0.10.4",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "memcached",
         version: "0.10.3",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "memcached",
         version: "0.10.2",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "memcached",
         version: "0.8.0",
         dependencies: [["runit", ">= 0.0.0"]] }],
      "mercurial" =>
      [{ name: "mercurial",
         version: "2.0.4",
         dependencies: [["windows", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "mercurial",
         version: "2.0.2",
         dependencies: [["windows", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "mercurial",
         version: "2.0.0",
         dependencies: [["windows", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "mercurial",
         version: "1.1.4",
         dependencies: [["windows", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "mercurial",
         version: "1.1.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "mercurial",
         version: "1.1.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "mercurial", version: "0.8.0", dependencies: [] },
       { name: "mercurial", version: "0.7.0", dependencies: [] }],
      "mesos" =>
      [{ name: "mesos",
         version: "1.0.6",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"],
          ["yum", "~> 3.0"]] },
       { name: "mesos",
         version: "1.0.5",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"],
          ["yum", "~> 3.0"]] },
       { name: "mesos",
         version: "1.0.4",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"]] },
       { name: "mesos",
         version: "1.0.3",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"]] },
       { name: "mesos",
         version: "1.0.2",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"]] },
       { name: "mesos",
         version: "1.0.1",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"]] },
       { name: "mesos",
         version: "1.0.0",
         dependencies: [["zookeeper", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["docker", ">= 0.0.0"]] }],
      "metachef" => [{ name: "metachef", version: "3.0.4", dependencies: [] }],
      "metarepo" =>
      [{ name: "metarepo",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"],
          ["ubuntu", ">= 0.0.0"],
          ["ruby_installer", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["redis", ">= 0.0.0"]] }],
      "meteor" =>
      [{ name: "meteor",
         version: "0.1.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] },
       { name: "meteor",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] },
       { name: "meteor",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] },
       { name: "meteor",
         version: "0.1.1",
         dependencies: [["nodejs", ">= 0.0.0"]] },
       { name: "meteor",
         version: "0.1.0",
         dependencies: [["nodejs", ">= 0.0.0"]] }],
      "mg" => [{ name: "mg", version: "1.0.0", dependencies: [] }],
      "minecraft" =>
      [{ name: "minecraft",
         version: "0.5.0",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "minecraft",
         version: "0.4.0",
         dependencies: [["python", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "minecraft",
         version: "0.3.0",
         dependencies: [["java", ">= 0.0.0"], ["tmux", ">= 0.0.0"]] },
       { name: "minecraft",
         version: "0.0.2",
         dependencies: [["java", ">= 0.0.0"], ["tmux", ">= 0.0.0"]] }],
      "mineos" =>
      [{ name: "mineos",
         version: "2.2.4",
         dependencies: [["logrotate", ">= 0.0.0"]] },
       { name: "mineos",
         version: "2.2.3",
         dependencies: [["logrotate", ">= 0.0.0"]] },
       { name: "mineos",
         version: "2.2.2",
         dependencies: [["logrotate", ">= 0.0.0"]] },
       { name: "mineos",
         version: "2.2.1",
         dependencies: [["logrotate", ">= 0.0.0"]] },
       { name: "mineos",
         version: "2.2.0",
         dependencies: [["logrotate", ">= 0.0.0"]] },
       { name: "mineos",
         version: "2.1.0",
         dependencies: [["logrotate", ">= 0.0.0"]] },
       { name: "mineos",
         version: "2.0.1",
         dependencies: [["logrotate", ">= 0.0.0"]] },
       { name: "mineos",
         version: "2.0.0",
         dependencies: [["logrotate", ">= 0.0.0"]] },
       { name: "mineos",
         version: "1.0.2",
         dependencies: [["apt-repo", ">= 0.0.0"]] },
       { name: "mineos",
         version: "1.0.1",
         dependencies: [["apt-repo", ">= 0.0.0"]] },
       { name: "mineos",
         version: "1.0.0",
         dependencies: [["apt-repo", ">= 0.0.0"], ["mysql", ">= 0.0.0"]] }],
      "minidlna" => [{ name: "minidlna", version: "0.1.0", dependencies: [] }],
      "minitest" =>
      [{ name: "minitest",
         version: "0.1.5",
         dependencies: [["chef_handler", "~> 1.0.4"]] },
       { name: "minitest",
         version: "0.1.4",
         dependencies: [["chef_handler", "~> 1.0.4"]] },
       { name: "minitest",
         version: "0.1.3",
         dependencies: [["chef_handler", "~> 1.0.4"]] },
       { name: "minitest",
         version: "0.1.2",
         dependencies: [["chef_handler", "~> 1.0.4"]] },
       { name: "minitest",
         version: "0.1.0",
         dependencies: [["chef_handler", "~> 1.0.4"]] },
       { name: "minitest",
         version: "0.0.5",
         dependencies: [["chef_handler", "~> 1.0.4"]] },
       { name: "minitest", version: "0.0.4", dependencies: [] },
       { name: "minitest", version: "0.0.3", dependencies: [] },
       { name: "minitest", version: "0.0.1", dependencies: [] }],
      "modcloth-hubot" =>
      [{ name: "modcloth-hubot",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"],
          ["smf", ">= 0.0.0"]] }],
      "modcloth-nad" =>
      [{ name: "modcloth-nad", version: "0.3.0", dependencies: [] }],
      "modules" =>
      [{ name: "modules", version: "0.2.0", dependencies: [] },
       { name: "modules", version: "0.1.3", dependencies: [] },
       { name: "modules", version: "0.1.2", dependencies: [] },
       { name: "modules", version: "0.1.0", dependencies: [] }],
      "mod_security" =>
      [{ name: "mod_security",
         version: "0.0.6",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "mod_security",
         version: "0.0.5",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "mod_security",
         version: "0.0.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "mod_security",
         version: "0.0.3",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "mod_security",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "mod_security",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "mogilefs" =>
      [{ name: "mogilefs",
         version: "0.2.5",
         dependencies: [["perl", "~> 0.10.0"], ["runit", "~> 0.14.2"]] },
       { name: "mogilefs",
         version: "0.2.4",
         dependencies: [["perl", "~> 0.10.0"], ["runit", "~> 0.14.2"]] }],
      "mongodb" =>
      [{ name: "mongodb",
         version: "0.13.7",
         dependencies: [["apt", ">= 1.8.2"],
          ["python", ">= 0.0.0"],
          ["runit", ">= 1.1.6"],
          ["yum", ">= 0.0.0"]] },
       { name: "mongodb",
         version: "0.13.6",
         dependencies: [["apt", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "mongodb",
         version: "0.13.4",
         dependencies: [["apt", ">= 1.8.2"], ["yum", ">= 0.0.0"]] },
       { name: "mongodb",
         version: "0.13.3",
         dependencies: [["apt", ">= 1.8.2"], ["yum", ">= 0.0.0"]] },
       { name: "mongodb",
         version: "0.11.0",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "mongodb", version: "0.9.0", dependencies: [] }],
      "mongodb-10gen" =>
      [{ name: "mongodb-10gen",
         version: "0.1.10",
         dependencies: [["apt", ">= 0.0.0"], ["mongodb-10gen", ">= 0.0.0"]] },
       { name: "mongodb-10gen",
         version: "0.1.9",
         dependencies: [["apt", ">= 0.0.0"], ["mongodb-10gen", ">= 0.0.0"]] },
       { name: "mongodb-10gen",
         version: "0.1.8",
         dependencies: [["apt", ">= 0.0.0"], ["mongodb-10gen", ">= 0.0.0"]] },
       { name: "mongodb-10gen",
         version: "0.1.7",
         dependencies: [["apt", ">= 0.0.0"], ["mongodb-10gen", ">= 0.0.0"]] },
       { name: "mongodb-10gen",
         version: "0.1.6",
         dependencies: [["apt", ">= 0.0.0"], ["mongodb-10gen", ">= 0.0.0"]] },
       { name: "mongodb-10gen",
         version: "0.1.4",
         dependencies: [["apt", ">= 0.0.0"], ["mongodb-10gen", ">= 0.0.0"]] }],
      "monitor" =>
      [{ name: "monitor",
         version: "0.0.4",
         dependencies: [["sensu", ">= 0.0.0"], ["sudo", ">= 0.0.0"]] },
       { name: "monitor",
         version: "0.0.3",
         dependencies: [["sensu", ">= 0.0.0"], ["sudo", ">= 0.0.0"]] },
       { name: "monitor",
         version: "0.0.2",
         dependencies: [["sensu", ">= 0.0.0"]] },
       { name: "monitor",
         version: "0.0.1",
         dependencies: [["sensu", ">= 0.0.0"]] }],
      "monit_bin" =>
      [{ name: "monit_bin", version: "1.0.0", dependencies: [] },
       { name: "monit_bin", version: "0.3.10", dependencies: [] },
       { name: "monit_bin", version: "0.3.9", dependencies: [] },
       { name: "monit_bin", version: "0.3.8", dependencies: [] },
       { name: "monit_bin", version: "0.3.7", dependencies: [] },
       { name: "monit_bin", version: "0.3.6", dependencies: [] },
       { name: "monit_bin", version: "0.3.5", dependencies: [] },
       { name: "monit_bin", version: "0.3.4", dependencies: [] },
       { name: "monit_bin", version: "0.3.3", dependencies: [] },
       { name: "monit_bin", version: "0.3.2", dependencies: [] },
       { name: "monit_bin", version: "0.3.1", dependencies: [] },
       { name: "monit_bin", version: "0.3.0", dependencies: [] },
       { name: "monit_bin", version: "0.2.1", dependencies: [] },
       { name: "monit_bin", version: "0.2.0", dependencies: [] },
       { name: "monit_bin", version: "0.1.3", dependencies: [] },
       { name: "monit_bin", version: "0.1.2", dependencies: [] },
       { name: "monit_bin", version: "0.1.0", dependencies: [] }],
      "mono" =>
      [{ name: "mono",
         version: "0.0.4",
         dependencies: [["git", ">= 0.0.0"], ["apt", ">= 0.0.0"]] }],
      "mosh" =>
      [{ name: "mosh", version: "0.3.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "mosh", version: "0.2.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "mosh", version: "0.1.0", dependencies: [] }],
      "motd" =>
      [{ name: "motd",
         version: "0.4.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "motd",
         version: "0.4.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "motd", version: "0.3.1", dependencies: [] },
       { name: "motd", version: "0.3.0", dependencies: [] }],
      "motd-tail" =>
      [{ name: "motd-tail", version: "2.0.0", dependencies: [] },
       { name: "motd-tail", version: "1.2.2", dependencies: [] },
       { name: "motd-tail", version: "1.2.0", dependencies: [] },
       { name: "motd-tail", version: "1.1.0", dependencies: [] },
       { name: "motd-tail", version: "1.0.0", dependencies: [] }],
      "motion" => [{ name: "motion", version: "0.1.0", dependencies: [] }],
      "moxi" => [{ name: "moxi", version: "0.1.0", dependencies: [] }],
      "mpd" => [{ name: "mpd", version: "0.0.1", dependencies: [] }],
      "mplayer" =>
      [{ name: "mplayer",
         version: "0.0.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yasm", ">= 0.0.0"],
          ["subversion", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "mplayer",
         version: "0.0.5",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yasm", ">= 0.0.0"],
          ["subversion", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "mplayer",
         version: "0.0.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["yasm", ">= 0.0.0"],
          ["subversion", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "mplayer",
         version: "0.0.3",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "mplayer",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "mplayer",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "mruby" =>
      [{ name: "mruby",
         version: "0.4.1",
         dependencies: [["nginx", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "mruby",
         version: "0.4.0",
         dependencies: [["nginx", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "mruby", version: "0.3.2", dependencies: [] },
       { name: "mruby", version: "0.3.1", dependencies: [] },
       { name: "mruby", version: "0.3.0", dependencies: [] },
       { name: "mruby", version: "0.2.1", dependencies: [] },
       { name: "mruby", version: "0.2.0", dependencies: [] },
       { name: "mruby", version: "0.1.0", dependencies: [] }],
      "msoffice" =>
      [{ name: "msoffice",
         version: "0.0.2",
         dependencies: [["windows", ">= 0.0.0"], ["7-zip", ">= 0.0.0"]] },
       { name: "msoffice",
         version: "0.0.1",
         dependencies: [["windows", ">= 0.0.0"], ["7-zip", ">= 0.0.0"]] }],
      "ms_dotnet2" =>
      [{ name: "ms_dotnet2",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "ms_dotnet35" =>
      [{ name: "ms_dotnet35",
         version: "1.0.1",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_dotnet35",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_dotnet35",
         version: "0.0.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_dotnet35",
         version: "0.0.1",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "ms_dotnet4" =>
      [{ name: "ms_dotnet4",
         version: "1.0.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_dotnet4",
         version: "1.0.1",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_dotnet4",
         version: "0.0.1",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "ms_dotnet45" =>
      [{ name: "ms_dotnet45",
         version: "1.1.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_dotnet45",
         version: "1.1.1",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_dotnet45",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "ms_messagequeue" =>
      [{ name: "ms_messagequeue",
         version: "0.0.3",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_messagequeue",
         version: "0.0.2",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_messagequeue",
         version: "0.0.1",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "ms_telnet_client" =>
      [{ name: "ms_telnet_client",
         version: "1.1.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "ms_telnet_client",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "multipath" =>
      [{ name: "multipath", version: "0.0.8", dependencies: [] },
       { name: "multipath", version: "0.0.7", dependencies: [] },
       { name: "multipath", version: "0.0.6", dependencies: [] },
       { name: "multipath", version: "0.0.5", dependencies: [] },
       { name: "multipath", version: "0.0.4", dependencies: [] }],
      "multitail" =>
      [{ name: "multitail",
         version: "0.1.0",
         dependencies: [["minitest-handler", ">= 0.0.0"]] }],
      "mumble" => [{ name: "mumble", version: "0.0.1", dependencies: [] }],
      "munin" =>
      [{ name: "munin",
         version: "1.4.3",
         dependencies: [["apache2", ">= 1.7.0"], ["nginx", ">= 1.8.0"]] },
       { name: "munin",
         version: "1.4.2",
         dependencies: [["apache2", ">= 1.7.0"], ["nginx", ">= 1.8.0"]] },
       { name: "munin",
         version: "1.4.0",
         dependencies: [["apache2", "~> 1.7"], ["nginx", "~> 1.8"]] },
       { name: "munin",
         version: "1.3.2",
         dependencies: [["apache2", ">= 1.0.6"], ["nginx", ">= 0.0.0"]] },
       { name: "munin",
         version: "1.3.0",
         dependencies: [["apache2", ">= 1.0.6"], ["nginx", ">= 0.0.0"]] },
       { name: "munin",
         version: "1.2.0",
         dependencies: [["apache2", ">= 1.0.6"], ["nginx", ">= 0.0.0"]] },
       { name: "munin",
         version: "1.1.2",
         dependencies: [["apache2", ">= 1.0.6"], ["nginx", ">= 0.0.0"]] },
       { name: "munin",
         version: "1.1.0",
         dependencies: [["apache2", ">= 1.0.6"], ["nginx", ">= 0.0.0"]] },
       { name: "munin",
         version: "1.0.2",
         dependencies: [["apache2", ">= 1.0.6"]] },
       { name: "munin",
         version: "1.0.0",
         dependencies: [["apache2", ">= 1.0.6"]] },
       { name: "munin",
         version: "0.99.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "munin",
         version: "0.10.1",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "munin",
         version: "0.10.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "munin",
         version: "0.9.2",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "munin",
         version: "0.9.1",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "munin", version: "0.8.0", dependencies: [] },
       { name: "munin", version: "0.7.0", dependencies: [] }],
      "munin-statsd" =>
      [{ name: "munin-statsd",
         version: "0.1.0",
         dependencies: [["perl", ">= 0.0.0"]] }],
      "myface" =>
      [{ name: "myface",
         version: "0.3.0",
         dependencies: [["mysql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] }],
      "mysql-admin-tools" =>
      [{ name: "mysql-admin-tools", version: "0.0.1", dependencies: [] }],
      "mysql-chef_gem" =>
      [{ name: "mysql-chef_gem",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["mysql", ">= 0.0.0"]] }],
      "mysqld" => [{ name: "mysqld", version: "0.1.0", dependencies: [] }],
      "mysqltuner" => [{ name: "mysqltuner", version: "0.1.0", dependencies: [] }],
      "mysql_charset" =>
      [{ name: "mysql_charset",
         version: "0.0.1",
         dependencies: [["mysql", ">= 0.0.0"]] }],
      "mysql_connector" =>
      [{ name: "mysql_connector", version: "0.7.1", dependencies: [] },
       { name: "mysql_connector", version: "0.6.0", dependencies: [] }],
      "mysql_ebs" => [{ name: "mysql_ebs", version: "0.1.0", dependencies: [] }],
      "mythtv" =>
      [{ name: "mythtv",
         version: "0.0.2",
         dependencies: [["mysql", ">= 0.0.0"]] },
       { name: "mythtv",
         version: "0.0.1",
         dependencies: [["mysql", ">= 0.0.0"]] }],
      "nad" =>
      [{ name: "nad", version: "0.0.5", dependencies: [] },
       { name: "nad", version: "0.0.4", dependencies: [] },
       { name: "nad", version: "0.0.3", dependencies: [] },
       { name: "nad", version: "0.0.2", dependencies: [] },
       { name: "nad", version: "0.0.1", dependencies: [] }],
      "nagios" =>
      [{ name: "nagios",
         version: "5.3.4",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nagios",
         version: "5.3.2",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nagios",
         version: "5.3.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nagios",
         version: "5.2.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum-epel", ">= 0.0.0"]] },
       { name: "nagios",
         version: "5.1.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum", "< 3.0.0"]] },
       { name: "nagios",
         version: "5.0.2",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "nagios",
         version: "5.0.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "nagios",
         version: "4.2.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "nagios",
         version: "4.1.4",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "nagios",
         version: "4.1.2",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "nagios",
         version: "4.1.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "nagios",
         version: "4.0.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"]] },
       { name: "nagios",
         version: "3.1.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"]] },
       { name: "nagios",
         version: "3.0.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"]] },
       { name: "nagios",
         version: "2.0.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"]] },
       { name: "nagios",
         version: "1.3.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["nginx_simplecgi", ">= 0.0.0"]] },
       { name: "nagios",
         version: "1.2.6",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "nagios",
         version: "1.2.4",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "nagios",
         version: "1.2.2",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "nagios",
         version: "1.2.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "nagios",
         version: "1.0.4",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "nagios",
         version: "1.0.2",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "nagios",
         version: "1.0.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "nagios",
         version: "0.4.4",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "nagios",
         version: "0.4.3",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "nagios",
         version: "0.4.2",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "nagios",
         version: "0.4.1",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "nagios",
         version: "0.4.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "nagios",
         version: "0.3.4",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "nagios",
         version: "0.3.3",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "nagios",
         version: "0.3.1",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "nagios", version: "0.3.0", dependencies: [] }],
      "nagios-xinetd" =>
      [{ name: "nagios-xinetd",
         version: "0.1.0",
         dependencies: [["xinetd", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "nagios-xinetd",
         version: "0.0.4",
         dependencies: [["xinetd", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "naglite2" =>
      [{ name: "naglite2",
         version: "0.1.3",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "naglite2",
         version: "0.1.2",
         dependencies: [["apache2", ">= 0.0.0"]] }],
      "nano" => [{ name: "nano", version: "1.0.0", dependencies: [] }],
      "naruto" =>
      [{ name: "naruto", version: "0.0.6", dependencies: [] },
       { name: "naruto", version: "0.0.5", dependencies: [] },
       { name: "naruto", version: "0.0.4", dependencies: [] }],
      "nats" =>
      [{ name: "nats",
         version: "1.0.2",
         dependencies: [["cloudfoundry", "~> 1.3.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "nats",
         version: "1.0.1",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "nats",
         version: "1.0.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] },
       { name: "nats",
         version: "0.99.0",
         dependencies: [["cloudfoundry", ">= 0.0.0"], ["rbenv", ">= 0.0.0"]] }],
      "ncftp" =>
      [{ name: "ncftp", version: "0.1.1", dependencies: [] },
       { name: "ncftp", version: "0.1.0", dependencies: [] }],
      "ncurses" =>
      [{ name: "ncurses", version: "0.0.3", dependencies: [] },
       { name: "ncurses", version: "0.0.2", dependencies: [] },
       { name: "ncurses", version: "0.0.1", dependencies: [] }],
      "nephele" => [{ name: "nephele", version: "0.1.2", dependencies: [] }],
      "nessus" =>
      [{ name: "nessus",
         version: "0.1.1",
         dependencies: [["chef-vault", ">= 0.0.0"]] },
       { name: "nessus", version: "0.1.0", dependencies: [] }],
      "netatalk" =>
      [{ name: "netatalk", version: "1.1.0", dependencies: [] },
       { name: "netatalk", version: "1.0.0", dependencies: [] },
       { name: "netatalk", version: "0.1.0", dependencies: [] }],
      "netcfg" =>
      [{ name: "netcfg", version: "0.0.3", dependencies: [] },
       { name: "netcfg", version: "0.0.2", dependencies: [] },
       { name: "netcfg", version: "0.0.1", dependencies: [] }],
      "netcobol" =>
      [{ name: "netcobol",
         version: "0.0.8",
         dependencies: [["yumrepo", ">= 0.0.0"]] },
       { name: "netcobol",
         version: "0.0.7",
         dependencies: [["yumrepo", ">= 0.0.0"]] }],
      "netdev" =>
      [{ name: "netdev", version: "2.0.0", dependencies: [] },
       { name: "netdev", version: "1.0.0", dependencies: [] }],
      "netdev_eos" =>
      [{ name: "netdev_eos",
         version: "0.1.1",
         dependencies: [["netdev", ">= 0.0.0"]] },
       { name: "netdev_eos",
         version: "0.1.0",
         dependencies: [["netdev", ">= 0.0.0"]] }],
      "netkernel" =>
      [{ name: "netkernel",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"]] }],
      "networking_basic" =>
      [{ name: "networking_basic", version: "0.0.7", dependencies: [] },
       { name: "networking_basic", version: "0.0.6", dependencies: [] },
       { name: "networking_basic", version: "0.0.5", dependencies: [] },
       { name: "networking_basic", version: "0.0.3", dependencies: [] },
       { name: "networking_basic", version: "0.0.2", dependencies: [] }],
      "network_interfaces" =>
      [{ name: "network_interfaces",
         version: "1.0.0",
         dependencies: [["modules", ">= 0.1.2"]] },
       { name: "network_interfaces",
         version: "0.2.2",
         dependencies: [["modules", ">= 0.1.2"]] },
       { name: "network_interfaces",
         version: "0.2.0",
         dependencies: [["modules", ">= 0.1.2"]] },
       { name: "network_interfaces",
         version: "0.1.0",
         dependencies: [["modules", ">= 0.1.2"]] },
       { name: "network_interfaces", version: "0.0.1", dependencies: [] }],
      "newrelic" =>
      [{ name: "newrelic",
         version: "1.0.1",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "1.0.0",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "newrelic", version: "0.5.8", dependencies: [] },
       { name: "newrelic", version: "0.5.7", dependencies: [] },
       { name: "newrelic", version: "0.5.6", dependencies: [] },
       { name: "newrelic", version: "0.5.5", dependencies: [] },
       { name: "newrelic", version: "0.5.4", dependencies: [] },
       { name: "newrelic", version: "0.5.3", dependencies: [] },
       { name: "newrelic", version: "0.5.2", dependencies: [] },
       { name: "newrelic", version: "0.5.1", dependencies: [] },
       { name: "newrelic", version: "0.5.0", dependencies: [] },
       { name: "newrelic", version: "0.4.7", dependencies: [] },
       { name: "newrelic", version: "0.4.6", dependencies: [] },
       { name: "newrelic", version: "0.4.5", dependencies: [] },
       { name: "newrelic", version: "0.4.4", dependencies: [] },
       { name: "newrelic", version: "0.4.3", dependencies: [] },
       { name: "newrelic", version: "0.4.2", dependencies: [] },
       { name: "newrelic",
         version: "0.4.1",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.4.0",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.3.7",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.3.6",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.3.5",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.3.4",
         dependencies: [["apache2", ">= 0.0.0"], ["php", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "newrelic", version: "0.3.3", dependencies: [] },
       { name: "newrelic", version: "0.3.2", dependencies: [] },
       { name: "newrelic", version: "0.3.1", dependencies: [] },
       { name: "newrelic", version: "0.3.0", dependencies: [] },
       { name: "newrelic",
         version: "0.2.6",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.2.5",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.2.4",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.2.1",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "newrelic",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "newrelic-ng" =>
      [{ name: "newrelic-ng",
         version: "0.4.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["php", ">= 0.0.0"]] },
       { name: "newrelic-ng",
         version: "0.3.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "newrelic-ng",
         version: "0.3.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "newrelic-ng",
         version: "0.3.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "newrelic-ng",
         version: "0.3.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "newrelic-ng",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "newrelic-ng",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "newrelic-ng",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"]] }],
      "newrelic-sysmond" =>
      [{ name: "newrelic-sysmond",
         version: "1.3.3",
         dependencies: [["apt", ">= 1.9.2"]] },
       { name: "newrelic-sysmond", version: "1.3.2", dependencies: [] },
       { name: "newrelic-sysmond", version: "1.3.1", dependencies: [] },
       { name: "newrelic-sysmond", version: "1.3.0", dependencies: [] },
       { name: "newrelic-sysmond", version: "1.2.1", dependencies: [] }],
      "newrelic_monitoring" =>
      [{ name: "newrelic_monitoring", version: "1.0.0", dependencies: [] }],
      "newrelic_plugins" =>
      [{ name: "newrelic_plugins", version: "1.0.0", dependencies: [] }],
      "nexus" =>
      [{ name: "nexus",
         version: "3.2.0",
         dependencies: [["java", ">= 1.15.4"],
          ["nginx", ">= 1.8.0"],
          ["artifact", ">= 1.11.0"]] },
       { name: "nexus",
         version: "3.1.0",
         dependencies: [["java", "~> 1.15.4"],
          ["nginx", "~> 1.8.0"],
          ["artifact", "~> 1.11.0"]] },
       { name: "nexus",
         version: "3.0.2",
         dependencies: [["java", "~> 1.15.4"],
          ["nginx", "~> 1.6.0"],
          ["artifact", "~> 1.11.0"]] },
       { name: "nexus",
         version: "3.0.1",
         dependencies: [["java", "~> 1.15.4"],
          ["nginx", "~> 1.6.0"],
          ["artifact", "~> 1.11.0"]] },
       { name: "nexus",
         version: "3.0.0",
         dependencies: [["java", "~> 1.12.0"], ["nginx", "~> 1.6.0"], ["artifact", "~> 1.6.0"]] },
       { name: "nexus",
         version: "2.4.0",
         dependencies: [["java", "~> 1.12.0"], ["nginx", "~> 1.6.0"], ["artifact", "~> 1.6.0"]] },
       { name: "nexus",
         version: "2.3.0",
         dependencies: [["java", "~> 1.12.0"], ["nginx", "~> 1.6.0"], ["artifact", "~> 1.6.0"]] },
       { name: "nexus",
         version: "2.2.0",
         dependencies: [["java", "~> 1.9.0"], ["nginx", "~> 1.6.0"], ["artifact", "~> 1.6.0"]] },
       { name: "nexus",
         version: "2.1.0",
         dependencies: [["java", "~> 1.9.0"], ["nginx", "~> 1.6.0"], ["artifact", "~> 1.5.0"]] },
       { name: "nexus",
         version: "2.0.0",
         dependencies: [["java", "~> 1.9.0"], ["nginx", "~> 1.6.0"], ["artifact", "~> 1.5.0"]] },
       { name: "nexus",
         version: "1.2.1",
         dependencies: [["java", "~> 1.9.0"],
          ["nginx", "~> 1.2.0"],
          ["artifact", "~> 1.5.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "nexus",
         version: "1.2.0",
         dependencies: [["java", "~> 1.9.0"],
          ["nginx", "~> 1.2.0"],
          ["artifact", "~> 1.2.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "nexus",
         version: "1.1.0",
         dependencies: [["java", "~> 1.9.0"],
          ["nginx", "~> 1.2.0"],
          ["artifact", "~> 1.2.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "nexus",
         version: "1.0.0",
         dependencies: [["java", "~> 1.9.0"],
          ["nginx", "~> 1.2.0"],
          ["artifact", "~> 1.2.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "nexus",
         version: "0.18.3",
         dependencies: [["java", "~> 1.5.2"],
          ["nginx", "~> 1.0.0"],
          ["artifact", "~> 0.11.5"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "nexus",
         version: "0.18.2",
         dependencies: [["java", "~> 1.5.2"],
          ["nginx", "~> 1.0.0"],
          ["artifact", "~> 0.11.5"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "nexus",
         version: "0.18.1",
         dependencies: [["java", "~> 1.5.2"],
          ["nginx", "~> 1.0.0"],
          ["artifact", "~> 0.11.5"],
          ["build-essential", ">= 0.0.0"],
          ["yum", "~> 2.0.6"]] },
       { name: "nexus",
         version: "0.18.0",
         dependencies: [["java", "~> 1.5.2"],
          ["nginx", "~> 1.0.0"],
          ["artifact", "~> 0.11.5"],
          ["build-essential", "~> 1.3.2"],
          ["yum", "~> 2.0.6"]] },
       { name: "nexus",
         version: "0.17.0",
         dependencies: [["java", "~> 1.5.2"], ["nginx", "~> 1.0.0"], ["artifact", "~> 0.11.0"]] },
       { name: "nexus",
         version: "0.16.0",
         dependencies: [["java", "~> 1.5.2"], ["nginx", "~> 1.0.0"], ["artifact", "~> 0.11.0"]] },
       { name: "nexus",
         version: "0.13.0",
         dependencies: [["ark", "~> 0.0.11"],
          ["java", "~> 1.5.2"],
          ["nginx", "~> 0.101.6"],
          ["bluepill", "~> 1.0.6"]] },
       { name: "nexus",
         version: "0.12.8",
         dependencies: [["ark", "~> 0.0.11"],
          ["java", "~> 1.5.2"],
          ["nginx", "~> 0.101.6"],
          ["bluepill", "~> 1.0.6"]] },
       { name: "nexus",
         version: "0.12.7",
         dependencies: [["ark", "~> 0.0.11"],
          ["java", "~> 1.5.2"],
          ["nginx", "~> 0.101.6"],
          ["bluepill", "~> 1.0.6"]] },
       { name: "nexus",
         version: "0.11.2",
         dependencies: [["ark", "~> 0.0.11"],
          ["java", "~> 1.5.2"],
          ["nginx", "~> 0.101.6"],
          ["bluepill", "~> 1.0.6"]] }],
      "nfs" =>
      [{ name: "nfs", version: "1.0.0", dependencies: [["line", ">= 0.0.0"]] },
       { name: "nfs", version: "0.5.0", dependencies: [["line", ">= 0.0.0"]] },
       { name: "nfs", version: "0.4.2", dependencies: [["line", ">= 0.0.0"]] },
       { name: "nfs", version: "0.4.1", dependencies: [["line", ">= 0.0.0"]] },
       { name: "nfs", version: "0.4.0", dependencies: [["line", ">= 0.0.0"]] },
       { name: "nfs", version: "0.3.1", dependencies: [["line", ">= 0.0.0"]] },
       { name: "nfs", version: "0.3.0", dependencies: [["line", ">= 0.0.0"]] },
       { name: "nfs", version: "0.2.8", dependencies: [] },
       { name: "nfs", version: "0.2.7", dependencies: [] },
       { name: "nfs", version: "0.2.6", dependencies: [] },
       { name: "nfs", version: "0.2.5", dependencies: [] },
       { name: "nfs", version: "0.2.4", dependencies: [] },
       { name: "nfs", version: "0.2.3", dependencies: [] },
       { name: "nfs", version: "0.2.2", dependencies: [] },
       { name: "nfs", version: "0.1.0", dependencies: [] },
       { name: "nfs", version: "0.0.6", dependencies: [] }],
      "nginx-fastcgi" =>
      [{ name: "nginx-fastcgi", version: "0.0.11", dependencies: [] },
       { name: "nginx-fastcgi", version: "0.0.10", dependencies: [] },
       { name: "nginx-fastcgi", version: "0.0.9", dependencies: [] },
       { name: "nginx-fastcgi", version: "0.0.6", dependencies: [] },
       { name: "nginx-fastcgi", version: "0.0.5", dependencies: [] },
       { name: "nginx-fastcgi", version: "0.0.4", dependencies: [] },
       { name: "nginx-fastcgi", version: "0.0.3", dependencies: [] },
       { name: "nginx-fastcgi", version: "0.0.2", dependencies: [] },
       { name: "nginx-fastcgi", version: "0.0.1", dependencies: [] }],
      "nginx-proxy" =>
      [{ name: "nginx-proxy",
         version: "0.2.0",
         dependencies: [["apache2", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] },
       { name: "nginx-proxy",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] }],
      "nginx_conf" =>
      [{ name: "nginx_conf",
         version: "0.0.5",
         dependencies: [["nginx", ">= 0.0.0"]] },
       { name: "nginx_conf",
         version: "0.0.4",
         dependencies: [["nginx", ">= 0.0.0"]] },
       { name: "nginx_conf",
         version: "0.0.3",
         dependencies: [["nginx", ">= 0.0.0"]] },
       { name: "nginx_conf",
         version: "0.0.2",
         dependencies: [["nginx", ">= 0.0.0"]] },
       { name: "nginx_conf",
         version: "0.0.1",
         dependencies: [["nginx", ">= 0.0.0"]] }],
      "nginx_simplecgi" =>
      [{ name: "nginx_simplecgi",
         version: "0.1.0",
         dependencies: [["nginx", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["bluepill", ">= 0.0.0"]] }],
      "nginx_vhost" => [{ name: "nginx_vhost", version: "0.1.0", dependencies: [] }],
      "nmap" => [{ name: "nmap", version: "0.1.0", dependencies: [] }],
      "noah" =>
      [{ name: "noah", version: "0.8.2", dependencies: [] },
       { name: "noah", version: "0.8.0", dependencies: [] }],
      "node" =>
      [{ name: "node",
         version: "1.1.0",
         dependencies: [["git", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "node",
         version: "1.0.1",
         dependencies: [["git", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "node",
         version: "1.0.0",
         dependencies: [["git", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "node", version: "0.0.6", dependencies: [["git", ">= 0.0.0"]] },
       { name: "node", version: "0.0.5", dependencies: [["git", ">= 0.0.0"]] },
       { name: "node", version: "0.0.4", dependencies: [["git", ">= 0.0.0"]] },
       { name: "node", version: "0.0.3", dependencies: [["git", ">= 0.0.0"]] },
       { name: "node", version: "0.0.2", dependencies: [["git", ">= 0.0.0"]] }],
      "nodebrew" =>
      [{ name: "nodebrew",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] }],
      "nodejs-windows" =>
      [{ name: "nodejs-windows",
         version: "0.10.13",
         dependencies: [["windows", ">= 1.2.8"]] }],
      "notepadplusplus" =>
      [{ name: "notepadplusplus",
         version: "0.0.5",
         dependencies: [["windows", ">= 1.2.8"]] }],
      "notepadplusplus_2" =>
      [{ name: "notepadplusplus_2",
         version: "1.0.3",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "now" =>
      [{ name: "now", version: "0.3.0", dependencies: [] },
       { name: "now", version: "0.2.2", dependencies: [] },
       { name: "now", version: "0.1.0", dependencies: [] }],
      "npm" =>
      [{ name: "npm", version: "0.1.2", dependencies: [["nodejs", ">= 0.0.0"]] }],
      "npm_registry" =>
      [{ name: "npm_registry",
         version: "0.2.0",
         dependencies: [["git", ">= 0.0.0"], ["couchdb", ">= 0.0.0"], ["nodejs", ">= 0.0.0"]] },
       { name: "npm_registry",
         version: "0.1.1",
         dependencies: [["git", ">= 0.0.0"], ["couchdb", ">= 0.0.0"], ["nodejs", ">= 0.0.0"]] },
       { name: "npm_registry",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"], ["couchdb", ">= 0.0.0"], ["nodejs", ">= 0.0.0"]] }],
      "nrpe" =>
      [{ name: "nrpe",
         version: "1.0.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "nrpe",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] }],
      "nsclient" =>
      [{ name: "nsclient",
         version: "0.1.0",
         dependencies: [["chocolatey", ">= 0.0.0"]] }],
      "nullmailer" => [{ name: "nullmailer", version: "0.1.1", dependencies: [] }],
      "nut" =>
      [{ name: "nut", version: "0.0.2", dependencies: [] },
       { name: "nut", version: "0.0.1", dependencies: [] }],
      "nventory" => [{ name: "nventory", version: "0.1.0", dependencies: [] }],
      "nvm" =>
      [{ name: "nvm", version: "0.1.0", dependencies: [["git", ">= 2.1.0"]] }],
      "nvp" =>
      [{ name: "nvp",
         version: "0.1.0",
         dependencies: [["quantum", ">= 0.0.0"]] }],
      "nyan-cat" =>
      [{ name: "nyan-cat",
         version: "0.1.4",
         dependencies: [["line", ">= 0.0.0"]] },
       { name: "nyan-cat",
         version: "0.1.3",
         dependencies: [["line", ">= 0.0.0"]] },
       { name: "nyan-cat",
         version: "0.1.2",
         dependencies: [["line", ">= 0.0.0"]] },
       { name: "nyan-cat", version: "0.1.1", dependencies: [] },
       { name: "nyan-cat", version: "0.1.0", dependencies: [] }],
      "Obfsproxy" => [{ name: "Obfsproxy", version: "0.0.1", dependencies: [] }],
      "oclint" =>
      [{ name: "oclint",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] }],
      "oh-my-zsh" =>
      [{ name: "oh-my-zsh",
         version: "0.4.3",
         dependencies: [["git", ">= 0.0.0"], ["zsh", ">= 0.0.0"], ["users", ">= 0.0.0"]] },
       { name: "oh-my-zsh",
         version: "0.4.2",
         dependencies: [["git", ">= 0.0.0"], ["zsh", ">= 0.0.0"], ["user", ">= 0.0.0"]] },
       { name: "oh-my-zsh",
         version: "0.4.1",
         dependencies: [["git", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] },
       { name: "oh-my-zsh",
         version: "0.4.0",
         dependencies: [["git", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] },
       { name: "oh-my-zsh",
         version: "0.2.0",
         dependencies: [["git", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] },
       { name: "oh-my-zsh",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] }],
      "ohai-private-ipaddress" =>
      [{ name: "ohai-private-ipaddress",
         version: "0.0.1",
         dependencies: [["ohai", ">= 0.0.0"]] }],
      "omnibus_serverspec" =>
      [{ name: "omnibus_serverspec", version: "0.1.1", dependencies: [] },
       { name: "omnibus_serverspec", version: "0.1.0", dependencies: [] }],
      "omsa" =>
      [{ name: "omsa", version: "0.1.0", dependencies: [["yum", ">= 0.0.0"]] }],
      "onddo-spamassassin" =>
      [{ name: "onddo-spamassassin", version: "0.1.0", dependencies: [] }],
      "opencv" =>
      [{ name: "opencv", version: "0.0.4", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "opencv",
         version: "0.0.3",
         dependencies: [["apt", ">= 0.0.0"], ["chocolatey", ">= 0.0.0"]] }],
      "opendj" =>
      [{ name: "opendj", version: "0.1.1", dependencies: [] },
       { name: "opendj", version: "0.1.0", dependencies: [] }],
      "opendj-openam" =>
      [{ name: "opendj-openam",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "opendj-openam",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "opendj-openam",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"]] }],
      "openerp" =>
      [{ name: "openerp",
         version: "0.0.1",
         dependencies: [["postgresql", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] }],
      "openfire" =>
      [{ name: "openfire",
         version: "0.2.0",
         dependencies: [["java", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] }],
      "openindiana" => [{ name: "openindiana", version: "0.5.0", dependencies: [] }],
      "openldap-server" =>
      [{ name: "openldap-server", version: "0.9.2", dependencies: [] },
       { name: "openldap-server", version: "0.9.1", dependencies: [] },
       { name: "openldap-server", version: "0.9.0", dependencies: [] }],
      "opennebula" =>
      [{ name: "opennebula",
         version: "0.1.6",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "opennebula",
         version: "0.1.5",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "opennebula",
         version: "0.1.4",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "opennebula",
         version: "0.1.3",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "opennebula",
         version: "0.1.0",
         dependencies: [["openssl", ">= 0.0.0"]] }],
      "openoffice" =>
      [{ name: "openoffice",
         version: "0.2.2",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "openoffice",
         version: "0.2.0",
         dependencies: [["java", ">= 0.0.0"]] }],
      "openresty" =>
      [{ name: "openresty",
         version: "0.3.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "openresty",
         version: "0.3.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "openresty",
         version: "0.3.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "openresty",
         version: "0.2.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "openresty",
         version: "0.1.9",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "openresty",
         version: "0.1.8",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "openresty",
         version: "0.1.7",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "openresty",
         version: "0.1.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "openresty",
         version: "0.1.5",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"],
          ["ohai", ">= 1.1.4"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] }],
      "opensmtpd" =>
      [{ name: "opensmtpd",
         version: "0.2.0",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "opensmtpd",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"]] }],
      "openssl-fips" =>
      [{ name: "openssl-fips",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "openvas" =>
      [{ name: "openvas",
         version: "0.0.52",
         dependencies: [["apt", ">= 0.0.0"], ["perl", ">= 0.0.0"], ["openvas", ">= 0.0.0"]] },
       { name: "openvas",
         version: "0.0.46",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "openvas",
         version: "0.0.44",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "openvas",
         version: "0.0.42",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "openvas",
         version: "0.0.40",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "openvas",
         version: "0.0.38",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "openvas",
         version: "0.0.36",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "openvas",
         version: "0.0.30",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "openvas",
         version: "0.0.26",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "openvz" => [{ name: "openvz", version: "0.1.0", dependencies: [] }],
      "optipng" =>
      [{ name: "optipng",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "oracle" =>
      [{ name: "oracle",
         version: "0.0.9",
         dependencies: [["el-sysctl", ">= 0.0.0"],
          ["x-windows", ">= 0.0.0"],
          ["gnome", ">= 0.0.0"]] },
       { name: "oracle",
         version: "0.0.8",
         dependencies: [["el-sysctl", ">= 0.0.0"],
          ["x-windows", ">= 0.0.0"],
          ["gnome", ">= 0.0.0"]] },
       { name: "oracle",
         version: "0.0.7",
         dependencies: [["el-sysctl", ">= 0.0.0"],
          ["x-windows", ">= 0.0.0"],
          ["gnome", ">= 0.0.0"]] },
       { name: "oracle",
         version: "0.0.6",
         dependencies: [["el-sysctl", ">= 0.0.0"],
          ["x-windows", ">= 0.0.0"],
          ["gnome", ">= 0.0.0"]] }],
      "oracle-instantclient" =>
      [{ name: "oracle-instantclient", version: "1.0.4", dependencies: [] },
       { name: "oracle-instantclient", version: "1.0.1", dependencies: [] },
       { name: "oracle-instantclient", version: "1.0.0", dependencies: [] },
       { name: "oracle-instantclient", version: "0.1.0", dependencies: [] }],
      "oracle-xe" => [{ name: "oracle-xe", version: "0.1.0", dependencies: [] }],
      "orientdb" =>
      [{ name: "orientdb",
         version: "0.2.0",
         dependencies: [["java", ">= 0.0.0"], ["apt", ">= 0.0.0"]] }],
      "osrm" =>
      [{ name: "osrm", version: "0.2.2", dependencies: [] },
       { name: "osrm", version: "0.2.1", dependencies: [] },
       { name: "osrm", version: "0.2.0", dependencies: [] },
       { name: "osrm", version: "0.1.2", dependencies: [] },
       { name: "osrm", version: "0.1.1", dependencies: [] },
       { name: "osrm", version: "0.1.0", dependencies: [] }],
      "ossec" =>
      [{ name: "ossec",
         version: "1.0.4",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ossec",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ossec",
         version: "1.0.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ossec",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "osx" => [{ name: "osx", version: "2.0.1", dependencies: [] }],
      "osxdefaults" => [{ name: "osxdefaults", version: "0.0.1", dependencies: [] }],
      "osxzip" => [{ name: "osxzip", version: "0.1.0", dependencies: [] }],
      "overridable" => [{ name: "overridable", version: "0.2.0", dependencies: [] }],
      "ovirt" =>
      [{ name: "ovirt", version: "0.1.1", dependencies: [] },
       { name: "ovirt", version: "0.1.0", dependencies: [] }],
      "ovirt-mom" => [{ name: "ovirt-mom", version: "0.1.0", dependencies: [] }],
      "owfs" => [{ name: "owfs", version: "0.1.0", dependencies: [] }],
      "owncloud" =>
      [{ name: "owncloud",
         version: "0.3.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.6.0"],
          ["postfix", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "owncloud",
         version: "0.3.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.6.0"],
          ["postfix", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "owncloud",
         version: "0.2.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["php-fpm", ">= 0.0.0"],
          ["postfix", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "owncloud",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["postfix", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] }],
      "p2p-network" =>
      [{ name: "p2p-network",
         version: "0.0.2",
         dependencies: [["tunnel", ">= 0.0.0"]] }],
      "package-driver" =>
      [{ name: "package-driver", version: "0.1.1", dependencies: [] },
       { name: "package-driver", version: "0.1.0", dependencies: [] }],
      "packages" => [{ name: "packages", version: "0.1.0", dependencies: [] }],
      "package_installer" =>
      [{ name: "package_installer", version: "0.0.1", dependencies: [] }],
      "packer" =>
      [{ name: "packer", version: "0.3.0", dependencies: [["ark", "~> 0.4.0"]] },
       { name: "packer", version: "0.2.4", dependencies: [["ark", "~> 0.4.0"]] },
       { name: "packer", version: "0.2.3", dependencies: [["ark", "~> 0.4.0"]] },
       { name: "packer", version: "0.2.2", dependencies: [["ark", "~> 0.4.0"]] },
       { name: "packer", version: "0.2.1", dependencies: [["ark", "~> 0.3.0"]] },
       { name: "packer", version: "0.2.0", dependencies: [["ark", "~> 0.3.0"]] }],
      "pam-ssh-agent-auth" =>
      [{ name: "pam-ssh-agent-auth",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "pandoc" =>
      [{ name: "pandoc",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"], ["dmg", ">= 0.0.0"], ["homebrew", ">= 0.0.0"]] },
       { name: "pandoc",
         version: "0.0.1",
         dependencies: [["windows", ">= 0.0.0"], ["dmg", ">= 0.0.0"]] }],
      "papertrail-rsyslog" =>
      [{ name: "papertrail-rsyslog",
         version: "1.1.1",
         dependencies: [["rsyslog", "~> 1.5.0"]] },
       { name: "papertrail-rsyslog",
         version: "1.1.0",
         dependencies: [["rsyslog", "~> 1.5.0"]] }],
      "parted" => [{ name: "parted", version: "1.0.0", dependencies: [] }],
      "partial_search" =>
      [{ name: "partial_search", version: "1.0.8", dependencies: [] },
       { name: "partial_search", version: "1.0.6", dependencies: [] },
       { name: "partial_search", version: "1.0.4", dependencies: [] },
       { name: "partial_search", version: "1.0.2", dependencies: [] },
       { name: "partial_search", version: "1.0.0", dependencies: [] }],
      "passenger" => [{ name: "passenger", version: "0.0.1", dependencies: [] }],
      "passenger_apache2" =>
      [{ name: "passenger_apache2",
         version: "2.2.0",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "2.1.2",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "2.1.0",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "2.0.4",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "2.0.2",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "2.0.0",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "1.1.0",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "1.0.0",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "0.99.4",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "0.99.2",
         dependencies: [["apache2", ">= 1.0.4"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "0.99.0",
         dependencies: [["apache2", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "0.16.3",
         dependencies: [["rails", ">= 0.0.0"],
          ["packages", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "0.16.0",
         dependencies: [["rails", ">= 0.0.0"],
          ["packages", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"]] },
       { name: "passenger_apache2",
         version: "0.14.0",
         dependencies: [["rails", ">= 0.0.0"],
          ["packages", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"]] }],
      "passenger_enterprise" =>
      [{ name: "passenger_enterprise",
         version: "0.99.0",
         dependencies: [["ruby_enterprise", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "passenger_enterprise",
         version: "0.4.3",
         dependencies: [["ruby_enterprise", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "passenger_enterprise",
         version: "0.4.2",
         dependencies: [["nginx", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"]] },
       { name: "passenger_enterprise",
         version: "0.4.0",
         dependencies: [["nginx", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"]] },
       { name: "passenger_enterprise",
         version: "0.2.0",
         dependencies: [["nginx", ">= 0.0.0"],
          ["ruby_enterprise", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "paths" =>
      [{ name: "paths", version: "0.3.0", dependencies: [] },
       { name: "paths", version: "0.2.0", dependencies: [] }],
      "pdepend" =>
      [{ name: "pdepend",
         version: "0.0.4",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "pdepend",
         version: "0.0.3",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "pdepend",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "pdepend",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] }],
      "pdf2image" =>
      [{ name: "pdf2image",
         version: "1.0.0",
         dependencies: [["xpdf", ">= 0.0.0"]] }],
      "pdftk" => [{ name: "pdftk", version: "0.0.1", dependencies: [] }],
      "pdns" =>
      [{ name: "pdns",
         version: "0.3.0",
         dependencies: [["sqlite", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["resolvconf", ">= 0.0.0"]] },
       { name: "pdns",
         version: "0.2.0",
         dependencies: [["sqlite", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "pdns", version: "0.1.2", dependencies: [["sqlite", ">= 0.0.0"]] },
       { name: "pdns", version: "0.1.0", dependencies: [["sqlite", ">= 0.0.0"]] },
       { name: "pdns", version: "0.0.2", dependencies: [["sqlite", ">= 0.0.0"]] },
       { name: "pdns",
         version: "0.0.1",
         dependencies: [["sqlite", ">= 0.0.0"]] }],
      "pdsh" =>
      [{ name: "pdsh", version: "0.1.1", dependencies: [] },
       { name: "pdsh", version: "0.1.0", dependencies: [] }],
      "pen" =>
      [{ name: "pen", version: "0.1.2", dependencies: [["runit", ">= 0.0.0"]] },
       { name: "pen", version: "0.1.0", dependencies: [] }],
      "pennyworth" =>
      [{ name: "pennyworth",
         version: "0.2.3",
         dependencies: [["java", ">= 0.0.0"],
          ["jenkins", ">= 0.0.0"],
          ["postfix", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["leiningen", ">= 0.0.0"],
          ["ant", ">= 0.0.0"]] },
       { name: "pennyworth",
         version: "0.2.1",
         dependencies: [["java", ">= 0.0.0"],
          ["jenkins", ">= 0.0.0"],
          ["postfix", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["leiningen", ">= 0.0.0"]] }],
      "percolate" =>
      [{ name: "percolate", version: "0.9.1", dependencies: [] },
       { name: "percolate", version: "0.9.0", dependencies: [] }],
      "percona" =>
      [{ name: "percona",
         version: "0.14.5",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.14.4",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.14.3",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.14.2",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.14.1",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.14.0",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.13.0",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.12.4",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.12.3",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona",
         version: "0.12.2",
         dependencies: [["apt", ">= 1.4.4"], ["yum", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "percona", version: "0.1.1", dependencies: [] },
       { name: "percona", version: "0.0.1", dependencies: [] }],
      "percona-install" =>
      [{ name: "percona-install", version: "0.1.4", dependencies: [] },
       { name: "percona-install", version: "0.1.3", dependencies: [] },
       { name: "percona-install", version: "0.0.6", dependencies: [] },
       { name: "percona-install", version: "0.0.5", dependencies: [] },
       { name: "percona-install", version: "0.0.4", dependencies: [] },
       { name: "percona-install", version: "0.0.3", dependencies: [] }],
      "percona-toolkit" =>
      [{ name: "percona-toolkit",
         version: "0.1.0",
         dependencies: [["yum", ">= 0.0.0"], ["apt", ">= 0.0.0"]] }],
      "perl" =>
      [{ name: "perl", version: "1.2.2", dependencies: [] },
       { name: "perl", version: "1.2.0", dependencies: [] },
       { name: "perl", version: "1.1.2", dependencies: [] },
       { name: "perl", version: "1.1.0", dependencies: [] },
       { name: "perl", version: "1.0.2", dependencies: [] },
       { name: "perl", version: "1.0.0", dependencies: [] },
       { name: "perl", version: "0.10.0", dependencies: [] },
       { name: "perl", version: "0.9.2", dependencies: [] },
       { name: "perl", version: "0.9.0", dependencies: [] },
       { name: "perl", version: "0.8.0", dependencies: [] }],
      "perlbrew" => [{ name: "perlbrew", version: "0.1.0", dependencies: [] }],
      "personality" => [{ name: "personality", version: "1.0.0", dependencies: [] }],
      "petals" =>
      [{ name: "petals",
         version: "0.0.4",
         dependencies: [["java", ">= 0.0.0"], ["mysql", ">= 0.0.0"]] },
       { name: "petals",
         version: "0.0.3",
         dependencies: [["java", ">= 0.0.0"], ["mysql", ">= 0.0.0"]] }],
      "pgbadger" =>
      [{ name: "pgbadger",
         version: "0.0.2",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "pgbouncer" => [{ name: "pgbouncer", version: "1.0.0", dependencies: [] }],
      "pg_repack" =>
      [{ name: "pg_repack",
         version: "0.1.0",
         dependencies: [["database", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] }],
      "phantomjs" =>
      [{ name: "phantomjs",
         version: "1.0.3",
         dependencies: [["build-essential", ">= 0.0.0"], ["chocolatey", ">= 0.0.0"]] },
       { name: "phantomjs",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["chocolatey", ">= 0.0.0"]] },
       { name: "phantomjs",
         version: "1.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["chocolatey", ">= 0.0.0"]] },
       { name: "phantomjs",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["chocolatey", ">= 0.0.0"]] },
       { name: "phantomjs", version: "0.1.0", dependencies: [] },
       { name: "phantomjs", version: "0.0.10", dependencies: [] },
       { name: "phantomjs", version: "0.0.9", dependencies: [] },
       { name: "phantomjs", version: "0.0.8", dependencies: [] },
       { name: "phantomjs", version: "0.0.6", dependencies: [] },
       { name: "phantomjs", version: "0.0.5", dependencies: [] },
       { name: "phantomjs", version: "0.0.4", dependencies: [] },
       { name: "phantomjs", version: "0.0.3", dependencies: [] },
       { name: "phantomjs", version: "0.0.2", dependencies: [] },
       { name: "phantomjs", version: "0.0.1", dependencies: [] }],
      "phing" =>
      [{ name: "phing", version: "0.0.2", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phing", version: "0.0.1", dependencies: [["php", ">= 0.0.0"]] }],
      "php-box" =>
      [{ name: "php-box", version: "0.0.2", dependencies: [["php", ">= 0.0.0"]] },
       { name: "php-box",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"]] }],
      "php-fpm" =>
      [{ name: "php-fpm",
         version: "0.6.4",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.6.3",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.6.2",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.6.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.5.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.4.6",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.4.5",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.4.4",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.4.3",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.4.2",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.4.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.4.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.3.3",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.3.2",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.3.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.2.4",
         dependencies: [["php", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.2.3",
         dependencies: [["php", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.2.2",
         dependencies: [["php", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.2.1",
         dependencies: [["php", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.2.0",
         dependencies: [["php", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "php-fpm",
         version: "0.1.0",
         dependencies: [["dotdeb", ">= 0.0.0"]] }],
      "php-mcrypt" =>
      [{ name: "php-mcrypt",
         version: "1.0.0",
         dependencies: [["php", ">= 0.0.0"]] }],
      "php-windows" =>
      [{ name: "php-windows",
         version: "0.1.23",
         dependencies: [["apache2-windows", ">= 0.0.0"]] }],
      "php5_ppa" =>
      [{ name: "php5_ppa",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "php5_ppa",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "php5_ppa",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "phpbb" =>
      [{ name: "phpbb",
         version: "0.1.0",
         dependencies: [["mysql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["imagemagick", ">= 0.0.0"]] }],
      "phpcb" =>
      [{ name: "phpcb", version: "0.0.4", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpcb", version: "0.0.3", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpcb", version: "0.0.1", dependencies: [["php", ">= 0.0.0"]] }],
      "phpcpd" =>
      [{ name: "phpcpd", version: "0.0.5", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpcpd", version: "0.0.4", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpcpd", version: "0.0.3", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpcpd",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpcpd",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] }],
      "phpcs" =>
      [{ name: "phpcs",
         version: "0.0.5",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "phpcs",
         version: "0.0.4",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpcs",
         version: "0.0.3",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpcs",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpcs",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] }],
      "phpdcd" =>
      [{ name: "phpdcd", version: "0.0.5", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpdcd", version: "0.0.4", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpdcd", version: "0.0.3", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpdcd",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpdcd",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] }],
      "phpdoc" =>
      [{ name: "phpdoc", version: "0.0.3", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpdoc", version: "0.0.2", dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpdoc", version: "0.0.1", dependencies: [["php", ">= 0.0.0"]] }],
      "phpldapadmin" =>
      [{ name: "phpldapadmin",
         version: "0.2.1",
         dependencies: [["openldap", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "phploc" =>
      [{ name: "phploc",
         version: "0.0.7",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phploc",
         version: "0.0.6",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phploc",
         version: "0.0.5",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phploc",
         version: "0.0.4",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phploc",
         version: "0.0.3",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phploc",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phploc",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] }],
      "phpmd" =>
      [{ name: "phpmd",
         version: "0.0.5",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"], ["pdepend", ">= 0.0.0"]] },
       { name: "phpmd",
         version: "0.0.4",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"], ["pdepend", ">= 0.0.0"]] },
       { name: "phpmd",
         version: "0.0.3",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"], ["pdepend", ">= 0.0.0"]] },
       { name: "phpmd",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"], ["pdepend", ">= 0.0.0"]] },
       { name: "phpmd",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] }],
      "phpmyadmin" =>
      [{ name: "phpmyadmin",
         version: "1.0.6",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpmyadmin",
         version: "1.0.5",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpmyadmin",
         version: "1.0.4",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpmyadmin",
         version: "1.0.2",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "phpmyadmin",
         version: "1.0.1",
         dependencies: [["php", ">= 0.0.0"]] }],
      "phpunit" =>
      [{ name: "phpunit",
         version: "0.0.9",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpunit",
         version: "0.0.8",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpunit",
         version: "0.0.7",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpunit",
         version: "0.0.6",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpunit",
         version: "0.0.5",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpunit",
         version: "0.0.4",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpunit",
         version: "0.0.3",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpunit",
         version: "0.0.2",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] },
       { name: "phpunit",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"], ["composer", ">= 0.0.0"]] }],
      "php_backup_s3" =>
      [{ name: "php_backup_s3", version: "0.1.1", dependencies: [] },
       { name: "php_backup_s3", version: "0.1.0", dependencies: [] }],
      "pig" =>
      [{ name: "pig",
         version: "3.0.4",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"]] },
       { name: "pig",
         version: "3.0.3",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"]] },
       { name: "pig",
         version: "3.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"]] }],
      "pinba" =>
      [{ name: "pinba",
         version: "0.1.1",
         dependencies: [["mysql", ">= 0.0.0"], ["php", ">= 0.0.0"]] },
       { name: "pinba",
         version: "0.1.0",
         dependencies: [["mysql", ">= 0.0.0"], ["php", ">= 0.0.0"]] }],
      "pinto" =>
      [{ name: "pinto", version: "0.1.10", dependencies: [] },
       { name: "pinto", version: "0.1.9", dependencies: [] },
       { name: "pinto", version: "0.1.8", dependencies: [] },
       { name: "pinto", version: "0.1.7", dependencies: [] },
       { name: "pinto", version: "0.1.6", dependencies: [] },
       { name: "pinto", version: "0.1.5", dependencies: [] },
       { name: "pinto", version: "0.1.4", dependencies: [] },
       { name: "pinto", version: "0.1.3", dependencies: [] },
       { name: "pinto", version: "0.1.2", dependencies: [] },
       { name: "pinto", version: "0.1.1", dependencies: [] },
       { name: "pinto",
         version: "0.1.0",
         dependencies: [["cpanminus", ">= 0.0.0"]] }],
      "piwik" =>
      [{ name: "piwik",
         version: "0.2.1",
         dependencies: [["logrotate", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] },
       { name: "piwik",
         version: "0.2.0",
         dependencies: [["logrotate", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] }],
      "pkg-build" =>
      [{ name: "pkg-build",
         version: "0.2.2",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", "~> 0.1.4"],
          ["reprepro", "~> 0.3.0"],
          ["apt", ">= 1.8.2"],
          ["ohai", ">= 0.0.0"],
          ["discovery", ">= 0.2.0"],
          ["lxc", "~> 1.0.0"],
          ["delayed_evaluator", ">= 0.0.0"],
          ["repository", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.2.0",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", "~> 0.1.4"],
          ["reprepro", "~> 0.3.0"],
          ["apt", ">= 1.8.2"],
          ["ohai", ">= 0.0.0"],
          ["discovery", ">= 0.2.0"],
          ["lxc", "~> 1.0.0"],
          ["delayed_evaluator", ">= 0.0.0"],
          ["repository", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.1.9",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"],
          ["discovery", ">= 0.2.0"]] },
       { name: "pkg-build",
         version: "0.1.8",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"],
          ["discovery", ">= 0.2.0"]] },
       { name: "pkg-build",
         version: "0.1.7",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.1.6",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.1.5",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.1.4",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.1.3",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.1.2",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.1.1",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"]] },
       { name: "pkg-build",
         version: "0.1.0",
         dependencies: [["builder", ">= 0.0.0"],
          ["fpm-tng", ">= 0.0.0"],
          ["reprepro", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["ohai", ">= 0.0.0"]] }],
      "pki" =>
      [{ name: "pki", version: "0.1.0", dependencies: [] },
       { name: "pki", version: "0.0.2", dependencies: [] },
       { name: "pki", version: "0.0.1", dependencies: [] }],
      "platform_packages" =>
      [{ name: "platform_packages", version: "0.4.2", dependencies: [] },
       { name: "platform_packages", version: "0.4.0", dependencies: [] }],
      "playonlinux" =>
      [{ name: "playonlinux",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "pleaserun" => [{ name: "pleaserun", version: "0.1.0", dependencies: [] }],
      "plexapp" => [{ name: "plexapp", version: "0.1.0", dependencies: [] }],
      "poise" =>
      [{ name: "poise", version: "1.0.10", dependencies: [] },
       { name: "poise", version: "1.0.8", dependencies: [] },
       { name: "poise", version: "1.0.4", dependencies: [] },
       { name: "poise", version: "1.0.2", dependencies: [] }],
      "poise-appenv" =>
      [{ name: "poise-appenv", version: "1.0.0", dependencies: [] }],
      "polyglot" =>
      [{ name: "polyglot",
         version: "1.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["maven", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"]] }],
      "portage" =>
      [{ name: "portage", version: "0.3.2", dependencies: [] },
       { name: "portage", version: "0.3.1", dependencies: [] }],
      "portage_snapshot" =>
      [{ name: "portage_snapshot",
         version: "0.1.0",
         dependencies: [["portage", ">= 0.0.0"]] }],
      "postfix-dkim" =>
      [{ name: "postfix-dkim", version: "0.0.2", dependencies: [] },
       { name: "postfix-dkim", version: "0.0.1", dependencies: [] }],
      "postfix-dovecot" =>
      [{ name: "postfix-dovecot",
         version: "0.2.0",
         dependencies: [["dovecot", ">= 0.0.0"],
          ["onddo-spamassassin", ">= 0.0.0"],
          ["postfixadmin", ">= 0.0.0"],
          ["postfix-full", ">= 0.0.0"]] },
       { name: "postfix-dovecot",
         version: "0.1.0",
         dependencies: [["dovecot", ">= 0.0.0"],
          ["onddo-spamassassin", ">= 0.0.0"],
          ["postfixadmin", ">= 0.0.0"],
          ["postfix-full", ">= 0.0.0"]] }],
      "postfix-full" =>
      [{ name: "postfix-full", version: "0.1.2", dependencies: [] },
       { name: "postfix-full", version: "0.1.1", dependencies: [] },
       { name: "postfix-full", version: "0.1.0", dependencies: [] }],
      "postfixadmin" =>
      [{ name: "postfixadmin",
         version: "0.1.3",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "postfixadmin",
         version: "0.1.2",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "postfixadmin",
         version: "0.1.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "postfixadmin",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] }],
      "postgis" =>
      [{ name: "postgis",
         version: "0.2.4",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "postgis",
         version: "0.2.2",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "postgis",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] }],
      "postgres" =>
      [{ name: "postgres",
         version: "1.0.1",
         dependencies: [["resource-control", ">= 0.0.0"],
          ["rbac", ">= 0.0.0"],
          ["smf", ">= 0.6.8"],
          ["ipaddr_extensions", ">= 0.0.0"]] },
       { name: "postgres",
         version: "1.0.0",
         dependencies: [["resource-control", ">= 0.0.0"],
          ["rbac", ">= 0.0.0"],
          ["smf", ">= 0.6.8"],
          ["ipaddr_extensions", ">= 0.0.0"]] },
       { name: "postgres",
         version: "0.0.10",
         dependencies: [["resource-control", ">= 0.0.0"],
          ["rbac", ">= 0.0.0"],
          ["smf", ">= 0.6.8"]] }],
      "postgresql91" =>
      [{ name: "postgresql91",
         version: "0.99.6",
         dependencies: [["apt", ">= 0.0.0"], ["openssl", ">= 0.0.0"], ["sysctl", ">= 0.0.0"]] },
       { name: "postgresql91",
         version: "0.99.5",
         dependencies: [["apt", ">= 0.0.0"], ["openssl", ">= 0.0.0"], ["sysctl", ">= 0.0.0"]] }],
      "powerdns" => [{ name: "powerdns", version: "0.1.0", dependencies: [] }],
      "powergui" =>
      [{ name: "powergui",
         version: "1.0.1",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "powergui",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "pptpd" =>
      [{ name: "pptpd", version: "1.0.1", dependencies: [] },
       { name: "pptpd", version: "1.0.0", dependencies: [] }],
      "prince" => [{ name: "prince", version: "0.0.1", dependencies: [] }],
      "pritunl" =>
      [{ name: "pritunl",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "proftpd" => [{ name: "proftpd", version: "0.2.0", dependencies: [] }],
      "proj" => [{ name: "proj", version: "0.1.0", dependencies: [] }],
      "prosody" =>
      [{ name: "prosody",
         version: "0.5.0",
         dependencies: [["ark", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["mercurial", ">= 0.0.0"]] },
       { name: "prosody",
         version: "0.4.0",
         dependencies: [["ark", ">= 0.0.0"],
          ["mercurial", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "prosody",
         version: "0.2.0",
         dependencies: [["mercurial", ">= 0.0.0"]] },
       { name: "prosody",
         version: "0.1.0",
         dependencies: [["mercurial", ">= 0.0.0"]] }],
      "protobuf" =>
      [{ name: "protobuf",
         version: "1.0.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "protobuf",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "protobuf",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "protobuf",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "protobuf",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "protobuf",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] }],
      "proxmox" => [{ name: "proxmox", version: "0.1.4", dependencies: [] }],
      "proxy" =>
      [{ name: "proxy",
         version: "1.0.0",
         dependencies: [["haproxy", ">= 0.0.0"]] }],
      "ps1" =>
      [{ name: "ps1", version: "0.1.0", dependencies: [["line", ">= 0.0.0"]] }],
      "psgi" =>
      [{ name: "psgi", version: "0.0.13", dependencies: [] },
       { name: "psgi", version: "0.0.12", dependencies: [] },
       { name: "psgi", version: "0.0.11", dependencies: [] },
       { name: "psgi", version: "0.0.10", dependencies: [] },
       { name: "psgi", version: "0.0.9", dependencies: [] },
       { name: "psgi", version: "0.0.8", dependencies: [] },
       { name: "psgi", version: "0.0.7", dependencies: [] },
       { name: "psgi", version: "0.0.6", dependencies: [] },
       { name: "psgi", version: "0.0.5", dependencies: [] },
       { name: "psgi", version: "0.0.4", dependencies: [] },
       { name: "psgi", version: "0.0.3", dependencies: [] },
       { name: "psgi", version: "0.0.2", dependencies: [] }],
      "psiprobe" =>
      [{ name: "psiprobe", version: "0.1.4", dependencies: [] },
       { name: "psiprobe", version: "0.1.3", dependencies: [] }],
      "psql" =>
      [{ name: "psql", version: "0.1.0", dependencies: [["cutlery", "~> 0.1"]] }],
      "pssh" =>
      [{ name: "pssh", version: "0.1.2", dependencies: [] },
       { name: "pssh", version: "0.1.1", dependencies: [] },
       { name: "pssh", version: "0.1.0", dependencies: [] }],
      "puma" =>
      [{ name: "puma",
         version: "0.1.4",
         dependencies: [["monit", ">= 0.0.0"], ["logrotate", ">= 0.0.0"]] },
       { name: "puma",
         version: "0.1.3",
         dependencies: [["monit", ">= 0.0.0"], ["logrotate", ">= 0.0.0"]] },
       { name: "puma",
         version: "0.1.1",
         dependencies: [["monit", ">= 0.0.0"], ["logrotate", ">= 0.0.0"]] },
       { name: "puma",
         version: "0.1.0",
         dependencies: [["monit", ">= 0.0.0"], ["logrotate", ">= 0.0.0"]] }],
      "puppet" =>
      [{ name: "puppet", version: "0.2.0", dependencies: [["apt", ">= 0.0.0"]] }],
      "pure-ftpd" =>
      [{ name: "pure-ftpd",
         version: "0.1.0",
         dependencies: [["paths", ">= 0.0.0"]] }],
      "purse" => [{ name: "purse", version: "1.0.0", dependencies: [] }],
      "push-jobs" =>
      [{ name: "push-jobs",
         version: "2.2.0",
         dependencies: [["runit", ">= 0.0.0"], ["windows", ">= 0.0.0"]] },
       { name: "push-jobs",
         version: "2.0.1",
         dependencies: [["runit", ">= 0.0.0"], ["windows", ">= 0.0.0"]] },
       { name: "push-jobs",
         version: "2.0.0",
         dependencies: [["runit", ">= 0.0.0"], ["windows", ">= 0.0.0"]] }],
      "putty" =>
      [{ name: "putty",
         version: "0.0.5",
         dependencies: [["windows", ">= 1.2.8"]] }],
      "pvpgn" =>
      [{ name: "pvpgn",
         version: "0.0.22",
         dependencies: [["mysql", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] },
       { name: "pvpgn",
         version: "0.0.18",
         dependencies: [["mysql", ">= 0.0.0"], ["postgresql", ">= 0.0.0"]] }],
      "pxe_dust" =>
      [{ name: "pxe_dust",
         version: "1.6.0",
         dependencies: [["apache2", ">= 1.6.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.5.0",
         dependencies: [["apache2", ">= 1.6.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.4.1",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.4.0",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.3.4",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.3.2",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.3.0",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.2.6",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.2.4",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.2.3",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.2.2",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.2.1",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.2.0",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.1.2",
         dependencies: [["apache2", ">= 0.0.0"], ["tftp", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.1.1",
         dependencies: [["tftp", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.1.0",
         dependencies: [["tftp", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.0.1",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "pxe_dust",
         version: "1.0.0",
         dependencies: [["apache2", ">= 0.0.0"]] }],
      "pxe_install_server" =>
      [{ name: "pxe_install_server", version: "0.1.2", dependencies: [] },
       { name: "pxe_install_server", version: "0.1.1", dependencies: [] },
       { name: "pxe_install_server", version: "0.1.0", dependencies: [] }],
      "pycharm-community-edition" =>
      [{ name: "pycharm-community-edition",
         version: "0.1.2",
         dependencies: [["windows", ">= 1.2.6"]] }],
      "pygments" => [{ name: "pygments", version: "1.0.0", dependencies: [] }],
      "pypi-mirror" =>
      [{ name: "pypi-mirror",
         version: "0.0.5",
         dependencies: [["apache2", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "pypi-mirror",
         version: "0.0.4",
         dependencies: [["apache2", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "pypi-mirror",
         version: "0.0.3",
         dependencies: [["apache2", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "pypi-mirror",
         version: "0.0.2",
         dependencies: [["apache2", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "pypi-mirror",
         version: "0.0.1",
         dependencies: [["apache2", ">= 0.0.0"], ["python", ">= 0.0.0"]] }],
      "python-sip" =>
      [{ name: "python-sip",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "quick_start" => [{ name: "quick_start", version: "0.7.0", dependencies: [] }],
      "R" => [{ name: "R", version: "0.0.1", dependencies: [] }],
      "r-project" =>
      [{ name: "r-project",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "r-project",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "rabbitmq-management" =>
      [{ name: "rabbitmq-management",
         version: "0.0.3",
         dependencies: [["rabbitmq", ">= 0.0.0"]] }],
      "rabbitmq_chef" =>
      [{ name: "rabbitmq_chef",
         version: "0.10.4",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "rabbitmq_chef",
         version: "0.10.3",
         dependencies: [["erlang", ">= 0.0.0"]] },
       { name: "rabbitmq_chef", version: "0.10.0", dependencies: [] }],
      "rabbitmq_settings" =>
      [{ name: "rabbitmq_settings",
         version: "0.1.0",
         dependencies: [["rabbitmq", ">= 0.0.0"]] }],
      "rackbox" =>
      [{ name: "rackbox",
         version: "0.1.2",
         dependencies: [["appbox", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 1.2.2"],
          ["runit", ">= 1.1.2"]] },
       { name: "rackbox",
         version: "0.1.1",
         dependencies: [["appbox", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 1.2.2"],
          ["runit", ">= 1.1.2"]] },
       { name: "rackbox",
         version: "0.1.0",
         dependencies: [["appbox", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 1.2.2"],
          ["runit", ">= 1.1.2"]] }],
      "rackconnect" =>
      [{ name: "rackconnect",
         version: "0.1.0",
         dependencies: [["sudo", ">= 0.0.0"]] }],
      "rackmonkey" =>
      [{ name: "rackmonkey",
         version: "0.2.0",
         dependencies: [["postgresql", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cpan", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"]] },
       { name: "rackmonkey", version: "0.1.0", dependencies: [] }],
      "rackspace-dns" =>
      [{ name: "rackspace-dns", version: "1.0.0", dependencies: [] }],
      "rackspacecloudbackup" =>
      [{ name: "rackspacecloudbackup", version: "0.0.1", dependencies: [] }],
      "rackspaceknife" =>
      [{ name: "rackspaceknife",
         version: "0.0.10",
         dependencies: [["perl", ">= 0.0.0"], ["minitest-handler", ">= 0.0.0"]] },
       { name: "rackspaceknife",
         version: "0.0.8",
         dependencies: [["perl", ">= 0.0.0"], ["minitest-handler", ">= 0.0.0"]] },
       { name: "rackspaceknife",
         version: "0.0.4",
         dependencies: [["perl", ">= 0.0.0"]] },
       { name: "rackspaceknife", version: "0.0.2", dependencies: [] }],
      "rackspace_networks" =>
      [{ name: "rackspace_networks",
         version: "0.1.2",
         dependencies: [["ohai", ">= 0.0.0"]] },
       { name: "rackspace_networks",
         version: "0.1.0",
         dependencies: [["ohai", ">= 0.0.0"]] }],
      "racoon-ipsec-osx" =>
      [{ name: "racoon-ipsec-osx", version: "0.1.1", dependencies: [] }],
      "radiant" =>
      [{ name: "radiant",
         version: "1.0.2",
         dependencies: [["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "radiant",
         version: "1.0.1",
         dependencies: [["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "radiant",
         version: "1.0.0",
         dependencies: [["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "radiant",
         version: "0.11.3",
         dependencies: [["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["rails", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "radiant",
         version: "0.11.2",
         dependencies: [["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["rails", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "radiant",
         version: "0.11.1",
         dependencies: [["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["rails", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "radiant",
         version: "0.11.0",
         dependencies: [["git", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["rails", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"]] },
       { name: "radiant",
         version: "0.10.2",
         dependencies: [["rails", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "radiant",
         version: "0.9.0",
         dependencies: [["rails", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "railo" =>
      [{ name: "railo",
         version: "0.1.1",
         dependencies: [["tomcat", ">= 0.0.0"]] },
       { name: "railo",
         version: "0.1.0",
         dependencies: [["tomcat", ">= 0.0.0"]] }],
      "rails" =>
      [{ name: "rails",
         version: "0.9.2",
         dependencies: [["apache2", ">= 0.0.0"], ["ruby", ">= 0.0.0"]] },
       { name: "rails",
         version: "0.8.0",
         dependencies: [["apache2", ">= 0.0.0"], ["ruby", ">= 0.0.0"]] }],
      "railsbox" =>
      [{ name: "railsbox",
         version: "0.1.0",
         dependencies: [["appbox", ">= 0.0.0"],
          ["rbenv", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 1.2.2"],
          ["runit", ">= 1.1.2"],
          ["postgresql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] }],
      "rails_application" =>
      [{ name: "rails_application",
         version: "0.2.3",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 1.2.1"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.2.2",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.2.1",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.2.0",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.10",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.9",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.8",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.7",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.6",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.5",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.4",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.3",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 2.0.2"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.2",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 0.0.0"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] },
       { name: "rails_application",
         version: "0.1.1",
         dependencies: [["git", ">= 0.0.0"],
          ["ruby", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["unicorn", ">= 0.0.0"],
          ["application", ">= 0.0.0"],
          ["application_ruby", ">= 0.0.0"],
          ["application_nginx", ">= 0.0.0"]] }],
      "rails_enterprise" =>
      [{ name: "rails_enterprise",
         version: "0.3.1",
         dependencies: [["ruby_enterprise", ">= 0.0.0"]] },
       { name: "rails_enterprise",
         version: "0.3.0",
         dependencies: [["ruby_enterprise", ">= 0.0.0"]] },
       { name: "rails_enterprise",
         version: "0.1.0",
         dependencies: [["ruby_enterprise", ">= 0.0.0"]] }],
      "rails_rvm" =>
      [{ name: "rails_rvm",
         version: "0.1.0",
         dependencies: [["rvm", ">= 0.0.0"]] }],
      "rake" =>
      [{ name: "rake", version: "0.1.1", dependencies: [] },
       { name: "rake", version: "0.1.0", dependencies: [] }],
      "raspberry-pi" =>
      [{ name: "raspberry-pi", version: "0.1.0", dependencies: [] }],
      "raxmon-cli" =>
      [{ name: "raxmon-cli",
         version: "0.0.4",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "raxmon-cli",
         version: "0.0.3",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "raxmon-cli",
         version: "0.0.2",
         dependencies: [["python", ">= 0.0.0"]] }],
      "rayo" =>
      [{ name: "rayo",
         version: "1.0.12",
         dependencies: [["prism", ">= 0.0.0"], ["cassandra", ">= 0.0.0"]] },
       { name: "rayo", version: "0.0.1", dependencies: [["prism", ">= 0.0.0"]] }],
      "razor" =>
      [{ name: "razor",
         version: "0.5.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["tftp", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] },
       { name: "razor",
         version: "0.4.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["tftp", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] },
       { name: "razor",
         version: "0.3.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["tftp", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] },
       { name: "razor",
         version: "0.2.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["tftp", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] }],
      "rbac" =>
      [{ name: "rbac", version: "1.0.1", dependencies: [] },
       { name: "rbac", version: "1.0.0", dependencies: [] },
       { name: "rbac", version: "0.0.3", dependencies: [] }],
      "rbenv-bootstrap" =>
      [{ name: "rbenv-bootstrap",
         version: "0.1.0",
         dependencies: [["rbenv", ">= 0.0.0"]] }],
      "rbenv-gemset" =>
      [{ name: "rbenv-gemset",
         version: "0.1.1",
         dependencies: [["rbenv", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "rbenv-gemset",
         version: "0.1.0",
         dependencies: [["rbenv", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "rbenv-install-rubies" =>
      [{ name: "rbenv-install-rubies",
         version: "0.2.1",
         dependencies: [["rbenv", ">= 0.0.0"]] },
       { name: "rbenv-install-rubies",
         version: "0.2.0",
         dependencies: [["rbenv", ">= 0.0.0"]] }],
      "rc_mon" =>
      [{ name: "rc_mon",
         version: "0.2.0",
         dependencies: [["control_groups", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "rc_mon",
         version: "0.1.6",
         dependencies: [["control_groups", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "rc_mon",
         version: "0.1.4",
         dependencies: [["control_groups", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "rc_mon",
         version: "0.1.2",
         dependencies: [["control_groups", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "rc_mon",
         version: "0.1.0",
         dependencies: [["control_groups", ">= 0.0.0"], ["runit", ">= 0.0.0"]] }],
      "rdiff-backup" =>
      [{ name: "rdiff-backup",
         version: "1.0.1",
         dependencies: [["ssh_known_hosts", ">= 0.0.0"], ["sudo", ">= 0.0.0"]] },
       { name: "rdiff-backup",
         version: "1.0.0",
         dependencies: [["ssh_known_hosts", ">= 0.0.0"], ["sudo", ">= 0.0.0"]] }],
      "re2" =>
      [{ name: "re2",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["mercurial", ">= 0.0.0"]] }],
      "readline" =>
      [{ name: "readline", version: "0.0.4", dependencies: [] },
       { name: "readline", version: "0.0.3", dependencies: [] }],
      "reboot-handler" =>
      [{ name: "reboot-handler",
         version: "0.2.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "reboot-handler",
         version: "0.1.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "reboot-handler",
         version: "0.1.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "reboot-handler",
         version: "0.1.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "recognizer" =>
      [{ name: "recognizer",
         version: "0.0.8",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "recognizer",
         version: "0.0.7",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "recognizer",
         version: "0.0.6",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "recognizer",
         version: "0.0.5",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "recognizer",
         version: "0.0.4",
         dependencies: [["java", ">= 0.0.0"]] }],
      "redis" =>
      [{ name: "redis",
         version: "3.0.4",
         dependencies: [["runit", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"]] },
       { name: "redis",
         version: "3.0.3",
         dependencies: [["runit", ">= 0.0.0"],
          ["install_from", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"]] },
       { name: "redis",
         version: "3.0.0",
         dependencies: [["runit", ">= 0.0.0"], ["install_from", ">= 0.0.0"]] }],
      "redis-package" =>
      [{ name: "redis-package", version: "1.0.0", dependencies: [] }],
      "redis-test" => [{ name: "redis-test", version: "0.2.0", dependencies: [] }],
      "redis2" =>
      [{ name: "redis2",
         version: "0.5.0",
         dependencies: [["runit", ">= 1.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["ark", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.4.7",
         dependencies: [["runit", ">= 1.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.4.6",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.4.5",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.4.4",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.3.3",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.3.2",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.3.1",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.3.0",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.2.1",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2",
         version: "0.2.0",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "redis2", version: "0.1.0", dependencies: [] }],
      "redisio" =>
      [{ name: "redisio",
         version: "1.7.1",
         dependencies: [["ulimit", ">= 0.1.2"]] },
       { name: "redisio",
         version: "1.7.0",
         dependencies: [["ulimit", ">= 0.1.2"]] },
       { name: "redisio",
         version: "1.6.0",
         dependencies: [["ulimit", ">= 0.1.2"]] },
       { name: "redisio",
         version: "1.5.0",
         dependencies: [["ulimit", ">= 0.1.2"]] },
       { name: "redisio",
         version: "1.4.1",
         dependencies: [["ulimit", ">= 0.1.2"]] },
       { name: "redisio", version: "1.3.2", dependencies: [] },
       { name: "redisio", version: "1.3.0", dependencies: [] },
       { name: "redisio", version: "1.2.0", dependencies: [] },
       { name: "redisio", version: "1.1.0", dependencies: [] },
       { name: "redisio", version: "1.0.3", dependencies: [] },
       { name: "redisio", version: "1.0.2", dependencies: [] },
       { name: "redisio", version: "1.0.1", dependencies: [] },
       { name: "redisio", version: "1.0.0", dependencies: [] }],
      "redis_2_cookbook" =>
      [{ name: "redis_2_cookbook", version: "0.3.3", dependencies: [] },
       { name: "redis_2_cookbook", version: "0.3.2", dependencies: [] },
       { name: "redis_2_cookbook", version: "0.3.1", dependencies: [] }],
      "redmine" =>
      [{ name: "redmine",
         version: "0.10.3",
         dependencies: [["apache2", ">= 0.0.0"],
          ["rails", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"]] },
       { name: "redmine",
         version: "0.10.2",
         dependencies: [["rails", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "redmine",
         version: "0.8.0",
         dependencies: [["rails", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["passenger_apache2", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "redmine2" =>
      [{ name: "redmine2",
         version: "0.1.0",
         dependencies: [["rbenv", ">= 0.0.0"],
          ["ruby_build", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["sqlite", ">= 0.0.0"]] }],
      "red_unicorn" =>
      [{ name: "red_unicorn",
         version: "0.1.2",
         dependencies: [["bluepill", ">= 0.0.0"]] },
       { name: "red_unicorn",
         version: "0.1.0",
         dependencies: [["bluepill", ">= 0.0.0"]] },
       { name: "red_unicorn",
         version: "0.0.1",
         dependencies: [["bluepill", ">= 0.0.0"]] }],
      "reginjector" =>
      [{ name: "reginjector", version: "0.2.0", dependencies: [] },
       { name: "reginjector", version: "0.1.3", dependencies: [] },
       { name: "reginjector", version: "0.1.1", dependencies: [] }],
      "rehost-munin" =>
      [{ name: "rehost-munin", version: "0.1.13", dependencies: [] }],
      "rehost-nagios" =>
      [{ name: "rehost-nagios", version: "1.0.11", dependencies: [] }],
      "remote_syslog" =>
      [{ name: "remote_syslog", version: "0.1.0", dependencies: [] }],
      "remote_template" =>
      [{ name: "remote_template", version: "0.0.1", dependencies: [] }],
      "repmgr" =>
      [{ name: "repmgr",
         version: "0.2.2",
         dependencies: [["postgresql", ">= 2.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["discovery", ">= 0.2.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "repmgr",
         version: "0.2.0",
         dependencies: [["postgresql", ">= 2.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["discovery", ">= 0.2.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "repmgr",
         version: "0.1.2",
         dependencies: [["postgresql", ">= 2.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["discovery", ">= 0.2.0"]] },
       { name: "repmgr",
         version: "0.1.1",
         dependencies: [["postgresql", ">= 2.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["discovery", ">= 2.0.0"]] },
       { name: "repmgr",
         version: "0.1.0",
         dependencies: [["postgresql", ">= 2.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["database", ">= 0.0.0"]] }],
      "reportchef" =>
      [{ name: "reportchef",
         version: "1.0.3",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "reportchef",
         version: "1.0.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "reportchef",
         version: "1.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "reportchef",
         version: "1.0.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "repos" =>
      [{ name: "repos", version: "0.0.3", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "repos", version: "0.0.2", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "repos", version: "0.0.1", dependencies: [["apt", ">= 0.0.0"]] }],
      "repository" =>
      [{ name: "repository",
         version: "0.1.8",
         dependencies: [["apache2", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["gpg", ">= 0.2.2"]] },
       { name: "repository",
         version: "0.1.6",
         dependencies: [["apache2", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["gpg", ">= 0.2.2"]] },
       { name: "repository",
         version: "0.1.4",
         dependencies: [["apache2", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["gpg", ">= 0.2.2"]] },
       { name: "repository",
         version: "0.1.2",
         dependencies: [["apache2", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["gpg", ">= 0.0.0"]] },
       { name: "repository",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["gpg", ">= 0.0.0"]] }],
      "reprepro" =>
      [{ name: "reprepro",
         version: "0.4.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"]] },
       { name: "reprepro",
         version: "0.4.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "reprepro",
         version: "0.3.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "reprepro",
         version: "0.2.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "reprepro",
         version: "0.2.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "reprepro",
         version: "0.2.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "resolvconf" =>
      [{ name: "resolvconf", version: "0.1.1", dependencies: [] },
       { name: "resolvconf", version: "0.1.0", dependencies: [] }],
      "resolver" =>
      [{ name: "resolver", version: "1.1.4", dependencies: [] },
       { name: "resolver", version: "1.1.2", dependencies: [] },
       { name: "resolver", version: "1.1.0", dependencies: [] },
       { name: "resolver", version: "1.0.2", dependencies: [] },
       { name: "resolver", version: "1.0.0", dependencies: [] },
       { name: "resolver", version: "0.8.2", dependencies: [] },
       { name: "resolver", version: "0.8.1", dependencies: [] },
       { name: "resolver", version: "0.7.0", dependencies: [] }],
      "resource-control" =>
      [{ name: "resource-control", version: "0.1.1", dependencies: [] },
       { name: "resource-control", version: "0.1.0", dependencies: [] },
       { name: "resource-control", version: "0.0.3", dependencies: [] },
       { name: "resource-control", version: "0.0.1", dependencies: [] }],
      "resource-tester" =>
      [{ name: "resource-tester",
         version: "0.1.4",
         dependencies: [["minitest-handler", ">= 0.0.0"]] },
       { name: "resource-tester",
         version: "0.1.3",
         dependencies: [["minitest-handler", ">= 0.0.0"]] }],
      "resource_masher" =>
      [{ name: "resource_masher", version: "0.10.0", dependencies: [] },
       { name: "resource_masher", version: "0.9.0", dependencies: [] }],
      "resque" =>
      [{ name: "resque",
         version: "3.0.4",
         dependencies: [["runit", ">= 0.0.0"], ["redis", ">= 0.0.0"]] },
       { name: "resque",
         version: "3.0.3",
         dependencies: [["runit", ">= 0.0.0"], ["redis", ">= 0.0.0"]] },
       { name: "resque",
         version: "3.0.0",
         dependencies: [["runit", ">= 0.0.0"], ["redis", ">= 0.0.0"]] }],
      "rethinkdb" =>
      [{ name: "rethinkdb",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 3.0.0"],
          ["yum-epel", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["nodejs", ">= 0.0.0"]] }],
      "revealcloud" =>
      [{ name: "revealcloud", version: "0.0.8", dependencies: [] },
       { name: "revealcloud", version: "0.0.6", dependencies: [] },
       { name: "revealcloud", version: "0.0.5", dependencies: [] },
       { name: "revealcloud", version: "0.0.4", dependencies: [] },
       { name: "revealcloud", version: "0.0.3", dependencies: [] },
       { name: "revealcloud", version: "0.0.2", dependencies: [] },
       { name: "revealcloud", version: "0.0.1", dependencies: [] }],
      "rhn" => [{ name: "rhn", version: "0.2.0", dependencies: [] }],
      "riak" =>
      [{ name: "riak",
         version: "2.4.7",
         dependencies: [["apt", "~> 2.3.8"],
          ["build-essential", "~> 1.4.2"],
          ["erlang", "~> 1.5.0"],
          ["git", "~> 3.0"],
          ["sysctl", "~> 0.3.5"],
          ["ulimit", "~> 0.3.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", "~> 0.3"]] },
       { name: "riak",
         version: "2.4.6",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"],
          ["yum", "~> 3.0"]] },
       { name: "riak",
         version: "2.4.5",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"],
          ["yum", "< 3.0.0"]] },
       { name: "riak",
         version: "2.4.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"],
          ["yum", "< 3.0.0"]] },
       { name: "riak",
         version: "2.4.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"],
          ["yum", "< 3.0.0"]] },
       { name: "riak",
         version: "2.4.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["sysctl", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "2.4.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "2.4.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "2.3.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "2.3.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "2.3.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "2.2.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "2.0.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "2.0.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["ulimit", ">= 0.0.0"]] },
       { name: "riak",
         version: "1.3.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"]] },
       { name: "riak", version: "1.2.1", dependencies: [] },
       { name: "riak", version: "1.1.0", dependencies: [] },
       { name: "riak", version: "1.0.3", dependencies: [] },
       { name: "riak",
         version: "1.0.2",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.14.5",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.14.4",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.14.3",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.14.2",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.14.1",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.14.0",
         dependencies: [["iptables", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.12.1",
         dependencies: [["erlang", ">= 0.0.0"], ["iptables", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.12.0",
         dependencies: [["iptables", ">= 0.0.0"], ["erlang", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.11.0",
         dependencies: [["iptables", ">= 0.0.0"],
          ["mercurial", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"]] },
       { name: "riak",
         version: "0.1.0",
         dependencies: [["iptables", ">= 0.0.0"],
          ["mercurial", ">= 0.0.0"],
          ["erlang", ">= 0.0.0"]] }],
      "riak-cs" =>
      [{ name: "riak-cs",
         version: "2.2.6",
         dependencies: [["apt", "~> 2.3.8"],
          ["riak", "~> 2.4.7"],
          ["ulimit", "~> 0.3.2"],
          ["yum", "~> 3.0"],
          ["yum-epel", "~> 0.3"]] },
       { name: "riak-cs",
         version: "2.2.4",
         dependencies: [["ulimit", ">= 0.0.0"]] },
       { name: "riak-cs",
         version: "2.2.3",
         dependencies: [["ulimit", ">= 0.0.0"]] },
       { name: "riak-cs",
         version: "2.2.1",
         dependencies: [["ulimit", ">= 0.0.0"]] },
       { name: "riak-cs", version: "2.0.0", dependencies: [] },
       { name: "riak-cs", version: "1.3.0", dependencies: [] },
       { name: "riak-cs", version: "1.2.2", dependencies: [] }],
      "riemann" => [{ name: "riemann", version: "1.0.0", dependencies: [] }],
      "rightscale" =>
      [{ name: "rightscale",
         version: "0.1.1",
         dependencies: [["collectd", ">= 0.0.0"], ["rest_connection", ">= 0.0.0"]] },
       { name: "rightscale",
         version: "0.1.0",
         dependencies: [["collectd", ">= 0.0.0"], ["rest_connection", ">= 0.0.0"]] }],
      "rightscale_backup" =>
      [{ name: "rightscale_backup", version: "1.0.1", dependencies: [] },
       { name: "rightscale_backup", version: "1.0.0", dependencies: [] }],
      "rightscale_tag" =>
      [{ name: "rightscale_tag",
         version: "1.0.1",
         dependencies: [["machine_tag", "~> 1.0.3"], ["marker", "~> 1.0.0"]] }],
      "rightscale_volume" =>
      [{ name: "rightscale_volume", version: "1.0.1", dependencies: [] },
       { name: "rightscale_volume", version: "1.0.0", dependencies: [] }],
      "riot_mysql" =>
      [{ name: "riot_mysql",
         version: "1.2.8",
         dependencies: [["openssl", ">= 0.0.0"]] },
       { name: "riot_mysql",
         version: "1.2.7",
         dependencies: [["openssl", ">= 0.0.0"]] }],
      "rng-tools" =>
      [{ name: "rng-tools", version: "1.1.0", dependencies: [] },
       { name: "rng-tools", version: "1.0.0", dependencies: [] }],
      "robot" =>
      [{ name: "robot",
         version: "0.1.1",
         dependencies: [["java", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "robot",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["python", ">= 0.0.0"]] }],
      "robottest" =>
      [{ name: "robottest",
         version: "0.1.1",
         dependencies: [["robot", ">= 0.0.0"]] },
       { name: "robottest",
         version: "0.1.0",
         dependencies: [["robot", ">= 0.0.0"]] }],
      "rot13" => [{ name: "rot13", version: "1.0.0", dependencies: [] }],
      "route53" =>
      [{ name: "route53",
         version: "0.3.3",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "route53", version: "0.3.2", dependencies: [] },
       { name: "route53", version: "0.3.1", dependencies: [] },
       { name: "route53", version: "0.3.0", dependencies: [] },
       { name: "route53", version: "0.2.0", dependencies: [] },
       { name: "route53", version: "0.1.0", dependencies: [] },
       { name: "route53", version: "0.0.1", dependencies: [] }],
      "rsdns" =>
      [{ name: "rsdns", version: "0.0.4", dependencies: [] },
       { name: "rsdns", version: "0.0.3", dependencies: [] },
       { name: "rsdns", version: "0.0.2", dependencies: [] }],
      "Rstats" =>
      [{ name: "Rstats", version: "3.0.4", dependencies: [] },
       { name: "Rstats", version: "3.0.3", dependencies: [] },
       { name: "Rstats", version: "3.0.0", dependencies: [] }],
      "rsync" =>
      [{ name: "rsync", version: "0.8.4", dependencies: [] },
       { name: "rsync", version: "0.8.2", dependencies: [] },
       { name: "rsync", version: "0.8.0", dependencies: [] },
       { name: "rsync", version: "0.7.0", dependencies: [] }],
      "rubies" =>
      [{ name: "rubies",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["chruby_install", ">= 0.0.0"],
          ["ruby_install", ">= 0.0.0"]] }],
      "ruby" =>
      [{ name: "ruby", version: "0.9.2", dependencies: [] },
       { name: "ruby", version: "0.9.0", dependencies: [] },
       { name: "ruby", version: "0.8.0", dependencies: [] },
       { name: "ruby", version: "0.7.3", dependencies: [] },
       { name: "ruby", version: "0.7.2", dependencies: [] },
       { name: "ruby", version: "0.7.0", dependencies: [] }],
      "ruby-helper" => [{ name: "ruby-helper", version: "0.0.1", dependencies: [] }],
      "ruby-install" =>
      [{ name: "ruby-install",
         version: "0.1.1",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "ruby-install",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"]] }],
      "ruby-ng" =>
      [{ name: "ruby-ng", version: "0.1.1", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "ruby-ng",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "rubycas" =>
      [{ name: "rubycas",
         version: "0.6.1",
         dependencies: [["logrotate", ">= 0.0.0"],
          ["rvm", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["god", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["database", ">= 0.0.0"]] },
       { name: "rubycas",
         version: "0.6.0",
         dependencies: [["database", ">= 0.0.0"],
          ["god", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rvm", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"]] },
       { name: "rubycas",
         version: "0.5.0",
         dependencies: [["database", ">= 0.0.0"],
          ["god", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["nginx", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["rvm", ">= 0.0.0"],
          ["logrotate", ">= 0.0.0"]] }],
      "rubygems" =>
      [{ name: "rubygems", version: "0.3.0", dependencies: [] },
       { name: "rubygems", version: "0.2.0", dependencies: [] },
       { name: "rubygems", version: "0.1.0", dependencies: [] }],
      "rubygems-compatibility" =>
      [{ name: "rubygems-compatibility", version: "0.1.0", dependencies: [] }],
      "ruby_enterprise" =>
      [{ name: "ruby_enterprise",
         version: "0.2.6",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ruby_enterprise",
         version: "0.2.5",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ruby_enterprise",
         version: "0.2.4",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ruby_enterprise",
         version: "0.2.3",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ruby_enterprise",
         version: "0.2.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ruby_enterprise",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "ruby_install" =>
      [{ name: "ruby_install",
         version: "1.0.2",
         dependencies: [["ark", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "ruby_install",
         version: "1.0.0",
         dependencies: [["ark", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "ruby_install",
         version: "0.1.2",
         dependencies: [["ark", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "ruby_install",
         version: "0.1.1",
         dependencies: [["ark", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "ruby_install",
         version: "0.1.0",
         dependencies: [["ark", ">= 0.0.0"], ["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "ruby_installer" =>
      [{ name: "ruby_installer",
         version: "0.1.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ruby_installer",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ruby_installer",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "ruby_pkg" =>
      [{ name: "ruby_pkg",
         version: "0.4.0",
         dependencies: [["fpm-tng", "~> 0.1.6"], ["ruby_build", "~> 0.6"]] },
       { name: "ruby_pkg",
         version: "0.3.2",
         dependencies: [["fpm-tng", "~> 0.1.6"], ["ruby_build", "~> 0.6"]] },
       { name: "ruby_pkg",
         version: "0.3.0",
         dependencies: [["fpm-tng", "~> 0.1.6"], ["ruby_build", "~> 0.6"]] },
       { name: "ruby_pkg",
         version: "0.2.0",
         dependencies: [["fpm-tng", "~> 0.1.6"], ["ruby_build", "~> 0.6"]] },
       { name: "ruby_pkg",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["fpm-tng", "~> 0.1.6"],
          ["ruby_build", "~> 0.6"]] }],
      "rundeck" =>
      [{ name: "rundeck",
         version: "2.0.2",
         dependencies: [["runit", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["rundeck", ">= 0.0.0"]] },
       { name: "rundeck",
         version: "2.0.0",
         dependencies: [["runit", ">= 0.0.0"],
          ["sudo", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "runlist_modifiers" =>
      [{ name: "runlist_modifiers", version: "0.1.2", dependencies: [] },
       { name: "runlist_modifiers", version: "0.1.1", dependencies: [] },
       { name: "runlist_modifiers", version: "0.1.0", dependencies: [] }],
      "run_action_now" =>
      [{ name: "run_action_now", version: "0.1.0", dependencies: [] }],
      "run_once" => [{ name: "run_once", version: "0.1.1", dependencies: [] }],
      "rush" => [{ name: "rush", version: "0.1.0", dependencies: [] }],
      "s3cfg" => [{ name: "s3cfg", version: "0.1.0", dependencies: [] }],
      "s3cmd" => [{ name: "s3cmd", version: "0.0.1", dependencies: [] }],
      "s3cmd-master" =>
      [{ name: "s3cmd-master", version: "0.1.0", dependencies: [] }],
      "s3fs" =>
      [{ name: "s3fs", version: "1.1.0", dependencies: [] },
       { name: "s3fs", version: "1.0.3", dependencies: [] },
       { name: "s3fs", version: "1.0.1", dependencies: [] },
       { name: "s3fs", version: "1.0.0", dependencies: [] },
       { name: "s3fs", version: "0.0.7", dependencies: [] },
       { name: "s3fs", version: "0.0.6", dependencies: [] },
       { name: "s3fs", version: "0.0.5", dependencies: [] },
       { name: "s3fs", version: "0.0.4", dependencies: [] },
       { name: "s3fs", version: "0.0.3", dependencies: [] },
       { name: "s3fs", version: "0.0.2", dependencies: [] },
       { name: "s3fs", version: "0.0.1", dependencies: [] }],
      "s3fs-c" =>
      [{ name: "s3fs-c", version: "0.0.2", dependencies: [["git", ">= 0.0.0"]] },
       { name: "s3fs-c", version: "0.0.1", dependencies: [["git", ">= 0.0.0"]] }],
      "s3fs-fuse" =>
      [{ name: "s3fs-fuse",
         version: "0.1.0",
         dependencies: [["rc_mon", ">= 0.0.0"]] },
       { name: "s3fs-fuse",
         version: "0.0.8",
         dependencies: [["bluepill", ">= 0.0.0"]] },
       { name: "s3fs-fuse",
         version: "0.0.7",
         dependencies: [["bluepill", ">= 0.0.0"]] }],
      "s3sync" => [{ name: "s3sync", version: "0.0.1", dependencies: [] }],
      "s3_file" =>
      [{ name: "s3_file", version: "2.3.3", dependencies: [] },
       { name: "s3_file", version: "2.3.2", dependencies: [] },
       { name: "s3_file", version: "2.3.1", dependencies: [] },
       { name: "s3_file", version: "2.3.0", dependencies: [] },
       { name: "s3_file", version: "2.2.1", dependencies: [] },
       { name: "s3_file", version: "2.2.0", dependencies: [] },
       { name: "s3_file", version: "2.1.1", dependencies: [] },
       { name: "s3_file", version: "2.1.0", dependencies: [] },
       { name: "s3_file", version: "2.0.4", dependencies: [] },
       { name: "s3_file", version: "2.0.3", dependencies: [] },
       { name: "s3_file", version: "2.0.2", dependencies: [] },
       { name: "s3_file", version: "2.0.1", dependencies: [] },
       { name: "s3_file", version: "1.1.1", dependencies: [] },
       { name: "s3_file", version: "1.1.0", dependencies: [] },
       { name: "s3_file", version: "1.0.1", dependencies: [] },
       { name: "s3_file", version: "1.0.0", dependencies: [] }],
      "s6" =>
      [{ name: "s6",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "sabnzbd" => [{ name: "sabnzbd", version: "1.0.0", dependencies: [] }],
      "samba" =>
      [{ name: "samba", version: "0.11.4", dependencies: [] },
       { name: "samba", version: "0.11.2", dependencies: [] },
       { name: "samba", version: "0.11.0", dependencies: [] },
       { name: "samba", version: "0.10.6", dependencies: [] },
       { name: "samba", version: "0.10.4", dependencies: [] },
       { name: "samba", version: "0.10.3", dependencies: [] },
       { name: "samba", version: "0.10.2", dependencies: [] },
       { name: "samba", version: "0.10.0", dependencies: [] }],
      "samba-ad" =>
      [{ name: "samba-ad", version: "0.1.0", dependencies: [] },
       { name: "samba-ad", version: "0.0.2", dependencies: [] }],
      "sanitize" =>
      [{ name: "sanitize",
         version: "0.5.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["dmg", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.5.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["dmg", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.5.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["dmg", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"],
          ["chef-helpers", "~> 0.1"]] },
       { name: "sanitize",
         version: "0.5.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["dmg", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"],
          ["chef-sugar", "~> 1.1"]] },
       { name: "sanitize",
         version: "0.4.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["dmg", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.4.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["dmg", ">= 0.0.0"],
          ["homebrew", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.4.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.3.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["chef-client", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"],
          ["omnibus_updater", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.2.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] },
       { name: "sanitize",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["iptables", ">= 0.0.0"]] }],
      "sar" => [{ name: "sar", version: "0.0.1", dependencies: [] }],
      "sargrapho" => [{ name: "sargrapho", version: "1.0.0", dependencies: [] }],
      "sauceconnect" =>
      [{ name: "sauceconnect",
         version: "0.1.10",
         dependencies: [["java", ">= 0.0.0"]] }],
      "sbt-extras" =>
      [{ name: "sbt-extras",
         version: "0.2.2",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "sbt-extras",
         version: "0.2.1",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "sbt-extras",
         version: "0.2.0",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "sbt-extras",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"]] }],
      "sbuild" =>
      [{ name: "sbuild",
         version: "0.3.3",
         dependencies: [["xfs", ">= 0.0.0"], ["lvm", ">= 0.0.0"]] },
       { name: "sbuild",
         version: "0.3.2",
         dependencies: [["lvm", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] },
       { name: "sbuild",
         version: "0.3.0",
         dependencies: [["lvm", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] },
       { name: "sbuild",
         version: "0.2.0",
         dependencies: [["lvm", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] }],
      "scala" =>
      [{ name: "scala",
         version: "1.0.0",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "scala",
         version: "0.0.2",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] },
       { name: "scala",
         version: "0.0.1",
         dependencies: [["java", ">= 0.0.0"], ["ark", ">= 0.0.0"]] }],
      "scanner-nmap" =>
      [{ name: "scanner-nmap", version: "0.1.0", dependencies: [] }],
      "scansnap1300i" =>
      [{ name: "scansnap1300i",
         version: "1.0.0",
         dependencies: [["dmg", ">= 0.0.0"]] }],
      "scipy" =>
      [{ name: "scipy",
         version: "0.3.1",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "scipy",
         version: "0.3.0",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "scipy",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "scipy",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "scout-agent" =>
      [{ name: "scout-agent",
         version: "1.0.0",
         dependencies: [["rvm", ">= 0.0.0"]] }],
      "scoutapp" =>
      [{ name: "scoutapp", version: "0.0.9", dependencies: [] },
       { name: "scoutapp", version: "0.0.8", dependencies: [] },
       { name: "scoutapp", version: "0.0.6", dependencies: [] },
       { name: "scoutapp", version: "0.0.5", dependencies: [] },
       { name: "scoutapp", version: "0.0.4", dependencies: [] },
       { name: "scoutapp", version: "0.0.3", dependencies: [] },
       { name: "scoutapp", version: "0.0.2", dependencies: [] },
       { name: "scoutapp", version: "0.0.1", dependencies: [] }],
      "scout_agent" => [{ name: "scout_agent", version: "0.1.0", dependencies: [] }],
      "screen" =>
      [{ name: "screen",
         version: "0.8.0",
         dependencies: [["git", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "screen", version: "0.7.0", dependencies: [] }],
      "search-utils" =>
      [{ name: "search-utils",
         version: "2.0.1",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "search-utils",
         version: "2.0.0",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "search-utils",
         version: "1.1.0",
         dependencies: [["partial_search", ">= 0.0.0"]] }],
      "searchef" => [{ name: "searchef", version: "0.2.0", dependencies: [] }],
      "selenium" =>
      [{ name: "selenium", version: "0.0.2", dependencies: [] },
       { name: "selenium", version: "0.0.1", dependencies: [] }],
      "selenium-grid" =>
      [{ name: "selenium-grid", version: "0.0.1", dependencies: [] }],
      "selfsigned_certificate" =>
      [{ name: "selfsigned_certificate", version: "0.1.0", dependencies: [] }],
      "selinux" =>
      [{ name: "selinux", version: "0.7.2", dependencies: [] },
       { name: "selinux", version: "0.7.0", dependencies: [] },
       { name: "selinux", version: "0.6.2", dependencies: [] },
       { name: "selinux", version: "0.6.0", dependencies: [] },
       { name: "selinux", version: "0.5.6", dependencies: [] },
       { name: "selinux", version: "0.5.4", dependencies: [] },
       { name: "selinux", version: "0.5.2", dependencies: [] },
       { name: "selinux", version: "0.5.0", dependencies: [] },
       { name: "selinux", version: "0.1.0", dependencies: [] }],
      "sendmail" => [{ name: "sendmail", version: "0.1.0", dependencies: [] }],
      "sensors" =>
      [{ name: "sensors", version: "0.9.1", dependencies: [] },
       { name: "sensors", version: "0.9.0", dependencies: [] }],
      "sensu_client" =>
      [{ name: "sensu_client",
         version: "0.1.0",
         dependencies: [["sensu", ">= 0.0.0"]] }],
      "sensu_server" =>
      [{ name: "sensu_server",
         version: "0.1.0",
         dependencies: [["sensu", ">= 0.0.0"]] }],
      "sensu_spec" =>
      [{ name: "sensu_spec",
         version: "0.2.5",
         dependencies: [["apt", "~> 2.3"], ["yum", "~> 3.0"], ["yum-epel", "~> 0.2"]] }],
      "sequel" => [{ name: "sequel", version: "0.1.0", dependencies: [] }],
      "serf" =>
      [{ name: "serf", version: "0.5.0", dependencies: [] },
       { name: "serf", version: "0.4.2", dependencies: [] },
       { name: "serf", version: "0.4.1", dependencies: [] },
       { name: "serf", version: "0.4.0", dependencies: [] },
       { name: "serf", version: "0.3.0", dependencies: [] },
       { name: "serf", version: "0.2.1", dependencies: [] },
       { name: "serf", version: "0.2.0", dependencies: [] }],
      "serverdensity" =>
      [{ name: "serverdensity", version: "0.1.0", dependencies: [] }],
      "server_inventory" =>
      [{ name: "server_inventory", version: "0.0.4", dependencies: [] },
       { name: "server_inventory", version: "0.0.3", dependencies: [] },
       { name: "server_inventory", version: "0.0.2", dependencies: [] },
       { name: "server_inventory", version: "0.0.1", dependencies: [] }],
      "services" => [{ name: "services", version: "0.2.0", dependencies: [] }],
      "service_factory" =>
      [{ name: "service_factory",
         version: "0.1.4",
         dependencies: [["unix_bin", ">= 0.2.7"],
          ["resource_masher", ">= 0.10.0"],
          ["run_action_now", ">= 0.1.0"]] },
       { name: "service_factory",
         version: "0.1.3",
         dependencies: [["unix_bin", ">= 0.2.7"],
          ["resource_masher", ">= 0.10.0"],
          ["run_action_now", ">= 0.1.0"]] },
       { name: "service_factory",
         version: "0.1.2",
         dependencies: [["unix_bin", ">= 0.2.7"],
          ["resource_masher", ">= 0.10.0"],
          ["run_action_now", ">= 0.1.0"]] },
       { name: "service_factory",
         version: "0.1.1",
         dependencies: [["unix_bin", ">= 0.0.0"], ["resource_masher", ">= 0.0.0"]] }],
      "seyren" =>
      [{ name: "seyren",
         version: "0.0.4",
         dependencies: [["graphite", ">= 0.0.0"],
          ["application", ">= 2.0.4"],
          ["maven", ">= 0.0.0"],
          ["tomcat", ">= 0.0.0"],
          ["mongodb", ">= 0.0.0"]] }],
      "sftp" =>
      [{ name: "sftp",
         version: "1.0.1",
         dependencies: [["chef-solo-search", "~> 0.5.1"],
          ["openssh", "~> 1.3.2"],
          ["users", "~> 1.6.0"]] },
       { name: "sftp",
         version: "1.0.0",
         dependencies: [["chef-solo-search", "~> 0.5.1"],
          ["openssh", "~> 1.3.2"],
          ["users", "~> 1.6.0"]] }],
      "shibboleth_idp" =>
      [{ name: "shibboleth_idp", version: "0.1.2", dependencies: [] },
       { name: "shibboleth_idp", version: "0.1.1", dependencies: [] },
       { name: "shibboleth_idp", version: "0.1.0", dependencies: [] }],
      "shibboleth_sp" =>
      [{ name: "shibboleth_sp", version: "0.1.1", dependencies: [] },
       { name: "shibboleth_sp", version: "0.1.0", dependencies: [] }],
      "shorewall" =>
      [{ name: "shorewall",
         version: "0.0.1",
         dependencies: [["yumrepo", ">= 0.0.0"]] }],
      "sickbeard" => [{ name: "sickbeard", version: "1.0.0", dependencies: [] }],
      "sidekiq" =>
      [{ name: "sidekiq", version: "0.6.0", dependencies: [["smf", ">= 1.5.0"]] },
       { name: "sidekiq", version: "0.4.0", dependencies: [["smf", ">= 1.5.0"]] },
       { name: "sidekiq", version: "0.1.0", dependencies: [["smf", ">= 0.6.8"]] },
       { name: "sidekiq",
         version: "0.0.3",
         dependencies: [["smf", ">= 0.0.0"]] }],
      "siege" =>
      [{ name: "siege", version: "0.1.1", dependencies: [["yum", ">= 0.0.0"]] },
       { name: "siege", version: "0.1.0", dependencies: [] }],
      "silverlight" => [{ name: "silverlight", version: "0.5.0", dependencies: [] }],
      "simplelog_handler" =>
      [{ name: "simplelog_handler", version: "1.0.0", dependencies: [] },
       { name: "simplelog_handler", version: "0.1.0", dependencies: [] }],
      "simple_iptables" =>
      [{ name: "simple_iptables", version: "0.6.0", dependencies: [] },
       { name: "simple_iptables", version: "0.3.0", dependencies: [] },
       { name: "simple_iptables", version: "0.2.4", dependencies: [] },
       { name: "simple_iptables", version: "0.2.3", dependencies: [] },
       { name: "simple_iptables", version: "0.2.2", dependencies: [] },
       { name: "simple_iptables", version: "0.2.1", dependencies: [] },
       { name: "simple_iptables", version: "0.2.0", dependencies: [] },
       { name: "simple_iptables", version: "0.1.2", dependencies: [] },
       { name: "simple_iptables", version: "0.1.1", dependencies: [] },
       { name: "simple_iptables", version: "0.1.0", dependencies: [] }],
      "sinopia" =>
      [{ name: "sinopia",
         version: "0.2.2",
         dependencies: [["apt", "~> 2.3.0"],
          ["nodejs", "~> 1.3.0"],
          ["node", "~> 1.0.1"],
          ["user", "~> 0.3.0"],
          ["logrotate", "~> 1.4.0"]] }],
      "sipp" =>
      [{ name: "sipp", version: "1.0.1", dependencies: [] },
       { name: "sipp", version: "1.0.0", dependencies: [] }],
      "Site24x7" => [{ name: "Site24x7", version: "0.1.0", dependencies: [] }],
      "skyline" =>
      [{ name: "skyline",
         version: "0.3.0",
         dependencies: [["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["scipy", ">= 0.0.0"]] },
       { name: "skyline",
         version: "0.2.0",
         dependencies: [["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["scipy", ">= 0.0.0"]] },
       { name: "skyline",
         version: "0.1.4",
         dependencies: [["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["scipy", ">= 0.0.0"]] },
       { name: "skyline",
         version: "0.1.3",
         dependencies: [["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["scipy", ">= 0.0.0"]] },
       { name: "skyline",
         version: "0.1.2",
         dependencies: [["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["scipy", ">= 0.0.0"]] },
       { name: "skyline",
         version: "0.1.1",
         dependencies: [["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["scipy", ">= 0.0.0"]] },
       { name: "skyline",
         version: "0.1.0",
         dependencies: [["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["redis", ">= 0.0.0"],
          ["scipy", ">= 0.0.0"]] }],
      "skype" => [{ name: "skype", version: "0.0.1", dependencies: [] }],
      "skype5" =>
      [{ name: "skype5", version: "1.0.4", dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "skype5", version: "1.0.3", dependencies: [] },
       { name: "skype5", version: "1.0.2", dependencies: [] },
       { name: "skype5", version: "1.0.1", dependencies: [] },
       { name: "skype5", version: "1.0.0", dependencies: [] }],
      "sk_ruby" =>
      [{ name: "sk_ruby",
         version: "1.0.5",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["sk_s3_file", ">= 0.0.0"]] },
       { name: "sk_ruby",
         version: "1.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] }],
      "sk_s3_file" =>
      [{ name: "sk_s3_file", version: "2.0.6", dependencies: [] },
       { name: "sk_s3_file", version: "2.0.5", dependencies: [] }],
      "slack" => [{ name: "slack", version: "0.1.0", dependencies: [] }],
      "smackage" => [{ name: "smackage", version: "0.0.1", dependencies: [] }],
      "smartmachine_functions" =>
      [{ name: "smartmachine_functions", version: "0.5.2", dependencies: [] },
       { name: "smartmachine_functions", version: "0.5.1", dependencies: [] },
       { name: "smartmachine_functions", version: "0.5.0", dependencies: [] },
       { name: "smartmachine_functions", version: "0.4.1", dependencies: [] },
       { name: "smartmachine_functions", version: "0.4.0", dependencies: [] },
       { name: "smartmachine_functions", version: "0.3.0", dependencies: [] },
       { name: "smartmachine_functions", version: "0.2.0", dependencies: [] },
       { name: "smartmachine_functions", version: "0.1.0", dependencies: [] }],
      "smartmontools" =>
      [{ name: "smartmontools", version: "1.0.0", dependencies: [] }],
      "smartos" => [{ name: "smartos", version: "0.0.1", dependencies: [] }],
      "smbfs" => [{ name: "smbfs", version: "0.2.0", dependencies: [] }],
      "smf" =>
      [{ name: "smf", version: "2.0.3", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "2.0.1", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "2.0.0", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "1.5.0", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "1.4.0", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "1.2.1", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "1.2.0", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "1.1.1", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "1.0.1", dependencies: [["rbac", ">= 1.0.1"]] },
       { name: "smf", version: "1.0.0", dependencies: [["rbac", ">= 1.0.0"]] },
       { name: "smf", version: "0.6.9", dependencies: [["rbac", ">= 0.0.2"]] },
       { name: "smf", version: "0.6.8", dependencies: [["rbac", ">= 0.0.2"]] },
       { name: "smf", version: "0.6.7", dependencies: [["rbac", ">= 0.0.2"]] },
       { name: "smf", version: "0.6.5", dependencies: [["rbac", ">= 0.0.2"]] },
       { name: "smf", version: "0.6.4", dependencies: [["rbac", ">= 0.0.2"]] },
       { name: "smf", version: "0.6.3", dependencies: [["rbac", ">= 0.0.0"]] }],
      "smokeping" =>
      [{ name: "smokeping",
         version: "0.4.0",
         dependencies: [["apache2", ">= 0.0.0"], ["perl", ">= 0.0.0"]] }],
      "snappy" =>
      [{ name: "snappy",
         version: "3.0.1",
         dependencies: [["install_from", ">= 0.0.0"]] }],
      "snapraid" =>
      [{ name: "snapraid",
         version: "0.2.0",
         dependencies: [["ark", ">= 0.0.0"]] },
       { name: "snapraid",
         version: "0.1.0",
         dependencies: [["ark", ">= 0.0.0"]] }],
      "snmp" =>
      [{ name: "snmp", version: "2.0.0", dependencies: [] },
       { name: "snmp", version: "1.1.0", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "1.0.0", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.4.0", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.3.1", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.2.1", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.2.0", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.1.2", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.1.0", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.0.9", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.0.8", dependencies: [["perl", ">= 0.0.0"]] },
       { name: "snmp", version: "0.0.4", dependencies: [] },
       { name: "snmp", version: "0.0.2", dependencies: [] }],
      "snort" =>
      [{ name: "snort", version: "0.10.0", dependencies: [] },
       { name: "snort", version: "0.9.0", dependencies: [] }],
      "soa_tools" =>
      [{ name: "soa_tools",
         version: "0.2.2",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "soa_tools",
         version: "0.2.1",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "soa_tools",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "soa_tools",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] },
       { name: "soa_tools",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "sol" =>
      [{ name: "sol",
         version: "0.2.0",
         dependencies: [["reboot-handler", ">= 0.0.0"]] }],
      "solo_data_bags" =>
      [{ name: "solo_data_bags", version: "0.0.4", dependencies: [] },
       { name: "solo_data_bags", version: "0.0.1", dependencies: [] }],
      "solr" =>
      [{ name: "solr", version: "0.1.2", dependencies: [["java", ">= 0.0.0"]] },
       { name: "solr", version: "0.1.0", dependencies: [["java", ">= 0.0.0"]] },
       { name: "solr", version: "0.0.1", dependencies: [["java", ">= 0.0.0"]] }],
      "solr_app" =>
      [{ name: "solr_app",
         version: "0.0.3",
         dependencies: [["application", ">= 0.0.0"],
          ["application_java", ">= 1.1.0"],
          ["tomcat", ">= 0.0.0"],
          ["ark", ">= 0.0.0"]] },
       { name: "solr_app",
         version: "0.0.2",
         dependencies: [["application", ">= 0.0.0"],
          ["application_java", ">= 0.0.0"],
          ["ark", ">= 0.0.0"]] }],
      "sonar" =>
      [{ name: "sonar", version: "0.0.1", dependencies: [["java", ">= 0.0.0"]] }],
      "sortable_mash" =>
      [{ name: "sortable_mash", version: "0.0.2", dependencies: [] },
       { name: "sortable_mash", version: "0.0.1", dependencies: [] }],
      "sox_mp3" =>
      [{ name: "sox_mp3",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["apt", ">= 0.0.0"]] }],
      "spamassassin" =>
      [{ name: "spamassassin", version: "0.1.1", dependencies: [] },
       { name: "spamassassin", version: "0.1.0", dependencies: [] }],
      "spark" =>
      [{ name: "spark", version: "1.0.1", dependencies: [["java", ">= 0.0.0"]] }],
      "sparkleshare" =>
      [{ name: "sparkleshare",
         version: "0.6.0",
         dependencies: [["npm", ">= 0.0.0"], ["openssh", ">= 0.0.0"]] },
       { name: "sparkleshare",
         version: "0.5.0",
         dependencies: [["npm", ">= 0.0.0"], ["openssh", ">= 0.0.0"]] }],
      "sphinx" =>
      [{ name: "sphinx", version: "1.0.3", dependencies: [] },
       { name: "sphinx",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["percona", ">= 0.0.0"],
          ["postgresql", "= 1.0.0"],
          ["yum", ">= 2.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "1.0.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["percona", ">= 0.0.0"],
          ["postgresql", "= 1.0.0"],
          ["yum", ">= 2.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["percona", ">= 0.0.0"],
          ["postgresql", "= 1.0.0"],
          ["yum", ">= 2.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.6.6",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["percona", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.6.5",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["percona", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.6.4",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.6.3",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.6.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.6.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.6.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.4.0",
         dependencies: [["mysql", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.3.0",
         dependencies: [["mysql", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "sphinx",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "spiceweasel" => [{ name: "spiceweasel", version: "0.1.0", dependencies: [] }],
      "splunk" =>
      [{ name: "splunk", version: "0.0.9", dependencies: [] },
       { name: "splunk", version: "0.0.4", dependencies: [] }],
      "splunkforwarder" =>
      [{ name: "splunkforwarder", version: "1.0.0", dependencies: [] }],
      "splunkstorm" =>
      [{ name: "splunkstorm", version: "0.0.3", dependencies: [] },
       { name: "splunkstorm", version: "0.0.2", dependencies: [] },
       { name: "splunkstorm", version: "0.0.1", dependencies: [] }],
      "splunk_handler" =>
      [{ name: "splunk_handler",
         version: "1.2.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "splunk_handler",
         version: "1.1.0",
         dependencies: [["chef_handler", ">= 0.0.0"]] },
       { name: "splunk_handler",
         version: "1.0.1",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "sptoolkit" =>
      [{ name: "sptoolkit",
         version: "0.0.16",
         dependencies: [["apache2", ">= 0.0.0"], ["mysql", ">= 0.0.0"]] },
       { name: "sptoolkit",
         version: "0.0.14",
         dependencies: [["apache2", ">= 0.0.0"], ["mysql", ">= 0.0.0"]] },
       { name: "sptoolkit",
         version: "0.0.12",
         dependencies: [["apache2", ">= 0.0.0"], ["mysql", ">= 0.0.0"]] },
       { name: "sptoolkit",
         version: "0.0.10",
         dependencies: [["apache2", ">= 0.0.0"], ["mysql", ">= 0.0.0"]] }],
      "sqlce" =>
      [{ name: "sqlce",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "sqlce",
         version: "0.1.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "sqlite" =>
      [{ name: "sqlite", version: "1.0.0", dependencies: [] },
       { name: "sqlite", version: "0.7.0", dependencies: [] }],
      "sql_server" =>
      [{ name: "sql_server",
         version: "2.2.0",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "2.0.0",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.4.4",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.4.1",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.3.0",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.2.2",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.2.1",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.2.0",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.1.0",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.0.4",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.6"]] },
       { name: "sql_server",
         version: "1.0.2",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.2.4"]] },
       { name: "sql_server",
         version: "1.0.0",
         dependencies: [["openssl", ">= 0.0.0"], ["windows", ">= 1.0.6"]] }],
      "squid" =>
      [{ name: "squid", version: "0.4.2", dependencies: [] },
       { name: "squid", version: "0.4.0", dependencies: [] },
       { name: "squid", version: "0.3.0", dependencies: [] },
       { name: "squid", version: "0.2.10", dependencies: [] },
       { name: "squid", version: "0.2.8", dependencies: [] },
       { name: "squid", version: "0.2.6", dependencies: [] },
       { name: "squid", version: "0.2.4", dependencies: [] },
       { name: "squid", version: "0.2.2", dependencies: [] },
       { name: "squid", version: "0.2.0", dependencies: [] },
       { name: "squid", version: "0.1.0", dependencies: [] }],
      "ssh-keys" => [{ name: "ssh-keys", version: "1.0.0", dependencies: [] }],
      "ssh-util" =>
      [{ name: "ssh-util", version: "0.6.3", dependencies: [] },
       { name: "ssh-util", version: "0.6.0", dependencies: [] }],
      "ssh-wrapper" => [{ name: "ssh-wrapper", version: "0.0.3", dependencies: [] }],
      "sshd" => [{ name: "sshd", version: "1.0.0", dependencies: [] }],
      "ssh_known_hosts" =>
      [{ name: "ssh_known_hosts",
         version: "1.2.0",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "ssh_known_hosts",
         version: "1.1.0",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "ssh_known_hosts",
         version: "1.0.2",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "ssh_known_hosts",
         version: "1.0.0",
         dependencies: [["partial_search", ">= 0.0.0"]] },
       { name: "ssh_known_hosts", version: "0.7.4", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.7.2", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.7.0", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.6.0", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.5.0", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.4.0", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.3.0", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.2.3", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.2.2", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.2.0", dependencies: [] },
       { name: "ssh_known_hosts", version: "0.1.0", dependencies: [] }],
      "ssh_user" =>
      [{ name: "ssh_user",
         version: "0.1.1",
         dependencies: [["user", ">= 0.0.0"], ["ssh-util", ">= 0.0.0"]] },
       { name: "ssh_user",
         version: "0.1.0",
         dependencies: [["user", ">= 0.0.0"], ["ssh-util", ">= 0.0.0"]] }],
      "ssl" =>
      [{ name: "ssl", version: "1.1.0", dependencies: [] },
       { name: "ssl", version: "1.0.8", dependencies: [] },
       { name: "ssl", version: "1.0.7", dependencies: [] },
       { name: "ssl", version: "1.0.6", dependencies: [] },
       { name: "ssl", version: "1.0.5", dependencies: [] },
       { name: "ssl", version: "1.0.4", dependencies: [] },
       { name: "ssl", version: "1.0.3", dependencies: [] },
       { name: "ssl", version: "1.0.2", dependencies: [] }],
      "ssl-key-vault" =>
      [{ name: "ssl-key-vault", version: "0.2.0", dependencies: [] },
       { name: "ssl-key-vault", version: "0.1.2", dependencies: [] },
       { name: "ssl-key-vault", version: "0.1.1", dependencies: [] },
       { name: "ssl-key-vault", version: "0.1.0", dependencies: [] }],
      "ssl-vault" =>
      [{ name: "ssl-vault",
         version: "1.1.1",
         dependencies: [["chef-vault", "~> 1.0.4"]] },
       { name: "ssl-vault",
         version: "1.1.0",
         dependencies: [["chef-vault", "~> 1.0.4"]] },
       { name: "ssl-vault",
         version: "1.0.0",
         dependencies: [["chef-vault", "~> 1.0.4"]] }],
      "ssmtp" =>
      [{ name: "ssmtp", version: "0.3.1", dependencies: [["yum", ">= 0.0.0"]] },
       { name: "ssmtp", version: "0.3.0", dependencies: [["yum", ">= 0.0.0"]] },
       { name: "ssmtp", version: "0.1.0", dependencies: [] }],
      "ssmtp2" =>
      [{ name: "ssmtp2", version: "0.1.0", dependencies: [["yum", "< 3.0.0"]] }],
      "sssd_ldap" =>
      [{ name: "sssd_ldap", version: "0.1.4", dependencies: [] },
       { name: "sssd_ldap", version: "0.1.0", dependencies: [] }],
      "stackdriver" => [{ name: "stackdriver", version: "0.1.0", dependencies: [] }],
      "stage" =>
      [{ name: "stage", version: "0.0.4", dependencies: [] },
       { name: "stage", version: "0.0.3", dependencies: [] },
       { name: "stage", version: "0.0.2", dependencies: [] },
       { name: "stage", version: "0.0.1", dependencies: [] }],
      "stash" =>
      [{ name: "stash",
         version: "3.7.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.6.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.5.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.4.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.3.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.2.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.1.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.1.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.0.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "3.0.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.21.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.20.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.19.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["cron", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.18.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.17.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.16.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.15.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.14.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.13.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.12.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.10.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.10.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.9.0",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] },
       { name: "stash",
         version: "2.6.1",
         dependencies: [["apache2", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["mysql_connector", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["postgresql", ">= 0.0.0"]] }],
      "statsite" =>
      [{ name: "statsite",
         version: "0.0.2",
         dependencies: [["git", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "statsite",
         version: "0.0.1",
         dependencies: [["python", ">= 0.0.0"], ["git", ">= 0.0.0"], ["runit", ">= 0.0.0"]] }],
      "stompserver" =>
      [{ name: "stompserver", version: "1.0.0", dependencies: [] },
       { name: "stompserver",
         version: "0.7.0",
         dependencies: [["runit", ">= 0.0.0"], ["packages", ">= 0.0.0"]] }],
      "stoplight" =>
      [{ name: "stoplight",
         version: "1.0.0",
         dependencies: [["git", ">= 0.0.0"], ["passenger_apache2", ">= 0.0.0"]] },
       { name: "stoplight",
         version: "0.1.4",
         dependencies: [["git", ">= 0.0.0"], ["passenger_apache2", ">= 0.0.0"]] },
       { name: "stoplight",
         version: "0.1.3",
         dependencies: [["git", ">= 0.0.0"], ["passenger_apache2", ">= 0.0.0"]] },
       { name: "stoplight",
         version: "0.1.2",
         dependencies: [["git", ">= 0.0.0"]] },
       { name: "stoplight",
         version: "0.1.1",
         dependencies: [["git", ">= 0.0.0"]] }],
      "storm" =>
      [{ name: "storm",
         version: "1.2.5",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "storm",
         version: "1.0.30",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "storm",
         version: "1.0.28",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "storm",
         version: "1.0.23",
         dependencies: [["java", ">= 0.0.0"], ["runit", ">= 0.0.0"]] }],
      "stormforwarder" =>
      [{ name: "stormforwarder",
         version: "1.0.0",
         dependencies: [["splunkforwarder", ">= 0.0.0"]] }],
      "strongswan" =>
      [{ name: "strongswan",
         version: "0.2.6",
         dependencies: [["route53", ">= 0.0.0"]] }],
      "stud" =>
      [{ name: "stud",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "stud",
         version: "0.0.1",
         dependencies: [["install_from", ">= 0.0.0"]] }],
      "stunnel" =>
      [{ name: "stunnel", version: "2.0.4", dependencies: [] },
       { name: "stunnel", version: "2.0.2", dependencies: [] },
       { name: "stunnel", version: "2.0.0", dependencies: [] },
       { name: "stunnel", version: "1.0.0", dependencies: [] }],
      "subrosa" =>
      [{ name: "subrosa",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"],
          ["leiningen", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] }],
      "subversion" =>
      [{ name: "subversion",
         version: "1.1.2",
         dependencies: [["apache2", "~> 1.7"], ["windows", "~> 1.10"]] },
       { name: "subversion",
         version: "1.1.0",
         dependencies: [["apache2", "~> 1.7"], ["windows", "~> 1.10"]] },
       { name: "subversion",
         version: "1.0.4",
         dependencies: [["apache2", ">= 0.0.0"], ["windows", ">= 0.0.0"]] },
       { name: "subversion",
         version: "1.0.2",
         dependencies: [["apache2", ">= 0.0.0"], ["windows", ">= 0.0.0"]] },
       { name: "subversion",
         version: "1.0.0",
         dependencies: [["apache2", ">= 0.0.0"], ["windows", ">= 0.0.0"]] },
       { name: "subversion",
         version: "0.8.3",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "subversion",
         version: "0.8.2",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "subversion",
         version: "0.8.1",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "subversion", version: "0.7.0", dependencies: [] }],
      "sugarcrm" =>
      [{ name: "sugarcrm",
         version: "0.1.2",
         dependencies: [["mysql", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "sugarcrm",
         version: "0.1.1",
         dependencies: [["mysql", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "sugar_crm" =>
      [{ name: "sugar_crm",
         version: "1.0.0",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] }],
      "sumologic-collector" =>
      [{ name: "sumologic-collector", version: "1.2.1", dependencies: [] },
       { name: "sumologic-collector", version: "1.2.2", dependencies: [] },
       { name: "sumologic-collector", version: "1.2.0", dependencies: [] },
       { name: "sumologic-collector", version: "1.0.2", dependencies: [] },
       { name: "sumologic-collector", version: "1.0.1", dependencies: [] }],
      "supervisor" =>
      [{ name: "supervisor",
         version: "0.4.10",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "supervisor",
         version: "0.4.8",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "supervisor",
         version: "0.4.6",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "supervisor",
         version: "0.4.4",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "supervisor",
         version: "0.4.2",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "supervisor",
         version: "0.4.0",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "supervisor",
         version: "0.3.0",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "supervisor",
         version: "0.2.0",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "supervisor",
         version: "0.1.0",
         dependencies: [["python", ">= 0.0.0"]] }],
      "supervisord" =>
      [{ name: "supervisord", version: "1.0.1", dependencies: [] },
       { name: "supervisord", version: "1.0.0", dependencies: [] },
       { name: "supervisord", version: "0.1.0", dependencies: [] },
       { name: "supervisord", version: "0.0.1", dependencies: [] }],
      "swap" =>
      [{ name: "swap", version: "0.3.6", dependencies: [] },
       { name: "swap", version: "0.3.5", dependencies: [] },
       { name: "swap", version: "0.3.4", dependencies: [] },
       { name: "swap", version: "0.3.3", dependencies: [] },
       { name: "swap", version: "0.3.2", dependencies: [] },
       { name: "swap", version: "0.3.1", dependencies: [] },
       { name: "swap", version: "0.3.0", dependencies: [] },
       { name: "swap", version: "0.2.0", dependencies: [] },
       { name: "swap", version: "0.1.2", dependencies: [] },
       { name: "swap", version: "0.1.1", dependencies: [] },
       { name: "swap", version: "0.1.0", dependencies: [] }],
      "swftools" =>
      [{ name: "swftools",
         version: "0.2.4",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "swftools",
         version: "0.2.2",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "swftools", version: "0.2.0", dependencies: [] }],
      "swftp" => [{ name: "swftp", version: "1.0.0", dependencies: [] }],
      "swift" => [{ name: "swift", version: "0.0.1", dependencies: [] }],
      "symantec" =>
      [{ name: "symantec",
         version: "0.0.1",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "symfony" =>
      [{ name: "symfony",
         version: "2.0.6",
         dependencies: [["nginx", "~> 2.4.4"],
          ["php-fpm", "~> 0.6.3"],
          ["php", "~> 1.4.4"],
          ["mysql", "~> 4.1.2"],
          ["database", "~> 2.0.0"],
          ["rvm", "~> 0.8.6"],
          ["git", "~> 3.1.0"],
          ["composer", "~> 0.2.0"]] },
       { name: "symfony",
         version: "2.0.2",
         dependencies: [["nginx", "~> 2.0.4"],
          ["php-fpm", "~> 0.5.0"],
          ["php", "~> 1.2.6"],
          ["mysql", "~> 4.0.4"],
          ["database", "~> 1.5.2"],
          ["rvm", "~> 0.9.1"],
          ["git", "~> 2.7.0"]] },
       { name: "symfony",
         version: "0.2.0",
         dependencies: [["nginx", "~> 2.0.4"],
          ["php-fpm", "~> 0.5.0"],
          ["php", "~> 1.2.6"],
          ["mysql", "~> 4.0.4"],
          ["database", "~> 1.5.2"],
          ["rvm", "~> 0.9.1"],
          ["git", "~> 2.7.0"]] },
       { name: "symfony",
         version: "0.1.3",
         dependencies: [["nginx", "~> 2.0.4"],
          ["php-fpm", "~> 0.5.0"],
          ["php", "~> 1.2.6"],
          ["mysql", "~> 4.0.4"],
          ["database", "~> 1.5.2"],
          ["rvm", "~> 0.9.1"],
          ["git", "~> 2.7.0"]] },
       { name: "symfony", version: "0.1.0", dependencies: [] }],
      "symfony2" =>
      [{ name: "symfony2",
         version: "0.0.1",
         dependencies: [["apache", ">= 0.0.0"]] }],
      "sysctl2" => [{ name: "sysctl2", version: "0.1.0", dependencies: [] }],
      "sysfs" => [{ name: "sysfs", version: "0.0.2", dependencies: [] }],
      "SysinternalsBginfo" =>
      [{ name: "SysinternalsBginfo",
         version: "1.0.1",
         dependencies: [["windows", ">= 1.2.8"]] }],
      "syslogger" => [{ name: "syslogger", version: "0.1.0", dependencies: [] }],
      "syslog_handler" =>
      [{ name: "syslog_handler",
         version: "0.1.2",
         dependencies: [["chef_handler", ">= 0.0.0"]] }],
      "sysstat" => [{ name: "sysstat", version: "1.2.0", dependencies: [] }],
      "system" =>
      [{ name: "system",
         version: "0.2.3",
         dependencies: [["apt", ">= 0.0.0"], ["cron", ">= 0.0.0"], ["hostsfile", ">= 0.0.0"]] },
       { name: "system",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["cron", ">= 0.0.0"]] },
       { name: "system",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"], ["cron", ">= 0.0.0"]] }],
      "systemd" => [{ name: "systemd", version: "0.1.0", dependencies: [] }],
      "tar" =>
      [{ name: "tar", version: "0.3.0", dependencies: [] },
       { name: "tar", version: "0.2.0", dependencies: [] },
       { name: "tar", version: "0.1.0", dependencies: [] },
       { name: "tar", version: "0.0.4", dependencies: [] },
       { name: "tar", version: "0.0.3", dependencies: [] },
       { name: "tar", version: "0.0.1", dependencies: [] }],
      "tarsnap" =>
      [{ name: "tarsnap",
         version: "0.1.2",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "tarsnap",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "tarsnap",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "tarsnap",
         version: "0.0.10",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] }],
      "taskwarrior" =>
      [{ name: "taskwarrior",
         version: "1.1.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["cmake", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "taskwarrior",
         version: "1.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["cmake", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] },
       { name: "taskwarrior",
         version: "1.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["cmake", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["perl", ">= 0.0.0"],
          ["python", ">= 0.0.0"],
          ["runit", ">= 0.0.0"]] }],
      "tasseo" =>
      [{ name: "tasseo",
         version: "0.0.1",
         dependencies: [["runit", ">= 0.0.0"]] }],
      "teamcity" => [{ name: "teamcity", version: "0.1.0", dependencies: [] }],
      "teamcity_server" =>
      [{ name: "teamcity_server",
         version: "0.0.0",
         dependencies: [["bluepill", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "teamforge" =>
      [{ name: "teamforge",
         version: "0.1.1",
         dependencies: [["dmg", ">= 0.0.0"], ["iptables", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "teamforge-tools" =>
      [{ name: "teamforge-tools", version: "0.1.0", dependencies: [] }],
      "teampass" =>
      [{ name: "teampass",
         version: "0.1.1",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["git", ">= 0.0.0"],
          ["chef-vault", ">= 0.0.0"],
          ["opscode-backup", ">= 0.0.0"]] }],
      "teamspeak" =>
      [{ name: "teamspeak",
         version: "0.8.1",
         dependencies: [["php", ">= 0.0.0"]] },
       { name: "teamspeak",
         version: "0.8.0",
         dependencies: [["php", ">= 0.0.0"]] }],
      "teamspeak3" =>
      [{ name: "teamspeak3",
         version: "1.1.0",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "teamspeak3",
         version: "1.0.4",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "teamspeak3",
         version: "1.0.3",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "teamspeak3",
         version: "1.0.0",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "teamspeak3",
         version: "0.2.1",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "teamspeak3",
         version: "0.2.0",
         dependencies: [["runit", ">= 0.0.0"]] },
       { name: "teamspeak3",
         version: "0.1.0",
         dependencies: [["runit", ">= 0.0.0"]] }],
      "terracotta" =>
      [{ name: "terracotta", version: "0.1.1", dependencies: [] },
       { name: "terracotta", version: "0.1.0", dependencies: [] }],
      "test-kitchen" =>
      [{ name: "test-kitchen",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["vagrant", ">= 0.0.0"],
          ["virtualbox", ">= 0.0.0"]] }],
      "testswarm" =>
      [{ name: "testswarm",
         version: "0.0.1",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] }],
      "texlive" =>
      [{ name: "texlive", version: "0.2.0", dependencies: [] },
       { name: "texlive", version: "0.1.0", dependencies: [] }],
      "tfchefint" =>
      [{ name: "tfchefint",
         version: "0.1.0",
         dependencies: [["sudo", ">= 0.0.0"], ["users", ">= 0.0.0"]] }],
      "tftp" =>
      [{ name: "tftp", version: "1.2.0", dependencies: [] },
       { name: "tftp", version: "1.1.0", dependencies: [] },
       { name: "tftp", version: "1.0.0", dependencies: [] },
       { name: "tftp", version: "0.2.0", dependencies: [] },
       { name: "tftp", version: "0.1.0", dependencies: [] }],
      "the_silver_searcher" =>
      [{ name: "the_silver_searcher",
         version: "1.3.9",
         dependencies: [["build-essential", ">= 0.0.0"], ["chef-sugar", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.3.8",
         dependencies: [["build-essential", ">= 0.0.0"], ["chef-sugar", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.3.7",
         dependencies: [["build-essential", ">= 0.0.0"], ["chef-sugar", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.3.6",
         dependencies: [["build-essential", ">= 0.0.0"], ["chef-sugar", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.3.5",
         dependencies: [["build-essential", ">= 0.0.0"], ["chef-sugar", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.3.3",
         dependencies: [["build-essential", ">= 0.0.0"], ["chef-sugar", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.3.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.3.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.3.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.2.4",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.2.3",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.2.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.2.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.2.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.1.1",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "the_silver_searcher",
         version: "1.0.4",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "thread" => [{ name: "thread", version: "0.1.0", dependencies: [] }],
      "thrift" =>
      [{ name: "thrift",
         version: "1.2.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["boost", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "thrift",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["boost", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "thrift",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["boost", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "thrift",
         version: "0.99.0",
         dependencies: [["build-essential", ">= 0.0.0"],
          ["boost", ">= 0.0.0"],
          ["python", ">= 0.0.0"]] },
       { name: "thrift",
         version: "0.1.0",
         dependencies: [["subversion", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["boost", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] }],
      "thruk" =>
      [{ name: "thruk",
         version: "0.2.2",
         dependencies: [["yum-epel", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "thruk",
         version: "0.2.1",
         dependencies: [["yum", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "thruk",
         version: "0.2.0",
         dependencies: [["yum", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "thumbor" =>
      [{ name: "thumbor",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] },
       { name: "thumbor",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["python", ">= 0.0.0"], ["nginx", ">= 0.0.0"]] }],
      "tig" =>
      [{ name: "tig", version: "0.1.0", dependencies: [["git", ">= 0.0.0"]] }],
      "timezone" => [{ name: "timezone", version: "0.0.1", dependencies: [] }],
      "timezone-ii" => [{ name: "timezone-ii", version: "0.2.0", dependencies: [] }],
      "tinc" =>
      [{ name: "tinc", version: "0.0.4", dependencies: [["apt", ">= 0.0.0"]] }],
      "tmpreaper" =>
      [{ name: "tmpreaper", version: "0.1.2", dependencies: [] },
       { name: "tmpreaper", version: "0.1.0", dependencies: [] }],
      "tomcat-openam" =>
      [{ name: "tomcat-openam",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] },
       { name: "tomcat-openam",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"]] }],
      "tomcat-solr" =>
      [{ name: "tomcat-solr",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "tomcat6" =>
      [{ name: "tomcat6", version: "0.5.4", dependencies: [] },
       { name: "tomcat6", version: "0.5.3", dependencies: [] },
       { name: "tomcat6", version: "0.5.2", dependencies: [] },
       { name: "tomcat6", version: "0.5.1", dependencies: [] },
       { name: "tomcat6", version: "0.5.0", dependencies: [] },
       { name: "tomcat6", version: "0.4.1", dependencies: [] },
       { name: "tomcat6", version: "0.4.0", dependencies: [] },
       { name: "tomcat6", version: "0.3.0", dependencies: [] },
       { name: "tomcat6", version: "0.1.0", dependencies: [] }],
      "tomcat6apr" =>
      [{ name: "tomcat6apr",
         version: "0.0.1",
         dependencies: [["debian", ">= 0.0.0"], ["java_sun", ">= 0.0.0"]] }],
      "tomcat_latest" =>
      [{ name: "tomcat_latest",
         version: "0.1.6",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat_latest",
         version: "0.1.5",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat_latest",
         version: "0.1.4",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat_latest",
         version: "0.1.3",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat_latest",
         version: "0.1.2",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat_latest",
         version: "0.1.1",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "tomcat_latest",
         version: "0.1.0",
         dependencies: [["java", ">= 0.0.0"]] }],
      "tomoyo" =>
      [{ name: "tomoyo",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "top" => [{ name: "top", version: "0.0.1", dependencies: [] }],
      "tor" =>
      [{ name: "tor", version: "0.0.2", dependencies: [] },
       { name: "tor", version: "0.0.1", dependencies: [] }],
      "trac" =>
      [{ name: "trac",
         version: "1.0.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "trac",
         version: "0.2.2",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "trac",
         version: "0.2.0",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "trac",
         version: "0.1.1",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "trac",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"]] }],
      "trac4r" =>
      [{ name: "trac4r", version: "1.0.5", dependencies: [] },
       { name: "trac4r", version: "1.0.3", dependencies: [] }],
      "traceroute" => [{ name: "traceroute", version: "1.0.0", dependencies: [] }],
      "transmission" =>
      [{ name: "transmission",
         version: "2.0.2",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "transmission",
         version: "2.0.0",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "transmission",
         version: "1.0.4",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "transmission",
         version: "1.0.2",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "transmission",
         version: "1.0.0",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "transmission",
         version: "0.99.0",
         dependencies: [["openssl", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] }],
      "tsdb-server" => [{ name: "tsdb-server", version: "0.1.0", dependencies: [] }],
      "tunnel" =>
      [{ name: "tunnel", version: "0.0.3", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "tunnel", version: "0.0.2", dependencies: [["apt", ">= 0.0.0"]] }],
      "tunnelblick" =>
      [{ name: "tunnelblick",
         version: "1.0.6",
         dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "tunnelblick",
         version: "1.0.4",
         dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "tunnelblick",
         version: "1.0.3",
         dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "tunnelblick",
         version: "1.0.2",
         dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "tunnelblick", version: "1.0.1", dependencies: [] },
       { name: "tunnelblick", version: "1.0.0", dependencies: [] }],
      "twitter" =>
      [{ name: "twitter", version: "1.0.8", dependencies: [] },
       { name: "twitter", version: "1.0.3", dependencies: [] },
       { name: "twitter", version: "1.0.2", dependencies: [] },
       { name: "twitter", version: "1.0.1", dependencies: [] }],
      "typesafe-stack" =>
      [{ name: "typesafe-stack",
         version: "0.1.0",
         dependencies: [["apt", ">= 1.4.0"], ["java", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "ubuntu_nvidia_gpu" =>
      [{ name: "ubuntu_nvidia_gpu", version: "0.1.0", dependencies: [] }],
      "uck" => [{ name: "uck", version: "0.1.0", dependencies: [] }],
      "ucs" => [{ name: "ucs", version: "0.0.1", dependencies: [] }],
      "ucs-pxe" => [{ name: "ucs-pxe", version: "0.0.1", dependencies: [] }],
      "ucs-solo" => [{ name: "ucs-solo", version: "0.0.1", dependencies: [] }],
      "ucspi-tcp" =>
      [{ name: "ucspi-tcp",
         version: "1.1.0",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ucspi-tcp",
         version: "1.0.2",
         dependencies: [["build-essential", ">= 0.0.0"]] },
       { name: "ucspi-tcp",
         version: "1.0.0",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "udev" =>
      [{ name: "udev", version: "0.2.0", dependencies: [] },
       { name: "udev", version: "0.1.0", dependencies: [] }],
      "ufw" =>
      [{ name: "ufw",
         version: "0.7.4",
         dependencies: [["firewall", ">= 0.9.0"]] },
       { name: "ufw",
         version: "0.7.2",
         dependencies: [["firewall", ">= 0.9.0"]] },
       { name: "ufw",
         version: "0.7.0",
         dependencies: [["firewall", ">= 0.8.0"]] },
       { name: "ufw",
         version: "0.6.4",
         dependencies: [["firewall", ">= 0.8.0"]] },
       { name: "ufw",
         version: "0.6.2",
         dependencies: [["firewall", ">= 0.8.0"]] },
       { name: "ufw",
         version: "0.6.1",
         dependencies: [["firewall", ">= 0.8.0"]] },
       { name: "ufw",
         version: "0.5.0",
         dependencies: [["firewall", ">= 0.6.0"]] },
       { name: "ufw",
         version: "0.4.2",
         dependencies: [["firewall", ">= 0.5.7"]] },
       { name: "ufw",
         version: "0.4.1",
         dependencies: [["firewall", ">= 0.5.6"]] },
       { name: "ufw",
         version: "0.4.0",
         dependencies: [["firewall", ">= 0.5.3"]] },
       { name: "ufw",
         version: "0.2.0",
         dependencies: [["firewall", ">= 0.0.0"]] },
       { name: "ufw",
         version: "0.1.0",
         dependencies: [["firewall", ">= 0.0.0"]] }],
      "ufw_install" => [{ name: "ufw_install", version: "0.1.0", dependencies: [] }],
      "ulimit" =>
      [{ name: "ulimit", version: "0.3.2", dependencies: [] },
       { name: "ulimit", version: "0.3.1", dependencies: [] },
       { name: "ulimit", version: "0.3.0", dependencies: [] },
       { name: "ulimit", version: "0.2.0", dependencies: [] },
       { name: "ulimit", version: "0.1.5", dependencies: [] },
       { name: "ulimit", version: "0.1.4", dependencies: [] },
       { name: "ulimit", version: "0.1.3", dependencies: [] },
       { name: "ulimit", version: "0.1.2", dependencies: [] },
       { name: "ulimit", version: "0.1.1", dependencies: [] },
       { name: "ulimit", version: "0.1.0", dependencies: [] }],
      "ulimit2" => [{ name: "ulimit2", version: "0.1.0", dependencies: [] }],
      "unattended_upgrades" =>
      [{ name: "unattended_upgrades", version: "0.0.2", dependencies: [] },
       { name: "unattended_upgrades", version: "0.0.1", dependencies: [] }],
      "unbound" => [{ name: "unbound", version: "0.1.0", dependencies: [] }],
      "unicorn" =>
      [{ name: "unicorn", version: "1.3.0", dependencies: [] },
       { name: "unicorn", version: "1.2.2", dependencies: [] },
       { name: "unicorn", version: "1.2.0", dependencies: [] },
       { name: "unicorn", version: "1.1.0", dependencies: [] },
       { name: "unicorn", version: "1.0.0", dependencies: [] },
       { name: "unicorn",
         version: "0.1.3",
         dependencies: [["ruby", ">= 0.0.0"], ["rubygems", ">= 0.0.0"]] },
       { name: "unicorn",
         version: "0.1.0",
         dependencies: [["ruby", ">= 0.0.0"], ["rubygems", ">= 0.0.0"]] }],
      "unicorn-ng" =>
      [{ name: "unicorn-ng", version: "0.2.0", dependencies: [] },
       { name: "unicorn-ng", version: "0.1.0", dependencies: [] }],
      "unimrcp" =>
      [{ name: "unimrcp",
         version: "0.2.0",
         dependencies: [["build-essential", "~> 1.4"]] },
       { name: "unimrcp", version: "0.1.0", dependencies: [["apt", "~> 2.2"]] }],
      "unix_bin" =>
      [{ name: "unix_bin", version: "0.2.7", dependencies: [] },
       { name: "unix_bin", version: "0.2.6", dependencies: [] },
       { name: "unix_bin", version: "0.2.4", dependencies: [] },
       { name: "unix_bin", version: "0.2.1", dependencies: [] }],
      "unix_shells" =>
      [{ name: "unix_shells", version: "0.2.4", dependencies: [] },
       { name: "unix_shells", version: "0.2.2", dependencies: [] }],
      "updatedb" => [{ name: "updatedb", version: "0.1.0", dependencies: [] }],
      "user" =>
      [{ name: "user", version: "0.3.0", dependencies: [] },
       { name: "user", version: "0.2.16", dependencies: [] },
       { name: "user", version: "0.2.14", dependencies: [] },
       { name: "user", version: "0.2.12", dependencies: [] },
       { name: "user", version: "0.2.10", dependencies: [] },
       { name: "user", version: "0.2.8", dependencies: [] },
       { name: "user", version: "0.2.6", dependencies: [] },
       { name: "user", version: "0.2.4", dependencies: [] },
       { name: "user", version: "0.2.2", dependencies: [] },
       { name: "user", version: "0.2.0", dependencies: [] }],
      "users_solo" => [{ name: "users_solo", version: "1.0.2", dependencies: [] }],
      "ut_base" =>
      [{ name: "ut_base",
         version: "1.2.0",
         dependencies: [["apt", "~> 2.0"],
          ["build-essential", "~> 1.4"],
          ["chef-sugar", "~> 1.1"],
          ["git", "~> 2.5"],
          ["homebrew", "~> 1.4"],
          ["mosh", "~> 0.3"],
          ["openssh", "~> 1.2"],
          ["postfix", "~> 3.0"],
          ["sudo", "~> 2.1"],
          ["ubuntu", "~> 1.1"],
          ["xcode", ">= 0.0.0"],
          ["yum-epel", "~> 0.2"]] },
       { name: "ut_base",
         version: "1.1.0",
         dependencies: [["apt", "~> 2.0.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.5.2"],
          ["homebrew", "~> 1.4"],
          ["mosh", "~> 0.3.0"],
          ["openssh", "~> 1.2.0"],
          ["postfix", "~> 2.1.6"],
          ["sudo", "~> 2.1.4"],
          ["xcode", ">= 0.0.0"],
          ["yum", "~> 2.3.0"]] },
       { name: "ut_base",
         version: "1.0.6",
         dependencies: [["apt", "~> 2.0.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.5.2"],
          ["homebrew", ">= 0.0.0"],
          ["mosh", "~> 0.3.0"],
          ["openssh", "~> 1.2.0"],
          ["postfix", "~> 2.1.6"],
          ["sudo", "~> 2.1.4"],
          ["yum", "~> 2.3.0"]] },
       { name: "ut_base",
         version: "1.0.4",
         dependencies: [["apt", "~> 2.0.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.5.2"],
          ["homebrew", ">= 0.0.0"],
          ["mosh", "~> 0.3.0"],
          ["openssh", "~> 1.2.0"],
          ["postfix", "~> 2.1.6"],
          ["sudo", "~> 2.1.4"],
          ["yum", "~> 2.3.0"]] },
       { name: "ut_base",
         version: "1.0.2",
         dependencies: [["apt", "~> 2.0.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.5.2"],
          ["homebrew", ">= 0.0.0"],
          ["mosh", "~> 0.3.0"],
          ["openssh", "~> 1.2.0"],
          ["postfix", "~> 2.1.6"],
          ["sudo", "~> 2.1.4"],
          ["yum", "~> 2.3.0"]] },
       { name: "ut_base",
         version: "1.0.0",
         dependencies: [["apt", "~> 2.0.0"],
          ["build-essential", "~> 1.4.0"],
          ["git", "~> 2.5.2"],
          ["homebrew", ">= 0.0.0"],
          ["mosh", "~> 0.3.0"],
          ["openssh", "~> 1.2.0"],
          ["postfix", "~> 2.1.6"],
          ["sudo", "~> 2.1.4"],
          ["yum", "~> 2.3.0"]] }],
      "ut_workstation" =>
      [{ name: "ut_workstation",
         version: "1.1.0",
         dependencies: [["apt", "~> 2.0"],
          ["ark", ">= 0.0.0"],
          ["bashrc", ">= 0.0.0"],
          ["chruby", ">= 0.0.0"],
          ["dmg", "~> 2.1"],
          ["homebrew", "~> 1.4"],
          ["homesick", "~> 0.4"],
          ["mac_os_x", ">= 0.0.0"],
          ["ubuntu", "~> 1.1"],
          ["user", "~> 0.3.0"],
          ["ut_base", "~> 1.2"],
          ["python", "~> 1.3"],
          ["ruby_install", "~> 0.1"],
          ["xquartz", ">= 0.0.0"],
          ["vagrant", ">= 0.0.0"],
          ["virtualbox", "~> 1.0"],
          ["zip_app", "~> 0.2"]] },
       { name: "ut_workstation",
         version: "1.0.4",
         dependencies: [["apt", "~> 2.0.0"],
          ["bashrc", ">= 0.0.0"],
          ["chgems", "~> 1.0.2"],
          ["chruby", ">= 0.0.0"],
          ["dmg", "~> 1.1.0"],
          ["homebrew", ">= 0.0.0"],
          ["homesick", "~> 0.4.0"],
          ["mac_os_x", ">= 0.0.0"],
          ["mosh", "~> 0.3.0"],
          ["ubuntu", "~> 1.1.2"],
          ["user", "~> 0.3.0"],
          ["ut_base", "~> 1.0.2"],
          ["python", "~> 1.3.4"],
          ["ruby_build", "~> 0.8.0"],
          ["xquartz", "~> 1.0.0"],
          ["vagrant", "~> 0.2.0"],
          ["virtualbox", ">= 0.0.0"],
          ["zip_app", "~> 0.2.2"]] },
       { name: "ut_workstation",
         version: "1.0.2",
         dependencies: [["apt", "~> 2.0.0"],
          ["bashrc", ">= 0.0.0"],
          ["chgems", "~> 1.0.2"],
          ["chruby", ">= 0.0.0"],
          ["dmg", "~> 1.1.0"],
          ["homebrew", ">= 0.0.0"],
          ["homesick", "~> 0.4.0"],
          ["mac_os_x", ">= 0.0.0"],
          ["mosh", "~> 0.3.0"],
          ["ubuntu", "~> 1.1.2"],
          ["user", "~> 0.3.0"],
          ["ut_base", "~> 1.0.2"],
          ["python", "~> 1.3.4"],
          ["ruby_build", "~> 0.8.0"],
          ["xquartz", "~> 1.0.0"],
          ["vagrant", "~> 0.2.0"],
          ["virtualbox", ">= 0.0.0"],
          ["zip_app", "~> 0.2.2"]] },
       { name: "ut_workstation",
         version: "1.0.0",
         dependencies: [["apt", "~> 2.0.0"],
          ["bashrc", ">= 0.0.0"],
          ["chgems", "~> 1.0.2"],
          ["chruby", ">= 0.0.0"],
          ["dmg", "~> 1.1.0"],
          ["homebrew", ">= 0.0.0"],
          ["homesick", "~> 0.4.0"],
          ["mac_os_x", ">= 0.0.0"],
          ["mosh", "~> 0.3.0"],
          ["ubuntu", "~> 1.1.2"],
          ["user", "~> 0.3.0"],
          ["python", "~> 1.3.4"],
          ["ruby_build", "~> 0.8.0"],
          ["xquartz", "~> 1.0.0"],
          ["vagrant", "~> 0.2.0"],
          ["virtualbox", ">= 0.0.0"],
          ["zip_app", "~> 0.2.2"]] }],
      "uwsgi" =>
      [{ name: "uwsgi",
         version: "0.1.0",
         dependencies: [["python", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["conffile", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.11",
         dependencies: [["python", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.10",
         dependencies: [["python", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.9",
         dependencies: [["python", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.8",
         dependencies: [["runit", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.7",
         dependencies: [["python", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.6",
         dependencies: [["runit", ">= 0.0.0"], ["python", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.5",
         dependencies: [["python", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.4",
         dependencies: [["python", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.2",
         dependencies: [["python", ">= 0.0.0"], ["runit", ">= 0.0.0"]] },
       { name: "uwsgi",
         version: "0.0.1",
         dependencies: [["python", ">= 0.0.0"], ["runit", ">= 0.0.0"]] }],
      "vagabond" =>
      [{ name: "vagabond",
         version: "1.0.4",
         dependencies: [["lxc", "~> 1.1.0"], ["apt", ">= 2.0.0"]] },
       { name: "vagabond",
         version: "1.0.2",
         dependencies: [["lxc", "~> 1.1.0"], ["apt", ">= 2.0.0"]] },
       { name: "vagabond",
         version: "1.0.0",
         dependencies: [["lxc", "~> 1.0.2"], ["apt", "~> 2.0.0"]] }],
      "vagrant" =>
      [{ name: "vagrant",
         version: "0.2.0",
         dependencies: [["dmg", ">= 0.0.0"], ["windows", ">= 0.0.0"]] },
       { name: "vagrant",
         version: "0.1.1",
         dependencies: [["dmg", ">= 0.0.0"], ["windows", ">= 0.0.0"]] }],
      "vagrant_extras" =>
      [{ name: "vagrant_extras", version: "0.2.0", dependencies: [] }],
      "variomedia-dns-updater" =>
      [{ name: "variomedia-dns-updater",
         version: "1.0.0",
         dependencies: [["application", ">= 0.0.0"]] }],
      "varnishd" =>
      [{ name: "varnishd",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "varnishd",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] },
       { name: "varnishd",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] }],
      "vc2010" =>
      [{ name: "vc2010",
         version: "1.0.1",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "vc2010",
         version: "1.0.0",
         dependencies: [["windows", ">= 1.2.6"]] }],
      "vcruntime" =>
      [{ name: "vcruntime",
         version: "0.1.6",
         dependencies: [["windows", ">= 0.0.0"]] },
       { name: "vcruntime",
         version: "0.1.4",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "vertx" =>
      [{ name: "vertx",
         version: "1.0.0",
         dependencies: [["ark", ">= 0.0.0"], ["java", ">= 1.7.0"]] }],
      "vifm" => [{ name: "vifm", version: "1.0.0", dependencies: [] }],
      "virtualbox" =>
      [{ name: "virtualbox",
         version: "1.0.3",
         dependencies: [["dmg", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", "~> 3.1"],
          ["apache2", ">= 0.0.0"]] },
       { name: "virtualbox",
         version: "1.0.2",
         dependencies: [["dmg", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "virtualbox",
         version: "1.0.0",
         dependencies: [["dmg", ">= 0.0.0"],
          ["windows", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "virtualbox", version: "0.7.2", dependencies: [] },
       { name: "virtualbox", version: "0.7.1", dependencies: [] },
       { name: "virtualbox", version: "0.7.0", dependencies: [] },
       { name: "virtualbox", version: "0.6.1", dependencies: [] },
       { name: "virtualbox", version: "0.6.0", dependencies: [] },
       { name: "virtualbox", version: "0.0.1", dependencies: [] }],
      "virtual_hosts" =>
      [{ name: "virtual_hosts",
         version: "0.1.1",
         dependencies: [["apache2", ">= 0.0.0"]] },
       { name: "virtual_hosts",
         version: "0.1.0",
         dependencies: [["apache2", ">= 0.0.0"]] }],
      "visualstudio" =>
      [{ name: "visualstudio",
         version: "0.1.0",
         dependencies: [["charon", ">= 0.1.0"]] }],
      "vmware" =>
      [{ name: "vmware", version: "0.0.3", dependencies: [] },
       { name: "vmware", version: "0.0.2", dependencies: [] },
       { name: "vmware", version: "0.0.1", dependencies: [] }],
      "vmware-tools" =>
      [{ name: "vmware-tools", version: "0.1.2", dependencies: [] },
       { name: "vmware-tools", version: "0.1.1", dependencies: [] }],
      "vnc" =>
      [{ name: "vnc",
         version: "0.0.1",
         dependencies: [["x-windows", ">= 0.0.0"], ["gnome", ">= 0.0.0"]] }],
      "vnstat" => [{ name: "vnstat", version: "0.0.1", dependencies: [] }],
      "volumes" =>
      [{ name: "volumes",
         version: "3.0.4",
         dependencies: [["metachef", ">= 0.0.0"], ["xfs", ">= 0.0.0"]] }],
      "VRTSralus" => [{ name: "VRTSralus", version: "0.0.2", dependencies: [] }],
      "vsftpd" => [{ name: "vsftpd", version: "0.0.1", dependencies: [] }],
      "vslinko" =>
      [{ name: "vslinko",
         version: "0.0.2",
         dependencies: [["git", ">= 0.0.0"], ["sudo", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] },
       { name: "vslinko",
         version: "0.0.1",
         dependencies: [["git", ">= 0.0.0"], ["sudo", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] },
       { name: "vslinko",
         version: "0.0.0",
         dependencies: [["git", ">= 0.0.0"], ["sudo", ">= 0.0.0"], ["zsh", ">= 0.0.0"]] }],
      "vt-gpg" => [{ name: "vt-gpg", version: "1.0.0", dependencies: [] }],
      "wait" =>
      [{ name: "wait", version: "0.1.1", dependencies: [] },
       { name: "wait", version: "0.1.0", dependencies: [] }],
      "wal-e" =>
      [{ name: "wal-e",
         version: "0.1.1",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "wal-e",
         version: "0.1.0",
         dependencies: [["python", ">= 0.0.0"]] }],
      "wav2rtp" => [{ name: "wav2rtp", version: "1.0.0", dependencies: [] }],
      "web" =>
      [{ name: "web", version: "0.0.10", dependencies: [] },
       { name: "web", version: "0.0.9", dependencies: [] },
       { name: "web", version: "0.0.7", dependencies: [] },
       { name: "web", version: "0.0.6", dependencies: [] },
       { name: "web", version: "0.0.2", dependencies: [] },
       { name: "web", version: "0.0.1", dependencies: [] }],
      "webapp" =>
      [{ name: "webapp",
         version: "0.1.6",
         dependencies: [["nginx", "= 2.2.0"],
          ["nodejs", "~> 1.3.0"],
          ["postgresql", "~> 3.3.4"],
          ["redisio", "~> 1.7.0"],
          ["rvm", "~> 0.9.1"],
          ["monit", "~> 1.5.0"]] },
       { name: "webapp",
         version: "0.1.5",
         dependencies: [["nginx", "= 2.2.0"],
          ["nodejs", "~> 1.3.0"],
          ["postgresql", "~> 3.3.4"],
          ["redisio", "~> 1.7.0"],
          ["rvm", "~> 0.9.1"],
          ["monit", "~> 1.5.0"]] },
       { name: "webapp",
         version: "0.1.4",
         dependencies: [["nginx", "= 2.2.0"],
          ["nodejs", "~> 1.3.0"],
          ["postgresql", "~> 3.3.4"],
          ["redisio", "~> 1.7.0"],
          ["rvm", "~> 0.9.1"],
          ["monit", "~> 1.5.0"]] },
       { name: "webapp",
         version: "0.1.3",
         dependencies: [["nginx", "= 2.2.0"],
          ["nodejs", "~> 1.3.0"],
          ["postgresql", "~> 3.3.4"],
          ["redisio", "~> 1.7.0"],
          ["rvm", "~> 0.9.1"],
          ["monit", "~> 1.5.0"]] },
       { name: "webapp",
         version: "0.1.2",
         dependencies: [["nginx", "= 2.2.0"],
          ["nodejs", "~> 1.3.0"],
          ["postgresql", "~> 3.3.4"],
          ["redisio", "~> 1.7.0"],
          ["rvm", "~> 0.9.1"],
          ["monit", "~> 1.5.0"]] },
       { name: "webapp",
         version: "0.1.1",
         dependencies: [["nginx", "= 2.2.0"],
          ["nodejs", "~> 1.3.0"],
          ["postgresql", "~> 3.3.4"],
          ["redisio", "~> 1.7.0"],
          ["rvm", "~> 0.9.1"],
          ["monit", "~> 1.5.0"]] },
       { name: "webapp",
         version: "0.1.0",
         dependencies: [["nginx", "= 2.2.0"],
          ["nodejs", "~> 1.3.0"],
          ["postgresql", "~> 3.3.4"],
          ["redisio", "~> 1.7.0"],
          ["rvm", "~> 0.9.1"],
          ["monit", "~> 1.5.0"]] }],
      "webobjects" =>
      [{ name: "webobjects",
         version: "0.0.3",
         dependencies: [["apache2", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "webobjects",
         version: "0.0.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "webobjects",
         version: "0.0.1",
         dependencies: [["java", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] }],
      "webpi" =>
      [{ name: "webpi",
         version: "1.2.8",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "webpi",
         version: "1.2.6",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "webpi",
         version: "1.2.4",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "webpi",
         version: "1.2.2",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "webpi",
         version: "1.2.0",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "webpi",
         version: "1.1.0",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "webpi",
         version: "1.0.4",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "webpi",
         version: "1.0.2",
         dependencies: [["windows", ">= 1.2.6"]] },
       { name: "webpi",
         version: "1.0.0",
         dependencies: [["windows", ">= 1.0.8"]] }],
      "whitelist-node-attrs" =>
      [{ name: "whitelist-node-attrs", version: "1.1.0", dependencies: [] },
       { name: "whitelist-node-attrs", version: "1.0.0", dependencies: [] }],
      "wifi-networking" =>
      [{ name: "wifi-networking", version: "0.1.0", dependencies: [] }],
      "wikiarguments" =>
      [{ name: "wikiarguments", version: "0.1.2", dependencies: [] }],
      "wildfly-clu" => [{ name: "wildfly-clu", version: "0.0.1", dependencies: [] }],
      "windirstat" =>
      [{ name: "windirstat",
         version: "1.0.0",
         dependencies: [["windows", ">= 1.2.6"]] }],
      "windows-hostname" =>
      [{ name: "windows-hostname",
         version: "0.1.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "windows_ad" =>
      [{ name: "windows_ad",
         version: "0.2.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "windows_firewall" =>
      [{ name: "windows_firewall", version: "0.1.0", dependencies: [] }],
      "windows_print" =>
      [{ name: "windows_print",
         version: "0.1.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "windows_ssl" =>
      [{ name: "windows_ssl",
         version: "0.1.0",
         dependencies: [["windows", ">= 0.0.0"]] }],
      "winrm" =>
      [{ name: "winrm",
         version: "1.0.0",
         dependencies: [["windows", ">= 0.0.0"], ["powershell", ">= 0.0.0"]] }],
      "winstaller" =>
      [{ name: "winstaller",
         version: "1.0.3",
         dependencies: [["powershell", ">= 1.0.6"]] }],
      "wkhtmltopdf" =>
      [{ name: "wkhtmltopdf",
         version: "0.2.0",
         dependencies: [["apt", ">= 0.0.0"]] },
       { name: "wkhtmltopdf", version: "0.1.0", dependencies: [] }],
      "wlp" =>
      [{ name: "wlp", version: "0.2.1", dependencies: [["java", ">= 1.16.4"]] },
       { name: "wlp", version: "0.2.0", dependencies: [["java", ">= 0.0.0"]] },
       { name: "wlp", version: "0.1.0", dependencies: [["java", ">= 0.0.0"]] }],
      "wordpress" =>
      [{ name: "wordpress",
         version: "2.1.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["database", ">= 1.6.0"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"],
          ["iis", ">= 1.6.2"]] },
       { name: "wordpress",
         version: "2.0.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["database", ">= 1.6.0"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"],
          ["iis", ">= 1.6.2"]] },
       { name: "wordpress",
         version: "1.3.2",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"],
          ["iis", ">= 1.6.2"]] },
       { name: "wordpress",
         version: "1.3.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"],
          ["iis", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "1.2.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "1.1.2",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "1.1.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "1.0.0",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"]] },
       { name: "wordpress",
         version: "0.8.8",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"]] },
       { name: "wordpress",
         version: "0.8.6",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"]] },
       { name: "wordpress",
         version: "0.8.4",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"]] },
       { name: "wordpress",
         version: "0.8.2",
         dependencies: [["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.99.4"],
          ["mysql", ">= 1.0.5"]] },
       { name: "wordpress",
         version: "0.8.1",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "0.8.0",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "0.7.2",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "0.7.1",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "0.6.3",
         dependencies: [["php", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "0.6.2",
         dependencies: [["mysql", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "0.5.0",
         dependencies: [["mysql", ">= 0.0.0"],
          ["php", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "wordpress",
         version: "0.1.0",
         dependencies: [["mysql", ">= 0.0.0"], ["php", ">= 0.0.0"], ["apache2", ">= 0.0.0"]] }],
      "wordpress-windows" =>
      [{ name: "wordpress-windows",
         version: "0.1.36",
         dependencies: [["windows", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["apache2-windows", ">= 0.0.0"],
          ["php-windows", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] }],
      "x-windows" =>
      [{ name: "x-windows", version: "0.0.3", dependencies: [] },
       { name: "x-windows", version: "0.0.2", dependencies: [] },
       { name: "x-windows", version: "0.0.1", dependencies: [] }],
      "x11vnc" =>
      [{ name: "x11vnc", version: "0.0.3", dependencies: [] },
       { name: "x11vnc", version: "0.0.2", dependencies: [] },
       { name: "x11vnc", version: "0.0.1", dependencies: [] }],
      "x264" =>
      [{ name: "x264",
         version: "0.4.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "x264",
         version: "0.4.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "x264",
         version: "0.4.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "x264",
         version: "0.3.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "x264",
         version: "0.2.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "x264",
         version: "0.1.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "x264",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "x2go" =>
      [{ name: "x2go", version: "0.1.0", dependencies: [["yum", ">= 0.0.0"]] }],
      "x509" =>
      [{ name: "x509", version: "1.1.0", dependencies: [["vt-gpg", ">= 0.0.0"]] },
       { name: "x509", version: "1.0.3", dependencies: [["vt-gpg", ">= 0.0.0"]] },
       { name: "x509", version: "1.0.2", dependencies: [["vt-gpg", ">= 0.0.0"]] },
       { name: "x509", version: "1.0.1", dependencies: [["vt-gpg", ">= 0.0.0"]] },
       { name: "x509",
         version: "1.0.0",
         dependencies: [["vt-gpg", ">= 0.0.0"]] }],
      "xbuild" =>
      [{ name: "xbuild",
         version: "0.1.0",
         dependencies: [["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["git", ">= 0.0.0"]] }],
      "xcode" =>
      [{ name: "xcode", version: "1.1.2", dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "xcode", version: "1.1.0", dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "xcode", version: "1.0.0", dependencies: [["dmg", ">= 0.0.0"]] }],
      "xen" => [{ name: "xen", version: "1.0.0", dependencies: [] }],
      "xfce4" => [{ name: "xfce4", version: "0.1.0", dependencies: [] }],
      "xfs" =>
      [{ name: "xfs", version: "1.1.0", dependencies: [] },
       { name: "xfs", version: "1.0.0", dependencies: [] },
       { name: "xfs", version: "0.1.0", dependencies: [] }],
      "xinetd" => [{ name: "xinetd", version: "0.0.1", dependencies: [] }],
      "xpdf" => [{ name: "xpdf", version: "1.0.0", dependencies: [] }],
      "xquartz" =>
      [{ name: "xquartz", version: "1.0.0", dependencies: [["dmg", "~> 1.1"]] },
       { name: "xquartz", version: "0.1.0", dependencies: [["dmg", ">= 0.0.0"]] },
       { name: "xquartz",
         version: "0.0.1",
         dependencies: [["dmg", ">= 0.0.0"]] }],
      "xrdp" =>
      [{ name: "xrdp",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "xslt" => [{ name: "xslt", version: "0.0.1", dependencies: [] }],
      "xvfb" => [{ name: "xvfb", version: "0.0.1", dependencies: [] }],
      "xymon" => [{ name: "xymon", version: "0.1.0", dependencies: [] }],
      "yasm" =>
      [{ name: "yasm",
         version: "0.0.4",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "yasm",
         version: "0.0.3",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "yasm",
         version: "0.0.2",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] },
       { name: "yasm",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "yaws" => [{ name: "yaws", version: "0.0.1", dependencies: [] }],
      "yoke" => [{ name: "yoke", version: "0.0.1", dependencies: [] }],
      "youtrack" =>
      [{ name: "youtrack",
         version: "0.0.0",
         dependencies: [["bluepill", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "yslow" =>
      [{ name: "yslow",
         version: "0.1.0",
         dependencies: [["phantomjs", "~> 1.0.3"]] }],
      "yum-amazon" =>
      [{ name: "yum-amazon",
         version: "0.2.0",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-amazon",
         version: "0.1.4",
         dependencies: [["yum", "~> 3.0"]] }],
      "yum-centos" =>
      [{ name: "yum-centos",
         version: "0.2.2",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-centos",
         version: "0.2.0",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-centos",
         version: "0.1.4",
         dependencies: [["yum", "~> 3.0"]] }],
      "yum-corporate" =>
      [{ name: "yum-corporate",
         version: "3.0.1",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yum-corporate",
         version: "3.0.0",
         dependencies: [["yum", ">= 0.0.0"]] }],
      "yum-dell" =>
      [{ name: "yum-dell",
         version: "3.0.4",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yum-dell",
         version: "3.0.3",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yum-dell",
         version: "3.0.2",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yum-dell",
         version: "3.0.1",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yum-dell",
         version: "3.0.0",
         dependencies: [["yum", ">= 0.0.0"]] }],
      "yum-elrepo" =>
      [{ name: "yum-elrepo",
         version: "0.2.0",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-elrepo",
         version: "0.1.4",
         dependencies: [["yum", "~> 3.0"]] }],
      "yum-erlang_solutions" =>
      [{ name: "yum-erlang_solutions",
         version: "0.2.0",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-erlang_solutions",
         version: "0.1.4",
         dependencies: [["yum", "~> 3.0"]] }],
      "yum-fedora" =>
      [{ name: "yum-fedora",
         version: "0.2.2",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-fedora",
         version: "0.2.0",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-fedora",
         version: "0.1.4",
         dependencies: [["yum", "~> 3.0"]] }],
      "yum-ius" =>
      [{ name: "yum-ius",
         version: "0.2.0",
         dependencies: [["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "yum-ius",
         version: "0.1.4",
         dependencies: [["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] }],
      "yum-oracle" =>
      [{ name: "yum-oracle",
         version: "1.0.0",
         dependencies: [["yum", "~> 3.0"]] }],
      "yum-percona" =>
      [{ name: "yum-percona",
         version: "0.2.0",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-percona",
         version: "0.1.6",
         dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-percona",
         version: "0.1.4",
         dependencies: [["yum", "~> 3.0"]] }],
      "yum-pgdg" =>
      [{ name: "yum-pgdg", version: "0.2.0", dependencies: [["yum", "~> 3.0"]] },
       { name: "yum-pgdg", version: "0.1.4", dependencies: [["yum", "~> 3.0"]] }],
      "yum-repoforge" =>
      [{ name: "yum-repoforge",
         version: "0.2.0",
         dependencies: [["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "yum-repoforge",
         version: "0.1.4",
         dependencies: [["yum", "~> 3.0"], ["yum-epel", ">= 0.0.0"]] }],
      "yum-vmware-tools" =>
      [{ name: "yum-vmware-tools",
         version: "3.0.2",
         dependencies: [["yum", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "yum-vmware-tools",
         version: "3.0.1",
         dependencies: [["yum", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] },
       { name: "yum-vmware-tools",
         version: "3.0.0",
         dependencies: [["yum", ">= 0.0.0"], ["yum-epel", ">= 0.0.0"]] }],
      "yumrepo" =>
      [{ name: "yumrepo", version: "3.0.0", dependencies: [["yum", "< 3.0.0"]] },
       { name: "yumrepo", version: "2.1.0", dependencies: [["yum", "< 3.0.0"]] },
       { name: "yumrepo", version: "2.0.0", dependencies: [["yum", ">= 2.3.0"]] },
       { name: "yumrepo",
         version: "0.16.6",
         dependencies: [["yum", ">= 1.0.0"]] },
       { name: "yumrepo",
         version: "0.16.5",
         dependencies: [["yum", ">= 1.0.0"]] },
       { name: "yumrepo",
         version: "0.16.4",
         dependencies: [["yum", ">= 1.0.0"]] },
       { name: "yumrepo",
         version: "0.16.3",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.16.2",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.16.0",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.15.4",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.15.2",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.15.0",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.14.1",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.14.0",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.13.0",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.12.8",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.12.6",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.12.4",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.12.2",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo",
         version: "0.12.0",
         dependencies: [["yum", ">= 0.0.0"]] },
       { name: "yumrepo", version: "0.11.1", dependencies: [] },
       { name: "yumrepo", version: "0.11.0", dependencies: [] },
       { name: "yumrepo", version: "0.10.1", dependencies: [] },
       { name: "yumrepo", version: "0.10.0", dependencies: [] },
       { name: "yumrepo", version: "0.0.8", dependencies: [] },
       { name: "yumrepo", version: "0.0.6", dependencies: [] },
       { name: "yumrepo", version: "0.0.4", dependencies: [] },
       { name: "yumrepo", version: "0.0.2", dependencies: [] }],
      "yum_mysql_community" =>
      [{ name: "yum_mysql_community",
         version: "0.0.4",
         dependencies: [["yum", "~> 3.1.0"]] },
       { name: "yum_mysql_community",
         version: "0.0.3",
         dependencies: [["yum", "~> 3.0"]] }],
      "zabbix" =>
      [{ name: "zabbix",
         version: "0.0.40",
         dependencies: [["database", ">= 1.3.0"],
          ["ufw", ">= 0.6.1"],
          ["mysql", ">= 1.3.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 1.0.8"]] },
       { name: "zabbix",
         version: "0.0.39",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["ufw", ">= 0.6.1"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 1.0.8"]] },
       { name: "zabbix",
         version: "0.0.37",
         dependencies: [["apache2", ">= 1.0.8"],
          ["yum", ">= 0.0.0"],
          ["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"]] },
       { name: "zabbix",
         version: "0.0.36",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["ufw", ">= 0.6.1"],
          ["apache2", ">= 1.0.8"],
          ["yum", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.35",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 1.0.8"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"]] },
       { name: "zabbix",
         version: "0.0.34",
         dependencies: [["database", ">= 1.0.0"],
          ["apache2", ">= 1.0.8"],
          ["ufw", ">= 0.6.1"],
          ["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.33",
         dependencies: [["database", ">= 1.0.0"],
          ["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"],
          ["apache2", ">= 1.0.8"],
          ["yum", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.32",
         dependencies: [["apache2", ">= 1.0.8"],
          ["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"]] },
       { name: "zabbix",
         version: "0.0.31",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["apache2", ">= 1.0.8"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"]] },
       { name: "zabbix",
         version: "0.0.30",
         dependencies: [["apache2", ">= 1.0.8"],
          ["yum", ">= 0.0.0"],
          ["database", ">= 1.0.0"],
          ["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"]] },
       { name: "zabbix",
         version: "0.0.29",
         dependencies: [["database", ">= 1.0.0"],
          ["apache2", ">= 1.0.8"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["mysql", ">= 1.2.0"]] },
       { name: "zabbix",
         version: "0.0.28",
         dependencies: [["apache2", ">= 1.0.8"],
          ["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.27",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 1.0.8"]] },
       { name: "zabbix",
         version: "0.0.26",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 1.0.8"]] },
       { name: "zabbix",
         version: "0.0.25",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 1.0.8"]] },
       { name: "zabbix",
         version: "0.0.24",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 1.0.8"]] },
       { name: "zabbix",
         version: "0.0.23",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 1.0.8"]] },
       { name: "zabbix",
         version: "0.0.22",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 1.0.8"]] },
       { name: "zabbix",
         version: "0.0.21",
         dependencies: [["mysql", ">= 1.2.0"],
          ["apache2>= 1.0.8", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"]] },
       { name: "zabbix",
         version: "0.0.20",
         dependencies: [["mysql", ">= 1.2.0"],
          ["yum", ">= 0.0.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.19",
         dependencies: [["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.18",
         dependencies: [["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.17",
         dependencies: [["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.16",
         dependencies: [["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.15",
         dependencies: [["mysql", ">= 1.2.0"],
          ["ufw", ">= 0.6.1"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.14",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.13",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.12",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.11",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.10",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.9",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.8",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.7",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.6",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.5",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix",
         version: "0.0.4",
         dependencies: [["mysql", ">= 1.2.0"],
          ["database", ">= 1.0.0"],
          ["apache2", ">= 0.0.0"]] },
       { name: "zabbix", version: "0.0.3", dependencies: [] },
       { name: "zabbix", version: "0.0.2", dependencies: [] },
       { name: "zabbix", version: "0.0.1", dependencies: [] }],
      "zabbix_windows" =>
      [{ name: "zabbix_windows", version: "0.0.1", dependencies: [] }],
      "zarafa" =>
      [{ name: "zarafa",
         version: "2.1.0",
         dependencies: [["dspam", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["ark", ">= 0.0.0"],
          ["openldap", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["clamav", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"]] },
       { name: "zarafa",
         version: "1.3.0",
         dependencies: [["dspam", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["clamav", ">= 0.0.0"],
          ["openldap", ">= 0.0.0"],
          ["database", ">= 0.0.0"]] },
       { name: "zarafa",
         version: "1.2.1",
         dependencies: [["openldap", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["clamav", ">= 0.0.0"],
          ["dspam", ">= 0.0.0"]] },
       { name: "zarafa",
         version: "1.2.0",
         dependencies: [["openssl", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["openldap", ">= 0.0.0"]] },
       { name: "zarafa",
         version: "1.1.0",
         dependencies: [["openldap", ">= 0.0.0"],
          ["database", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] }],
      "zend" =>
      [{ name: "zend", version: "0.2.0", dependencies: [["apt", ">= 0.0.0"]] },
       { name: "zend", version: "0.1.0", dependencies: [["apt", ">= 0.0.0"]] }],
      "zend-server" =>
      [{ name: "zend-server",
         version: "0.1.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["conf", ">= 0.0.0"]] },
       { name: "zend-server",
         version: "0.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"],
          ["conf", ">= 0.0.0"]] }],
      "zendserver" =>
      [{ name: "zendserver",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] },
       { name: "zendserver",
         version: "0.8.0",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "zenoss" =>
      [{ name: "zenoss",
         version: "2.0.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["mysql", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["rabbitmq", ">= 0.0.0"],
          ["selinux", ">= 0.0.0"],
          ["zenoss_client", ">= 0.0.0"],
          ["redisio", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "1.1.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "0.7.6",
         dependencies: [["apt", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "0.7.5",
         dependencies: [["apt", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "0.7.4",
         dependencies: [["apt", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "0.7.1",
         dependencies: [["openssl", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "0.7.0",
         dependencies: [["openssl", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["openssh", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "0.6.3",
         dependencies: [["apt", ">= 0.0.0"], ["openssh", ">= 0.0.0"], ["openssl", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "0.6.2",
         dependencies: [["openssl", ">= 0.0.0"], ["apt", "> 0.9.0"], ["openssh", ">= 0.0.0"]] },
       { name: "zenoss",
         version: "0.6.0",
         dependencies: [["openssl", ">= 0.0.0"], ["apt", "> 0.9.0"], ["openssh", ">= 0.0.0"]] }],
      "zenoss_client" =>
      [{ name: "zenoss_client", version: "1.1.2", dependencies: [] },
       { name: "zenoss_client", version: "1.1.0", dependencies: [] },
       { name: "zenoss_client", version: "1.0.0", dependencies: [] }],
      "zenoss_register" =>
      [{ name: "zenoss_register", version: "0.2.2", dependencies: [] },
       { name: "zenoss_register", version: "0.2.0", dependencies: [] },
       { name: "zenoss_register", version: "0.1.33", dependencies: [] }],
      "zentyal" =>
      [{ name: "zentyal",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"]] }],
      "zeoserver" =>
      [{ name: "zeoserver",
         version: "0.1.1",
         dependencies: [["python", ">= 0.0.0"]] },
       { name: "zeoserver",
         version: "0.1.0",
         dependencies: [["python", ">= 0.0.0"]] }],
      "zerigo" =>
      [{ name: "zerigo", version: "0.1.1", dependencies: [] },
       { name: "zerigo", version: "0.1.0", dependencies: [] }],
      "zeromq" =>
      [{ name: "zeromq",
         version: "1.0.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "zeromq",
         version: "1.0.1",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] },
       { name: "zeromq",
         version: "1.0.0",
         dependencies: [["apt", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["build-essential", ">= 0.0.0"]] }],
      "zerovm" =>
      [{ name: "zerovm",
         version: "0.1.0",
         dependencies: [["build-essential", ">= 0.0.0"], ["git", ">= 0.0.0"]] }],
      "zeus-zxtm" => [{ name: "zeus-zxtm", version: "0.1.0", dependencies: [] }],
      "zfs" =>
      [{ name: "zfs", version: "0.0.2", dependencies: [] },
       { name: "zfs", version: "0.0.1", dependencies: [] }],
      "ziggrid" =>
      [{ name: "ziggrid",
         version: "0.5.1",
         dependencies: [["java", "~> 1.10.2"],
          ["partial_search", "~> 1.0.0"],
          ["bluepill", "~> 2.2.2"]] },
       { name: "ziggrid",
         version: "0.5.0",
         dependencies: [["java", "~> 1.10.2"],
          ["partial_search", "~> 1.0.0"],
          ["bluepill", "~> 2.2.2"]] }],
      "zip" =>
      [{ name: "zip", version: "1.1.0", dependencies: [] },
       { name: "zip", version: "1.0.0", dependencies: [] }],
      "zip_app" =>
      [{ name: "zip_app", version: "0.2.2", dependencies: [] },
       { name: "zip_app", version: "0.2.0", dependencies: [] }],
      "zlib" =>
      [{ name: "zlib", version: "2.0.0", dependencies: [] },
       { name: "zlib", version: "1.0.2", dependencies: [] },
       { name: "zlib", version: "1.0.0", dependencies: [] },
       { name: "zlib", version: "0.1.0", dependencies: [] }],
      "znc" =>
      [{ name: "znc",
         version: "0.0.1",
         dependencies: [["build-essential", ">= 0.0.0"]] }],
      "zncrypt" =>
      [{ name: "zncrypt",
         version: "0.3.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.2.9",
         dependencies: [["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.2.5",
         dependencies: [["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["java", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.1.4",
         dependencies: [["yum", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.1.3",
         dependencies: [["apt", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.1.2",
         dependencies: [["apt", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.1.1",
         dependencies: [["yum", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.1.0",
         dependencies: [["yum", ">= 0.0.0"],
          ["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["openssl", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.0.2",
         dependencies: [["yum", ">= 0.0.0"], ["apt", ">= 0.0.0"]] },
       { name: "zncrypt",
         version: "0.0.1",
         dependencies: [["apt", ">= 0.0.0"], ["yum", ">= 0.0.0"]] }],
      "zone" =>
      [{ name: "zone", version: "0.0.6", dependencies: [] },
       { name: "zone", version: "0.0.5", dependencies: [] },
       { name: "zone", version: "0.0.4", dependencies: [] },
       { name: "zone", version: "0.0.3", dependencies: [] },
       { name: "zone", version: "0.0.2", dependencies: [] },
       { name: "zone", version: "0.0.1", dependencies: [] }],
      "zone2ldif" =>
      [{ name: "zone2ldif",
         version: "0.1.2",
         dependencies: [["perl", ">= 0.0.0"]] },
       { name: "zone2ldif",
         version: "0.1.0",
         dependencies: [["perl", ">= 0.0.0"]] }],
      "zonefile" =>
      [{ name: "zonefile", version: "0.9.2", dependencies: [] },
       { name: "zonefile", version: "0.9.1", dependencies: [] }],
      "zoneminder" => [{ name: "zoneminder", version: "0.1.0", dependencies: [] }],
      "zookeeper" =>
      [{ name: "zookeeper",
         version: "1.6.1",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.6.0",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.5.0",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.10",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.9",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.8",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.7",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.6",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.5",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.4",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.3",
         dependencies: [["java", ">= 0.0.0"], ["build-essential", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.4.1",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.3.3",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.3.1",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.2.3",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "zookeeper",
         version: "1.2.1",
         dependencies: [["java", ">= 0.0.0"]] },
       { name: "zookeeper", version: "1.1.0", dependencies: [] },
       { name: "zookeeper",
         version: "0.1.0",
         dependencies: [["runit", ">= 0.0.0"], ["java", ">= 0.0.0"]] }],
      "zookeeperd" =>
      [{ name: "zookeeperd",
         version: "0.1.6",
         dependencies: [["apt", ">= 0.0.0"],
          ["discovery", ">= 0.2.0"],
          ["java", ">= 0.0.0"],
          ["yum", ">= 0.0.0"]] },
       { name: "zookeeperd",
         version: "0.1.4",
         dependencies: [["discovery", ">= 0.2.0"]] },
       { name: "zookeeperd",
         version: "0.1.2",
         dependencies: [["discovery", ">= 0.2.0"]] },
       { name: "zookeeperd",
         version: "0.1.0",
         dependencies: [["discovery", ">= 0.2.0"]] }],
      "zookeeper_cluster" =>
      [{ name: "zookeeper_cluster",
         version: "3.0.4",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"]] },
       { name: "zookeeper_cluster",
         version: "3.0.3",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["runit", ">= 0.0.0"],
          ["volumes", ">= 0.0.0"],
          ["metachef", ">= 0.0.0"],
          ["hadoop_cluster", ">= 0.0.0"]] },
       { name: "zookeeper_cluster",
         version: "3.0.0",
         dependencies: [["java", ">= 0.0.0"],
          ["apt", ">= 0.0.0"],
          ["mountable_volumes", ">= 0.0.0"],
          ["provides_service", ">= 0.0.0"]] }],
      "zotonic" =>
      [{ name: "zotonic",
         version: "0.2.0",
         dependencies: [["erlang", ">= 1.2.0"], ["apt", ">= 1.7.0"]] },
       { name: "zotonic", version: "0.1.0", dependencies: [] }],
      "zpool" => [{ name: "zpool", version: "0.0.1", dependencies: [] }] }.freeze
end
