# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ParticipantList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, room_sid):
        """
        Initialize the ParticipantList

        :param Version version: Version that contains the resource
        :param room_sid: The room_sid

        :returns: twilio.rest.insights.v1.room.participant.ParticipantList
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantList
        """
        super(ParticipantList, self).__init__(version)

        # Path Solution
        self._solution = {'room_sid': room_sid, }
        self._uri = '/Video/Rooms/{room_sid}/Participants'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams ParticipantInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.insights.v1.room.participant.ParticipantInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists ParticipantInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.insights.v1.room.participant.ParticipantInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of ParticipantInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ParticipantInstance
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ParticipantPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ParticipantInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ParticipantInstance
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ParticipantPage(self._version, response, self._solution)

    def get(self, participant_sid):
        """
        Constructs a ParticipantContext

        :param participant_sid: The participant_sid

        :returns: twilio.rest.insights.v1.room.participant.ParticipantContext
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantContext
        """
        return ParticipantContext(
            self._version,
            room_sid=self._solution['room_sid'],
            participant_sid=participant_sid,
        )

    def __call__(self, participant_sid):
        """
        Constructs a ParticipantContext

        :param participant_sid: The participant_sid

        :returns: twilio.rest.insights.v1.room.participant.ParticipantContext
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantContext
        """
        return ParticipantContext(
            self._version,
            room_sid=self._solution['room_sid'],
            participant_sid=participant_sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1.ParticipantList>'


class ParticipantPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the ParticipantPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param room_sid: The room_sid

        :returns: twilio.rest.insights.v1.room.participant.ParticipantPage
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantPage
        """
        super(ParticipantPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ParticipantInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.insights.v1.room.participant.ParticipantInstance
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantInstance
        """
        return ParticipantInstance(self._version, payload, room_sid=self._solution['room_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1.ParticipantPage>'


class ParticipantContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, room_sid, participant_sid):
        """
        Initialize the ParticipantContext

        :param Version version: Version that contains the resource
        :param room_sid: The room_sid
        :param participant_sid: The participant_sid

        :returns: twilio.rest.insights.v1.room.participant.ParticipantContext
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantContext
        """
        super(ParticipantContext, self).__init__(version)

        # Path Solution
        self._solution = {'room_sid': room_sid, 'participant_sid': participant_sid, }
        self._uri = '/Video/Rooms/{room_sid}/Participants/{participant_sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the ParticipantInstance

        :returns: The fetched ParticipantInstance
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ParticipantInstance(
            self._version,
            payload,
            room_sid=self._solution['room_sid'],
            participant_sid=self._solution['participant_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Insights.V1.ParticipantContext {}>'.format(context)


class ParticipantInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class RoomStatus(object):
        IN_PROGRESS = "in_progress"
        COMPLETED = "completed"

    class Codec(object):
        VP8 = "VP8"
        H264 = "H264"
        VP9 = "VP9"

    class TwilioRealm(object):
        US1 = "us1"
        US2 = "us2"
        AU1 = "au1"
        BR1 = "br1"
        IE1 = "ie1"
        JP1 = "jp1"
        SG1 = "sg1"
        IN1 = "in1"
        DE1 = "de1"
        GLL = "gll"

    class EdgeLocation(object):
        ASHBURN = "ashburn"
        DUBLIN = "dublin"
        FRANKFURT = "frankfurt"
        SINGAPORE = "singapore"
        SYDNEY = "sydney"
        SAO_PAULO = "sao_paulo"
        ROAMING = "roaming"
        UMATILLA = "umatilla"
        TOKYO = "tokyo"

    def __init__(self, version, payload, room_sid, participant_sid=None):
        """
        Initialize the ParticipantInstance

        :returns: twilio.rest.insights.v1.room.participant.ParticipantInstance
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantInstance
        """
        super(ParticipantInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'participant_sid': payload.get('participant_sid'),
            'participant_identity': payload.get('participant_identity'),
            'join_time': deserialize.iso8601_datetime(payload.get('join_time')),
            'leave_time': deserialize.iso8601_datetime(payload.get('leave_time')),
            'duration_sec': deserialize.integer(payload.get('duration_sec')),
            'account_sid': payload.get('account_sid'),
            'room_sid': payload.get('room_sid'),
            'status': payload.get('status'),
            'codecs': payload.get('codecs'),
            'end_reason': payload.get('end_reason'),
            'error_code': deserialize.integer(payload.get('error_code')),
            'error_code_url': payload.get('error_code_url'),
            'media_region': payload.get('media_region'),
            'properties': payload.get('properties'),
            'edge_location': payload.get('edge_location'),
            'publisher_info': payload.get('publisher_info'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {
            'room_sid': room_sid,
            'participant_sid': participant_sid or self._properties['participant_sid'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ParticipantContext for this ParticipantInstance
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantContext
        """
        if self._context is None:
            self._context = ParticipantContext(
                self._version,
                room_sid=self._solution['room_sid'],
                participant_sid=self._solution['participant_sid'],
            )
        return self._context

    @property
    def participant_sid(self):
        """
        :returns: The participant_sid
        :rtype: unicode
        """
        return self._properties['participant_sid']

    @property
    def participant_identity(self):
        """
        :returns: The participant_identity
        :rtype: unicode
        """
        return self._properties['participant_identity']

    @property
    def join_time(self):
        """
        :returns: The join_time
        :rtype: datetime
        """
        return self._properties['join_time']

    @property
    def leave_time(self):
        """
        :returns: The leave_time
        :rtype: datetime
        """
        return self._properties['leave_time']

    @property
    def duration_sec(self):
        """
        :returns: The duration_sec
        :rtype: unicode
        """
        return self._properties['duration_sec']

    @property
    def account_sid(self):
        """
        :returns: The account_sid
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def room_sid(self):
        """
        :returns: The room_sid
        :rtype: unicode
        """
        return self._properties['room_sid']

    @property
    def status(self):
        """
        :returns: The status
        :rtype: ParticipantInstance.RoomStatus
        """
        return self._properties['status']

    @property
    def codecs(self):
        """
        :returns: The codecs
        :rtype: list[ParticipantInstance.Codec]
        """
        return self._properties['codecs']

    @property
    def end_reason(self):
        """
        :returns: The end_reason
        :rtype: unicode
        """
        return self._properties['end_reason']

    @property
    def error_code(self):
        """
        :returns: The error_code
        :rtype: unicode
        """
        return self._properties['error_code']

    @property
    def error_code_url(self):
        """
        :returns: The error_code_url
        :rtype: unicode
        """
        return self._properties['error_code_url']

    @property
    def media_region(self):
        """
        :returns: The media_region
        :rtype: ParticipantInstance.TwilioRealm
        """
        return self._properties['media_region']

    @property
    def properties(self):
        """
        :returns: The properties
        :rtype: dict
        """
        return self._properties['properties']

    @property
    def edge_location(self):
        """
        :returns: The edge_location
        :rtype: ParticipantInstance.EdgeLocation
        """
        return self._properties['edge_location']

    @property
    def publisher_info(self):
        """
        :returns: The publisher_info
        :rtype: dict
        """
        return self._properties['publisher_info']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the ParticipantInstance

        :returns: The fetched ParticipantInstance
        :rtype: twilio.rest.insights.v1.room.participant.ParticipantInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Insights.V1.ParticipantInstance {}>'.format(context)
