/* SPDX-License-Identifier: GPL-2.0+ */
/* Copyright (c) 2024 Hisilicon Limited. */

#ifndef __HBG_REG_H
#define __HBG_REG_H

/* DEV SPEC */
#define HBG_REG_SPEC_VALID_ADDR			0x0000
#define HBG_REG_EVENT_REQ_ADDR			0x0004
#define HBG_REG_MAC_ID_ADDR			0x0008
#define HBG_REG_PHY_ID_ADDR			0x000C
#define HBG_REG_MAC_ADDR_ADDR			0x0010
#define HBG_REG_MAC_ADDR_HIGH_ADDR		0x0014
#define HBG_REG_UC_MAC_NUM_ADDR			0x0018
#define HBG_REG_MDIO_FREQ_ADDR			0x0024
#define HBG_REG_MAX_MTU_ADDR			0x0028
#define HBG_REG_MIN_MTU_ADDR			0x002C
#define HBG_REG_TX_FIFO_NUM_ADDR		0x0030
#define HBG_REG_RX_FIFO_NUM_ADDR		0x0034
#define HBG_REG_VLAN_LAYERS_ADDR		0x0038
#define HBG_REG_PUSH_REQ_ADDR			0x00F0
#define HBG_REG_MSG_HEADER_ADDR			0x00F4
#define HBG_REG_MSG_HEADER_OPCODE_M		GENMASK(7, 0)
#define HBG_REG_MSG_HEADER_STATUS_M		GENMASK(11, 8)
#define HBG_REG_MSG_HEADER_DATA_NUM_M		GENMASK(19, 12)
#define HBG_REG_MSG_HEADER_RESP_CODE_M		GENMASK(27, 20)
#define HBG_REG_MSG_DATA_BASE_ADDR		0x0100

/* MDIO */
#define HBG_REG_MDIO_BASE			0x8000
#define HBG_REG_MDIO_COMMAND_ADDR		(HBG_REG_MDIO_BASE + 0x0000)
#define HBG_REG_MDIO_COMMAND_CLK_SEL_EXP_B	BIT(17)
#define HBG_REG_MDIO_COMMAND_AUTO_SCAN_B	BIT(16)
#define HBG_REG_MDIO_COMMAND_CLK_SEL_B		BIT(15)
#define HBG_REG_MDIO_COMMAND_START_B		BIT(14)
#define HBG_REG_MDIO_COMMAND_ST_M		GENMASK(13, 12)
#define HBG_REG_MDIO_COMMAND_OP_M		GENMASK(11, 10)
#define HBG_REG_MDIO_COMMAND_PRTAD_M		GENMASK(9, 5)
#define HBG_REG_MDIO_COMMAND_DEVAD_M		GENMASK(4, 0)
#define HBG_REG_MDIO_ADDR_ADDR			(HBG_REG_MDIO_BASE + 0x0004)
#define HBG_REG_MDIO_WDATA_ADDR			(HBG_REG_MDIO_BASE + 0x0008)
#define HBG_REG_MDIO_WDATA_M			GENMASK(15, 0)
#define HBG_REG_MDIO_RDATA_ADDR			(HBG_REG_MDIO_BASE + 0x000C)
#define HBG_REG_MDIO_STA_ADDR			(HBG_REG_MDIO_BASE + 0x0010)

/* GMAC */
#define HBG_REG_SGMII_BASE			0x10000
#define HBG_REG_DUPLEX_TYPE_ADDR		(HBG_REG_SGMII_BASE + 0x0008)
#define HBG_REG_FD_FC_TYPE_ADDR			(HBG_REG_SGMII_BASE + 0x000C)
#define HBG_REG_FC_TX_TIMER_ADDR		(HBG_REG_SGMII_BASE + 0x001C)
#define HBG_REG_FD_FC_ADDR_LOW_ADDR		(HBG_REG_SGMII_BASE + 0x0020)
#define HBG_REG_FD_FC_ADDR_HIGH_ADDR		(HBG_REG_SGMII_BASE + 0x0024)
#define HBG_REG_DUPLEX_B			BIT(0)
#define HBG_REG_MAX_FRAME_SIZE_ADDR		(HBG_REG_SGMII_BASE + 0x003C)
#define HBG_REG_PORT_MODE_ADDR			(HBG_REG_SGMII_BASE + 0x0040)
#define HBG_REG_PORT_MODE_M			GENMASK(3, 0)
#define HBG_REG_PORT_ENABLE_ADDR		(HBG_REG_SGMII_BASE + 0x0044)
#define HBG_REG_PORT_ENABLE_RX_B		BIT(1)
#define HBG_REG_PORT_ENABLE_TX_B		BIT(2)
#define HBG_REG_PAUSE_ENABLE_ADDR		(HBG_REG_SGMII_BASE + 0x0048)
#define HBG_REG_PAUSE_ENABLE_RX_B		BIT(0)
#define HBG_REG_PAUSE_ENABLE_TX_B		BIT(1)
#define HBG_REG_AN_NEG_STATE_ADDR		(HBG_REG_SGMII_BASE + 0x0058)
#define HBG_REG_AN_NEG_STATE_NP_LINK_OK_B	BIT(15)
#define HBG_REG_TRANSMIT_CTRL_ADDR		(HBG_REG_SGMII_BASE + 0x0060)
#define HBG_REG_TRANSMIT_CTRL_PAD_EN_B		BIT(7)
#define HBG_REG_TRANSMIT_CTRL_CRC_ADD_B		BIT(6)
#define HBG_REG_TRANSMIT_CTRL_AN_EN_B		BIT(5)
#define HBG_REG_REC_FILT_CTRL_ADDR		(HBG_REG_SGMII_BASE + 0x0064)
#define HBG_REG_REC_FILT_CTRL_UC_MATCH_EN_B	BIT(0)
#define HBG_REG_REC_FILT_CTRL_PAUSE_FRM_PASS_B	BIT(4)
#define HBG_REG_RX_OCTETS_TOTAL_OK_ADDR		(HBG_REG_SGMII_BASE + 0x0080)
#define HBG_REG_RX_OCTETS_BAD_ADDR		(HBG_REG_SGMII_BASE + 0x0084)
#define HBG_REG_RX_UC_PKTS_ADDR			(HBG_REG_SGMII_BASE + 0x0088)
#define HBG_REG_RX_MC_PKTS_ADDR			(HBG_REG_SGMII_BASE + 0x008C)
#define HBG_REG_RX_BC_PKTS_ADDR			(HBG_REG_SGMII_BASE + 0x0090)
#define HBG_REG_RX_PKTS_64OCTETS_ADDR		(HBG_REG_SGMII_BASE + 0x0094)
#define HBG_REG_RX_PKTS_65TO127OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x0098)
#define HBG_REG_RX_PKTS_128TO255OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x009C)
#define HBG_REG_RX_PKTS_256TO511OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x00A0)
#define HBG_REG_RX_PKTS_512TO1023OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x00A4)
#define HBG_REG_RX_PKTS_1024TO1518OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x00A8)
#define HBG_REG_RX_PKTS_1519TOMAXOCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x00AC)
#define HBG_REG_RX_FCS_ERRORS_ADDR		(HBG_REG_SGMII_BASE + 0x00B0)
#define HBG_REG_RX_TAGGED_ADDR			(HBG_REG_SGMII_BASE + 0x00B4)
#define HBG_REG_RX_DATA_ERR_ADDR		(HBG_REG_SGMII_BASE + 0x00B8)
#define HBG_REG_RX_ALIGN_ERRORS_ADDR		(HBG_REG_SGMII_BASE + 0x00BC)
#define HBG_REG_RX_LONG_ERRORS_ADDR		(HBG_REG_SGMII_BASE + 0x00C0)
#define HBG_REG_RX_JABBER_ERRORS_ADDR		(HBG_REG_SGMII_BASE + 0x00C4)
#define HBG_REG_RX_PAUSE_MACCTL_FRAMCOUNTER_ADDR   (HBG_REG_SGMII_BASE + 0x00C8)
#define HBG_REG_RX_UNKNOWN_MACCTL_FRAMCOUNTER_ADDR (HBG_REG_SGMII_BASE + 0x00CC)
#define HBG_REG_RX_VERY_LONG_ERR_CNT_ADDR	(HBG_REG_SGMII_BASE + 0x00D0)
#define HBG_REG_RX_RUNT_ERR_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x00D4)
#define HBG_REG_RX_SHORT_ERR_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x00D8)
#define HBG_REG_RX_FILT_PKT_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x00E8)
#define HBG_REG_RX_OCTETS_TOTAL_FILT_ADDR	(HBG_REG_SGMII_BASE + 0x00EC)
#define HBG_REG_OCTETS_TRANSMITTED_OK_ADDR	(HBG_REG_SGMII_BASE + 0x0100)
#define HBG_REG_OCTETS_TRANSMITTED_BAD_ADDR	(HBG_REG_SGMII_BASE + 0x0104)
#define HBG_REG_TX_UC_PKTS_ADDR			(HBG_REG_SGMII_BASE + 0x0108)
#define HBG_REG_TX_MC_PKTS_ADDR			(HBG_REG_SGMII_BASE + 0x010C)
#define HBG_REG_TX_BC_PKTS_ADDR			(HBG_REG_SGMII_BASE + 0x0110)
#define HBG_REG_TX_PKTS_64OCTETS_ADDR		(HBG_REG_SGMII_BASE + 0x0114)
#define HBG_REG_TX_PKTS_65TO127OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x0118)
#define HBG_REG_TX_PKTS_128TO255OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x011C)
#define HBG_REG_TX_PKTS_256TO511OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x0120)
#define HBG_REG_TX_PKTS_512TO1023OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x0124)
#define HBG_REG_TX_PKTS_1024TO1518OCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x0128)
#define HBG_REG_TX_PKTS_1519TOMAXOCTETS_ADDR	(HBG_REG_SGMII_BASE + 0x012C)
#define HBG_REG_TX_EXCESSIVE_LENGTH_DROP_ADDR	(HBG_REG_SGMII_BASE + 0x014C)
#define HBG_REG_TX_UNDERRUN_ADDR		(HBG_REG_SGMII_BASE + 0x0150)
#define HBG_REG_TX_TAGGED_ADDR			(HBG_REG_SGMII_BASE + 0x0154)
#define HBG_REG_TX_CRC_ERROR_ADDR		(HBG_REG_SGMII_BASE + 0x0158)
#define HBG_REG_TX_PAUSE_FRAMES_ADDR		(HBG_REG_SGMII_BASE + 0x015C)
#define HBG_REG_LINE_LOOP_BACK_ADDR		(HBG_REG_SGMII_BASE + 0x01A8)
#define HBG_REG_CF_CRC_STRIP_ADDR		(HBG_REG_SGMII_BASE + 0x01B0)
#define HBG_REG_CF_CRC_STRIP_B			BIT(0)
#define HBG_REG_MODE_CHANGE_EN_ADDR		(HBG_REG_SGMII_BASE + 0x01B4)
#define HBG_REG_MODE_CHANGE_EN_B		BIT(0)
#define HBG_REG_LOOP_REG_ADDR			(HBG_REG_SGMII_BASE + 0x01DC)
#define HBG_REG_RECV_CTRL_ADDR			(HBG_REG_SGMII_BASE + 0x01E0)
#define HBG_REG_RECV_CTRL_STRIP_PAD_EN_B	BIT(3)
#define HBG_REG_VLAN_CODE_ADDR			(HBG_REG_SGMII_BASE + 0x01E8)
#define HBG_REG_RX_OVERRUN_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x01EC)
#define HBG_REG_RX_LENGTHFIELD_ERR_CNT_ADDR	(HBG_REG_SGMII_BASE + 0x01F4)
#define HBG_REG_RX_FAIL_COMMA_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x01F8)
#define HBG_REG_STATION_ADDR_LOW_0_ADDR		(HBG_REG_SGMII_BASE + 0x0200)
#define HBG_REG_STATION_ADDR_HIGH_0_ADDR	(HBG_REG_SGMII_BASE + 0x0204)
#define HBG_REG_STATION_ADDR_LOW_1_ADDR		(HBG_REG_SGMII_BASE + 0x0208)
#define HBG_REG_STATION_ADDR_HIGH_1_ADDR	(HBG_REG_SGMII_BASE + 0x020C)
#define HBG_REG_STATION_ADDR_LOW_2_ADDR		(HBG_REG_SGMII_BASE + 0x0210)
#define HBG_REG_STATION_ADDR_HIGH_2_ADDR	(HBG_REG_SGMII_BASE + 0x0214)
#define HBG_REG_STATION_ADDR_LOW_3_ADDR		(HBG_REG_SGMII_BASE + 0x0218)
#define HBG_REG_STATION_ADDR_HIGH_3_ADDR	(HBG_REG_SGMII_BASE + 0x021C)
#define HBG_REG_STATION_ADDR_LOW_4_ADDR		(HBG_REG_SGMII_BASE + 0x0220)
#define HBG_REG_STATION_ADDR_HIGH_4_ADDR	(HBG_REG_SGMII_BASE + 0x0224)
#define HBG_REG_STATION_ADDR_LOW_5_ADDR		(HBG_REG_SGMII_BASE + 0x0228)
#define HBG_REG_STATION_ADDR_HIGH_5_ADDR	(HBG_REG_SGMII_BASE + 0x022C)
#define HBG_REG_STATION_ADDR_LOW_MSK_0		(HBG_REG_SGMII_BASE + 0x0230)
#define HBG_REG_STATION_ADDR_LOW_MSK_1		(HBG_REG_SGMII_BASE + 0x0238)

/* PCU */
#define HBG_REG_TX_FIFO_THRSLD_ADDR		(HBG_REG_SGMII_BASE + 0x0420)
#define HBG_REG_RX_FIFO_THRSLD_ADDR		(HBG_REG_SGMII_BASE + 0x0424)
#define HBG_REG_FIFO_THRSLD_FULL_M		GENMASK(25, 16)
#define HBG_REG_FIFO_THRSLD_EMPTY_M		GENMASK(9, 0)
#define HBG_REG_CFG_FIFO_THRSLD_ADDR		(HBG_REG_SGMII_BASE + 0x0428)
#define HBG_REG_CFG_FIFO_THRSLD_TX_FULL_M	GENMASK(31, 24)
#define HBG_REG_CFG_FIFO_THRSLD_TX_EMPTY_M	GENMASK(23, 16)
#define HBG_REG_CFG_FIFO_THRSLD_RX_FULL_M	GENMASK(15, 8)
#define HBG_REG_CFG_FIFO_THRSLD_RX_EMPTY_M	GENMASK(7, 0)
#define HBG_REG_CF_INTRPT_MSK_ADDR		(HBG_REG_SGMII_BASE + 0x042C)
#define HBG_INT_MSK_WE_ERR_B			BIT(31)
#define HBG_INT_MSK_RBREQ_ERR_B			BIT(30)
#define HBG_INT_MSK_MAC_FIFO_ERR_B		BIT(29)
#define HBG_INT_MSK_RX_AHB_ERR_B		BIT(28)
#define HBG_INT_MSK_RX_DROP_B			BIT(26)
#define HBG_INT_MSK_TX_DROP_B			BIT(25)
#define HBG_INT_MSK_TXCFG_AVL_B			BIT(24)
#define HBG_INT_MSK_REL_BUF_ERR_B		BIT(23)
#define HBG_INT_MSK_RX_BUF_AVL_B		BIT(22)
#define HBG_INT_MSK_TX_AHB_ERR_B		BIT(21)
#define HBG_INT_MSK_SRAM_PARITY_ERR_B		BIT(20)
#define HBG_INT_MSK_MAC_APP_TX_FIFO_ERR_B	BIT(19)
#define HBG_INT_MSK_MAC_APP_RX_FIFO_ERR_B	BIT(18)
#define HBG_INT_MSK_MAC_PCS_TX_FIFO_ERR_B	BIT(17)
#define HBG_INT_MSK_MAC_PCS_RX_FIFO_ERR_B	BIT(16)
#define HBG_INT_MSK_MAC_MII_FIFO_ERR_B		BIT(15)
#define HBG_INT_MSK_TX_PKT_CPL_B		BIT(14)
#define HBG_INT_MSK_TX_B			BIT(1) /* just used in driver */
#define HBG_INT_MSK_RX_B			BIT(0) /* just used in driver */
#define HBG_REG_CF_INTRPT_STAT_ADDR		(HBG_REG_SGMII_BASE + 0x0434)
#define HBG_REG_CF_INTRPT_CLR_ADDR		(HBG_REG_SGMII_BASE + 0x0438)
#define HBG_REG_TX_BUS_ERR_ADDR_ADDR		(HBG_REG_SGMII_BASE + 0x043C)
#define HBG_REG_RX_BUS_ERR_ADDR_ADDR		(HBG_REG_SGMII_BASE + 0x0440)
#define HBG_REG_MAX_FRAME_LEN_ADDR		(HBG_REG_SGMII_BASE + 0x0444)
#define HBG_REG_MAX_FRAME_LEN_M			GENMASK(15, 0)
#define HBG_REG_TX_DROP_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x0448)
#define HBG_REG_RX_OVER_FLOW_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x044C)
#define HBG_REG_DEBUG_ST_MCH_ADDR		(HBG_REG_SGMII_BASE + 0x0450)
#define HBG_REG_FIFO_CURR_STATUS_ADDR		(HBG_REG_SGMII_BASE + 0x0454)
#define HBG_REG_FIFO_HIST_STATUS_ADDR		(HBG_REG_SGMII_BASE + 0x0458)
#define HBG_REG_CF_CFF_DATA_NUM_ADDR		(HBG_REG_SGMII_BASE + 0x045C)
#define HBG_REG_CF_CFF_DATA_NUM_ADDR_TX_M	GENMASK(8, 0)
#define HBG_REG_CF_CFF_DATA_NUM_ADDR_RX_M	GENMASK(24, 16)
#define HBG_REG_TX_CS_FAIL_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x0460)
#define HBG_REG_RX_TRANS_PKG_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x0464)
#define HBG_REG_TX_TRANS_PKG_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x0468)
#define HBG_REG_CF_TX_PAUSE_ADDR		(HBG_REG_SGMII_BASE + 0x0470)
#define HBG_REG_TX_CFF_ADDR_0_ADDR		(HBG_REG_SGMII_BASE + 0x0488)
#define HBG_REG_TX_CFF_ADDR_1_ADDR		(HBG_REG_SGMII_BASE + 0x048C)
#define HBG_REG_TX_CFF_ADDR_2_ADDR		(HBG_REG_SGMII_BASE + 0x0490)
#define HBG_REG_TX_CFF_ADDR_3_ADDR		(HBG_REG_SGMII_BASE + 0x0494)
#define HBG_REG_RX_CFF_ADDR_ADDR		(HBG_REG_SGMII_BASE + 0x04A0)
#define HBG_REG_BRUST_LENGTH_ADDR		(HBG_REG_SGMII_BASE + 0x04C4)
#define HBG_REG_BRUST_LENGTH_B			BIT(29)
#define HBG_REG_RX_BUF_SIZE_ADDR		(HBG_REG_SGMII_BASE + 0x04E4)
#define HBG_REG_RX_BUF_SIZE_M			GENMASK(15, 0)
#define HBG_REG_BUS_CTRL_ADDR			(HBG_REG_SGMII_BASE + 0x04E8)
#define HBG_REG_BUS_CTRL_ENDIAN_M		GENMASK(2, 1)
#define HBG_REG_RX_CTRL_ADDR			(HBG_REG_SGMII_BASE + 0x04F0)
#define HBG_REG_RX_CTRL_RXBUF_1ST_SKIP_SIZE_M	GENMASK(31, 28)
#define HBG_REG_RX_CTRL_TIME_INF_EN_B		BIT(23)
#define HBG_REG_RX_CTRL_RX_ALIGN_NUM_M		GENMASK(18, 17)
#define HBG_REG_RX_CTRL_PORT_NUM		GENMASK(16, 13)
#define HBG_REG_RX_CTRL_RX_GET_ADDR_MODE_B	BIT(12)
#define HBG_REG_RX_CTRL_RXBUF_1ST_SKIP_SIZE2_M	GENMASK(3, 0)
#define HBG_REG_RX_PKT_MODE_ADDR		(HBG_REG_SGMII_BASE + 0x04F4)
#define HBG_REG_RX_PKT_MODE_PARSE_MODE_M	GENMASK(22, 21)
#define HBG_REG_RX_BUFRQ_ERR_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x058C)
#define HBG_REG_TX_BUFRL_ERR_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x0590)
#define HBG_REG_RX_WE_ERR_CNT_ADDR		(HBG_REG_SGMII_BASE + 0x0594)
#define HBG_REG_DBG_ST0_ADDR			(HBG_REG_SGMII_BASE + 0x05E4)
#define HBG_REG_DBG_ST1_ADDR			(HBG_REG_SGMII_BASE + 0x05E8)
#define HBG_REG_DBG_ST2_ADDR			(HBG_REG_SGMII_BASE + 0x05EC)
#define HBG_REG_BUS_RST_EN_ADDR			(HBG_REG_SGMII_BASE + 0x0688)
#define HBG_REG_CF_IND_TXINT_MSK_ADDR		(HBG_REG_SGMII_BASE + 0x0694)
#define HBG_REG_IND_INTR_MASK_B			BIT(0)
#define HBG_REG_CF_IND_TXINT_STAT_ADDR		(HBG_REG_SGMII_BASE + 0x0698)
#define HBG_REG_CF_IND_TXINT_CLR_ADDR		(HBG_REG_SGMII_BASE + 0x069C)
#define HBG_REG_CF_IND_RXINT_MSK_ADDR		(HBG_REG_SGMII_BASE + 0x06a0)
#define HBG_REG_CF_IND_RXINT_STAT_ADDR		(HBG_REG_SGMII_BASE + 0x06a4)
#define HBG_REG_CF_IND_RXINT_CLR_ADDR		(HBG_REG_SGMII_BASE + 0x06a8)

enum hbg_port_mode {
	/* 0x0 ~ 0x5 are reserved */
	HBG_PORT_MODE_SGMII_10M = 0x6,
	HBG_PORT_MODE_SGMII_100M = 0x7,
	HBG_PORT_MODE_SGMII_1000M = 0x8,
};

struct hbg_tx_desc {
	u32 word0;
	u32 word1;
	u32 word2; /* pkt_addr */
	u32 word3; /* clear_addr */
};

#define HBG_TX_DESC_W0_IP_OFF_M		GENMASK(30, 26)
#define HBG_TX_DESC_W0_l3_CS_B		BIT(2)
#define HBG_TX_DESC_W0_WB_B		BIT(1)
#define HBG_TX_DESC_W0_l4_CS_B		BIT(0)
#define HBG_TX_DESC_W1_SEND_LEN_M	GENMASK(19, 4)

struct hbg_rx_desc {
	u32 word0;
	u32 word1; /* tag */
	u32 word2;
	u32 word3;
	u32 word4;
	u32 word5;
};

#define HBG_RX_DESC_W2_PKT_LEN_M	GENMASK(31, 16)
#define HBG_RX_DESC_W2_PORT_NUM_M	GENMASK(15, 12)
#define HBG_RX_DESC_W4_IP_TCP_UDP_M	GENMASK(31, 30)
#define HBG_RX_DESC_W4_IPSEC_B		BIT(29)
#define HBG_RX_DESC_W4_IP_VERSION_B	BIT(28)
#define HBG_RX_DESC_W4_L4_ERR_CODE_M	GENMASK(26, 23)
#define HBG_RX_DESC_W4_FRAG_B		BIT(22)
#define HBG_RX_DESC_W4_OPT_B		BIT(21)
#define HBG_RX_DESC_W4_IP_VERSION_ERR_B	BIT(20)
#define HBG_RX_DESC_W4_BRD_CST_B	BIT(19)
#define HBG_RX_DESC_W4_MUL_CST_B	BIT(18)
#define HBG_RX_DESC_W4_ARP_B		BIT(17)
#define HBG_RX_DESC_W4_RARP_B		BIT(16)
#define HBG_RX_DESC_W4_ICMP_B		BIT(15)
#define HBG_RX_DESC_W4_VLAN_FLAG_B	BIT(14)
#define HBG_RX_DESC_W4_DROP_B		BIT(13)
#define HBG_RX_DESC_W4_L3_ERR_CODE_M	GENMASK(12, 9)
#define HBG_RX_DESC_W4_L2_ERR_B		BIT(8)
#define HBG_RX_DESC_W4_IDX_MATCH_B	BIT(7)

enum hbg_l3_err_code {
	HBG_L3_OK = 0,
	HBG_L3_WRONG_HEAD,
	HBG_L3_CSUM_ERR,
	HBG_L3_LEN_ERR,
	HBG_L3_ZERO_TTL,
	HBG_L3_RSVD,
};

enum hbg_l4_err_code {
	HBG_L4_OK = 0,
	HBG_L4_WRONG_HEAD,
	HBG_L4_LEN_ERR,
	HBG_L4_CSUM_ERR,
	HBG_L4_ZERO_PORT_NUM,
	HBG_L4_RSVD,
};

enum hbg_pkt_type_code {
	HBG_NO_IP_PKT = 0,
	HBG_IP_PKT,
	HBG_TCP_PKT,
	HBG_UDP_PKT,
};

#endif
