#include <stdio.h>
#include <sys/audit.h>
#include <errno.h>

main()
{
    int count;
    aud_rec_t rec;
    aud_hdr_t header, oheader;
    aud_evinfo_t event;
    aud_obj_t object;
    aud_info_t info_data;
    const char *text;

    /* obtain a blank audit record */
    rec = aud_init_record();
    printf("obtained an audit record: %p\n", rec);

    /* add a header */
    /*  count the number of headers already known */
    count = aud_get_hdr(rec, 1, NULL);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("There are currently %d headers in this audit record\n", count);

    /*  obtain a header */
    if (aud_put_hdr(rec, NULL, &header) == -1) {
	perror("obtaining a new record header");
	exit(1);
    }
    printf("New record header %p\n", header);
    header = NULL;
    count = aud_get_hdr(rec, 1, &header);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("There is currently %d header (%p) in this audit record\n",
	   count, header);

    /* add another header */
    if (aud_put_hdr(rec, NULL, &header) == -1) {
	perror("obtaining a new record header");
	exit(1);
    }
    printf("New record header %p\n", header);
    count = aud_get_hdr(rec, 2, &header);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    count = aud_get_hdr(rec, 3, &header);
    if (count == -1) {
	perror("failed to obtain 3rd header -> as expected");
    } else {
	fprintf(stderr, "attempt to get 3rd header should have failed\n");
	exit(1);
    }

    /* add another header */
    if (aud_put_hdr(rec, NULL, &header) == -1) {
	perror("obtaining a new record header");
	exit(1);
    }
    printf("New record header %p\n", header);
    count = aud_get_hdr(rec, 1, NULL);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("There are currently %d headers in this audit record\n", count);

    /* add an event */
    count = aud_get_event(rec, 1, NULL);
    if (count == -1) {
	perror("obtaining a record event count");
	exit(1);
    }
    printf("There are currently %d events in this audit record\n", count);

    if (aud_put_event(rec, NULL, &event) == -1) {
	perror("obtaining a new event");
	exit(1);
    }
    printf("New record event %p\n", event);
    event = NULL;
    count = aud_get_event(rec, 1, &event);
    if (count == -1) {
	perror("obtaining a record event count");
	exit(1);
    }
    printf("There is currently %d event (%p) in this audit record\n",
	   count, event);

    /* add an object */
    count = aud_get_obj(rec, 1, NULL);
    if (count == -1) {
	perror("obtaining a record object count");
	exit(1);
    }
    printf("There are currently %d objects in this audit record\n", count);

    if (aud_put_obj(rec, NULL, &object) == -1) {
	perror("obtaining object count");
	exit(1);
    }
    printf("New record object %p\n", object);
    object = NULL;
    count = aud_get_obj(rec, 1, &object);
    if (count == -1) {
	perror("obtaining a record object count");
	exit(1);
    }
    printf("There is currently %d object (%p) in this audit record\n",
	   count, object);

    /* add another event */
    count = aud_get_event(rec, 1, NULL);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("There are currently %d events in this audit record\n", count);

    if (aud_put_event(rec, NULL, &event) == -1) {
	perror("obtaining a new event header");
	exit(1);
    }
    printf("New record event %p\n", event);
    event = NULL;
    count = aud_get_event(rec, 2, &event);
    if (count == -1) {
	perror("obtaining a record event count");
	exit(1);
    }
    printf("There are currently %d events (%p) in this audit record\n",
	   count, event);

    /* add another object */
    count = aud_get_obj(rec, 1, NULL);
    if (count == -1) {
	perror("obtaining a record object count");
	exit(1);
    }
    printf("There are currently %d objects in this audit record\n", count);

    if (aud_put_obj(rec, NULL, &object) == -1) {
	perror("obtaining object count");
	exit(1);
    }
    printf("New record object %p\n", object);
    object = NULL;
    count = aud_get_obj(rec, 2, &object);
    if (count == -1) {
	perror("obtaining a record object count");
	exit(1);
    }
    printf("There are currently %d objects (%p) in this audit record\n",
	   count, object);

    /* add another header */
    oheader = header;
    if (aud_put_hdr(rec, &oheader, &header) == -1) {
	perror("obtaining a new record header");
	exit(1);
    }
    printf("New record header %p\n", header);
    count = aud_get_hdr(rec, 3, NULL);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("There are currently %d headers (%p) in this audit record\n",
	   count, header);
    count = aud_get_hdr(rec, 4, &header);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("The %dth being (%p)\n", count, header);

    /* print audit record */
    text = aud_rec_to_text(rec, &count);
    fprintf(stderr, "audit record(length=%d):\n%s", count, text);
    if (aud_free(text) == -1) {
	perror("trouble freeing text");
	exit(1);
    }

    /* delete header */
    count = aud_get_hdr(rec, 3, &header);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("deleting 3rd header\n");
    count = aud_delete_hdr(header);
    if (count == -1) {
	perror("trouble deleting header");
	exit(1);
    }
    count = aud_get_hdr(rec, 3, &header);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("there are %d headers (%p) now\n", count, header);

    count = aud_get_hdr(rec, 1, &header);
    if (count == -1) {
	perror("obtaining a record header count");
	exit(1);
    }
    printf("there are %d headers (first is %p)\n", count, header);

    text = aud_rec_to_text(rec, &count);
    fprintf(stderr, "audit record(length=%d):\n%s", count, text);
    if (aud_free(text) == -1) {
	perror("trouble freeing text");
	exit(1);
    }

    /* add some information to the header */
    {
	static char evnt[] = "AET_taudit";

	info_data.aud_info_type = AUD_TYPE_STRING;
	info_data.aud_info_length = sizeof(evnt);
	info_data.aud_info_p = evnt;

	count = aud_put_hdr_info(header, AUD_LAST_ITEM, AUD_EVENT_TYPE_ID,
				 &info_data);
	if (count == -1) {
	    perror("failed to add a info member to header");
	    exit(1);
	}
    }

    text = aud_rec_to_text(rec, &count);
    fprintf(stderr, "audit record(length=%d):\n%s", count, text);
    if (aud_free(text) == -1) {
	perror("trouble freeing text");
	exit(1);
    }

    /* add some more information to the header */
    {
	aud_status_t evnt = AUD_PRIV_USED;

	info_data.aud_info_type = AUD_TYPE_AUD_STATUS;
	info_data.aud_info_length = sizeof(evnt);
	info_data.aud_info_p = &evnt;

	count = aud_put_hdr_info(header, AUD_LAST_ITEM, AUD_STATUS_ID,
				 &info_data);
	if (count == -1) {
	    perror("failed to add a info member to header");
	    exit(1);
	}
    }
    /* print audit record */
    text = aud_rec_to_text(rec, &count);
    fprintf(stderr, "audit record(length=%d):\n%s", count, text);
    if (aud_free(text) == -1) {
	perror("trouble freeing text");
	exit(1);
    }

    /* delete object */
    
    /* delete record */
    if (aud_free(rec) == -1) {
	perror("deleting record");
	exit(1);
    }

    /* make an attempt to re-delete this object.  This should fail */

    printf("deleted record\n");
    if (aud_free(rec) != -1) {
	printf("second attempt to delete record succeeded\n");
	exit(1);
    }
    perror("failed to delete record on second attempt - good!");
    exit(0);
}
