# spin.rb --
#
# This demonstration script creates several spinbox widgets.
#
# based on Tcl/Tk8.4.4 widget demos

if defined?($spin_demo) && $spin_demo
  $spin_demo.destroy 
  $spin_demo = nil
end

$spin_demo = TkToplevel.new {|w|
  title("Spinbox Demonstration")
  iconname("spin")
  positionWindow(w)
}

TkLabel.new($spin_demo, 
            :font=>$font, :wraplength=>'5i', :justify=>:left, 
            :text=><<EOL).pack(:side=>:top)
ˤϣΥԥܥåɽƤޤ\
줾졢ޥ򤷤ʸϤ뤳ȤǤޤ
ԽȤƤϡEmacs ¿˲äơŪ
Motif ΥݡȤƤޤȤС
Backspace  Control-h Ȥϥκ¦ʸ
Delete  Control-d Ȥϱ¦ʸޤ
ȤĹۤ褦ĹʸϤˤϡ
ޥΥܥ󣲤򲡤ƥɥå뤳Ȥǡʸ
򥹥󤹤뤳ȤǽǤ
ʤǽΥԥܥåϡͤȤߤʤ褦
ʸ󤷤ϤʤȤդƤޤ
ܤΥԥܥå˸Τϥȥ
ꥢԻ̾ΥꥹȤȤʤäƤޤ
⤷ʤȤäƤ Ruby ˥󥯤Ƥ Tk 饤
֥꤬ spinbox åȤƤʤ硢
ǥϤޤưʤϤǤξˤ spinbox 
åȤƤ褦ʤ꿷С Tk 
Ȥ߹碌ƻ褦ˤƤ
EOL

TkFrame.new($spin_demo){|f|
  pack(:side=>:bottom, :fill=>:x, :pady=>'2m')

  TkButton.new(f, :text=>'Ĥ', :width=>15, :command=>proc{
                 $spin_demo.destroy
                 $spin_demo = nil
               }).pack(:side=>:left, :expand=>true)

  TkButton.new(f, :text=>'ɻ', :width=>15, :command=>proc{
                 showCode 'spin'
               }).pack(:side=>:left, :expand=>true)
}

australianCities = [
    'Canberra', 'Sydney', 'Melbourne', 'Perth', 'Adelaide', 
    'Brisbane', 'Hobart', 'Darwin', 'Alice Springs'
]

[
  TkSpinbox.new($spin_demo, :from=>1, :to=>10, :width=>10, :validate=>:key, 
                :validatecommand=>[
                  proc{|s| s == '' || /^[+-]?\d+$/ =~ s }, '%P'
                ]), 
  TkSpinbox.new($spin_demo, :from=>0, :to=>3, :increment=>0.5, 
                :format=>'%05.2f', :width=>10), 
  TkSpinbox.new($spin_demo, :values=>australianCities, :width=>10)
].each{|sbox| sbox.pack(:side=>:top, :pady=>5, :padx=>10)}
