
#line 3 "<stdout>"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE configYYrestart(configYYin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int configYYleng;

extern FILE *configYYin, *configYYout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up configYYtext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up configYYtext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via configYYrestart()), so that the user can continue scanning by
	 * just pointing configYYin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when configYYtext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int configYYleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow configYYwrap()'s to do buffer switches
 * instead of setting up a fresh configYYin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void configYYrestart (FILE *input_file  );
void configYY_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE configYY_create_buffer (FILE *file,int size  );
void configYY_delete_buffer (YY_BUFFER_STATE b  );
void configYY_flush_buffer (YY_BUFFER_STATE b  );
void configYYpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void configYYpop_buffer_state (void );

static void configYYensure_buffer_stack (void );
static void configYY_load_buffer_state (void );
static void configYY_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER configYY_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE configYY_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE configYY_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE configYY_scan_bytes (yyconst char *bytes,int len  );

void *configYYalloc (yy_size_t  );
void *configYYrealloc (void *,yy_size_t  );
void configYYfree (void *  );

#define yy_new_buffer configYY_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        configYYensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            configYY_create_buffer(configYYin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        configYYensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            configYY_create_buffer(configYYin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define configYYwrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *configYYin = (FILE *) 0, *configYYout = (FILE *) 0;

typedef int yy_state_type;

extern int configYYlineno;

int configYYlineno = 1;

extern char *configYYtext;
#define yytext_ptr configYYtext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up configYYtext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	configYYleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 24
#define YY_END_OF_BUFFER 25
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[100] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       25,   22,   23,   22,   22,    2,    8,   22,    8,   19,
       22,    9,   13,   12,    2,   12,   12,   17,   18,   11,
       10,   18,   18,   16,   14,   14,   16,   16,    7,   22,
        7,    7,    0,   21,    0,    8,    0,    0,    0,    8,
        3,    0,   20,   12,   12,   17,   18,   11,   18,   15,
        7,    0,    7,    0,    0,    4,   12,   18,    7,    7,
        1,    0,    1,    1,    1,    0,    0,    0,    0,    0,
        6,    0,    0,    0,    0,    0,    0,    5,    0

    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    6,    1,    1,    1,    1,    1,
        1,    1,    7,    1,    1,    1,    1,    8,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    1,    1,    1,
       10,    1,    1,   11,   12,   13,   14,   15,   16,   13,
       13,   17,   18,   13,   13,   19,   13,   20,   13,   21,
       13,   13,   13,   22,   23,   13,   13,   13,   13,   13,
        1,   24,    1,    1,   25,    1,   13,   13,   13,   26,

       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   27,
       13,   13,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[29] =
    {   0,
        1,    2,    3,    4,    3,    5,    6,    7,    7,    6,
        1,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    1,    7,    8,    8,    1
    } ;

static yyconst flex_int16_t yy_base[112] =
    {   0,
        0,    1,   29,    0,   55,   56,   82,  108,  135,  162,
      190,    0,  217,  244,   58,   65,   66,   68,  271,  298,
      145,  408,  408,    3,  117,  408,    0,  125,    6,  408,
        7,  408,  408,    0,    0,   15,  115,    0,    0,  133,
      408,   18,  107,  408,  408,  408,   62,  106,    0,    0,
       70,  104,   73,  408,  122,    0,  109,   93,  118,   95,
      408,  105,  408,    0,  118,    0,    0,  123,  116,  408,
        0,  117,  113,   94,  105,  408,   92,   91,  408,   90,
      408,   82,    0,    0,    0,   75,   66,   62,  102,   13,
      408,   41,   48,    5,    9,   89,  113,  408,  408,  326,

      334,  342,  350,  358,  360,  367,  375,    4,  383,  391,
      399
    } ;

static yyconst flex_int16_t yy_def[112] =
    {   0,
      100,  100,   99,    3,  100,  100,  100,  100,  101,  101,
       99,   11,  102,  102,  103,  103,  100,  100,  104,  104,
       99,   99,   99,   99,   99,   99,  105,   99,  106,   99,
       99,   99,   99,  107,  107,  107,  107,  108,  109,   99,
       99,  109,  109,   99,   99,   99,   99,   99,  110,  111,
      110,  110,   99,   99,   99,  105,   99,   99,   99,  106,
       99,   99,   99,  107,  107,  108,  109,   99,  109,   99,
      110,  111,  110,   99,   99,   99,  107,  109,   99,  110,
       99,   99,  107,  109,  110,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,    0,   99,

       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99
    } ;

static yyconst flex_int16_t yy_nxt[437] =
    {   0,
       99,   99,   23,   23,   53,   54,   53,   58,   62,   63,
       62,   66,   59,   99,   90,   61,   53,   54,   53,   53,
       54,   53,   91,   24,   24,   96,   95,   25,   25,   22,
       22,   23,   22,   22,   26,   22,   27,   27,   22,   28,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   24,   29,   29,   29,   25,   30,   30,   94,
       45,   93,   46,   53,   54,   53,   70,   45,   23,   46,
       23,   53,   54,   53,   53,   54,   53,   89,   31,   31,
       88,   47,   25,   25,   32,   48,   33,   26,   47,   24,
       97,   24,   48,   25,   58,   25,   58,   87,   98,   59,

       86,   59,   61,   90,   61,   24,   62,   63,   62,   25,
       32,   91,   33,   26,   97,   85,   84,   83,   82,   81,
       80,   79,   98,   78,   68,   77,   92,   76,   75,   74,
       73,   24,   55,   69,   68,   25,   22,   32,   22,   33,
       35,   65,   57,   55,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   36,   99,
       99,   99,   37,   22,   32,   22,   33,   35,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   36,   99,   99,   99,   37,
       22,   22,   32,   22,   22,   26,   22,   22,   22,   22,

       22,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   24,   22,   38,   38,   25,   40,   41,
       22,   33,   26,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       42,   99,   99,   99,   43,   40,   41,   22,   33,   26,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   42,   99,   99,
       99,   43,   22,   23,   22,   50,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   51,   99,   99,   99,   52,   22,

       23,   22,   50,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   51,   99,   99,   99,   52,   22,   22,   22,   22,
       22,   22,   22,   22,   34,   34,   34,   34,   34,   34,
       34,   34,   39,   39,   39,   39,   39,   39,   39,   39,
       44,   44,   44,   44,   44,   44,   44,   44,   49,   49,
       49,   49,   49,   49,   49,   49,   56,   56,   60,   99,
       99,   99,   60,   60,   60,   64,   99,   99,   99,   64,
       64,   64,   64,   67,   99,   99,   99,   99,   67,   67,
       67,   71,   99,   99,   99,   71,   71,   71,   71,   72,

       72,   99,   72,   72,   72,   72,   72,   21,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99
    } ;

static yyconst flex_int16_t yy_chk[437] =
    {   0,
        0,    0,    1,    2,   24,   24,   24,   29,   31,   31,
       31,  108,   29,    0,   90,   29,   36,   36,   36,   42,
       42,   42,   90,    1,    2,   95,   94,    1,    2,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    5,    6,   93,
       15,   92,   15,   47,   47,   47,   47,   16,   17,   16,
       18,   51,   51,   51,   53,   53,   53,   88,    5,    6,
       87,   15,    5,    6,    7,   15,    7,    7,   16,   17,
       96,   18,   16,   17,   58,   18,   60,   86,   96,   58,

       82,   60,   58,   89,   60,    7,   62,   62,   62,    7,
        8,   89,    8,    8,   97,   80,   78,   77,   75,   74,
       73,   72,   97,   69,   68,   65,   89,   59,   57,   55,
       52,    8,   48,   43,   40,    8,    9,    9,    9,    9,
        9,   37,   28,   25,   21,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    9,    0,
        0,    0,    9,   10,   10,   10,   10,   10,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   10,    0,    0,    0,   10,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,

       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   13,   13,
       13,   13,   13,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       13,    0,    0,    0,   13,   14,   14,   14,   14,   14,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   14,    0,    0,
        0,   14,   19,   19,   19,   19,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   19,    0,    0,    0,   19,   20,

       20,   20,   20,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   20,    0,    0,    0,   20,  100,  100,  100,  100,
      100,  100,  100,  100,  101,  101,  101,  101,  101,  101,
      101,  101,  102,  102,  102,  102,  102,  102,  102,  102,
      103,  103,  103,  103,  103,  103,  103,  103,  104,  104,
      104,  104,  104,  104,  104,  104,  105,  105,  106,    0,
        0,    0,  106,  106,  106,  107,    0,    0,    0,  107,
      107,  107,  107,  109,    0,    0,    0,    0,  109,  109,
      109,  110,    0,    0,    0,  110,  110,  110,  110,  111,

      111,    0,  111,  111,  111,  111,  111,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int configYY_flex_debug;
int configYY_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *configYYtext;
#line 1 "config.l"
/******************************************************************************
 *
 * $Id: config_templ.l,v 1.8 2001/01/01 10:15:16 root Exp $
 *
 * Copyright (C) 1997-2006 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 */
#line 16 "config.l"

/*
 *	includes
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <ctype.h>
#include <stdarg.h>

#include <qfileinfo.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qstack.h>
  
#include "config.h"
#include "version.h"

#include "lang_cfg.h"

#undef Config_getString
#undef Config_getInt
#undef Config_getList
#undef Config_getEnum
#undef Config_getBool

// use in-class definitions
#define Config_getString(val)  getString(__FILE__,__LINE__,val)
#define Config_getInt(val)     getInt(__FILE__,__LINE__,val)
#define Config_getList(val)    getList(__FILE__,__LINE__,val)
#define Config_getEnum(val)    getEnum(__FILE__,__LINE__,val)
#define Config_getBool(val)    getBool(__FILE__,__LINE__,val)
  
void config_err(const char *fmt, ...)
{
  va_list args;
  va_start(args, fmt);
  vfprintf(stderr, fmt, args);
  va_end(args); 
}
void config_warn(const char *fmt, ...)
{
  va_list args;
  va_start(args, fmt);
  vfprintf(stderr, fmt, args);
  va_end(args);
}

#define MAX_INCLUDE_DEPTH 10
#define YY_NEVER_INTERACTIVE 1

/* -----------------------------------------------------------------
 */

QCString ConfigOption::convertToComment(const QCString &s)
{
  QCString result;
  if (s.isEmpty()) return result;
  else
  {
    result+="# ";
    QCString tmp=s.stripWhiteSpace();
    char *p=tmp.data();
    char c;
    while ((c=*p++))
    {
      if (c=='\n') result+="\n# ";
      else result+=c;
    }
    result+='\n';
  }
  return result;
}

void ConfigOption::writeBoolValue(QTextStream &t,bool v)
{
  if (v) t << "YES"; else t << "NO";
}

void ConfigOption::writeIntValue(QTextStream &t,int i)
{
  t << i;
}

void ConfigOption::writeStringValue(QTextStream &t,QCString &s)
{
  const char *p=s.data();
  char c;
  bool needsEscaping=FALSE;
  if (p)
  {
    while ((c=*p++)!=0 && !needsEscaping) 
      needsEscaping = (c==' ' || c=='\n' || c=='\t' || c=='"');
    if (needsEscaping)
    { 
      t << "\"";
      p=s.data();
      while (*p)
      {
	if (*p=='"') t << "\\"; // escape quotes
	t << *p++;
      }
      t << "\"";
    }
    else
    {
      t << s;
    }
  }
}

void ConfigOption::writeStringList(QTextStream &t,QStrList &l)
{
  const char *p = l.first();
  bool first=TRUE;
  while (p)
  {
    QCString s=p;
    if (!first) t << "                         ";
    first=FALSE;
    writeStringValue(t,s);
    p = l.next();
    if (p) t << " \\" << endl;
  }
}

/* -----------------------------------------------------------------
 */

Config *Config::m_instance = 0;

void ConfigInt::convertStrToVal() 
{
  if (!m_valueString.isEmpty())
  {
    bool ok;
    int val = m_valueString.toInt(&ok);
    if (!ok || val<m_minVal || val>m_maxVal)
    {
      config_warn("Warning: argument `%s' for option %s is not a valid number in the range [%d..%d]!\n"
                "Using the default: %d!\n",m_valueString.data(),m_name.data(),m_minVal,m_maxVal,m_value);
    }
    m_value=val;
  }
}

void ConfigBool::convertStrToVal()
{
  QCString val = m_valueString.stripWhiteSpace().lower();
  if (!val.isEmpty())
  {
    if (val=="yes" || val=="true" || val=="1") 
    {
      m_value=TRUE;
    }
    else if (val=="no" || val=="false" || val=="0")
    {
      m_value=FALSE;
    }
    else
    {
      config_warn("Warning: argument `%s' for option %s is not a valid boolean value\n"
                "Using the default: %s!\n",m_valueString.data(),m_name.data(),m_value?"YES":"NO");
    }
  }
}

QCString &Config::getString(const char *fileName,int num,const char *name) const
{
  ConfigOption *opt = m_dict->find(name);
  if (opt==0) 
  {
    config_err("%s<%d>: Internal error: Requested unknown option %s!\n",fileName,num,name);
    exit(1);
  }
  else if (opt->kind()!=ConfigOption::O_String)
  {
    config_err("%s<%d>: Internal error: Requested option %s not of string type!\n",fileName,num,name);
    exit(1);
  }
  return *((ConfigString *)opt)->valueRef();
}

QStrList &Config::getList(const char *fileName,int num,const char *name) const
{
  ConfigOption *opt = m_dict->find(name);
  if (opt==0) 
  {
    config_err("%s<%d>: Internal error: Requested unknown option %s!\n",fileName,num,name);
    exit(1);
  }
  else if (opt->kind()!=ConfigOption::O_List)
  {
    config_err("%d<%d>: Internal error: Requested option %s not of list type!\n",fileName,num,name);
    exit(1);
  }
  return *((ConfigList *)opt)->valueRef();
}

QCString &Config::getEnum(const char *fileName,int num,const char *name) const
{
  ConfigOption *opt = m_dict->find(name);
  if (opt==0) 
  {
    config_err("%s<%d>: Internal error: Requested unknown option %s!\n",fileName,num,name);
    exit(1);
  }
  else if (opt->kind()!=ConfigOption::O_Enum)
  {
    config_err("%s<%d>: Internal error: Requested option %s not of enum type!\n",fileName,num,name);
    exit(1);
  }
  return *((ConfigEnum *)opt)->valueRef();
}

int &Config::getInt(const char *fileName,int num,const char *name) const
{
  ConfigOption *opt = m_dict->find(name);
  if (opt==0) 
  {
    config_err("%s<%d>: Internal error: Requested unknown option %s!\n",fileName,num,name);
    exit(1);
  }
  else if (opt->kind()!=ConfigOption::O_Int)
  {
    config_err("%s<%d>: Internal error: Requested option %s not of integer type!\n",fileName,num,name);
    exit(1);
  }
  return *((ConfigInt *)opt)->valueRef();
}

bool &Config::getBool(const char *fileName,int num,const char *name) const
{
  ConfigOption *opt = m_dict->find(name);
  if (opt==0) 
  {
    config_err("%s<%d>: Internal error: Requested unknown option %s!\n",fileName,num,name);
    exit(1);
  }
  else if (opt->kind()!=ConfigOption::O_Bool)
  {
    config_err("%s<%d>: Internal error: Requested option %s not of integer type!\n",fileName,num,name);
    exit(1);
  }
  return *((ConfigBool *)opt)->valueRef();
}

/* -----------------------------------------------------------------
 *
 *	static variables
 */

struct ConfigFileState
{
  int lineNr;
  FILE *filePtr;
  YY_BUFFER_STATE oldState;
  YY_BUFFER_STATE newState;
  QCString fileName;
};  

static const char       *inputString;
static int	         inputPosition;
static int               yyLineNr;
static QCString          yyFileName;
static QCString          tmpString;
static QCString         *s=0;
static bool             *b=0;
static QStrList         *l=0;
static int               lastState;
static QCString          elemStr;
static QCString          includeName;
static QStrList          includePathList;
static QStack<ConfigFileState> includeStack;  
static int               includeDepth;

static QCString     tabSizeString;
static QCString     maxInitLinesString;
static QCString     colsInAlphaIndexString;
static QCString     enumValuesPerLineString;
static QCString     treeViewWidthString;
static QCString     maxDotGraphWidthString;
static QCString     maxDotGraphHeightString;

static Config      *config;

/* -----------------------------------------------------------------
 */
#undef	YY_INPUT
#define	YY_INPUT(buf,result,max_size) result=yyread(buf,max_size);

static int yyread(char *buf,int max_size)
{
    // no file included
    if (includeStack.isEmpty()) 
    {
        int c=0;
	if (inputString==0) return c;
	while( c < max_size && inputString[inputPosition] )
	{
	      *buf = inputString[inputPosition++] ;
	      c++; buf++;
  	}
	return c;
    } 
    else 
    {
        //assert(includeStack.current()->newState==YY_CURRENT_BUFFER);
	return fread(buf,1,max_size,includeStack.current()->filePtr);
    }
}


static FILE *tryPath(const char *path,const char *fileName)
{
  QCString absName=(QCString)path+"/"+fileName;
  QFileInfo fi(absName);
  if (fi.exists() && fi.isFile())
  {
    FILE *f=fopen(absName,"r");
    if (!f) config_err("Error: could not open file %s for reading\n",absName.data());
    return f;
  }
  return 0;
}

static void substEnvVarsInStrList(QStrList &sl);
static void substEnvVarsInString(QCString &s);

static FILE *findFile(const char *fileName)
{
  substEnvVarsInStrList(includePathList);
  char *s=includePathList.first();
  while (s) // try each of the include paths
  {
    FILE *f = tryPath(s,fileName);
    if (f) return f;
    s=includePathList.next();
  } 
  // try cwd if includePathList fails
  return tryPath(".",fileName);
}

static void readIncludeFile(const char *incName)
{
  if (includeDepth==MAX_INCLUDE_DEPTH) {
    config_err("Error: maximum include depth (%d) reached, %s is not included. Aborting...\n",
	MAX_INCLUDE_DEPTH,incName);
    exit(1);
  } 

  QCString inc = incName;
  substEnvVarsInString(inc);
  inc = inc.stripWhiteSpace();
  uint incLen = inc.length();
  if (inc.at(0)=='"' && inc.at(incLen-1)=='"') // strip quotes
  {
    inc=inc.mid(1,incLen-2);
  }

  FILE *f;

  //printf("Searching for `%s'\n",incFileName.data());
  if ((f=findFile(inc))) // see if the include file can be found
  {
    // For debugging
#if SHOW_INCLUDES
    for (i=0;i<includeStack.count();i++) msg("  ");
    msg("@INCLUDE = %s: parsing...\n",inc.data());
#endif

    // store the state of the old file 
    ConfigFileState *fs=new ConfigFileState;
    fs->oldState=YY_CURRENT_BUFFER;
    fs->lineNr=yyLineNr;
    fs->fileName=yyFileName;
    fs->filePtr=f;
    // push the state on the stack
    includeStack.push(fs);
    // set the scanner to the include file
    configYY_switch_to_buffer(configYY_create_buffer(f,YY_BUF_SIZE));
    fs->newState=YY_CURRENT_BUFFER;
    yyFileName=inc;
    includeDepth++;
  } 
  else
  {
    config_err("Error: @INCLUDE = %s: not found!\n",inc.data());
    exit(1);
  }
}











#line 1003 "<stdout>"

#define INITIAL 0
#define Start 1
#define SkipComment 2
#define SkipInvalid 3
#define GetString 4
#define GetBool 5
#define GetStrList 6
#define GetQuotedString 7
#define GetEnvVar 8
#define Include 9

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int configYYwrap (void );
#else
extern int configYYwrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( configYYtext, configYYleng, 1, configYYout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( configYYin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( configYYin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, configYYin))==0 && ferror(configYYin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(configYYin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int configYYlex (void);

#define YY_DECL int configYYlex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after configYYtext and configYYleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 425 "config.l"


#line 1166 "<stdout>"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! configYYin )
			configYYin = stdin;

		if ( ! configYYout )
			configYYout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			configYYensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				configYY_create_buffer(configYYin,YY_BUF_SIZE );
		}

		configYY_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of configYYtext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 100 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 408 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 427 "config.l"

	YY_BREAK
case 2:
YY_RULE_SETUP
#line 428 "config.l"
{ BEGIN(SkipComment); }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 429 "config.l"
{ QCString cmd=configYYtext;
                                           cmd=cmd.left(cmd.length()-1).stripWhiteSpace(); 
					   ConfigOption *option = config->get(cmd);
					   if (option==0) // oops not known
					   {
					     config_err("Warning: ignoring unsupported tag `%s' at line %d, file %s\n",
						 configYYtext,yyLineNr,yyFileName.data()); 
					     BEGIN(SkipInvalid);
					   }
					   else // known tag
					   {
					     switch(option->kind())
					     {
					       case ConfigOption::O_Info:
						 // shouldn't get here!
					         BEGIN(SkipInvalid);
						 break;
					       case ConfigOption::O_List:
						 l = ((ConfigList *)option)->valueRef();
					         l->clear();
						 elemStr="";
					         BEGIN(GetStrList);
					         break;
					       case ConfigOption::O_Enum:
						 s = ((ConfigEnum *)option)->valueRef();
					         s->resize(0);
					         BEGIN(GetString);
					         break;
					       case ConfigOption::O_String:
						 s = ((ConfigString *)option)->valueRef();
					         s->resize(0);
					         BEGIN(GetString);
					         break;
					       case ConfigOption::O_Int:
						 s = ((ConfigInt *)option)->valueStringRef();
					         s->resize(0);
					         BEGIN(GetString);
					         break;
					       case ConfigOption::O_Bool:
						 s = ((ConfigBool *)option)->valueStringRef();
					         s->resize(0);
					         BEGIN(GetString);
						 break;
					       case ConfigOption::O_Obsolete:
					         config_err("Warning: Tag `%s' at line %d of file %s has become obsolete.\n"
						            "To avoid this warning please update your configuration "
							    "file using \"doxygen -u\"\n", cmd.data(),yyLineNr,yyFileName.data()); 
					         BEGIN(SkipInvalid);
						 break;
					     }
					   }
					}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 481 "config.l"
{ QCString cmd=configYYtext;
                                          cmd=cmd.left(cmd.length()-2).stripWhiteSpace(); 
					  ConfigOption *option = config->get(cmd);
					  if (option==0) // oops not known
					  {
					    config_err("Warning: ignoring unsupported tag `%s' at line %d, file %s\n",
						configYYtext,yyLineNr,yyFileName.data()); 
					    BEGIN(SkipInvalid);
					  }
					  else // known tag
					  {
					    switch(option->kind())
					    {
					      case ConfigOption::O_Info:
					        // shouldn't get here!
					        BEGIN(SkipInvalid);
						break;
					      case ConfigOption::O_List:
					        l = ((ConfigList *)option)->valueRef();
						elemStr="";
					        BEGIN(GetStrList);
					        break;
					      case ConfigOption::O_Enum:
					      case ConfigOption::O_String:
					      case ConfigOption::O_Int:
					      case ConfigOption::O_Bool:
					        config_err("Warning: operator += not supported for `%s'. Ignoring line at line %d, file %s\n",
						    configYYtext,yyLineNr,yyFileName.data()); 
					        BEGIN(SkipInvalid);
						break;
					       case ConfigOption::O_Obsolete:
					         config_err("Warning: Tag `%s' at line %d of file %s has become obsolete.\n"
						            "To avoid this warning please update your configuration "
							    "file using \"doxygen -u\"\n", cmd.data(),yyLineNr,yyFileName.data()); 
					         BEGIN(SkipInvalid);
						 break;
					     }
					   }
					}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 520 "config.l"
{ BEGIN(GetStrList); l=&includePathList; l->clear(); elemStr=""; }
	YY_BREAK
/* include a config file */
case 6:
YY_RULE_SETUP
#line 522 "config.l"
{ BEGIN(Include);}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 523 "config.l"
{ 
  					  readIncludeFile(configYYtext); 
  					  BEGIN(Start);
					}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(Start):
case YY_STATE_EOF(SkipComment):
case YY_STATE_EOF(SkipInvalid):
case YY_STATE_EOF(GetString):
case YY_STATE_EOF(GetBool):
case YY_STATE_EOF(GetStrList):
case YY_STATE_EOF(GetQuotedString):
case YY_STATE_EOF(GetEnvVar):
case YY_STATE_EOF(Include):
#line 527 "config.l"
{
                                          //printf("End of include file\n");
					  //printf("Include stack depth=%d\n",g_includeStack.count());
                                          if (includeStack.isEmpty())
					  {
					    //printf("Terminating scanner!\n");
					    yyterminate();
					  }
					  else
					  {
					    ConfigFileState *fs=includeStack.pop();
					    fclose(fs->filePtr);
					    YY_BUFFER_STATE oldBuf = YY_CURRENT_BUFFER;
					    configYY_switch_to_buffer(fs->oldState );
					    configYY_delete_buffer(oldBuf );
					    yyLineNr=fs->lineNr;
					    yyFileName=fs->fileName;
					    delete fs; fs=0;
                                            includeDepth--;
					  }
  					}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 549 "config.l"
{ config_err("Warning: ignoring unknown tag `%s' at line %d, file %s\n",configYYtext,yyLineNr,yyFileName.data()); }
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 550 "config.l"
{ yyLineNr++; BEGIN(Start); }
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 551 "config.l"
{ 
  					  yyLineNr++; 
					  if (!elemStr.isEmpty())
					  {
					    //printf("elemStr1=`%s'\n",elemStr.data());
					    l->append(elemStr);
					  }
					  BEGIN(Start); 
					}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 560 "config.l"
{
  				          if (!elemStr.isEmpty())
					  {
					    //printf("elemStr2=`%s'\n",elemStr.data());
  					    l->append(elemStr);
					  }
					  elemStr.resize(0);
  					}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 568 "config.l"
{ (*s)+=configYYtext; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 569 "config.l"
{ lastState=YY_START;
  					  BEGIN(GetQuotedString); 
                                          tmpString.resize(0); 
					}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 573 "config.l"
{ 
  					  //printf("Quoted String = `%s'\n",tmpString.data());
  					  if (lastState==GetString)
					    (*s)+=tmpString;
					  else
					    elemStr+=tmpString;
					  if (*configYYtext=='\n')
					  {
					    config_err("Warning: Missing end quote (\") on line %d, file %s\n",yyLineNr,yyFileName.data());
					    yyLineNr++;
					  }
					  BEGIN(lastState);
  					}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 586 "config.l"
{
  					  tmpString+='"';
  					}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 589 "config.l"
{ tmpString+=*configYYtext; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 590 "config.l"
{ 
  					  QCString bs=configYYtext; 
  					  bs=bs.upper();
  					  if (bs=="YES" || bs=="1")
					    *b=TRUE;
					  else if (bs=="NO" || bs=="0")
					    *b=FALSE;
					  else 
					  {
					    *b=FALSE; 
					    config_warn("Warning: Invalid value `%s' for "
						 "boolean tag in line %d, file %s; use YES or NO\n",
						 bs.data(),yyLineNr,yyFileName.data());
					  }
					}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 605 "config.l"
{
  					  elemStr+=configYYtext;
  					}
	YY_BREAK
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 608 "config.l"
{ yyLineNr++; BEGIN(Start); }
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 609 "config.l"
{ yyLineNr++; BEGIN(Start); }
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 610 "config.l"
{ yyLineNr++; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 611 "config.l"

	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 612 "config.l"
{ yyLineNr++ ; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 614 "config.l"
ECHO;
	YY_BREAK
#line 1550 "<stdout>"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed configYYin at a new source and called
			 * configYYlex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = configYYin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( configYYwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * configYYtext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of configYYlex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					configYYrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			configYYrestart(configYYin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 28);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 100 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 28;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 100 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 99);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					configYYrestart(configYYin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( configYYwrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve configYYtext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void configYYrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        configYYensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            configYY_create_buffer(configYYin,YY_BUF_SIZE );
	}

	configYY_init_buffer(YY_CURRENT_BUFFER,input_file );
	configYY_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void configYY_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		configYYpop_buffer_state();
	 *		configYYpush_buffer_state(new_buffer);
     */
	configYYensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	configYY_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (configYYwrap()) processing, but the only time this flag
	 * is looked at is after configYYwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void configYY_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	configYYin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE configYY_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) configYYalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in configYY_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) configYYalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in configYY_create_buffer()" );

	b->yy_is_our_buffer = 1;

	configYY_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with configYY_create_buffer()
 * 
 */
    void configYY_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		configYYfree((void *) b->yy_ch_buf  );

	configYYfree((void *) b  );
}

#ifndef _UNISTD_H /* assume unistd.h has isatty() for us */
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __THROW /* this is a gnuism */
extern int isatty (int ) __THROW;
#else
extern int isatty (int );
#endif
#ifdef __cplusplus
}
#endif
#endif
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a configYYrestart() or at EOF.
 */
    static void configYY_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	configYY_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then configYY_init_buffer was _probably_
     * called from configYYrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void configYY_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		configYY_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void configYYpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	configYYensure_buffer_stack();

	/* This block is copied from configYY_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from configYY_switch_to_buffer. */
	configYY_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void configYYpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	configYY_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		configYY_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void configYYensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)configYYalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)configYYrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE configYY_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) configYYalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in configYY_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	configYY_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to configYYlex() will
 * scan from a @e copy of @a str.
 * @param str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       configYY_scan_bytes() instead.
 */
YY_BUFFER_STATE configYY_scan_string (yyconst char * yystr )
{
    
	return configYY_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to configYYlex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE configYY_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) configYYalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in configYY_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = configYY_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in configYY_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up configYYtext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		configYYtext[configYYleng] = (yy_hold_char); \
		(yy_c_buf_p) = configYYtext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		configYYleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int configYYget_lineno  (void)
{
        
    return configYYlineno;
}

/** Get the input stream.
 * 
 */
FILE *configYYget_in  (void)
{
        return configYYin;
}

/** Get the output stream.
 * 
 */
FILE *configYYget_out  (void)
{
        return configYYout;
}

/** Get the length of the current token.
 * 
 */
int configYYget_leng  (void)
{
        return configYYleng;
}

/** Get the current token.
 * 
 */

char *configYYget_text  (void)
{
        return configYYtext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void configYYset_lineno (int  line_number )
{
    
    configYYlineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see configYY_switch_to_buffer
 */
void configYYset_in (FILE *  in_str )
{
        configYYin = in_str ;
}

void configYYset_out (FILE *  out_str )
{
        configYYout = out_str ;
}

int configYYget_debug  (void)
{
        return configYY_flex_debug;
}

void configYYset_debug (int  bdebug )
{
        configYY_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from configYYlex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    configYYin = stdin;
    configYYout = stdout;
#else
    configYYin = (FILE *) 0;
    configYYout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * configYYlex_init()
     */
    return 0;
}

/* configYYlex_destroy is for both reentrant and non-reentrant scanners. */
int configYYlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		configYY_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		configYYpop_buffer_state();
	}

	/* Destroy the stack itself. */
	configYYfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * configYYlex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *configYYalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *configYYrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void configYYfree (void * ptr )
{
	free( (char *) ptr );	/* see configYYrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 614 "config.l"



/*@ ----------------------------------------------------------------------------
 */

#if 0
static void writeBoolValue(QTextStream &t,bool v)
{
  if (v) t << "YES"; else t << "NO";
}

static void writeIntValue(QTextStream &t,int i)
{
  t << i;
}

static void writeStringValue(QTextStream &t,QCString &s)
{
  const char *p=s.data();
  char c;
  bool hasBlanks=FALSE;
  if (p)
  {
    while ((c=*p++)!=0 && !hasBlanks) hasBlanks = (c==' ' || c=='\n' || c=='\t');
    if (hasBlanks) 
      t << "\"" << s << "\"";
    else
      t << s;
  }
}

static void writeStringList(QTextStream &t,QStrList &l)
{
  const char *p = l.first();
  bool first=TRUE;
  while (p)
  {
    char c;
    const char *s=p;
    bool hasBlanks=FALSE;
    while ((c=*p++)!=0 && !hasBlanks) hasBlanks = (c==' ' || c=='\n' || c=='\t');
    if (!first) t << "                         ";
    first=FALSE;
    if (hasBlanks) t << "\"" << s << "\""; else t << s;
    p = l.next();
    if (p) t << " \\" << endl;
  }
}
#endif

void Config::writeTemplate(QTextStream &t,bool sl,bool upd)
{
  t << "# Doxyfile " << versionString << endl << endl;
  if (!sl)
  {
    t << "# This file describes the settings to be used by the documentation system\n";
    t << "# doxygen (www.doxygen.org) for a project\n";
    t << "#\n";
    t << "# All text after a hash (#) is considered a comment and will be ignored\n";
    t << "# The format is:\n";
    t << "#       TAG = value [value, ...]\n";
    t << "# For lists items can also be appended using:\n";
    t << "#       TAG += value [value, ...]\n";
    t << "# Values that contain spaces should be placed between quotes (\" \")\n";
  }
  ConfigOption *option = m_options->first();
  while (option)
  {
    option->writeTemplate(t,sl,upd);
    option = m_options->next();
  }
}

void Config::convertStrToVal()
{
  ConfigOption *option = m_options->first();
  while (option)
  {
    option->convertStrToVal();
    option = m_options->next();
  }
}

static void substEnvVarsInString(QCString &s)
{
  static QRegExp re("\\$\\([a-z_A-Z0-9]+\\)");
  if (s.isEmpty()) return;
  int p=0;
  int i,l;
  //printf("substEnvVarInString(%s) start\n",s.data());
  while ((i=re.match(s,p,&l))!=-1)
  {
    //printf("Found environment var s.mid(%d,%d)=`%s'\n",i+2,l-3,s.mid(i+2,l-3).data());
    QCString env=getenv(s.mid(i+2,l-3));
    substEnvVarsInString(env); // recursively expand variables if needed.
    s = s.left(i)+env+s.right(s.length()-i-l);
    p=i+env.length(); // next time start at the end of the expanded string
  }
  //printf("substEnvVarInString(%s) end\n",s.data());
}

static void substEnvVarsInStrList(QStrList &sl)
{
  char *s = sl.first();
  while (s)
  {
    QCString result(s);
    bool wasQuoted = (result.find(' ')!=-1) || (result.find('\t')!=-1);
    substEnvVarsInString(result);

    //printf("Result %s was quoted=%d\n",result.data(),wasQuoted);

    if (!wasQuoted) /* as a result of the expansion, a single string
		       may have expanded into a list, which we'll
		       add to sl. If the orginal string already 
		       contained multiple elements no further 
		       splitting is done to allow quoted items with spaces! */
    {
      int l=result.length();
      int i,p=0;
      // skip spaces
      // search for a "word"
      for (i=0;i<l;i++)
      {
	char c=0;
	// skip until start of new word
	while (i<l && ((c=result.at(i))==' ' || c=='\t')) i++; 
	p=i; // p marks the start index of the word
	// skip until end of a word
	while (i<l && ((c=result.at(i))!=' ' && c!='\t' && c!='"')) i++;
	if (i<l) // not at the end of the string
	{
	  if (c=='"') // word within quotes
	  {
	    p=i+1;
	    for (i++;i<l;i++)
	    {
	      c=result.at(i);
	      if (c=='"') // end quote
	      {
		// replace the string in the list and go to the next item.
		sl.insert(sl.at(),result.mid(p,i-p)); // insert new item before current item.
		sl.next();                 // current item is now the old item
		p=i+1;
		break; 
	      }
	      else if (c=='\\') // skip escaped stuff
	      {
		i++;
	      }
	    }
	  }
	  else if (c==' ' || c=='\t') // separator
	  {
	    // replace the string in the list and go to the next item.
	    sl.insert(sl.at(),result.mid(p,i-p)); // insert new item before current item.
	    sl.next();                 // current item is now the old item
	    p=i+1;
	  }
	}
      }
      if (p!=l) // add the leftover as a string
      {
	// replace the string in the list and go to the next item.
	sl.insert(sl.at(),result.right(l-p)); // insert new item before current item.
	sl.next();                 // current item is now the old item
      }
    }
    else // just goto the next element in the list
    {
      sl.insert(sl.at(),result);
      sl.next();
    }
    // remove the old unexpanded string from the list
    int i=sl.at();
    sl.remove(); // current item index changes if the last element is removed.
    if (sl.at()==i)     // not last item
	s = sl.current();
    else                // just removed last item
	s = 0;
  }
}

void ConfigString::substEnvVars()
{
  substEnvVarsInString(m_value);
}

void ConfigList::substEnvVars()
{
  substEnvVarsInStrList(m_value);
}

void ConfigBool::substEnvVars()
{
  substEnvVarsInString(m_valueString);
}

void ConfigInt::substEnvVars()
{
  substEnvVarsInString(m_valueString);
}

void ConfigEnum::substEnvVars()
{
  substEnvVarsInString(m_value);
}

void Config::substituteEnvironmentVars()
{
  ConfigOption *option = m_options->first();
  while (option)
  {
    option->substEnvVars();
    option = m_options->next();
  }
}

static void cleanUpPaths(QStrList &str)
{
  char *sfp = str.first();
  while (sfp)
  {
    register char *p = sfp;
    if (p)
    {
      char c;
      while ((c=*p))
      {
	if (c=='\\') *p='/';
	p++;
      }
    }
    QCString path = sfp;
    if ((path.at(0)!='/' && (path.length()<=2 || path.at(1)!=':')) ||
	path.at(path.length()-1)!='/'
       )
    {
      QFileInfo fi(path);
      if (fi.exists() && fi.isDir())
      {
	int i = str.at();
	str.remove();
	if (str.at()==i) // did not remove last item
	  str.insert(i,fi.absFilePath()+"/");
	else
	  str.append(fi.absFilePath()+"/");
      }
    }
    sfp = str.next();
  }
}

void Config::check()
{
  //if (!projectName.isEmpty())
  //{
  //  projectName[0]=toupper(projectName[0]);
  //}

  QCString &warnFormat = Config_getString("WARN_FORMAT");
  if (warnFormat.isEmpty())
  {
    warnFormat="$file:$line $text";
  }
  else
  {
    if (warnFormat.find("$file")==-1)
    {
      config_err("Error: warning format does not contain a $file tag!\n");
      exit(1);
    }
    if (warnFormat.find("$line")==-1)
    {
      config_err("Error: warning format does not contain a $line tag!\n");
      exit(1);
    }
    if (warnFormat.find("$text")==-1)
    {
      config_err("Error: wanring format foes not contain a $text tag!\n");
      exit(1);
    }
  }

  QCString &manExtension = Config_getString("MAN_EXTENSION");
  
  // set default man page extension if non is given by the user
  if (manExtension.isEmpty())
  {
    manExtension=".3";
  }
  
  QCString &paperType = Config_getEnum("PAPER_TYPE");
  paperType=paperType.lower().stripWhiteSpace(); 
  if (paperType.isEmpty())
  {
    paperType = "a4wide";
  }
  if (paperType!="a4" && paperType!="a4wide" && paperType!="letter" && 
      paperType!="legal" && paperType!="executive")
  {
    config_err("Error: Unknown page type specified");
  }
  
  QCString &outputLanguage=Config_getEnum("OUTPUT_LANGUAGE");
  outputLanguage=outputLanguage.stripWhiteSpace();
  if (outputLanguage.isEmpty())
  {
    outputLanguage = "English";
  }

  QCString &htmlFileExtension=Config_getString("HTML_FILE_EXTENSION");
  htmlFileExtension=htmlFileExtension.stripWhiteSpace();
  if (htmlFileExtension.isEmpty())
  {
    htmlFileExtension = ".html";
  }
  
  // expand the relative stripFromPath values
  QStrList &stripFromPath = Config_getList("STRIP_FROM_PATH");
  char *sfp = stripFromPath.first();
  if (sfp==0) // by default use the current path
  {
    stripFromPath.append(QDir::currentDirPath()+"/");
  }
  else
  {
    cleanUpPaths(stripFromPath);
  }

  // expand the relative stripFromPath values
  QStrList &stripFromIncPath = Config_getList("STRIP_FROM_INC_PATH");
  cleanUpPaths(stripFromIncPath);
  
  // Test to see if HTML header is valid
  QCString &headerFile = Config_getString("HTML_HEADER");
  if (!headerFile.isEmpty())
  {
    QFileInfo fi(headerFile);
    if (!fi.exists())
    {
      config_err("Error: tag HTML_HEADER: header file `%s' "
	  "does not exist\n",headerFile.data());
      exit(1);
    }
  }
  // Test to see if HTML footer is valid
  QCString &footerFile = Config_getString("HTML_FOOTER");
  if (!footerFile.isEmpty())
  {
    QFileInfo fi(footerFile);
    if (!fi.exists())
    {
      config_err("Error: tag HTML_FOOTER: footer file `%s' "
	  "does not exist\n",footerFile.data());
      exit(1);
    }
  }
  // Test to see if LaTeX header is valid
  QCString &latexHeaderFile = Config_getString("LATEX_HEADER");
  if (!latexHeaderFile.isEmpty())
  {
    QFileInfo fi(latexHeaderFile);
    if (!fi.exists())
    {
      config_err("Error: tag LATEX_HEADER: header file `%s' "
	  "does not exist\n",latexHeaderFile.data());
      exit(1);
    }
  }
  // check include path
  QStrList &includePath = Config_getList("INCLUDE_PATH");
  char *s=includePath.first();
  while (s)
  {
    QFileInfo fi(s);
    if (!fi.exists()) config_err("Warning: tag INCLUDE_PATH: include path `%s' "
	                  "does not exist\n",s);
    s=includePath.next();
  }

  // check aliases
  QStrList &aliasList = Config_getList("ALIASES");
  s=aliasList.first();
  while (s)
  {
    QRegExp re("[a-z_A-Z][a-z_A-Z0-9]*[ \t]*=");
    QCString alias=s;
    alias=alias.stripWhiteSpace();
    if (alias.find(re)!=0)
    {
      config_err("Illegal alias format `%s'. Use \"name=value\"\n",
	  alias.data());
    }
    s=aliasList.next();
  }

  // check dot image format
  QCString &dotImageFormat=Config_getEnum("DOT_IMAGE_FORMAT");
  dotImageFormat=dotImageFormat.stripWhiteSpace();
  if (dotImageFormat.isEmpty())
  {
    dotImageFormat = "png";
  }
  else if (dotImageFormat!="gif" && dotImageFormat!="png" && dotImageFormat!="jpg")
  {
    config_err("Invalid value for DOT_IMAGE_FORMAT: `%s'. Using the default.\n",dotImageFormat.data());
    dotImageFormat = "png";
  }
  
  
  // check dot path
  QCString &dotPath = Config_getString("DOT_PATH");
  if (!dotPath.isEmpty())
  {
    if (dotPath.find('\\')!=-1)
    {
      if (dotPath.at(dotPath.length()-1)!='\\')
      {
	dotPath+='\\';
      } 
    } 
    else if (dotPath.find('/')!=-1)
    {
      if (dotPath.at(dotPath.length()-1)!='/')
      {
	dotPath+='/';
      } 
    } 
#if defined(_WIN32)
    QFileInfo dp(dotPath+"dot.exe");
#else
    QFileInfo dp(dotPath+"dot");
#endif
    if (!dp.exists() || !dp.isFile())
    {
      config_err("Warning: the dot tool could not be found at %s\n",dotPath.data());
      dotPath="";
    }
    else
    {
      dotPath=dp.dirPath(TRUE)+"/";
#if defined(_WIN32) // convert slashes
      uint i=0,l=dotPath.length();
      for (i=0;i<l;i++) if (dotPath.at(i)=='/') dotPath.at(i)='\\';
#endif
    }
  }
  else // make sure the string is empty but not null!
  {
    dotPath="";
  }
  
  // check input
  QStrList &inputSources=Config_getList("INPUT");
  if (inputSources.count()==0)
  {
    // use current dir as the default
    inputSources.append(QDir::currentDirPath());
  }
  else
  {
    s=inputSources.first();
    while (s)
    {
      QFileInfo fi(s);
      if (!fi.exists())
      {
	config_err("Error: tag INPUT: input source `%s' does not exist\n",s);
	exit(1);
      }
      s=inputSources.next();
    }
  }

  // add default pattern if needed
  QStrList &filePatternList = Config_getList("FILE_PATTERNS");
  if (filePatternList.isEmpty())
  {
    filePatternList.append("*.c");
    filePatternList.append("*.cc"); 
    filePatternList.append("*.cxx");
    filePatternList.append("*.cpp");
    filePatternList.append("*.c++");
    filePatternList.append("*.d");
    filePatternList.append("*.java");
    filePatternList.append("*.ii");
    filePatternList.append("*.ixx");
    filePatternList.append("*.ipp");
    filePatternList.append("*.i++");
    filePatternList.append("*.inl");
    filePatternList.append("*.h");
    filePatternList.append("*.hh");
    filePatternList.append("*.hxx");
    filePatternList.append("*.hpp");
    filePatternList.append("*.h++");
    filePatternList.append("*.idl");
    filePatternList.append("*.odl");
    filePatternList.append("*.cs");
    filePatternList.append("*.php");
    filePatternList.append("*.php3");
    filePatternList.append("*.inc");
    filePatternList.append("*.m");
    filePatternList.append("*.mm");
    filePatternList.append("*.dox");
    filePatternList.append("*.py");
#if !defined(_WIN32)
    // unix => case sensitive match => also include useful uppercase versions
    filePatternList.append("*.C");
    filePatternList.append("*.CC"); 
    filePatternList.append("*.C++");
    filePatternList.append("*.II");
    filePatternList.append("*.I++");
    filePatternList.append("*.H");
    filePatternList.append("*.HH");
    filePatternList.append("*.H++");
    filePatternList.append("*.CS");
    filePatternList.append("*.PHP");
    filePatternList.append("*.PHP3");
    filePatternList.append("*.M");
    filePatternList.append("*.MM");
    filePatternList.append("*.PY");
#endif
  }

  // add default pattern if needed
  QStrList &examplePatternList = Config_getList("EXAMPLE_PATTERNS");
  if (examplePatternList.isEmpty())
  {
    examplePatternList.append("*");
  }

#undef PUTENV
#undef SEP
#if defined(_WIN32) && !defined(__GNUC__) && (__BORLANDC__ < 0x0550)
#define PUTENV _putenv
#define SEP ";"
#else 
#define PUTENV putenv
#define SEP ":"
#endif
  if (Config_getBool("HAVE_DOT")) 
  {
    char *curFontPath = getenv("DOTFONTPATH");
    int l=curFontPath ? strlen(curFontPath)+1 : 0;
    static char *buf = 0;
    buf = (char *)realloc(buf,strlen("DOTFONTPATH=.")+l+1);
    strcpy(buf,"DOTFONTPATH=.");
    if (l>0)
    {
      strcat(buf,SEP);
      strcat(buf,curFontPath);
    }
    PUTENV(buf);
  }

  int &depth = Config_getInt("MAX_DOT_GRAPH_DEPTH");
  if (depth==0)
  {
    depth=1000;
  }
  
  if (Config_getBool("OPTIMIZE_OUTPUT_JAVA") && Config_getBool("INLINE_INFO"))
  {
    // don't show inline info for Java output, since Java has no inline 
    // concept.
    Config_getBool("INLINE_INFO")=FALSE;
  }
  
  // add default words if needed
  QStrList &annotationFromBrief = Config_getList("ABBREVIATE_BRIEF");
  if (annotationFromBrief.isEmpty())
  {
    annotationFromBrief.append("The $name class");
    annotationFromBrief.append("The $name widget");
    annotationFromBrief.append("The $name file");
    annotationFromBrief.append("is");
    annotationFromBrief.append("provides");
    annotationFromBrief.append("specifies");
    annotationFromBrief.append("contains");
    annotationFromBrief.append("represents");
    annotationFromBrief.append("a");
    annotationFromBrief.append("an");
    annotationFromBrief.append("the");
  }
}

void Config::init()
{
  ConfigOption *option = m_options->first();
  while (option)
  {
    option->init();
    option = m_options->next();
  }
}

void Config::create()
{
  if (m_initialized) return; 
  m_initialized = TRUE;

  ConfigString *cs;
  ConfigEnum   *ce;
  ConfigList   *cl;
  ConfigInt    *ci;
  ConfigBool   *cb;
  
  // option definitions
  //-----------------------------------------------------------------------------------------------
  addInfo("Project","Project related configuration options");
  //-----------------------------------------------------------------------------------------------
  
  
  cs = addString(
                 "PROJECT_NAME",
                 "The PROJECT_NAME tag is a single word (or a sequence of words surrounded \n"
                 "by quotes) that should identify the project. "
                );
  cs = addString(
                 "PROJECT_NUMBER",
                 "The PROJECT_NUMBER tag can be used to enter a project or revision number. \n"
                 "This could be handy for archiving the generated documentation or \n"
                 "if some version control system is used.\n"
                );
  cs = addString(
                 "OUTPUT_DIRECTORY",
                 "The OUTPUT_DIRECTORY tag is used to specify the (relative or absolute) \n"
                 "base path where the generated documentation will be put. \n"
                 "If a relative path is entered, it will be relative to the location \n"
                 "where doxygen was started. If left blank the current directory will be used.\n"
		);
  cs->setWidgetType(ConfigString::Dir);
  cb = addBool(
                 "CREATE_SUBDIRS",
                 "If the CREATE_SUBDIRS tag is set to YES, then doxygen will create \n"
                 "4096 sub-directories (in 2 levels) under the output directory of each output \n"
		 "format and will distribute the generated files over these directories. \n"
		 "Enabling this option can be useful when feeding doxygen a huge amount of \n"
		 "source files, where putting all generated files in the same directory would \n"
		 "otherwise cause performance problems for the file system. \n",
		 FALSE
                );
  ce = addEnum(
                 "OUTPUT_LANGUAGE",
                 "The OUTPUT_LANGUAGE tag is used to specify the language in which all \n"
                 "documentation generated by doxygen is written. Doxygen will use this \n"
                 "information to generate all constant output in the proper language. \n"
                 "The default language is English, other supported languages are: \n"
		 "Brazilian, Catalan, Chinese, Chinese-Traditional, Croatian, Czech, Danish, \n"
		 "Dutch, Finnish, French, German, Greek, Hungarian, Italian, Japanese, \n"
		 "Japanese-en (Japanese with English messages), Korean, Korean-en, Norwegian, \n"
		 "Polish, Portuguese, Romanian, Russian, Serbian, Slovak, Slovene, Spanish, \n"
		 "Swedish, and Ukrainian.\n", 
		 "English"
                );
#ifdef LANG_BR
  ce->addValue("Brazilian");
#endif
#ifdef LANG_CA
  ce->addValue("Catalan");
#endif
#ifdef LANG_CN
  ce->addValue("Chinese");
#endif
#ifdef LANG_TW
  ce->addValue("Chinese-Traditional");
#endif
#ifdef LANG_HR
  ce->addValue("Croatian");
#endif
#ifdef LANG_CZ
  ce->addValue("Czech");
#endif
#ifdef LANG_DK
  ce->addValue("Danish");
#endif
#ifdef LANG_NL
  ce->addValue("Dutch");
#endif
  ce->addValue("English");
#ifdef LANG_FI
  ce->addValue("Finnish");
#endif
#ifdef LANG_FR
  ce->addValue("French");
#endif
#ifdef LANG_DE
  ce->addValue("German");
#endif
#ifdef LANG_GR
  ce->addValue("Greek");
#endif
#ifdef LANG_HU
  ce->addValue("Hungarian");
#endif
#ifdef LANG_IT
  ce->addValue("Italian");
#endif
#ifdef LANG_JP
  ce->addValue("Japanese");
  ce->addValue("Japanese-en");
#endif
#ifdef LANG_KR
  ce->addValue("Korean");
  ce->addValue("Korean-en");
#endif
#ifdef LANG_NO
  ce->addValue("Norwegian");
#endif
#ifdef LANG_PL
  ce->addValue("Polish");
#endif
#ifdef LANG_PT
  ce->addValue("Portuguese");
#endif
#ifdef LANG_RO
  ce->addValue("Romanian");
#endif
#ifdef LANG_RU
  ce->addValue("Russian");
#endif
#ifdef LANG_SR
  ce->addValue("Serbian");
#endif
#ifdef LANG_SK
  ce->addValue("Slovak");
#endif
#ifdef LANG_SI
  ce->addValue("Slovene");
#endif
#ifdef LANG_ES
  ce->addValue("Spanish");
#endif
#ifdef LANG_SE
  ce->addValue("Swedish");
#endif
#ifdef LANG_UA
  ce->addValue("Ukrainian");
#endif
  cb = addBool(
                    "USE_WINDOWS_ENCODING",
		    "This tag can be used to specify the encoding used in the generated output. \n"
		    "The encoding is not always determined by the language that is chosen, \n"
		    "but also whether or not the output is meant for Windows or non-Windows users. \n"
		    "In case there is a difference, setting the USE_WINDOWS_ENCODING tag to YES \n"
		    "forces the Windows encoding (this is the default for the Windows binary), \n"
		    "whereas setting the tag to NO uses a Unix-style encoding (the default for \n"
		    "all platforms other than Windows).\n",
#if defined(_WIN32) || defined(__CYGWIN__)
		    TRUE
#else
		    FALSE
#endif
		 );
  cb = addBool(
                    "BRIEF_MEMBER_DESC",
                    "If the BRIEF_MEMBER_DESC tag is set to YES (the default) Doxygen will \n"
                    "include brief member descriptions after the members that are listed in \n"
                    "the file and class documentation (similar to JavaDoc). \n"
                    "Set to NO to disable this. \n",
                    TRUE
                 );
  cb = addBool(
                    "REPEAT_BRIEF",
                    "If the REPEAT_BRIEF tag is set to YES (the default) Doxygen will prepend \n"
                    "the brief description of a member or function before the detailed description. \n"
                    "Note: if both HIDE_UNDOC_MEMBERS and BRIEF_MEMBER_DESC are set to NO, the \n"
                    "brief descriptions will be completely suppressed. \n",
                    TRUE
                 );
  cl = addList(
                    "ABBREVIATE_BRIEF",
                    "This tag implements a quasi-intelligent brief description abbreviator \n"
                    "that is used to form the text in various listings. Each string \n"
                    "in this list, if found as the leading text of the brief description, will be \n"
                    "stripped from the text and the result after processing the whole list, is \n"
		    "used as the annotated text. Otherwise, the brief description is used as-is. \n"
		    "If left blank, the following values are used (\"$name\" is automatically \n"
		    "replaced with the name of the entity): \"The $name class\" \"The $name widget\" \n"
		    "\"The $name file\" \"is\" \"provides\" \"specifies\" \"contains\" \n"
		    "\"represents\" \"a\" \"an\" \"the\"\n"
                 );
  cb = addBool(
                    "ALWAYS_DETAILED_SEC",
                    "If the ALWAYS_DETAILED_SEC and REPEAT_BRIEF tags are both set to YES then \n"
                    "Doxygen will generate a detailed section even if there is only a brief \n"
                    "description. \n",
                    FALSE
                 );
  cb = addBool(
                    "INLINE_INHERITED_MEMB",
                    "If the INLINE_INHERITED_MEMB tag is set to YES, doxygen will show all \n"
		    "inherited members of a class in the documentation of that class as if those \n"
		    "members were ordinary class members. Constructors, destructors and assignment \n"
		    "operators of the base classes will not be shown. \n",
		    FALSE
                 );
  cb = addBool(
                    "FULL_PATH_NAMES",
                    "If the FULL_PATH_NAMES tag is set to YES then Doxygen will prepend the full \n"
                    "path before files name in the file list and in the header files. If set \n"
                    "to NO the shortest path that makes the file name unique will be used. \n",
                    TRUE
                 );
  cl = addList(
                    "STRIP_FROM_PATH",
                    "If the FULL_PATH_NAMES tag is set to YES then the STRIP_FROM_PATH tag \n"
                    "can be used to strip a user-defined part of the path. Stripping is \n"
                    "only done if one of the specified strings matches the left-hand part of \n"
                    "the path. The tag can be used to show relative paths in the file list. \n"
		    "If left blank the directory from which doxygen is run is used as the \n"
		    "path to strip. \n"
                 );
  cl->addDependency("FULL_PATH_NAMES");
  cl = addList(
                    "STRIP_FROM_INC_PATH",
                    "The STRIP_FROM_INC_PATH tag can be used to strip a user-defined part of \n"
		    "the path mentioned in the documentation of a class, which tells \n"
		    "the reader which header file to include in order to use a class. \n"
		    "If left blank only the name of the header file containing the class \n"
		    "definition is used. Otherwise one should specify the include paths that \n"
		    "are normally passed to the compiler using the -I flag.\n"
                 );
  cb = addBool(
                    "SHORT_NAMES",
		    "If the SHORT_NAMES tag is set to YES, doxygen will generate much shorter \n"
		    "(but less readable) file names. This can be useful is your file systems \n"
		    "doesn't support long names like on DOS, Mac, or CD-ROM. \n",
		    FALSE
                 );
  cb = addBool(
                    "JAVADOC_AUTOBRIEF",
                    "If the JAVADOC_AUTOBRIEF tag is set to YES then Doxygen \n"
                    "will interpret the first line (until the first dot) of a JavaDoc-style \n"
                    "comment as the brief description. If set to NO, the JavaDoc \n"
                    "comments will behave just like the Qt-style comments (thus requiring an \n"
                    "explicit @brief command for a brief description. \n",
                    FALSE
                 );
  cb = addBool(
                    "MULTILINE_CPP_IS_BRIEF",
                    "The MULTILINE_CPP_IS_BRIEF tag can be set to YES to make Doxygen \n"
                    "treat a multi-line C++ special comment block (i.e. a block of //! or /// \n"
		    "comments) as a brief description. This used to be the default behaviour. \n"
		    "The new default is to treat a multi-line C++ comment block as a detailed \n"
		    "description. Set this tag to YES if you prefer the old behaviour instead. \n",
                    FALSE
                 );
  cb = addBool(
                    "DETAILS_AT_TOP",
                    "If the DETAILS_AT_TOP tag is set to YES then Doxygen \n"
                    "will output the detailed description near the top, like JavaDoc.\n"
                    "If set to NO, the detailed description appears after the member \n"
                    "documentation. \n",
                    FALSE
                 );
  cb = addBool(
                    "INHERIT_DOCS",
                    "If the INHERIT_DOCS tag is set to YES (the default) then an undocumented \n"
                    "member inherits the documentation from any documented member that it \n"
                    "re-implements. \n",
                    TRUE
                 );
  cb = addBool(    
                    "SEPARATE_MEMBER_PAGES",
		    "If the SEPARATE_MEMBER_PAGES tag is set to YES, then doxygen will produce \n"
		    "a new page for each member. If set to NO, the documentation of a member will \n"
		    "be part of the file/class/namespace that contains it.\n",
		    FALSE
		 );
  ci = addInt(
                    "TAB_SIZE",
                    "The TAB_SIZE tag can be used to set the number of spaces in a tab. \n"
                    "Doxygen uses this value to replace tabs by spaces in code fragments. \n",
                    1,16,8
                 );
  cl = addList(
                    "ALIASES",
                    "This tag can be used to specify a number of aliases that acts \n"
                    "as commands in the documentation. An alias has the form \"name=value\". \n"
                    "For example adding \"sideeffect=\\par Side Effects:\\n\" will allow you to \n"
                    "put the command \\sideeffect (or @sideeffect) in the documentation, which \n"
                    "will result in a user-defined paragraph with heading \"Side Effects:\". \n"
                    "You can put \\n's in the value part of an alias to insert newlines. \n" 
                 );
  cb = addBool(
                    "OPTIMIZE_OUTPUT_FOR_C",
                    "Set the OPTIMIZE_OUTPUT_FOR_C tag to YES if your project consists of C \n"
		    "sources only. Doxygen will then generate output that is more tailored for C. \n"
                    "For instance, some of the names that are used will be different. The list \n"
                    "of all members will be omitted, etc. \n",
                    FALSE
                 );
  cb = addBool(
                    "OPTIMIZE_OUTPUT_JAVA",
                    "Set the OPTIMIZE_OUTPUT_JAVA tag to YES if your project consists of Java \n"
		    "sources only. Doxygen will then generate output that is more tailored for Java. \n"
                    "For instance, namespaces will be presented as packages, qualified scopes \n"
                    "will look different, etc. \n",
                    FALSE
                 );
  cb = addBool(  
                    "BUILTIN_STL_SUPPORT",
		    "If you use STL classes (i.e. std::string, std::vector, etc.) but do not want to \n"
		    "include (a tag file for) the STL sources as input, then you should \n"
		    "set this tag to YES in order to let doxygen match functions declarations and \n"
		    "definitions whose arguments contain STL classes (e.g. func(std::string); v.s. \n"
		    "func(std::string) {}). This also make the inheritance and collaboration \n"
		    "diagrams that involve STL classes more complete and accurate. \n",
		    FALSE
		 );
  cb = addBool(
                    "DISTRIBUTE_GROUP_DOC",
                    "If member grouping is used in the documentation and the DISTRIBUTE_GROUP_DOC \n"
                    "tag is set to YES, then doxygen will reuse the documentation of the first \n"
                    "member in the group (if any) for the other members of the group. By default \n"
                    "all members of a group must be documented explicitly.\n",
                    FALSE
                 );
  cb = addBool(    
                    "SUBGROUPING",
		    "Set the SUBGROUPING tag to YES (the default) to allow class member groups of \n"
		    "the same type (for instance a group of public functions) to be put as a \n"
		    "subgroup of that type (e.g. under the Public Functions section). Set it to \n"
		    "NO to prevent subgrouping. Alternatively, this can be done per class using \n"
		    "the \\nosubgrouping command. \n",
		    TRUE
                );
  //-----------------------------------------------------------------------------------------------
  addInfo("Build","Build related configuration options");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "EXTRACT_ALL",
                    "If the EXTRACT_ALL tag is set to YES doxygen will assume all entities in \n"
                    "documentation are documented, even if no documentation was available. \n"
                    "Private class members and static file members will be hidden unless \n"
                    "the EXTRACT_PRIVATE and EXTRACT_STATIC tags are set to YES \n",
                    FALSE
                 );
  cb = addBool(
                    "EXTRACT_PRIVATE",
                    "If the EXTRACT_PRIVATE tag is set to YES all private members of a class \n"
                    "will be included in the documentation. \n",
                    FALSE
                 );
  cb = addBool(
                    "EXTRACT_STATIC",
                    "If the EXTRACT_STATIC tag is set to YES all static members of a file \n"
                    "will be included in the documentation. \n",
                    FALSE
                 );
  cb = addBool(
                    "EXTRACT_LOCAL_CLASSES",
                    "If the EXTRACT_LOCAL_CLASSES tag is set to YES classes (and structs) \n"
		    "defined locally in source files will be included in the documentation. \n"
		    "If set to NO only classes defined in header files are included. \n",
                    TRUE
                 );
  cb = addBool(
                    "EXTRACT_LOCAL_METHODS",
                    "This flag is only useful for Objective-C code. When set to YES local \n"
		    "methods, which are defined in the implementation section but not in \n"
		    "the interface are included in the documentation. \n"
		    "If set to NO (the default) only methods in the interface are included. \n",
                    FALSE
                 );
  cb = addBool(
                    "HIDE_UNDOC_MEMBERS",
                    "If the HIDE_UNDOC_MEMBERS tag is set to YES, Doxygen will hide all \n"
                    "undocumented members of documented classes, files or namespaces. \n"
                    "If set to NO (the default) these members will be included in the \n"
                    "various overviews, but no documentation section is generated. \n"
                    "This option has no effect if EXTRACT_ALL is enabled. \n",
                    FALSE
                 );
  cb = addBool(
                    "HIDE_UNDOC_CLASSES",
                    "If the HIDE_UNDOC_CLASSES tag is set to YES, Doxygen will hide all \n"
                    "undocumented classes that are normally visible in the class hierarchy. \n"
                    "If set to NO (the default) these classes will be included in the various \n"
                    "overviews. This option has no effect if EXTRACT_ALL is enabled. \n",
                    FALSE
                 );
  cb = addBool(
                    "HIDE_FRIEND_COMPOUNDS",
                    "If the HIDE_FRIEND_COMPOUNDS tag is set to YES, Doxygen will hide all \n"
                    "friend (class|struct|union) declarations. \n"
                    "If set to NO (the default) these declarations will be included in the \n"
                    "documentation. \n",
                    FALSE
                 );
  cb = addBool(
                    "HIDE_IN_BODY_DOCS",
                    "If the HIDE_IN_BODY_DOCS tag is set to YES, Doxygen will hide any \n"
                    "documentation blocks found inside the body of a function. \n"
                    "If set to NO (the default) these blocks will be appended to the \n"
                    "function's detailed documentation block. \n",
                    FALSE
                 );
  cb = addBool(
                    "INTERNAL_DOCS",
                    "The INTERNAL_DOCS tag determines if documentation \n"
                    "that is typed after a \\internal command is included. If the tag is set \n"
                    "to NO (the default) then the documentation will be excluded. \n"
                    "Set it to YES to include the internal documentation. \n",
                    FALSE
                 );
  cb = addBool(
                    "CASE_SENSE_NAMES",
                    "If the CASE_SENSE_NAMES tag is set to NO then Doxygen will only generate \n"
                    "file names in lower-case letters. If set to YES upper-case letters are also \n"
                    "allowed. This is useful if you have classes or files whose names only differ \n"
                    "in case and if your file system supports case sensitive file names. Windows \n"
                    "and Mac users are advised to set this option to NO.\n",
#if defined(_WIN32) || defined(macintosh) || defined(__MACOSX__) || defined(__APPLE__)
		    FALSE // case insensitive file system expected
#else
                    TRUE // case sensitive file system expected
#endif
                 );
  cb = addBool(
                    "HIDE_SCOPE_NAMES",
                    "If the HIDE_SCOPE_NAMES tag is set to NO (the default) then Doxygen \n"
                    "will show members with their full class and namespace scopes in the \n"
                    "documentation. If set to YES the scope will be hidden. \n",
                    FALSE
                 );
  cb = addBool(
                    "SHOW_INCLUDE_FILES",
                    "If the SHOW_INCLUDE_FILES tag is set to YES (the default) then Doxygen \n"
                    "will put a list of the files that are included by a file in the documentation \n"
                    "of that file. \n",
                    TRUE
                 );
  cb = addBool(
                    "INLINE_INFO",
                    "If the INLINE_INFO tag is set to YES (the default) then a tag [inline] \n"
                    "is inserted in the documentation for inline members. \n",
                    TRUE
                 );
  cb = addBool(
                    "SORT_MEMBER_DOCS",
                    "If the SORT_MEMBER_DOCS tag is set to YES (the default) then doxygen \n"
                    "will sort the (detailed) documentation of file and class members \n"
                    "alphabetically by member name. If set to NO the members will appear in \n"
                    "declaration order. \n",
                    TRUE
                 );
  cb = addBool(
                    "SORT_BRIEF_DOCS",
                    "If the SORT_BRIEF_DOCS tag is set to YES then doxygen will sort the \n"
                    "brief documentation of file, namespace and class members alphabetically \n"
                    "by member name. If set to NO (the default) the members will appear in \n"
                    "declaration order. \n",
                    FALSE
                 );
  cb = addBool(
                    "SORT_BY_SCOPE_NAME",
                    "If the SORT_BY_SCOPE_NAME tag is set to YES, the class list will be \n"
                    "sorted by fully-qualified names, including namespaces. If set to \n"
		    "NO (the default), the class list will be sorted only by class name, \n"
		    "not including the namespace part. \n"
                    "Note: This option is not very useful if HIDE_SCOPE_NAMES is set to YES.\n"
                    "Note: This option applies only to the class list, not to the \n"
                    "alphabetical list.\n",
                    FALSE
                 );

  cb = addBool(
                    "GENERATE_TODOLIST",
                    "The GENERATE_TODOLIST tag can be used to enable (YES) or \n"
                    "disable (NO) the todo list. This list is created by putting \\todo \n"
                    "commands in the documentation.\n",
                    TRUE
                 );
  cb = addBool(
                    "GENERATE_TESTLIST",
                    "The GENERATE_TESTLIST tag can be used to enable (YES) or \n"
                    "disable (NO) the test list. This list is created by putting \\test \n"
                    "commands in the documentation.\n",
                    TRUE
                 );
  cb = addBool(
                    "GENERATE_BUGLIST",
                    "The GENERATE_BUGLIST tag can be used to enable (YES) or \n"
                    "disable (NO) the bug list. This list is created by putting \\bug \n"
                    "commands in the documentation.\n",
                    TRUE
                 );
  cb = addBool(
                    "GENERATE_DEPRECATEDLIST",
                    "The GENERATE_DEPRECATEDLIST tag can be used to enable (YES) or \n"
                    "disable (NO) the deprecated list. This list is created by putting \n"
		    "\\deprecated commands in the documentation.\n",
                    TRUE
	         );
  cl = addList(
                    "ENABLED_SECTIONS",
                    "The ENABLED_SECTIONS tag can be used to enable conditional \n"
                    "documentation sections, marked by \\if sectionname ... \\endif. \n"
                 );
  ci = addInt(
                    "MAX_INITIALIZER_LINES",
                    "The MAX_INITIALIZER_LINES tag determines the maximum number of lines \n"
                    "the initial value of a variable or define consists of for it to appear in \n"
                    "the documentation. If the initializer consists of more lines than specified \n"
                    "here it will be hidden. Use a value of 0 to hide initializers completely. \n"
                    "The appearance of the initializer of individual variables and defines in the \n"
                    "documentation can be controlled using \\showinitializer or \\hideinitializer \n"
                    "command in the documentation regardless of this setting. \n",
                    0,10000,30
                 );
  cb = addBool(
                    "SHOW_USED_FILES",
                    "Set the SHOW_USED_FILES tag to NO to disable the list of files generated \n"
                    "at the bottom of the documentation of classes and structs. If set to YES the \n"
                    "list will mention the files that were used to generate the documentation. \n",
                    TRUE
                );
  cb = addBool(
                    "SHOW_DIRECTORIES",
		    "If the sources in your project are distributed over multiple directories \n"
		    "then setting the SHOW_DIRECTORIES tag to YES will show the directory hierarchy \n"
		    "in the documentation. The default is NO.\n",
		    FALSE
              );
  cs = addString(  "FILE_VERSION_FILTER",
                   "The FILE_VERSION_FILTER tag can be used to specify a program or script that \n"
		   "doxygen should invoke to get the current version for each file (typically from the \n"
		   "version control system). Doxygen will invoke the program by executing (via \n"
		   "popen()) the command <command> <input-file>, where <command> is the value of \n"
		   "the FILE_VERSION_FILTER tag, and <input-file> is the name of an input file \n"
		   "provided by doxygen. Whatever the program writes to standard output \n"
		   "is used as the file version. See the manual for examples. \n"
              );
  cs->setWidgetType(ConfigString::File);
  
  //-----------------------------------------------------------------------------------------------
  addInfo(  "Messages","configuration options related to warning and progress messages");
  //-----------------------------------------------------------------------------------------------

  cb = addBool(
                    "QUIET",
                    "The QUIET tag can be used to turn on/off the messages that are generated \n"
                    "by doxygen. Possible values are YES and NO. If left blank NO is used. \n",
                    FALSE
                 );
  cb = addBool(
                    "WARNINGS",
                    "The WARNINGS tag can be used to turn on/off the warning messages that are \n"
                    "generated by doxygen. Possible values are YES and NO. If left blank \n"
                    "NO is used. \n",
                    TRUE
                 );
  cb = addBool(
                    "WARN_IF_UNDOCUMENTED",
                    "If WARN_IF_UNDOCUMENTED is set to YES, then doxygen will generate warnings \n"
                    "for undocumented members. If EXTRACT_ALL is set to YES then this flag will \n"
                    "automatically be disabled. \n",
                    TRUE
                 );
  cb = addBool(
                    "WARN_IF_DOC_ERROR",
                    "If WARN_IF_DOC_ERROR is set to YES, doxygen will generate warnings for \n"
                    "potential errors in the documentation, such as not documenting some \n"
		    "parameters in a documented function, or documenting parameters that \n"
		    "don't exist or using markup commands wrongly. \n",
                    TRUE
                 );
  cb = addBool(     "WARN_NO_PARAMDOC",
                    "This WARN_NO_PARAMDOC option can be abled to get warnings for \n"
		    "functions that are documented, but have no documentation for their parameters \n"
		    "or return value. If set to NO (the default) doxygen will only warn about \n"
		    "wrong or incomplete parameter documentation, but not about the absence of \n"
		    "documentation.\n",
                    FALSE
                 );
  cs = addString(
                    "WARN_FORMAT",
                    "The WARN_FORMAT tag determines the format of the warning messages that \n"
                    "doxygen can produce. The string should contain the $file, $line, and $text \n"
                    "tags, which will be replaced by the file and line number from which the \n"
                    "warning originated and the warning text. Optionally the format may contain \n"
		    "$version, which will be replaced by the version of the file (if it could \n"
		    "be obtained via FILE_VERSION_FILTER)\n"
                   ); 
  cs->setDefaultValue("$file:$line: $text");
  cs = addString(
                    "WARN_LOGFILE",
                    "The WARN_LOGFILE tag can be used to specify a file to which warning \n"
                    "and error messages should be written. If left blank the output is written \n"
                    "to stderr. \n"
                   );
  cs->setWidgetType(ConfigString::File);
  //-----------------------------------------------------------------------------------------------
  addInfo(  "Input","configuration options related to the input files");
  //-----------------------------------------------------------------------------------------------
  cl = addList(
                    "INPUT",
                    "The INPUT tag can be used to specify the files and/or directories that contain \n"
                    "documented source files. You may enter file names like \"myfile.cpp\" or \n"
                    "directories like \"/usr/src/myproject\". Separate the files or directories \n"
                    "with spaces. \n"
                 );
  cl->setWidgetType(ConfigList::FileAndDir);
  cl = addList(
                    "FILE_PATTERNS",
                    "If the value of the INPUT tag contains directories, you can use the \n"
                    "FILE_PATTERNS tag to specify one or more wildcard pattern (like *.cpp \n"
                    "and *.h) to filter out the source-files in the directories. If left \n"
                    "blank the following patterns are tested: \n"
		    "*.c *.cc *.cxx *.cpp *.c++ *.java *.ii *.ixx *.ipp *.i++ *.inl *.h *.hh *.hxx \n"
		    "*.hpp *.h++ *.idl *.odl *.cs *.php *.php3 *.inc *.m *.mm *.py\n"
                 );
  cb = addBool(
                    "RECURSIVE",
                    "The RECURSIVE tag can be used to turn specify whether or not subdirectories \n"
                    "should be searched for input files as well. Possible values are YES and NO. \n"
                    "If left blank NO is used. \n",
                    FALSE
                 );
  cl = addList(
                    "EXCLUDE",
                    "The EXCLUDE tag can be used to specify files and/or directories that should \n"
                    "excluded from the INPUT source files. This way you can easily exclude a \n"
                    "subdirectory from a directory tree whose root is specified with the INPUT tag. \n"
                 );
  cb = addBool(
                    "EXCLUDE_SYMLINKS",
                    "The EXCLUDE_SYMLINKS tag can be used select whether or not files or \n"
		    "directories that are symbolic links (a Unix filesystem feature) are excluded \n"
		    "from the input. \n",
                    FALSE
                 );
  cl->setWidgetType(ConfigList::FileAndDir);
  cl = addList(
                    "EXCLUDE_PATTERNS",
                    "If the value of the INPUT tag contains directories, you can use the \n"
                    "EXCLUDE_PATTERNS tag to specify one or more wildcard patterns to exclude \n"
                    "certain files from those directories. Note that the wildcards are matched \n"
		    "against the file with absolute path, so to exclude all test directories \n"
		    "for example use the pattern */test/* \n"
                 );
  cl = addList(
                    "EXAMPLE_PATH",
                    "The EXAMPLE_PATH tag can be used to specify one or more files or \n"
                    "directories that contain example code fragments that are included (see \n"
                    "the \\include command). \n"
                 );
  cl->setWidgetType(ConfigList::Dir);
  cl = addList(
                    "EXAMPLE_PATTERNS",
                    "If the value of the EXAMPLE_PATH tag contains directories, you can use the \n"
                    "EXAMPLE_PATTERNS tag to specify one or more wildcard pattern (like *.cpp \n"
                    "and *.h) to filter out the source-files in the directories. If left \n"
                    "blank all files are included. \n"
                 );
  cb = addBool(
                    "EXAMPLE_RECURSIVE",
                    "If the EXAMPLE_RECURSIVE tag is set to YES then subdirectories will be \n"
                    "searched for input files to be used with the \\include or \\dontinclude \n"
                    "commands irrespective of the value of the RECURSIVE tag. \n"
                    "Possible values are YES and NO. If left blank NO is used. \n",
                    FALSE
                 );
  cl = addList(
                    "IMAGE_PATH",
                    "The IMAGE_PATH tag can be used to specify one or more files or \n"
                    "directories that contain image that are included in the documentation (see \n"
                    "the \\image command). \n"
                 );
  cl->setWidgetType(ConfigList::Dir);
  cs = addString(
                    "INPUT_FILTER",
                    "The INPUT_FILTER tag can be used to specify a program that doxygen should \n"
                    "invoke to filter for each input file. Doxygen will invoke the filter program \n"
                    "by executing (via popen()) the command <filter> <input-file>, where <filter> \n"
                    "is the value of the INPUT_FILTER tag, and <input-file> is the name of an \n"
                    "input file. Doxygen will then use the output that the filter program writes \n"
                    "to standard output.  If FILTER_PATTERNS is specified, this tag will be \n"
                    "ignored. \n"
                   );
  cs->setWidgetType(ConfigString::File);
  cl = addList(
                    "FILTER_PATTERNS",
                    "The FILTER_PATTERNS tag can be used to specify filters on a per file pattern \n"
                    "basis.  Doxygen will compare the file name with each pattern and apply the \n"
                    "filter if there is a match.  The filters are a list of the form: \n"
                    "pattern=filter (like *.cpp=my_cpp_filter). See INPUT_FILTER for further \n"
                    "info on how filters are used. If FILTER_PATTERNS is empty, INPUT_FILTER \n"
                    "is applied to all files. \n"
                   );
  cl->setWidgetType(ConfigList::File);
  cb = addBool(
                    "FILTER_SOURCE_FILES",
                    "If the FILTER_SOURCE_FILES tag is set to YES, the input filter (if set using \n"
                    "INPUT_FILTER) will be used to filter the input files when producing source \n"
                    "files to browse (i.e. when SOURCE_BROWSER is set to YES). \n",
                    FALSE
                );    
  //-----------------------------------------------------------------------------------------------
  addInfo(  "Source Browser","configuration options related to source browsing");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "SOURCE_BROWSER",
                    "If the SOURCE_BROWSER tag is set to YES then a list of source files will \n"
                    "be generated. Documented entities will be cross-referenced with these sources. \n"
		    "Note: To get rid of all source code in the generated output, make sure also \n"
		    "VERBATIM_HEADERS is set to NO. \n",
                    FALSE
                 );
  cb = addBool(
                    "INLINE_SOURCES",
                    "Setting the INLINE_SOURCES tag to YES will include the body \n"
                    "of functions and classes directly in the documentation. \n",
                    FALSE
                 );
  cb = addBool(
                    "STRIP_CODE_COMMENTS",
                    "Setting the STRIP_CODE_COMMENTS tag to YES (the default) will instruct \n"
                    "doxygen to hide any special comment blocks from generated source code \n"
                    "fragments. Normal C and C++ comments will always remain visible. \n",
                    TRUE
                 );
  cb = addBool(     "REFERENCED_BY_RELATION",
                    "If the REFERENCED_BY_RELATION tag is set to YES (the default) \n"
		    "then for each documented function all documented \n"
		    "functions referencing it will be listed. \n",
                    TRUE
              );
  cb->addDependency("SOURCE_BROWSER");
  cb = addBool(     "REFERENCES_RELATION",
                    "If the REFERENCES_RELATION tag is set to YES (the default) \n"
		    "then for each documented function all documented entities \n"
		    "called/used by that function will be listed. \n",
                    TRUE
              );
  cb->addDependency("SOURCE_BROWSER");
  cb = addBool(     "REFERENCES_LINK_SOURCE",
                    "If the REFERENCES_LINK_SOURCE tag is set to YES (the default)\n"
                    "and SOURCE_BROWSER tag is set to YES, then the hyperlinks from\n"
                    "functions in REFERENCES_RELATION and REFERENCED_BY_RELATION lists will\n"
                    "link to the source code.  Otherwise they will link to the documentstion.\n",
                    TRUE
              );
  cb->addDependency("SOURCE_BROWSER");
  cb = addBool(
                    "USE_HTAGS",
		    "If the USE_HTAGS tag is set to YES then the references to source code \n"
		    "will point to the HTML generated by the htags(1) tool instead of doxygen \n"
		    "built-in source browser. The htags tool is part of GNU's global source \n"
		    "tagging system (see http://www.gnu.org/software/global/global.html). You \n"
		    "will need version 4.8.6 or higher. \n",
		    FALSE
              );
  cb->addDependency("SOURCE_BROWSER");
  cb = addBool(
                    "VERBATIM_HEADERS",
                    "If the VERBATIM_HEADERS tag is set to YES (the default) then Doxygen \n"
                    "will generate a verbatim copy of the header file for each class for \n"
                    "which an include is specified. Set to NO to disable this. \n",
                    TRUE
              );
  
  //-----------------------------------------------------------------------------------------------
  addInfo(  "Index","configuration options related to the alphabetical class index");
  //-----------------------------------------------------------------------------------------------
  
  cb = addBool(
                    "ALPHABETICAL_INDEX",
                    "If the ALPHABETICAL_INDEX tag is set to YES, an alphabetical index \n"
                    "of all compounds will be generated. Enable this if the project \n"
                    "contains a lot of classes, structs, unions or interfaces. \n",
                    FALSE
                 );
  ci = addInt(
                    "COLS_IN_ALPHA_INDEX",
                    "If the alphabetical index is enabled (see ALPHABETICAL_INDEX) then \n"
                    "the COLS_IN_ALPHA_INDEX tag can be used to specify the number of columns \n"
                    "in which this list will be split (can be a number in the range [1..20]) \n",
                    1,20,5
                );
  cl = addList(
                    "IGNORE_PREFIX",
                    "In case all classes in a project start with a common prefix, all \n"
                    "classes will be put under the same header in the alphabetical index. \n"
                    "The IGNORE_PREFIX tag can be used to specify one or more prefixes that \n"
                    "should be ignored while generating the index headers. \n"
                 );
  //-----------------------------------------------------------------------------------------------
  addInfo(  "HTML","configuration options related to the HTML output");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "GENERATE_HTML",
                    "If the GENERATE_HTML tag is set to YES (the default) Doxygen will \n"
                    "generate HTML output. \n",
                    TRUE
                 );
  cs = addString(
                    "HTML_OUTPUT",
                    "The HTML_OUTPUT tag is used to specify where the HTML docs will be put. \n"
                    "If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
                    "put in front of it. If left blank `html' will be used as the default path. \n"
                   );
  cs->setDefaultValue("html");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_HTML");
  cs = addString(
                    "HTML_FILE_EXTENSION",
                    "The HTML_FILE_EXTENSION tag can be used to specify the file extension for \n"
                    "each generated HTML page (for example: .htm,.php,.asp). If it is left blank \n"
                    "doxygen will generate files with .html extension.\n"
                   );
  cs->setDefaultValue(".html");
  cs->addDependency("GENERATE_HTML");
  cs = addString(
                    "HTML_HEADER",
                    "The HTML_HEADER tag can be used to specify a personal HTML header for \n"
                    "each generated HTML page. If it is left blank doxygen will generate a \n"
                    "standard header.\n"
                   );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTML");
  cs = addString(
                    "HTML_FOOTER",
                    "The HTML_FOOTER tag can be used to specify a personal HTML footer for \n"
                    "each generated HTML page. If it is left blank doxygen will generate a \n"
                    "standard footer.\n"
                   );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTML");
  cs = addString(
                    "HTML_STYLESHEET",
                    "The HTML_STYLESHEET tag can be used to specify a user-defined cascading \n"
                    "style sheet that is used by each HTML page. It can be used to \n"
                    "fine-tune the look of the HTML output. If the tag is left blank doxygen \n"
                    "will generate a default style sheet. Note that doxygen will try to copy \n"
		    "the style sheet file to the HTML output directory, so don't put your own \n"
		    "stylesheet in the HTML output directory as well, or it will be erased! \n"
                   );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTML");
  cb = addBool( 
                    "HTML_ALIGN_MEMBERS",
                    "If the HTML_ALIGN_MEMBERS tag is set to YES, the members of classes, \n"
                    "files or namespaces will be aligned in HTML using tables. If set to \n"
                    "NO a bullet list will be used. \n",
                    TRUE
                 );
  cb->addDependency("GENERATE_HTML");
  cb = addBool(
                    "GENERATE_HTMLHELP",
                    "If the GENERATE_HTMLHELP tag is set to YES, additional index files \n"
                    "will be generated that can be used as input for tools like the \n"
                    "Microsoft HTML help workshop to generate a compressed HTML help file (.chm) \n"
                    "of the generated HTML documentation. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_HTML");
  cs = addString(
                    "CHM_FILE",
                    "If the GENERATE_HTMLHELP tag is set to YES, the CHM_FILE tag can \n"
                    "be used to specify the file name of the resulting .chm file. You \n"
		    "can add a path in front of the file if the result should not be \n"
		    "written to the html output directory. \n"
                   );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTML");
  cs = addString(
                    "HHC_LOCATION",
                    "If the GENERATE_HTMLHELP tag is set to YES, the HHC_LOCATION tag can \n"
                    "be used to specify the location (absolute path including file name) of \n"
		    "the HTML help compiler (hhc.exe). If non-empty doxygen will try to run \n"
		    "the HTML help compiler on the generated index.hhp.\n"
                   );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTML");
  cb = addBool(
                    "GENERATE_CHI",
                    "If the GENERATE_HTMLHELP tag is set to YES, the GENERATE_CHI flag \n"
                    "controls if a separate .chi index file is generated (YES) or that \n"
                    "it should be included in the master .chm file (NO).\n",
                    FALSE
                 );
  cb->addDependency("GENERATE_HTML");
  cb = addBool(
                    "BINARY_TOC",
                    "If the GENERATE_HTMLHELP tag is set to YES, the BINARY_TOC flag \n"
                    "controls whether a binary table of contents is generated (YES) or a \n"
                    "normal table of contents (NO) in the .chm file.\n",
                    FALSE
                 );
  cb->addDependency("GENERATE_HTML");
  cb = addBool(
                    "TOC_EXPAND",
                    "The TOC_EXPAND flag can be set to YES to add extra items for group members \n"
                    "to the contents of the HTML help documentation and to the tree view. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_HTML");
  cb = addBool(
                    "DISABLE_INDEX",
                    "The DISABLE_INDEX tag can be used to turn on/off the condensed index at \n"
                    "top of each HTML page. The value NO (the default) enables the index and \n"
                    "the value YES disables it. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_HTML");
  ci = addInt(
                    "ENUM_VALUES_PER_LINE",
                    "This tag can be used to set the number of enum values (range [1..20]) \n"
                    "that doxygen will group on one line in the generated HTML documentation. \n",
                    1,20,4
                );
  ci->addDependency("GENERATE_HTML");
  cb = addBool(
                    "GENERATE_TREEVIEW",
                    "If the GENERATE_TREEVIEW tag is set to YES, a side panel will be\n"
                    "generated containing a tree-like index structure (just like the one that \n"
                    "is generated for HTML Help). For this to work a browser that supports \n"
                    "JavaScript, DHTML, CSS and frames is required (for instance Mozilla 1.0+, \n"
		    "Netscape 6.0+, Internet explorer 5.0+, or Konqueror). Windows users are \n"
		    "probably better off using the HTML help feature. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_HTML");
  ci = addInt(
                    "TREEVIEW_WIDTH",
                    "If the treeview is enabled (see GENERATE_TREEVIEW) then this tag can be \n"
                    "used to set the initial width (in pixels) of the frame in which the tree \n"
                    "is shown. \n",
                    0,1500,250
                 );
  ci->addDependency("GENERATE_HTML");

  //-----------------------------------------------------------------------------------------------
  addInfo(  "LaTeX","configuration options related to the LaTeX output");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "GENERATE_LATEX",
                    "If the GENERATE_LATEX tag is set to YES (the default) Doxygen will \n"
                    "generate Latex output. \n",
                    TRUE
                 );
  cs = addString(
                    "LATEX_OUTPUT",
                    "The LATEX_OUTPUT tag is used to specify where the LaTeX docs will be put. \n"
                    "If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
                    "put in front of it. If left blank `latex' will be used as the default path. \n"
                   );
  cs->setDefaultValue("latex");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_LATEX");
  cs = addString(
                    "LATEX_CMD_NAME",
                    "The LATEX_CMD_NAME tag can be used to specify the LaTeX command name to be \n"
                    "invoked. If left blank `latex' will be used as the default command name. \n"
                   );
  cs->setDefaultValue("latex");
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_LATEX");
  cs = addString(
                    "MAKEINDEX_CMD_NAME",
                    "The MAKEINDEX_CMD_NAME tag can be used to specify the command name to \n"
		    "generate index for LaTeX. If left blank `makeindex' will be used as the \n"
		    "default command name. \n"
                   );
  cs->setDefaultValue("makeindex");
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_LATEX");
  cb = addBool(
                    "COMPACT_LATEX",
                    "If the COMPACT_LATEX tag is set to YES Doxygen generates more compact \n"
                    "LaTeX documents. This may be useful for small projects and may help to \n"
                    "save some trees in general. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_LATEX");
  ce = addEnum(
                    "PAPER_TYPE",
                    "The PAPER_TYPE tag can be used to set the paper type that is used \n"
                    "by the printer. Possible values are: a4, a4wide, letter, legal and \n"
                    "executive. If left blank a4wide will be used. \n",
                    "a4wide"
                   );
  ce->addValue("a4");
  ce->addValue("a4wide");
  ce->addValue("letter");
  ce->addValue("legal");
  ce->addValue("executive");
  ce->addDependency("GENERATE_LATEX");
  cl = addList(
                    "EXTRA_PACKAGES",
                    "The EXTRA_PACKAGES tag can be to specify one or more names of LaTeX \n"
                    "packages that should be included in the LaTeX output. \n"
                 );
  cl->addDependency("GENERATE_LATEX");
  cs = addString(
                    "LATEX_HEADER",
                    "The LATEX_HEADER tag can be used to specify a personal LaTeX header for \n"
                    "the generated latex document. The header should contain everything until \n"
                    "the first chapter. If it is left blank doxygen will generate a \n"
                    "standard header. Notice: only use this tag if you know what you are doing! \n"
                 );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_LATEX");
  cb = addBool(
                    "PDF_HYPERLINKS",
                    "If the PDF_HYPERLINKS tag is set to YES, the LaTeX that is generated \n"
                    "is prepared for conversion to pdf (using ps2pdf). The pdf file will \n"
                    "contain links (just like the HTML output) instead of page references \n"
                    "This makes the output suitable for online browsing using a pdf viewer. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_LATEX");
  cb = addBool(
                    "USE_PDFLATEX",
                    "If the USE_PDFLATEX tag is set to YES, pdflatex will be used instead of \n"
                    "plain latex in the generated Makefile. Set this option to YES to get a \n"
                    "higher quality PDF documentation. \n",
                    FALSE
                 );   
  cb->addDependency("GENERATE_LATEX");
  cb = addBool(
                    "LATEX_BATCHMODE",
                    "If the LATEX_BATCHMODE tag is set to YES, doxygen will add the \\\\batchmode. \n"
                    "command to the generated LaTeX files. This will instruct LaTeX to keep \n"
                    "running if errors occur, instead of asking the user for help. \n"
                    "This option is also used when generating formulas in HTML. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_LATEX");
  cb = addBool(
                    "LATEX_HIDE_INDICES",
                    "If LATEX_HIDE_INDICES is set to YES then doxygen will not \n"
                    "include the index chapters (such as File Index, Compound Index, etc.) \n"
                    "in the output. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_LATEX");
  //-----------------------------------------------------------------------------------------------
  addInfo(  "RTF","configuration options related to the RTF output");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "GENERATE_RTF",
                    "If the GENERATE_RTF tag is set to YES Doxygen will generate RTF output \n"
                    "The RTF output is optimized for Word 97 and may not look very pretty with \n"
                    "other RTF readers or editors.\n",
                    FALSE
                 );
  cs = addString(
                    "RTF_OUTPUT",
                    "The RTF_OUTPUT tag is used to specify where the RTF docs will be put. \n"
                    "If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
                    "put in front of it. If left blank `rtf' will be used as the default path. \n"
                 );
  cs->setDefaultValue("rtf");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_RTF");
  cb = addBool(
                    "COMPACT_RTF",
                    "If the COMPACT_RTF tag is set to YES Doxygen generates more compact \n"
                    "RTF documents. This may be useful for small projects and may help to \n"
                    "save some trees in general. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_RTF");
  cb = addBool(
                    "RTF_HYPERLINKS",
                    "If the RTF_HYPERLINKS tag is set to YES, the RTF that is generated \n"
                    "will contain hyperlink fields. The RTF file will \n"
                    "contain links (just like the HTML output) instead of page references. \n"
                    "This makes the output suitable for online browsing using WORD or other \n"
                    "programs which support those fields. \n"
                    "Note: wordpad (write) and others do not support links. \n",
                    FALSE
                 );
  cb->addDependency("GENERATE_RTF");
  cs = addString(
                    "RTF_STYLESHEET_FILE",
                    "Load stylesheet definitions from file. Syntax is similar to doxygen's \n"
                    "config file, i.e. a series of assignments. You only have to provide \n"
                    "replacements, missing definitions are set to their default value. \n"
                   );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_RTF");
  cs = addString(
                    "RTF_EXTENSIONS_FILE",
                    "Set optional variables used in the generation of an rtf document. \n"
                    "Syntax is similar to doxygen's config file.\n"
                );                  
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_RTF");

  //-----------------------------------------------------------------------------------------------
  addInfo(  "Man","configuration options related to the man page output");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "GENERATE_MAN",
                    "If the GENERATE_MAN tag is set to YES (the default) Doxygen will \n"
                    "generate man pages \n",
                    FALSE
                   );
  cs = addString(
                    "MAN_OUTPUT",
                    "The MAN_OUTPUT tag is used to specify where the man pages will be put. \n"
                    "If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
                    "put in front of it. If left blank `man' will be used as the default path. \n"
                   );
  cs->setDefaultValue("man");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_MAN");
  cs = addString(
                    "MAN_EXTENSION",
                    "The MAN_EXTENSION tag determines the extension that is added to \n"
                    "the generated man pages (default is the subroutine's section .3) \n"
                   );
  cs->setDefaultValue(".3");
  cs->addDependency("GENERATE_MAN");
  cb = addBool(
                    "MAN_LINKS",
                    "If the MAN_LINKS tag is set to YES and Doxygen generates man output, \n"
                    "then it will generate one additional man file for each entity \n"
                    "documented in the real man page(s). These additional files \n"
                    "only source the real man page, but without them the man command \n"
                    "would be unable to find the correct page. The default is NO. \n",
                    FALSE
                   );
  cb->addDependency("GENERATE_MAN");
  //-----------------------------------------------------------------------------------------------
  addInfo(  "XML","configuration options related to the XML output");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(  
                    "GENERATE_XML",
                    "If the GENERATE_XML tag is set to YES Doxygen will \n"
                    "generate an XML file that captures the structure of \n"
                    "the code including all documentation. \n",
		    FALSE
                 );
  cs = addString(
                    "XML_OUTPUT",
                    "The XML_OUTPUT tag is used to specify where the XML pages will be put. \n"
                    "If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
                    "put in front of it. If left blank `xml' will be used as the default path. \n"
                   );
  cs->setDefaultValue("xml");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_XML");
  cs = addString(
                    "XML_SCHEMA",
		    "The XML_SCHEMA tag can be used to specify an XML schema, \n"
		    "which can be used by a validating XML parser to check the \n"
		    "syntax of the XML files. \n"
                 );
  cs->addDependency("GENERATE_XML");
  cs = addString(
                    "XML_DTD",
		    "The XML_DTD tag can be used to specify an XML DTD, \n"
		    "which can be used by a validating XML parser to check the \n"
		    "syntax of the XML files. \n"
                 );
  cs->addDependency("GENERATE_XML");
  cb = addBool(
                    "XML_PROGRAMLISTING",
                    "If the XML_PROGRAMLISTING tag is set to YES Doxygen will \n"
                    "dump the program listings (including syntax highlighting \n"
		    "and cross-referencing information) to the XML output. Note that \n"
		    "enabling this will significantly increase the size of the XML output. \n",
                    TRUE
                 );
  cb->addDependency("GENERATE_XML");

  //--------------------------------------------------------------------------
  addInfo(  "DEF","configuration options for the AutoGen Definitions output");
  //--------------------------------------------------------------------------
  cb = addBool("GENERATE_AUTOGEN_DEF",

               "If the GENERATE_AUTOGEN_DEF tag is set to YES Doxygen will \n"
               "generate an AutoGen Definitions (see autogen.sf.net) file \n"
	       "that captures the structure of the code including all \n"
	       "documentation. Note that this feature is still experimental \n"
	       "and incomplete at the moment. \n",

               FALSE );
  //-----------------------------------------------------------------------------------------------
  addInfo(  "PerlMod","configuration options related to the Perl module output");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(  
                    "GENERATE_PERLMOD",
                    "If the GENERATE_PERLMOD tag is set to YES Doxygen will \n"
                    "generate a Perl module file that captures the structure of \n"
                    "the code including all documentation. Note that this \n"
		    "feature is still experimental and incomplete at the \n"
		    "moment. \n",
		    FALSE
                 );
  cb = addBool(  
                    "PERLMOD_LATEX",
                    "If the PERLMOD_LATEX tag is set to YES Doxygen will generate \n"
                    "the necessary Makefile rules, Perl scripts and LaTeX code to be able \n"
		    "to generate PDF and DVI output from the Perl module output. \n",
		    FALSE
                 );
  cb->addDependency("GENERATE_PERLMOD");
  cb = addBool(  
                    "PERLMOD_PRETTY",
                    "If the PERLMOD_PRETTY tag is set to YES the Perl module output will be \n"
		    "nicely formatted so it can be parsed by a human reader.  This is useful \n"
		    "if you want to understand what is going on.  On the other hand, if this \n"
		    "tag is set to NO the size of the Perl module output will be much smaller \n"
		    "and Perl will parse it just the same. \n",
		    TRUE
                 );
  cb->addDependency("GENERATE_PERLMOD");
  cs = addString(  
                    "PERLMOD_MAKEVAR_PREFIX",
                    "The names of the make variables in the generated doxyrules.make file \n"
                    "are prefixed with the string contained in PERLMOD_MAKEVAR_PREFIX. \n"
		    "This is useful so different doxyrules.make files included by the same \n"
		    "Makefile don't overwrite each other's variables."
                 );
  cs->addDependency("GENERATE_PERLMOD");

  //-----------------------------------------------------------------------------------------------
  addInfo(  "Preprocessor","Configuration options related to the preprocessor   ");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "ENABLE_PREPROCESSING",
                    "If the ENABLE_PREPROCESSING tag is set to YES (the default) Doxygen will \n"
                    "evaluate all C-preprocessor directives found in the sources and include \n"
                    "files. \n",
                    TRUE
                 );
  cb = addBool(
                    "MACRO_EXPANSION",
                    "If the MACRO_EXPANSION tag is set to YES Doxygen will expand all macro \n"
                    "names in the source code. If set to NO (the default) only conditional \n"
                    "compilation will be performed. Macro expansion can be done in a controlled \n"
                    "way by setting EXPAND_ONLY_PREDEF to YES. \n",
                    FALSE
                 );
  cb->addDependency("ENABLE_PREPROCESSING");
  cb = addBool(
                    "EXPAND_ONLY_PREDEF",
                    "If the EXPAND_ONLY_PREDEF and MACRO_EXPANSION tags are both set to YES \n"
                    "then the macro expansion is limited to the macros specified with the \n"
                    "PREDEFINED and EXPAND_AS_DEFINED tags. \n",
                    FALSE
                 );
  cb->addDependency("ENABLE_PREPROCESSING");
  cb = addBool(
                    "SEARCH_INCLUDES",
                    "If the SEARCH_INCLUDES tag is set to YES (the default) the includes files \n"
                    "in the INCLUDE_PATH (see below) will be search if a #include is found. \n",
                    TRUE
                 );
  cb->addDependency("ENABLE_PREPROCESSING");
  cl = addList(
                    "INCLUDE_PATH",
                    "The INCLUDE_PATH tag can be used to specify one or more directories that \n"
                    "contain include files that are not input files but should be processed by \n"
                    "the preprocessor.\n"
                 );
  cl->setWidgetType(ConfigList::Dir);
  cl->addDependency("ENABLE_PREPROCESSING");
  cl = addList(
                    "INCLUDE_FILE_PATTERNS",
                    "You can use the INCLUDE_FILE_PATTERNS tag to specify one or more wildcard \n"
                    "patterns (like *.h and *.hpp) to filter out the header-files in the \n"
                    "directories. If left blank, the patterns specified with FILE_PATTERNS will \n"
                    "be used. \n"
                 );
  cl->addDependency("ENABLE_PREPROCESSING");
  cl = addList(
                    "PREDEFINED",
                    "The PREDEFINED tag can be used to specify one or more macro names that \n"
                    "are defined before the preprocessor is started (similar to the -D option of \n"
                    "gcc). The argument of the tag is a list of macros of the form: name \n"
                    "or name=definition (no spaces). If the definition and the = are \n"
                    "omitted =1 is assumed. To prevent a macro definition from being \n"
		    "undefined via #undef or recursively expanded use the := operator \n"
		    "instead of the = operator.\n"
                 );
  cl->addDependency("ENABLE_PREPROCESSING");
  cl = addList(
                    "EXPAND_AS_DEFINED",
                    "If the MACRO_EXPANSION and EXPAND_ONLY_PREDEF tags are set to YES then \n"
                    "this tag can be used to specify a list of macro names that should be expanded. \n"
                    "The macro definition that is found in the sources will be used. \n"
                    "Use the PREDEFINED tag if you want to use a different macro definition. \n" 
                 );
  cl->addDependency("ENABLE_PREPROCESSING");
  cb = addBool(
                    "SKIP_FUNCTION_MACROS",
                    "If the SKIP_FUNCTION_MACROS tag is set to YES (the default) then \n"
		    "doxygen's preprocessor will remove all function-like macros that are alone \n"
		    "on a line, have an all uppercase name, and do not end with a semicolon. Such \n"
		    "function macros are typically used for boiler-plate code, and will confuse \n"
		    "the parser if not removed. \n",
                    TRUE
                 );
  cb->addDependency("ENABLE_PREPROCESSING");
  //-----------------------------------------------------------------------------------------------
  addInfo(  "External","Configuration::additions related to external references   ");
  //-----------------------------------------------------------------------------------------------
  cl = addList(
                    "TAGFILES",
                    "The TAGFILES option can be used to specify one or more tagfiles. \n"
		    "Optionally an initial location of the external documentation \n"
		    "can be added for each tagfile. The format of a tag file without \n"
		    "this location is as follows: \n"
		    "  TAGFILES = file1 file2 ... \n" 
		    "Adding location for the tag files is done as follows: \n"
		    "  TAGFILES = file1=loc1 \"file2 = loc2\" ... \n"
	            "where \"loc1\" and \"loc2\" can be relative or absolute paths or \n"
		    "URLs. If a location is present for each tag, the installdox tool \n"
		    "does not have to be run to correct the links.\n"
		    "Note that each tag file must have a unique name\n"
		    "(where the name does NOT include the path)\n"
	            "If a tag file is not located in the directory in which doxygen \n"
	            "is run, you must also specify the path to the tagfile here. \n"
               );
  cl->setWidgetType(ConfigList::File);
  cs = addString(
                    "GENERATE_TAGFILE",
                    "When a file name is specified after GENERATE_TAGFILE, doxygen will create \n"
                    "a tag file that is based on the input files it reads. \n"
                   );
  cs->setWidgetType(ConfigString::File);
  cb = addBool(
                    "ALLEXTERNALS",
                    "If the ALLEXTERNALS tag is set to YES all external classes will be listed \n"
                    "in the class index. If set to NO only the inherited external classes \n"
                    "will be listed. \n",
                    FALSE
                 );
  cb = addBool(
                    "EXTERNAL_GROUPS",
                    "If the EXTERNAL_GROUPS tag is set to YES all external groups will be listed \n"
                    "in the modules index. If set to NO, only the current project's groups will \n"
                    "be listed. \n",
                    TRUE
                 );
  cs = addString(
                    "PERL_PATH",
                    "The PERL_PATH should be the absolute path and name of the perl script \n"
                    "interpreter (i.e. the result of `which perl'). \n"
                   );
  cs->setDefaultValue("/usr/bin/perl");
  cs->setWidgetType(ConfigString::Dir);

  //-----------------------------------------------------------------------------------------------
  addInfo(  "Dot","Configuration options related to the dot tool   ");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "CLASS_DIAGRAMS",
                    "If the CLASS_DIAGRAMS tag is set to YES (the default) Doxygen will \n"
                    "generate a inheritance diagram (in HTML, RTF and LaTeX) for classes with base \n"
		    "or super classes. Setting the tag to NO turns the diagrams off. Note that \n"
		    "this option is superseded by the HAVE_DOT option below. This is only a \n"
		    "fallback. It is recommended to install and use dot, since it yields more \n"
		    "powerful graphs. \n",
                    TRUE
                 );
  cb = addBool(
                    "HIDE_UNDOC_RELATIONS",
		    "If set to YES, the inheritance and collaboration graphs will hide \n"
		    "inheritance and usage relations if the target is undocumented \n"
		    "or is not a class. \n",
                    TRUE
                 );
  cb = addBool(
                    "HAVE_DOT",
                    "If you set the HAVE_DOT tag to YES then doxygen will assume the dot tool is \n"
                    "available from the path. This tool is part of Graphviz, a graph visualization \n"
                    "toolkit from AT&T and Lucent Bell Labs. The other options in this section \n"
                    "have no effect if this option is set to NO (the default) \n",
                    FALSE
                 );
  cb = addBool(
                    "CLASS_GRAPH",
                    "If the CLASS_GRAPH and HAVE_DOT tags are set to YES then doxygen \n"
                    "will generate a graph for each documented class showing the direct and \n"
                    "indirect inheritance relations. Setting this tag to YES will force the \n"
                    "the CLASS_DIAGRAMS tag to NO.\n",
                    TRUE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "COLLABORATION_GRAPH",
                    "If the COLLABORATION_GRAPH and HAVE_DOT tags are set to YES then doxygen \n"
                    "will generate a graph for each documented class showing the direct and \n"
                    "indirect implementation dependencies (inheritance, containment, and \n"
                    "class references variables) of the class with other documented classes. \n",
                    TRUE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "GROUP_GRAPHS",
                    "If the GROUP_GRAPHS and HAVE_DOT tags are set to YES then doxygen \n"
                    "will generate a graph for groups, showing the direct groups dependencies\n",
                    TRUE
                 );                 
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "UML_LOOK",
                    "If the UML_LOOK tag is set to YES doxygen will generate inheritance and \n"
	            "collaboration diagrams in a style similar to the OMG's Unified Modeling \n"
		    "Language. \n",
	            FALSE
	      );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "TEMPLATE_RELATIONS",
		    "If set to YES, the inheritance and collaboration graphs will show the \n"
		    "relations between templates and their instances. \n",
                    FALSE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "INCLUDE_GRAPH",
                    "If the ENABLE_PREPROCESSING, SEARCH_INCLUDES, INCLUDE_GRAPH, and HAVE_DOT \n"
                    "tags are set to YES then doxygen will generate a graph for each documented \n"
                    "file showing the direct and indirect include dependencies of the file with \n"
                    "other documented files. \n",
                    TRUE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "INCLUDED_BY_GRAPH",
                    "If the ENABLE_PREPROCESSING, SEARCH_INCLUDES, INCLUDED_BY_GRAPH, and \n"
                    "HAVE_DOT tags are set to YES then doxygen will generate a graph for each \n"
                    "documented header file showing the documented files that directly or \n"
                    "indirectly include this file. \n",
                    TRUE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "CALL_GRAPH",
                    "If the CALL_GRAPH and HAVE_DOT tags are set to YES then doxygen will \n"
		    "generate a call dependency graph for every global function or class method. \n"
                    "Note that enabling this option will significantly increase the time of a run. \n"
		    "So in most cases it will be better to enable call graphs for selected \n"
		    "functions only using the \\callgraph command.\n",
                    FALSE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "CALLER_GRAPH",
                    "If the CALLER_GRAPH and HAVE_DOT tags are set to YES then doxygen will \n"
		    "generate a caller dependency graph for every global function or class method. \n"
                    "Note that enabling this option will significantly increase the time of a run. \n"
		    "So in most cases it will be better to enable caller graphs for selected \n"
		    "functions only using the \\callergraph command.\n",
                    FALSE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "GRAPHICAL_HIERARCHY",
                    "If the GRAPHICAL_HIERARCHY and HAVE_DOT tags are set to YES then doxygen \n"
                    "will graphical hierarchy of all classes instead of a textual one. \n",
                    TRUE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(    
                    "DIRECTORY_GRAPH",
		    "If the DIRECTORY_GRAPH, SHOW_DIRECTORIES and HAVE_DOT tags are set to YES \n"
		    "then doxygen will show the dependencies a directory has on other directories \n"
		    "in a graphical way. The dependency relations are determined by the #include\n"
		    "relations between the files in the directories.\n",
                    TRUE
               );
  cb->addDependency("HAVE_DOT");
  ce = addEnum(
                    "DOT_IMAGE_FORMAT",
                    "The DOT_IMAGE_FORMAT tag can be used to set the image format of the images \n"
		    "generated by dot. Possible values are png, jpg, or gif\n"
                    "If left blank png will be used. \n",
                    "png"
                   );
  ce->addValue("png");
  ce->addValue("jpg");
  ce->addValue("gif");
  ce->addDependency("HAVE_DOT");
  cs = addString(
                    "DOT_PATH",
                    "The tag DOT_PATH can be used to specify the path where the dot tool can be \n"
                    "found. If left blank, it is assumed the dot tool can be found in the path. \n"
                   );
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("HAVE_DOT");
  cl = addList(
                    "DOTFILE_DIRS",
                    "The DOTFILE_DIRS tag can be used to specify one or more directories that \n"
		    "contain dot files that are included in the documentation (see the \n"
                    "\\dotfile command). \n"
                 );
  cl->setWidgetType(ConfigList::Dir);
  cl->addDependency("HAVE_DOT");
  ci = addInt(
                    "MAX_DOT_GRAPH_WIDTH",
                    "The MAX_DOT_GRAPH_WIDTH tag can be used to set the maximum allowed width \n"
                    "(in pixels) of the graphs generated by dot. If a graph becomes larger than \n"
                    "this value, doxygen will try to truncate the graph, so that it fits within \n"
                    "the specified constraint. Beware that most browsers cannot cope with very \n"
                    "large images. \n",
                    100,30000, 1024
                );
  ci->addDependency("HAVE_DOT");
  ci = addInt(
                    "MAX_DOT_GRAPH_HEIGHT",
                    "The MAX_DOT_GRAPH_HEIGHT tag can be used to set the maximum allows height \n"
                    "(in pixels) of the graphs generated by dot. If a graph becomes larger than \n"
                    "this value, doxygen will try to truncate the graph, so that it fits within \n"
                    "the specified constraint. Beware that most browsers cannot cope with very \n"
                    "large images. \n",
                    100,30000,1024
                );
  ci = addInt(
                    "MAX_DOT_GRAPH_DEPTH",
                    "The MAX_DOT_GRAPH_DEPTH tag can be used to set the maximum depth of the \n"
                    "graphs generated by dot. A depth value of 3 means that only nodes reachable \n"
                    "from the root by following a path via at most 3 edges will be shown. Nodes \n"
		    "that lay further from the root node will be omitted. Note that setting this \n"
		    "option to 1 or 2 may greatly reduce the computation time needed for large \n"
		    "code bases. Also note that a graph may be further truncated if the graph's \n"
		    "image dimensions are not sufficient to fit the graph (see MAX_DOT_GRAPH_WIDTH \n"
		    "and MAX_DOT_GRAPH_HEIGHT). If 0 is used for the depth value (the default), \n"
		    "the graph is not depth-constrained. \n",
                    0,1000,0
                );
  ci->addDependency("HAVE_DOT");
  cb = addBool(
                    "DOT_TRANSPARENT",
		    "Set the DOT_TRANSPARENT tag to YES to generate images with a transparent \n"
		    "background. This is disabled by default, which results in a white background. \n"
		    "Warning: Depending on the platform used, enabling this option may lead to \n"
		    "badly anti-aliased labels on the edges of a graph (i.e. they become hard to \n"
		    "read). \n",
		    FALSE
              );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "DOT_MULTI_TARGETS",
		    "Set the DOT_MULTI_TARGETS tag to YES allow dot to generate multiple output \n"
		    "files in one run (i.e. multiple -o and -T options on the command line). This \n"
		    "makes dot run faster, but since only newer versions of dot (>1.8.10) \n"
		    "support this, this feature is disabled by default. \n",
		    FALSE
              );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "GENERATE_LEGEND",
                    "If the GENERATE_LEGEND tag is set to YES (the default) Doxygen will \n"
                    "generate a legend page explaining the meaning of the various boxes and \n"
                    "arrows in the dot generated graphs. \n",
                    TRUE
                 );
  cb->addDependency("HAVE_DOT");
  cb = addBool(
                    "DOT_CLEANUP",
                    "If the DOT_CLEANUP tag is set to YES (the default) Doxygen will \n"
                    "remove the intermediate dot files that are used to generate \n"
                    "the various graphs. \n",
                    TRUE
                 );
  cb->addDependency("HAVE_DOT");

  //-----------------------------------------------------------------------------------------------
  addInfo(  "Search","Configuration::additions related to the search engine   ");
  //-----------------------------------------------------------------------------------------------
  cb = addBool(
                    "SEARCHENGINE",
                    "The SEARCHENGINE tag specifies whether or not a search engine should be \n"
                    "used. If set to NO the values of all tags below this one will be ignored. \n",
                    FALSE
                 );
  addObsolete("CGI_NAME");
  addObsolete("CGI_URL");
  addObsolete("DOC_URL");
  addObsolete("DOC_ABSPATH");
  addObsolete("BIN_ABSPATH");
  addObsolete("EXT_DOC_PATHS");

  // The IMAGE_PATTERNS tag is now officially obsolete.
}

static QCString configFileToString(const char *name)
{
  if (name==0 || name[0]==0) return 0;
  QFile f;

  bool fileOpened=FALSE;
  if (name[0]=='-' && name[1]==0) // read from stdin
  {
    fileOpened=f.open(IO_ReadOnly,stdin);
    if (fileOpened)
    {
      const int bSize=4096;
      QCString contents(bSize);
      int totalSize=0;
      int size;
      while ((size=f.readBlock(contents.data()+totalSize,bSize))==bSize)
      {
        totalSize+=bSize;
        contents.resize(totalSize+bSize); 
      }
      totalSize+=size+2;
      contents.resize(totalSize);
      contents.at(totalSize-2)='\n'; // to help the scanner
      contents.at(totalSize-1)='\0';
      return contents;
    }
  }
  else // read from file
  {
    QFileInfo fi(name);
    if (!fi.exists() || !fi.isFile())
    {
      config_err("Error: file `%s' not found\n",name);
      return "";
    }
      f.setName(name);
      fileOpened=f.open(IO_ReadOnly);
      if (fileOpened)
      {
        int fsize=f.size();
        QCString contents(fsize+2);
        f.readBlock(contents.data(),fsize);
        f.close();
        if (fsize==0 || contents[fsize-1]=='\n') 
          contents[fsize]='\0';
        else
          contents[fsize]='\n'; // to help the scanner
        contents[fsize+1]='\0';
        return contents;
      }
  }
  if (!fileOpened)  
  {
    config_err("Error: cannot open file `%s' for reading\n",name);
  }
  return "";
}

bool Config::parseString(const char *fn,const char *str)
{
  config = Config::instance();
  inputString   = str;
  inputPosition = 0;
  yyFileName    = fn;
  yyLineNr      = 1;
  includeStack.setAutoDelete(TRUE);
  includeStack.clear();
  includeDepth  = 0;
  configYYrestart( configYYin );
  BEGIN( Start );
  configYYlex();
  inputString = 0;
  return TRUE;
}

bool Config::parse(const char *fn)
{
  return parseString(fn,configFileToString(fn)); 
}

extern "C" { // some bogus code to keep the compiler happy
  //int  configYYwrap() { return 1 ; }
}

