package JIRA::API::SharePermissionInputBean 0.01;
# DO NOT EDIT! This is an autogenerated file.
use 5.020;
use Moo 2;
use experimental 'signatures';
use Types::Standard qw(Str Bool Num Int Object ArrayRef);
use MooX::TypeTiny;

=head1 NAME

JIRA::API::SharePermissionInputBean -

=head1 SYNOPSIS

  my $obj = JIRA::API::SharePermissionInputBean->new();
  ...

=cut

sub as_hash( $self ) {
    return { $self->%* }
}

=head1 PROPERTIES

=head2 C<< accountId >>

The user account ID that the filter is shared with. For a request, specify the `accountId` property for the user.

=cut

has 'accountId' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< groupId >>

The ID of the group, which uniquely identifies the group across all Atlassian products.For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*. Cannot be provided with `groupname`.

=cut

has 'groupId' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< groupname >>

The name of the group to share the filter with. Set `type` to `group`. Please note that the name of a group is mutable, to reliably identify a group use `groupId`.

=cut

has 'groupname' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< projectId >>

The ID of the project to share the filter with. Set `type` to `project`.

=cut

has 'projectId' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< projectRoleId >>

The ID of the project role to share the filter with. Set `type` to `projectRole` and the `projectId` for the project that the role is in.

=cut

has 'projectRoleId' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< rights >>

The rights for the share permission.

=cut

has 'rights' => (
    is       => 'ro',
    isa      => Int,
);

=head2 C<< type >>

The type of the share permission.Specify the type as follows:

 *  `user` Share with a user.
 *  `group` Share with a group. Specify `groupname` as well.
 *  `project` Share with a project. Specify `projectId` as well.
 *  `projectRole` Share with a project role in a project. Specify `projectId` and `projectRoleId` as well.
 *  `global` Share globally, including anonymous users. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.
 *  `authenticated` Share with all logged-in users. This shows as `loggedin` in the response. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.

=cut

has 'type' => (
    is       => 'ro',
    isa      => Str,
    required => 1,
);


1;
