# Generated by default/object.tt
package Paws::MediaLive::InputPrepareScheduleActionSettings;
  use Moose;
  has InputAttachmentNameReference => (is => 'ro', isa => 'Str', request_name => 'inputAttachmentNameReference', traits => ['NameInRequest']);
  has InputClippingSettings => (is => 'ro', isa => 'Paws::MediaLive::InputClippingSettings', request_name => 'inputClippingSettings', traits => ['NameInRequest']);
  has UrlPath => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'urlPath', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::InputPrepareScheduleActionSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::InputPrepareScheduleActionSettings object:

  $service_obj->Method(Att1 => { InputAttachmentNameReference => $value, ..., UrlPath => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::InputPrepareScheduleActionSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->InputAttachmentNameReference

=head1 DESCRIPTION

Action to prepare an input for a future immediate input switch.

=head1 ATTRIBUTES


=head2 InputAttachmentNameReference => Str

The name of the input attachment that should be prepared by this
action. If no name is provided, the action will stop the most recent
prepare (if any) when activated.


=head2 InputClippingSettings => L<Paws::MediaLive::InputClippingSettings>

Settings to let you create a clip of the file input, in order to set up
the input to ingest only a portion of the file.


=head2 UrlPath => ArrayRef[Str|Undef]

The value for the variable portion of the URL for the dynamic input,
for this instance of the input. Each time you use the same dynamic
input in an input switch action, you can provide a different value, in
order to connect the input to a different content source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

