/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Magma;
import net.sourceforge.plantuml.cucadiagram.SquareLinker;
import net.sourceforge.plantuml.cucadiagram.SquareMaker;

class MagmaList {
    private final List<Magma> all = new ArrayList<Magma>();

    MagmaList() {
    }

    public void add(Magma magma) {
        this.all.add(magma);
    }

    public MagmaList getMagmas(IGroup iGroup) {
        MagmaList magmaList = new MagmaList();
        for (Magma magma : this.all) {
            if (magma.getContainer() != iGroup) continue;
            magmaList.add(magma);
        }
        return magmaList;
    }

    public int size() {
        return this.all.size();
    }

    public void putInSquare() {
        SquareLinker<Magma> squareLinker = new SquareLinker<Magma>(){

            @Override
            public void topDown(Magma magma, Magma magma2) {
                magma.linkToDown(magma2);
            }

            @Override
            public void leftRight(Magma magma, Magma magma2) {
                magma.linkToRight(magma2);
            }
        };
        new SquareMaker<Magma>().putInSquare(this.all, squareLinker);
    }
}

