# Generated by default/object.tt
package Paws::ImageBuilder::SystemsManagerAgent;
  use Moose;
  has UninstallAfterBuild => (is => 'ro', isa => 'Bool', request_name => 'uninstallAfterBuild', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ImageBuilder::SystemsManagerAgent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ImageBuilder::SystemsManagerAgent object:

  $service_obj->Method(Att1 => { UninstallAfterBuild => $value, ..., UninstallAfterBuild => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ImageBuilder::SystemsManagerAgent object:

  $result = $service_obj->Method(...);
  $result->Att1->UninstallAfterBuild

=head1 DESCRIPTION

Contains settings for the SSM agent on your build instance.

=head1 ATTRIBUTES


=head2 UninstallAfterBuild => Bool

This property defaults to true. If Image Builder installs the SSM agent
on a build instance, it removes the agent before creating a snapshot
for the AMI. To ensure that the AMI you create includes the SSM agent,
set this property to false.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ImageBuilder>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

