#!perl -T

use 5.006;
use strict;
use warnings;

use Test::More tests => 4 * 441;
use Math::AnyNum qw(kronecker);

my @data = split(' ', <<'EOT');
0 -1 0 -1 0 0 0 1 0 -1 0 1 0 -1 0 0 0 1 0 1 0
-1 0 -1 1 0 -1 -1 0 -1 -1 0 1 1 0 1 1 0 -1 1 0 1
0 -1 0 1 0 1 0 -1 0 -1 0 1 0 1 0 -1 0 -1 0 1 0
1 -1 -1 0 1 1 -1 1 -1 -1 0 1 1 -1 1 -1 -1 0 1 1 -1
0 0 0 -1 0 -1 0 0 0 -1 0 1 0 0 0 1 0 1 0 0 0
0 -1 1 -1 1 0 -1 -1 1 -1 0 1 -1 1 1 0 -1 1 -1 1 0
0 -1 0 1 0 -1 0 1 0 -1 0 1 0 -1 0 1 0 -1 0 1 0
-1 0 1 -1 0 1 -1 0 1 -1 0 1 -1 0 1 -1 0 1 -1 0 1
0 -1 0 1 0 1 0 -1 0 -1 0 1 0 1 0 -1 0 -1 0 1 0
-1 -1 -1 1 1 -1 -1 1 -1 -1 1 1 1 -1 1 1 -1 -1 1 1 1
0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
0 1 0 1 0 -1 0 -1 0 1 0 1 0 -1 0 -1 0 1 0 1 0
1 0 -1 -1 0 -1 1 0 -1 1 0 1 -1 0 1 -1 0 -1 -1 0 1
0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0
0 1 -1 -1 1 0 1 -1 -1 1 0 1 -1 -1 1 0 1 -1 -1 1 0
0 0 0 -1 0 1 0 0 0 1 0 1 0 0 0 1 0 -1 0 0 0
-1 1 1 0 1 -1 1 1 1 1 0 1 1 1 1 -1 1 0 1 1 -1
0 1 0 1 0 -1 0 -1 0 1 0 1 0 -1 0 -1 0 1 0 1 0
1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1
0 1 0 -1 0 0 0 1 0 1 0 1 0 1 0 0 0 -1 0 1 0
EOT

foreach my $n (-10 .. 10) {
    foreach my $k (-10 .. 10) {

        my $sym = shift(@data);

        is(kronecker($n,                    $k),                    $sym, "kronecker($n, $k)");
        is(kronecker($n,                    Math::AnyNum->new($k)), $sym, "kronecker($n, $k)");
        is(kronecker(Math::AnyNum->new($n), $k),                    $sym, "kronecker($n, $k)");
        is(kronecker(Math::AnyNum->new($n), Math::AnyNum->new($k)), $sym, "kronecker($n, $k)");
    }
}
