// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +f -target-feature +d -target-feature +experimental-v \
// RUN:   -disable-O0-optnone -emit-llvm %s -o - | opt -S -mem2reg | FileCheck --check-prefix=CHECK-RV64 %s

#include <riscv_vector.h>

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i8.nxv1i8.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8mf8(int8_t *base, vuint8mf8_t bindex, vint8mf8_t value,
                          size_t vl) {
  return vsuxei8_v_i8mf8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i8.nxv2i8.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8mf4(int8_t *base, vuint8mf4_t bindex, vint8mf4_t value,
                          size_t vl) {
  return vsuxei8_v_i8mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i8.nxv4i8.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8mf2(int8_t *base, vuint8mf2_t bindex, vint8mf2_t value,
                          size_t vl) {
  return vsuxei8_v_i8mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i8.nxv8i8.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8m1(int8_t *base, vuint8m1_t bindex, vint8m1_t value,
                         size_t vl) {
  return vsuxei8_v_i8m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i8.nxv16i8.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8m2(int8_t *base, vuint8m2_t bindex, vint8m2_t value,
                         size_t vl) {
  return vsuxei8_v_i8m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 32 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv32i8.nxv32i8.i64(<vscale x 32 x i8> [[VALUE:%.*]], <vscale x 32 x i8>* [[TMP0]], <vscale x 32 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8m4(int8_t *base, vuint8m4_t bindex, vint8m4_t value,
                         size_t vl) {
  return vsuxei8_v_i8m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 64 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv64i8.nxv64i8.i64(<vscale x 64 x i8> [[VALUE:%.*]], <vscale x 64 x i8>* [[TMP0]], <vscale x 64 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8m8(int8_t *base, vuint8m8_t bindex, vint8m8_t value,
                         size_t vl) {
  return vsuxei8_v_i8m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i8.nxv1i16.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8mf8(int8_t *base, vuint16mf4_t bindex, vint8mf8_t value,
                           size_t vl) {
  return vsuxei16_v_i8mf8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i8.nxv2i16.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8mf4(int8_t *base, vuint16mf2_t bindex, vint8mf4_t value,
                           size_t vl) {
  return vsuxei16_v_i8mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i8.nxv4i16.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8mf2(int8_t *base, vuint16m1_t bindex, vint8mf2_t value,
                           size_t vl) {
  return vsuxei16_v_i8mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i8.nxv8i16.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8m1(int8_t *base, vuint16m2_t bindex, vint8m1_t value,
                          size_t vl) {
  return vsuxei16_v_i8m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i8.nxv16i16.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8m2(int8_t *base, vuint16m4_t bindex, vint8m2_t value,
                          size_t vl) {
  return vsuxei16_v_i8m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 32 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv32i8.nxv32i16.i64(<vscale x 32 x i8> [[VALUE:%.*]], <vscale x 32 x i8>* [[TMP0]], <vscale x 32 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8m4(int8_t *base, vuint16m8_t bindex, vint8m4_t value,
                          size_t vl) {
  return vsuxei16_v_i8m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i8.nxv1i32.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8mf8(int8_t *base, vuint32mf2_t bindex, vint8mf8_t value,
                           size_t vl) {
  return vsuxei32_v_i8mf8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i8.nxv2i32.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8mf4(int8_t *base, vuint32m1_t bindex, vint8mf4_t value,
                           size_t vl) {
  return vsuxei32_v_i8mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i8.nxv4i32.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8mf2(int8_t *base, vuint32m2_t bindex, vint8mf2_t value,
                           size_t vl) {
  return vsuxei32_v_i8mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i8.nxv8i32.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8m1(int8_t *base, vuint32m4_t bindex, vint8m1_t value,
                          size_t vl) {
  return vsuxei32_v_i8m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i8.nxv16i32.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8m2(int8_t *base, vuint32m8_t bindex, vint8m2_t value,
                          size_t vl) {
  return vsuxei32_v_i8m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i8.nxv1i64.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i8mf8(int8_t *base, vuint64m1_t bindex, vint8mf8_t value,
                           size_t vl) {
  return vsuxei64_v_i8mf8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i8.nxv2i64.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i8mf4(int8_t *base, vuint64m2_t bindex, vint8mf4_t value,
                           size_t vl) {
  return vsuxei64_v_i8mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i8.nxv4i64.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i8mf2(int8_t *base, vuint64m4_t bindex, vint8mf2_t value,
                           size_t vl) {
  return vsuxei64_v_i8mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i8.nxv8i64.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i8m1(int8_t *base, vuint64m8_t bindex, vint8m1_t value,
                          size_t vl) {
  return vsuxei64_v_i8m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i16.nxv1i8.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16mf4(int16_t *base, vuint8mf8_t bindex, vint16mf4_t value,
                           size_t vl) {
  return vsuxei8_v_i16mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i16.nxv2i8.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16mf2(int16_t *base, vuint8mf4_t bindex, vint16mf2_t value,
                           size_t vl) {
  return vsuxei8_v_i16mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i16.nxv4i8.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16m1(int16_t *base, vuint8mf2_t bindex, vint16m1_t value,
                          size_t vl) {
  return vsuxei8_v_i16m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i16.nxv8i8.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16m2(int16_t *base, vuint8m1_t bindex, vint16m2_t value,
                          size_t vl) {
  return vsuxei8_v_i16m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i16.nxv16i8.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16m4(int16_t *base, vuint8m2_t bindex, vint16m4_t value,
                          size_t vl) {
  return vsuxei8_v_i16m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 32 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv32i16.nxv32i8.i64(<vscale x 32 x i16> [[VALUE:%.*]], <vscale x 32 x i16>* [[TMP0]], <vscale x 32 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16m8(int16_t *base, vuint8m4_t bindex, vint16m8_t value,
                          size_t vl) {
  return vsuxei8_v_i16m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i16.nxv1i16.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16mf4(int16_t *base, vuint16mf4_t bindex,
                            vint16mf4_t value, size_t vl) {
  return vsuxei16_v_i16mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i16.nxv2i16.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16mf2(int16_t *base, vuint16mf2_t bindex,
                            vint16mf2_t value, size_t vl) {
  return vsuxei16_v_i16mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i16.nxv4i16.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16m1(int16_t *base, vuint16m1_t bindex, vint16m1_t value,
                           size_t vl) {
  return vsuxei16_v_i16m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i16.nxv8i16.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16m2(int16_t *base, vuint16m2_t bindex, vint16m2_t value,
                           size_t vl) {
  return vsuxei16_v_i16m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i16.nxv16i16.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16m4(int16_t *base, vuint16m4_t bindex, vint16m4_t value,
                           size_t vl) {
  return vsuxei16_v_i16m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 32 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv32i16.nxv32i16.i64(<vscale x 32 x i16> [[VALUE:%.*]], <vscale x 32 x i16>* [[TMP0]], <vscale x 32 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16m8(int16_t *base, vuint16m8_t bindex, vint16m8_t value,
                           size_t vl) {
  return vsuxei16_v_i16m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i16.nxv1i32.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16mf4(int16_t *base, vuint32mf2_t bindex,
                            vint16mf4_t value, size_t vl) {
  return vsuxei32_v_i16mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i16.nxv2i32.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16mf2(int16_t *base, vuint32m1_t bindex,
                            vint16mf2_t value, size_t vl) {
  return vsuxei32_v_i16mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i16.nxv4i32.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16m1(int16_t *base, vuint32m2_t bindex, vint16m1_t value,
                           size_t vl) {
  return vsuxei32_v_i16m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i16.nxv8i32.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16m2(int16_t *base, vuint32m4_t bindex, vint16m2_t value,
                           size_t vl) {
  return vsuxei32_v_i16m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i16.nxv16i32.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16m4(int16_t *base, vuint32m8_t bindex, vint16m4_t value,
                           size_t vl) {
  return vsuxei32_v_i16m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i16.nxv1i64.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i16mf4(int16_t *base, vuint64m1_t bindex,
                            vint16mf4_t value, size_t vl) {
  return vsuxei64_v_i16mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i16.nxv2i64.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i16mf2(int16_t *base, vuint64m2_t bindex,
                            vint16mf2_t value, size_t vl) {
  return vsuxei64_v_i16mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i16.nxv4i64.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i16m1(int16_t *base, vuint64m4_t bindex, vint16m1_t value,
                           size_t vl) {
  return vsuxei64_v_i16m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i16.nxv8i64.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i16m2(int16_t *base, vuint64m8_t bindex, vint16m2_t value,
                           size_t vl) {
  return vsuxei64_v_i16m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i32.nxv1i8.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32mf2(int32_t *base, vuint8mf8_t bindex, vint32mf2_t value,
                           size_t vl) {
  return vsuxei8_v_i32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i32.nxv2i8.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32m1(int32_t *base, vuint8mf4_t bindex, vint32m1_t value,
                          size_t vl) {
  return vsuxei8_v_i32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i32.nxv4i8.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32m2(int32_t *base, vuint8mf2_t bindex, vint32m2_t value,
                          size_t vl) {
  return vsuxei8_v_i32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i32.nxv8i8.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32m4(int32_t *base, vuint8m1_t bindex, vint32m4_t value,
                          size_t vl) {
  return vsuxei8_v_i32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i32.nxv16i8.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32m8(int32_t *base, vuint8m2_t bindex, vint32m8_t value,
                          size_t vl) {
  return vsuxei8_v_i32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i32.nxv1i16.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32mf2(int32_t *base, vuint16mf4_t bindex,
                            vint32mf2_t value, size_t vl) {
  return vsuxei16_v_i32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i32.nxv2i16.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32m1(int32_t *base, vuint16mf2_t bindex, vint32m1_t value,
                           size_t vl) {
  return vsuxei16_v_i32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i32.nxv4i16.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32m2(int32_t *base, vuint16m1_t bindex, vint32m2_t value,
                           size_t vl) {
  return vsuxei16_v_i32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i32.nxv8i16.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32m4(int32_t *base, vuint16m2_t bindex, vint32m4_t value,
                           size_t vl) {
  return vsuxei16_v_i32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i32.nxv16i16.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32m8(int32_t *base, vuint16m4_t bindex, vint32m8_t value,
                           size_t vl) {
  return vsuxei16_v_i32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i32.nxv1i32.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32mf2(int32_t *base, vuint32mf2_t bindex,
                            vint32mf2_t value, size_t vl) {
  return vsuxei32_v_i32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i32.nxv2i32.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32m1(int32_t *base, vuint32m1_t bindex, vint32m1_t value,
                           size_t vl) {
  return vsuxei32_v_i32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i32.nxv4i32.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32m2(int32_t *base, vuint32m2_t bindex, vint32m2_t value,
                           size_t vl) {
  return vsuxei32_v_i32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i32.nxv8i32.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32m4(int32_t *base, vuint32m4_t bindex, vint32m4_t value,
                           size_t vl) {
  return vsuxei32_v_i32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i32.nxv16i32.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32m8(int32_t *base, vuint32m8_t bindex, vint32m8_t value,
                           size_t vl) {
  return vsuxei32_v_i32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i32.nxv1i64.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i32mf2(int32_t *base, vuint64m1_t bindex,
                            vint32mf2_t value, size_t vl) {
  return vsuxei64_v_i32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i32.nxv2i64.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i32m1(int32_t *base, vuint64m2_t bindex, vint32m1_t value,
                           size_t vl) {
  return vsuxei64_v_i32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i32.nxv4i64.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i32m2(int32_t *base, vuint64m4_t bindex, vint32m2_t value,
                           size_t vl) {
  return vsuxei64_v_i32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i32.nxv8i64.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i32m4(int32_t *base, vuint64m8_t bindex, vint32m4_t value,
                           size_t vl) {
  return vsuxei64_v_i32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i64.nxv1i8.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i64m1(int64_t *base, vuint8mf8_t bindex, vint64m1_t value,
                          size_t vl) {
  return vsuxei8_v_i64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i64.nxv2i8.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i64m2(int64_t *base, vuint8mf4_t bindex, vint64m2_t value,
                          size_t vl) {
  return vsuxei8_v_i64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i64.nxv4i8.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i64m4(int64_t *base, vuint8mf2_t bindex, vint64m4_t value,
                          size_t vl) {
  return vsuxei8_v_i64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i64.nxv8i8.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i64m8(int64_t *base, vuint8m1_t bindex, vint64m8_t value,
                          size_t vl) {
  return vsuxei8_v_i64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i64.nxv1i16.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i64m1(int64_t *base, vuint16mf4_t bindex, vint64m1_t value,
                           size_t vl) {
  return vsuxei16_v_i64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i64.nxv2i16.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i64m2(int64_t *base, vuint16mf2_t bindex, vint64m2_t value,
                           size_t vl) {
  return vsuxei16_v_i64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i64.nxv4i16.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i64m4(int64_t *base, vuint16m1_t bindex, vint64m4_t value,
                           size_t vl) {
  return vsuxei16_v_i64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i64.nxv8i16.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i64m8(int64_t *base, vuint16m2_t bindex, vint64m8_t value,
                           size_t vl) {
  return vsuxei16_v_i64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i64.nxv1i32.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i64m1(int64_t *base, vuint32mf2_t bindex, vint64m1_t value,
                           size_t vl) {
  return vsuxei32_v_i64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i64.nxv2i32.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i64m2(int64_t *base, vuint32m1_t bindex, vint64m2_t value,
                           size_t vl) {
  return vsuxei32_v_i64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i64.nxv4i32.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i64m4(int64_t *base, vuint32m2_t bindex, vint64m4_t value,
                           size_t vl) {
  return vsuxei32_v_i64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i64.nxv8i32.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i64m8(int64_t *base, vuint32m4_t bindex, vint64m8_t value,
                           size_t vl) {
  return vsuxei32_v_i64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i64.nxv1i64.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i64m1(int64_t *base, vuint64m1_t bindex, vint64m1_t value,
                           size_t vl) {
  return vsuxei64_v_i64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i64.nxv2i64.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i64m2(int64_t *base, vuint64m2_t bindex, vint64m2_t value,
                           size_t vl) {
  return vsuxei64_v_i64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i64.nxv4i64.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i64m4(int64_t *base, vuint64m4_t bindex, vint64m4_t value,
                           size_t vl) {
  return vsuxei64_v_i64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i64.nxv8i64.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i64m8(int64_t *base, vuint64m8_t bindex, vint64m8_t value,
                           size_t vl) {
  return vsuxei64_v_i64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i8.nxv1i8.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8mf8(uint8_t *base, vuint8mf8_t bindex, vuint8mf8_t value,
                          size_t vl) {
  return vsuxei8_v_u8mf8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i8.nxv2i8.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8mf4(uint8_t *base, vuint8mf4_t bindex, vuint8mf4_t value,
                          size_t vl) {
  return vsuxei8_v_u8mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i8.nxv4i8.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8mf2(uint8_t *base, vuint8mf2_t bindex, vuint8mf2_t value,
                          size_t vl) {
  return vsuxei8_v_u8mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i8.nxv8i8.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8m1(uint8_t *base, vuint8m1_t bindex, vuint8m1_t value,
                         size_t vl) {
  return vsuxei8_v_u8m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i8.nxv16i8.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8m2(uint8_t *base, vuint8m2_t bindex, vuint8m2_t value,
                         size_t vl) {
  return vsuxei8_v_u8m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 32 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv32i8.nxv32i8.i64(<vscale x 32 x i8> [[VALUE:%.*]], <vscale x 32 x i8>* [[TMP0]], <vscale x 32 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8m4(uint8_t *base, vuint8m4_t bindex, vuint8m4_t value,
                         size_t vl) {
  return vsuxei8_v_u8m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 64 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv64i8.nxv64i8.i64(<vscale x 64 x i8> [[VALUE:%.*]], <vscale x 64 x i8>* [[TMP0]], <vscale x 64 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8m8(uint8_t *base, vuint8m8_t bindex, vuint8m8_t value,
                         size_t vl) {
  return vsuxei8_v_u8m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i8.nxv1i16.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8mf8(uint8_t *base, vuint16mf4_t bindex,
                           vuint8mf8_t value, size_t vl) {
  return vsuxei16_v_u8mf8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i8.nxv2i16.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8mf4(uint8_t *base, vuint16mf2_t bindex,
                           vuint8mf4_t value, size_t vl) {
  return vsuxei16_v_u8mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i8.nxv4i16.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8mf2(uint8_t *base, vuint16m1_t bindex, vuint8mf2_t value,
                           size_t vl) {
  return vsuxei16_v_u8mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i8.nxv8i16.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8m1(uint8_t *base, vuint16m2_t bindex, vuint8m1_t value,
                          size_t vl) {
  return vsuxei16_v_u8m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i8.nxv16i16.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8m2(uint8_t *base, vuint16m4_t bindex, vuint8m2_t value,
                          size_t vl) {
  return vsuxei16_v_u8m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 32 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv32i8.nxv32i16.i64(<vscale x 32 x i8> [[VALUE:%.*]], <vscale x 32 x i8>* [[TMP0]], <vscale x 32 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8m4(uint8_t *base, vuint16m8_t bindex, vuint8m4_t value,
                          size_t vl) {
  return vsuxei16_v_u8m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i8.nxv1i32.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8mf8(uint8_t *base, vuint32mf2_t bindex,
                           vuint8mf8_t value, size_t vl) {
  return vsuxei32_v_u8mf8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i8.nxv2i32.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8mf4(uint8_t *base, vuint32m1_t bindex, vuint8mf4_t value,
                           size_t vl) {
  return vsuxei32_v_u8mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i8.nxv4i32.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8mf2(uint8_t *base, vuint32m2_t bindex, vuint8mf2_t value,
                           size_t vl) {
  return vsuxei32_v_u8mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i8.nxv8i32.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8m1(uint8_t *base, vuint32m4_t bindex, vuint8m1_t value,
                          size_t vl) {
  return vsuxei32_v_u8m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i8.nxv16i32.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8m2(uint8_t *base, vuint32m8_t bindex, vuint8m2_t value,
                          size_t vl) {
  return vsuxei32_v_u8m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i8.nxv1i64.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u8mf8(uint8_t *base, vuint64m1_t bindex, vuint8mf8_t value,
                           size_t vl) {
  return vsuxei64_v_u8mf8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i8.nxv2i64.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u8mf4(uint8_t *base, vuint64m2_t bindex, vuint8mf4_t value,
                           size_t vl) {
  return vsuxei64_v_u8mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i8.nxv4i64.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u8mf2(uint8_t *base, vuint64m4_t bindex, vuint8mf2_t value,
                           size_t vl) {
  return vsuxei64_v_u8mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i8.nxv8i64.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u8m1(uint8_t *base, vuint64m8_t bindex, vuint8m1_t value,
                          size_t vl) {
  return vsuxei64_v_u8m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i16.nxv1i8.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16mf4(uint16_t *base, vuint8mf8_t bindex,
                           vuint16mf4_t value, size_t vl) {
  return vsuxei8_v_u16mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i16.nxv2i8.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16mf2(uint16_t *base, vuint8mf4_t bindex,
                           vuint16mf2_t value, size_t vl) {
  return vsuxei8_v_u16mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i16.nxv4i8.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16m1(uint16_t *base, vuint8mf2_t bindex, vuint16m1_t value,
                          size_t vl) {
  return vsuxei8_v_u16m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i16.nxv8i8.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16m2(uint16_t *base, vuint8m1_t bindex, vuint16m2_t value,
                          size_t vl) {
  return vsuxei8_v_u16m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i16.nxv16i8.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16m4(uint16_t *base, vuint8m2_t bindex, vuint16m4_t value,
                          size_t vl) {
  return vsuxei8_v_u16m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 32 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv32i16.nxv32i8.i64(<vscale x 32 x i16> [[VALUE:%.*]], <vscale x 32 x i16>* [[TMP0]], <vscale x 32 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16m8(uint16_t *base, vuint8m4_t bindex, vuint16m8_t value,
                          size_t vl) {
  return vsuxei8_v_u16m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i16.nxv1i16.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16mf4(uint16_t *base, vuint16mf4_t bindex,
                            vuint16mf4_t value, size_t vl) {
  return vsuxei16_v_u16mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i16.nxv2i16.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16mf2(uint16_t *base, vuint16mf2_t bindex,
                            vuint16mf2_t value, size_t vl) {
  return vsuxei16_v_u16mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i16.nxv4i16.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16m1(uint16_t *base, vuint16m1_t bindex,
                           vuint16m1_t value, size_t vl) {
  return vsuxei16_v_u16m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i16.nxv8i16.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16m2(uint16_t *base, vuint16m2_t bindex,
                           vuint16m2_t value, size_t vl) {
  return vsuxei16_v_u16m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i16.nxv16i16.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16m4(uint16_t *base, vuint16m4_t bindex,
                           vuint16m4_t value, size_t vl) {
  return vsuxei16_v_u16m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 32 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv32i16.nxv32i16.i64(<vscale x 32 x i16> [[VALUE:%.*]], <vscale x 32 x i16>* [[TMP0]], <vscale x 32 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16m8(uint16_t *base, vuint16m8_t bindex,
                           vuint16m8_t value, size_t vl) {
  return vsuxei16_v_u16m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i16.nxv1i32.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16mf4(uint16_t *base, vuint32mf2_t bindex,
                            vuint16mf4_t value, size_t vl) {
  return vsuxei32_v_u16mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i16.nxv2i32.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16mf2(uint16_t *base, vuint32m1_t bindex,
                            vuint16mf2_t value, size_t vl) {
  return vsuxei32_v_u16mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i16.nxv4i32.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16m1(uint16_t *base, vuint32m2_t bindex,
                           vuint16m1_t value, size_t vl) {
  return vsuxei32_v_u16m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i16.nxv8i32.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16m2(uint16_t *base, vuint32m4_t bindex,
                           vuint16m2_t value, size_t vl) {
  return vsuxei32_v_u16m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i16.nxv16i32.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16m4(uint16_t *base, vuint32m8_t bindex,
                           vuint16m4_t value, size_t vl) {
  return vsuxei32_v_u16m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i16.nxv1i64.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u16mf4(uint16_t *base, vuint64m1_t bindex,
                            vuint16mf4_t value, size_t vl) {
  return vsuxei64_v_u16mf4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i16.nxv2i64.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u16mf2(uint16_t *base, vuint64m2_t bindex,
                            vuint16mf2_t value, size_t vl) {
  return vsuxei64_v_u16mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i16.nxv4i64.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u16m1(uint16_t *base, vuint64m4_t bindex,
                           vuint16m1_t value, size_t vl) {
  return vsuxei64_v_u16m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i16.nxv8i64.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u16m2(uint16_t *base, vuint64m8_t bindex,
                           vuint16m2_t value, size_t vl) {
  return vsuxei64_v_u16m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i32.nxv1i8.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32mf2(uint32_t *base, vuint8mf8_t bindex,
                           vuint32mf2_t value, size_t vl) {
  return vsuxei8_v_u32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i32.nxv2i8.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32m1(uint32_t *base, vuint8mf4_t bindex, vuint32m1_t value,
                          size_t vl) {
  return vsuxei8_v_u32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i32.nxv4i8.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32m2(uint32_t *base, vuint8mf2_t bindex, vuint32m2_t value,
                          size_t vl) {
  return vsuxei8_v_u32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i32.nxv8i8.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32m4(uint32_t *base, vuint8m1_t bindex, vuint32m4_t value,
                          size_t vl) {
  return vsuxei8_v_u32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i32.nxv16i8.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32m8(uint32_t *base, vuint8m2_t bindex, vuint32m8_t value,
                          size_t vl) {
  return vsuxei8_v_u32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i32.nxv1i16.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32mf2(uint32_t *base, vuint16mf4_t bindex,
                            vuint32mf2_t value, size_t vl) {
  return vsuxei16_v_u32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i32.nxv2i16.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32m1(uint32_t *base, vuint16mf2_t bindex,
                           vuint32m1_t value, size_t vl) {
  return vsuxei16_v_u32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i32.nxv4i16.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32m2(uint32_t *base, vuint16m1_t bindex,
                           vuint32m2_t value, size_t vl) {
  return vsuxei16_v_u32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i32.nxv8i16.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32m4(uint32_t *base, vuint16m2_t bindex,
                           vuint32m4_t value, size_t vl) {
  return vsuxei16_v_u32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i32.nxv16i16.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32m8(uint32_t *base, vuint16m4_t bindex,
                           vuint32m8_t value, size_t vl) {
  return vsuxei16_v_u32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i32.nxv1i32.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32mf2(uint32_t *base, vuint32mf2_t bindex,
                            vuint32mf2_t value, size_t vl) {
  return vsuxei32_v_u32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i32.nxv2i32.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32m1(uint32_t *base, vuint32m1_t bindex,
                           vuint32m1_t value, size_t vl) {
  return vsuxei32_v_u32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i32.nxv4i32.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32m2(uint32_t *base, vuint32m2_t bindex,
                           vuint32m2_t value, size_t vl) {
  return vsuxei32_v_u32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i32.nxv8i32.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32m4(uint32_t *base, vuint32m4_t bindex,
                           vuint32m4_t value, size_t vl) {
  return vsuxei32_v_u32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16i32.nxv16i32.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32m8(uint32_t *base, vuint32m8_t bindex,
                           vuint32m8_t value, size_t vl) {
  return vsuxei32_v_u32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i32.nxv1i64.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u32mf2(uint32_t *base, vuint64m1_t bindex,
                            vuint32mf2_t value, size_t vl) {
  return vsuxei64_v_u32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i32.nxv2i64.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u32m1(uint32_t *base, vuint64m2_t bindex,
                           vuint32m1_t value, size_t vl) {
  return vsuxei64_v_u32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i32.nxv4i64.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u32m2(uint32_t *base, vuint64m4_t bindex,
                           vuint32m2_t value, size_t vl) {
  return vsuxei64_v_u32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i32.nxv8i64.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u32m4(uint32_t *base, vuint64m8_t bindex,
                           vuint32m4_t value, size_t vl) {
  return vsuxei64_v_u32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i64.nxv1i8.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u64m1(uint64_t *base, vuint8mf8_t bindex, vuint64m1_t value,
                          size_t vl) {
  return vsuxei8_v_u64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i64.nxv2i8.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u64m2(uint64_t *base, vuint8mf4_t bindex, vuint64m2_t value,
                          size_t vl) {
  return vsuxei8_v_u64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i64.nxv4i8.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u64m4(uint64_t *base, vuint8mf2_t bindex, vuint64m4_t value,
                          size_t vl) {
  return vsuxei8_v_u64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i64.nxv8i8.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u64m8(uint64_t *base, vuint8m1_t bindex, vuint64m8_t value,
                          size_t vl) {
  return vsuxei8_v_u64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i64.nxv1i16.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u64m1(uint64_t *base, vuint16mf4_t bindex,
                           vuint64m1_t value, size_t vl) {
  return vsuxei16_v_u64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i64.nxv2i16.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u64m2(uint64_t *base, vuint16mf2_t bindex,
                           vuint64m2_t value, size_t vl) {
  return vsuxei16_v_u64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i64.nxv4i16.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u64m4(uint64_t *base, vuint16m1_t bindex,
                           vuint64m4_t value, size_t vl) {
  return vsuxei16_v_u64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i64.nxv8i16.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u64m8(uint64_t *base, vuint16m2_t bindex,
                           vuint64m8_t value, size_t vl) {
  return vsuxei16_v_u64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i64.nxv1i32.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u64m1(uint64_t *base, vuint32mf2_t bindex,
                           vuint64m1_t value, size_t vl) {
  return vsuxei32_v_u64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i64.nxv2i32.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u64m2(uint64_t *base, vuint32m1_t bindex,
                           vuint64m2_t value, size_t vl) {
  return vsuxei32_v_u64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i64.nxv4i32.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u64m4(uint64_t *base, vuint32m2_t bindex,
                           vuint64m4_t value, size_t vl) {
  return vsuxei32_v_u64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i64.nxv8i32.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u64m8(uint64_t *base, vuint32m4_t bindex,
                           vuint64m8_t value, size_t vl) {
  return vsuxei32_v_u64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1i64.nxv1i64.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u64m1(uint64_t *base, vuint64m1_t bindex,
                           vuint64m1_t value, size_t vl) {
  return vsuxei64_v_u64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2i64.nxv2i64.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u64m2(uint64_t *base, vuint64m2_t bindex,
                           vuint64m2_t value, size_t vl) {
  return vsuxei64_v_u64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4i64.nxv4i64.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u64m4(uint64_t *base, vuint64m4_t bindex,
                           vuint64m4_t value, size_t vl) {
  return vsuxei64_v_u64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8i64.nxv8i64.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u64m8(uint64_t *base, vuint64m8_t bindex,
                           vuint64m8_t value, size_t vl) {
  return vsuxei64_v_u64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 1 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1f32.nxv1i8.i64(<vscale x 1 x float> [[VALUE:%.*]], <vscale x 1 x float>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32mf2(float *base, vuint8mf8_t bindex, vfloat32mf2_t value,
                           size_t vl) {
  return vsuxei8_v_f32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 2 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2f32.nxv2i8.i64(<vscale x 2 x float> [[VALUE:%.*]], <vscale x 2 x float>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32m1(float *base, vuint8mf4_t bindex, vfloat32m1_t value,
                          size_t vl) {
  return vsuxei8_v_f32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 4 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4f32.nxv4i8.i64(<vscale x 4 x float> [[VALUE:%.*]], <vscale x 4 x float>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32m2(float *base, vuint8mf2_t bindex, vfloat32m2_t value,
                          size_t vl) {
  return vsuxei8_v_f32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 8 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8f32.nxv8i8.i64(<vscale x 8 x float> [[VALUE:%.*]], <vscale x 8 x float>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32m4(float *base, vuint8m1_t bindex, vfloat32m4_t value,
                          size_t vl) {
  return vsuxei8_v_f32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 16 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16f32.nxv16i8.i64(<vscale x 16 x float> [[VALUE:%.*]], <vscale x 16 x float>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32m8(float *base, vuint8m2_t bindex, vfloat32m8_t value,
                          size_t vl) {
  return vsuxei8_v_f32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 1 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1f32.nxv1i16.i64(<vscale x 1 x float> [[VALUE:%.*]], <vscale x 1 x float>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32mf2(float *base, vuint16mf4_t bindex,
                            vfloat32mf2_t value, size_t vl) {
  return vsuxei16_v_f32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 2 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2f32.nxv2i16.i64(<vscale x 2 x float> [[VALUE:%.*]], <vscale x 2 x float>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32m1(float *base, vuint16mf2_t bindex, vfloat32m1_t value,
                           size_t vl) {
  return vsuxei16_v_f32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 4 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4f32.nxv4i16.i64(<vscale x 4 x float> [[VALUE:%.*]], <vscale x 4 x float>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32m2(float *base, vuint16m1_t bindex, vfloat32m2_t value,
                           size_t vl) {
  return vsuxei16_v_f32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 8 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8f32.nxv8i16.i64(<vscale x 8 x float> [[VALUE:%.*]], <vscale x 8 x float>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32m4(float *base, vuint16m2_t bindex, vfloat32m4_t value,
                           size_t vl) {
  return vsuxei16_v_f32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 16 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16f32.nxv16i16.i64(<vscale x 16 x float> [[VALUE:%.*]], <vscale x 16 x float>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32m8(float *base, vuint16m4_t bindex, vfloat32m8_t value,
                           size_t vl) {
  return vsuxei16_v_f32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 1 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1f32.nxv1i32.i64(<vscale x 1 x float> [[VALUE:%.*]], <vscale x 1 x float>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32mf2(float *base, vuint32mf2_t bindex,
                            vfloat32mf2_t value, size_t vl) {
  return vsuxei32_v_f32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 2 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2f32.nxv2i32.i64(<vscale x 2 x float> [[VALUE:%.*]], <vscale x 2 x float>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32m1(float *base, vuint32m1_t bindex, vfloat32m1_t value,
                           size_t vl) {
  return vsuxei32_v_f32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 4 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4f32.nxv4i32.i64(<vscale x 4 x float> [[VALUE:%.*]], <vscale x 4 x float>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32m2(float *base, vuint32m2_t bindex, vfloat32m2_t value,
                           size_t vl) {
  return vsuxei32_v_f32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 8 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8f32.nxv8i32.i64(<vscale x 8 x float> [[VALUE:%.*]], <vscale x 8 x float>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32m4(float *base, vuint32m4_t bindex, vfloat32m4_t value,
                           size_t vl) {
  return vsuxei32_v_f32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 16 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv16f32.nxv16i32.i64(<vscale x 16 x float> [[VALUE:%.*]], <vscale x 16 x float>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32m8(float *base, vuint32m8_t bindex, vfloat32m8_t value,
                           size_t vl) {
  return vsuxei32_v_f32m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 1 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1f32.nxv1i64.i64(<vscale x 1 x float> [[VALUE:%.*]], <vscale x 1 x float>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f32mf2(float *base, vuint64m1_t bindex,
                            vfloat32mf2_t value, size_t vl) {
  return vsuxei64_v_f32mf2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 2 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2f32.nxv2i64.i64(<vscale x 2 x float> [[VALUE:%.*]], <vscale x 2 x float>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f32m1(float *base, vuint64m2_t bindex, vfloat32m1_t value,
                           size_t vl) {
  return vsuxei64_v_f32m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 4 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4f32.nxv4i64.i64(<vscale x 4 x float> [[VALUE:%.*]], <vscale x 4 x float>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f32m2(float *base, vuint64m4_t bindex, vfloat32m2_t value,
                           size_t vl) {
  return vsuxei64_v_f32m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 8 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8f32.nxv8i64.i64(<vscale x 8 x float> [[VALUE:%.*]], <vscale x 8 x float>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f32m4(float *base, vuint64m8_t bindex, vfloat32m4_t value,
                           size_t vl) {
  return vsuxei64_v_f32m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 1 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1f64.nxv1i8.i64(<vscale x 1 x double> [[VALUE:%.*]], <vscale x 1 x double>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f64m1(double *base, vuint8mf8_t bindex, vfloat64m1_t value,
                          size_t vl) {
  return vsuxei8_v_f64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 2 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2f64.nxv2i8.i64(<vscale x 2 x double> [[VALUE:%.*]], <vscale x 2 x double>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f64m2(double *base, vuint8mf4_t bindex, vfloat64m2_t value,
                          size_t vl) {
  return vsuxei8_v_f64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 4 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4f64.nxv4i8.i64(<vscale x 4 x double> [[VALUE:%.*]], <vscale x 4 x double>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f64m4(double *base, vuint8mf2_t bindex, vfloat64m4_t value,
                          size_t vl) {
  return vsuxei8_v_f64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 8 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8f64.nxv8i8.i64(<vscale x 8 x double> [[VALUE:%.*]], <vscale x 8 x double>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f64m8(double *base, vuint8m1_t bindex, vfloat64m8_t value,
                          size_t vl) {
  return vsuxei8_v_f64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 1 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1f64.nxv1i16.i64(<vscale x 1 x double> [[VALUE:%.*]], <vscale x 1 x double>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f64m1(double *base, vuint16mf4_t bindex,
                           vfloat64m1_t value, size_t vl) {
  return vsuxei16_v_f64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 2 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2f64.nxv2i16.i64(<vscale x 2 x double> [[VALUE:%.*]], <vscale x 2 x double>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f64m2(double *base, vuint16mf2_t bindex,
                           vfloat64m2_t value, size_t vl) {
  return vsuxei16_v_f64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 4 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4f64.nxv4i16.i64(<vscale x 4 x double> [[VALUE:%.*]], <vscale x 4 x double>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f64m4(double *base, vuint16m1_t bindex, vfloat64m4_t value,
                           size_t vl) {
  return vsuxei16_v_f64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 8 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8f64.nxv8i16.i64(<vscale x 8 x double> [[VALUE:%.*]], <vscale x 8 x double>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f64m8(double *base, vuint16m2_t bindex, vfloat64m8_t value,
                           size_t vl) {
  return vsuxei16_v_f64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 1 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1f64.nxv1i32.i64(<vscale x 1 x double> [[VALUE:%.*]], <vscale x 1 x double>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f64m1(double *base, vuint32mf2_t bindex,
                           vfloat64m1_t value, size_t vl) {
  return vsuxei32_v_f64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 2 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2f64.nxv2i32.i64(<vscale x 2 x double> [[VALUE:%.*]], <vscale x 2 x double>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f64m2(double *base, vuint32m1_t bindex, vfloat64m2_t value,
                           size_t vl) {
  return vsuxei32_v_f64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 4 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4f64.nxv4i32.i64(<vscale x 4 x double> [[VALUE:%.*]], <vscale x 4 x double>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f64m4(double *base, vuint32m2_t bindex, vfloat64m4_t value,
                           size_t vl) {
  return vsuxei32_v_f64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 8 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8f64.nxv8i32.i64(<vscale x 8 x double> [[VALUE:%.*]], <vscale x 8 x double>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f64m8(double *base, vuint32m4_t bindex, vfloat64m8_t value,
                           size_t vl) {
  return vsuxei32_v_f64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 1 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv1f64.nxv1i64.i64(<vscale x 1 x double> [[VALUE:%.*]], <vscale x 1 x double>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f64m1(double *base, vuint64m1_t bindex, vfloat64m1_t value,
                           size_t vl) {
  return vsuxei64_v_f64m1(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 2 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv2f64.nxv2i64.i64(<vscale x 2 x double> [[VALUE:%.*]], <vscale x 2 x double>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f64m2(double *base, vuint64m2_t bindex, vfloat64m2_t value,
                           size_t vl) {
  return vsuxei64_v_f64m2(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 4 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv4f64.nxv4i64.i64(<vscale x 4 x double> [[VALUE:%.*]], <vscale x 4 x double>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f64m4(double *base, vuint64m4_t bindex, vfloat64m4_t value,
                           size_t vl) {
  return vsuxei64_v_f64m4(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 8 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.nxv8f64.nxv8i64.i64(<vscale x 8 x double> [[VALUE:%.*]], <vscale x 8 x double>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f64m8(double *base, vuint64m8_t bindex, vfloat64m8_t value,
                           size_t vl) {
  return vsuxei64_v_f64m8(base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8mf8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i8.nxv1i8.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8mf8_m(vbool64_t mask, int8_t *base, vuint8mf8_t bindex,
                            vint8mf8_t value, size_t vl) {
  return vsuxei8_v_i8mf8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i8.nxv2i8.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8mf4_m(vbool32_t mask, int8_t *base, vuint8mf4_t bindex,
                            vint8mf4_t value, size_t vl) {
  return vsuxei8_v_i8mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i8.nxv4i8.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8mf2_m(vbool16_t mask, int8_t *base, vuint8mf2_t bindex,
                            vint8mf2_t value, size_t vl) {
  return vsuxei8_v_i8mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i8.nxv8i8.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8m1_m(vbool8_t mask, int8_t *base, vuint8m1_t bindex,
                           vint8m1_t value, size_t vl) {
  return vsuxei8_v_i8m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i8.nxv16i8.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8m2_m(vbool4_t mask, int8_t *base, vuint8m2_t bindex,
                           vint8m2_t value, size_t vl) {
  return vsuxei8_v_i8m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 32 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv32i8.nxv32i8.i64(<vscale x 32 x i8> [[VALUE:%.*]], <vscale x 32 x i8>* [[TMP0]], <vscale x 32 x i8> [[BINDEX:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8m4_m(vbool2_t mask, int8_t *base, vuint8m4_t bindex,
                           vint8m4_t value, size_t vl) {
  return vsuxei8_v_i8m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i8m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 64 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv64i8.nxv64i8.i64(<vscale x 64 x i8> [[VALUE:%.*]], <vscale x 64 x i8>* [[TMP0]], <vscale x 64 x i8> [[BINDEX:%.*]], <vscale x 64 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i8m8_m(vbool1_t mask, int8_t *base, vuint8m8_t bindex,
                           vint8m8_t value, size_t vl) {
  return vsuxei8_v_i8m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8mf8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i8.nxv1i16.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8mf8_m(vbool64_t mask, int8_t *base, vuint16mf4_t bindex,
                             vint8mf8_t value, size_t vl) {
  return vsuxei16_v_i8mf8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i8.nxv2i16.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8mf4_m(vbool32_t mask, int8_t *base, vuint16mf2_t bindex,
                             vint8mf4_t value, size_t vl) {
  return vsuxei16_v_i8mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i8.nxv4i16.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8mf2_m(vbool16_t mask, int8_t *base, vuint16m1_t bindex,
                             vint8mf2_t value, size_t vl) {
  return vsuxei16_v_i8mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i8.nxv8i16.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8m1_m(vbool8_t mask, int8_t *base, vuint16m2_t bindex,
                            vint8m1_t value, size_t vl) {
  return vsuxei16_v_i8m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i8.nxv16i16.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8m2_m(vbool4_t mask, int8_t *base, vuint16m4_t bindex,
                            vint8m2_t value, size_t vl) {
  return vsuxei16_v_i8m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i8m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 32 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv32i8.nxv32i16.i64(<vscale x 32 x i8> [[VALUE:%.*]], <vscale x 32 x i8>* [[TMP0]], <vscale x 32 x i16> [[BINDEX:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i8m4_m(vbool2_t mask, int8_t *base, vuint16m8_t bindex,
                            vint8m4_t value, size_t vl) {
  return vsuxei16_v_i8m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8mf8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i8.nxv1i32.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8mf8_m(vbool64_t mask, int8_t *base, vuint32mf2_t bindex,
                             vint8mf8_t value, size_t vl) {
  return vsuxei32_v_i8mf8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i8.nxv2i32.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8mf4_m(vbool32_t mask, int8_t *base, vuint32m1_t bindex,
                             vint8mf4_t value, size_t vl) {
  return vsuxei32_v_i8mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i8.nxv4i32.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8mf2_m(vbool16_t mask, int8_t *base, vuint32m2_t bindex,
                             vint8mf2_t value, size_t vl) {
  return vsuxei32_v_i8mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i8.nxv8i32.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8m1_m(vbool8_t mask, int8_t *base, vuint32m4_t bindex,
                            vint8m1_t value, size_t vl) {
  return vsuxei32_v_i8m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i8m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i8.nxv16i32.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i8m2_m(vbool4_t mask, int8_t *base, vuint32m8_t bindex,
                            vint8m2_t value, size_t vl) {
  return vsuxei32_v_i8m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i8mf8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i8.nxv1i64.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i8mf8_m(vbool64_t mask, int8_t *base, vuint64m1_t bindex,
                             vint8mf8_t value, size_t vl) {
  return vsuxei64_v_i8mf8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i8mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i8.nxv2i64.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i8mf4_m(vbool32_t mask, int8_t *base, vuint64m2_t bindex,
                             vint8mf4_t value, size_t vl) {
  return vsuxei64_v_i8mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i8mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i8.nxv4i64.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i8mf2_m(vbool16_t mask, int8_t *base, vuint64m4_t bindex,
                             vint8mf2_t value, size_t vl) {
  return vsuxei64_v_i8mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i8m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i8.nxv8i64.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i8m1_m(vbool8_t mask, int8_t *base, vuint64m8_t bindex,
                            vint8m1_t value, size_t vl) {
  return vsuxei64_v_i8m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i16.nxv1i8.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16mf4_m(vbool64_t mask, int16_t *base, vuint8mf8_t bindex,
                             vint16mf4_t value, size_t vl) {
  return vsuxei8_v_i16mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i16.nxv2i8.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16mf2_m(vbool32_t mask, int16_t *base, vuint8mf4_t bindex,
                             vint16mf2_t value, size_t vl) {
  return vsuxei8_v_i16mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i16.nxv4i8.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16m1_m(vbool16_t mask, int16_t *base, vuint8mf2_t bindex,
                            vint16m1_t value, size_t vl) {
  return vsuxei8_v_i16m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i16.nxv8i8.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16m2_m(vbool8_t mask, int16_t *base, vuint8m1_t bindex,
                            vint16m2_t value, size_t vl) {
  return vsuxei8_v_i16m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i16.nxv16i8.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16m4_m(vbool4_t mask, int16_t *base, vuint8m2_t bindex,
                            vint16m4_t value, size_t vl) {
  return vsuxei8_v_i16m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i16m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 32 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv32i16.nxv32i8.i64(<vscale x 32 x i16> [[VALUE:%.*]], <vscale x 32 x i16>* [[TMP0]], <vscale x 32 x i8> [[BINDEX:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i16m8_m(vbool2_t mask, int16_t *base, vuint8m4_t bindex,
                            vint16m8_t value, size_t vl) {
  return vsuxei8_v_i16m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i16.nxv1i16.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16mf4_m(vbool64_t mask, int16_t *base,
                              vuint16mf4_t bindex, vint16mf4_t value,
                              size_t vl) {
  return vsuxei16_v_i16mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i16.nxv2i16.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16mf2_m(vbool32_t mask, int16_t *base,
                              vuint16mf2_t bindex, vint16mf2_t value,
                              size_t vl) {
  return vsuxei16_v_i16mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i16.nxv4i16.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16m1_m(vbool16_t mask, int16_t *base, vuint16m1_t bindex,
                             vint16m1_t value, size_t vl) {
  return vsuxei16_v_i16m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i16.nxv8i16.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16m2_m(vbool8_t mask, int16_t *base, vuint16m2_t bindex,
                             vint16m2_t value, size_t vl) {
  return vsuxei16_v_i16m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i16.nxv16i16.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16m4_m(vbool4_t mask, int16_t *base, vuint16m4_t bindex,
                             vint16m4_t value, size_t vl) {
  return vsuxei16_v_i16m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i16m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 32 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv32i16.nxv32i16.i64(<vscale x 32 x i16> [[VALUE:%.*]], <vscale x 32 x i16>* [[TMP0]], <vscale x 32 x i16> [[BINDEX:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i16m8_m(vbool2_t mask, int16_t *base, vuint16m8_t bindex,
                             vint16m8_t value, size_t vl) {
  return vsuxei16_v_i16m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i16.nxv1i32.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16mf4_m(vbool64_t mask, int16_t *base,
                              vuint32mf2_t bindex, vint16mf4_t value,
                              size_t vl) {
  return vsuxei32_v_i16mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i16.nxv2i32.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16mf2_m(vbool32_t mask, int16_t *base, vuint32m1_t bindex,
                              vint16mf2_t value, size_t vl) {
  return vsuxei32_v_i16mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i16.nxv4i32.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16m1_m(vbool16_t mask, int16_t *base, vuint32m2_t bindex,
                             vint16m1_t value, size_t vl) {
  return vsuxei32_v_i16m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i16.nxv8i32.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16m2_m(vbool8_t mask, int16_t *base, vuint32m4_t bindex,
                             vint16m2_t value, size_t vl) {
  return vsuxei32_v_i16m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i16m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i16.nxv16i32.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i16m4_m(vbool4_t mask, int16_t *base, vuint32m8_t bindex,
                             vint16m4_t value, size_t vl) {
  return vsuxei32_v_i16m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i16.nxv1i64.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i16mf4_m(vbool64_t mask, int16_t *base, vuint64m1_t bindex,
                              vint16mf4_t value, size_t vl) {
  return vsuxei64_v_i16mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i16.nxv2i64.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i16mf2_m(vbool32_t mask, int16_t *base, vuint64m2_t bindex,
                              vint16mf2_t value, size_t vl) {
  return vsuxei64_v_i16mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i16.nxv4i64.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i16m1_m(vbool16_t mask, int16_t *base, vuint64m4_t bindex,
                             vint16m1_t value, size_t vl) {
  return vsuxei64_v_i16m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i16.nxv8i64.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i16m2_m(vbool8_t mask, int16_t *base, vuint64m8_t bindex,
                             vint16m2_t value, size_t vl) {
  return vsuxei64_v_i16m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i32.nxv1i8.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32mf2_m(vbool64_t mask, int32_t *base, vuint8mf8_t bindex,
                             vint32mf2_t value, size_t vl) {
  return vsuxei8_v_i32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i32.nxv2i8.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32m1_m(vbool32_t mask, int32_t *base, vuint8mf4_t bindex,
                            vint32m1_t value, size_t vl) {
  return vsuxei8_v_i32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i32.nxv4i8.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32m2_m(vbool16_t mask, int32_t *base, vuint8mf2_t bindex,
                            vint32m2_t value, size_t vl) {
  return vsuxei8_v_i32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i32.nxv8i8.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32m4_m(vbool8_t mask, int32_t *base, vuint8m1_t bindex,
                            vint32m4_t value, size_t vl) {
  return vsuxei8_v_i32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i32.nxv16i8.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i32m8_m(vbool4_t mask, int32_t *base, vuint8m2_t bindex,
                            vint32m8_t value, size_t vl) {
  return vsuxei8_v_i32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i32.nxv1i16.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32mf2_m(vbool64_t mask, int32_t *base,
                              vuint16mf4_t bindex, vint32mf2_t value,
                              size_t vl) {
  return vsuxei16_v_i32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i32.nxv2i16.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32m1_m(vbool32_t mask, int32_t *base, vuint16mf2_t bindex,
                             vint32m1_t value, size_t vl) {
  return vsuxei16_v_i32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i32.nxv4i16.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32m2_m(vbool16_t mask, int32_t *base, vuint16m1_t bindex,
                             vint32m2_t value, size_t vl) {
  return vsuxei16_v_i32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i32.nxv8i16.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32m4_m(vbool8_t mask, int32_t *base, vuint16m2_t bindex,
                             vint32m4_t value, size_t vl) {
  return vsuxei16_v_i32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i32.nxv16i16.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i32m8_m(vbool4_t mask, int32_t *base, vuint16m4_t bindex,
                             vint32m8_t value, size_t vl) {
  return vsuxei16_v_i32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i32.nxv1i32.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32mf2_m(vbool64_t mask, int32_t *base,
                              vuint32mf2_t bindex, vint32mf2_t value,
                              size_t vl) {
  return vsuxei32_v_i32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i32.nxv2i32.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32m1_m(vbool32_t mask, int32_t *base, vuint32m1_t bindex,
                             vint32m1_t value, size_t vl) {
  return vsuxei32_v_i32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i32.nxv4i32.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32m2_m(vbool16_t mask, int32_t *base, vuint32m2_t bindex,
                             vint32m2_t value, size_t vl) {
  return vsuxei32_v_i32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i32.nxv8i32.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32m4_m(vbool8_t mask, int32_t *base, vuint32m4_t bindex,
                             vint32m4_t value, size_t vl) {
  return vsuxei32_v_i32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i32.nxv16i32.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i32m8_m(vbool4_t mask, int32_t *base, vuint32m8_t bindex,
                             vint32m8_t value, size_t vl) {
  return vsuxei32_v_i32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i32.nxv1i64.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i32mf2_m(vbool64_t mask, int32_t *base, vuint64m1_t bindex,
                              vint32mf2_t value, size_t vl) {
  return vsuxei64_v_i32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i32.nxv2i64.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i32m1_m(vbool32_t mask, int32_t *base, vuint64m2_t bindex,
                             vint32m1_t value, size_t vl) {
  return vsuxei64_v_i32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i32.nxv4i64.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i32m2_m(vbool16_t mask, int32_t *base, vuint64m4_t bindex,
                             vint32m2_t value, size_t vl) {
  return vsuxei64_v_i32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i32.nxv8i64.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i32m4_m(vbool8_t mask, int32_t *base, vuint64m8_t bindex,
                             vint32m4_t value, size_t vl) {
  return vsuxei64_v_i32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i64.nxv1i8.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i64m1_m(vbool64_t mask, int64_t *base, vuint8mf8_t bindex,
                            vint64m1_t value, size_t vl) {
  return vsuxei8_v_i64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i64.nxv2i8.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i64m2_m(vbool32_t mask, int64_t *base, vuint8mf4_t bindex,
                            vint64m2_t value, size_t vl) {
  return vsuxei8_v_i64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i64.nxv4i8.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i64m4_m(vbool16_t mask, int64_t *base, vuint8mf2_t bindex,
                            vint64m4_t value, size_t vl) {
  return vsuxei8_v_i64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_i64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i64.nxv8i8.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_i64m8_m(vbool8_t mask, int64_t *base, vuint8m1_t bindex,
                            vint64m8_t value, size_t vl) {
  return vsuxei8_v_i64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i64.nxv1i16.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i64m1_m(vbool64_t mask, int64_t *base, vuint16mf4_t bindex,
                             vint64m1_t value, size_t vl) {
  return vsuxei16_v_i64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i64.nxv2i16.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i64m2_m(vbool32_t mask, int64_t *base, vuint16mf2_t bindex,
                             vint64m2_t value, size_t vl) {
  return vsuxei16_v_i64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i64.nxv4i16.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i64m4_m(vbool16_t mask, int64_t *base, vuint16m1_t bindex,
                             vint64m4_t value, size_t vl) {
  return vsuxei16_v_i64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_i64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i64.nxv8i16.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_i64m8_m(vbool8_t mask, int64_t *base, vuint16m2_t bindex,
                             vint64m8_t value, size_t vl) {
  return vsuxei16_v_i64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i64.nxv1i32.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i64m1_m(vbool64_t mask, int64_t *base, vuint32mf2_t bindex,
                             vint64m1_t value, size_t vl) {
  return vsuxei32_v_i64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i64.nxv2i32.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i64m2_m(vbool32_t mask, int64_t *base, vuint32m1_t bindex,
                             vint64m2_t value, size_t vl) {
  return vsuxei32_v_i64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i64.nxv4i32.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i64m4_m(vbool16_t mask, int64_t *base, vuint32m2_t bindex,
                             vint64m4_t value, size_t vl) {
  return vsuxei32_v_i64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_i64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i64.nxv8i32.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_i64m8_m(vbool8_t mask, int64_t *base, vuint32m4_t bindex,
                             vint64m8_t value, size_t vl) {
  return vsuxei32_v_i64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i64.nxv1i64.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i64m1_m(vbool64_t mask, int64_t *base, vuint64m1_t bindex,
                             vint64m1_t value, size_t vl) {
  return vsuxei64_v_i64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i64.nxv2i64.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i64m2_m(vbool32_t mask, int64_t *base, vuint64m2_t bindex,
                             vint64m2_t value, size_t vl) {
  return vsuxei64_v_i64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i64.nxv4i64.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i64m4_m(vbool16_t mask, int64_t *base, vuint64m4_t bindex,
                             vint64m4_t value, size_t vl) {
  return vsuxei64_v_i64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_i64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i64.nxv8i64.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_i64m8_m(vbool8_t mask, int64_t *base, vuint64m8_t bindex,
                             vint64m8_t value, size_t vl) {
  return vsuxei64_v_i64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8mf8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i8.nxv1i8.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8mf8_m(vbool64_t mask, uint8_t *base, vuint8mf8_t bindex,
                            vuint8mf8_t value, size_t vl) {
  return vsuxei8_v_u8mf8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i8.nxv2i8.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8mf4_m(vbool32_t mask, uint8_t *base, vuint8mf4_t bindex,
                            vuint8mf4_t value, size_t vl) {
  return vsuxei8_v_u8mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i8.nxv4i8.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8mf2_m(vbool16_t mask, uint8_t *base, vuint8mf2_t bindex,
                            vuint8mf2_t value, size_t vl) {
  return vsuxei8_v_u8mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i8.nxv8i8.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8m1_m(vbool8_t mask, uint8_t *base, vuint8m1_t bindex,
                           vuint8m1_t value, size_t vl) {
  return vsuxei8_v_u8m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i8.nxv16i8.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8m2_m(vbool4_t mask, uint8_t *base, vuint8m2_t bindex,
                           vuint8m2_t value, size_t vl) {
  return vsuxei8_v_u8m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 32 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv32i8.nxv32i8.i64(<vscale x 32 x i8> [[VALUE:%.*]], <vscale x 32 x i8>* [[TMP0]], <vscale x 32 x i8> [[BINDEX:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8m4_m(vbool2_t mask, uint8_t *base, vuint8m4_t bindex,
                           vuint8m4_t value, size_t vl) {
  return vsuxei8_v_u8m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u8m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 64 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv64i8.nxv64i8.i64(<vscale x 64 x i8> [[VALUE:%.*]], <vscale x 64 x i8>* [[TMP0]], <vscale x 64 x i8> [[BINDEX:%.*]], <vscale x 64 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u8m8_m(vbool1_t mask, uint8_t *base, vuint8m8_t bindex,
                           vuint8m8_t value, size_t vl) {
  return vsuxei8_v_u8m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8mf8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i8.nxv1i16.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8mf8_m(vbool64_t mask, uint8_t *base, vuint16mf4_t bindex,
                             vuint8mf8_t value, size_t vl) {
  return vsuxei16_v_u8mf8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i8.nxv2i16.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8mf4_m(vbool32_t mask, uint8_t *base, vuint16mf2_t bindex,
                             vuint8mf4_t value, size_t vl) {
  return vsuxei16_v_u8mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i8.nxv4i16.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8mf2_m(vbool16_t mask, uint8_t *base, vuint16m1_t bindex,
                             vuint8mf2_t value, size_t vl) {
  return vsuxei16_v_u8mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i8.nxv8i16.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8m1_m(vbool8_t mask, uint8_t *base, vuint16m2_t bindex,
                            vuint8m1_t value, size_t vl) {
  return vsuxei16_v_u8m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i8.nxv16i16.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8m2_m(vbool4_t mask, uint8_t *base, vuint16m4_t bindex,
                            vuint8m2_t value, size_t vl) {
  return vsuxei16_v_u8m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u8m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 32 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv32i8.nxv32i16.i64(<vscale x 32 x i8> [[VALUE:%.*]], <vscale x 32 x i8>* [[TMP0]], <vscale x 32 x i16> [[BINDEX:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u8m4_m(vbool2_t mask, uint8_t *base, vuint16m8_t bindex,
                            vuint8m4_t value, size_t vl) {
  return vsuxei16_v_u8m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8mf8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i8.nxv1i32.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8mf8_m(vbool64_t mask, uint8_t *base, vuint32mf2_t bindex,
                             vuint8mf8_t value, size_t vl) {
  return vsuxei32_v_u8mf8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i8.nxv2i32.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8mf4_m(vbool32_t mask, uint8_t *base, vuint32m1_t bindex,
                             vuint8mf4_t value, size_t vl) {
  return vsuxei32_v_u8mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i8.nxv4i32.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8mf2_m(vbool16_t mask, uint8_t *base, vuint32m2_t bindex,
                             vuint8mf2_t value, size_t vl) {
  return vsuxei32_v_u8mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i8.nxv8i32.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8m1_m(vbool8_t mask, uint8_t *base, vuint32m4_t bindex,
                            vuint8m1_t value, size_t vl) {
  return vsuxei32_v_u8m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u8m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 16 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i8.nxv16i32.i64(<vscale x 16 x i8> [[VALUE:%.*]], <vscale x 16 x i8>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u8m2_m(vbool4_t mask, uint8_t *base, vuint32m8_t bindex,
                            vuint8m2_t value, size_t vl) {
  return vsuxei32_v_u8m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u8mf8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 1 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i8.nxv1i64.i64(<vscale x 1 x i8> [[VALUE:%.*]], <vscale x 1 x i8>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u8mf8_m(vbool64_t mask, uint8_t *base, vuint64m1_t bindex,
                             vuint8mf8_t value, size_t vl) {
  return vsuxei64_v_u8mf8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u8mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 2 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i8.nxv2i64.i64(<vscale x 2 x i8> [[VALUE:%.*]], <vscale x 2 x i8>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u8mf4_m(vbool32_t mask, uint8_t *base, vuint64m2_t bindex,
                             vuint8mf4_t value, size_t vl) {
  return vsuxei64_v_u8mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u8mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 4 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i8.nxv4i64.i64(<vscale x 4 x i8> [[VALUE:%.*]], <vscale x 4 x i8>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u8mf2_m(vbool16_t mask, uint8_t *base, vuint64m4_t bindex,
                             vuint8mf2_t value, size_t vl) {
  return vsuxei64_v_u8mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u8m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i8* [[BASE:%.*]] to <vscale x 8 x i8>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i8.nxv8i64.i64(<vscale x 8 x i8> [[VALUE:%.*]], <vscale x 8 x i8>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u8m1_m(vbool8_t mask, uint8_t *base, vuint64m8_t bindex,
                            vuint8m1_t value, size_t vl) {
  return vsuxei64_v_u8m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i16.nxv1i8.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16mf4_m(vbool64_t mask, uint16_t *base, vuint8mf8_t bindex,
                             vuint16mf4_t value, size_t vl) {
  return vsuxei8_v_u16mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i16.nxv2i8.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16mf2_m(vbool32_t mask, uint16_t *base, vuint8mf4_t bindex,
                             vuint16mf2_t value, size_t vl) {
  return vsuxei8_v_u16mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i16.nxv4i8.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16m1_m(vbool16_t mask, uint16_t *base, vuint8mf2_t bindex,
                            vuint16m1_t value, size_t vl) {
  return vsuxei8_v_u16m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i16.nxv8i8.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16m2_m(vbool8_t mask, uint16_t *base, vuint8m1_t bindex,
                            vuint16m2_t value, size_t vl) {
  return vsuxei8_v_u16m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i16.nxv16i8.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16m4_m(vbool4_t mask, uint16_t *base, vuint8m2_t bindex,
                            vuint16m4_t value, size_t vl) {
  return vsuxei8_v_u16m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u16m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 32 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv32i16.nxv32i8.i64(<vscale x 32 x i16> [[VALUE:%.*]], <vscale x 32 x i16>* [[TMP0]], <vscale x 32 x i8> [[BINDEX:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u16m8_m(vbool2_t mask, uint16_t *base, vuint8m4_t bindex,
                            vuint16m8_t value, size_t vl) {
  return vsuxei8_v_u16m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i16.nxv1i16.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16mf4_m(vbool64_t mask, uint16_t *base,
                              vuint16mf4_t bindex, vuint16mf4_t value,
                              size_t vl) {
  return vsuxei16_v_u16mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i16.nxv2i16.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16mf2_m(vbool32_t mask, uint16_t *base,
                              vuint16mf2_t bindex, vuint16mf2_t value,
                              size_t vl) {
  return vsuxei16_v_u16mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i16.nxv4i16.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16m1_m(vbool16_t mask, uint16_t *base, vuint16m1_t bindex,
                             vuint16m1_t value, size_t vl) {
  return vsuxei16_v_u16m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i16.nxv8i16.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16m2_m(vbool8_t mask, uint16_t *base, vuint16m2_t bindex,
                             vuint16m2_t value, size_t vl) {
  return vsuxei16_v_u16m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i16.nxv16i16.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16m4_m(vbool4_t mask, uint16_t *base, vuint16m4_t bindex,
                             vuint16m4_t value, size_t vl) {
  return vsuxei16_v_u16m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u16m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 32 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv32i16.nxv32i16.i64(<vscale x 32 x i16> [[VALUE:%.*]], <vscale x 32 x i16>* [[TMP0]], <vscale x 32 x i16> [[BINDEX:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u16m8_m(vbool2_t mask, uint16_t *base, vuint16m8_t bindex,
                             vuint16m8_t value, size_t vl) {
  return vsuxei16_v_u16m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i16.nxv1i32.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16mf4_m(vbool64_t mask, uint16_t *base,
                              vuint32mf2_t bindex, vuint16mf4_t value,
                              size_t vl) {
  return vsuxei32_v_u16mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i16.nxv2i32.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16mf2_m(vbool32_t mask, uint16_t *base,
                              vuint32m1_t bindex, vuint16mf2_t value,
                              size_t vl) {
  return vsuxei32_v_u16mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i16.nxv4i32.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16m1_m(vbool16_t mask, uint16_t *base, vuint32m2_t bindex,
                             vuint16m1_t value, size_t vl) {
  return vsuxei32_v_u16m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i16.nxv8i32.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16m2_m(vbool8_t mask, uint16_t *base, vuint32m4_t bindex,
                             vuint16m2_t value, size_t vl) {
  return vsuxei32_v_u16m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u16m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 16 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i16.nxv16i32.i64(<vscale x 16 x i16> [[VALUE:%.*]], <vscale x 16 x i16>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u16m4_m(vbool4_t mask, uint16_t *base, vuint32m8_t bindex,
                             vuint16m4_t value, size_t vl) {
  return vsuxei32_v_u16m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 1 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i16.nxv1i64.i64(<vscale x 1 x i16> [[VALUE:%.*]], <vscale x 1 x i16>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u16mf4_m(vbool64_t mask, uint16_t *base,
                              vuint64m1_t bindex, vuint16mf4_t value,
                              size_t vl) {
  return vsuxei64_v_u16mf4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 2 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i16.nxv2i64.i64(<vscale x 2 x i16> [[VALUE:%.*]], <vscale x 2 x i16>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u16mf2_m(vbool32_t mask, uint16_t *base,
                              vuint64m2_t bindex, vuint16mf2_t value,
                              size_t vl) {
  return vsuxei64_v_u16mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 4 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i16.nxv4i64.i64(<vscale x 4 x i16> [[VALUE:%.*]], <vscale x 4 x i16>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u16m1_m(vbool16_t mask, uint16_t *base, vuint64m4_t bindex,
                             vuint16m1_t value, size_t vl) {
  return vsuxei64_v_u16m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i16* [[BASE:%.*]] to <vscale x 8 x i16>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i16.nxv8i64.i64(<vscale x 8 x i16> [[VALUE:%.*]], <vscale x 8 x i16>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u16m2_m(vbool8_t mask, uint16_t *base, vuint64m8_t bindex,
                             vuint16m2_t value, size_t vl) {
  return vsuxei64_v_u16m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i32.nxv1i8.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32mf2_m(vbool64_t mask, uint32_t *base, vuint8mf8_t bindex,
                             vuint32mf2_t value, size_t vl) {
  return vsuxei8_v_u32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i32.nxv2i8.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32m1_m(vbool32_t mask, uint32_t *base, vuint8mf4_t bindex,
                            vuint32m1_t value, size_t vl) {
  return vsuxei8_v_u32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i32.nxv4i8.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32m2_m(vbool16_t mask, uint32_t *base, vuint8mf2_t bindex,
                            vuint32m2_t value, size_t vl) {
  return vsuxei8_v_u32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i32.nxv8i8.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32m4_m(vbool8_t mask, uint32_t *base, vuint8m1_t bindex,
                            vuint32m4_t value, size_t vl) {
  return vsuxei8_v_u32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i32.nxv16i8.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u32m8_m(vbool4_t mask, uint32_t *base, vuint8m2_t bindex,
                            vuint32m8_t value, size_t vl) {
  return vsuxei8_v_u32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i32.nxv1i16.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32mf2_m(vbool64_t mask, uint32_t *base,
                              vuint16mf4_t bindex, vuint32mf2_t value,
                              size_t vl) {
  return vsuxei16_v_u32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i32.nxv2i16.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32m1_m(vbool32_t mask, uint32_t *base,
                             vuint16mf2_t bindex, vuint32m1_t value,
                             size_t vl) {
  return vsuxei16_v_u32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i32.nxv4i16.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32m2_m(vbool16_t mask, uint32_t *base, vuint16m1_t bindex,
                             vuint32m2_t value, size_t vl) {
  return vsuxei16_v_u32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i32.nxv8i16.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32m4_m(vbool8_t mask, uint32_t *base, vuint16m2_t bindex,
                             vuint32m4_t value, size_t vl) {
  return vsuxei16_v_u32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i32.nxv16i16.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u32m8_m(vbool4_t mask, uint32_t *base, vuint16m4_t bindex,
                             vuint32m8_t value, size_t vl) {
  return vsuxei16_v_u32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i32.nxv1i32.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32mf2_m(vbool64_t mask, uint32_t *base,
                              vuint32mf2_t bindex, vuint32mf2_t value,
                              size_t vl) {
  return vsuxei32_v_u32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i32.nxv2i32.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32m1_m(vbool32_t mask, uint32_t *base, vuint32m1_t bindex,
                             vuint32m1_t value, size_t vl) {
  return vsuxei32_v_u32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i32.nxv4i32.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32m2_m(vbool16_t mask, uint32_t *base, vuint32m2_t bindex,
                             vuint32m2_t value, size_t vl) {
  return vsuxei32_v_u32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i32.nxv8i32.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32m4_m(vbool8_t mask, uint32_t *base, vuint32m4_t bindex,
                             vuint32m4_t value, size_t vl) {
  return vsuxei32_v_u32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 16 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16i32.nxv16i32.i64(<vscale x 16 x i32> [[VALUE:%.*]], <vscale x 16 x i32>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u32m8_m(vbool4_t mask, uint32_t *base, vuint32m8_t bindex,
                             vuint32m8_t value, size_t vl) {
  return vsuxei32_v_u32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 1 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i32.nxv1i64.i64(<vscale x 1 x i32> [[VALUE:%.*]], <vscale x 1 x i32>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u32mf2_m(vbool64_t mask, uint32_t *base,
                              vuint64m1_t bindex, vuint32mf2_t value,
                              size_t vl) {
  return vsuxei64_v_u32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 2 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i32.nxv2i64.i64(<vscale x 2 x i32> [[VALUE:%.*]], <vscale x 2 x i32>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u32m1_m(vbool32_t mask, uint32_t *base, vuint64m2_t bindex,
                             vuint32m1_t value, size_t vl) {
  return vsuxei64_v_u32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 4 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i32.nxv4i64.i64(<vscale x 4 x i32> [[VALUE:%.*]], <vscale x 4 x i32>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u32m2_m(vbool16_t mask, uint32_t *base, vuint64m4_t bindex,
                             vuint32m2_t value, size_t vl) {
  return vsuxei64_v_u32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i32* [[BASE:%.*]] to <vscale x 8 x i32>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i32.nxv8i64.i64(<vscale x 8 x i32> [[VALUE:%.*]], <vscale x 8 x i32>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u32m4_m(vbool8_t mask, uint32_t *base, vuint64m8_t bindex,
                             vuint32m4_t value, size_t vl) {
  return vsuxei64_v_u32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i64.nxv1i8.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u64m1_m(vbool64_t mask, uint64_t *base, vuint8mf8_t bindex,
                            vuint64m1_t value, size_t vl) {
  return vsuxei8_v_u64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i64.nxv2i8.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u64m2_m(vbool32_t mask, uint64_t *base, vuint8mf4_t bindex,
                            vuint64m2_t value, size_t vl) {
  return vsuxei8_v_u64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i64.nxv4i8.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u64m4_m(vbool16_t mask, uint64_t *base, vuint8mf2_t bindex,
                            vuint64m4_t value, size_t vl) {
  return vsuxei8_v_u64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_u64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i64.nxv8i8.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_u64m8_m(vbool8_t mask, uint64_t *base, vuint8m1_t bindex,
                            vuint64m8_t value, size_t vl) {
  return vsuxei8_v_u64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i64.nxv1i16.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u64m1_m(vbool64_t mask, uint64_t *base,
                             vuint16mf4_t bindex, vuint64m1_t value,
                             size_t vl) {
  return vsuxei16_v_u64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i64.nxv2i16.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u64m2_m(vbool32_t mask, uint64_t *base,
                             vuint16mf2_t bindex, vuint64m2_t value,
                             size_t vl) {
  return vsuxei16_v_u64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i64.nxv4i16.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u64m4_m(vbool16_t mask, uint64_t *base, vuint16m1_t bindex,
                             vuint64m4_t value, size_t vl) {
  return vsuxei16_v_u64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_u64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i64.nxv8i16.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_u64m8_m(vbool8_t mask, uint64_t *base, vuint16m2_t bindex,
                             vuint64m8_t value, size_t vl) {
  return vsuxei16_v_u64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i64.nxv1i32.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u64m1_m(vbool64_t mask, uint64_t *base,
                             vuint32mf2_t bindex, vuint64m1_t value,
                             size_t vl) {
  return vsuxei32_v_u64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i64.nxv2i32.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u64m2_m(vbool32_t mask, uint64_t *base, vuint32m1_t bindex,
                             vuint64m2_t value, size_t vl) {
  return vsuxei32_v_u64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i64.nxv4i32.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u64m4_m(vbool16_t mask, uint64_t *base, vuint32m2_t bindex,
                             vuint64m4_t value, size_t vl) {
  return vsuxei32_v_u64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_u64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i64.nxv8i32.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_u64m8_m(vbool8_t mask, uint64_t *base, vuint32m4_t bindex,
                             vuint64m8_t value, size_t vl) {
  return vsuxei32_v_u64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 1 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1i64.nxv1i64.i64(<vscale x 1 x i64> [[VALUE:%.*]], <vscale x 1 x i64>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u64m1_m(vbool64_t mask, uint64_t *base, vuint64m1_t bindex,
                             vuint64m1_t value, size_t vl) {
  return vsuxei64_v_u64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 2 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2i64.nxv2i64.i64(<vscale x 2 x i64> [[VALUE:%.*]], <vscale x 2 x i64>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u64m2_m(vbool32_t mask, uint64_t *base, vuint64m2_t bindex,
                             vuint64m2_t value, size_t vl) {
  return vsuxei64_v_u64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 4 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4i64.nxv4i64.i64(<vscale x 4 x i64> [[VALUE:%.*]], <vscale x 4 x i64>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u64m4_m(vbool16_t mask, uint64_t *base, vuint64m4_t bindex,
                             vuint64m4_t value, size_t vl) {
  return vsuxei64_v_u64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_u64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast i64* [[BASE:%.*]] to <vscale x 8 x i64>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8i64.nxv8i64.i64(<vscale x 8 x i64> [[VALUE:%.*]], <vscale x 8 x i64>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_u64m8_m(vbool8_t mask, uint64_t *base, vuint64m8_t bindex,
                             vuint64m8_t value, size_t vl) {
  return vsuxei64_v_u64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 1 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1f32.nxv1i8.i64(<vscale x 1 x float> [[VALUE:%.*]], <vscale x 1 x float>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32mf2_m(vbool64_t mask, float *base, vuint8mf8_t bindex,
                             vfloat32mf2_t value, size_t vl) {
  return vsuxei8_v_f32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 2 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2f32.nxv2i8.i64(<vscale x 2 x float> [[VALUE:%.*]], <vscale x 2 x float>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32m1_m(vbool32_t mask, float *base, vuint8mf4_t bindex,
                            vfloat32m1_t value, size_t vl) {
  return vsuxei8_v_f32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 4 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4f32.nxv4i8.i64(<vscale x 4 x float> [[VALUE:%.*]], <vscale x 4 x float>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32m2_m(vbool16_t mask, float *base, vuint8mf2_t bindex,
                            vfloat32m2_t value, size_t vl) {
  return vsuxei8_v_f32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 8 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8f32.nxv8i8.i64(<vscale x 8 x float> [[VALUE:%.*]], <vscale x 8 x float>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32m4_m(vbool8_t mask, float *base, vuint8m1_t bindex,
                            vfloat32m4_t value, size_t vl) {
  return vsuxei8_v_f32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 16 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16f32.nxv16i8.i64(<vscale x 16 x float> [[VALUE:%.*]], <vscale x 16 x float>* [[TMP0]], <vscale x 16 x i8> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f32m8_m(vbool4_t mask, float *base, vuint8m2_t bindex,
                            vfloat32m8_t value, size_t vl) {
  return vsuxei8_v_f32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 1 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1f32.nxv1i16.i64(<vscale x 1 x float> [[VALUE:%.*]], <vscale x 1 x float>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32mf2_m(vbool64_t mask, float *base, vuint16mf4_t bindex,
                              vfloat32mf2_t value, size_t vl) {
  return vsuxei16_v_f32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 2 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2f32.nxv2i16.i64(<vscale x 2 x float> [[VALUE:%.*]], <vscale x 2 x float>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32m1_m(vbool32_t mask, float *base, vuint16mf2_t bindex,
                             vfloat32m1_t value, size_t vl) {
  return vsuxei16_v_f32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 4 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4f32.nxv4i16.i64(<vscale x 4 x float> [[VALUE:%.*]], <vscale x 4 x float>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32m2_m(vbool16_t mask, float *base, vuint16m1_t bindex,
                             vfloat32m2_t value, size_t vl) {
  return vsuxei16_v_f32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 8 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8f32.nxv8i16.i64(<vscale x 8 x float> [[VALUE:%.*]], <vscale x 8 x float>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32m4_m(vbool8_t mask, float *base, vuint16m2_t bindex,
                             vfloat32m4_t value, size_t vl) {
  return vsuxei16_v_f32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 16 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16f32.nxv16i16.i64(<vscale x 16 x float> [[VALUE:%.*]], <vscale x 16 x float>* [[TMP0]], <vscale x 16 x i16> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f32m8_m(vbool4_t mask, float *base, vuint16m4_t bindex,
                             vfloat32m8_t value, size_t vl) {
  return vsuxei16_v_f32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 1 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1f32.nxv1i32.i64(<vscale x 1 x float> [[VALUE:%.*]], <vscale x 1 x float>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32mf2_m(vbool64_t mask, float *base, vuint32mf2_t bindex,
                              vfloat32mf2_t value, size_t vl) {
  return vsuxei32_v_f32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 2 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2f32.nxv2i32.i64(<vscale x 2 x float> [[VALUE:%.*]], <vscale x 2 x float>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32m1_m(vbool32_t mask, float *base, vuint32m1_t bindex,
                             vfloat32m1_t value, size_t vl) {
  return vsuxei32_v_f32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 4 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4f32.nxv4i32.i64(<vscale x 4 x float> [[VALUE:%.*]], <vscale x 4 x float>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32m2_m(vbool16_t mask, float *base, vuint32m2_t bindex,
                             vfloat32m2_t value, size_t vl) {
  return vsuxei32_v_f32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 8 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8f32.nxv8i32.i64(<vscale x 8 x float> [[VALUE:%.*]], <vscale x 8 x float>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32m4_m(vbool8_t mask, float *base, vuint32m4_t bindex,
                             vfloat32m4_t value, size_t vl) {
  return vsuxei32_v_f32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 16 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv16f32.nxv16i32.i64(<vscale x 16 x float> [[VALUE:%.*]], <vscale x 16 x float>* [[TMP0]], <vscale x 16 x i32> [[BINDEX:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f32m8_m(vbool4_t mask, float *base, vuint32m8_t bindex,
                             vfloat32m8_t value, size_t vl) {
  return vsuxei32_v_f32m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 1 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1f32.nxv1i64.i64(<vscale x 1 x float> [[VALUE:%.*]], <vscale x 1 x float>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f32mf2_m(vbool64_t mask, float *base, vuint64m1_t bindex,
                              vfloat32mf2_t value, size_t vl) {
  return vsuxei64_v_f32mf2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 2 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2f32.nxv2i64.i64(<vscale x 2 x float> [[VALUE:%.*]], <vscale x 2 x float>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f32m1_m(vbool32_t mask, float *base, vuint64m2_t bindex,
                             vfloat32m1_t value, size_t vl) {
  return vsuxei64_v_f32m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 4 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4f32.nxv4i64.i64(<vscale x 4 x float> [[VALUE:%.*]], <vscale x 4 x float>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f32m2_m(vbool16_t mask, float *base, vuint64m4_t bindex,
                             vfloat32m2_t value, size_t vl) {
  return vsuxei64_v_f32m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast float* [[BASE:%.*]] to <vscale x 8 x float>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8f32.nxv8i64.i64(<vscale x 8 x float> [[VALUE:%.*]], <vscale x 8 x float>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f32m4_m(vbool8_t mask, float *base, vuint64m8_t bindex,
                             vfloat32m4_t value, size_t vl) {
  return vsuxei64_v_f32m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 1 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1f64.nxv1i8.i64(<vscale x 1 x double> [[VALUE:%.*]], <vscale x 1 x double>* [[TMP0]], <vscale x 1 x i8> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f64m1_m(vbool64_t mask, double *base, vuint8mf8_t bindex,
                            vfloat64m1_t value, size_t vl) {
  return vsuxei8_v_f64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 2 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2f64.nxv2i8.i64(<vscale x 2 x double> [[VALUE:%.*]], <vscale x 2 x double>* [[TMP0]], <vscale x 2 x i8> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f64m2_m(vbool32_t mask, double *base, vuint8mf4_t bindex,
                            vfloat64m2_t value, size_t vl) {
  return vsuxei8_v_f64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 4 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4f64.nxv4i8.i64(<vscale x 4 x double> [[VALUE:%.*]], <vscale x 4 x double>* [[TMP0]], <vscale x 4 x i8> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f64m4_m(vbool16_t mask, double *base, vuint8mf2_t bindex,
                            vfloat64m4_t value, size_t vl) {
  return vsuxei8_v_f64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei8_v_f64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 8 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8f64.nxv8i8.i64(<vscale x 8 x double> [[VALUE:%.*]], <vscale x 8 x double>* [[TMP0]], <vscale x 8 x i8> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei8_v_f64m8_m(vbool8_t mask, double *base, vuint8m1_t bindex,
                            vfloat64m8_t value, size_t vl) {
  return vsuxei8_v_f64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 1 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1f64.nxv1i16.i64(<vscale x 1 x double> [[VALUE:%.*]], <vscale x 1 x double>* [[TMP0]], <vscale x 1 x i16> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f64m1_m(vbool64_t mask, double *base, vuint16mf4_t bindex,
                             vfloat64m1_t value, size_t vl) {
  return vsuxei16_v_f64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 2 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2f64.nxv2i16.i64(<vscale x 2 x double> [[VALUE:%.*]], <vscale x 2 x double>* [[TMP0]], <vscale x 2 x i16> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f64m2_m(vbool32_t mask, double *base, vuint16mf2_t bindex,
                             vfloat64m2_t value, size_t vl) {
  return vsuxei16_v_f64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 4 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4f64.nxv4i16.i64(<vscale x 4 x double> [[VALUE:%.*]], <vscale x 4 x double>* [[TMP0]], <vscale x 4 x i16> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f64m4_m(vbool16_t mask, double *base, vuint16m1_t bindex,
                             vfloat64m4_t value, size_t vl) {
  return vsuxei16_v_f64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei16_v_f64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 8 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8f64.nxv8i16.i64(<vscale x 8 x double> [[VALUE:%.*]], <vscale x 8 x double>* [[TMP0]], <vscale x 8 x i16> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei16_v_f64m8_m(vbool8_t mask, double *base, vuint16m2_t bindex,
                             vfloat64m8_t value, size_t vl) {
  return vsuxei16_v_f64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 1 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1f64.nxv1i32.i64(<vscale x 1 x double> [[VALUE:%.*]], <vscale x 1 x double>* [[TMP0]], <vscale x 1 x i32> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f64m1_m(vbool64_t mask, double *base, vuint32mf2_t bindex,
                             vfloat64m1_t value, size_t vl) {
  return vsuxei32_v_f64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 2 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2f64.nxv2i32.i64(<vscale x 2 x double> [[VALUE:%.*]], <vscale x 2 x double>* [[TMP0]], <vscale x 2 x i32> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f64m2_m(vbool32_t mask, double *base, vuint32m1_t bindex,
                             vfloat64m2_t value, size_t vl) {
  return vsuxei32_v_f64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 4 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4f64.nxv4i32.i64(<vscale x 4 x double> [[VALUE:%.*]], <vscale x 4 x double>* [[TMP0]], <vscale x 4 x i32> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f64m4_m(vbool16_t mask, double *base, vuint32m2_t bindex,
                             vfloat64m4_t value, size_t vl) {
  return vsuxei32_v_f64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei32_v_f64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 8 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8f64.nxv8i32.i64(<vscale x 8 x double> [[VALUE:%.*]], <vscale x 8 x double>* [[TMP0]], <vscale x 8 x i32> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei32_v_f64m8_m(vbool8_t mask, double *base, vuint32m4_t bindex,
                             vfloat64m8_t value, size_t vl) {
  return vsuxei32_v_f64m8_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 1 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv1f64.nxv1i64.i64(<vscale x 1 x double> [[VALUE:%.*]], <vscale x 1 x double>* [[TMP0]], <vscale x 1 x i64> [[BINDEX:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f64m1_m(vbool64_t mask, double *base, vuint64m1_t bindex,
                             vfloat64m1_t value, size_t vl) {
  return vsuxei64_v_f64m1_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 2 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv2f64.nxv2i64.i64(<vscale x 2 x double> [[VALUE:%.*]], <vscale x 2 x double>* [[TMP0]], <vscale x 2 x i64> [[BINDEX:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f64m2_m(vbool32_t mask, double *base, vuint64m2_t bindex,
                             vfloat64m2_t value, size_t vl) {
  return vsuxei64_v_f64m2_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 4 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv4f64.nxv4i64.i64(<vscale x 4 x double> [[VALUE:%.*]], <vscale x 4 x double>* [[TMP0]], <vscale x 4 x i64> [[BINDEX:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f64m4_m(vbool16_t mask, double *base, vuint64m4_t bindex,
                             vfloat64m4_t value, size_t vl) {
  return vsuxei64_v_f64m4_m(mask, base, bindex, value, vl);
}

//
// CHECK-RV64-LABEL: @test_vsuxei64_v_f64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = bitcast double* [[BASE:%.*]] to <vscale x 8 x double>*
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsuxei.mask.nxv8f64.nxv8i64.i64(<vscale x 8 x double> [[VALUE:%.*]], <vscale x 8 x double>* [[TMP0]], <vscale x 8 x i64> [[BINDEX:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_vsuxei64_v_f64m8_m(vbool8_t mask, double *base, vuint64m8_t bindex,
                             vfloat64m8_t value, size_t vl) {
  return vsuxei64_v_f64m8_m(mask, base, bindex, value, vl);
}
