.\"
.\"
.\" Copyright © 2013 Keith Packard
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that copyright
.\" notice and this permission notice appear in supporting documentation, and
.\" that the name of the copyright holders not be used in advertising or
.\" publicity pertaining to distribution of the software without specific,
.\" written prior permission.  The copyright holders make no representations
.\" about the suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
.\" OF THIS SOFTWARE.
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH XPRESENT __libmansuffix__ 2022-08-27 __xorgversion__
.SH NAME
Xpresent \- X Present Extension
.SH SYNTAX
\&#include <X11/extensions/Xpresent.h>
.nf
.sp
Bool XPresentQueryExtension \^(\^Display *\fIdpy\fP, int *\fImajor_opcode_return\fP,
	int *\fIevent_base_return\fP, int *\fIerror_base_return\fP\^);
.sp
Status XPresentQueryVersion \^(\^Display *\fIdpy\fP,
	int *\fImajor_version_return\fP,
	int *\fIminor_version_return\fP\^);
.sp
int XPresentVersion (void);
.fi
.SH ARGUMENTS
.IP \fIdpy\fP 1i
Specifies the connection to the X server.
.SH DESCRIPTION
.B Xpresent
is a library designed to interface the X Present Extension.
The Present extension provides a way for applications to update their
window contents from a pixmap in a well defined fashion, synchronizing
with the display refresh and potentially using a more efficient
mechanism than copying the contents of the source pixmap.
.PP
The
.B XPresentQueryExtension
function checks if the X server specified by \fIdpy\fP supports the X Present
extension.
If the server does not support the extension, it returns
.BR False .
If the server does support the extension, it returns
.BR True ,
and sets the values of \fImajor_opcode_return\fP, \fIevent_base_return\fP, and
\fIerror_base_return\fP if the pointers are not NULL.
.PP
Clients must call the
.B XPresentQueryExtension
function to verify the server supports the extension before calling any other
function for this extension.
.PP
The
.B XPresentQueryVersion
function sets the values pointed to by \fImajor_version_return\fP and
\fIminor_version_return\fP to the version of the extension supported
by the X server specified by \fIdpy\fP.
The
.B XPresentQueryVersion
function returns the version of the libXpresent library in use, as defined
by the \fBPRESENT_VERSION\fP macro in <X11/extensions/Xpresent.h>.
.SH SEE ALSO
.BR XPresentNotifyMSC (__libmansuffix__),
.BR XPresentPixmap (__libmansuffix__),
.BR XPresentQueryCapabilities (__libmansuffix__),
.BR XPresentSelectInput (__libmansuffix__)
.SH RESTRICTIONS
.B Xpresent
will remain upward compatible after the 1.0 release.
.SH AUTHORS
Keith Packard, Intel
