//
//  XTHtmlTagDl.m
//  XTads
//
//  Created by Rune Berg on 13/01/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTHtmlTagDl.h"


@implementation XTHtmlTagDl

+ (NSString *)name
{
	return @"dl";
}

- (BOOL)needsBlockLevelSpacingBefore
{
	return YES;
}

- (BOOL)needsBlockLevelSpacingAfter
{
	return YES;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	res.dlLevel = formattingSpec.dlLevel + 1;
	res.dd = NO;
	return res;
}

- (BOOL)contributesToListNestingLevel
{
	return NO;
}

@end
