//
//  XTRecentGameFiles.h
//  XTads
//
//  Created by Rune Berg on 06/08/15.
//  Copyright (c) 2015 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface XTRecentGameFilesEntry : NSObject

@property NSURL *gameFileUrl;
@property NSString *gameTitle;

+ (instancetype)entryWithGameFileUrl:(NSURL *)gameFileUrl gameTitle:(NSString *)gameTitle;

@end


@interface XTRecentGameFiles : NSObject

@property NSUInteger maxNumberOfEntries;
@property (readonly) NSUInteger numberOfEntries;

// Get/create the singleton instance
+ (instancetype)recentGameFiles;

- (void)removeAllEntries;

- (void)persist;

- (void)restoreFromPersisted;

- (void)addNewestEntry:(XTRecentGameFilesEntry *)entry;

- (XTRecentGameFilesEntry *)entryAtIndex:(NSUInteger)index;

@end
