//
//  XTBaseTextHandler.h
//  XTads
//
//  Created by Rune Berg on 11/08/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTGameWindowController.h"
#import "XTOutputFormatter.h"
#import "XTOutputTextParserPlain.h"
#import "XTOutputTextParserHtml.h"
#import "XTPrefs.h"


#define NO_CHILD_INDEX  (-1)


@interface XTBaseTextHandler : NSObject

@property (readonly) NSUInteger bannerIndex;

@property NSScrollView *scrollView; // Needs to be a _strong_ ref, because of our banner relayout code
@property (unsafe_unretained) XTTextView *textView;

@property (weak) XTGameWindowController *gameWindowController;
@property XTOutputTextParserPlain *outputTextParserPlain;
@property XTOutputTextParserHtml *outputTextParserHtml;
@property XTOutputFormatter *outputFormatter;

@property (nonatomic) BOOL htmlMode;


- (void)traceWithIndentLevel:(NSUInteger)indentLevel;

- (id<XTOutputTextParserProtocol>)getOutputTextParser;

- (void)setHiliteMode:(BOOL)hiliteMode;

- (void)setColorsFromPrefs;

- (void)resetForNextCommand;

- (BOOL)formattingQueueNeedsFlushing;

- (void)mainThread_pumpOutputText:(NSMutableArray *)retValHolder;

- (void)mainThread_removeHandler;

- (void)moveCursorToEndOfOutputPosition;

// the index where new output text should be appended
- (NSUInteger)endOfOutputPosition;

- (void)mainThread_noteStartOfPagination;

- (void)scrollToBottom;

- (BOOL)paginationIsActive;

- (BOOL)awaitingMorePromptForPagination;

- (void)noteScrollPositionAtStartOfWindowResize;

- (void)restoreScrollPositionAtEndOfWindowResize;

@end
