//
//  XTTimedCommandState.m
//  XTads
//
//  Created by Rune Berg on 24/03/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTTimedCommandState.h"


@implementation XTTimedCommandState

- (instancetype)init
{
	self = [super init];
	if (self) {
		_state = XTTimedCommandStateInitial;
		_command = nil;
		_cursorOffsetFromEndOfCommand = NSMakeRange(0, 0);
		_selectedTextAffinity = NSSelectionAffinityUpstream;
	}
	return self;
}

- (BOOL)isTimedOut
{
	BOOL res = (self.state == XTTimedCommandStateTimedOut);
	return res;
}

- (void)setTimedOut
{
	self.state = XTTimedCommandStateTimedOut;
}

- (BOOL)isCancelled
{
	BOOL res = (self.state == XTTimedCommandStateCancelled);
	return res;
}

- (void)setCancelled
{
	self.state = XTTimedCommandStateCancelled;
}

@end
