//
//  XTHtmlTag.h
//  TadsTerp
//
//  Created by Rune Berg on 29/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTOutputTextParserProtocol.h"
#import "XTOutputFormatterProtocol.h"
#import "XTFormattingSpecification.h"
#import "XTPair.h"

@class XTBaseTextHandler;
@class XTHtmlTagContainer;


@interface XTHtmlTag : NSObject

+ (NSString *)name; // for <BR> this would be "BR"
+ (NSArray<NSString *>*)nameSynonyms;
+ (BOOL)standalone;
+ (BOOL)forT2;
+ (BOOL)forT3;

@property (readonly) NSString *name;

@property BOOL closing;
@property (readonly) BOOL isBlockLevel;

@property (readonly) NSUInteger uniqueId; // for logging/debugging

@property BOOL hasFormatted;

//			void CHtmlTagContainer::append_to_sublist(CHtmlTag *tag)
//			corresponds to our container's appendToContents
//				TODO!!! when is this called? - see htmlprs.cpp x 4

- (BOOL)blockLevel;

- (BOOL)blockLevelSpacingBefore;

- (BOOL)blockLevelSpacingAfter;

- (XTHtmlTagContainer *)getContainer;

- (void)assertHasContainer;

- (void)removeFromContainer;

- (XTHtmlTagContainer *)findCorrectContainer:(XTHtmlTagContainer *)defaultContainer;

- (void)onParsing:(NSObject<XTOutputTextParserProtocol> *)parser;

- (void)onEndTag:(NSObject<XTOutputTextParserProtocol> *)parser;

- (BOOL)isReadyToFormat;

- (void)preFormatForBlockLevel:(NSObject<XTOutputFormatterProtocol> *)formatter
				   textHandler:(XTBaseTextHandler *)textHandler;

- (void)checkNotHasFormatted;

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler;

- (void)noteHasFormatted;

- (void)postFormatForBlockLevel:(NSObject<XTOutputFormatterProtocol> *)formatter
					textHandler:(XTBaseTextHandler *)textHandler;

//TODO !!! overrides...
- (XTHtmlTag *)getNextTagToFormat:(NSObject<XTOutputFormatterProtocol> *)formatter
					  textHandler:(XTBaseTextHandler *)textHandler
					 shouldFormat:(BOOL)shouldFormat;

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec;

- (XTTextAlignMode)getTextAlignModeFrom:(XTTextAlignMode)currentTextAlignMode;
	//TODO !!! these seem not be be called anymore...

- (void)addAttribute:(NSString *)attributeName value:(NSString *)value;

- (void)replaceAttributes:(NSArray *)attributesArray;

- (BOOL)hasAttribute:(NSString *)attributeName;

- (BOOL)attributeNameAndValue:(XTPair *)attrNameAndValue
					  hasName:(NSString *)name;

- (BOOL)attributeNameAndValue:(XTPair *)attrNameAndValue
					  hasName:(NSString *)name
	 withCaseInsensitiveValue:(NSString *)value;

- (BOOL)attributeNameAndValue:(XTPair *)attrNameAndValue
					  hasName:(NSString *)name
	   withCaseSensitiveValue:(NSString *)value;

- (BOOL)hasAttribute:(NSString *)attributeName withCaseInsensitiveValue:(NSString *)value;
	//TODO use whenever appr

- (NSString *)attributeAsString:(NSString *)attributeName;

- (BOOL)attribute:(NSString *)attributeName asOptionalSign:(NSInteger*)sign andUint:(NSUInteger*)uint;

- (NSUInteger)attributeAsUInt:(NSString *)attributeName;

- (NSNumber *)attributeAsNumber:(NSString *)attributeName;

- (NSNumber *)attributeAsNumberWithOptionalSuffix:(NSString *)attributeName;

- (NSNumber *)attributeAsPercentage:(NSString *)attributeName;

//- (NSInteger)attributeAsInt:(NSString *)attributeName;

- (NSArray *)attributeAsCommaSeparatedStrings:(NSString *)attributeName;

- (BOOL)isStandalone;

- (BOOL)needsBlockLevelSpacingBefore;

- (BOOL)needsBlockLevelSpacingAfter;

- (NSUInteger)getListNestingLevel;

//TODO !!! make general "indent nesting level"?
- (NSUInteger)getBlockquoteNestingLevel;

- (BOOL)isForT2;

- (BOOL)isForT3;

- (BOOL)isSameClassAs:(XTHtmlTag *)other;

- (NSString *)debugString;

- (NSUInteger)recursivelyCountChildren;

@end
