//
//  XTHtmlTagPre.m
//  TadsTerp
//
//  Created by Rune Berg on 31/08/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagPre.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagPre

+ (NSString *)name
{
	return @"pre";
}

+ (BOOL)standalone
{
	return NO;
}

- (BOOL)blockLevel
{
	return YES;
}

- (BOOL)blockLevelSpacingBefore
{
	return YES;
}

- (BOOL)blockLevelSpacingAfter
{
	return YES;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	[super format:formatter textHandler:textHandler];
	
	NSArray *formattedElements = [formatter handleHtmlTagPreOpen:self];
	[textHandler receiveFormattedElements:formattedElements];
}

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagPreClose];
	[textHandler receiveFormattedElements:formattedElements];
	
	[super formatExit:formatter textHandler:textHandler];
}

@end
