//
//  XTBannerBorderView.m
//  XTads
//
//  Created by Rune Berg on 20/05/16.
//  Copyright © 2016 Rune Berg. All rights reserved.
//

#import "XTBannerBorderView.h"
#import "XTLogger.h"
#import "XTAllocDeallocCounter.h"


@implementation XTBannerBorderView

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTBannerBorderView class]];
}

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (instancetype)initWithFrame:(NSRect)frameRect
{
	//XT_DEF_SELNAME;
	//XT_TRACE_0(@"");
	
	XTBannerBorderView *view = [super initWithFrame:frameRect];
	if (view != nil) {
		
		NSAutoresizingMaskOptions newAMO = NSViewHeightSizable | NSViewWidthSizable;
		[self setAutoresizingMask:newAMO];
		
		[self setTranslatesAutoresizingMaskIntoConstraints:NO];
	}
	return view;
}

- (void)drawRect:(NSRect)dirtyRect
{
	[super drawRect:dirtyRect];
	
	if (self.backgroundColor != nil) {
		[self.backgroundColor set];
		NSRectFill([self bounds]);
	}
}

@end
